@php
    $organizer = $event->organizer;
    $eventMetaDisplay = json_decode(theme_option('event_detail_meta_display', []), true);
    $shouldDisplayDateTime = in_array('date_time', $eventMetaDisplay);
    $shouldDisplayOrganizerName = in_array('organizer_name', $eventMetaDisplay);
    $shouldDisplayOrganizerTitle = in_array('organizer_title', $eventMetaDisplay);
    $shouldDisplayOrganizerImage = in_array('organizer_image', $eventMetaDisplay);
    $shouldDisplayAddress = in_array('address', $eventMetaDisplay);
    $isFullSlots = $event->booked_seats >= $event->seats;
    $isClosedBooking = $event->booking_closed_at && \Carbon\Carbon::now()->greaterThan($event->booking_closed_at);
@endphp
<div class="shedule-listarea">
    <div class="card">
        <div class="head">
            {{ __('Event Information') }}
        </div>
        <ul style="border-radius: 0">
            @if ($organizer = $event->organizer)
                <li class="border-0">
                    {{ __('Organizer') }} : <span>{{ $organizer->name }}</span>
                </li>
            @endif

            @if ($address = $event->address)
                <li class="border-0">
                    {{ __('Address') }} : <span>{{ $address }}</span>
                </li>
            @endif

            <li class="border-0">
                {{ __('Start date') }} : <span>{{ $event->started_at }}</span>
            </li>

            @if($endedAt = $event->ended_at)
                <li class="border-0">
                    {{ __('End date') }} : <span>{{ $endedAt }}</span>
                </li>
            @endif

            @if ($bookingClosedAt = $event->booking_closed_at)
                <li class="border-0">
                    {{ __('Booking closed date') }} : <span @class(['text-danger' => $isClosedBooking])>{{ $event->booking_closed_at }}</span>
                </li>
            @endif

            <li class="border-0">
                {{ __('Price') }} : <span>{{ __(':price / Ticket', ['price' => format_price($event->price)]) }}</span>
            </li>

            <li
                class="border-0"
                style="border: none"
            >
                {{ __('Slots') }} : <span>{{ $event->booked_seats }}</span> /
                <span>{{ $event->seats }}</span>

                @if ($isFullSlots)
                    <span>( {{ __('Full') }} )</span>
                @endif
            </li>
        </ul>
        <form
            action="{{ route('public.booking') }}"
            method="POST"
        >
            @csrf

            <input
                type="hidden"
                name="event_id"
                value="{{ $event->getkey() }}"
            >
            <div class="form-group mb-3">
                <label
                    class="form-label"
                    for="events-booking-number-slots"
                >{{ __('Number Slots') }}</label>
                <input
                    id="events-booking-number-slots"
                    class="form-control"
                    type="number"
                    name="number_slots"
                    value="1"
                    @disabled($isFullSlots || $isClosedBooking)
                >
            </div>

            <button
                type="submit"
                class="vl-btn1"
                @disabled($isFullSlots || $isClosedBooking)
            >
                {{ __('Book Now') }}
            </button>
        </form>
    </div>

    @if ($address = $event->address)
        <div class="space30"></div>
        <div class="mapouter">
            <div class="gmap_canvas">
                <iframe
                    src="https://maps.google.com/maps?q={{ addslashes($address) }}&t=&z=13&ie=UTF8&iwloc=&output=embed"
                    width="600"
                    height="450"
                    style="border: 0"
                    allowfullscreen=""
                    loading="lazy"
                    referrerpolicy="no-referrer-when-downgrade"
                ></iframe>
            </div>
        </div>
    @endif
</div>
