@php
    $style = [];
    $bgColor = theme_option('header_background_color', '#313131');
    $textColor = theme_option('header_text_color', '#ffffff');
    $isTransparent = theme_option('is_header_transparent', false) && Theme::get('isHomepage');

    if ($textColor) {
        $style["--header-text-color: $textColor"] = $textColor;
    }

    if ($bgColor !== 'transparent') {
        $style["--header-background-color: $bgColor"] = $bgColor;
    }

    $announcementDisplayHtml = apply_filters('announcement_display_html');
    $bgColor = theme_option('header_top_background_color');
    $textColor = theme_option('header_top_text_color');
@endphp

{!! apply_filters('ads_render', null, 'header_before', ['class' => 'mb-2']) !!}

<div class="announcement-mobile"
    @style([
        "--header-top-background-color: $bgColor" => $bgColor,
        "--header-top-text-color: $textColor" => $textColor,
    ])
>{!! $announcementDisplayHtml !!}</div>
<header class="header-no-sticky">
    @if (theme_option('display_header_top', false))
        {!! Theme::partial('header.header-top', ['headerWrapperClass' => 'home-main']) !!}
    @endif

    <div
        @class([
            'header-area homepage1 header header-sticky d-none d-lg-block',
            'no-transparent' => !$isTransparent,
        ])
        id="header"
        @style($style)
    >
        {!! Theme::partial('header.content') !!}
    </div>
</header>

{!! apply_filters('ads_render', null, 'header_after', ['class' => 'mt-2']) !!}

{!! Theme::partial('header.mobile') !!}
