@if (is_plugin_active('events-booking'))
    @php
        $auth = auth('account');
    @endphp

    <div class="widget-search-action-button btn-login pe-2">
        @if (! $auth->check())
            <a href="{{ route('account.login') }}">
                <x-core::icon name="ti ti-user" />
                <span>{{ __('Login') }}</span>
            </a>
        @else
            @php $account = $auth->user(); @endphp

            <div class="dropdown dropdown-login">
                <a href="#" class="btn-login neutral-1000 dropdown-toggle" id="shareDropdown" data-bs-toggle="dropdown" data-bs-auto-close="outside">
                    <div class="wrapper-avatar-ratio">
                        <div class="wrapper-avatar">
                            {{ RvMedia::image($account->avatar_url, $account->name, 'thumb', attributes: ['class' => 'avatar']) }}
                        </div>
                    </div>
                    <span class="user-name d-none d-sm-inline text-truncate">{{ $account->name }}</span>
                </a>

                <ul class="dropdown-menu" aria-labelledby="shareDropdown">
                    <li>
                        <a
                            href="{{ route('account.orders') }}"
                            class="dropdown-item"
                        >
                            <span>{{ __('Orders') }}</span>
                        </a>
                    </li>
                        <li>
                            <a
                                href="{{ route('account.edit-account') }}"
                                class="dropdown-item"
                            >
                                <span>{{ __('Profile') }}</span>
                            </a>
                        </li>
                        <li>
                            <a
                                href="{{ route('account.change-password') }}"
                                class="dropdown-item"
                            >
                                <span>{{ __('Change Password') }}</span>
                            </a>
                        </li>
                    <li>
                        <a
                            href="{{ route('account.logout') }}"
                            class="dropdown-item"
                        >
                            <span>{{ __('Logout') }}</span>
                        </a>
                    </li>
                </ul>
            </div>
        @endif
    </div>
@endif
