<div
    class="about4-section-area sp1 shortcode-about-information shortcode-about-information-style-5" @style($variablesStyle)>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="about-images">
                    <div class="row">
                        <div class="col-lg-6 col-md-6">
                            @if($image = $shortcode->image)
                                <div class="img1 image-anime reveal">
                                    {{ RvMedia::image($image, '','large') }}
                                </div>
                            @endif
                            <div class="space30"></div>
                            <div class="content-box">
                                @if($description = $shortcode->description)
                                    <p>{{ $description }}</p>
                                @endif
                                <div class="space12"></div>
                                @if($event)
                                    <h6>{{ $event->name }}</h6>
                                    <div class="space6"></div>
                                    <ul>
                                        @if($event->started_at && $event->ended_at)
                                            <li>
                                        <span>
                                            @if($timeImage = theme_option('event_list_widget_date_icon_image'))
                                                {{ RvMedia::image($timeImage, '', 'thumbnail', attributes: ['style' => 'width: 20px']) }}
                                            @endif
                                            {{ $event->started_at?->format('g:i A') }} - {{ $event->ended_at?->format('g:i A') }}
                                        </span>
                                            </li>
                                        @endif
                                        @if($address = $event->address)
                                            <li>
                                        <span>
                                            @if($locationImage = theme_option('event_location_image'))
                                                {{ RvMedia::image($locationImage, '', 'thumbnail', attributes: ['style' => 'width: 20px']) }}
                                            @endif
                                            {{ $address }}
                                        </span>
                                            </li>
                                        @endif
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <div class="col-lg-6 col-md-6">
                            <div class="space44"></div>
                            @if($image1 = $shortcode->image_1)
                                <div class="img1 image-anime reveal">
                                    {{ RvMedia::image($image1, '','large') }}
                                </div>
                            @endif
                            <div class="space30"></div>
                            @if($image2 = $shortcode->image_2)
                                <div class="img1 image-anime reveal">
                                    {{ RvMedia::image($image2, '','large') }}
                                </div>
                            @endif
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="about4-heading heading6">
                    @if($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">{{ BaseHelper::clean($subtitle) }}</h5>
                    @endif
                    <div class="space18"></div>
                    @if($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{{ BaseHelper::clean($title) }}</h2>
                    @endif
                    <div class="space16"></div>
                    @if($description = $shortcode->description)
                        <p data-aos="fade-left" data-aos-duration="900">{{ BaseHelper::clean($description) }}</p>
                    @endif
                    <div class="space10"></div>
                    <ul data-aos="fade-left" data-aos-duration="1000">
                        @foreach($tabs as $tab)
                            @continue(!$tab['title'])
                            <li>
                                @if ($icon = Arr::get($tab, 'icon_image'))
                                    {{ RvMedia::image($icon, '','small', attributes: ['style' => 'width: 20px']) }}
                                @endif
                                {{ BaseHelper::clean($tab['title']) }}
                            </li>
                        @endforeach
                    </ul>
                    <div class="space32"></div>
                    <div class="btn-area1" data-aos="fade-left" data-aos-duration="1200">
                        @if($buttonUrl = $shortcode->button_url && $buttonLabel = $shortcode->button_label)
                            <a href="{{ $buttonUrl }}" class="vl-btn4">{{ BaseHelper::clean($buttonLabel) }}</a>
                        @elseif($buttonLabel = $shortcode->button_label)
                            <span class="vl-btn4">{{ BaseHelper::clean($buttonLabel) }}</span>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
