@php
    $durationPattern = [800, 1000, 1200];
    $postMetaData = json_decode(theme_option('blog_post_meta_display', []), true);
    $shouldDisplayDateTime = in_array('published_date', $postMetaData);
    $shouldDisplayAuthor = in_array('author_name', $postMetaData);
    $shouldDisplayView = in_array('view_count', $postMetaData);
@endphp

<div class="blog4-section-area shortcode-blog-posts shortcode-blog-posts-2 sp2" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="blog-header heading6 text-center space-margin60">
                    @if ($subTitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subTitle) !!}</h5>
                    @endif
                    <div class="space18"></div>
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            @foreach ($posts as $key => $post)
                @php
                    $aosDuration = $durationPattern[$key % count($durationPattern)];
                @endphp
                <div class="col-lg-4 col-md-6" data-aos="zoom-in" data-aos-duration="{{ $aosDuration }}">
                    <div class="blog4-boxarea">
                        <div class="img1">
                            {{ RvMedia::image($post->image, $post->name, 'medium-rectangle-vertical') }}
                        </div>
                        <div class="content-area">
                            <ul>
                                @if (($publishedDate = $post->created_at) && $shouldDisplayDateTime)
                                    <li>
                                    <span>
                                        @if ($calenderIcon = theme_option('calender_icon_image'))
                                            {{ RvMedia::image($calenderIcon, 'calender icon', attributes: ['style' => 'width: 20px']) }}
                                        @endif
                                        {{ $publishedDate->format('d M Y') }} <span class="symbol-slash"> | </span>
                                    </span>
                                    </li>
                                @endif
                                @if (($author = $post->author) && $shouldDisplayAuthor)
                                    @php
                                        $fullName = $author->first_name . ' ' . $author->last_name;
                                    @endphp
                                    <li>
                                        <span>
                                            @if ($authorIcon = theme_option('author_icon_image'))
                                                {{ RvMedia::image($authorIcon, 'author icon') }}
                                            @endif
                                            {!! BaseHelper::clean($fullName) !!}
                                            <span class="symbol-slash"> | </span>
                                        </span>
                                    </li>
                                @endif
                                @if (($views = $post->views) && $shouldDisplayView)
                                    <li>
                                    <span>
                                        @if ($viewIcon = theme_option('views_icon_image'))
                                            {{ RvMedia::image($viewIcon, 'view icon') }}
                                        @endif
                                        {!! BaseHelper::clean($views) !!}
                                        <span class="symbol-slash"> | </span>
                                    </span>

                                    </li>
                                @endif
                            </ul>
                            <div class="space20"></div>
                            @if ($name = $post->name)
                                <a
                                    aria-label="{{ $name }}"
                                    class="truncate-2-custom"
                                    title="{{ $name }}"
                                    href="{{ $post->url }}"
                                    title="{{ $name }}"
                                >{{ $name }}</a>
                            @endif
                            <div class="space24"></div>
                            <a aria-label="{{ __('Read more') }}" href="{{ $post->url }}" class="readmore">
                                {{ __('Read now') }} <x-core::icon name="ti ti-arrow-right"/>
                            </a>
                            <div class="arrow">
                                <a aria-label="{{ $post->name }}" href="{{ $post->url }}"><x-core::icon name="ti ti-arrow-right"/></a>
                            </div>
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
