<div class="shortcode-brand-style2 shortcode-brands shortcode-brands-style-2 brands1-section-area sp2"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="brand-header heading2 space-margin60 text-center">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'icon', attributes: ['class' => 'subtitle-img']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            @foreach ($brands as $key => $brand)
                @continue(!($image = Arr::get($brand, 'image')))
                @php
                    $durationPattern = [800, 900, 1000, 1100];
                    $aosDuration = $durationPattern[$key % count($durationPattern)];
                @endphp
                <div
                    class="col-lg-3 col-md-6"
                    data-aos="zoom-in"
                    data-aos-duration="{{ $aosDuration }}"
                >

                    <div class="brand-box">
                        @if ($link = Arr::get($brand, 'link'))
                            <a
                                href="{{ $link }}"
                                target="blank"
                            >
                                {{ RvMedia::image($image, Arr::get($brand, 'alt')) }}
                            </a>
                        @else
                            {{ RvMedia::image($image, Arr::get($brand, 'alt')) }}
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
