<div class="contact10-bg-section shortcode-contact-information-style-5" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="space48"></div>
                <div class="row">
                    @foreach ($contactMethod as $key => $method)
                        @continue(!($title = Arr::get($method, 'title')))

                        @if ($key == 0 || $key == 2)
                            <div class="col-lg-6 col-md-6">
                        @endif
                        <div
                            class="contact-boxarea aos-init aos-animate"
                            data-aos="zoom-in"
                            data-aos-duration="900"
                        >
                            <div class="icons contact-icon-bg">
                                @if ($iconImage = Arr::get($method, 'icon_image'))
                                    {{ RvMedia::image($iconImage, 'icon') }}
                                @endif
                            </div>
                            <div class="text">
                                <h5>{!! BaseHelper::clean($title) !!}</h5>
                                <div class="space14"></div>
                                @if ($description = Arr::get($method, 'description'))
                                    @if ($url = Arr::get($method, 'url'))
                                        <a aria-label="{{ $title }}" href='{{ $url }}'>{!! BaseHelper::clean($description) !!}</a>
                                    @else
                                        <span>{!! BaseHelper::clean($description) !!}</span>
                                    @endif
                                @endif
                            </div>
                        </div>
                        <div class="space18"></div>
                        @if ($key == 1 || $key == 3)
                            </div>
                        @endif
                    @endforeach
                </div>
                <div class="space48"></div>
            </div>
        </div>
    </div>
    @if ($address = $shortcode->address)
        <div class="mapouter">
            <div class="gmap_canvas">
                <iframe title="{{ $address }}" src="https://maps.google.com/maps?q={{ addslashes($address) }}&t=&z=13&ie=UTF8&iwloc=&output=embed" width="600" height="450" style="border: 0" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    @endif

</div>
