@if($startDate = $shortcode->start_date)
    <div
        class="shortcode-countdown shortcode-countdown-style-1 others-timer-area sp2 d-lg-block d-none" @style($variablesStyle)>
        <div class="container">
            @if($title || $subtitle)
                <div class="row">
                    <div class="col-lg-9 m-auto">
                        <div class="heading8 text-center space-margin80">
                            @if($subtitle)
                                <h5>
                                    @if($subtitleImage = $shortcode->subtitle_image)
                                        {{ RvMedia::image($subtitleImage, '') }}
                                    @endif
                                    {!! BaseHelper::clean($subtitle) !!}
                                </h5>
                            @endif

                            @if ($title)
                                <div class="space32"></div>
                                <h2>{!! BaseHelper::clean($title) !!}</h2>
                            @endif
                        </div>
                    </div>
                </div>
            @endif

            <div class="row">
                <div class="col-lg-12">
                    <div class="timer timer-single"
                         data-target="{{ \Carbon\Carbon::make($startDate)->format('m-d-Y h:m:i') }}">
                        <div class="row">
                            <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="900">
                                <div class="time-box">
                                    <span class="time-value days"></span>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="1000">
                                <div class="time-box">
                                    <span class="time-value hours"></span>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="1100">
                                <div class="time-box">
                                    <span class="time-value minutes"></span>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6" data-aos="zoom-in" data-aos-duration="1200">
                                <div class="time-box">
                                    <span class="time-value seconds"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            @if(($primaryButtonLabel && $primaryButtonUrl) || ($secondaryButtonLabel && $secondaryButtonUrl))
                <div class="row">
                    <div class="col-lg-12 m-auto">
                        <div class="space60"></div>
                        <div class="btn-area1 text-center">
                            @if($primaryButtonLabel && $primaryButtonUrl)
                                <a href="{{ $primaryButtonUrl }}" class="vl-btn5">
                                    <span class="demo">{!! BaseHelper::clean($primaryButtonLabel) !!}</span>
                                    <span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span>
                                </a>
                            @endif

                            @if($secondaryButtonLabel && $secondaryButtonUrl)
                                <a href="{{ $secondaryButtonUrl }}" class="vl-btn5 btn2">
                                    <span class="demo">{!! BaseHelper::clean($secondaryButtonLabel) !!}</span>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
@endif
