<div class="shortcode-events-schedule shortcode-events-schedule-style-2 event2-section-area sp1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="event2-header heading4 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif

                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12" data-aos="fade-up" data-aos-duration="1000">
                @if($tabs)
                    <div class="tabs-button space-margin60">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            @foreach($tabs as $item)
                                <li class="nav-item" role="presentation">
                                    <button
                                        data-bb-toggle="events-schedule"
                                        data-date="{{ Arr::get($item, 'date') }}"
                                        @class(['nav-link', 'active' => $loop->first]) data-bs-toggle="pill" type="button" role="tab" aria-selected="true">
                                        <span class="calender"><img src="{{ Theme::asset()->url('images/icons/calender.svg') }}" alt="icon" /></span>

                                        <span class="pl-8">
											<span class="day">{{ __('Day :number', ['number' => $loop->index + 1]) }}</span>
											<span class="date">{{ Arr::get($item, 'month') }} {{ Arr::get($item, 'day') }}, {{ Arr::get($item, 'year') }}</span>
										</span>
                                    </button>
                                </li>
                            @endforeach
                        </ul>
                    </div>
                @endif

                <div class="tab-content" id="pills-tabContent">
                    <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab" tabindex="0">
                        <div class="event-widget-area">
                            @php
                                $events->loadMissing('speakers');
                            @endphp

                            @foreach($events as $event)
                                @php
                                    $speakers = $event->speakers->take(2);
                                @endphp

                                <div class="row"
                                     data-bb-value="events-schedule"
                                     data-date="{{ $event->started_at?->format('Y-m-d') }}"
                                >
                                    <div class="col-lg-9 m-auto">
                                        <div class="event2-boxarea box1">
                                            <h1 class="ordinal-number">{{ $loop->index + 1 }}</h1>
                                            <div class="row align-items-center">
                                                <div class="col-lg-5">
                                                    <div class="img1">
                                                        {{ RvMedia::image($event->image, $event->name, 'small-rectangle') }}
                                                    </div>
                                                </div>
                                                <div class="col-lg-7">
                                                    <div class="content-area">
                                                        <ul>
                                                            <li>
                                                                <a href="{{ $event->url }}"><img src="{{ Theme::asset()->url('images/icons/clock.svg') }}" alt="" />{{ $event->started_at?->format('H:i') }} - {{ $event->ended_at?->format('H:i') }} <span> | </span></a>
                                                            </li>
                                                            <li>
                                                                <a href="{{ $event->url }}"><img src="{{ Theme::asset()->url('images/icons/location.svg') }}" alt="" />{{ $event->address }}</a>
                                                            </li>
                                                        </ul>
                                                        <div class="space20"></div>
                                                        <a href="{{ $event->url }}" class="head">{{ $event->name }}</a>
                                                        @if($speakers->isNotEmpty())
                                                            <div class="space24"></div>
                                                            <div class="author-area">
                                                                @foreach($speakers as $speaker)
                                                                    <div class="autho-name-area">
                                                                        <div class="img1">
                                                                            {{ RvMedia::image($speaker->avatar, $speaker->name, 'thumb') }}
                                                                        </div>
                                                                        <div class="text">
                                                                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                                                                            @if ($speakerTitle = $speaker->getMetaData('title', true))
                                                                                <div class="space8"></div>
                                                                                <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                @endforeach
                                                            </div>
                                                            <div class="space24"></div>
                                                        @endif
                                                        <div class="btn-area1">
                                                            <a href="{{ $event->url }}" class="vl-btn2"
                                                            ><span class="demo">{{ __('purchase ticket now') }}</span><span class="arrow"><x-core::icon name="ti ti-arrow-right"/></span
                                                                ></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="space30"></div>
                                </div>

                            @endforeach
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
