<div class="event6-section-area sp1 shortcode-events shortcode-events-style-5" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="event-heading heading9 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'icon',attributes: ['class' => 'subtitle-img']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        @if ($events->isNotEmpty())
            <div class="row">
                <div class="col-lg-12">
                    @php
                        $styleClassArr = [null, 2, 3];
                    @endphp
                    @foreach($events as $event)
                        <div class="event6-widget-boxarea{{ $styleClassArr[rand(0, 2)] }}"
                             data-aos="{{ $loop->even ? 'fade-left' : 'fade-right' }}"
                             data-aos-duration="{{ 1000 + ($loop->index * 100) }}">
                            <div class="row align-items-center">
                                <div class="col-lg-7">
                                    <div class="img1 image-anime reveal">
                                        {{ RvMedia::image($event->image, $event->name, 'medium') }}
                                    </div>
                                </div>
                                <div class="col-lg-5">
                                    <div class="content-area">
                                        <h3 class="text-anime-style-3 truncate-3-custom">“{{ $event->name }}”</h3>
                                        <div class="space24"></div>
                                        <ul>
                                            <li>
                                                <a href="#">
                                                    <img src="{{ Theme::asset()->url('images/icons/clock.svg') }}"
                                                         alt="" />
                                                    {{ $event->started_at?->format('H:i') }}
                                                    - {{ $event->ended_at?->format('H:i') }}
                                                </a>
                                            </li>
                                            <li class="space14"></li>
                                            <li>
                                                <a href="#">
                                                    <img src="{{ Theme::asset()->url('images/icons/location.svg') }}"
                                                         alt="" />
                                                    {{ $event->address }}
                                                </a>
                                            </li>
                                        </ul>
                                        <div class="space32"></div>
                                        <div class="btn-area1">
                                            <a aria-label="{{ $event->name }}" href="{{ $event->url }}" class="vl-btn6">
                                                {{ __('Buy Tickets Now ') }}
                                                <img src="{{ Theme::asset()->url('images/icons/arrow2.svg') }}"
                                                     alt="" />
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        @if (! $loop->last)
                            <div class="space50"></div>
                        @endif
                    @endforeach
                </div>
            </div>
        @endif
    </div>
</div>
