@php
    $cards = Shortcode::fields()->getTabsData(['title', 'description', 'url', 'icon_image'], $shortcode);
@endphp
<div class="choose-section-area sp2 featured-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-4 m-auto">
                <div class="heading2 text-center space-margin60">
                    @if($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                        <div class="space18"></div>
                    @endif

                    @if($title = $shortcode->title)
                        <h2>{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            @foreach($cards as $card)
                @php
                    $url = Arr::get($card, 'url');
                @endphp

                @continue(! ($title = Arr::get($card, 'title')))
                <div class="col-lg-4 col-md-6">
                    <div class="choose-widget-boxarea">
                        @if($iconImage = Arr::get($card, 'icon_image'))
                            <div class="icons">
                                {{ RvMedia::image($iconImage, 'icon') }}
                            </div>
                        @endif
                        <div class="space24"></div>
                        <div class="content-area">
                            <a href="{{ $url }}">{!! BaseHelper::clean($title) !!}</a>
                            <div class="space16"></div>

                            @if ($description = Arr::get($card, 'description'))
                                <p>{!! BaseHelper::clean($description) !!}</p>
                                <div class="space24"></div>
                            @endif

                            @if ($url)
                                <a href="{{$url}}" class="readmore">{{__("Read More")}}
                                    <x-core::icon name="ti ti-arrow-right"/>
                                </a>
                            @endif
                        </div>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
