@php
    $featuredBlock = $tabs[0];
    $tabs = array_slice($tabs, 1);
@endphp
<div class="attent10-section-area sp3">
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="heading13 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            <img src="{{ url('/storage/homepage10/general/logo2.png') }}" alt="" />
                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space20"></div>
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-lg-12">
                <div class="event6-widget-boxarea" data-aos="fade-left" data-aos-duration="1000">
                    <div class="row align-items-center">
                        <div class="col-lg-5">
                            <div class="content-area">
                                @if($title = Arr::get($featuredBlock, 'title'))
                                    <h3 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h3>
                                @endif
                                <div class="space16"></div>
                                @if($description = Arr::get($featuredBlock, 'description'))
                                    <p>{!! BaseHelper::clean($description) !!}</p>
                                @endif
                                <div class="space32"></div>
                                <div class="btn-area1">
                                    @if ($buttonUrl = Arr::get($featuredBlock, 'url'))
                                    <a href="{{ $buttonUrl }}" class="vl-btn10">{{ __('See Eventify') }} 
                                        <img src="{{ Theme::asset()->url('images/icons/arrow3.svg') }}" alt="" />
                                    </a>
                                    @endif
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-1"></div>
                        @if($image = Arr::get($featuredBlock, 'icon_image'))
                            <div class="col-lg-6">
                                <div class="img1 image-anime reveal">
                                    {{ RvMedia::image($image, 'image') }}
                                </div>
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
        <div class="space30"></div>
        <div class="row">
            @foreach($tabs as $key => $tab)
                @php
                    $url = Arr::get($tab, 'url');
                    $title = Arr::get($tab, 'title');
                    $img = Arr::get($tab, 'icon_image');
                @endphp

                @continue(! $title)

                <div class="col-lg-4 col-md-6">
                    <div class="schedule-boxarea">
                        <h4>{{ $title }}</h4>
                        <div class="space40"></div>
                        <div class="images{{$key == 0 ? '' : 2}}">
                            {{ RvMedia::image($img, '', null, true, ['class' => 'elements37']) }}
                            {{ RvMedia::image($img, '', null, true, ['class' => 'elements38']) }}
                            {{ RvMedia::image($img, '', null, true, ['class' => 'elements39']) }}
                        </div>
                    </div>
                </div>                
            @endforeach
        </div>
    </div>
</div>
