<div class="shortcode-hero-banner shortcode-hero-banner-style-1 hero1-section-area">
    @if($backgroundImage = $shortcode->background_image)
        <div class="bg1">
            {{ RvMedia::image($backgroundImage, 'bg', attributes: ['class' => 'header-bg1']) }}
        </div>
    @endif

    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="hero1-header heading1">
                    @if($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">
                            {{ RvMedia::image(theme_option('favicon'), theme_option('site_title'), attributes: ['width' => 16, 'height' => 16, 'class' => 'white-image']) }}
                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space16"></div>
                    @if($title = $shortcode->title)
                        <h1 class="text-anime-style-3">
                            {!! BaseHelper::clean($title) !!}
                        </h1>
                    @endif

                    <div class="space16"></div>

                    @if ($description = $shortcode->description)
                        <p data-aos="fade-left" data-aos-duration="900">
                            {!! BaseHelper::clean($description) !!}
                        </p>
                    @endif

                    <div class="space32"></div>
                    <div class="btn-area1" data-aos="fade-left" data-aos-duration="1100">
                        @if(($buttonPrimaryLabel = $shortcode->button_primary_label) && ($buttonPrimaryUrl = $shortcode->button_primary_url))
                            <a href="{{ $buttonPrimaryUrl }}"
                               class="vl-btn1">{!! BaseHelper::clean($buttonPrimaryLabel) !!}</a>
                        @endif

                        @if(($buttonSecondaryLabel = $shortcode->button_secondary_label) && ($buttonSecondaryUrl = $shortcode->button_secondary_url))
                            <a href="{{ $buttonSecondaryUrl }}"
                               class="vl-btn2">{!! BaseHelper::clean($buttonSecondaryLabel) !!}</a>
                        @endif

                    </div>
                </div>
            </div>
            <div class="col-lg-5">
                <div class="header-images">
                    @if($image = $shortcode->image)
                        <div class="img1" data-aos="zoom-in" data-aos-duration="1000">
                            {{ RvMedia::image($image, 'hero') }}
                        </div>
                    @endif

                    @if($event)
                        <div class="images-content-area" data-aos="fade-up" data-aos-duration="900">
                            <h3>{{ $event->name }}</h3>
                            <div class="space12"></div>
                            <a href="{{ $event->url }}">{{ $event->started_at?->format('F j, Y') }}</a>
                            <div class="space12"></div>
                            <a href="{{ $event->url }}">{{ $event->address }}</a>
                            <div class="space16"></div>

                            @if($eventDescription = $event->description)
                                <p>{!! BaseHelper::clean($eventDescription) !!}</p>
                            @endif
                        </div>
                    @endif

                </div>
            </div>

            @if ($event)
                <div class="col-lg-1">
                    <div class="timer" data-aos="fade-left" data-aos-duration="1000"
                         data-target="{{ $event->started_at }}">
                        <div class="time-box">
                            <span class="time-value days"></span>
                            <div class="space8"></div>
                        </div>
                        <div class="space14"></div>
                        <div class="time-box">
                            <span class="time-value hours"></span>
                            <div class="space8"></div>
                        </div>
                        <div class="space14"></div>
                        <div class="time-box">
                            <span class="time-value minutes"></span>
                            <div class="space8"></div>
                        </div>
                        <div class="space14"></div>
                        <div class="time-box" style="margin: 0">
                            <span class="time-value seconds"></span>
                            <div class="space8"></div>
                        </div>
                    </div>
                </div>
            @endif
        </div>
    </div>
</div>
