<div class="shortcode-hero-banner shortcode-hero-banner-style-2 hero3-section-area"
    @style($variablesStyle)
>
    <img src="{{ Theme::asset()->url('images/shapes/elements18.png') }}" alt="" class="elements18" />
    <img src="{{ Theme::asset()->url('images/shapes/elements9.png') }}" alt="" class="elements9" />
    <div class="container">
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="hero3-header text-center">
                    @if($subtitle = $shortcode->subtitle)
                        <h5>
                            {{ RvMedia::image(theme_option('favicon'), theme_option('site_title'), attributes: ['width' => 16, 'height' => 16, 'class' => 'white-image']) }}
                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space32"></div>
                    @if($title = $shortcode->title)
                        <h1 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h1>
                    @endif

                    <div class="space40"></div>
                    <div class="btn-area1">
                        @if(($buttonUrl = $shortcode->button_primary_url) && ($buttonLabel = $shortcode->button_primary_label))
                            <a href="{{ $buttonUrl }}" class="vl-btn3">{!! BaseHelper::clean($buttonLabel) !!}</a>
                        @endif

                        @if($event)
                            <a href="{{ $event->url }}" class="vl-btn3 btn2">{{ __('Buy ticket now') }}</a>
                        @endif
                    </div>

                    @if($circleText = $shortcode->circle_text)
                        <div class="arrow-btnarea">
                            <a href="#">
                                <div class="content" bis_skin_checked="1">
                                    <h6 class="circle rotateme">{!! BaseHelper::clean($circleText) !!}</h6>
                                </div>
                                <img src="{{ Theme::asset()->url('images/icons/arrow.svg') }}" alt="" class="arrow1" />
                            </a>
                        </div>
                    @endif

                    @if ($event)
                        <div class="date-btn aniamtion-key-1">
                            <h4>{{ $event->started_at?->format('d') }}</h4>
                            <div class="space14"></div>
                            <p>{{ $event->started_at?->format('M') }}</p>
                            <div class="space20"></div>
                            <a href="{{ $event->url }}"> {{ __('Buy Ticket') }} </a>
                        </div>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
