<div class="hero6-section-area shortcode-hero-banner shortcode-hero-banner-style-5"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row align-items-center">
            <div class="col-lg-7">
                <div class="hero6-header">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, '', 'thumbnail', attributes: ['class' => 'd-md-inline-block d-none']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space24"></div>
                        <h1 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h1>
                    @endif

                    @if (($buttonPrimaryLabel = $shortcode->button_primary_label) && ($buttonPrimaryUrl = $shortcode->button_primary_url))
                        <div class="space24"></div>
                        <div class="btn-area1">
                            <a href="{{ $buttonPrimaryUrl }}"
                               class="vl-btn6">{!! BaseHelper::clean($buttonPrimaryLabel) !!}
                                <img src="{{ Theme::asset()->url('images/icons/arrow2.svg') }}" alt="" />
                            </a>
                        </div>
                    @endif

                    @if($circleText = $shortcode->circle_text)
                        <div class="circle-wrapper">
                            <div class="content" bis_skin_checked="1">
                                <h6 class="circle rotateme">{!! BaseHelper::clean($circleText) !!}</h6>
                            </div>
                            <img src="{{ Theme::asset()->url('images/icons/arrow1.svg') }}" alt="" class="arrow1" />

                        </div>
                    @endif
                </div>
            </div>
            <div class="col-lg-5">
                <div class="img1">
                    @if ($image = $shortcode->image)
                        {{ RvMedia::image($image, 'banner-image') }}
                    @endif


                    @if ($event)
                        <a aria-label="{{ $event->name }}" href="{{ $event->url }}">
                            <div class="date-format">
                                <img src="{{ Theme::asset()->url('images/shapes/elements35.png') }}" alt=""
                                     class="keyframe5" />
                                <h5>{{ $event->started_at?->format('d') }}</h5>
                                <p>{{ $event->started_at?->format('M') }}</p>
                            </div>
                        </a>
                    @endif
                </div>
            </div>
        </div>
    </div>
</div>
