<div class="pricing-lan-section-area sp1 shortcode-pricing shortcode-pricing-style-1"
    @style($variablesStyle)
>
    <div class="container">
        <div class="row">
            <div class="col-lg-5 m-auto">
                <div class="heading2 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    <div class="space18"></div>

                    @if ($title = $shortcode->title)
                        <h2>{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            @foreach($tabs as $tab)
                @continue(! ($title = Arr::get($tab, 'name')))

                <div class="col-lg-4 col-md-6">
                    <div class="pricing-boxarea">
                        <h5>{!! BaseHelper::clean($title) !!}</h5>
                        <div class="space20"></div>
                        @if($price = Arr::get($tab, 'price'))
                            <h2>{!! BaseHelper::clean($price) !!}
                            @if ($unit = Arr::get($tab, 'unit'))
                                <span>/{!! BaseHelper::clean($unit) !!}</span>
                            @endif
                            </h2>
                        @endif

                        <div class="space8"></div>
                        <ul>
                            @foreach($features = Arr::get($tab, 'features')  as $feature)
                                @if($feature['is_available'])
                                    <li class="d-flex align-items-center mb-3">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="currentColor"  class="icon icon-tabler icons-tabler-filled icon-tabler-circle-check flex-shrink-0 text-success"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-1.293 5.953a1 1 0 0 0 -1.32 -.083l-.094 .083l-3.293 3.292l-1.293 -1.292l-.094 -.083a1 1 0 0 0 -1.403 1.403l.083 .094l2 2l.094 .083a1 1 0 0 0 1.226 0l.094 -.083l4 -4l.083 -.094a1 1 0 0 0 -.083 -1.32z" /></svg>
                                        <p title="{{ $feature['value'] }}" class="text-sm-medium m-0 ms-2 truncate-1-custom">{!! BaseHelper::clean($feature['value']) !!}</p>
                                    </li>
                                @else
                                    <li class="d-flex align-items-center mb-3">
                                        <svg  xmlns="http://www.w3.org/2000/svg"  width="24"  height="24"  viewBox="0 0 24 24"  fill="currentColor"  class="icon icon-tabler icons-tabler-filled icon-tabler-circle-x flex-shrink-0 text-danger"><path stroke="none" d="M0 0h24v24H0z" fill="none"/><path d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-6.489 5.8a1 1 0 0 0 -1.218 1.567l1.292 1.293l-1.292 1.293l-.083 .094a1 1 0 0 0 1.497 1.32l1.293 -1.292l1.293 1.292l.094 .083a1 1 0 0 0 1.32 -1.497l-1.292 -1.293l1.292 -1.293l.083 -.094a1 1 0 0 0 -1.497 -1.32l-1.293 1.292l-1.293 -1.292l-.094 -.083z" /></svg>
                                        <p title="{{ $feature['value'] }}" class="text-sm-medium m-0 ms-2 truncate-1-custom">{!! BaseHelper::clean($feature['value']) !!}</p>
                                    </li>
                                @endif
                            @endforeach
                        </ul>
                        <div class="space28"></div>

                        @if (($buttonUrl = Arr::get($tab, 'button_url')) && ($buttonLabel = Arr::get($tab, 'button_label')))
                            <div class="btn-area1">
                                <a href="{{ $buttonUrl }}" class="vl-btn1">{!! BaseHelper::clean($buttonLabel) !!}</a>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
