<div class="others-pricing-area2 sp2 shortcode-pricing shortcode-pricing-style-4" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="pricing-heading heading12 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>

        <div class="row">
            @foreach($tabs as $tab)
                @continue(! ($tabTitle = Arr::get($tab, 'name')))

                <div class="col-lg-4 col-md-6" data-aos="fade-right" data-aos-duration="1000">
                    <div @class(['pricing-boarea', 'box2' => Arr::get($tab, 'is_featured') === 'yes'])>
                        <h3>{!! BaseHelper::clean($tabTitle) !!}</h3>

                        @if ($tabDescription = Arr::get($tab, 'description'))
                            <div class="space16"></div>
                            <p>{!! BaseHelper::clean($tabDescription) !!}</p>
                        @endif

                        @if($price = Arr::get($tab, 'price'))
                            <div class="space32"></div>
                            <h2 class="text-white">{!! BaseHelper::clean($price) !!}
                                <span>/{!! BaseHelper::clean(Arr::get($tab, 'unit')) !!}</span></h2>
                            <div class="space8"></div>
                        @endif

                        <ul>
                            @foreach($features = Arr::get($tab, 'features')  as $feature)
                                @if($feature['is_available'])
                                    <li class="d-flex align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                             viewBox="0 0 24 24" fill="currentColor"
                                             class="icon icon-tabler icons-tabler-filled icon-tabler-circle-check flex-shrink-0 text-success">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-1.293 5.953a1 1 0 0 0 -1.32 -.083l-.094 .083l-3.293 3.292l-1.293 -1.292l-.094 -.083a1 1 0 0 0 -1.403 1.403l.083 .094l2 2l.094 .083a1 1 0 0 0 1.226 0l.094 -.083l4 -4l.083 -.094a1 1 0 0 0 -.083 -1.32z" />
                                        </svg>
                                        <p title="{{ $feature['value'] }}"
                                           class="text-sm-medium m-0 ms-2 truncate-1-custom">{!! BaseHelper::clean($feature['value']) !!}</p>
                                    </li>
                                @else
                                    <li class="d-flex align-items-center mb-3">
                                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24"
                                             viewBox="0 0 24 24" fill="currentColor"
                                             class="icon icon-tabler icons-tabler-filled icon-tabler-circle-x flex-shrink-0 text-danger">
                                            <path stroke="none" d="M0 0h24v24H0z" fill="none" />
                                            <path
                                                d="M17 3.34a10 10 0 1 1 -14.995 8.984l-.005 -.324l.005 -.324a10 10 0 0 1 14.995 -8.336zm-6.489 5.8a1 1 0 0 0 -1.218 1.567l1.292 1.293l-1.292 1.293l-.083 .094a1 1 0 0 0 1.497 1.32l1.293 -1.292l1.293 1.292l.094 .083a1 1 0 0 0 1.32 -1.497l-1.292 -1.293l1.292 -1.293l.083 -.094a1 1 0 0 0 -1.497 -1.32l-1.293 1.292l-1.293 -1.292l-.094 -.083z" />
                                        </svg>
                                        <p title="{{ $feature['value'] }}"
                                           class="text-sm-medium m-0 ms-2 truncate-1-custom">
                                            <s>{!! BaseHelper::clean($feature['value']) !!}</s></p>
                                    </li>
                                @endif
                            @endforeach
                        </ul>

                        @if (($buttonUrl = Arr::get($tab, 'button_url')) && ($buttonLabel = Arr::get($tab, 'button_label')))
                            <div class="space32"></div>
                            <div class="btn-area1">
                                <a href="{{ $buttonUrl }}" class="vl-btn9">{!! BaseHelper::clean($buttonLabel) !!}</a>
                            </div>
                        @endif
                    </div>
                </div>
            @endforeach
        </div>
    </div>
</div>
