@use(Botble\Theme\Supports\ThemeSupport)
<div class="team3-section-area sp1 shortcode-speakers shortcode-speaker-style-3" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="team2-header heading5 space-margin60">
                    @if($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                        @if ($title = $shortcode->title)
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="team-slider-area2 owl-carousel">
                    @foreach($speakers as $speaker)
                        <div class="our-team-boxarea">
                        <div class="team-widget-area">
                            <img src="{{ Theme::asset()->url('images/shapes/speaker-shape-3.png') }}" alt="" class="elements21" />
                            <img src="{{ Theme::asset()->url('images/shapes/speaker-shape-4.png') }}" alt="" class="elements22" />

                            <div class="img1">
                                @if ($avatar = $speaker->avatar)
                                    {{ RvMedia::image($speaker->avatar, $speaker->name ?? '', attributes: ['class' => 'team-img4']) }}
                                @endif

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp
                                    <ul>
                                        @foreach($socials as $social)
                                            <li>
                                                <a aria-label="{{ $social->getName() }}" class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}" href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                        </div>
                        <div class="space28"></div>
                        <div class="content-area">
                            <a aria-label="{{ $speaker->name }}" href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                            <div class="space16"></div>
                            @if ($title = $speaker->getMetaData('title', true))
                                <p>{!! BaseHelper::clean($title) !!}</p>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
