@use(Botble\Theme\Supports\ThemeSupport)

<div class="team4-section-area shortcode-speaker-style-4 sp1" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-6">
                <div class="team-header space-margin60 heading6">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">
                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif
                    <div class="space16"></div>
                    @if ($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="team-slider-area4 owl-carousel">
                        @foreach($speakers as $speaker)
                    <div class="team-widget-boxarea">
                        <div class="img1 image-anime">
                            {{ RvMedia::image($speaker->avatar, $speaker->name, 'thumb') }}
                            @if ($socials = $speaker->getMetaData('socials', true))
                                @php
                                    $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                @endphp
                                <ul>
                                    @foreach($socials as $social)
                                        <li>
                                            <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}"
                                            href="{{ $social->getUrl() }}" target="_blank">
                                                {!! $social->getIconHtml() !!}
                                            </a>
                                        </li>
                                    @endforeach
                                </ul>
                            @endif
                        </div>
                        <div class="space20"></div>
                        <div class="text-area">
                            <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                            <div class="space16"></div>
                            @if ($title = $speaker->getMetaData('title', true))
                                <p>{!! BaseHelper::clean($title) !!}</p>
                            @endif
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
