@use(Botble\Theme\Supports\ThemeSupport)

<div class="team7-section-area sp1 shortcode-speakers shortcode-speaker-style-7" @style($variablesStyle)>
    <div class="container">
        @if ($title = $shortcode->title)
            <div class="row">
                <div class="col-lg-5 m-auto">
                    <div class="team-header space-margin60 heading10 text-center">
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    </div>
                </div>
            </div>
        @endif

        <div class="row">
            <div class="col-lg-12">
                <div class="team-slider-area7 owl-carousel">
                    @foreach ($speakers as $speaker)
                        <div class="team-widget-boxarea">
                            <div class="img1 image-anime">
                                {{ RvMedia::image($speaker->avatar, $speaker->name, 'medium-rectangle-vertical') }}

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp
                                    <ul>
                                        @foreach($socials as $social)
                                            <li>
                                                <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}"
                                                   href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                            <div class="space20"></div>
                            <div class="text-area">
                                <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                                @if ($speakerTitle = $speaker->getMetaData('title', true))
                                    <div class="space16"></div>
                                    <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
