@use(Botble\Theme\Supports\ThemeSupport)

<div class="team8-section-rea sp1 shortcode-speakers shortcode-speaker-style-8" @style($variablesStyle)>
    <div class="container">
        <div class="row">
            <div class="col-lg-5">
                <div class="heading11 space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>{!! BaseHelper::clean($subtitle) !!}</h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space18"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="team-slider-area8 owl-carousel">
                    @foreach($speakers as $speaker)
                        <div class="team-widget-boxarea">
                            <div class="img1 image-anime">
                                {{ RvMedia::image($speaker->avatar, $speaker->name, 'medium-rectangle-vertical') }}

                                @if ($socials = $speaker->getMetaData('socials', true))
                                    @php
                                        $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                    @endphp
                                    <ul>
                                        @foreach($socials as $social)
                                            <li>
                                                <a class="icon{{ $loop->index + 1 }}" title="{{ $social->getName() }}"
                                                   href="{{ $social->getUrl() }}" target="_blank">
                                                    {!! $social->getIconHtml() !!}
                                                </a>
                                            </li>
                                        @endforeach
                                    </ul>
                                @endif
                            </div>
                            <div class="space20"></div>
                            <div class="text-area">
                                <a href="{{ $speaker->url }}">{{ $speaker->name }}</a>
                                @if ($speakerTitle = $speaker->getMetaData('title', true))
                                    <div class="space16"></div>
                                    <p>{!! BaseHelper::clean($speakerTitle) !!}</p>
                                @endif
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
