<div
    class="shortcode-testimonials shortcode-testimonials-2 testimonial4-section-area sp1" @style(["--background-color: $backgroundColor" => $backgroundColor])>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="testimonial4-header heading6 text-center space-margin60">
                    @if($subtitle = $shortcode->subtitle)
                        <h5 data-aos="fade-left" data-aos-duration="800">{{ BaseHelper::clean($subtitle) }}</h5>
                    @endif
                    <div class="space18"></div>
                    @if($title = $shortcode->title)
                        <h2 class="text-anime-style-3">{{ BaseHelper::clean($title) }}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-8 m-auto">
                <div class="testimonial-review-slider owl-carousel">
                    @foreach($testimonials as $testimonial)
                        <div class="testimonial4-content">
                            <ul>
                                @for($i = 0; $i < 5; $i++)
                                    <li>
                                        <x-core::icon name="ti ti-star"/>
                                    </li>
                                @endfor
                            </ul>
                            <div class="space20"></div>
                            <p class="main">“{!! BaseHelper::clean($testimonial->content) !!}”</p>
                            <div class="space32"></div>
                            <div class="name-area">
                                @if($authorImage = $testimonial->image)
                                    <div class="img1">
                                        {{ RvMedia::image($authorImage, $testimonial->name) }}
                                    </div>
                                @endif
                                <div class="text">
                                    <span>{{ $testimonial->name }}</span>
                                    <div class="space6"></div>
                                    @if($company = $testimonial->company)
                                        <p>{!! BaseHelper::clean($company) !!}</p>
                                    @endif
                                </div>
                            </div>
                        </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
