@php
    $testimonialsSplit = $testimonials->split(2);
@endphp

<div
    class="shortcode-testimonials shortcode-testimonials-3 testimonial6-section-area sp1" @style(["--background-color: $backgroundColor !important" => $backgroundColor])>
    <div class="container">
        <div class="row">
            <div class="col-lg-6 m-auto">
                <div class="testimonial-heading heading9 text-center space-margin60">
                    @if ($subtitle = $shortcode->subtitle)
                        <h5>
                            @if ($subtitleImage = $shortcode->subtitle_image)
                                {{ RvMedia::image($subtitleImage, 'icon', attributes: ['class' => 'subtitle-img']) }}
                            @endif

                            {!! BaseHelper::clean($subtitle) !!}
                        </h5>
                    @endif

                    @if ($title = $shortcode->title)
                        <div class="space20"></div>
                        <h2 class="text-anime-style-3">{!! BaseHelper::clean($title) !!}</h2>
                    @endif
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                @foreach($testimonialsSplit as $testimonials)
                    <div @class(['testimonial-reviews-area' => $loop->first, 'testimonial-reviews-area2' => ! $loop->first])>
                        @foreach($testimonials as $testimonial)
                            <div class="testimonial-boxarea">
                                <p>“{!! BaseHelper::clean($testimonial->content) !!}”</p>
                                <span>{{ $testimonial->name }}</span>
                            </div>
                        @endforeach
                    </div>

                    @if (! $loop->last)
                        <div class="space24"></div>
                    @endif
                @endforeach
            </div>
        </div>
    </div>
</div>
