@use(Botble\Theme\Supports\ThemeSupport)

@php
    Theme::set('pageTitle', $account->name);
@endphp

{!! apply_filters('ads_render', null, 'speaker_before', ['class' => 'mb-2']) !!}

<div class="team-details-section-area sp1">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 m-auto">
                <div class="speakers-details-box">
                    <div class="row">
                        <div class="col-lg-5">
                            <div class="our-team-boxarea">
                                <div class="team-widget-area">
                                    <img
                                        src="{{ Theme::asset()->url('images/shapes/speaker-shape-1.png') }}"
                                        alt=""
                                        class="elements21"
                                    />
                                    <img
                                        src="{{ Theme::asset()->url('images/shapes/speaker-shape-2.png') }}"
                                        alt=""
                                        class="elements22"
                                    />
                                    <div class="img1">
                                        {{ RvMedia::image($account->avatar, $account->name, attributes: ['class' => 'team-img4']) }}
                                    </div>
                                </div>
                                <div class="content-area">
                                    <a href="{{ $account->url }}">{{ $account->name }}</a>
                                    @if ($title = $account->getMetaData('title', true))
                                        <div class="space16"></div>
                                        <p>{!! BaseHelper::clean($title) !!}</p>
                                    @endif

                                    @if ($socials = $account->getMetaData('socials', true))
                                        @php
                                            $socials = ThemeSupport::convertSocialLinksToArray($socials);
                                        @endphp
                                        <div class="space24"></div>
                                        <ul>
                                            @foreach ($socials as $social)
                                                <li>
                                                    <a
                                                        class="icon{{ $loop->index + 1 }}"
                                                        title="{{ $social->getName() }}"
                                                        href="{{ $social->getUrl() }}"
                                                        target="_blank"
                                                    >
                                                        {!! $social->getIconHtml() !!}
                                                    </a>
                                                </li>
                                            @endforeach
                                        </ul>
                                    @endif

                                </div>
                            </div>
                        </div>
                        <div class="col-lg-7">
                            <div class="speakesr-details-content heading2">
                                <h2>{{ __('Personal Information') }}</h2>
                                <div class="space16"></div>
                                @if ($description = $account->getMetaData('description', true))
                                    <p>{!! BaseHelper::clean($description) !!}</p>
                                @endif
                                <div class="space32"></div>
                                <div class="row">
                                    <div class="col-lg-12">
                                        <div class="details-content">
                                            @if ($dob = $account->dob)
                                                <h4>{{ __('Date Of Birth:') }}</h4>
                                                <div class="space12"></div>
                                                <a href="#">{{ $dob->format('F d, Y') }}</a>
                                            @endif

                                            @if ($phone = $account->phone)
                                                <div class="space32"></div>
                                                <h4>{{ __('Mobile Number:') }}</h4>
                                                <div class="space12"></div>
                                                <a href="tel:{{ $phone }}">{{ $phone }}</a>
                                            @endif

                                            @if ($address = $account->getMetaData('address', true))
                                                <div class="space32"></div>
                                                <h4>{{ __('Address:') }}</h4>
                                                <div class="space12"></div>
                                                <a href="#">{!! BaseHelper::clean($address) !!}</a>
                                            @endif
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{!! apply_filters('ads_render', null, 'speaker_after', ['class' => 'mt-2']) !!}
