<?php

use Botble\Base\Forms\FieldOptions\SelectFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\SelectField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Blog\Models\Category;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;
use Illuminate\Support\Arr;
use Illuminate\Support\Collection;

class BlogCategoriesWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Blog Categories'),
            'description' => __('Widget blog categories'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        $categories = Category::query()->pluck('name', 'id')->all();
        $data = $this->getConfig();
        $categoryIds = Arr::get($data, 'category_ids');

        return WidgetForm::createFromArray($this->getConfig())
            ->add(
                'title',
                TextField::class,
                TextFieldOption::make()
                    ->label(__('Title'))
            )
            ->add(
                'category_ids',
                SelectField::class,
                SelectFieldOption::make()
                    ->label(__('Choose categories'))
                    ->choices($categories)
                    ->selected($categoryIds)
                    ->searchable()
                    ->multiple()
            );
    }

    protected function data(): array|Collection
    {
        $config = $this->getConfig();
        $title = Arr::get($config, 'title');
        $categoryIds = Arr::get($config, 'category_ids');

        if (empty($categoryIds)) {
            return [];
        }

        $categories = Category::query()
            ->select('id', 'name')
            ->with('slugable')
            ->wherePublished()
            ->whereIn('id', $categoryIds)
            ->get();

        if (! $categories) {
            return [];
        }

        return compact('title', 'categories');
    }

    protected function requiredPlugins(): array
    {
        return ['blog'];
    }
}
