@if (($quantity = Arr::get($config, 'quantity')) > 0)
    <div class="single-footer widget-contact-info">
        @if ($titleMain = Arr::get($config, 'title'))
            <h3>{!! BaseHelper::clean($titleMain) !!}</h3>
        @endif

        <div class="footer1-contact-info">
            @foreach (range(1, $quantity) as $i)
                @continue(!($title = Arr::get($config, "title_$i")))

                <div class="contact-info-single">
                    <div class="contact-info-icon">
                        <span>
                            @if ($iconImage = Arr::get($config, "icon_image_$i"))
                                {{ RvMedia::image($iconImage, $title, attributes: ['width' => 16, 'height' => 16]) }}
                            @elseif($icon = Arr::get($config, "icon_$i"))
                                <x-core::icon :name="$icon" />
                            @endif
                        </span>
                    </div>
                    <div class="contact-info-text">
                        <a href="{{ Arr::get($config, "url_$i") }}">{!! BaseHelper::clean($title) !!}</a>
                    </div>
                </div>
            @endforeach
        </div>
    </div>
@endif
