@if (($quantity = Arr::get($config, 'quantity')) > 0)
    <ul class="widget-contact-information">
        @foreach (range(1, $quantity) as $i)
            @continue(!($title = Arr::get($config, "title_$i")))

            <li>
                <a href="{{ Arr::get($config, "url_$i") }}">
                    @if ($iconImage = Arr::get($config, "icon_image_$i"))
                        {{ RvMedia::image($iconImage, $title, attributes: ['width' => 16, 'height' => 16]) }}
                    @elseif($icon = Arr::get($config, "icon_$i"))
                        <x-core::icon :name="$icon" />
                    @endif

                    {!! BaseHelper::clean($title) !!}
                </a>
            </li>
        @endforeach
    </ul>
@endif
