@php
    $hasIcon = false;

    foreach ($items as $item) {
        if ($item->icon) {
            $hasIcon = true;
            break;
        }
    }
@endphp

@if ($items->isNotEmpty())
    <div @class(['col-md-6', 'col-lg-2' => !$hasIcon, 'col-lg-3' => $hasIcon])>
        <div class="link-content">
            @if ($name = Arr::get($config, 'name'))
                <h3>{!! BaseHelper::clean($name) !!}</h3>
            @endif

            <ul>
                @foreach ($items as $item)
                    @php
                        $label = $item->label;
                        $url = $item->url;
                        $icon = $item->icon;
                    @endphp

                    @continue(!$label || !$url)

                    <li>
                        <a
                            href="{{ $url }}"
                            {!! $item->attributes !!}
                            @if ($item->is_open_new_tab) target="_blank" @endif
                        >
                            @if ($icon)
                                <x-core::icon :name="$icon" />
                            @endif
                            {!! BaseHelper::clean($label) !!}
                        </a>
                    </li>
                @endforeach
            </ul>
        </div>
    </div>
@endif
