<?php

use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Forms\FieldOptions\ColorFieldOption;
use Botble\Base\Forms\FieldOptions\MediaImageFieldOption;
use Botble\Base\Forms\FieldOptions\TextFieldOption;
use Botble\Base\Forms\Fields\ColorField;
use Botble\Base\Forms\Fields\MediaImageField;
use Botble\Base\Forms\Fields\TextField;
use Botble\Widget\AbstractWidget;
use Botble\Widget\Forms\WidgetForm;
use Illuminate\Support\Collection;

class UpcomingEventWidget extends AbstractWidget
{
    public function __construct()
    {
        parent::__construct([
            'name' => __('Upcoming Event'),
            'description' => __('Widget upcoming event'),
        ]);
    }

    public function settingForm(): string|null|WidgetForm
    {
        return WidgetForm::createFromArray($this->getConfig())
            ->add(
                'button_label',
                TextField::class,
                TextFieldOption::make()->label(__('Button label'))
            )
            ->add('image', MediaImageField::class, MediaImageFieldOption::make()
                ->label(__('Image')))
            ->add(
                'background_color',
                ColorField::class,
                ColorFieldOption::make()
                    ->label(__('Background color'))
            )
            ->add('background_image', MediaImageField::class, MediaImageFieldOption::make()
                ->label(__('Background image')));
    }

    protected function data(): array|Collection
    {
        $event = Event::query()
            ->withCount('speakers')
            ->where('status', EventStatusEnum::APPROVED)
            ->where('started_at', '>=', now())
            ->orderBy('started_at')
            ->first();

        return compact('event');
    }

    protected function requiredPlugins(): array
    {
        return ['events-booking'];
    }
}
