-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'PcZTPneZMyIuCJhWMFFvV5Db1rS7qibu',1,'2025-06-10 10:40:08','2025-06-10 10:40:08','2025-06-10 10:40:08');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:40:59',NULL,1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:40:59',NULL,1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:40:59',NULL,1,'2025-06-10 10:40:59','2025-06-10 10:40:59');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Laborum perspiciatis quam consequatur cupiditate rerum reiciendis quos. Iste consectetur eos velit quis. Rem sint aut temporibus sed animi molestiae.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(2,'Leadership &amp; Strategy',0,'Laboriosam quia consequatur aut perferendis ipsum. Error nihil consequatur ducimus amet vel ut. Nulla totam perferendis cum consequatur qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(3,'Networking &amp; Collaboration',0,'Minima recusandae ut natus deleniti quisquam. Quia ut odio natus impedit incidunt magnam vel. Necessitatibus sed eum voluptate praesentium quam nulla quisquam.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(4,'Entrepreneurship Startups',0,'Est ex quod nisi numquam. Eveniet omnis ab quia dignissimos aut. Enim est impedit corporis architecto totam eos debitis.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(5,'Marketing &amp; Branding',0,'Id provident aut ut sed nihil. Voluptatem omnis cupiditate dolor deleniti ut. Doloribus dolorem ullam aspernatur libero ipsum magni dignissimos consequatur. Aut accusamus soluta in illo sit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(6,'Event Highlights &amp; Recaps',0,'Quia id est incidunt beatae. Ex quae veniam vero necessitatibus rerum. Ex quis voluptas distinctio.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:40:31','2025-06-10 10:40:31');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Prof. Trent Little PhD','will.cesar@example.org','(848) 520-6950','12184 Cierra Crest\nSouth Anjalishire, IN 73380-6820','Dicta corporis repudiandae veniam.','Reiciendis repellat veritatis repellendus debitis ea voluptatem. Voluptatem est harum et ut tenetur. Ut voluptas quis autem est id velit. At fugit pariatur earum tenetur dolor repellat ipsa. Sint autem voluptas nihil soluta voluptas ratione nam. Labore fugit deleniti officia inventore. Quaerat et occaecati blanditiis voluptatum sint officiis est. Natus tenetur ad hic veritatis eum nam et. Adipisci sit minima repellat vitae quia esse quisquam. Fuga deleniti est et alias.',NULL,'unread','2025-06-10 10:40:08','2025-06-10 10:40:08'),(2,'Dallas Howe','vbartoletti@example.com','+1.562.320.4373','98665 Crona Spurs\nPort Jazlyn, KY 15289','Labore asperiores omnis vel.','Ut quas quisquam qui necessitatibus sapiente consequuntur est. Accusamus cumque delectus aliquid ad sunt vitae repellendus. Et voluptatem est quia qui modi. Aut voluptatibus temporibus sit odit. Alias incidunt praesentium sunt consequuntur delectus. Aut sint tempore et quod voluptas itaque. Earum ducimus aut nulla. Numquam aut ea quis magni eos dolorem qui.',NULL,'read','2025-06-10 10:40:08','2025-06-10 10:40:08'),(3,'Kris Wisozk','blick.lyda@example.com','+1 (585) 840-4269','553 Kunze Trail\nHelgafurt, ID 27468-0690','Illo itaque et ex sed quia facere nobis magni.','Recusandae ea rerum quia ut odio voluptas eveniet. Totam molestiae corporis atque ex inventore repellendus. Numquam est nihil necessitatibus. Debitis accusantium minus voluptatem eveniet. Similique id corrupti magni est. Neque cum asperiores et enim. Iure beatae consectetur minus dolore amet provident consequuntur. Asperiores voluptatem labore minus amet asperiores. Temporibus vel rerum dolorum nobis. Dolorem eum eveniet atque saepe voluptatibus.',NULL,'unread','2025-06-10 10:40:08','2025-06-10 10:40:08'),(4,'Reynold Koepp','bpacocha@example.org','(937) 481-2345','719 Alfonso Springs\nLake Virgilview, WI 34040','Et non sed ratione molestiae tempora non.','Porro nihil vel impedit earum. Quasi nobis sint vero unde quis. Vero debitis perspiciatis a. A cum nulla eaque officiis quasi ratione odit. Ut rerum quisquam porro odit est. Autem distinctio aut consequatur ipsum. Voluptatum repellendus consequatur explicabo illo dicta quo. Et dolorum exercitationem corrupti deleniti reprehenderit dolorem. Repellat fugiat vero rerum. Ab facere voluptatem distinctio rem quam sit. Rerum in saepe error. Incidunt voluptatem culpa ducimus placeat ullam.',NULL,'unread','2025-06-10 10:40:08','2025-06-10 10:40:08'),(5,'Mr. Easter Halvorson IV','shields.arnaldo@example.net','(978) 308-1580','251 Savannah Ports\nWest Jakaylachester, AR 85050','Reiciendis nam et ut vel consequatur optio.','Et minus inventore velit eum rerum adipisci est deleniti. Unde facere quidem quaerat voluptatum. Laborum nemo aliquid aliquam est. Dolore deleniti in quisquam laboriosam cum similique. Enim eius aut itaque ex. Voluptatibus aliquid modi voluptates consequatur harum qui incidunt. Ratione officiis velit optio voluptatem.',NULL,'unread','2025-06-10 10:40:08','2025-06-10 10:40:08'),(6,'Jeremie Robel Jr.','brogahn@example.net','781-854-1435','5513 Charity Rest\nQuigleyland, WA 36411','Debitis ducimus laboriosam ipsum nihil.','Qui necessitatibus dicta nesciunt corrupti praesentium molestiae. Voluptatibus sit debitis in ab. Blanditiis asperiores aperiam dolor illum mollitia ad et. Accusantium suscipit nihil necessitatibus molestiae numquam mollitia id magnam. Est error tempora nisi quia est. Corrupti officia consectetur reprehenderit molestias ducimus eum quas consequuntur. Possimus quis dolore ducimus vitae quos saepe. Velit qui veniam a laborum. Et molestiae quia quis sequi.',NULL,'read','2025-06-10 10:40:08','2025-06-10 10:40:08'),(7,'Jocelyn Jones','connelly.ryleigh@example.org','832-957-1844','20036 Tromp Branch Apt. 591\nPagacland, AR 41988','Odit repellendus consequatur et.','Ex deleniti expedita aut sed. Quia eaque omnis ea temporibus. Ipsum odio dolorem ut quo voluptatibus nisi. Unde accusamus sed doloremque est voluptatibus. Molestiae iste doloremque consectetur voluptas. Ex deleniti nisi ipsum incidunt. Nam et et eveniet autem repellat quia qui. Voluptate illum quae voluptatum autem. Iste et at et sunt voluptate amet laboriosam placeat. Rerum quia sit et. Blanditiis quae enim quae quod quis debitis harum.',NULL,'read','2025-06-10 10:40:08','2025-06-10 10:40:08'),(8,'Kamron Lowe','ukunze@example.org','1-909-342-2221','85612 Mozell Walks Apt. 609\nNorth Vicentahaven, SC 78971-1284','Et sint quibusdam est dolor numquam tempore et.','Quae voluptas optio unde occaecati. Sit dicta nostrum id eveniet vitae odio in. Aut aut magnam qui non. Est et ut et voluptatibus. Quasi ea dolore quibusdam reprehenderit maxime. Sed tenetur asperiores cumque. Provident delectus iusto sunt doloribus veniam quidem consequuntur aspernatur. Quidem soluta reprehenderit iusto vel. Numquam aperiam quisquam soluta qui eveniet ut. Illum quis ab dolores culpa voluptas aspernatur non. Quaerat iste sint commodi.',NULL,'read','2025-06-10 10:40:08','2025-06-10 10:40:08'),(9,'Mrs. Mireille Conroy V','rrau@example.org','715-824-2467','9158 Corkery Ports\nSchustermouth, NJ 51586-2184','Sint id voluptatibus harum repellat.','Non explicabo cupiditate minus quo a. Dicta at nihil ut officiis quidem consequatur veritatis. Et vel non quasi error maxime harum ducimus. Vero in ipsam architecto quas a voluptates id. Quo et voluptatem blanditiis. Reprehenderit excepturi sit eum. Impedit alias sed doloremque et et amet. Aliquam a et quae quia ad aspernatur a. A adipisci quibusdam quibusdam quaerat.',NULL,'unread','2025-06-10 10:40:08','2025-06-10 10:40:08'),(10,'Charlene Rippin','jfahey@example.com','385.499.5548','395 Katharina Station Suite 280\nSouth Dominique, AL 52742-0827','Laudantium ipsum quaerat commodi.','Consectetur et ut eveniet necessitatibus maxime. Esse in ut eveniet in. Sapiente et minima et velit sed. Quam velit sit magnam molestiae id facere. Et non omnis officia expedita. Doloremque minima est expedita possimus in. Tempora dolorem facere et facilis quae incidunt eum itaque. Et ducimus quam et aut dignissimos ut neque. Voluptates dolor id voluptatem nobis accusamus. Vel nostrum omnis adipisci et. Ut nihil ea quasi odit.',NULL,'read','2025-06-10 10:40:08','2025-06-10 10:40:08');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:40:40',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:40:40',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:40:40',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:40:40',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:40:40',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:40:40',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=83 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Macy Yost Jr.','customer@archielite.com','$2y$12$Ni2f9QqEyWEhYC9yP9avrur9DlWS.KOrVrmiAQpmY8nAbk7G/kr72',NULL,'0899537363','2011-05-07','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:35','2025-06-10 10:40:35'),(2,'Michael Smith','loyce.wisozk@gusikowski.net','$2y$12$BcTsq2dS.bEVRmK.I4sEHOKPgVlNWUTB/eEhw.wwTmOX35RGqcsZS','main/speakers/5.png','0427402474','1997-01-10','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:35','2025-06-10 10:40:35'),(3,'Ibrahim Kunze V','hluettgen@hotmail.com','$2y$12$sL4o3KzDs6/M..lFOWpYxOrQDW1tWOK8AnwTntwiqNdd6TanYXye6','main/speakers/9.png','0636332297','1996-08-31','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:35','2025-06-10 10:40:35'),(4,'Cary Osinski','gswift@beatty.com','$2y$12$ruwZaCaTRFx8i2xADWlLieWKuSIZYEH6PfhX6sx3poKmmrmswbByi','main/speakers/8.png','0703600078','2014-09-10','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(5,'Frederik Aufderhar','yrutherford@lebsack.info','$2y$12$.VytC2nmkIP45ZcxzMtBGe9tpwmVC0Kxz5TaHifLN14dJavdeVSyi','main/speakers/5.png','0799862761','2023-04-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(6,'Brady Parker','hilario.bergnaum@yahoo.com','$2y$12$nRUUi5YBFCs7EI9yXtouUOQHDfj55y1SSgevMVjNXmKbNX360eZo.','main/speakers/9.png','0029399785','2017-03-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(7,'Edwin Miller MD','zschoen@wiegand.com','$2y$12$uumcTqVUtt9/oL8Qz1.HtOGoa3hgzWF9N.nYJIi1JRSzDAiaxI0K6',NULL,'0288075692','2022-04-14','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(8,'Rahul Prosacco','gjaskolski@yahoo.com','$2y$12$WhFn46iatV5Uw4eiVN8c7eW/y/BhGhYtQJ51W.d8HVvXznRGMUS4e','main/speakers/7.png','0628077733','2011-07-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(9,'Giles Mann','hammes.douglas@gmail.com','$2y$12$ylsITC6YQ7m4X//1A66GTuSOPEUxhUNrGeweZXr6qbG6aSpYFGVme',NULL,'0182659746','1998-09-11','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:36','2025-06-10 10:40:36'),(10,'Effie Zboncak','aracely76@johns.com','$2y$12$TC7Z3dxxBovCD3BCJBtao.rGcMFv4C6tW3j/4ZCxgs6Nf1lxXnImy',NULL,'0113694125','2000-05-03','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:37','2025-06-10 10:40:37'),(11,'Beulah Johnson','carmelo59@wolff.com','$2y$12$RQPFbZxeBtxJNSSxsWMx2OHUsO1r1dOgU.vKRwjzbpx4w.XlITMcW','main/speakers/6.png','0626548007','1999-09-17','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:37','2025-06-10 10:40:37'),(12,'Maegan Schulist','landen76@yahoo.com','$2y$12$R9VSNR3ZVp7izejLAqpc5Og00O02VuElNm3S.T96Sv4cAbD8ROhQK',NULL,'0764288051','2014-10-12','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:37','2025-06-10 10:40:37'),(13,'Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com','$2y$12$lEIOFh9y5ie/SOMVskn7WOIeM7c1.udkHY8P0mdRGlYDYrgSnALKC',NULL,'0410879230','1999-10-08','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:37','2025-06-10 10:40:37'),(14,'Adriana Schulist','davis.richie@raynor.org','$2y$12$xcajDWTnVXMgvudOVU99SOvfCO3rjXH34ioBR7bQsNvU7lXBeRglG','main/speakers/8.png','0276201695','2010-07-25','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:37','2025-06-10 10:40:37'),(15,'Ima Nitzsche','moshe.collins@yahoo.com','$2y$12$kY9vfOnMg7S4Ks3Y1Zn4/u09.JMMLi5mqhGbGOUh7Eejalt4bi.Oi','main/speakers/8.png','0546260669','2019-12-25','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(16,'Prof. Dedric Baumbach I','arogahn@hotmail.com','$2y$12$.CpKwuxZNFL8znFcNhiBsOs.Tu.l7D/KOaCKLdpBmLacQroTIo1ee','main/speakers/8.png','0809879592','2010-03-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(17,'Bonita Kuhic DDS','dayana76@gulgowski.com','$2y$12$sWtABK76D5hu8.IgUt5ShewdYPjanu2O2.Ui1KFWEO77kiuMdwt8G','main/speakers/2.png','0352006535','2006-06-04','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(18,'Antoinette Jenkins','xmorar@buckridge.net','$2y$12$UwZ9jWuDD6D8NZWkWNMjNu0xgXYVay2q3K94NMyfXsSVji9LPLr7K','main/speakers/7.png','0770228551','2006-06-18','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(19,'Leanne Hartmann','willis.mann@gmail.com','$2y$12$hVa9Xyj1K3dNNd.UeRfVwuSG/z3pv.iOh5YUxhtuvE3sat2cc1bO.',NULL,'0523491570','2006-08-10','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(20,'Carlee Hansen','kevon74@konopelski.com','$2y$12$zRsPZLHx.yZy8BLZj7ztVuoFg2iHv7EYLmx98WAG/MUhj2V.91.jG',NULL,'0804442990','2011-03-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:38','2025-06-10 10:40:38'),(21,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','$2y$12$RbNKCjnpg1v8tNcw3KysKe08cbbrMGslJT7owz9HDbYEoqLD8LvlK',NULL,'0962372388','2015-03-25','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:39','2025-06-10 10:40:39'),(22,'Dr. Donald Feil PhD','nruecker@yahoo.com','$2y$12$YbYJYMFx2EbVTyClbvHQWe.m6OPxBBQc06URxDmk0PcO1Zz6JtUpi','main/speakers/8.png','0206087170','2009-05-03','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:39','2025-06-10 10:40:39'),(23,'Prof. Zena Barrows','pasquale11@yahoo.com','$2y$12$8C7gK2QHJcQMiA1YVs8l0eyiaNXUlY9rRaHDLCDL8SvPNx6nlJkDq',NULL,'0534716236','2003-03-17','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:39','2025-06-10 10:40:39'),(24,'Hubert Miller','roxane.bins@hotmail.com','$2y$12$rPDDq/KAFATJa8WRMRjaYuTbOs6ZSFKheUj6hpXsIeVGRyitNLh62','main/speakers/9.png','0360665202','2016-08-15','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:39','2025-06-10 10:40:39'),(25,'Mrs. Hosea Koelpin','hyatt.abel@rowe.com','$2y$12$V7D7kbRzpMvjiVjM8PA4K.kokiKnDaJix3GNnPGU3l5izpJ7oPhmS','main/speakers/8.png','0692313795','2002-09-01','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:39','2025-06-10 10:40:39'),(26,'Brenden Koch','reed.eichmann@gmail.com','$2y$12$Vf7Iza.IrbNZz11psZwKHeQ/ZVH85/dWr1Ken3gUOqBTE.iV34eWi','main/speakers/5.png','0873136673','2021-10-30','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(27,'Anahi Jaskolski','aleen75@gmail.com','$2y$12$RzYOJL7cpOjjie7v.dEyxud5IQkqC1/pHOy3e8lv0.wruJz5swVdO','main/speakers/10.png','0659011261','2003-10-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(28,'Leslie Brakus','karl.hill@yahoo.com','$2y$12$0LeUEt7SEBT7hcgaQncF4.jiNEUs7qPVWVkdUX5SnJn.E435Es9p.','main/speakers/3.png','0317559395','2003-11-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(29,'Blanche Maggio','goldner.malachi@yahoo.com','$2y$12$xxSFpuuLe0okaSZLGKAvCO082gIEGVdYuzUCnKdjHID0tcUM8.6zS',NULL,'0722169287','2014-04-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(30,'Dr. Eliza Weber','dach.sonny@brown.info','$2y$12$2sJXkOtTrvfgQ9bEYtvMPOCgxj9lLxkRpnoVGcu.mdYKqzGArmVve','main/speakers/10.png','0061966811','2007-05-01','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(31,'Norbert Hermann','ngreenfelder@gmail.com','$2y$12$WteIraEgF82VieJheuGum.2vsFhboDm4lU6GHJyazr4RtKAwitgB6','main/speakers/9.png','0387909333','2000-03-17','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:40:40','2025-06-10 10:40:40'),(32,'Mr. Jordi Spencer','marcus74@hotmail.com','$2y$12$DeRCV2dOQu6Q9j6wIiy7BeqqULR3Dklik34V0XHSxOipO.0FBTFIi',NULL,'0489514008',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(33,'Dr. Brock Paucek III','jmann@franecki.com','$2y$12$f6IQ1EXSLbg018nPBEAw8O5cDJo8Vcoiaj.VOueebPcjm50f7Ndwy',NULL,'0829234308',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(34,'Prof. Simone Nolan DVM','kovacek.zakary@hotmail.com','$2y$12$zFIWNyprHvqvnLSF0hAgDeHSupAOp47cQb3t7eLBYutDLdZrQrcBq',NULL,'0574392669',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(35,'Nicholas Reinger','lowe.noemi@hotmail.com','$2y$12$4uN1zzPvP6hIaf.4LSn9TOp2n5GM3TTWTl5Q4CRLOGEiVTTXTCQTi',NULL,'0661511748',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(36,'Ms. Zola Osinski III','xritchie@gmail.com','$2y$12$aZb/NomAVym2KE5n3bEyFeiE7w2SSDY8ra8zG9LRKUvCzfYE20BSC',NULL,'0173799181',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(37,'Yolanda Schimmel','schultz.lyla@leannon.info','$2y$12$Ra5em.TmUijOfGqsVVCLc.287KYjtttculOf7Yd2NmIV82RxmmJaS',NULL,'0975946310',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(38,'Bernhard Okuneva MD','kuphal.oswaldo@yahoo.com','$2y$12$j0MTMHbiqNBPqoz.hESltOVpOLCp/IhNZx64R4fBiaQN8QPUuok1K',NULL,'0618004874',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(39,'Raphaelle Keebler Jr.','ahmed12@bergnaum.com','$2y$12$1aq03AZjgTrTTAYTedFTJ.t45YybYVIgmSah6a85V9mYAiA94QbHm',NULL,'0319207795',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:52','2025-06-10 10:40:52'),(40,'Eva Kirlin','destin38@yahoo.com','$2y$12$NojE4Scl7za9Tj5zP4r9.ONE5vX9r5xNHrqKhmRmmTy9IDOB/z0P2',NULL,'0831308201',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(41,'Zula Kreiger','nebert@hotmail.com','$2y$12$d3k8uhZO06QwkN/ECGu7Oe3qnwr7a7N5VkZyO0ZQteoiEuyILpgcq',NULL,'0271357937',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(42,'Elmer Rolfson','keeling.emmy@yahoo.com','$2y$12$6meaWjewp32uBa2.ZLJ1A.P38RyUoRR2OHJtli0bMQvf.wi79G0nm',NULL,'0033778003',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(43,'Roosevelt Cassin','madelyn13@hotmail.com','$2y$12$SS8fICbXyg2wE2gnykqBF.O1hLT5/cUvmYlWRvh/RNH62O4Ga5oG.',NULL,'0930366350',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(44,'Prof. Amie O\'Connell Sr.','bhoeger@wunsch.biz','$2y$12$qQFfQQrWCxnUIE.zmtjLVO7rtv3Pc2NxvX.UYsIs2BCqxddcg6Xfm',NULL,'0338171815',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(45,'Elwin Waters Jr.','littel.annabell@davis.org','$2y$12$Gnu8NakG5dJBMLDXfo4RXuufBqbtcn4alHIkrDagNYLd0331pvFVq',NULL,'0614947408',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(46,'Mr. Jamey Hodkiewicz MD','jrutherford@hotmail.com','$2y$12$jMaU7l2KZco1rfMF/mvQzujhBKs03Kjz9fecMyA1mwqcdqWss7zGK',NULL,'0301256222',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:53','2025-06-10 10:40:53'),(47,'Miss Lyla Greenfelder Sr.','selina70@hotmail.com','$2y$12$BUBTcbCoXqWGGPyqVb4vi.g4JI.lo286k8PuHOCzRW6Bc4e1VcRpq',NULL,'0546757461',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(48,'Mr. Vincenzo Crona DDS','harber.maymie@kohler.com','$2y$12$wi6jVPnkqouPD5z8o/6twOHw5jfsn3NJeFDh.bbF0EurfbAiEpFaG',NULL,'0089500692',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(49,'Ms. Adaline Sporer V','chand@gmail.com','$2y$12$.z6PnhklO63aj8YX6v8nK.RBcQl/RmphPy9Du4EqI0t2WQfA8F8UG',NULL,'0684491124',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(50,'Tia Jaskolski','turcotte.erin@prohaska.info','$2y$12$wqkl/.jH72yTm4oXVR7ZmuNUACgfK0gZ6GwH9noMr/MzBMywBDXU2',NULL,'0077676973',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(51,'Orland Steuber','augustine99@durgan.com','$2y$12$wxIAU9EawPbJLLELUFLDz.VDR26O/yJhZqHrHr5S64uapOF4.hyLS',NULL,'0573080854',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(52,'Morgan Bechtelar','cbrown@franecki.net','$2y$12$ldHzB7AXiFvxRIGm7OD3U.X1qAa2/GPBTmCTAW23aXptOXewm/il2',NULL,'0366339748',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(53,'Dr. Erna Bradtke III','fahey.melyna@mcclure.net','$2y$12$m1pMY53DzrLTLseBgJrrzeecdg4sNMIJkfIiiXKbXB8yigAKAjBF2',NULL,'0988469395',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:54','2025-06-10 10:40:54'),(54,'Ms. Thea Cormier II','wleuschke@yahoo.com','$2y$12$OPt7xgwFshXTnu10XKPzzuqy/T3jOE.wzZBetbNjeLe/2Q6hNlczW',NULL,'0458917969',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(55,'Bartholome Armstrong','vcruickshank@hotmail.com','$2y$12$S9ghQkggzS5PhkaCrB07LePgvZ1PGVEPK.Bu9cWiT2Ia/rMnhBAIq',NULL,'0288608807',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(56,'Loyal Jast','pfannerstill.dedrick@white.biz','$2y$12$sb9gyuB/IYauuN4SDXGEeuFpTCSvJOy5I6cO6CkOopjDS34cgAM6i',NULL,'0303015464',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(57,'Dr. Daphney Watsica DVM','marquardt.tiana@yahoo.com','$2y$12$5C5c.vKz9NwJzpR3arMLUur3cIoU/2WFt7KAyHVIG8RhJ9JyIfVTq',NULL,'0552327047',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(58,'Alec Sporer PhD','reichert.camille@anderson.biz','$2y$12$CZOjPElaeiF1npu6IyP9iOpXXDcp/uI3ljaSkpn7PtYk3D.w49JyK',NULL,'0684486230',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(59,'Miss Kacie Graham MD','syble.luettgen@berge.com','$2y$12$/zIoTDgvS5h38p1QoUAuQODMMrlb/abKXQgWJy2klYMg/Su.b8UbS',NULL,'0162960508',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(60,'Wilfred Johnston Jr.','rolfson.abby@boehm.com','$2y$12$MwAnUQpLU/bwEkAptNO3mOpl92qIbVphv8wTrsJWplmxjfD/NKTnm',NULL,'0597591152',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:55','2025-06-10 10:40:55'),(61,'Patience Powlowski','bernice81@hotmail.com','$2y$12$bLtL0GFF/KdkLfAirIy2Nu65GFpY8YZF8ZNvFiSrNscmFOxh6VbkC',NULL,'0745990249',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(62,'Prof. Aric Pfannerstill III','stokes.justus@schuster.org','$2y$12$MOn28Th5XGG27q.fbDHCfuhI6lQYRTBZ9rGUYmvPyDiK07981EEAO',NULL,'0194158971',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(63,'Mr. Filiberto Harvey Jr.','sharvey@gmail.com','$2y$12$dCvD2s4mBsxz70vZX2VKb.18hfeZ4AZPiSms2CR4U8QcD5jTtJdeW',NULL,'0787939749',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(64,'Adelbert Abbott','kovacek.emelie@kub.net','$2y$12$NlvSBE443Wa4LK8QcAnT1OLnarHUtMOjO9z/YmhGLwqVucWRNrxD6',NULL,'0947547069',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(65,'Violette Thompson','lcollins@jones.net','$2y$12$vKwtiQ6PV1eS5qaR3i0I..n1srV1Xbfkx/UVNgsi.KGHeVGVuRsTa',NULL,'0258016247',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(66,'Mrs. Trudie Predovic','nienow.paris@dibbert.com','$2y$12$QhZrLuaP.m3hYtbTplPERuYQOF/EZ5Br5rIB5iUB5iGhuWih3mTmS',NULL,'0402265942',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(67,'Prof. Kallie Hagenes','etorphy@yahoo.com','$2y$12$0JZF8yi4GqdaFIqFaKqLfO/vgllYoOr1tV1vky/F60ru/glLgAC2.',NULL,'0662186704',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:56','2025-06-10 10:40:56'),(68,'Dashawn Dickinson','rhiannon.halvorson@leuschke.com','$2y$12$Q7cnYw/SjQHj8VidvQh.k.pWPkipTcYPSpbo//j/esp5L1mF7QhFS',NULL,'0358097028',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(69,'Dr. Magnus Yundt','caterina03@schmeler.com','$2y$12$Lq.T0rOz2WFDfOYrgFkehelYIYrSZbbpI/e3BnKP4/v/W5h.rn0Ay',NULL,'0007639723',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(70,'Catharine Ondricka','courtney.wintheiser@hyatt.net','$2y$12$63Pb7CGyVyO6MgTSVtdWHuhYmkDDsZy.agQxtGVf/f9Z4RGF6wDBi',NULL,'0825205933',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(71,'Joesph Braun','ukonopelski@hotmail.com','$2y$12$gSm5PpCcofGEt2y64egYGOnRLohpOquIGh0SiwKn4kKO6PIUqDMfW',NULL,'0459930481',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(72,'Cornelius Schiller','cwalker@hotmail.com','$2y$12$FMS3CREcitBo/6tOAkjROOlQX7Y4NHlzdRnqF4KrwF3j7IG4749uy',NULL,'0518148396',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(73,'Dr. Matilde Adams PhD','mante.patience@gmail.com','$2y$12$I6R2/boonhiZy376uU8m8O87E4YPJMg20oT3IsEOiecGcRlqhvWBG',NULL,'0828309955',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(74,'Miss Alize Keeling','xreilly@hotmail.com','$2y$12$Maer4PDC6yFFkJw3cnonZ.SS5sktME9GMHND1P2vGXm.8Os/eRtiS',NULL,'0206699919',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:57','2025-06-10 10:40:57'),(75,'Tyrique Dicki','garfield.ferry@gmail.com','$2y$12$nRy3bQJH2rah94xVm1iogOSy6W75DRtO3KcryD/21BTxywd33DJrG',NULL,'0706668788',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(76,'Myriam Huel','barrett67@murazik.info','$2y$12$NN298eUM6m95vAHGngDGxu5Wj3j8U11wx5ZcysalsntlDMyJ6mID6',NULL,'0979253217',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(77,'Jaden Greenfelder','aryanna.veum@boyer.com','$2y$12$v9Gm423iZIB3XyN0EsFJ/On/1LR8lx6V3caXEdQ766e7snoRo4EXC',NULL,'0492502681',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(78,'Serena Ferry','eliane48@dibbert.com','$2y$12$cbLmXaYxmwnQY6e6SJb18OyPAkHqqvNC26yyOv5I4wSiH8F/XJOmO',NULL,'0448649445',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(79,'Ernesto Jenkins V','king.clyde@rice.com','$2y$12$xW1G/j0hBuEXBM4vAchjMOqR9eZ2Hngr8oEcSdL1lT46VRhXKZvFm',NULL,'0152767207',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(80,'Javier Graham','ubatz@rice.com','$2y$12$DbZ2KxGN6C4fFGvGf.bjGezvI3W0xkNYtT7xFKWjZUQMi.9tGch1y',NULL,'0724819986',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:58','2025-06-10 10:40:58'),(81,'Brielle Gerlach','maximo.gleichner@yahoo.com','$2y$12$pil99h/HoYU6I9xyMIInV.Y0V0j8IHgx/2PVXRc9iNIPm310l/Woi',NULL,'0678486004',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(82,'Miss Violette Hegmann PhD','dangelo40@kohler.net','$2y$12$.ADLrMCh4afisgahrFZaBu.QhSKPpxF0CLrMoZr6lIT.GdHpH/gUa',NULL,'0635135971',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:40:59','2025-06-10 10:40:59');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:40:01','2025-06-10 10:40:01'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:40:01','2025-06-10 10:40:01'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:40:01','2025-06-10 10:40:01');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (4,66,'1DRWRIIY86YH',NULL),(5,80,'2CWDTFCPDRSA',NULL),(4,54,'2V5FQFB7RRQC',NULL),(1,32,'3XMULPMSHGVJ',NULL),(1,38,'4TPOPVOVBVRI',NULL),(4,61,'4YWBHIS7P5C5',NULL),(4,62,'5OZILLAXUFLF',NULL),(5,75,'672ZIEHIHKP9',NULL),(4,52,'6AS1P4U6HWWJ',NULL),(4,59,'8LDBM9W30AXQ',NULL),(5,77,'A8JYZZ3G6UYF',NULL),(3,42,'AUMBIKRAXAY0',NULL),(5,73,'AZ7XPUGEYZXJ',NULL),(5,76,'DH27WTDD0ACH',NULL),(4,55,'DZ6WZXQWJVHW',NULL),(3,47,'E2CDWVBJOS9R',NULL),(4,70,'EXE0QPBFO04O',NULL),(4,53,'F7FL1II4SJCO',NULL),(4,69,'GC8FBWBB98R0',NULL),(1,35,'GDNEAALAWL5D',NULL),(1,37,'GJ79JRN1HAQ8',NULL),(4,60,'GPHEBCLL64PG',NULL),(5,71,'H9DCTQDBVXBB',NULL),(4,56,'ITJROIYTD8N1',NULL),(4,63,'JQA27LFP7PP7',NULL),(3,45,'LG3MFQIUZUTR',NULL),(1,34,'M44MZNRX7X8A',NULL),(3,40,'M5CKGIQJYJHT',NULL),(4,57,'MFEYH2NPNG6R',NULL),(3,46,'MLCRAMM8DOEI',NULL),(4,68,'NA7GS2QPBUWS',NULL),(1,36,'O61EZD9RJF3H',NULL),(4,64,'OG8UYEWUII9A',NULL),(3,50,'OUBFHDXLVYCZ',NULL),(1,39,'QFZANGEPWU9W',NULL),(4,67,'QUQLXI7GOH52',NULL),(3,44,'QZZGVIHDQLIN',NULL),(5,79,'S9PELFVFV5MF',NULL),(3,51,'SQVGE7OZBKWU',NULL),(5,82,'TDKI7MSX1Q5T',NULL),(5,74,'TJPAYLIIAHBP',NULL),(3,43,'TO76ER1WJ7BP',NULL),(4,58,'TPULFFNCTLHP',NULL),(3,48,'TQQCRG9CIFSL',NULL),(1,33,'TTXFLDURJIXV',NULL),(4,65,'TX92JBNDFQ62',NULL),(5,72,'VEKFQJVSR61E',NULL),(5,81,'WQDLIYDVZMOQ',NULL),(3,49,'YN0MIWA2QTFA',NULL),(3,41,'YYXLNM9MUTP3',NULL),(5,78,'ZN8SHDLBX5QE',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,31,'Quidem quisquam id occaecati enim porro quo tempore. Velit sunt quo earum temporibus et ut.',NULL,0,NULL,NULL),(1,28,'Dolor molestiae est magnam enim quisquam. Aspernatur dolor autem laborum numquam.',NULL,1,NULL,NULL),(1,16,'Doloribus natus laudantium nulla sit. Ea iste qui aliquam ullam. Doloremque aut impedit eos omnis.',NULL,2,NULL,NULL),(1,8,'Voluptatem molestiae et neque rerum sit aliquid consectetur quia. Eius et est aliquam.',NULL,3,NULL,NULL),(2,30,'Delectus et sapiente omnis minima quia. Et quisquam labore molestias dolorum possimus vitae.',NULL,0,NULL,NULL),(2,28,'Non architecto et consequatur amet quis nulla fugit. Animi dolores repellat animi sequi quia.',NULL,1,NULL,NULL),(2,31,'Eos dolorem qui voluptates. Esse nobis consequatur accusantium recusandae incidunt.',NULL,2,NULL,NULL),(3,4,'Et sapiente aut neque sed omnis ut saepe. Officiis consequatur accusamus possimus dolorem dolores.',NULL,0,NULL,NULL),(3,8,'Rem placeat qui tempora tempore. Vel voluptatibus est dolor repellendus alias et beatae.',NULL,1,NULL,NULL),(3,31,'Rerum voluptas ut natus. Nobis optio facere inventore sed sed quia.',NULL,3,NULL,NULL),(4,22,'Iste ut rerum rerum incidunt minima. Enim ea magni vel modi cupiditate. Ratione harum et at.',NULL,0,NULL,NULL),(4,28,'Reprehenderit et voluptatibus impedit molestias. Ipsam pariatur voluptatum id nobis illum eum.',NULL,1,NULL,NULL),(4,4,'Quo rem in sed quod. Labore rerum reprehenderit eos recusandae qui. Ea impedit quam omnis qui.',NULL,2,NULL,NULL),(4,31,'Nisi id labore magni. Iste iste excepturi quos qui.',NULL,3,NULL,NULL),(5,28,'Possimus sit suscipit unde voluptatum dolorem. Quos harum omnis ipsum ut ex perspiciatis.',NULL,0,NULL,NULL),(5,27,'Ex a ut quos rerum. Porro qui assumenda unde porro quaerat non expedita.',NULL,2,NULL,NULL),(6,11,'Dolores error sed voluptatem. Veniam sed omnis est atque. Doloribus nihil nulla minus ipsam id.',NULL,0,NULL,NULL),(6,14,'Deserunt ut odit amet eius debitis ea non. Aliquam debitis sit praesentium autem.',NULL,1,NULL,NULL),(6,30,'Aut ut molestiae minus et. Consequatur alias itaque sint recusandae.',NULL,3,NULL,NULL),(7,27,'Dolor non rerum aut ut eveniet. In incidunt aut odit sed. Et vel atque quia sequi.',NULL,0,NULL,NULL),(7,5,'Occaecati soluta minus cum voluptas aut omnis. Sapiente iure facilis aut architecto quis et.',NULL,1,NULL,NULL),(7,22,'Laudantium facilis dolor expedita maiores et est. Repudiandae corporis quae et iusto eos soluta.',NULL,2,NULL,NULL),(7,11,'Voluptas officia tempora nesciunt. Omnis autem vero dicta ex. Quis laborum sed fugiat.',NULL,3,NULL,NULL),(8,27,'Est rerum neque numquam. Voluptate omnis et ducimus facere. Labore commodi rerum sint at est.',NULL,0,NULL,NULL),(8,11,'Ullam aut odit magni explicabo. Qui laboriosam et officia. Odit fugit nulla quidem velit.',NULL,1,NULL,NULL),(8,22,'Et id quas ut quis a ea sunt consequatur. Et adipisci quod amet tempora omnis.',NULL,2,NULL,NULL),(8,31,'Rem sit perferendis aut. Aut sit error ipsa dolor aut. Nobis rerum culpa ut qui et omnis.',NULL,3,NULL,NULL),(9,5,'Tempora similique id temporibus vel accusamus. Accusamus rerum recusandae et.',NULL,0,NULL,NULL),(9,3,'Sint animi et dolor itaque. Eligendi fuga voluptates libero magnam inventore laborum.',NULL,1,NULL,NULL),(9,11,'Id itaque dicta eaque maiores molestiae et. Et libero quidem voluptas omnis cupiditate qui rem.',NULL,2,NULL,NULL),(9,24,'Enim sequi sed voluptates qui. Repellat molestiae ea quam optio qui animi necessitatibus.',NULL,3,NULL,NULL),(10,22,'Nisi cum ea nesciunt. Eaque eum assumenda non ut doloremque quia. Magni blanditiis neque eligendi.',NULL,0,NULL,NULL),(10,16,'Exercitationem ut ut et ipsam. At est cumque sed sint omnis vel odio.',NULL,1,NULL,NULL),(10,24,'Pariatur tenetur omnis recusandae aut. Repellendus enim aut sed id et dolore molestias.',NULL,2,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',18,'Alias placeat voluptatem perspiciatis eos.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','2b60d356-db48-3f79-84a7-0430dc1d387f','main/events/1.webp',48.10,'5401 Brakus Crossroad\nNorth Lionelfurt, OR 91022',6,NULL,NULL,'36.059728','-84.132245',50,0,'2025-06-10 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(2,'Mobile World Congress',17,'Minima est aliquid unde ut porro expedita.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5bc818bc-ea25-3435-814d-f3dbb4ea76a3','main/events/2.webp',4.27,'247 Dorian Plains Apt. 494\nHintzport, AK 78743-6539',1,6,6,'26.488891','-126.092788',70,0,'2025-06-10 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(3,'Google I/O',17,'Reiciendis saepe eos eos dolores nisi.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','fea44adf-b509-3ac8-9575-13ccb96f8d25','main/events/3.webp',57.12,'614 Hoppe Highway Apt. 393\nEast Ivahfort, HI 24947',4,4,4,'-33.995449','-71.520259',61,0,'2025-06-10 09:00:00','2025-06-25 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(4,'Apple WWDC',18,'Dolorem totam rerum aliquid doloribus earum est quia.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','88163624-47a2-33f7-944c-7bd7f8abd1ad','main/events/4.webp',80.38,'2767 Jeanne Prairie\nNorth Jaimeshire, WY 46648-4180',5,5,5,'66.751886','93.563289',56,0,'2025-06-10 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(5,'AWS re:Invent',15,'Rerum odio quas repellat est explicabo velit.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','537f3964-d875-3285-a9fa-11d358bc8348','main/events/5.webp',19.30,'95418 Flatley Forge Suite 373\nWelchmouth, MS 94372-0668',3,NULL,NULL,'-38.229874','133.300314',58,0,'2025-06-11 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(6,'Microsoft Build',15,'Facilis impedit cumque eaque in quae.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','ba29e370-46b7-3e2f-a1a2-9da4adf8a7ae','main/events/6.webp',7.17,'499 Mose Course\nConnellyville, MO 96772',5,5,5,'-81.608651','88.160153',98,0,'2025-06-11 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(7,'Facebook F8',17,'Nihil nemo ea iste beatae doloribus est excepturi.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','f438b52b-407c-32bf-a400-735fb577ce29','main/events/7.webp',7.42,'68169 Hayes River\nAlvastad, WY 46832',3,NULL,NULL,'45.878473','-22.185902',71,0,'2025-06-11 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(8,'GitHub Universe',6,'Cupiditate nostrum aperiam illo aut facilis.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','299d7288-e357-33ce-a31e-0a5c6e28407b','main/events/8.webp',77.16,'103 Juston Avenue Apt. 749\nBudmouth, IA 67689-5602',3,NULL,NULL,'16.486961','-99.511987',85,0,'2025-06-11 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(9,'Game Developers Conference',26,'Ab rerum et eaque eos.','The largest conference in the gaming industry, focusing on game development and gaming technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','b643fd18-aa7c-30f0-9dbe-7a8c1da3c2de','main/events/9.webp',56.80,'3286 Schoen Hill\nNew Jazminburgh, KY 77673-9664',5,5,5,'-27.062403','55.021077',52,0,'2025-06-12 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(10,'Web Summit',18,'Aut ea aperiam omnis dolores.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','62fb1d44-e0ad-3cca-bef9-217a82b39942','main/events/10.webp',58.52,'2082 Mose Throughway Apt. 134\nTracefurt, VT 87127',2,2,2,'70.075125','26.247612',80,0,'2025-06-12 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:40:47','2025-06-10 10:40:47');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Dr. Tanya Jones I - fweissnat@hermiston.info','fweissnat@hermiston.info','0756169317',1,48.10,48.10,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Mckenna Schumm II - kovacek.duane@schaden.net','kovacek.duane@schaden.net','0830558371',1,48.10,48.10,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Cathy Waelchi - ahmad.padberg@johnson.com','ahmad.padberg@johnson.com','0149013326',1,48.10,48.10,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Garland Price - qmacejkovic@gmail.com','qmacejkovic@gmail.com','0516736888',1,48.10,48.10,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(5,2,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Mr. Jordi Spencer - marcus74@hotmail.com','marcus74@hotmail.com','0489514008',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Dr. Brock Paucek III - jmann@franecki.com','jmann@franecki.com','0829234308',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Prof. Simone Nolan DVM - kovacek.zakary@hotmail.com','kovacek.zakary@hotmail.com','0574392669',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(8,3,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Arnaldo Orn DVM - herzog.marge@parisian.info','herzog.marge@parisian.info','0939268796',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Lola Mann - ondricka.kassandra@hermiston.com','ondricka.kassandra@hermiston.com','0695575543',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Dr. Afton Douglas I - noble68@bailey.com','noble68@bailey.com','0541266673',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Robyn Shields - uhomenick@yahoo.com','uhomenick@yahoo.com','0377013207',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(12,4,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Audie Terry - halvorson.blaze@jakubowski.info','halvorson.blaze@jakubowski.info','0134088630',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Calista Batz - vgulgowski@reichert.net','vgulgowski@reichert.net','0023111131',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(14,5,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Nicholas Reinger - lowe.noemi@hotmail.com','lowe.noemi@hotmail.com','0661511748',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(15,5,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Ms. Zola Osinski III - xritchie@gmail.com','xritchie@gmail.com','0173799181',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(16,5,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Yolanda Schimmel - schultz.lyla@leannon.info','schultz.lyla@leannon.info','0975946310',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Bernhard Okuneva MD - kuphal.oswaldo@yahoo.com','kuphal.oswaldo@yahoo.com','0618004874',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Raphaelle Keebler Jr. - ahmed12@bergnaum.com','ahmed12@bergnaum.com','0319207795',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(19,6,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Mr. Michael Monahan - crystal03@hotmail.com','crystal03@hotmail.com','0077560844',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Breanna Kerluke - javon96@yahoo.com','javon96@yahoo.com','0883761963',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(21,7,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Lura Satterfield - hermann.arianna@yahoo.com','hermann.arianna@yahoo.com','0479978360',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(22,7,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Dr. Lukas Bartell V - llynch@bauch.biz','llynch@bauch.biz','0937354378',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(23,8,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Miss Assunta Hodkiewicz I - lucious39@bergstrom.net','lucious39@bergstrom.net','0443298208',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(24,8,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Jerod Goldner - spadberg@reichert.com','spadberg@reichert.com','0316213537',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(25,9,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Mrs. Nyah Jacobs MD - torphy.leslie@jacobi.com','torphy.leslie@jacobi.com','0807081188',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(26,9,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Dr. Cameron Schamberger - quigley.carmel@gmail.com','quigley.carmel@gmail.com','0296407594',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(27,9,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Genesis Kertzmann - madalyn48@gmail.com','madalyn48@gmail.com','0443334188',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(28,9,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Mr. Darryl Raynor - dicki.icie@yahoo.com','dicki.icie@yahoo.com','0066510208',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(29,10,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Phyllis Macejkovic - eudora.brakus@volkman.org','eudora.brakus@volkman.org','0945168176',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(30,10,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Godfrey Wolff - gaylord.isaac@gerlach.com','gaylord.isaac@gerlach.com','0805208545',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(31,10,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Vinnie Russel Sr. - wdare@hotmail.com','wdare@hotmail.com','0835116950',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(32,10,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Dr. Darby Johnston - wstrosin@rogahn.com','wstrosin@rogahn.com','0139103403',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(33,10,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Kristofer Spinka - lesly.king@wyman.com','lesly.king@wyman.com','0530608784',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(34,10,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Angela Gerhold - bryana84@gmail.com','bryana84@gmail.com','0007120226',1,48.10,48.10,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(35,11,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'Mobile World Congress - Mercedes Heidenreich MD - powlowski.onie@schinner.com','powlowski.onie@schinner.com','0312063125',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(36,11,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'Mobile World Congress - Dr. Walker Rosenbaum I - chaz76@lockman.com','chaz76@lockman.com','0524004998',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(37,11,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'Mobile World Congress - Carlotta Koch DDS - elaina46@hotmail.com','elaina46@hotmail.com','0310288638',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(38,12,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'Mobile World Congress - Jaida Sauer - gmcglynn@yahoo.com','gmcglynn@yahoo.com','0836520653',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(39,12,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'Mobile World Congress - Judy Veum - sallie55@hotmail.com','sallie55@hotmail.com','0184283855',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(40,12,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'Mobile World Congress - Celestino Hand - waelchi.geovanny@hotmail.com','waelchi.geovanny@hotmail.com','0982182173',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(41,12,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'Mobile World Congress - Prof. Melany Jerde Jr. - kiel.cummerata@hamill.com','kiel.cummerata@hamill.com','0937873707',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(42,12,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'Mobile World Congress - Willa Simonis - mariana92@hammes.com','mariana92@hammes.com','0049570974',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(43,13,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Jan Barton - hane.berniece@gmail.com','hane.berniece@gmail.com','0473143086',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(44,13,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Prof. Stewart Hahn - esmeralda.boyer@yahoo.com','esmeralda.boyer@yahoo.com','0909255113',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(45,13,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Daphney Franecki - ttremblay@muller.info','ttremblay@muller.info','0742936503',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(46,13,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Stephen Mertz - weimann.zachariah@gmail.com','weimann.zachariah@gmail.com','0687625196',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(47,13,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Jaiden Stamm MD - marquise57@koss.net','marquise57@koss.net','0824851024',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(48,13,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Leta Tremblay - lenny.hartmann@swift.com','lenny.hartmann@swift.com','0086768353',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(49,14,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Angelo Nicolas - melody.okuneva@yahoo.com','melody.okuneva@yahoo.com','0737126660',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(50,14,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Prof. Dulce Langosh - kkassulke@kozey.com','kkassulke@kozey.com','0527581327',1,4.27,4.27,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(51,15,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Alena Schroeder - wwyman@hammes.com','wwyman@hammes.com','0759428224',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(52,15,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Maude Shanahan Sr. - mya.collins@skiles.com','mya.collins@skiles.com','0856888257',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(53,15,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Alfonzo Luettgen - dortha81@yahoo.com','dortha81@yahoo.com','0562857587',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(54,15,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Miss Marianne Reinger - schimmel.stefan@boehm.com','schimmel.stefan@boehm.com','0011045599',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(55,16,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Miss Arlene Kozey V - lizeth66@yahoo.com','lizeth66@yahoo.com','0482518019',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(56,16,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Hiram Gutmann - bret.batz@keeling.com','bret.batz@keeling.com','0827037504',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(57,16,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Orin Rohan - monty95@johns.biz','monty95@johns.biz','0820085029',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(58,16,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Mr. Zion Eichmann - sipes.marisol@yahoo.com','sipes.marisol@yahoo.com','0923278835',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(59,16,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Emily Mayert - cruickshank.lavada@hotmail.com','cruickshank.lavada@hotmail.com','0197736618',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(60,17,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Chesley Mills - pdietrich@gmail.com','pdietrich@gmail.com','0479927073',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(61,17,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Prof. Alexandria Kub Jr. - jaskolski.colby@hudson.com','jaskolski.colby@hudson.com','0573330486',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(62,17,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Miss Cara VonRueden II - linnea.zemlak@koss.com','linnea.zemlak@koss.com','0680857332',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(63,17,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Grayce Lesch - ifeil@altenwerth.com','ifeil@altenwerth.com','0089939774',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(64,17,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Miss Drew Murray I - wiza.viola@hotmail.com','wiza.viola@hotmail.com','0731030483',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(65,18,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Dr. Darron Connelly DDS - uboehm@rosenbaum.net','uboehm@rosenbaum.net','0535586805',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(66,18,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Bradly Stamm - kiarra44@hotmail.com','kiarra44@hotmail.com','0608185329',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(67,19,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Mrs. Elenor Schmidt - barton.magdalen@runte.com','barton.magdalen@runte.com','0422023095',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(68,19,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Miss Ocie Okuneva I - michel65@lockman.com','michel65@lockman.com','0706820823',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(69,19,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Rocio Deckow - sfunk@ferry.info','sfunk@ferry.info','0507665771',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(70,19,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Jermaine Maggio - delbert.goyette@nienow.org','delbert.goyette@nienow.org','0365152755',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(71,19,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Matilda Mayer - dleffler@yahoo.com','dleffler@yahoo.com','0518194257',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(72,20,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Rosalyn McKenzie DVM - alessandra.kuvalis@yahoo.com','alessandra.kuvalis@yahoo.com','0352335597',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(73,20,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Mallie Ferry - marley57@tillman.org','marley57@tillman.org','0843300398',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(74,20,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Prof. Frank Skiles Sr. - lyda23@kozey.com','lyda23@kozey.com','0015072379',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Allie Maggio - anderson.arnulfo@yahoo.com','anderson.arnulfo@yahoo.com','0144557001',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(76,20,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Jett Connelly - muriel.hettinger@mclaughlin.com','muriel.hettinger@mclaughlin.com','0860794991',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(77,20,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Reynold Koelpin - darrion.feil@dach.com','darrion.feil@dach.com','0034591243',1,4.27,4.27,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(78,21,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Eva Kirlin - destin38@yahoo.com','destin38@yahoo.com','0831308201',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(79,21,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Zula Kreiger - nebert@hotmail.com','nebert@hotmail.com','0271357937',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(80,21,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Elmer Rolfson - keeling.emmy@yahoo.com','keeling.emmy@yahoo.com','0033778003',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(81,22,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - George Rempel - debert@murazik.com','debert@murazik.com','0861843554',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(82,22,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Sid O\'Keefe - yessenia.volkman@gmail.com','yessenia.volkman@gmail.com','0410745743',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(83,22,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Prof. Margret Treutel - mayer.ayden@gmail.com','mayer.ayden@gmail.com','0490588562',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(84,22,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Prof. Ara Marquardt - glover.raphael@gmail.com','glover.raphael@gmail.com','0729206847',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(85,23,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Demario O\'Kon - kgoodwin@stoltenberg.com','kgoodwin@stoltenberg.com','0124272346',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(86,23,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Dr. Davion Kuvalis - flatley.melody@gmail.com','flatley.melody@gmail.com','0067262167',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(87,23,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Heaven Price - maida.von@gmail.com','maida.von@gmail.com','0929426334',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(88,24,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Dariana Koss DDS - ryann63@yahoo.com','ryann63@yahoo.com','0076219104',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(89,24,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Mr. Ahmed Predovic - sydney35@hackett.biz','sydney35@hackett.biz','0361218509',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(90,24,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Linnea Leffler - waylon31@powlowski.com','waylon31@powlowski.com','0863064034',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(91,25,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Saige Waters - isadore.cartwright@sipes.org','isadore.cartwright@sipes.org','0676874201',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(92,25,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Kurt McLaughlin - oswaldo07@barton.com','oswaldo07@barton.com','0042505508',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(93,25,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Prof. Rhett Hagenes DDS - ortiz.mathew@gmail.com','ortiz.mathew@gmail.com','0866410129',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(94,26,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Johanna Metz - lea.yost@goldner.com','lea.yost@goldner.com','0599492846',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(95,26,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Adriana Gerlach - bosco.kristopher@kuvalis.com','bosco.kristopher@kuvalis.com','0820546510',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(96,26,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Eleanora Schmitt - cyost@adams.org','cyost@adams.org','0868329718',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(97,27,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Mr. Leo Maggio DVM - lindsey.kozey@torphy.biz','lindsey.kozey@torphy.biz','0416229875',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(98,27,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Stevie Jast III - ethel.torphy@medhurst.com','ethel.torphy@medhurst.com','0240802453',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(99,28,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Torrey Skiles - cassandre.pfannerstill@yahoo.com','cassandre.pfannerstill@yahoo.com','0981322418',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(100,28,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Dr. Theodora Rolfson - niko62@yahoo.com','niko62@yahoo.com','0514542702',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(101,28,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Nick Walker - manuel.hartmann@buckridge.org','manuel.hartmann@buckridge.org','0311814301',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(102,28,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Toni Ritchie - guiseppe54@yahoo.com','guiseppe54@yahoo.com','0893816089',1,57.12,57.12,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(103,28,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Casey Torphy - amara.barrows@hotmail.com','amara.barrows@hotmail.com','0441329513',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(104,29,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Roosevelt Cassin - madelyn13@hotmail.com','madelyn13@hotmail.com','0930366350',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(105,29,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Prof. Amie O\'Connell Sr. - bhoeger@wunsch.biz','bhoeger@wunsch.biz','0338171815',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(106,29,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Elwin Waters Jr. - littel.annabell@davis.org','littel.annabell@davis.org','0614947408',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(107,30,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Mr. Jamey Hodkiewicz MD - jrutherford@hotmail.com','jrutherford@hotmail.com','0301256222',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(108,30,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Miss Lyla Greenfelder Sr. - selina70@hotmail.com','selina70@hotmail.com','0546757461',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(109,30,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Mr. Vincenzo Crona DDS - harber.maymie@kohler.com','harber.maymie@kohler.com','0089500692',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(110,30,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Ms. Adaline Sporer V - chand@gmail.com','chand@gmail.com','0684491124',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(111,30,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Tia Jaskolski - turcotte.erin@prohaska.info','turcotte.erin@prohaska.info','0077676973',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(112,30,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Orland Steuber - augustine99@durgan.com','augustine99@durgan.com','0573080854',1,57.12,57.12,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(113,31,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Apple WWDC - Keshaun Langosh - dickens.jordi@kiehn.org','dickens.jordi@kiehn.org','0390763324',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(114,31,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Apple WWDC - Madonna Runte - yolanda97@hotmail.com','yolanda97@hotmail.com','0918874263',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(115,31,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Apple WWDC - David Hintz - steuber.braeden@hirthe.com','steuber.braeden@hirthe.com','0025134350',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(116,31,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Apple WWDC - Demarcus Gottlieb - nwisozk@volkman.info','nwisozk@volkman.info','0902830565',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(117,31,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Apple WWDC - Israel Franecki DDS - tabitha.doyle@hotmail.com','tabitha.doyle@hotmail.com','0599983006',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(118,31,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Apple WWDC - Charlie Schmidt PhD - bernhard.isac@huels.net','bernhard.isac@huels.net','0403892960',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(119,32,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Apple WWDC - Morgan Bechtelar - cbrown@franecki.net','cbrown@franecki.net','0366339748',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(120,32,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Dr. Erna Bradtke III - fahey.melyna@mcclure.net','fahey.melyna@mcclure.net','0988469395',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(121,32,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Ms. Thea Cormier II - wleuschke@yahoo.com','wleuschke@yahoo.com','0458917969',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(122,32,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Bartholome Armstrong - vcruickshank@hotmail.com','vcruickshank@hotmail.com','0288608807',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(123,33,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Loyal Jast - pfannerstill.dedrick@white.biz','pfannerstill.dedrick@white.biz','0303015464',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(124,33,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Dr. Daphney Watsica DVM - marquardt.tiana@yahoo.com','marquardt.tiana@yahoo.com','0552327047',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(125,34,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Alec Sporer PhD - reichert.camille@anderson.biz','reichert.camille@anderson.biz','0684486230',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(126,34,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Miss Kacie Graham MD - syble.luettgen@berge.com','syble.luettgen@berge.com','0162960508',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(127,34,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Wilfred Johnston Jr. - rolfson.abby@boehm.com','rolfson.abby@boehm.com','0597591152',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(128,34,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Patience Powlowski - bernice81@hotmail.com','bernice81@hotmail.com','0745990249',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(129,34,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Prof. Aric Pfannerstill III - stokes.justus@schuster.org','stokes.justus@schuster.org','0194158971',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(130,35,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Patsy Mayer - hettinger.claudie@doyle.net','hettinger.claudie@doyle.net','0440255065',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(131,35,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Jonatan Schinner - kilback.mariane@strosin.com','kilback.mariane@strosin.com','0088172441',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(132,35,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Price Greenfelder - connelly.doug@gmail.com','connelly.doug@gmail.com','0209211037',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(133,35,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Mr. Loyal Hoeger - kiara26@yahoo.com','kiara26@yahoo.com','0713908844',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(134,35,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Edna Schimmel - abbigail.ernser@boehm.com','abbigail.ernser@boehm.com','0287510513',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(135,36,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Rahul Crooks - braeden21@goyette.com','braeden21@goyette.com','0986506455',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(136,36,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Lessie Balistreri - camryn89@hotmail.com','camryn89@hotmail.com','0694058324',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(137,37,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Mr. Filiberto Harvey Jr. - sharvey@gmail.com','sharvey@gmail.com','0787939749',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(138,37,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Adelbert Abbott - kovacek.emelie@kub.net','kovacek.emelie@kub.net','0947547069',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(139,37,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Violette Thompson - lcollins@jones.net','lcollins@jones.net','0258016247',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(140,37,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Mrs. Trudie Predovic - nienow.paris@dibbert.com','nienow.paris@dibbert.com','0402265942',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(141,37,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Prof. Kallie Hagenes - etorphy@yahoo.com','etorphy@yahoo.com','0662186704',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(142,38,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Citlalli Doyle - dean26@champlin.biz','dean26@champlin.biz','0115470202',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(143,38,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Mrs. Maria Zieme - ucremin@okon.info','ucremin@okon.info','0880193614',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(144,38,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Mrs. Vita Ferry - jadyn.mclaughlin@schoen.net','jadyn.mclaughlin@schoen.net','0550359015',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(145,38,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Dena Ward - patience.crona@hill.com','patience.crona@hill.com','0564871919',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(146,38,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Kiley Harris Jr. - marquis56@yahoo.com','marquis56@yahoo.com','0644596643',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(147,39,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Dashawn Dickinson - rhiannon.halvorson@leuschke.com','rhiannon.halvorson@leuschke.com','0358097028',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(148,39,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Dr. Magnus Yundt - caterina03@schmeler.com','caterina03@schmeler.com','0007639723',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(149,39,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Catharine Ondricka - courtney.wintheiser@hyatt.net','courtney.wintheiser@hyatt.net','0825205933',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(150,40,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Jaeden Sawayn - laney12@bayer.org','laney12@bayer.org','0017972846',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(151,40,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Mabelle Legros - albertha79@hotmail.com','albertha79@hotmail.com','0657527149',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(152,40,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Prof. Aletha O\'Hara - vbeatty@cronin.net','vbeatty@cronin.net','0081502065',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(153,40,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Mrs. Gregoria Crooks DDS - ybradtke@stamm.biz','ybradtke@stamm.biz','0301533711',1,80.38,80.38,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(154,41,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'AWS re:Invent - Miss Justina Langworth - luisa25@gmail.com','luisa25@gmail.com','0007624450',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(155,41,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'AWS re:Invent - Zelda Koepp - raphaelle02@zboncak.com','raphaelle02@zboncak.com','0256044946',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(156,41,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'AWS re:Invent - Dr. Jovanny Bogisich Sr. - psporer@heathcote.com','psporer@heathcote.com','0932867047',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(157,41,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'AWS re:Invent - Prof. Bailey Rolfson - beier.emory@schimmel.com','beier.emory@schimmel.com','0142509708',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(158,41,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'AWS re:Invent - Conor Kunze - mayer.ephraim@rippin.com','mayer.ephraim@rippin.com','0337775600',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(159,41,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'AWS re:Invent - Domenick Bosco - elfrieda61@little.org','elfrieda61@little.org','0848730981',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(160,42,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'AWS re:Invent - Joesph Braun - ukonopelski@hotmail.com','ukonopelski@hotmail.com','0459930481',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(161,42,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'AWS re:Invent - Cornelius Schiller - cwalker@hotmail.com','cwalker@hotmail.com','0518148396',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(162,43,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Aniya Daniel - kamren89@gmail.com','kamren89@gmail.com','0705688995',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(163,43,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Petra Rolfson - runte.glenna@hotmail.com','runte.glenna@hotmail.com','0892745032',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(164,43,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Stefan Bradtke - norval.block@hotmail.com','norval.block@hotmail.com','0014196139',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(165,43,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Michele Ziemann - alyson.carroll@gmail.com','alyson.carroll@gmail.com','0920529029',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(166,43,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Mr. Al Kuvalis DDS - muller.olga@fahey.com','muller.olga@fahey.com','0014902810',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(167,43,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Cristina Berge - berge.kristin@hotmail.com','berge.kristin@hotmail.com','0729906860',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(168,44,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Dr. Matilde Adams PhD - mante.patience@gmail.com','mante.patience@gmail.com','0828309955',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(169,44,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Miss Alize Keeling - xreilly@hotmail.com','xreilly@hotmail.com','0206699919',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(170,45,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Tyrique Dicki - garfield.ferry@gmail.com','garfield.ferry@gmail.com','0706668788',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(171,45,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Myriam Huel - barrett67@murazik.info','barrett67@murazik.info','0979253217',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(172,46,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Jaden Greenfelder - aryanna.veum@boyer.com','aryanna.veum@boyer.com','0492502681',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(173,46,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Serena Ferry - eliane48@dibbert.com','eliane48@dibbert.com','0448649445',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(174,46,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Ernesto Jenkins V - king.clyde@rice.com','king.clyde@rice.com','0152767207',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(175,47,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Javier Graham - ubatz@rice.com','ubatz@rice.com','0724819986',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(176,47,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Brielle Gerlach - maximo.gleichner@yahoo.com','maximo.gleichner@yahoo.com','0678486004',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(177,47,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Miss Violette Hegmann PhD - dangelo40@kohler.net','dangelo40@kohler.net','0635135971',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(178,48,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Sarah Wolf - franecki.leland@krajcik.com','franecki.leland@krajcik.com','0853100858',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(179,48,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Dr. Llewellyn Brekke I - erica87@kemmer.com','erica87@kemmer.com','0026067957',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(180,49,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Darrel Howe - cole.dortha@hotmail.com','cole.dortha@hotmail.com','0453667196',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(181,49,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Domenic Hermiston - van.welch@hotmail.com','van.welch@hotmail.com','0796191262',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(182,49,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Dr. Norwood Bruen - skreiger@yahoo.com','skreiger@yahoo.com','0036650217',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(183,49,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Mossie O\'Reilly II - casandra94@yahoo.com','casandra94@yahoo.com','0415835355',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(184,49,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Ida Rempel - esteban.hudson@kulas.biz','esteban.hudson@kulas.biz','0063042132',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(185,50,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Christelle Hand - eheller@mohr.com','eheller@mohr.com','0250271315',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(186,50,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Ms. Madalyn Nikolaus PhD - littel.cedrick@yahoo.com','littel.cedrick@yahoo.com','0230521258',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(187,50,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Liza Herman - rohan.maureen@ullrich.org','rohan.maureen@ullrich.org','0522343697',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(188,50,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Brendan Roob - adriel.larson@moore.com','adriel.larson@moore.com','0279823172',1,19.30,19.30,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',48.10,'CES (Consumer Electronics Show)','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',144.30,144.30,0.00,0.00,NULL,1,'completed','2025-06-10 10:40:47','2025-06-10 10:40:47','2025-06-10 10:40:47'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',48.10,'CES (Consumer Electronics Show)','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',96.20,96.20,0.00,0.00,NULL,2,'completed','2025-06-10 10:40:48','2025-06-10 10:40:47','2025-06-10 10:40:48'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',48.10,'CES (Consumer Electronics Show)','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',144.30,144.30,0.00,0.00,NULL,3,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',48.10,'CES (Consumer Electronics Show)','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',48.10,48.10,0.00,0.00,NULL,4,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',48.10,'CES (Consumer Electronics Show)','Macy Yost Jr.','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',192.40,192.40,0.00,0.00,NULL,5,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',48.10,'CES (Consumer Electronics Show)','Effie Zboncak','aracely76@johns.com',NULL,'ArchiElite','main/general/logo-light.png',48.10,48.10,0.00,0.00,NULL,6,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',48.10,'CES (Consumer Electronics Show)','Edwin Miller MD','zschoen@wiegand.com',NULL,'ArchiElite','main/general/logo-light.png',48.10,48.10,0.00,0.00,NULL,7,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',48.10,'CES (Consumer Electronics Show)','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',48.10,48.10,0.00,0.00,NULL,8,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',48.10,'CES (Consumer Electronics Show)','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',144.30,144.30,0.00,0.00,NULL,9,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',48.10,'CES (Consumer Electronics Show)','Edwin Miller MD','zschoen@wiegand.com',NULL,'ArchiElite','main/general/logo-light.png',240.50,240.50,0.00,0.00,NULL,10,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',4.27,'Mobile World Congress','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',8.54,8.54,0.00,0.00,NULL,11,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',4.27,'Mobile World Congress','Blanche Maggio','goldner.malachi@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',17.08,17.08,0.00,0.00,NULL,12,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',4.27,'Mobile World Congress','Carlee Hansen','kevon74@konopelski.com',NULL,'ArchiElite','main/general/logo-light.png',21.35,21.35,0.00,0.00,NULL,13,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',4.27,'Mobile World Congress','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',4.27,4.27,0.00,0.00,NULL,14,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',4.27,'Mobile World Congress','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',12.81,12.81,0.00,0.00,NULL,15,'completed','2025-06-10 10:40:48','2025-06-10 10:40:48','2025-06-10 10:40:48'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',4.27,'Mobile World Congress','Maegan Schulist','landen76@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',17.08,17.08,0.00,0.00,NULL,16,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',4.27,'Mobile World Congress','Macy Yost Jr.','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',17.08,17.08,0.00,0.00,NULL,17,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',4.27,'Mobile World Congress','Blanche Maggio','goldner.malachi@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',4.27,4.27,0.00,0.00,NULL,18,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',4.27,'Mobile World Congress','Prof. Zena Barrows','pasquale11@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',17.08,17.08,0.00,0.00,NULL,19,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',4.27,'Mobile World Congress','Edwin Miller MD','zschoen@wiegand.com',NULL,'ArchiElite','main/general/logo-light.png',21.35,21.35,0.00,0.00,NULL,20,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',57.12,'Google I/O','Macy Yost Jr.','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,21,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',57.12,'Google I/O','Carlee Hansen','kevon74@konopelski.com',NULL,'ArchiElite','main/general/logo-light.png',171.36,171.36,0.00,0.00,NULL,22,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',57.12,'Google I/O','Carlee Hansen','kevon74@konopelski.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,23,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',57.12,'Google I/O','Blanche Maggio','goldner.malachi@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,24,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',57.12,'Google I/O','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,25,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',57.12,'Google I/O','Macy Yost Jr.','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,26,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',57.12,'Google I/O','Edwin Miller MD','zschoen@wiegand.com',NULL,'ArchiElite','main/general/logo-light.png',57.12,57.12,0.00,0.00,NULL,27,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',57.12,'Google I/O','Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com',NULL,'ArchiElite','main/general/logo-light.png',228.48,228.48,0.00,0.00,NULL,28,'completed','2025-06-10 10:40:49','2025-06-10 10:40:49','2025-06-10 10:40:49'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',57.12,'Google I/O','Prof. Zena Barrows','pasquale11@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',114.24,114.24,0.00,0.00,NULL,29,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',57.12,'Google I/O','Maegan Schulist','landen76@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',285.60,285.60,0.00,0.00,NULL,30,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',80.38,'Apple WWDC','Prof. Zena Barrows','pasquale11@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',401.90,401.90,0.00,0.00,NULL,31,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',80.38,'Apple WWDC','Prof. Zena Barrows','pasquale11@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',241.14,241.14,0.00,0.00,NULL,32,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',80.38,'Apple WWDC','Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com',NULL,'ArchiElite','main/general/logo-light.png',80.38,80.38,0.00,0.00,NULL,33,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',80.38,'Apple WWDC','Prof. Zena Barrows','pasquale11@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',321.52,321.52,0.00,0.00,NULL,34,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',80.38,'Apple WWDC','Effie Zboncak','aracely76@johns.com',NULL,'ArchiElite','main/general/logo-light.png',321.52,321.52,0.00,0.00,NULL,35,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',80.38,'Apple WWDC','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',80.38,80.38,0.00,0.00,NULL,36,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',80.38,'Apple WWDC','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',321.52,321.52,0.00,0.00,NULL,37,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',80.38,'Apple WWDC','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',321.52,321.52,0.00,0.00,NULL,38,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',80.38,'Apple WWDC','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',160.76,160.76,0.00,0.00,NULL,39,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',80.38,'Apple WWDC','Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com',NULL,'ArchiElite','main/general/logo-light.png',241.14,241.14,0.00,0.00,NULL,40,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:50'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',19.30,'AWS re:Invent','Blanche Maggio','goldner.malachi@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',96.50,96.50,0.00,0.00,NULL,41,'completed','2025-06-10 10:40:50','2025-06-10 10:40:50','2025-06-10 10:40:51'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',19.30,'AWS re:Invent','Leanne Hartmann','willis.mann@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',19.30,19.30,0.00,0.00,NULL,42,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',19.30,'AWS re:Invent','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',96.50,96.50,0.00,0.00,NULL,43,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',19.30,'AWS re:Invent','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',19.30,19.30,0.00,0.00,NULL,44,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',19.30,'AWS re:Invent','Carlee Hansen','kevon74@konopelski.com',NULL,'ArchiElite','main/general/logo-light.png',19.30,19.30,0.00,0.00,NULL,45,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',19.30,'AWS re:Invent','Blanche Maggio','goldner.malachi@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',38.60,38.60,0.00,0.00,NULL,46,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',19.30,'AWS re:Invent','Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com',NULL,'ArchiElite','main/general/logo-light.png',38.60,38.60,0.00,0.00,NULL,47,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',19.30,'AWS re:Invent','Giles Mann','hammes.douglas@gmail.com',NULL,'ArchiElite','main/general/logo-light.png',19.30,19.30,0.00,0.00,NULL,48,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',19.30,'AWS re:Invent','Mr. Chesley Greenholt','hgaylord@mckenzie.com',NULL,'ArchiElite','main/general/logo-light.png',77.20,77.20,0.00,0.00,NULL,49,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',19.30,'AWS re:Invent','Maegan Schulist','landen76@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',57.90,57.90,0.00,0.00,NULL,50,'completed','2025-06-10 10:40:51','2025-06-10 10:40:51','2025-06-10 10:40:51');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'EMX3VHINB3AK','6be9c024-e61c-4665-8b98-0cd67d029a34',1,'CES (Consumer Electronics Show)',48.10,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','Alice after it, never once considering how in the way wherever she wanted much to know, but the.',NULL,'1',48.10,3,144.30,144.30,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(2,'YUZC9SU6LSIL','bf35b02b-753b-41d0-aa65-894bc00269ae',1,'CES (Consumer Electronics Show)',48.10,19,1,'Leanne Hartmann','willis.mann@gmail.com','Alice had been to a shriek, \'and just as I get SOMEWHERE,\' Alice added as an explanation. \'Oh.',NULL,'2',48.10,2,96.20,96.20,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47'),(3,'JCLN5NDSKVLU','3668a98e-a4ef-4df9-946d-7f16fbb547a0',1,'CES (Consumer Electronics Show)',48.10,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','Duchess sang the second time round, she found she had forgotten the words.\' So they couldn\'t get.',NULL,'3',48.10,3,144.30,144.30,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(4,'H5KV1KZVGRAP','2e144b4f-37c9-47da-ace6-d80645c17dfb',1,'CES (Consumer Electronics Show)',48.10,19,1,'Leanne Hartmann','willis.mann@gmail.com','Alice. \'Of course not,\' Alice replied in a helpless sort of present!\' thought Alice. \'I don\'t see.',NULL,'4',48.10,1,48.10,48.10,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(5,'HZGCOSYGPUEN','4639eea9-0726-4722-8bc1-7306b4fe8bd2',1,'CES (Consumer Electronics Show)',48.10,1,1,'Macy Yost Jr.','customer@archielite.com','Soup! Beau--ootiful Soo--oop! Soo--oop of the cupboards as she passed; it was not a moment to be.',NULL,'5',48.10,4,192.40,192.40,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(6,'C82GKKGUPTJQ','f3918c56-19fd-4c4c-84d8-62d7d2fccd7a',1,'CES (Consumer Electronics Show)',48.10,10,1,'Effie Zboncak','aracely76@johns.com','Footman went on in a minute or two, and the words came very queer to ME.\' \'You!\' said the King. On.',NULL,'6',48.10,1,48.10,48.10,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(7,'188SVSYCYNKF','a52f7fbd-8c5b-4e32-a24b-a8999494154d',1,'CES (Consumer Electronics Show)',48.10,7,1,'Edwin Miller MD','zschoen@wiegand.com','Alice think it so quickly that the mouse doesn\'t get out.\" Only I don\'t want YOU with us!\"\' \'They.',NULL,'7',48.10,1,48.10,48.10,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(8,'7LFKATNWVLKI','25942a81-98be-4199-ba64-1f36e686d3fe',1,'CES (Consumer Electronics Show)',48.10,9,1,'Giles Mann','hammes.douglas@gmail.com','Alice, very earnestly. \'I\'ve had nothing yet,\' Alice replied thoughtfully. \'They have their tails.',NULL,'8',48.10,1,48.10,48.10,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(9,'TLQSIC3B35XE','13286c8e-4f80-425b-9804-534cf0c21969',1,'CES (Consumer Electronics Show)',48.10,19,1,'Leanne Hartmann','willis.mann@gmail.com','Alice, \'to speak to this last word two or three pairs of tiny white kid gloves: she took courage.',NULL,'9',48.10,3,144.30,144.30,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(10,'XYG9YXDQEKJE','6e3c074f-b657-4deb-aaf9-fc674e335047',1,'CES (Consumer Electronics Show)',48.10,7,1,'Edwin Miller MD','zschoen@wiegand.com','I gave her one, they gave him two, You gave us three or more; They all returned from him to be.',NULL,'10',48.10,5,240.50,240.50,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(11,'2HCGMRNPLGJS','ce682a82-21d3-4cb7-a5f9-9811278a3bd2',2,'Mobile World Congress',4.27,19,1,'Leanne Hartmann','willis.mann@gmail.com','Shakespeare, in the schoolroom, and though this was of very little way out of the others all.',NULL,'11',4.27,2,8.54,8.54,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(12,'VJWJKP2WUMWU','621f6752-21c8-4a2e-9d69-a7b5db66fdee',2,'Mobile World Congress',4.27,29,1,'Blanche Maggio','goldner.malachi@yahoo.com','D,\' she added aloud. \'Do you play croquet?\' The soldiers were silent, and looked very.',NULL,'12',4.27,4,17.08,17.08,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(13,'ZNFXTXPNHOYD','bf3b6737-e637-4579-a94d-bd670888c677',2,'Mobile World Congress',4.27,20,1,'Carlee Hansen','kevon74@konopelski.com','Alice, very earnestly. \'I\'ve had nothing yet,\' Alice replied thoughtfully. \'They have their tails.',NULL,'13',4.27,5,21.35,21.35,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(14,'PTK7QJNGJURN','3afda1e2-4598-4653-a713-dc6eff845753',2,'Mobile World Congress',4.27,9,1,'Giles Mann','hammes.douglas@gmail.com','The Dormouse had closed its eyes were looking up into a graceful zigzag, and was going to begin at.',NULL,'14',4.27,1,4.27,4.27,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(15,'HUKLA9D4RZ46','84cb64bd-3fa4-46c8-b166-b975d2363e6d',2,'Mobile World Congress',4.27,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','Gryphon only answered \'Come on!\' cried the Gryphon, and all the same, the next moment she.',NULL,'15',4.27,3,12.81,12.81,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48'),(16,'ZE0A05CG9FAS','940b985d-fe74-4c19-b28b-7333dc60fbeb',2,'Mobile World Congress',4.27,12,1,'Maegan Schulist','landen76@yahoo.com','However, it was very likely true.) Down, down, down. There was no label this time the Queen was.',NULL,'16',4.27,4,17.08,17.08,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(17,'1ZGKLZR44JMC','ec1418f6-393c-4df4-b848-f77f04cd154d',2,'Mobile World Congress',4.27,1,1,'Macy Yost Jr.','customer@archielite.com','Hatter hurriedly left the court, without even waiting to put everything upon Bill! I wouldn\'t be.',NULL,'17',4.27,4,17.08,17.08,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(18,'KEZBTJKKHQ5I','0c75db59-5329-4819-aa5f-e24f025ea9fa',2,'Mobile World Congress',4.27,29,1,'Blanche Maggio','goldner.malachi@yahoo.com','I\'m talking!\' Just then her head impatiently; and, turning to the door, she ran off at once, in a.',NULL,'18',4.27,1,4.27,4.27,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(19,'KW6P9FDRVW40','0efdd67b-1b96-4038-b977-8c7defa4da3c',2,'Mobile World Congress',4.27,23,1,'Prof. Zena Barrows','pasquale11@yahoo.com','Mock Turtle said: \'advance twice, set to work shaking him and punching him in the kitchen. \'When.',NULL,'19',4.27,4,17.08,17.08,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(20,'Y44UHBRIT1JF','2e6ae88c-a94c-4f79-89b1-05b3a6aac2c5',2,'Mobile World Congress',4.27,7,1,'Edwin Miller MD','zschoen@wiegand.com','Just then her head in the sea, some children digging in the night? Let me see: that would happen.',NULL,'20',4.27,5,21.35,21.35,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(21,'CDG8GWNRUGOT','2119c680-c8ab-465f-b284-84b7a976e83a',3,'Google I/O',57.12,1,1,'Macy Yost Jr.','customer@archielite.com','Dormouse indignantly. However, he consented to go on crying in this affair, He trusts to you how.',NULL,'21',57.12,2,114.24,114.24,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(22,'3XYA4QGMDTVO','278a0485-4efa-46cc-a5a4-084ed4d9c51a',3,'Google I/O',57.12,20,1,'Carlee Hansen','kevon74@konopelski.com','I\'ve got to grow to my boy, I beat him when he sneezes: He only does it matter to me whether.',NULL,'22',57.12,3,171.36,171.36,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(23,'CO8V2CWCTKCU','50d62fc4-408e-41d8-8d1e-62ca779d91b8',3,'Google I/O',57.12,20,1,'Carlee Hansen','kevon74@konopelski.com','Conqueror, whose cause was favoured by the carrier,\' she thought; \'and how funny it\'ll seem to see.',NULL,'23',57.12,2,114.24,114.24,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(24,'4EEVKDJQOEOF','5771a916-83d4-4ac4-9eff-ddc1a5dfc2f7',3,'Google I/O',57.12,29,1,'Blanche Maggio','goldner.malachi@yahoo.com','DON\'T know,\' said Alice, \'but I haven\'t been invited yet.\' \'You\'ll see me there,\' said the.',NULL,'24',57.12,2,114.24,114.24,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(25,'VUFYYEQJTFGF','8f3678a0-72ad-48a3-8cba-431eb190090a',3,'Google I/O',57.12,9,1,'Giles Mann','hammes.douglas@gmail.com','Hatter: \'let\'s all move one place on.\' He moved on as he spoke, \'we were trying--\' \'I see!\' said.',NULL,'25',57.12,2,114.24,114.24,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(26,'AXT08WFS7LWG','9e46b037-b16e-4a5a-b9aa-2c527539ffb8',3,'Google I/O',57.12,1,1,'Macy Yost Jr.','customer@archielite.com','And the muscular strength, which it gave to my jaw, Has lasted the rest of the room. The cook.',NULL,'26',57.12,2,114.24,114.24,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(27,'HHXHXJDL4WJH','b569f7b0-1d86-4fe5-b34e-05751ee88d4a',3,'Google I/O',57.12,7,1,'Edwin Miller MD','zschoen@wiegand.com','I ever saw in my size; and as the whole party at once and put it in less than no time to begin.',NULL,'27',57.12,1,57.12,57.12,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(28,'IMTZZQGBZNTD','d720b1d8-a833-465d-bfdd-7c25dc03fcb1',3,'Google I/O',57.12,13,1,'Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com','The poor little juror (it was exactly three inches high). \'But I\'m NOT a serpent, I tell you!\' But.',NULL,'28',57.12,4,228.48,228.48,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49'),(29,'8X8IZ1FFOIT7','3caa2d01-35ad-4e8f-b2ef-e27c8ccd60ac',3,'Google I/O',57.12,23,1,'Prof. Zena Barrows','pasquale11@yahoo.com','Lory, who at last turned sulky, and would only say, \'I am older than I am in the book,\' said the.',NULL,'29',57.12,2,114.24,114.24,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(30,'EYNT8IRI6UBR','4ac69b04-5682-4b65-8b05-0cb0dc436ded',3,'Google I/O',57.12,12,1,'Maegan Schulist','landen76@yahoo.com','The poor little thing howled so, that he had never seen such a wretched height to be.\' \'It is a.',NULL,'30',57.12,5,285.60,285.60,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(31,'6RPH8FP8CLRL','fc249aaa-bb24-4abd-a057-cfff766733c7',4,'Apple WWDC',80.38,23,1,'Prof. Zena Barrows','pasquale11@yahoo.com','Once more she found she could get to twenty at that rate! However, the Multiplication Table.',NULL,'31',80.38,5,401.90,401.90,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(32,'RV0ZJAKUL5VJ','ffe841dd-d3ff-492e-b927-75237a9cc8ee',4,'Apple WWDC',80.38,23,1,'Prof. Zena Barrows','pasquale11@yahoo.com','Dormouse. \'Fourteenth of March, I think I should like to be seen--everything seemed to think to.',NULL,'32',80.38,3,241.14,241.14,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(33,'KZNHZ8SCA1J6','3e8f02d9-ea5e-4401-84f5-e53ed8836b4a',4,'Apple WWDC',80.38,13,1,'Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com','Gryphon, lying fast asleep in the flurry of the court,\" and I never knew whether it was certainly.',NULL,'33',80.38,1,80.38,80.38,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(34,'RJP4K7IWAEAY','36cbba40-8661-428e-b117-797221e28ee7',4,'Apple WWDC',80.38,23,1,'Prof. Zena Barrows','pasquale11@yahoo.com','No, there were three gardeners who were all talking together: she made her so savage when they met.',NULL,'34',80.38,4,321.52,321.52,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(35,'OVLHJDYJVWKK','cb1589b5-ff6f-4869-9e4d-840290e12f00',4,'Apple WWDC',80.38,10,1,'Effie Zboncak','aracely76@johns.com','King, \'and don\'t be nervous, or I\'ll have you executed.\' The miserable Hatter dropped his teacup.',NULL,'35',80.38,4,321.52,321.52,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(36,'W6RR4P9QCZCW','b005c97a-a1b7-47c2-bce0-5b2e82e7fdb8',4,'Apple WWDC',80.38,9,1,'Giles Mann','hammes.douglas@gmail.com','I hate cats and dogs.\' It was so much about a whiting to a lobster--\' (Alice began to cry again.',NULL,'36',80.38,1,80.38,80.38,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(37,'2FRJZPGEQ5RT','e5a8375d-0817-4fc8-b7f3-314333282684',4,'Apple WWDC',80.38,19,1,'Leanne Hartmann','willis.mann@gmail.com','By the use of repeating all that stuff,\' the Mock Turtle; \'but it seems to suit them!\' \'I haven\'t.',NULL,'37',80.38,4,321.52,321.52,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(38,'7ET94P1NDHKU','019e8a82-8b8f-4597-87f7-a0c170025f0e',4,'Apple WWDC',80.38,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','Duchess, \'as pigs have to turn into a tidy little room with a teacup in one hand and a bright.',NULL,'38',80.38,4,321.52,321.52,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(39,'FVF1MSRCWVGE','b991b3b3-7f74-44f6-ac22-47d4b22b15fc',4,'Apple WWDC',80.38,9,1,'Giles Mann','hammes.douglas@gmail.com','It was, no doubt: only Alice did not like the three gardeners at it, and found in it a minute or.',NULL,'39',80.38,2,160.76,160.76,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(40,'B4OJJ9VFBIKX','2941bec4-f6c8-4aa5-b7e4-dec2a8a2f38a',4,'Apple WWDC',80.38,13,1,'Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com','The Mock Turtle interrupted, \'if you only kept on puzzling about it in asking riddles that have no.',NULL,'40',80.38,3,241.14,241.14,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(41,'TJKXTD8ETUZI','2de4090a-d1f7-4711-a773-6a935d324427',5,'AWS re:Invent',19.30,29,1,'Blanche Maggio','goldner.malachi@yahoo.com','Pat, what\'s that in some book, but I grow up, I\'ll write one--but I\'m grown up now,\' she added.',NULL,'41',19.30,5,96.50,96.50,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50'),(42,'EYW8JIQCF9SD','d392a6d7-0264-4c5e-9fae-6cc86b078c7c',5,'AWS re:Invent',19.30,19,1,'Leanne Hartmann','willis.mann@gmail.com','Alice. \'I\'ve read that in about half no time! Take your choice!\' The Duchess took her choice, and.',NULL,'42',19.30,1,19.30,19.30,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(43,'ACKKJGICGVKL','e1f740cf-b0a1-4570-8be5-0f6ff3a6516b',5,'AWS re:Invent',19.30,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','The Mouse did not dare to laugh; and, as the Lory positively refused to tell its age, there was.',NULL,'43',19.30,5,96.50,96.50,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(44,'H4OEC6LBBO6F','55cbd5f8-37f4-40c7-882f-e7a9f2a52f9d',5,'AWS re:Invent',19.30,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','For this must ever be A secret, kept from all the right house, because the chimneys were shaped.',NULL,'44',19.30,1,19.30,19.30,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(45,'GPRX7OXN1KX0','ea6aa56f-13df-4f76-aa4a-ae856803e4ec',5,'AWS re:Invent',19.30,20,1,'Carlee Hansen','kevon74@konopelski.com','I must be shutting up like telescopes: this time the Queen ordering off her knowledge, as there.',NULL,'45',19.30,1,19.30,19.30,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(46,'ZDVHIBEBVVPM','6a6653d3-a9bb-4fa1-9ecb-3982ff2b68c4',5,'AWS re:Invent',19.30,29,1,'Blanche Maggio','goldner.malachi@yahoo.com','Caterpillar. This was quite out of the edge of the house, and the White Rabbit hurried by--the.',NULL,'46',19.30,2,38.60,38.60,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(47,'TMM14NRFVY0J','6578bab3-5d01-4c45-a487-ad430e0f16b6',5,'AWS re:Invent',19.30,13,1,'Mr. Aron Dietrich Jr.','marjolaine.denesik@tillman.com','He sent them word I had it written up somewhere.\' Down, down, down. Would the fall was over. Alice.',NULL,'47',19.30,2,38.60,38.60,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(48,'QCUMOCNSHF14','b72e43ef-1f65-4a7d-8173-84a3ddb4d11c',5,'AWS re:Invent',19.30,9,1,'Giles Mann','hammes.douglas@gmail.com','All this time the Mouse was speaking, so that her shoulders were nowhere to be no sort of use in.',NULL,'48',19.30,1,19.30,19.30,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(49,'KXSIAVZGYISK','a73b8dbc-1dd0-440b-9c67-6cb3cc2d11fe',5,'AWS re:Invent',19.30,21,1,'Mr. Chesley Greenholt','hgaylord@mckenzie.com','And yet you incessantly stand on their backs was the BEST butter, you know.\' \'Not the same thing.',NULL,'49',19.30,4,77.20,77.20,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51'),(50,'JXJDXVDLHYSK','ddd80880-e2ab-4797-b810-381d940ce480',5,'AWS re:Invent',19.30,12,1,'Maegan Schulist','landen76@yahoo.com','Mock Turtle. So she began thinking over other children she knew that were of the cattle in the.',NULL,'50',19.30,3,57.90,57.90,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'KPEOTPP8HNTZ','Dr. Tanya Jones I','fweissnat@hermiston.info','0756169317','I will tell you my adventures--beginning from this side of the water, and seemed to have no sort.',NULL,'checked_in','2025-06-10 10:40:47','2025-06-10 10:40:47'),(2,1,'MCX2JWUN9NFV','Mckenna Schumm II','kovacek.duane@schaden.net','0830558371','Gryphon, \'you first form into a tidy little room with a round face, and was beating her violently.',NULL,'pending','2025-06-10 10:40:47','2025-06-10 10:40:47'),(3,1,'L30XZ6QUPIXT','Cathy Waelchi','ahmad.padberg@johnson.com','0149013326','Alice replied eagerly, for she thought, \'it\'s sure to happen,\' she said this, she came rather.',NULL,'refunded','2025-06-10 10:40:47','2025-06-10 10:40:47'),(4,1,'HDVG7MHCVGSR','Garland Price','qmacejkovic@gmail.com','0516736888','I can say.\' This was such a curious appearance in the same thing as a last resource, she put them.',NULL,'reserved','2025-06-10 10:40:47','2025-06-10 10:40:47'),(5,2,'3XMULPMSHGVJ','Mr. Jordi Spencer','marcus74@hotmail.com','0489514008','Sir, With no jury or judge, would be four thousand miles down, I think--\' (for, you see, Miss.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(6,2,'TTXFLDURJIXV','Dr. Brock Paucek III','jmann@franecki.com','0829234308','I wish I hadn\'t drunk quite so much!\' Alas! it was very nearly getting up and leave the court; but.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(7,2,'M44MZNRX7X8A','Prof. Simone Nolan DVM','kovacek.zakary@hotmail.com','0574392669','Duchess said in a piteous tone. And the moral of that is--\"The more there is of yours.\"\' \'Oh, I.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(8,3,'SYBLLHRHBIYG','Arnaldo Orn DVM','herzog.marge@parisian.info','0939268796','Lizard, who seemed too much overcome to do next, when suddenly a White Rabbit read:-- \'They told.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(9,3,'MJJMXQ0D1IGW','Lola Mann','ondricka.kassandra@hermiston.com','0695575543','That WILL be a letter, written by the Hatter, \'when the Queen said to herself how this same little.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(10,3,'QHMBYLZV3Z1V','Dr. Afton Douglas I','noble68@bailey.com','0541266673','I am very tired of this. I vote the young Crab, a little faster?\" said a whiting before.\' \'I can.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(11,3,'MCLWAJ8XETMD','Robyn Shields','uhomenick@yahoo.com','0377013207','M--\' \'Why with an M, such as mouse-traps, and the fan, and skurried away into the air. \'--as far.',NULL,'checked_in','2025-06-10 10:40:48','2025-06-10 10:40:48'),(12,4,'ZAET8NLNAHFE','Audie Terry','halvorson.blaze@jakubowski.info','0134088630','However, everything is to-day! And yesterday things went on growing, and growing, and she put her.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(13,4,'G4EAUQR9W4ST','Calista Batz','vgulgowski@reichert.net','0023111131','Alice, and looking at them with large eyes full of tears, but said nothing. \'Perhaps it hasn\'t.',NULL,'purchased','2025-06-10 10:40:48','2025-06-10 10:40:48'),(14,5,'GDNEAALAWL5D','Nicholas Reinger','lowe.noemi@hotmail.com','0661511748','Dodo had paused as if she meant to take out of THIS!\' (Sounds of more broken glass.) \'Now tell me.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(15,5,'O61EZD9RJF3H','Ms. Zola Osinski III','xritchie@gmail.com','0173799181','Conqueror.\' (For, with all their simple joys, remembering her own mind (as well as the rest were.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(16,5,'GJ79JRN1HAQ8','Yolanda Schimmel','schultz.lyla@leannon.info','0975946310','Alice. \'I\'m a--I\'m a--\' \'Well! WHAT are you?\' said Alice, and she walked off, leaving Alice alone.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(17,5,'4TPOPVOVBVRI','Bernhard Okuneva MD','kuphal.oswaldo@yahoo.com','0618004874','For instance, suppose it doesn\'t understand English,\' thought Alice; \'I can\'t explain it,\' said.',NULL,'cancelled','2025-06-10 10:40:48','2025-06-10 10:40:48'),(18,5,'QFZANGEPWU9W','Raphaelle Keebler Jr.','ahmed12@bergnaum.com','0319207795','And the Gryphon said, in a low, weak voice. \'Now, I give you fair warning,\' shouted the Queen.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(19,6,'LP4UYKHUATFA','Mr. Michael Monahan','crystal03@hotmail.com','0077560844','Here the Queen in front of them, with her arms folded, quietly smoking a long and a scroll of.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(20,6,'LDGM8LPBXDSA','Breanna Kerluke','javon96@yahoo.com','0883761963','Alice; \'that\'s not at all like the three were all talking at once, with a round face, and large.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(21,7,'9YRD1AIRVSHR','Lura Satterfield','hermann.arianna@yahoo.com','0479978360','Puss,\' she began, rather timidly, saying to herself in a tone of great relief. \'Now at OURS they.',NULL,'purchased','2025-06-10 10:40:48','2025-06-10 10:40:48'),(22,7,'9PUV7MVYVGHR','Dr. Lukas Bartell V','llynch@bauch.biz','0937354378','So Alice got up and walking away. \'You insult me by talking such nonsense!\' \'I didn\'t know how to.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(23,8,'IMNDOVB5M68I','Miss Assunta Hodkiewicz I','lucious39@bergstrom.net','0443298208','PLEASE mind what you\'re at!\" You know the meaning of half an hour or so, and were resting in the.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(24,8,'VVQZDK6JMDSH','Jerod Goldner','spadberg@reichert.com','0316213537','March Hare. \'Then it wasn\'t trouble enough hatching the eggs,\' said the Mock Turtle sighed deeply.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(25,9,'GD5GHOFUABST','Mrs. Nyah Jacobs MD','torphy.leslie@jacobi.com','0807081188','Mock Turtle would be worth the trouble of getting her hands on her spectacles, and began to repeat.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(26,9,'1BJIVASAQP06','Dr. Cameron Schamberger','quigley.carmel@gmail.com','0296407594','Mock Turtle recovered his voice, and, with tears again as she spoke. Alice did not like to be in.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(27,9,'MNB7TCZMRJCC','Genesis Kertzmann','madalyn48@gmail.com','0443334188','Mock Turtle Soup is made from,\' said the Queen, turning purple. \'I won\'t!\' said Alice. \'Did you.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(28,9,'U1JTKSRYEQ8P','Mr. Darryl Raynor','dicki.icie@yahoo.com','0066510208','SLUGGARD,\"\' said the King. \'I can\'t help it,\' said Alice a good deal to ME,\' said the King, \'and.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(29,10,'PBT0ORNFKAP7','Phyllis Macejkovic','eudora.brakus@volkman.org','0945168176','Alice desperately: \'he\'s perfectly idiotic!\' And she squeezed herself up closer to Alice\'s side as.',NULL,'cancelled','2025-06-10 10:40:48','2025-06-10 10:40:48'),(30,10,'7OLUEDPO5ROK','Godfrey Wolff','gaylord.isaac@gerlach.com','0805208545','So you see, Miss, we\'re doing our best, afore she comes, to--\' At this moment Alice appeared, she.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(31,10,'1IDZXFMIGJ4S','Vinnie Russel Sr.','wdare@hotmail.com','0835116950','Alice in a helpless sort of a globe of goldfish she had sat down with her head!\' about once in a.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(32,10,'IL3VWGRULD17','Dr. Darby Johnston','wstrosin@rogahn.com','0139103403','Alice, as she could do, lying down with one eye; \'I seem to put everything upon Bill! I wouldn\'t.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(33,10,'CHM84SYWWXAT','Kristofer Spinka','lesly.king@wyman.com','0530608784','I grow up, I\'ll write one--but I\'m grown up now,\' she added aloud. \'Do you mean \"purpose\"?\' said.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(34,10,'F1NR8UT3ZFPO','Angela Gerhold','bryana84@gmail.com','0007120226','Duck and a piece of rudeness was more than Alice could think of what sort it was) scratching and.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(35,11,'ZV1M3TVVWOWB','Mercedes Heidenreich MD','powlowski.onie@schinner.com','0312063125','And he added looking angrily at the end of the evening, beautiful Soup! Soup of the month is it?\'.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(36,11,'7T6C2TD3LYCK','Dr. Walker Rosenbaum I','chaz76@lockman.com','0524004998','Conqueror, whose cause was favoured by the time he was speaking, and this was his first speech.',NULL,'cancelled','2025-06-10 10:40:48','2025-06-10 10:40:48'),(37,11,'AICKDBGIIIYD','Carlotta Koch DDS','elaina46@hotmail.com','0310288638','They had a bone in his turn; and both creatures hid their faces in their mouths; and the great.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(38,12,'RCGSFUFQUW8T','Jaida Sauer','gmcglynn@yahoo.com','0836520653','Hatter added as an unusually large saucepan flew close by it, and talking over its head. \'Very.',NULL,'pending','2025-06-10 10:40:48','2025-06-10 10:40:48'),(39,12,'QNU4HA7QF3DG','Judy Veum','sallie55@hotmail.com','0184283855','She said the King, the Queen, who was peeping anxiously into its face was quite surprised to find.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(40,12,'N2DBA2H2D2AT','Celestino Hand','waelchi.geovanny@hotmail.com','0982182173','If I or she should meet the real Mary Ann, what ARE you doing out here? Run home this moment, and.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(41,12,'TBDCOYRWIPIP','Prof. Melany Jerde Jr.','kiel.cummerata@hamill.com','0937873707','But, when the race was over. However, when they passed too close, and waving their forepaws to.',NULL,'purchased','2025-06-10 10:40:48','2025-06-10 10:40:48'),(42,12,'OLOQV0KF2NXF','Willa Simonis','mariana92@hammes.com','0049570974','Suppress him! Pinch him! Off with his knuckles. It was high time to see that she could not join.',NULL,'purchased','2025-06-10 10:40:48','2025-06-10 10:40:48'),(43,13,'7GA7ON38PWFJ','Jan Barton','hane.berniece@gmail.com','0473143086','THERE again!\' said Alice in a great deal to come before that!\' \'Call the first figure!\' said the.',NULL,'purchased','2025-06-10 10:40:48','2025-06-10 10:40:48'),(44,13,'YHAJTGYMYXAE','Prof. Stewart Hahn','esmeralda.boyer@yahoo.com','0909255113','Mock Turtle would be offended again. \'Mine is a very truthful child; \'but little girls of her.',NULL,'checked_in','2025-06-10 10:40:48','2025-06-10 10:40:48'),(45,13,'1UDV2DZV9MW3','Daphney Franecki','ttremblay@muller.info','0742936503','Mock Turtle. \'No, no! The adventures first,\' said the Duchess; \'I never saw one, or heard of.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(46,13,'CYJYUAIZFYVQ','Stephen Mertz','weimann.zachariah@gmail.com','0687625196','Do cats eat bats, I wonder?\' Alice guessed in a tone of the way--\' \'THAT generally takes some.',NULL,'cancelled','2025-06-10 10:40:48','2025-06-10 10:40:48'),(47,13,'70RBBTZBOUVP','Jaiden Stamm MD','marquise57@koss.net','0824851024','Dodo suddenly called out \'The race is over!\' and they sat down, and was going to begin lessons.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(48,13,'NOLZFTTU7SVR','Leta Tremblay','lenny.hartmann@swift.com','0086768353','Duchess asked, with another dig of her knowledge. \'Just think of nothing better to say a word, but.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(49,14,'PYTFRIT55OTB','Angelo Nicolas','melody.okuneva@yahoo.com','0737126660','Mock Turtle said: \'I\'m too stiff. And the muscular strength, which it gave to my right size: the.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(50,14,'GXI3UD1CQECC','Prof. Dulce Langosh','kkassulke@kozey.com','0527581327','I want to get in at the time when I was a large fan in the pool as it was good manners for her.',NULL,'reserved','2025-06-10 10:40:48','2025-06-10 10:40:48'),(51,15,'TBGRXXIFXNOB','Alena Schroeder','wwyman@hammes.com','0759428224','VERY nearly at the mouth with strings: into this they slipped the guinea-pig, head first, and.',NULL,'checked_in','2025-06-10 10:40:48','2025-06-10 10:40:48'),(52,15,'GTIIBKGIKGPM','Maude Shanahan Sr.','mya.collins@skiles.com','0856888257','Dormouse. \'Fourteenth of March, I think I should be like then?\' And she kept on puzzling about it.',NULL,'refunded','2025-06-10 10:40:48','2025-06-10 10:40:48'),(53,15,'CVNNMCMCZYRW','Alfonzo Luettgen','dortha81@yahoo.com','0562857587','King said, with a little of it?\' said the Caterpillar. \'I\'m afraid I can\'t put it in time,\' said.',NULL,'cancelled','2025-06-10 10:40:48','2025-06-10 10:40:48'),(54,15,'FNLFIWH2DSNR','Miss Marianne Reinger','schimmel.stefan@boehm.com','0011045599','I begin, please your Majesty,\' said Alice indignantly, and she trembled till she shook the house.',NULL,'transferred','2025-06-10 10:40:48','2025-06-10 10:40:48'),(55,16,'DEKT5SKVY4AP','Miss Arlene Kozey V','lizeth66@yahoo.com','0482518019','Alice, who always took a great interest in questions of eating and drinking. \'They lived on.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(56,16,'FAC2E2B1RVKD','Hiram Gutmann','bret.batz@keeling.com','0827037504','I was going to dive in among the trees under which she found herself in a few minutes to see that.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(57,16,'QU8PBEWBMQTH','Orin Rohan','monty95@johns.biz','0820085029','QUITE as much as serpents do, you know.\' \'Not the same when I got up in such long curly brown.',NULL,'checked_in','2025-06-10 10:40:49','2025-06-10 10:40:49'),(58,16,'KTC7E6BTGCG6','Mr. Zion Eichmann','sipes.marisol@yahoo.com','0923278835','Dormouse indignantly. However, he consented to go through next walking about at the righthand bit.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(59,16,'9LFVAR0B8FAE','Emily Mayert','cruickshank.lavada@hotmail.com','0197736618','THIS size: why, I should understand that better,\' Alice said very politely, \'for I never was so.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(60,17,'XSJZTKNR1VDD','Chesley Mills','pdietrich@gmail.com','0479927073','Then she went to school every day--\' \'I\'VE been to her, still it had fallen into it: there was no.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(61,17,'AGQFSTFOUO1Y','Prof. Alexandria Kub Jr.','jaskolski.colby@hudson.com','0573330486','I shall think nothing of the room again, no wonder she felt a very little use, as it happens; and.',NULL,'purchased','2025-06-10 10:40:49','2025-06-10 10:40:49'),(62,17,'EMZHAURTGBCJ','Miss Cara VonRueden II','linnea.zemlak@koss.com','0680857332','Alice thought she had not noticed before, and behind it when she found this a good many voices all.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(63,17,'THSPICGD9HH4','Grayce Lesch','ifeil@altenwerth.com','0089939774','Alice noticed, had powdered hair that WOULD always get into that beautiful garden--how IS that to.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(64,17,'S20UM9SFMKTP','Miss Drew Murray I','wiza.viola@hotmail.com','0731030483','Queen say only yesterday you deserved to be almost out of sight, they were IN the well,\' Alice.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(65,18,'D6SEQMMXCHJS','Dr. Darron Connelly DDS','uboehm@rosenbaum.net','0535586805','Five! Always lay the blame on others!\' \'YOU\'D better not talk!\' said Five. \'I heard the Queen was.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(66,18,'KD8DEHSTU1T5','Bradly Stamm','kiarra44@hotmail.com','0608185329','But she waited patiently. \'Once,\' said the March Hare. The Hatter looked at it again: but he could.',NULL,'transferred','2025-06-10 10:40:49','2025-06-10 10:40:49'),(67,19,'SWVTSOMCYY26','Mrs. Elenor Schmidt','barton.magdalen@runte.com','0422023095','Good-bye, feet!\' (for when she looked back once or twice she had tired herself out with his head!\'.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(68,19,'FGDA5YRT5QDK','Miss Ocie Okuneva I','michel65@lockman.com','0706820823','ME.\' \'You!\' said the King. \'When did you call him Tortoise--\' \'Why did you call him Tortoise--\'.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(69,19,'FKVYD5IGWRRM','Rocio Deckow','sfunk@ferry.info','0507665771','King. \'When did you manage on the end of his great wig.\' The judge, by the way I want to get out.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(70,19,'FARD9T2YLW20','Jermaine Maggio','delbert.goyette@nienow.org','0365152755','Alice ventured to ask. \'Suppose we change the subject. \'Ten hours the first day,\' said the.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(71,19,'6BDMSTQIFOWV','Matilda Mayer','dleffler@yahoo.com','0518194257','Gryphon, the squeaking of the house!\' (Which was very glad to find quite a chorus of voices asked.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(72,20,'RHLSDSUIINVO','Rosalyn McKenzie DVM','alessandra.kuvalis@yahoo.com','0352335597','Bill,\' thought Alice,) \'Well, I shan\'t go, at any rate: go and get in at the end of every line.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(73,20,'KERXOA0UUNYR','Mallie Ferry','marley57@tillman.org','0843300398','Alice could speak again. In a minute or two she walked off, leaving Alice alone with the bones and.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(74,20,'KKK8VVVQKF0W','Prof. Frank Skiles Sr.','lyda23@kozey.com','0015072379','Alice. \'Who\'s making personal remarks now?\' the Hatter were having tea at it: a Dormouse was.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(75,20,'VHXXISOVKUWR','Allie Maggio','anderson.arnulfo@yahoo.com','0144557001','I was going to begin with; and being so many lessons to learn! Oh, I shouldn\'t want YOURS: I don\'t.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(76,20,'MHX9AGJRVFHC','Jett Connelly','muriel.hettinger@mclaughlin.com','0860794991','Queen, who was trembling down to her that she was quite pleased to find that she was about a foot.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(77,20,'NX4XH7APG3TJ','Reynold Koelpin','darrion.feil@dach.com','0034591243','Stigand, the patriotic archbishop of Canterbury, found it so VERY much out of his teacup and.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(78,21,'M5CKGIQJYJHT','Eva Kirlin','destin38@yahoo.com','0831308201','King, and the Dormouse shall!\' they both bowed low, and their slates and pencils had been for some.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(79,21,'YYXLNM9MUTP3','Zula Kreiger','nebert@hotmail.com','0271357937','When she got up this morning, but I THINK I can listen all day about it!\' and he hurried off.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(80,21,'AUMBIKRAXAY0','Elmer Rolfson','keeling.emmy@yahoo.com','0033778003','How the Owl had the door of which was sitting next to her. The Cat only grinned a little bottle.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(81,22,'UNOUJERBAG9K','George Rempel','debert@murazik.com','0861843554','No room!\' they cried out when they hit her; and when she first saw the White Rabbit, who said in.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(82,22,'FLUOLTNESQET','Sid O\'Keefe','yessenia.volkman@gmail.com','0410745743','Dodo managed it.) First it marked out a history of the e--e--evening, Beautiful, beauti--FUL.',NULL,'transferred','2025-06-10 10:40:49','2025-06-10 10:40:49'),(83,22,'HT3GVVEN77DC','Prof. Margret Treutel','mayer.ayden@gmail.com','0490588562','Hatter. \'I deny it!\' said the Hatter, it woke up again as she could not taste theirs, and the.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(84,22,'N9GPEZES2V8K','Prof. Ara Marquardt','glover.raphael@gmail.com','0729206847','But the insolence of his teacup and bread-and-butter, and then unrolled the parchment scroll, and.',NULL,'transferred','2025-06-10 10:40:49','2025-06-10 10:40:49'),(85,23,'ZCQKF8IQ51I6','Demario O\'Kon','kgoodwin@stoltenberg.com','0124272346','Alice waited till she too began dreaming after a minute or two to think about it, so she bore it.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(86,23,'NCXHZEBWKBVH','Dr. Davion Kuvalis','flatley.melody@gmail.com','0067262167','I\'ve made up my mind about it; if I\'m not looking for it, while the Mouse replied rather crossly.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(87,23,'4Z29I3DEN8KQ','Heaven Price','maida.von@gmail.com','0929426334','Turtle.\' These words were followed by a very grave voice, \'until all the arches are gone from this.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(88,24,'35EEZEKSSUPF','Dariana Koss DDS','ryann63@yahoo.com','0076219104','I give you fair warning,\' shouted the Queen till she had caught the baby was howling so much about.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(89,24,'1JP4FC06VBYX','Mr. Ahmed Predovic','sydney35@hackett.biz','0361218509','Mock Turtle, \'Drive on, old fellow! Don\'t be all day about it!\' Last came a little feeble.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(90,24,'GZ3VDUUEZHDT','Linnea Leffler','waylon31@powlowski.com','0863064034','She said it to be told so. \'It\'s really dreadful,\' she muttered to herself, and shouted out.',NULL,'purchased','2025-06-10 10:40:49','2025-06-10 10:40:49'),(91,25,'7XCIVVRLCOAS','Saige Waters','isadore.cartwright@sipes.org','0676874201','I hadn\'t to bring tears into her eyes--and still as she stood watching them, and all her fancy.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(92,25,'CCMB7BBZWDBZ','Kurt McLaughlin','oswaldo07@barton.com','0042505508','I do hope it\'ll make me larger, it must make me larger, it must be on the other was sitting on a.',NULL,'refunded','2025-06-10 10:40:49','2025-06-10 10:40:49'),(93,25,'TSWXOANAOTGS','Prof. Rhett Hagenes DDS','ortiz.mathew@gmail.com','0866410129','Mock Turtle replied; \'and then the puppy jumped into the jury-box, and saw that, in her pocket).',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(94,26,'QIGP29IUOA9Q','Johanna Metz','lea.yost@goldner.com','0599492846','She went on \'And how did you begin?\' The Hatter shook his head mournfully. \'Not I!\' said the.',NULL,'pending','2025-06-10 10:40:49','2025-06-10 10:40:49'),(95,26,'VZEJQ5D5YHDE','Adriana Gerlach','bosco.kristopher@kuvalis.com','0820546510','Pennyworth only of beautiful Soup? Pennyworth only of beautiful Soup? Pennyworth only of beautiful.',NULL,'transferred','2025-06-10 10:40:49','2025-06-10 10:40:49'),(96,26,'KSJUZIIEYNHG','Eleanora Schmitt','cyost@adams.org','0868329718','I\'m afraid, but you might catch a bat, and that\'s all the unjust things--\' when his eye chanced to.',NULL,'purchased','2025-06-10 10:40:49','2025-06-10 10:40:49'),(97,27,'HQWCBUIWL3NZ','Mr. Leo Maggio DVM','lindsey.kozey@torphy.biz','0416229875','A bright idea came into her face. \'Wake up, Alice dear!\' said her sister; \'Why, what are they made.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(98,27,'TWQN4KUKN1BC','Stevie Jast III','ethel.torphy@medhurst.com','0240802453','The Hatter was the only difficulty was, that if you don\'t like them!\' When the sands are all.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(99,28,'B5ALD6LUMVRF','Torrey Skiles','cassandre.pfannerstill@yahoo.com','0981322418','I must have a prize herself, you know,\' said the King: \'leave out that she ran off at once, in a.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(100,28,'DPDZZGANP4WZ','Dr. Theodora Rolfson','niko62@yahoo.com','0514542702','Gryphon. \'They can\'t have anything to put everything upon Bill! I wouldn\'t be so easily offended.',NULL,'cancelled','2025-06-10 10:40:49','2025-06-10 10:40:49'),(101,28,'9KRCHRYSQZCG','Nick Walker','manuel.hartmann@buckridge.org','0311814301','By the time when she noticed a curious dream, dear, certainly: but now run in to your tea; it\'s.',NULL,'reserved','2025-06-10 10:40:49','2025-06-10 10:40:49'),(102,28,'RK5QIGMFJOXM','Toni Ritchie','guiseppe54@yahoo.com','0893816089','She had not gone (We know it to be ashamed of yourself for asking such a capital one for catching.',NULL,'purchased','2025-06-10 10:40:49','2025-06-10 10:40:49'),(103,28,'HXSEKZ6COHE1','Casey Torphy','amara.barrows@hotmail.com','0441329513','I\'ll tell you his history,\' As they walked off together. Alice laughed so much about a thousand.',NULL,'checked_in','2025-06-10 10:40:49','2025-06-10 10:40:49'),(104,29,'TO76ER1WJ7BP','Roosevelt Cassin','madelyn13@hotmail.com','0930366350','Presently the Rabbit began. Alice thought she might as well look and see what would happen next.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(105,29,'QZZGVIHDQLIN','Prof. Amie O\'Connell Sr.','bhoeger@wunsch.biz','0338171815','She was walking by the end of trials, \"There was some attempts at applause, which was full of.',NULL,'reserved','2025-06-10 10:40:50','2025-06-10 10:40:50'),(106,29,'LG3MFQIUZUTR','Elwin Waters Jr.','littel.annabell@davis.org','0614947408','I can guess that,\' she added in a confused way, \'Prizes! Prizes!\' Alice had no very clear notion.',NULL,'transferred','2025-06-10 10:40:50','2025-06-10 10:40:50'),(107,30,'MLCRAMM8DOEI','Mr. Jamey Hodkiewicz MD','jrutherford@hotmail.com','0301256222','Mock Turtle said: \'no wise fish would go round and round the hall, but they were gardeners, or.',NULL,'reserved','2025-06-10 10:40:50','2025-06-10 10:40:50'),(108,30,'E2CDWVBJOS9R','Miss Lyla Greenfelder Sr.','selina70@hotmail.com','0546757461','Tortoise because he was in March.\' As she said to herself that perhaps it was all ridges and.',NULL,'purchased','2025-06-10 10:40:50','2025-06-10 10:40:50'),(109,30,'TQQCRG9CIFSL','Mr. Vincenzo Crona DDS','harber.maymie@kohler.com','0089500692','Bill,\' she gave a little queer, won\'t you?\' \'Not a bit,\' said the Dormouse began in a great deal.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(110,30,'YN0MIWA2QTFA','Ms. Adaline Sporer V','chand@gmail.com','0684491124','MARMALADE\', but to open her mouth; but she saw in another moment it was very nearly in the air.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(111,30,'OUBFHDXLVYCZ','Tia Jaskolski','turcotte.erin@prohaska.info','0077676973','Dormouse!\' And they pinched it on both sides at once. \'Give your evidence,\' said the Mock Turtle.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(112,30,'SQVGE7OZBKWU','Orland Steuber','augustine99@durgan.com','0573080854','Those whom she sentenced were taken into custody by the way, was the Cat remarked. \'Don\'t be.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(113,31,'IBA3NA6NLYNL','Keshaun Langosh','dickens.jordi@kiehn.org','0390763324','I tell you, you coward!\' and at last the Caterpillar seemed to be told so. \'It\'s really dreadful,\'.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(114,31,'APB9Y1LILMTA','Madonna Runte','yolanda97@hotmail.com','0918874263','Alice was not a regular rule: you invented it just now.\' \'It\'s the Cheshire Cat: now I shall only.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(115,31,'SJ0UJMGOU4M1','David Hintz','steuber.braeden@hirthe.com','0025134350','Alice, who always took a great deal too far off to trouble myself about you: you must manage the.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(116,31,'N81M4U88NPDF','Demarcus Gottlieb','nwisozk@volkman.info','0902830565','I\'m not looking for eggs, as it could go, and broke to pieces against one of its mouth open.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(117,31,'CFVCBD0F6RNU','Israel Franecki DDS','tabitha.doyle@hotmail.com','0599983006','I believe.\' \'Boots and shoes under the sea,\' the Gryphon went on. \'Would you tell me,\' said Alice.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(118,31,'S8QPMOUF6T44','Charlie Schmidt PhD','bernhard.isac@huels.net','0403892960','Mock Turtle, \'but if they do, why then they\'re a kind of sob, \'I\'ve tried every way, and nothing.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(119,32,'6AS1P4U6HWWJ','Morgan Bechtelar','cbrown@franecki.net','0366339748','Alice replied in a hoarse growl, \'the world would go through,\' thought poor Alice, and she went.',NULL,'reserved','2025-06-10 10:40:50','2025-06-10 10:40:50'),(120,32,'F7FL1II4SJCO','Dr. Erna Bradtke III','fahey.melyna@mcclure.net','0988469395','After these came the royal children, and everybody laughed, \'Let the jury asked. \'That I can\'t.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(121,32,'2V5FQFB7RRQC','Ms. Thea Cormier II','wleuschke@yahoo.com','0458917969','I goes like a telescope! I think you\'d better leave off,\' said the King, and he hurried off. Alice.',NULL,'purchased','2025-06-10 10:40:50','2025-06-10 10:40:50'),(122,32,'DZ6WZXQWJVHW','Bartholome Armstrong','vcruickshank@hotmail.com','0288608807','Hatter went on talking: \'Dear, dear! How queer everything is to-day! And yesterday things went on.',NULL,'reserved','2025-06-10 10:40:50','2025-06-10 10:40:50'),(123,33,'ITJROIYTD8N1','Loyal Jast','pfannerstill.dedrick@white.biz','0303015464','Alice, thinking it was written to nobody, which isn\'t usual, you know.\' \'Who is this?\' She said.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(124,33,'MFEYH2NPNG6R','Dr. Daphney Watsica DVM','marquardt.tiana@yahoo.com','0552327047','Alice. \'It must be kind to them,\' thought Alice, \'they\'re sure to do so. \'Shall we try another.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(125,34,'TPULFFNCTLHP','Alec Sporer PhD','reichert.camille@anderson.biz','0684486230','I fell off the mushroom, and raised herself to some tea and bread-and-butter, and then hurried on.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(126,34,'8LDBM9W30AXQ','Miss Kacie Graham MD','syble.luettgen@berge.com','0162960508','I should understand that better,\' Alice said very politely, \'if I had our Dinah here, I know all.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(127,34,'GPHEBCLL64PG','Wilfred Johnston Jr.','rolfson.abby@boehm.com','0597591152','Rabbit actually TOOK A WATCH OUT OF ITS WAISTCOAT-POCKET, and looked at Two. Two began in a.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(128,34,'4YWBHIS7P5C5','Patience Powlowski','bernice81@hotmail.com','0745990249','She felt very glad to find her way through the wood. \'If it had entirely disappeared; so the King.',NULL,'transferred','2025-06-10 10:40:50','2025-06-10 10:40:50'),(129,34,'5OZILLAXUFLF','Prof. Aric Pfannerstill III','stokes.justus@schuster.org','0194158971','Dormouse. \'Don\'t talk nonsense,\' said Alice doubtfully: \'it means--to--make--anything--prettier.\'.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(130,35,'BQE4GPMIP8HS','Patsy Mayer','hettinger.claudie@doyle.net','0440255065','Why, there\'s hardly enough of me left to make out exactly what they said. The executioner\'s.',NULL,'purchased','2025-06-10 10:40:50','2025-06-10 10:40:50'),(131,35,'SBWJDTJQYIQ9','Jonatan Schinner','kilback.mariane@strosin.com','0088172441','I get it home?\' when it grunted again, so that altogether, for the immediate adoption of more.',NULL,'transferred','2025-06-10 10:40:50','2025-06-10 10:40:50'),(132,35,'X57FITWJJXEU','Price Greenfelder','connelly.doug@gmail.com','0209211037','I beg your pardon!\' cried Alice in a very short time the Queen to play croquet.\' Then they both.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(133,35,'QZO2YJ5U0TD5','Mr. Loyal Hoeger','kiara26@yahoo.com','0713908844','I was going on, as she went in search of her voice. Nobody moved. \'Who cares for fish, Game, or.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(134,35,'PLQOECL38D3P','Edna Schimmel','abbigail.ernser@boehm.com','0287510513','Mock Turtle went on, \'--likely to win, that it\'s hardly worth while finishing the game.\' The Queen.',NULL,'purchased','2025-06-10 10:40:50','2025-06-10 10:40:50'),(135,36,'E8TDMUYDIPPL','Rahul Crooks','braeden21@goyette.com','0986506455','Alice could not answer without a moment\'s pause. The only things in the other: the only difficulty.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(136,36,'19YZUIHYAIB4','Lessie Balistreri','camryn89@hotmail.com','0694058324','Still she went hunting about, and shouting \'Off with her head!\' Alice glanced rather anxiously at.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(137,37,'JQA27LFP7PP7','Mr. Filiberto Harvey Jr.','sharvey@gmail.com','0787939749','Mock Turtle a little nervous about this; \'for it might not escape again, and made believe to worry.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(138,37,'OG8UYEWUII9A','Adelbert Abbott','kovacek.emelie@kub.net','0947547069','I did: there\'s no harm in trying.\' So she began: \'O Mouse, do you know about it, even if I chose,\'.',NULL,'reserved','2025-06-10 10:40:50','2025-06-10 10:40:50'),(139,37,'TX92JBNDFQ62','Violette Thompson','lcollins@jones.net','0258016247','I hadn\'t begun my tea--not above a week or so--and what with the strange creatures of her own ears.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(140,37,'1DRWRIIY86YH','Mrs. Trudie Predovic','nienow.paris@dibbert.com','0402265942','Alice quite jumped; but she had expected: before she got to see what this bottle was NOT marked.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(141,37,'QUQLXI7GOH52','Prof. Kallie Hagenes','etorphy@yahoo.com','0662186704','There were doors all round the hall, but they began moving about again, and all dripping wet.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(142,38,'FZ3TJNSUCYC9','Citlalli Doyle','dean26@champlin.biz','0115470202','Time, and round Alice, every now and then another confusion of voices--\'Hold up his head--Brandy.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(143,38,'Q3OYXLI38PKN','Mrs. Maria Zieme','ucremin@okon.info','0880193614','So she began again. \'I wonder how many miles I\'ve fallen by this time?\' she said to herself as she.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(144,38,'SDL9BFZGXWGT','Mrs. Vita Ferry','jadyn.mclaughlin@schoen.net','0550359015','I eat or drink anything; so I\'ll just see what was the BEST butter, you know.\' He was an old.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(145,38,'CHH96YDPG4UH','Dena Ward','patience.crona@hill.com','0564871919','I believe.\' \'Boots and shoes under the circumstances. There was no more to do it.\' (And, as you.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(146,38,'O0VVVS9HA8HJ','Kiley Harris Jr.','marquis56@yahoo.com','0644596643','Cat, \'a dog\'s not mad. You grant that?\' \'I suppose so,\' said the Cat, \'a dog\'s not mad. You grant.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(147,39,'NA7GS2QPBUWS','Dashawn Dickinson','rhiannon.halvorson@leuschke.com','0358097028','IS his business!\' said Five, in a moment. \'Let\'s go on in a shrill, loud voice, and see what the.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(148,39,'GC8FBWBB98R0','Dr. Magnus Yundt','caterina03@schmeler.com','0007639723','She soon got it out to be an advantage,\' said Alice, a little of the lefthand bit of stick, and.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(149,39,'EXE0QPBFO04O','Catharine Ondricka','courtney.wintheiser@hyatt.net','0825205933','I get\" is the capital of Paris, and Paris is the driest thing I ever heard!\' \'Yes, I think it so.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(150,40,'GYWRYTMJWNVQ','Jaeden Sawayn','laney12@bayer.org','0017972846','There was a little nervous about this; \'for it might be some sense in your knocking,\' the Footman.',NULL,'transferred','2025-06-10 10:40:50','2025-06-10 10:40:50'),(151,40,'DZSLK3ISCULX','Mabelle Legros','albertha79@hotmail.com','0657527149','The next thing is, to get to,\' said the cook. The King looked anxiously at the stick, and made.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(152,40,'U7IOC4RGIE1F','Prof. Aletha O\'Hara','vbeatty@cronin.net','0081502065','How neatly spread his claws, And welcome little fishes in With gently smiling jaws!\' \'I\'m sure.',NULL,'transferred','2025-06-10 10:40:50','2025-06-10 10:40:50'),(153,40,'1JSMJWKOBWEU','Mrs. Gregoria Crooks DDS','ybradtke@stamm.biz','0301533711','Dormouse sulkily remarked, \'If you knew Time as well look and see how he did it,) he did it,) he.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(154,41,'QFV40D6EPUZX','Miss Justina Langworth','luisa25@gmail.com','0007624450','White Rabbit put on your head-- Do you think, at your age, it is I hate cats and dogs.\' It was.',NULL,'refunded','2025-06-10 10:40:50','2025-06-10 10:40:50'),(155,41,'CRQTTECGSNAD','Zelda Koepp','raphaelle02@zboncak.com','0256044946','I learn music.\' \'Ah! that accounts for it,\' said Alice loudly. \'The idea of the table, but it.',NULL,'checked_in','2025-06-10 10:40:50','2025-06-10 10:40:50'),(156,41,'UYFPZOLZMFBK','Dr. Jovanny Bogisich Sr.','psporer@heathcote.com','0932867047','I BEG your pardon!\' cried Alice again, in a moment. \'Let\'s go on for some way of expecting nothing.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(157,41,'WPDTQ6Z3NBJZ','Prof. Bailey Rolfson','beier.emory@schimmel.com','0142509708','I was going off into a sort of idea that they couldn\'t get them out of sight, they were nice grand.',NULL,'pending','2025-06-10 10:40:50','2025-06-10 10:40:50'),(158,41,'6PVPHJJLCRWK','Conor Kunze','mayer.ephraim@rippin.com','0337775600','Alice again, in a trembling voice:-- \'I passed by his face only, she would gather about her and to.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(159,41,'ZBRMQCLVHXKF','Domenick Bosco','elfrieda61@little.org','0848730981','I THINK; or is it directed to?\' said the Mock Turtle, \'but if they do, why then they\'re a kind of.',NULL,'cancelled','2025-06-10 10:40:50','2025-06-10 10:40:50'),(160,42,'H9DCTQDBVXBB','Joesph Braun','ukonopelski@hotmail.com','0459930481','Rabbit say to itself, \'Oh dear! Oh dear! I wish I hadn\'t begun my tea--not above a week or so--and.',NULL,'cancelled','2025-06-10 10:40:51','2025-06-10 10:40:51'),(161,42,'VEKFQJVSR61E','Cornelius Schiller','cwalker@hotmail.com','0518148396','I\'ve tried to get into that lovely garden. I think I could, if I fell off the fire, licking her.',NULL,'pending','2025-06-10 10:40:51','2025-06-10 10:40:51'),(162,43,'TDADBWNTQTVV','Aniya Daniel','kamren89@gmail.com','0705688995','SIT down,\' the King put on his slate with one elbow against the door, she ran across the field.',NULL,'checked_in','2025-06-10 10:40:51','2025-06-10 10:40:51'),(163,43,'SY2BONUADPX7','Petra Rolfson','runte.glenna@hotmail.com','0892745032','In the very tones of the Rabbit\'s voice; and Alice rather unwillingly took the cauldron of soup.',NULL,'transferred','2025-06-10 10:40:51','2025-06-10 10:40:51'),(164,43,'MIUSTSOIWEZH','Stefan Bradtke','norval.block@hotmail.com','0014196139','Alice hastily replied; \'at least--at least I mean what I eat\" is the use of this ointment--one.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(165,43,'YBZRKBB7TFOD','Michele Ziemann','alyson.carroll@gmail.com','0920529029','Even the Duchess began in a deep, hollow tone: \'sit down, both of you, and listen to me! I\'LL soon.',NULL,'checked_in','2025-06-10 10:40:51','2025-06-10 10:40:51'),(166,43,'DMMJWEXRZLDP','Mr. Al Kuvalis DDS','muller.olga@fahey.com','0014902810','Gryphon, before Alice could speak again. In a little scream of laughter. \'Oh, hush!\' the Rabbit.',NULL,'cancelled','2025-06-10 10:40:51','2025-06-10 10:40:51'),(167,43,'ED8GDVEDS3OM','Cristina Berge','berge.kristin@hotmail.com','0729906860','Alice had not attended to this mouse? Everything is so out-of-the-way down here, that I should.',NULL,'cancelled','2025-06-10 10:40:51','2025-06-10 10:40:51'),(168,44,'AZ7XPUGEYZXJ','Dr. Matilde Adams PhD','mante.patience@gmail.com','0828309955','Alice, quite forgetting in the beautiful garden, among the party. Some of the song, she kept.',NULL,'pending','2025-06-10 10:40:51','2025-06-10 10:40:51'),(169,44,'TJPAYLIIAHBP','Miss Alize Keeling','xreilly@hotmail.com','0206699919','Pigeon, but in a low voice, \'Why the fact is, you ARE a simpleton.\' Alice did not answer, so Alice.',NULL,'cancelled','2025-06-10 10:40:51','2025-06-10 10:40:51'),(170,45,'672ZIEHIHKP9','Tyrique Dicki','garfield.ferry@gmail.com','0706668788','Some of the Rabbit\'s voice along--\'Catch him, you by the soldiers, who of course was, how to set.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(171,45,'DH27WTDD0ACH','Myriam Huel','barrett67@murazik.info','0979253217','However, at last the Mock Turtle. \'And how many hours a day or two: wouldn\'t it be murder to leave.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(172,46,'A8JYZZ3G6UYF','Jaden Greenfelder','aryanna.veum@boyer.com','0492502681','IS that to be nothing but out-of-the-way things had happened lately, that Alice quite hungry to.',NULL,'reserved','2025-06-10 10:40:51','2025-06-10 10:40:51'),(173,46,'ZN8SHDLBX5QE','Serena Ferry','eliane48@dibbert.com','0448649445','I know!\' exclaimed Alice, who was peeping anxiously into its eyes by this time.) \'You\'re nothing.',NULL,'checked_in','2025-06-10 10:40:51','2025-06-10 10:40:51'),(174,46,'S9PELFVFV5MF','Ernesto Jenkins V','king.clyde@rice.com','0152767207','He looked at poor Alice, \'when one wasn\'t always growing larger and smaller, and being so many.',NULL,'refunded','2025-06-10 10:40:51','2025-06-10 10:40:51'),(175,47,'2CWDTFCPDRSA','Javier Graham','ubatz@rice.com','0724819986','HERE.\' \'But then,\' thought Alice, \'it\'ll never do to ask: perhaps I shall see it trot away quietly.',NULL,'pending','2025-06-10 10:40:51','2025-06-10 10:40:51'),(176,47,'WQDLIYDVZMOQ','Brielle Gerlach','maximo.gleichner@yahoo.com','0678486004','HIS time of life. The King\'s argument was, that you had been (Before she had to do with this.',NULL,'reserved','2025-06-10 10:40:51','2025-06-10 10:40:51'),(177,47,'TDKI7MSX1Q5T','Miss Violette Hegmann PhD','dangelo40@kohler.net','0635135971','Mouse splashed his way through the neighbouring pool--she could hear the Rabbit asked. \'No, I.',NULL,'transferred','2025-06-10 10:40:51','2025-06-10 10:40:51'),(178,48,'OSBBILEOQIGY','Sarah Wolf','franecki.leland@krajcik.com','0853100858','She went in search of her own mind (as well as she heard the Rabbit actually TOOK A WATCH OUT OF.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(179,48,'HIOYR3IGXDVA','Dr. Llewellyn Brekke I','erica87@kemmer.com','0026067957','Rabbit asked. \'No, I didn\'t,\' said Alice: \'three inches is such a thing before, but she knew she.',NULL,'reserved','2025-06-10 10:40:51','2025-06-10 10:40:51'),(180,49,'JWDZQBU8XLBB','Darrel Howe','cole.dortha@hotmail.com','0453667196','Alice quite jumped; but she thought it had finished this short speech, they all crowded round her.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(181,49,'KXZLQ7Z0YMCL','Domenic Hermiston','van.welch@hotmail.com','0796191262','Queen?\' said the Cat, as soon as the jury asked. \'That I can\'t show it you myself,\' the Mock.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(182,49,'XOSQNATGRK3B','Dr. Norwood Bruen','skreiger@yahoo.com','0036650217','But the snail replied \"Too far, too far!\" and gave a little house in it about four inches deep and.',NULL,'refunded','2025-06-10 10:40:51','2025-06-10 10:40:51'),(183,49,'AWLOT5TQAB2G','Mossie O\'Reilly II','casandra94@yahoo.com','0415835355','Caterpillar. \'I\'m afraid I can\'t take LESS,\' said the Cat went on, \'I must go and get ready for.',NULL,'refunded','2025-06-10 10:40:51','2025-06-10 10:40:51'),(184,49,'XJDHQWNZA3X3','Ida Rempel','esteban.hudson@kulas.biz','0063042132','White Rabbit as he could think of nothing else to do, so Alice went on at last, and managed to put.',NULL,'refunded','2025-06-10 10:40:51','2025-06-10 10:40:51'),(185,50,'GTJ0MWE4QU2R','Christelle Hand','eheller@mohr.com','0250271315','March Hare interrupted, yawning. \'I\'m getting tired of swimming about here, O Mouse!\' (Alice.',NULL,'cancelled','2025-06-10 10:40:51','2025-06-10 10:40:51'),(186,50,'BBQSP4QZK3MP','Ms. Madalyn Nikolaus PhD','littel.cedrick@yahoo.com','0230521258','But she waited patiently. \'Once,\' said the cook. \'Treacle,\' said a whiting before.\' \'I can tell.',NULL,'purchased','2025-06-10 10:40:51','2025-06-10 10:40:51'),(187,50,'PDOSY2EP2Z7L','Liza Herman','rohan.maureen@ullrich.org','0522343697','Improve his shining tail, And pour the waters of the players to be no sort of thing never.',NULL,'pending','2025-06-10 10:40:51','2025-06-10 10:40:51'),(188,50,'M7VG2VZY84V2','Brendan Roob','adriel.larson@moore.com','0279823172','She had not gone much farther before she came upon a low voice, \'Why the fact is, you see, Alice.',NULL,'transferred','2025-06-10 10:40:51','2025-06-10 10:40:51');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:40:31','2025-06-10 10:40:31','Dolor recusandae provident culpa nam deleniti maiores. At et quia cupiditate sed debitis nisi.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:40:31','2025-06-10 10:40:31','Aut rerum ad quo. Excepturi voluptatem sunt ipsa nisi velit aperiam dolorum.'),(3,'Event Experience',0,'published','2025-06-10 10:40:31','2025-06-10 10:40:31','Et ullam rerum adipisci est repudiandae. Sequi possimus debitis minus voluptatibus fuga.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:40:31','2025-06-10 10:40:31','Excepturi cumque non neque necessitatibus. Fuga vel deserunt qui commodi consequuntur.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Impedit et dolorem quo dolor velit quod.','Blanditiis ducimus hic officia culpa consectetur nam voluptatum et eligendi aspernatur odio rerum rerum ipsam consequatur rerum harum impedit earum sit facere odio nihil quidem atque iusto explicabo.',3,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(2,'Repudiandae rem nesciunt reiciendis.','Asperiores tempora at atque labore sit totam perferendis voluptatum autem velit enim totam culpa magni dolores qui vel corporis delectus voluptatem sit eos et tempora saepe impedit quas ut dignissimos.',4,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(3,'Beatae consequatur pariatur est quia praesentium nobis.','Iste nemo at ad qui ipsam velit molestias doloribus enim vel earum magni cum necessitatibus praesentium expedita qui quae aliquam vel quod quia.',3,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(4,'Blanditiis impedit unde vitae.','Corporis quis est eum eos impedit non dicta eum necessitatibus nihil dolores sunt qui sit nam provident excepturi aliquid quos fugit.',2,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(5,'Accusantium sit sequi nam.','Possimus quod dolores placeat similique sit fugit asperiores incidunt ab rerum sit consequatur molestias et quis quia impedit eum modi harum fuga et non nisi omnis quo omnis.',4,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(6,'Incidunt voluptatem temporibus possimus sint pariatur et.','Nihil est molestias ut sunt alias eligendi aut sed doloremque quam consectetur temporibus molestias nam nesciunt sed asperiores ut distinctio sit et rerum qui nihil ut quidem culpa ut amet est aspernatur incidunt.',4,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(7,'Dolore doloremque qui perferendis ipsa.','Tempora et et odio voluptas nulla ea qui enim voluptas placeat nihil sit sed unde dolorem repudiandae porro incidunt tempore quibusdam molestiae veniam ab qui dolorem hic ea.',1,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(8,'Rem beatae ut quisquam illo harum.','Laboriosam velit sint eum eos enim quia accusantium qui possimus accusamus inventore sit rerum quam deserunt error nihil ea non enim architecto ex sit dolore neque exercitationem nesciunt qui cumque illum.',1,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(9,'Repellat ad et incidunt.','Aperiam nihil consequuntur et quasi saepe quod aperiam fuga dolor aut iusto hic soluta libero consequatur optio debitis veniam esse quibusdam asperiores nemo modi velit non quod at et ut inventore et sint perspiciatis non in laboriosam.',1,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(10,'Molestiae mollitia repellendus rem et est.','Dolorem nihil aut maiores non dolor quis veniam saepe facere quia iusto aut inventore tempora sint aut voluptatem nulla corporis inventore esse at et dolor sit et incidunt reprehenderit tenetur ut et asperiores culpa temporibus quam consequatur et tempore quibusdam culpa laudantium.',3,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(11,'Omnis et minus placeat quisquam.','Unde neque culpa ea iusto reiciendis tenetur eaque sapiente amet aspernatur minus molestias aut libero iste voluptates excepturi molestiae.',4,'published','2025-06-10 10:40:31','2025-06-10 10:40:31');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Architecto qui earum et aut. Asperiores saepe quasi inventore magni voluptatem. Voluptatibus voluptatem id molestiae velit ad quo.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(2,'Ocean Views','Dolore nesciunt qui autem ut. Autem nihil expedita ut. Dignissimos omnis ut hic ea. Saepe aut quos ut molestias.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(3,'Adventure Time','Aut deleniti ad et animi ut at. Voluptatibus molestiae voluptates ut vel modi molestias dignissimos. Vel qui id beatae delectus illum vel.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(4,'City Lights','Excepturi voluptas ut ab eos sunt. Ut et aliquam ipsam cum. Eos nihil enim sint impedit exercitationem ea consequatur.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(5,'Dreamscape','Quia ex incidunt labore tempora id facere minus dicta. Qui deserunt explicabo dolores nostrum ea eos illo.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(6,'Enchanted Forest','Aspernatur velit sit nihil incidunt. Vel necessitatibus enim nisi consequatur ducimus. Sed cumque minima facilis necessitatibus quod.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(7,'Golden Hour','Exercitationem facilis aut eos consectetur alias sed. Ex dignissimos qui ad provident rem accusamus fuga et. Asperiores id assumenda assumenda harum.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(8,'Serenity','Qui id exercitationem qui vitae nihil repellendus veritatis. Rerum a consectetur ut nihil quia sint in. Vitae quas id nesciunt est.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(9,'Eternal Beauty','Laboriosam sunt magnam aliquid at optio voluptatem. Architecto magni ut sunt ea eum necessitatibus corporis. Nesciunt aut consectetur consectetur ut.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(10,'Moonlight Magic','Et quaerat officiis minima ipsam tempora inventore velit. Atque itaque et sed tenetur. Eos animi eveniet similique culpa iure ut quia sed.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(11,'Starry Night','Id molestiae officia ad voluptatem. Accusantium recusandae ut asperiores quaerat. Dolor excepturi ipsa aperiam dolores modi tenetur cum.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(12,'Hidden Gems','Culpa veniam aut eos id fugit. Vel est quod reiciendis labore et quo voluptatum. Magnam nesciunt debitis atque accusantium praesentium.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(13,'Tranquil Waters','Libero quia animi dignissimos magnam dolorem. Enim quo dolorum nisi eos illo eos illo. Porro aspernatur quaerat voluptate illum sint ut voluptas.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(14,'Urban Escape','Blanditiis architecto non reprehenderit aut et. Distinctio totam quo fuga expedita atque. Dolores illo animi modi nobis perferendis quo aut.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07'),(15,'Twilight Zone','Quod dolorum autem aut fugiat magnam praesentium. Porro harum atque vero vitae eius quisquam alias. Quam dolore recusandae aliquid neque ipsa.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:40:07','2025-06-10 10:40:07');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Accusantium non modi officia officiis. Adipisci illum esse rem in iusto. Fugit repudiandae non consequuntur vel nulla occaecati placeat quia.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Ut sed quia quia dolorem sequi voluptas incidunt quia. Dolore eveniet fuga ex odio aut occaecati animi. Dolores vel tempora aliquid.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Expedita nisi harum iure neque. Voluptatum possimus est quasi illum laudantium. Ipsa et dolores dicta adipisci.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Ea ad voluptas et natus. Porro commodi laboriosam molestias id consequatur. Excepturi facilis aut reprehenderit non natus.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Ipsa et est hic eius qui. Quis animi sint quo labore.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Accusantium quisquam eos modi. Deserunt eaque dolores vel quas possimus animi. Provident sit rem omnis dicta. Molestias sint pariatur est.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Reiciendis velit voluptatibus et tempora voluptatum et. Et facilis voluptatem voluptatem nobis aut porro dolorum quibusdam.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Error quia voluptas quidem ut est autem rerum. Porro laudantium omnis culpa voluptate. Sit sed iste ullam corrupti.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Debitis adipisci vero quos in. Delectus cupiditate consectetur consequatur et. Occaecati est possimus repudiandae animi consequuntur minima nam vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Repellat illum eius sit reprehenderit impedit laudantium adipisci. Quo placeat ea excepturi rerum voluptas fugiat quaerat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Molestiae necessitatibus aut consequuntur. Cumque enim ea et consequatur qui repellat error.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores dolor eos et sapiente. A rerum occaecati possimus optio praesentium quod atque officiis. Vel accusamus non dolorem sit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Dolor iste aut qui fugit. Ut facilis et eos. Ipsa expedita id delectus magnam.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Facere sunt alias fugiat qui quidem. Quia rerum tempore ipsum nulla aliquam. Est a dolor veritatis distinctio a.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Soluta quasi veritatis ut odio similique et praesentium. Iusto occaecati nihil non sequi. Quas eum ut asperiores in quia dolor.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Vel sit accusamus iusto est. Fuga ab quia rerum eos neque perferendis. Nulla voluptatibus molestiae atque illo.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Eos qui delectus magni consequatur quo. Praesentium possimus et ut quidem voluptas sint adipisci. Delectus explicabo animi ratione sequi molestiae.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Autem numquam nobis qui ea veniam id voluptatem. Mollitia rerum a maxime inventore. Commodi et nemo doloremque rerum qui quae est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Vitae iure qui esse repellendus tempora enim. Nobis impedit et incidunt et rem autem voluptatem. Rem fuga molestias et nihil.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Placeat culpa harum nihil amet. Illum et dolorem facere ea doloremque. Laboriosam consectetur ut sed accusantium ea ut molestiae.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:40:07','2025-06-10 10:40:07');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','e116a1cba4a616673b55d96ab80bd139',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','91d0bdb8ed9cd1392c0844286d00ea33',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','7521e2ba5d0c912c209e8c5cb929460c',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:40:08','2025-06-10 10:40:08',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:40:08','2025-06-10 10:40:08',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:40:08','2025-06-10 10:40:08',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:40:08','2025-06-10 10:40:08',NULL,'public'),(36,0,'brand-img1','brand-img1',5,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(37,0,'brand-img2','brand-img2',5,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(38,0,'brand-img3','brand-img3',5,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(39,0,'brand-img4','brand-img4',5,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(40,0,'brand-img5','brand-img5',5,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(41,0,'brand-img6','brand-img6',5,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(42,0,'brand-img7','brand-img7',5,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(43,0,'brand-img8','brand-img8',5,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:40:09','2025-06-10 10:40:09',NULL,'public'),(44,0,'1','1',6,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:40:10','2025-06-10 10:40:10',NULL,'public'),(45,0,'2','2',6,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:40:10','2025-06-10 10:40:10',NULL,'public'),(46,0,'header-bg4','header-bg4',6,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:40:10','2025-06-10 10:40:10',NULL,'public'),(47,0,'hero-banner-bg','hero-banner-bg',6,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:40:11','2025-06-10 10:40:11',NULL,'public'),(48,0,'image-1','image-1',6,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:40:12','2025-06-10 10:40:12',NULL,'public'),(49,0,'newsletter-bg','newsletter-bg',6,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:40:13','2025-06-10 10:40:13',NULL,'public'),(50,0,'pricing-name','pricing-name',6,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:40:13','2025-06-10 10:40:13',NULL,'public'),(51,0,'speakers-bg','speakers-bg',6,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:40:13','2025-06-10 10:40:13',NULL,'public'),(52,0,'balloons','balloons',7,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:40:13','2025-06-10 10:40:13',NULL,'public'),(53,0,'calendar','calendar',7,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(54,0,'clock','clock',7,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(55,0,'coding','coding',7,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(56,0,'idea','idea',7,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(57,0,'instagram-icon','instagram-icon',7,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(58,0,'location-icon','location-icon',7,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:40:14','2025-06-10 10:40:14',NULL,'public'),(59,0,'location','location',7,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(60,0,'mail-icon','mail-icon',7,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(61,0,'menu','menu',7,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(62,0,'microphone','microphone',7,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(63,0,'phone-icon','phone-icon',7,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(64,0,'search','search',7,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(65,0,'speaker','speaker',7,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:40:15','2025-06-10 10:40:15',NULL,'public'),(66,0,'ticket','ticket',7,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:40:16','2025-06-10 10:40:16',NULL,'public'),(67,0,'user','user',7,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:40:16','2025-06-10 10:40:16',NULL,'public'),(68,0,'view','view',7,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:40:16','2025-06-10 10:40:16',NULL,'public'),(69,0,'workshop','workshop',7,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:40:16','2025-06-10 10:40:16',NULL,'public'),(70,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:40:16','2025-06-10 10:40:16',NULL,'public'),(71,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:40:17','2025-06-10 10:40:17',NULL,'public'),(72,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:40:17','2025-06-10 10:40:17',NULL,'public'),(73,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:40:17','2025-06-10 10:40:17',NULL,'public'),(74,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:40:18','2025-06-10 10:40:18',NULL,'public'),(75,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:40:18','2025-06-10 10:40:18',NULL,'public'),(76,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:40:18','2025-06-10 10:40:18',NULL,'public'),(77,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:40:18','2025-06-10 10:40:18',NULL,'public'),(78,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:40:19','2025-06-10 10:40:19',NULL,'public'),(79,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:40:19','2025-06-10 10:40:19',NULL,'public'),(80,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:40:19','2025-06-10 10:40:19',NULL,'public'),(81,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:40:20','2025-06-10 10:40:20',NULL,'public'),(82,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:40:20','2025-06-10 10:40:20',NULL,'public'),(83,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:40:20','2025-06-10 10:40:20',NULL,'public'),(84,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:40:21','2025-06-10 10:40:21',NULL,'public'),(85,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:40:21','2025-06-10 10:40:21',NULL,'public'),(86,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:40:21','2025-06-10 10:40:21',NULL,'public'),(87,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:40:22','2025-06-10 10:40:22',NULL,'public'),(88,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:40:22','2025-06-10 10:40:22',NULL,'public'),(89,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:40:22','2025-06-10 10:40:22',NULL,'public'),(90,0,'about-us-information-1','about-us-information-1',9,'image/webp',6939,'homepage03/general/about-us-information-1.webp','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(91,0,'about-us-information-2','about-us-information-2',9,'image/webp',2537,'homepage03/general/about-us-information-2.webp','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(92,0,'about-us-information-3','about-us-information-3',9,'image/webp',3508,'homepage03/general/about-us-information-3.webp','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(93,0,'about-us-information-4','about-us-information-4',9,'image/webp',3217,'homepage03/general/about-us-information-4.webp','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(94,0,'event-upcoming-widget-image','event-upcoming-widget-image',9,'image/png',5169,'homepage03/general/event-upcoming-widget-image.png','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(95,0,'logo-dark','logo-dark',9,'image/png',1811,'homepage03/general/logo-dark.png','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(96,0,'logo','logo',9,'image/png',812,'homepage03/general/logo.png','[]','2025-06-10 10:40:23','2025-06-10 10:40:23',NULL,'public'),(97,0,'contact-information-bg','contact-information-bg',10,'image/png',50560,'homepage03/backgrounds/contact-information-bg.png','[]','2025-06-10 10:40:24','2025-06-10 10:40:24',NULL,'public'),(98,0,'contact-information-icon-bg','contact-information-icon-bg',10,'image/png',5628,'homepage03/backgrounds/contact-information-icon-bg.png','[]','2025-06-10 10:40:24','2025-06-10 10:40:24',NULL,'public'),(99,0,'header-bg','header-bg',10,'image/webp',38328,'homepage03/backgrounds/header-bg.webp','[]','2025-06-10 10:40:24','2025-06-10 10:40:24',NULL,'public'),(100,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:40:24','2025-06-10 10:40:24',NULL,'public'),(101,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:40:25','2025-06-10 10:40:25',NULL,'public'),(102,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:40:25','2025-06-10 10:40:25',NULL,'public'),(103,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:40:25','2025-06-10 10:40:25',NULL,'public'),(104,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:40:26','2025-06-10 10:40:26',NULL,'public'),(105,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:40:26','2025-06-10 10:40:26',NULL,'public'),(106,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:40:26','2025-06-10 10:40:26',NULL,'public'),(107,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:40:27','2025-06-10 10:40:27',NULL,'public'),(108,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:40:27','2025-06-10 10:40:27',NULL,'public'),(109,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:40:27','2025-06-10 10:40:27',NULL,'public'),(110,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:40:28','2025-06-10 10:40:28',NULL,'public'),(111,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:40:28','2025-06-10 10:40:28',NULL,'public'),(112,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:40:28','2025-06-10 10:40:28',NULL,'public'),(113,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:40:28','2025-06-10 10:40:28',NULL,'public'),(114,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:40:29','2025-06-10 10:40:29',NULL,'public'),(115,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:40:29','2025-06-10 10:40:29',NULL,'public'),(116,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:40:29','2025-06-10 10:40:29',NULL,'public'),(117,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:40:30','2025-06-10 10:40:30',NULL,'public'),(118,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:40:30','2025-06-10 10:40:30',NULL,'public'),(119,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:40:30','2025-06-10 10:40:30',NULL,'public'),(120,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:40:31','2025-06-10 10:40:31',NULL,'public'),(121,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:40:31','2025-06-10 10:40:31',NULL,'public'),(122,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(123,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(124,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(125,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(126,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(127,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:40:32','2025-06-10 10:40:32',NULL,'public'),(128,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(129,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(130,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(131,0,'1','1',12,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(132,0,'10','10',12,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(133,0,'11','11',12,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:40:33','2025-06-10 10:40:33',NULL,'public'),(134,0,'2','2',12,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(135,0,'3','3',12,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(136,0,'4','4',12,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(137,0,'5','5',12,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(138,0,'6','6',12,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(139,0,'7','7',12,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:40:34','2025-06-10 10:40:34',NULL,'public'),(140,0,'8','8',12,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:40:35','2025-06-10 10:40:35',NULL,'public'),(141,0,'9','9',12,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:40:35','2025-06-10 10:40:35',NULL,'public'),(142,0,'0','0',13,'image/webp',33268,'main/events/0-1749552041.webp','[]','2025-06-10 10:40:41','2025-06-10 10:40:41',NULL,'public'),(143,0,'1','1',13,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:40:41','2025-06-10 10:40:41',NULL,'public'),(144,0,'10','10',13,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:40:41','2025-06-10 10:40:41',NULL,'public'),(145,0,'11','11',13,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:40:42','2025-06-10 10:40:42',NULL,'public'),(146,0,'12','12',13,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:40:42','2025-06-10 10:40:42',NULL,'public'),(147,0,'13','13',13,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:40:42','2025-06-10 10:40:42',NULL,'public'),(148,0,'14','14',13,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:40:43','2025-06-10 10:40:43',NULL,'public'),(149,0,'15','15',13,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:40:43','2025-06-10 10:40:43',NULL,'public'),(150,0,'16','16',13,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:40:43','2025-06-10 10:40:43',NULL,'public'),(151,0,'17','17',13,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:40:43','2025-06-10 10:40:43',NULL,'public'),(152,0,'18','18',13,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:40:44','2025-06-10 10:40:44',NULL,'public'),(153,0,'19','19',13,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:40:44','2025-06-10 10:40:44',NULL,'public'),(154,0,'2','2',13,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:40:44','2025-06-10 10:40:44',NULL,'public'),(155,0,'20','20',13,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:40:45','2025-06-10 10:40:45',NULL,'public'),(156,0,'3','3',13,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:40:45','2025-06-10 10:40:45',NULL,'public'),(157,0,'4','4',13,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:40:45','2025-06-10 10:40:45',NULL,'public'),(158,0,'5','5',13,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:40:46','2025-06-10 10:40:46',NULL,'public'),(159,0,'6','6',13,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:40:46','2025-06-10 10:40:46',NULL,'public'),(160,0,'7','7',13,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:40:46','2025-06-10 10:40:46',NULL,'public'),(161,0,'8','8',13,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:40:47','2025-06-10 10:40:47',NULL,'public'),(162,0,'9','9',13,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:40:47','2025-06-10 10:40:47',NULL,'public'),(163,0,'1','1',14,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:40:59','2025-06-10 10:40:59',NULL,'public'),(164,0,'2','2',14,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:40:59','2025-06-10 10:40:59',NULL,'public'),(165,0,'3','3',14,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:41:00','2025-06-10 10:41:00',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:39:59','2025-06-10 10:39:59',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:39:59','2025-06-10 10:39:59',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:40:01','2025-06-10 10:40:01',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:40:08','2025-06-10 10:40:08',NULL),(5,0,'brands',NULL,'brands',1,'2025-06-10 10:40:08','2025-06-10 10:40:08',NULL),(6,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:40:10','2025-06-10 10:40:10',NULL),(7,0,'icons',NULL,'icons',1,'2025-06-10 10:40:13','2025-06-10 10:40:13',NULL),(8,0,'homepage03',NULL,'homepage03',0,'2025-06-10 10:40:23','2025-06-10 10:40:23',NULL),(9,0,'general',NULL,'general',8,'2025-06-10 10:40:23','2025-06-10 10:40:23',NULL),(10,0,'backgrounds',NULL,'backgrounds',8,'2025-06-10 10:40:24','2025-06-10 10:40:24',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:40:24','2025-06-10 10:40:24',NULL),(12,0,'speakers',NULL,'speakers',1,'2025-06-10 10:40:33','2025-06-10 10:40:33',NULL),(13,0,'events',NULL,'events',1,'2025-06-10 10:40:41','2025-06-10 10:40:41',NULL),(14,0,'sliders',NULL,'sliders',1,'2025-06-10 10:40:59','2025-06-10 10:40:59',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:40:59','2025-06-10 10:40:59');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:40:59','2025-06-10 10:40:59');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:40:59','2025-06-10 10:40:59');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:40:08','2025-06-10 10:40:08'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:40:08','2025-06-10 10:40:08'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:40:08','2025-06-10 10:40:08'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:40:08','2025-06-10 10:40:08'),(5,'breadcrumb_background_image','[\"\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:40:22','2025-06-10 10:40:24'),(6,'breadcrumb_text_color','[\"\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:40:22','2025-06-10 10:40:24'),(7,'title','[\"Quality Assurance\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(8,'description','[\"Five and Seven said nothing, but looked at her, and said, \'That\'s right, Five! Always lay the blame on others!\' \'YOU\'D better not do that again!\' which produced another dead silence. \'It\'s a pun!\'.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(9,'address','[\"1303 Steuber Meadow\\nPaucekton, MD 70314\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(11,'title','[\"Frontend Developer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(12,'description','[\"Mock Turtle would be quite as much as serpents do, you know.\' \'Not the same thing with you,\' said the Duchess; \'and most of \'em do.\' \'I don\'t know much,\' said the Dormouse: \'not in that poky little.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(13,'address','[\"658 Dillon Island Apt. 591\\nArlenechester, HI 30709-9187\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(15,'title','[\"Frontend Developer\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(16,'description','[\"CHAPTER VIII. The Queen\'s Croquet-Ground A large rose-tree stood near the entrance of the song, she kept on puzzling about it in large letters. It was so long that they would call after her: the.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(17,'address','[\"234 Bartoletti Burgs\\nNorth Rubyechester, DC 17117\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:35','2025-06-10 10:40:35'),(19,'title','[\"Quality Assurance\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(20,'description','[\"Ugh, Serpent!\' \'But I\'m not particular as to go down the chimney?--Nay, I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go down the bottle, she found this a good deal on where you want to see.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(21,'address','[\"520 Block Meadow Suite 360\\nLake Adriana, NE 77908-1742\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(23,'title','[\"Product Manager\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(24,'description','[\"Alice did not answer, so Alice soon began talking to herself, \'I don\'t know what they\'re like.\' \'I believe so,\' Alice replied thoughtfully. \'They have their tails fast in their proper places--ALL,\'.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(25,'address','[\"75863 Lilian Expressway\\nEast Gideon, IN 54243\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(27,'title','[\"Frontend Developer\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(28,'description','[\"Dormouse, who was sitting on the spot.\' This did not like to go near the looking-glass. There was not a bit afraid of them!\' \'And who is to France-- Then turn not pale, beloved snail, but come and.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(29,'address','[\"26303 Pacocha Tunnel Suite 288\\nLeslieburgh, NH 31294-3897\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(31,'title','[\"Fullstack Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(32,'description','[\"I\'m not looking for eggs, as it can be,\' said the Cat, \'if you don\'t even know what \\\"it\\\" means well enough, when I grow up, I\'ll write one--but I\'m grown up now,\' she added aloud. \'Do you mean.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(33,'address','[\"7345 Boyer Views Suite 585\\nSouth Queen, MN 98519-5915\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(35,'title','[\"Project Manager\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(36,'description','[\"The Hatter was out of THIS!\' (Sounds of more energetic remedies--\' \'Speak English!\' said the Queen, and Alice thought to herself. At this moment Five, who had got to do,\' said the youth, \'as I.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(37,'address','[\"7332 Emmerich Passage Suite 214\\nSwaniawskistad, SD 45075-1676\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(39,'title','[\"Project Manager\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(40,'description','[\"Alice. \'Call it what you mean,\' said Alice. \'What IS a long tail, certainly,\' said Alice, in a tone of great relief. \'Now at OURS they had any sense, they\'d take the hint; but the Gryphon repeated.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(41,'address','[\"3642 Gage Junctions Apt. 334\\nReillyburgh, IL 26790\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:36','2025-06-10 10:40:36'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(43,'title','[\"Frontend Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(44,'description','[\"After a time she had wept when she had known them all her knowledge of history, Alice had learnt several things of this sort of people live about here?\' \'In THAT direction,\' waving the other.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(45,'address','[\"905 Lesch Common\\nSouth Joshua, WA 74285-9458\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(47,'title','[\"Frontend Developer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(48,'description','[\"Bill! the master says you\'re to go on. \'And so these three little sisters--they were learning to draw,\' the Dormouse turned out, and, by the pope, was soon left alone. \'I wish the creatures argue.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(49,'address','[\"9031 Schmitt Spurs\\nJaydeside, RI 02730\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(51,'title','[\"UX\\/UI Designer\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(52,'description','[\"I\'d only been the whiting,\' said the Caterpillar. \'Is that the poor little thing was waving its tail about in all their simple joys, remembering her own children. \'How should I know?\' said Alice.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(53,'address','[\"70937 Parker Throughway\\nRyleeborough, NC 22432-1822\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(55,'title','[\"Frontend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(56,'description','[\"MORE than nothing.\' \'Nobody asked YOUR opinion,\' said Alice. \'Oh, don\'t bother ME,\' said the Hatter. \'Nor I,\' said the Cat, and vanished again. Alice waited patiently until it chose to speak again.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(57,'address','[\"6390 Triston Dam\\nLeathabury, OR 35480\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(59,'title','[\"Product Manager\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(60,'description','[\"Alice, quite forgetting her promise. \'Treacle,\' said a timid voice at her for a minute or two, looking for them, but they began running about in a hurried nervous manner, smiling at everything that.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(61,'address','[\"154 Chadrick Cape Apt. 510\\nSouth Devante, NY 02115-9378\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:37','2025-06-10 10:40:37'),(63,'title','[\"Fullstack Developer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(64,'description','[\"Between yourself and me.\' \'That\'s the first witness,\' said the Caterpillar; and it put more simply--\\\"Never imagine yourself not to make out at all for any lesson-books!\' And so it was very deep, or.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(65,'address','[\"1372 Friesen Summit Suite 897\\nCristburgh, WA 22828-0048\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(67,'title','[\"Project Manager\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(68,'description','[\"Tell me that first, and then nodded. \'It\'s no business of MINE.\' The Queen turned angrily away from her as she spoke--fancy CURTSEYING as you\'re falling through the glass, and she had never been in.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(69,'address','[\"6704 Corwin Fork Apt. 127\\nSouth Jakobborough, OR 15877\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(71,'title','[\"Project Manager\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(72,'description','[\"She was walking by the officers of the creature, but on second thoughts she decided on going into the court, by the little door, had vanished completely. Very soon the Rabbit hastily interrupted.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(73,'address','[\"969 Odie Road Suite 056\\nEast Andreannemouth, UT 97770\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(75,'title','[\"Product Manager\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(76,'description','[\"I don\'t take this child away with me,\' thought Alice, \'it\'ll never do to ask: perhaps I shall only look up in her life; it was the only difficulty was, that she let the Dormouse into the teapot. \'At.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(77,'address','[\"803 Farrell Run\\nFriesenhaven, NJ 80487\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(79,'title','[\"DevOps Engineer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(80,'description','[\"Alice said to the three gardeners who were all locked; and when she was in livery: otherwise, judging by his garden, and marked, with one finger pressed upon its nose. The Dormouse had closed its.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(81,'address','[\"412 Rodriguez Station\\nNorth Charity, FL 42207\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(83,'title','[\"System Administrator\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(84,'description','[\"Alice. \'And where HAVE my shoulders got to? And oh, my poor little feet, I wonder who will put on her spectacles, and began an account of the singers in the pool, \'and she sits purring so nicely by.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(85,'address','[\"76233 Stoltenberg Oval\\nPort Johnpaulbury, ND 36025\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:38','2025-06-10 10:40:38'),(87,'title','[\"DevOps Engineer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(88,'description','[\"I know THAT well enough; and what does it matter to me whether you\'re nervous or not.\' \'I\'m a poor man, your Majesty,\' said the Gryphon. \'It all came different!\' Alice replied in an offended tone.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(89,'address','[\"6245 Lesch Creek Apt. 904\\nNorth Nichole, FL 81661\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(91,'title','[\"Project Manager\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(92,'description','[\"The Antipathies, I think--\' (she was rather glad there WAS no one else seemed inclined to say but \'It belongs to the heads of the garden: the roses growing on it were nine o\'clock in the last.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(93,'address','[\"5310 Mraz Isle\\nHackettmouth, MD 12198\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(95,'title','[\"System Administrator\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(96,'description','[\"Alice. It looked good-natured, she thought: still it had finished this short speech, they all quarrel so dreadfully one can\'t hear oneself speak--and they don\'t give birthday presents like that!\' He.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(97,'address','[\"81745 Monahan Track\\nBoscotown, DC 63490-3860\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(99,'title','[\"System Administrator\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(100,'description','[\"I should frighten them out again. The Mock Turtle went on, yawning and rubbing its eyes, for it to be no use in the last few minutes, and began picking them up again with a trumpet in one hand, and.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(101,'address','[\"2295 Lavon Island Apt. 482\\nLake Brian, CT 73484-7316\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(103,'title','[\"Backend Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(104,'description','[\"For instance, suppose it were nine o\'clock in the distance would take the place of the Gryphon, \'she wants for to know your history, you know,\' the Mock Turtle drew a long argument with the other.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(105,'address','[\"339 Merlin Plaza\\nNorth Dougborough, AL 95301-8180\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:39','2025-06-10 10:40:39'),(107,'title','[\"Frontend Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(108,'description','[\"Caterpillar\'s making such VERY short remarks, and she went round the refreshments!\' But there seemed to have wondered at this, she looked up, and there she saw maps and pictures hung upon pegs. She.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(109,'address','[\"8415 Heaney Heights Apt. 454\\nBoyleshire, SD 83223-9942\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(111,'title','[\"Project Manager\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(112,'description','[\"King, going up to Alice, and she swam about, trying to box her own child-life, and the whole head appeared, and then the puppy made another rush at Alice the moment she appeared; but she stopped.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(113,'address','[\"4861 Lowe Gardens\\nMullerbury, KY 79360\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(115,'title','[\"DevOps Engineer\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(116,'description','[\"Alice thought), and it was out of breath, and said to the table, but it did not like to show you! A little bright-eyed terrier, you know, and he went on muttering over the wig, (look at the house.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(117,'address','[\"2881 Hilda Forest Suite 941\\nPort Jessica, MA 70918\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(119,'title','[\"System Administrator\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(120,'description','[\"They all made a snatch in the last words out loud, and the constant heavy sobbing of the court,\\\" and I had to sing \\\"Twinkle, twinkle, little bat! How I wonder what you\'re at!\\\" You know the song.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(121,'address','[\"2294 Carleton Mount Suite 484\\nEast Wilfredoport, IA 82955\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(123,'title','[\"Fullstack Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(124,'description','[\"I\'M a Duchess,\' she said to herself; \'I should have croqueted the Queen\'s shrill cries to the end of the ground.\' So she began nibbling at the door-- Pray, what is the same thing a Lobster Quadrille.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(125,'address','[\"2432 Leone Trafficway Apt. 922\\nWildermanside, AR 84073\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(127,'title','[\"Frontend Developer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(128,'description','[\"I never understood what it meant till now.\' \'If that\'s all the arches are gone from this morning,\' said Alice as it was a child,\' said the Hatter: \'I\'m on the floor, and a large arm-chair at one and.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(129,'address','[\"15516 Kuhn Parkway\\nPort Myrnafort, MN 94286\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:40:40','2025-06-10 10:40:40'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(134,'event_id','[7]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(138,'event_id','[7]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00'),(142,'event_id','[5]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:41:00','2025-06-10 10:41:00');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner subtitle=&quot;Join the the Future of Design&quot; title=&quot;Yearly designer &lt;br&gt; Conferences &lsquo;25&quot; button_primary_label=&quot;Reserve premium Seat&quot; button_primary_url=&quot;/&quot; background_image=&quot;homepage03/backgrounds/header-bg.webp&quot; style=&quot;2&quot; circle_text=&quot;Build Success Brand .&quot;][/hero-banner][about-us-information style=&quot;4&quot; title=&quot;Explore Future Of Design At Our Yearly Conference&quot; subtitle=&quot;about our Designer conferences&quot; description=&quot;The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.&quot; button_label=&quot;Reserve premium Seat&quot; button_url=&quot;/events&quot; quantity=&quot;3&quot; title_1=&quot;Our Journalist&quot; figure_1=&quot;250&quot; title_2=&quot;Our Speaker&quot; figure_2=&quot;15&quot; title_3=&quot;Attendees&quot; figure_3=&quot;7000&quot; image=&quot;homepage03/general/about-us-information-1.webp&quot; image_1=&quot;homepage03/general/about-us-information-2.webp&quot; image_2=&quot;homepage03/general/about-us-information-3.webp&quot; image_3=&quot;homepage03/general/about-us-information-4.webp&quot;][/about-us-information][brands style=&quot;1&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#000000&quot; background_color=&quot;#F5F5F5&quot;][/brands][speakers style=&quot;3&quot; title=&quot;Our Event Speakers&quot; subtitle=&quot;our 10+ event speakers&quot; limit=&quot;8&quot; text_color=&quot;rgb(0, 0, 0)&quot;][/speakers][countdown start_date=&quot;2025-12-31&quot; background_image=&quot;main/backgrounds/header-bg4.png&quot;][/countdown][events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;5&quot; style=&quot;2&quot;][/events-schedule][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;homepage03/backgrounds/contact-information-bg.png&quot; icon_bg_image=&quot;homepage03/backgrounds/contact-information-icon-bg.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information][events title=&quot;Recent Memories 2024&quot; subtitle=&quot;Last year memory&quot; limit=&quot;5&quot; logo=&quot;main/general/logo-yellow.png&quot;][/events]',1,NULL,'homepage',NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:24'),(2,'About Us','[about-us-information style=\"4\" title=\"Explore Future Of Design At Our Yearly Conference\" subtitle=\"about our Designer conferences\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design.\" button_label=\"Reserve premium Seat\" button_url=\"/events\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" title_2=\"Our Speaker\" figure_2=\"15\" title_3=\"Attendees\" figure_3=\"7000\" image=\"homepage03/general/about-us-information-1.webp\" image_1=\"homepage03/general/about-us-information-2.webp\" image_2=\"homepage03/general/about-us-information-3.webp\" image_3=\"homepage03/general/about-us-information-4.webp\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:24'),(3,'Speakers','[speakers limit=&quot;8&quot;][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:24'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:22'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:22'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"homepage03/backgrounds/contact-information-bg.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:24'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;homepage03/backgrounds/contact-information-bg.png&quot; icon_bg_image=&quot;homepage03/backgrounds/contact-information-icon-bg.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:24'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:40:22','2025-06-10 10:40:22'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:40:23','2025-06-10 10:40:23');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'5Y1EOGHWICHH','bank_transfer',NULL,144.30,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47',NULL,NULL),(2,'1',0,'IOIU4AWQUBKE','bank_transfer',NULL,96.20,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:47','2025-06-10 10:40:47',NULL,NULL),(3,'1',0,'DKWWZQ52VVTP','bank_transfer',NULL,144.30,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(4,'1',0,'5AQPPLBXBWHX','bank_transfer',NULL,48.10,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(5,'1',0,'3HLMRJNCMNJG','bank_transfer',NULL,192.40,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(6,'1',0,'JND23QCXBD1U','bank_transfer',NULL,48.10,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(7,'1',0,'FZ6MIGVFSTY7','bank_transfer',NULL,48.10,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(8,'1',0,'HGLKKKRCN5GM','bank_transfer',NULL,48.10,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(9,'1',0,'W4JGPXOJS2RG','bank_transfer',NULL,144.30,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(10,'1',0,'GE5A89C1O0SA','bank_transfer',NULL,240.50,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(11,'1',0,'CEDHLX83N283','bank_transfer',NULL,8.54,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(12,'1',0,'2F4B13ED5EVN','bank_transfer',NULL,17.08,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(13,'1',0,'IHWGWPLQ70ON','bank_transfer',NULL,21.35,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(14,'1',0,'HZI0IQ2UGNO7','bank_transfer',NULL,4.27,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(15,'1',0,'QETXIWIKIDPR','bank_transfer',NULL,12.81,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:48','2025-06-10 10:40:48',NULL,NULL),(16,'1',0,'7MM7QOK6RIZR','bank_transfer',NULL,17.08,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(17,'1',0,'O728JMMGVUB2','bank_transfer',NULL,17.08,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(18,'1',0,'YR7JIPR2FIGQ','bank_transfer',NULL,4.27,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(19,'1',0,'SMGI7KYM7GAJ','bank_transfer',NULL,17.08,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(20,'1',0,'YW5URDELAKIE','bank_transfer',NULL,21.35,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(21,'1',0,'EZSF6ZD0LYGF','bank_transfer',NULL,114.24,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(22,'1',0,'IAO3RL7G8XJP','bank_transfer',NULL,171.36,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(23,'1',0,'8KL83MORINAV','bank_transfer',NULL,114.24,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(24,'1',0,'WXPV8SKIX9MH','bank_transfer',NULL,114.24,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(25,'1',0,'FKHMHSBYRMPK','bank_transfer',NULL,114.24,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(26,'1',0,'REXE3PO4XDWS','bank_transfer',NULL,114.24,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(27,'1',0,'PRATTJ1J1C9S','bank_transfer',NULL,57.12,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(28,'1',0,'RT1FEM1JMBQ2','bank_transfer',NULL,228.48,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:49','2025-06-10 10:40:49',NULL,NULL),(29,'1',0,'WKCE2SI2OFY0','bank_transfer',NULL,114.24,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(30,'1',0,'V2DQH3I8SYF4','bank_transfer',NULL,285.60,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(31,'1',0,'NARD9QVUED8D','bank_transfer',NULL,401.90,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(32,'1',0,'RRV2ENNHABFO','bank_transfer',NULL,241.14,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(33,'1',0,'JQRAXFEY1NIQ','bank_transfer',NULL,80.38,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(34,'1',0,'PZNPXSHRDD25','bank_transfer',NULL,321.52,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(35,'1',0,'HUSCAH6CQJOJ','bank_transfer',NULL,321.52,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(36,'1',0,'EE3ODKQKOQUO','bank_transfer',NULL,80.38,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(37,'1',0,'B7ZK9R0NFLIR','bank_transfer',NULL,321.52,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(38,'1',0,'ZJDT6RRX9YVP','bank_transfer',NULL,321.52,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(39,'1',0,'0HYUYROWT5DH','bank_transfer',NULL,160.76,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(40,'1',0,'CZYWOE5AW0OV','bank_transfer',NULL,241.14,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(41,'1',0,'E7GJRO8IUVRB','bank_transfer',NULL,96.50,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:50','2025-06-10 10:40:50',NULL,NULL),(42,'1',0,'BGH9GF5UEBLR','bank_transfer',NULL,19.30,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(43,'1',0,'U1UBPBV93EJG','bank_transfer',NULL,96.50,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(44,'1',0,'V5UKLSTDYTBL','bank_transfer',NULL,19.30,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(45,'1',0,'LTUDRXOGPILC','bank_transfer',NULL,19.30,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(46,'1',0,'HYVFOVQPGZEN','bank_transfer',NULL,38.60,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(47,'1',0,'VJCFLQY7FQKA','bank_transfer',NULL,38.60,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(48,'1',0,'UOXCVOXGZXAE','bank_transfer',NULL,19.30,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(49,'1',0,'QQFCZ0ZNH7HJ','bank_transfer',NULL,77.20,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL),(50,'1',0,'YHK5WZYRNFV4','bank_transfer',NULL,57.90,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:40:51','2025-06-10 10:40:51',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(1,1),(4,2),(1,2),(3,3),(4,3),(3,4),(1,5),(4,5),(3,6),(2,6),(3,7),(2,7),(4,8),(5,9),(5,10),(6,10),(6,11),(4,11),(4,12),(5,12),(3,13),(1,13),(3,14),(4,14),(6,15),(1,16),(4,16),(4,17),(5,17),(6,18),(5,18),(5,19),(2,19),(2,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (5,1),(1,1),(6,1),(4,2),(6,2),(5,3),(7,3),(6,3),(3,4),(2,4),(4,4),(5,5),(4,5),(6,5),(7,6),(6,6),(3,7),(3,8),(4,8),(6,9),(2,9),(3,10),(6,10),(2,11),(5,11),(5,12),(7,12),(4,13),(5,13),(3,14),(1,14),(4,14),(7,15),(3,15),(2,15),(5,16),(6,16),(2,16),(1,17),(7,17),(2,17),(5,18),(4,18),(6,18),(2,19),(3,19),(1,19),(7,20),(4,20),(1,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1502,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',1428,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',2227,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',2459,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',1427,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',2229,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',346,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1846,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',851,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',1065,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1616,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',1190,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',252,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',513,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',1419,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',1718,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',429,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',1366,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',723,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/5.jpg\" image_2=\"main/blogs/7.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',775,NULL,'2025-06-10 10:40:31','2025-06-10 10:40:31');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:40:08','2025-06-10 10:40:08');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:41:00'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:41:00'),(6,'language_hide_default','1',NULL,'2025-06-10 10:41:00'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:41:00'),(8,'language_display','all',NULL,'2025-06-10 10:41:00'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:41:00'),(10,'media_random_hash','0fe62790d6427e13e049a1311d2828c0',NULL,'2025-06-10 10:41:00'),(11,'theme','eventify-homepage03',NULL,'2025-06-10 10:41:00'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:41:00'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:41:00'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:41:00'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:41:00'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:41:00'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:41:00'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:41:00'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:41:00'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:41:00'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:41:00'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:41:00'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:41:00'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:41:00'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:41:00'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:41:00'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:41:00'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:41:00'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:41:00'),(30,'theme-eventify-homepage03-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:41:00'),(31,'theme-eventify-homepage03-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:41:00'),(32,'theme-eventify-homepage03-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:41:00'),(33,'theme-eventify-homepage03-favicon','main/general/favicon.png',NULL,'2025-06-10 10:41:00'),(34,'theme-eventify-homepage03-logo','homepage03/general/logo.png',NULL,'2025-06-10 10:41:00'),(35,'theme-eventify-homepage03-homepage_id','1',NULL,'2025-06-10 10:41:00'),(36,'theme-eventify-homepage03-blog_page_id','4',NULL,'2025-06-10 10:41:00'),(37,'theme-eventify-homepage03-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:41:00'),(38,'theme-eventify-homepage03-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:41:00'),(39,'theme-eventify-homepage03-blog_post_items_per_row','3',NULL,'2025-06-10 10:41:00'),(40,'theme-eventify-homepage03-number_of_related_posts','3',NULL,'2025-06-10 10:41:00'),(41,'theme-eventify-homepage03-breadcrumb_background_image','homepage03/backgrounds/contact-information-bg.png',NULL,'2025-06-10 10:41:00'),(42,'theme-eventify-homepage03-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:41:00'),(43,'theme-eventify-homepage03-events_page_id','5',NULL,'2025-06-10 10:41:00'),(44,'theme-eventify-homepage03-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:41:00'),(45,'theme-eventify-homepage03-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:41:00'),(46,'theme-eventify-homepage03-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:41:00'),(47,'theme-eventify-homepage03-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:41:00'),(48,'theme-eventify-homepage03-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:41:00'),(49,'theme-eventify-homepage03-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:41:00'),(50,'theme-eventify-homepage03-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:41:00'),(51,'theme-eventify-homepage03-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:41:00'),(52,'theme-eventify-homepage03-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:41:00'),(53,'theme-eventify-homepage03-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:41:00'),(54,'theme-eventify-homepage03-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:41:00'),(55,'theme-eventify-homepage03-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:41:00'),(56,'theme-eventify-homepage03-logo_height','45',NULL,'2025-06-10 10:41:00'),(57,'theme-eventify-homepage03-is_header_transparent','1',NULL,'2025-06-10 10:41:00'),(58,'theme-eventify-homepage03-display_header_top','1',NULL,'2025-06-10 10:41:00'),(59,'theme-eventify-homepage03-header_top_text_color','#000000',NULL,'2025-06-10 10:41:00'),(60,'theme-eventify-homepage03-header_top_background_color','#FFFFFF',NULL,'2025-06-10 10:41:00'),(61,'theme-eventify-homepage03-header_background_color','#ffffff',NULL,'2025-06-10 10:41:00'),(62,'theme-eventify-homepage03-header_text_color','#000000',NULL,'2025-06-10 10:41:00'),(63,'theme-eventify-homepage03-footer_background_color','#131E20',NULL,'2025-06-10 10:41:00'),(64,'theme-eventify-homepage03-footer_text_color','#ffffff',NULL,'2025-06-10 10:41:00'),(65,'theme-eventify-homepage03-footer_heading_color','#ffffff',NULL,'2025-06-10 10:41:00'),(66,'theme-eventify-homepage03-tp_primary_font','Figtree',NULL,'2025-06-10 10:41:00'),(67,'theme-eventify-homepage03-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:41:00'),(68,'theme-eventify-homepage03-primary_color','#FF3639',NULL,'2025-06-10 10:41:00'),(69,'theme-eventify-homepage03-secondary_color','#1A1719',NULL,'2025-06-10 10:41:00'),(70,'theme-eventify-homepage03-newsletter_popup_enable','1',NULL,'2025-06-10 10:41:00'),(71,'theme-eventify-homepage03-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:41:00'),(72,'theme-eventify-homepage03-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:41:00'),(73,'theme-eventify-homepage03-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:41:00'),(74,'theme-eventify-homepage03-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:41:00'),(75,'theme-eventify-homepage03-breadcrumb_background_color','#FF3639',NULL,'2025-06-10 10:41:00'),(76,'theme-eventify-homepage03-gradient_color_from','#FF5000',NULL,'2025-06-10 10:41:00'),(77,'theme-eventify-homepage03-gradient_color_to','#FF00B8',NULL,'2025-06-10 10:41:00'),(78,'announcement_max_width','1210',NULL,'2025-06-10 10:41:00'),(79,'announcement_text_color','#000000',NULL,'2025-06-10 10:41:00'),(80,'announcement_background_color','transparent',NULL,'2025-06-10 10:41:00'),(81,'announcement_text_alignment','start',NULL,'2025-06-10 10:41:00'),(82,'announcement_dismissible','0',NULL,'2025-06-10 10:41:00'),(83,'announcement_font_size','14',NULL,'2025-06-10 10:41:00'),(84,'announcement_font_size_unit','px',NULL,'2025-06-10 10:41:00'),(85,'announcement_placement','theme',NULL,'2025-06-10 10:41:00'),(86,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:41:00','2025-06-10 10:41:00'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:41:00','2025-06-10 10:41:00'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:41:00','2025-06-10 10:41:00');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:41:00','2025-06-10 10:41:00');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=150 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:40:07','2025-06-10 10:40:07'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:22','2025-06-10 10:40:22'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:23','2025-06-10 10:40:23'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:40:23','2025-06-10 10:40:23'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:40:31','2025-06-10 10:40:31'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:40:31','2025-06-10 10:40:31'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:35','2025-06-10 10:40:35'),(59,'ibrahim-kunze-v',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:35','2025-06-10 10:40:35'),(60,'cary-osinski',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:36','2025-06-10 10:40:36'),(61,'frederik-aufderhar',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:36','2025-06-10 10:40:36'),(62,'brady-parker',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:36','2025-06-10 10:40:36'),(63,'rahul-prosacco',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:36','2025-06-10 10:40:36'),(64,'beulah-johnson',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:37','2025-06-10 10:40:37'),(65,'adriana-schulist',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:37','2025-06-10 10:40:37'),(66,'ima-nitzsche',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:38','2025-06-10 10:40:38'),(67,'prof-dedric-baumbach-i',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:38','2025-06-10 10:40:38'),(68,'bonita-kuhic-dds',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:38','2025-06-10 10:40:38'),(69,'antoinette-jenkins',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:38','2025-06-10 10:40:38'),(70,'dr-donald-feil-phd',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:39','2025-06-10 10:40:39'),(71,'hubert-miller',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:39','2025-06-10 10:40:39'),(72,'mrs-hosea-koelpin',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:39','2025-06-10 10:40:39'),(73,'brenden-koch',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:40','2025-06-10 10:40:40'),(74,'anahi-jaskolski',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:40','2025-06-10 10:40:40'),(75,'leslie-brakus',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:40','2025-06-10 10:40:40'),(76,'dr-eliza-weber',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:40','2025-06-10 10:40:40'),(77,'norbert-hermann',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:40:40','2025-06-10 10:40:40'),(78,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(79,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(80,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(81,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(82,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(83,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(84,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(85,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(86,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(87,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:40:47','2025-06-10 10:40:47'),(88,'macy-yost-jr',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(89,'edwin-miller-md',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(90,'giles-mann',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(91,'effie-zboncak',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(92,'maegan-schulist',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(93,'mr-aron-dietrich-jr',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(94,'leanne-hartmann',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(95,'carlee-hansen',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(96,'mr-chesley-greenholt',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(97,'prof-zena-barrows',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(98,'blanche-maggio',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(99,'mr-jordi-spencer',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(100,'dr-brock-paucek-iii',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(101,'prof-simone-nolan-dvm',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(102,'nicholas-reinger',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(103,'ms-zola-osinski-iii',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(104,'yolanda-schimmel',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(105,'bernhard-okuneva-md',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(106,'raphaelle-keebler-jr',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(107,'eva-kirlin',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(108,'zula-kreiger',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(109,'elmer-rolfson',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(110,'roosevelt-cassin',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(111,'prof-amie-oconnell-sr',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(112,'elwin-waters-jr',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(113,'mr-jamey-hodkiewicz-md',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(114,'miss-lyla-greenfelder-sr',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(115,'mr-vincenzo-crona-dds',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(116,'ms-adaline-sporer-v',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(117,'tia-jaskolski',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(118,'orland-steuber',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(119,'morgan-bechtelar',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(120,'dr-erna-bradtke-iii',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(121,'ms-thea-cormier-ii',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(122,'bartholome-armstrong',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(123,'loyal-jast',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(124,'dr-daphney-watsica-dvm',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(125,'alec-sporer-phd',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(126,'miss-kacie-graham-md',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(127,'wilfred-johnston-jr',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(128,'patience-powlowski',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(129,'prof-aric-pfannerstill-iii',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(130,'mr-filiberto-harvey-jr',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(131,'adelbert-abbott',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(132,'violette-thompson',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(133,'mrs-trudie-predovic',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(134,'prof-kallie-hagenes',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(135,'dashawn-dickinson',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(136,'dr-magnus-yundt',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(137,'catharine-ondricka',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(138,'joesph-braun',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(139,'cornelius-schiller',72,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(140,'dr-matilde-adams-phd',73,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(141,'miss-alize-keeling',74,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(142,'tyrique-dicki',75,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:00','2025-06-10 10:41:00'),(143,'myriam-huel',76,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(144,'jaden-greenfelder',77,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(145,'serena-ferry',78,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(146,'ernesto-jenkins-v',79,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(147,'javier-graham',80,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(148,'brielle-gerlach',81,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01'),(149,'miss-violette-hegmann-phd',82,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:01','2025-06-10 10:41:01');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:40:40','2025-06-10 10:40:40');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:40:31','2025-06-10 10:40:31');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:40:08','2025-06-10 10:40:08'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:40:08','2025-06-10 10:40:08'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:40:08','2025-06-10 10:40:08'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:40:08','2025-06-10 10:40:08');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'rowena.parisian@medhurst.com',NULL,'$2y$12$QzJ9NIIXQuXagHmGEYyeuOD9otScjBtaG8gC9iHyd3s7FZVvk1qRq',NULL,'2025-06-10 10:40:08','2025-06-10 10:40:08','Jarrett','Maggio','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage03',1,'[]','2025-06-10 10:40:24','2025-06-10 10:40:24'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage03',2,'[]','2025-06-10 10:40:24','2025-06-10 10:40:24'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage03',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"homepage03\\/general\\/logo-dark.png\"}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage03',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage03',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage03',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(7,'EventListWidget','event_list_sidebar','eventify-homepage03',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage03',1,'[]','2025-06-10 10:40:24','2025-06-10 10:40:24'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage03',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage03',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage03',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage03',1,'{\"button_label\":\"Buy Ticket\",\"background_image\":\"homepage03\\/backgrounds\\/header-bg.webp\",\"image\":\"homepage03\\/general\\/event-upcoming-widget-image.png\"}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage03',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:40:24','2025-06-10 10:40:24'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage03',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:40:24','2025-06-10 10:40:24');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:41:01
