-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'qEwPjik4C9EjrEoSM2U0uN3eLiSPoAUX',1,'2025-06-10 10:41:15','2025-06-10 10:41:15','2025-06-10 10:41:15');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:42:03',NULL,1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:42:03',NULL,1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:42:03',NULL,1,'2025-06-10 10:42:03','2025-06-10 10:42:03');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Hic porro et odit dolores. Omnis possimus architecto voluptate officia facilis et quaerat. Dolorum numquam possimus quis error. Suscipit repellat sint et.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(2,'Leadership &amp; Strategy',0,'Voluptas quia cupiditate ullam commodi illo et. Dolorem facilis rerum neque illo. Deleniti molestiae sunt dicta. Consequuntur ex delectus explicabo enim error. Voluptate quis tenetur molestias non.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(3,'Networking &amp; Collaboration',0,'Aliquid est id et animi ut. Quaerat sed eveniet illo repudiandae totam iusto. Quae iusto quidem accusantium dolorem eos eaque voluptatum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(4,'Entrepreneurship Startups',0,'Ipsam non ipsum illo quibusdam. Alias ut perferendis commodi ab. Rerum est unde minus.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(5,'Marketing &amp; Branding',0,'Animi repellendus sit quae earum ut eligendi sed. Aut eaque explicabo explicabo at. Dolor et autem dolores ea ut.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(6,'Event Highlights &amp; Recaps',0,'Voluptates rem et vel rerum vitae. Asperiores ducimus laboriosam culpa. Consectetur nihil inventore aliquid maiores id. Exercitationem laudantium qui qui mollitia.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:41:36','2025-06-10 10:41:36');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Ernestine DuBuque','amber.roberts@example.com','+1-385-686-8234','8984 Osinski Trail Apt. 971\nKatrineside, IN 24772','Ut id numquam et consectetur.','Quo sapiente perspiciatis qui sit perferendis. Provident beatae eaque reiciendis. Vitae omnis suscipit quia. Magni enim beatae aspernatur amet iste vitae et quia. Molestiae omnis quis ea eligendi accusantium rerum quos. Et esse saepe ut voluptate quibusdam voluptates. Culpa non totam harum vel. Harum unde quia aut nisi consequatur ipsum magni sint. Deserunt tempore est non possimus porro vel.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(2,'Felipa Hartmann IV','zechariah.lueilwitz@example.net','+1-706-269-1487','308 Abshire Village Suite 052\nCristton, VT 98377-2493','Autem atque excepturi corrupti blanditiis iusto.','Reiciendis error cumque repellendus in ad. Debitis deleniti dolore velit vero doloremque similique. Tempora omnis ratione libero maxime ex quaerat. Quae sit molestiae possimus dolor inventore odio. Temporibus numquam error voluptatibus. Et maiores dolores at fugiat. Quam sint sequi amet. Sit fuga facilis est aut occaecati. Incidunt est hic qui reprehenderit autem ea. Quas non voluptatem aut. Porro dolore a ab possimus porro facere error.',NULL,'read','2025-06-10 10:41:15','2025-06-10 10:41:15'),(3,'Uriah Blanda','helmer91@example.net','+1.213.815.6618','356 Romaguera River Suite 210\nNorth Hoseaside, HI 56406-3369','Voluptate cupiditate delectus officia quo esse.','Aut consequatur cum eos odio tempora qui voluptas impedit. Possimus vitae et aperiam eveniet dignissimos. Quisquam est ducimus rem quae voluptatibus autem. Quo iusto est asperiores sit. Veniam veritatis vitae pariatur voluptatum ipsam nihil. Dolores quo saepe vero velit similique consequatur occaecati. Omnis aut dolorum eligendi officiis. Error reprehenderit est eum quo aliquid est vero quo. Magnam corrupti adipisci rem a est aut corporis. Hic vitae mollitia hic est.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(4,'Hillary Hayes','ronny.hane@example.org','1-209-395-6622','265 Swift Avenue\nWest Janellefort, FL 22286-6741','Amet non qui sint magni hic consequatur.','Et officiis delectus optio voluptatem. Eaque voluptates sit est eos voluptas quo. Voluptatum minima praesentium voluptatibus ut consequatur et officia. Atque odit quos culpa voluptas odio. Vel est cupiditate aut qui iure aut. Voluptatum quod sed ab quis. Excepturi atque est deserunt qui. Recusandae quo quia ut soluta. Quos dolorum consectetur maxime distinctio. Voluptas excepturi illum fugit voluptatem voluptates aliquam.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(5,'Forest Hill DVM','ashleigh.gerhold@example.com','+18317509060','486 Zackary Plain\nAbbeyport, AK 02846','Quos illum commodi et sequi totam officiis.','Nihil et eaque dignissimos nam tenetur. Rerum molestiae earum nulla ut sed sequi. Voluptatem rerum est amet et rerum. Deserunt facilis et ea placeat dolores. Rerum quam qui inventore et. Doloremque qui consequatur quo perferendis aliquid quia nisi. Veritatis animi occaecati veniam iste odio et in rem. Voluptas facilis numquam magni omnis sit sed ab. Iure cumque numquam aliquid laudantium. Cumque ipsam officia assumenda cupiditate.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(6,'Ahmad Torp III','brain.heller@example.com','+17579188446','90315 Haley Ferry\nJoesphfort, HI 29665-5733','Qui quia unde sit voluptatem ducimus voluptatem.','Eveniet debitis accusamus quidem dolor labore est sunt. Accusantium fugit iste magnam omnis. Voluptatem maxime quis occaecati voluptas autem. Aut enim sit corporis ex tenetur officiis magnam. Animi distinctio dolor error nam doloribus ea harum. Et reiciendis aut ea voluptatem repudiandae. Explicabo ullam tempore non facere tempora nesciunt. Molestiae doloremque impedit cumque. Aut dolorum voluptates pariatur sit non quis rem quia.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(7,'Prof. Bryce Baumbach','emard.lennie@example.org','1-925-409-5592','59414 Sauer Crescent\nNew Davionfurt, VT 94962-4978','Quia sit sunt corrupti delectus fugit.','Ut quam dolor debitis reiciendis enim minus. Autem doloremque voluptatem ducimus ut corporis. Eos voluptatem aliquid rerum in explicabo consequatur non. Veniam odio repellat odit ut eius similique. Qui et quis provident esse. Labore quam dolor facere ut molestias. Praesentium explicabo animi sequi aut libero. Sint quasi qui libero eligendi.',NULL,'read','2025-06-10 10:41:15','2025-06-10 10:41:15'),(8,'Mrs. Matilde Harvey Sr.','reta.parker@example.net','(231) 681-8965','3611 Feil Fields Apt. 585\nWest Samir, NY 04497-8436','Molestias id non aut est consectetur.','Doloremque error aut eius veniam totam. Ex asperiores amet omnis et ut maxime ipsum. Saepe et in eum asperiores blanditiis quam soluta. Facere quia vero inventore dolores. Excepturi dicta iste qui neque. Aut sit quos officiis nobis dolor hic sed. Laudantium fugiat ipsam doloribus ut. Provident quis perspiciatis sed sit accusantium eius. Quaerat ut neque quia id fugit qui. Officiis accusantium dignissimos modi inventore atque dicta tempore. Est architecto odit quaerat possimus minus quo.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(9,'Jarvis Crona PhD','vbatz@example.com','+1-724-855-7084','2410 Doyle Point\nNorth Julesmouth, CT 37216-1517','Natus excepturi inventore autem sint.','Ea ut deserunt sit at ut officiis. Omnis qui repellat ut quos deleniti architecto. Deleniti adipisci nisi dignissimos nihil sit corporis facilis culpa. Assumenda et et aut deleniti omnis. Explicabo et ex vero est. Inventore aut qui voluptas unde nihil molestiae quis. Consequatur tenetur earum ratione et quidem neque voluptas. Et modi rerum ut. Quidem omnis aut repudiandae. Eaque cum sequi dolores minima commodi. Quaerat amet nemo quia iste.',NULL,'unread','2025-06-10 10:41:15','2025-06-10 10:41:15'),(10,'Chaim Hirthe','dietrich.mellie@example.org','+1-341-220-2683','7453 Toy Springs\nSvenborough, SC 97422-4141','Et distinctio iure et laudantium.','Aut molestiae doloremque amet commodi dolorum. Officia velit ipsa itaque expedita quis nostrum est aut. Omnis et aut et necessitatibus ut pariatur provident. Assumenda unde veritatis ipsam neque placeat atque corrupti. Et qui optio amet quaerat. Optio laborum dolorem quibusdam voluptatem autem modi eos vero. Eligendi qui animi officia quidem voluptas omnis ut dignissimos. Voluptatibus optio molestiae sint rerum earum. Natus nemo beatae ad.',NULL,'read','2025-06-10 10:41:15','2025-06-10 10:41:15');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:41:46',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:41:46',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:41:46',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:41:46',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:41:46',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:41:46',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=70 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Dr. Modesto Lemke','customer@archielite.com','$2y$12$Exof2ytOWHhyEKJPqpes5esrOyKmATReFGMEAn0atqcL/uCh/cpbm',NULL,'0539662780','2002-03-20','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:40','2025-06-10 10:41:40'),(2,'Michael Smith','idibbert@hotmail.com','$2y$12$FwvsKlKdGttnE5uA/8rHaOTxGSnwQlDaaSU.qXgQUF6Hqtn.CiFE.','main/speakers/8.png','0721401983','2015-10-16','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:41','2025-06-10 10:41:41'),(3,'Jalon Nader','henri.green@heaney.com','$2y$12$4e9o9tEUEc6.IsIBmNp08ugPH1NeknkkdK4klBm7oJA7HEI7Xgn9i','main/speakers/8.png','0442380576','2005-11-17','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:41','2025-06-10 10:41:41'),(4,'Richie Lakin','jessyca.donnelly@veum.biz','$2y$12$5BbuVVl8oLHSS8/asPgQX..o5GhTtG41gHw2y8P9dGGYsdHsOeA0i',NULL,'0054859698','1998-07-11','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:41','2025-06-10 10:41:41'),(5,'Miss Lilla Jacobi III','csmitham@gmail.com','$2y$12$rQnvhbx61YesoFIMRuNDt.dgRsJ9Q9EACC6MR9fzjZ2M4Ll6oIwvK','main/speakers/6.png','0138963908','2008-03-17','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:41','2025-06-10 10:41:41'),(6,'Delpha Bruen','garry67@stehr.com','$2y$12$2tfYDKRR3J6tHwQU4wEi2uuE34zvPOd6pcwaWiUtGxmpQnFUwwsXC','main/speakers/7.png','0743965589','2001-11-17','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:41','2025-06-10 10:41:41'),(7,'Dora Gusikowski','glover.bartholome@yahoo.com','$2y$12$8AwANH2j6dc1.pSguD361usmV8YV6XpU2ACbkjreZ7a1mRcd.lisG',NULL,'0009278802','2003-06-24','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(8,'Leta Schultz','beau.conn@herman.net','$2y$12$0kPoGwSJNDRhedBEgsLUku7GTUA7UCqQxc8uU/GqH9.Zayrek3DoK',NULL,'0660583005','2002-02-08','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(9,'Unique Heathcote','mona.schoen@pouros.info','$2y$12$RQRL2qaBmjJy8dMSl.e1oe/uxkg3RK.LYrTyLnG86lhJiN3Ikzu.K','main/speakers/1.png','0865595681','2001-10-29','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(10,'Lukas Barrows III','corbin.grady@gmail.com','$2y$12$2G8q7W3almlJw1PuB1bjbeF9SxYsyQ6po.6dbugGnwnAspiE9A5Me','main/speakers/1.png','0653660986','2006-03-26','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(11,'Arnaldo Klein','delilah33@hotmail.com','$2y$12$WyKHwrkkPZn6AALC9pPcoOsDII92rdbrfwjkzi9ha/eUPH.mh9rWy',NULL,'0618893854','2023-10-08','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(12,'Prof. Meaghan Skiles Jr.','zkling@hotmail.com','$2y$12$ohvMNZeN3uzBm/MPSn.7vuTco8f9fkOUeHOtvGiuSMAGegaw8FrNa',NULL,'0176902422','1996-12-28','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:42','2025-06-10 10:41:42'),(13,'Jerome Koss','nhodkiewicz@hermiston.com','$2y$12$Ds4Usb0cVtnWm/FXHHEoNOAMj/So8EY5zgaQPp6x4fpu6U8ti4yba','main/speakers/6.png','0960840918','2018-01-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(14,'Dr. Toy Fritsch','roman78@gmail.com','$2y$12$EbSl5qR/uDYS3Yx2k09Hs.gwzUqNVG1lKAuDGCPn6eFWOvL2dSQLu','main/speakers/2.png','0680304370','2011-10-16','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(15,'Maximillian Stamm','fritsch.emily@jacobs.net','$2y$12$Z3g6f4DamzjZcck3mn2sievMevfRay1h7zVQGIdpaBwSjB8mt6kpW',NULL,'0619482818','1996-04-09','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(16,'Dr. Marty Hauck Jr.','mitchell.chelsie@yahoo.com','$2y$12$9b2CmuNvCm9pMFyR6ghSLu448C4.UE7FtKlvcNbZwGQhf3Vi5GUSe',NULL,'0921501246','2019-01-06','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(17,'Dovie Runolfsson','lrippin@yahoo.com','$2y$12$Lyz88VShewKHHb1aE3PEp.gB4jIIowQh6um.XgEZ2P1oJ4ENbE7qe','main/speakers/6.png','0215994238','2017-11-25','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(18,'Orland Gorczany','iokeefe@hotmail.com','$2y$12$Fjwo0Uo8EGrO29gOwc9Q3ulU8hqyC8Aa.H.FWspploNDfCBx9KYg6','main/speakers/6.png','0374560261','2019-07-11','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:43','2025-06-10 10:41:43'),(19,'Mr. Bart Wolf','akeem.crist@hotmail.com','$2y$12$AYR/Qfp/DH4LeSEXxsubuOjcSxTfv9lnQG/NKa8OtvxdlzZ1yY0AS','main/speakers/2.png','0126288233','2006-09-04','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:44','2025-06-10 10:41:44'),(20,'Isai VonRueden','paige.stracke@yahoo.com','$2y$12$tCPuwJeu8/LY9iLhp7Lu7erb7usRq7ej1k5vGIpHnbHdJPLHYlPZe',NULL,'0926780930','2003-06-11','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:44','2025-06-10 10:41:44'),(21,'Johathan Bauch','ankunding.romaine@legros.biz','$2y$12$0l7MYUgbzq2CiipLYkBLPOueyucCjHp/BiU3FasbSqpFaMCWe1OXC',NULL,'0745150957','2015-11-29','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:44','2025-06-10 10:41:44'),(22,'Mrs. Samantha Leuschke','isobel.heller@hotmail.com','$2y$12$i5BzQevr0NL6FZLFmAu1c..ykema.knqWbYCF5CGr5Cz80uVFjQ3K','main/speakers/6.png','0074826154','2019-10-24','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:44','2025-06-10 10:41:44'),(23,'Rosemary Lowe','bkessler@feest.com','$2y$12$a8t.dP/SU7kwZtPJSSDncO3AhSjlP6PgouOr/xkz6xz2i6cVONKem','main/speakers/6.png','0681200334','2021-05-29','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:44','2025-06-10 10:41:44'),(24,'Lennie Leannon','demond15@gaylord.com','$2y$12$f3IKyaPYt4XvlHFcBGihoeBNCmFpw86LEjqgPHKKP6HkM8S1JQPm2','main/speakers/9.png','0497324904','2008-10-09','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(25,'Genoveva Kuhlman','dante26@kreiger.org','$2y$12$38wVu43hwLXPdWnsVpaePOwWblH/zAHyFwwEcfcFAmJVfWgiLaEN2',NULL,'0058204777','2022-03-18','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(26,'Mrs. Lelia Tromp Jr.','coty83@breitenberg.com','$2y$12$4b4xtiDYQC6DdGgtfUBVZeIR/SgjaLDU730Si9lfYNPhSuzKlp/.S','main/speakers/2.png','0719077370','2011-04-23','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(27,'Dawson Bogan','johanna35@schumm.info','$2y$12$E/ZphybW2VEeFlgbFJRsuePDnepfq8DC2RZhDkItWQIP7GDpYkr8e','main/speakers/10.png','0374345192','1999-08-01','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(28,'Dr. Alfred Kassulke','wstracke@swaniawski.com','$2y$12$CPIAUzhrJRhzakFdwoWaz.t8jOLbA6shCBLpp2KeP59JJUHZ0zQvy','main/speakers/4.png','0381125291','2019-02-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(29,'Joana Watsica','jenifer.feeney@yahoo.com','$2y$12$64IicgFonMw5uVnirN6yyu.nRxTjIPrpz7tnsndaZmXt1OcgSn1vq','main/speakers/1.png','0670649937','2013-12-26','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:45','2025-06-10 10:41:45'),(30,'Neva Zieme','mferry@hotmail.com','$2y$12$mjOx4bKXLtXGU6a4kMXAIOdz0cz5bmBKdcrK/xizAy/JELB0/58Jy','main/speakers/1.png','0022873063','2016-08-20','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:46','2025-06-10 10:41:46'),(31,'Shaylee McDermott','nrutherford@gmail.com','$2y$12$6px3s49jyklkUJRHgUBzMu2iC1Hlw.IxnvCXMKCUGuVTpOSTpYOQu','main/speakers/4.png','0437120618','2020-03-30','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:41:46','2025-06-10 10:41:46'),(32,'Lucio Corkery','koss.emily@pfannerstill.com','$2y$12$TUJIzMhba8THKwvLG5Pi7.E/jmhcr.wCWtnwMqz4O0qJeqaTj9av2',NULL,'0793244920',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(33,'Deshawn Ebert V','icarter@gmail.com','$2y$12$mQ02iMmapX/fIQ2OQP2m2.ZO3ZDlMtZPvpoKdi1bB8TOMu20L35iC',NULL,'0746716471',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(34,'Willy Wiza MD','gziemann@hotmail.com','$2y$12$V2C82YsHF.IRu7.RvfbcxuBAvFtEsQRIWIZOyOGg//x3zMnU6uQP.',NULL,'0017054653',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(35,'Dr. Keon Ortiz III','bechtelar.braeden@yahoo.com','$2y$12$0dy.F/qOJrKVyPMMUTP37Os1ydhf9aPqsF31VCMxFTCNz3wN5cNhu',NULL,'0112995407',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(36,'Tia Bartoletti','schaefer.andre@hotmail.com','$2y$12$aIF4BbyOdzm5nbJt1bFhbu4FdT1B44nCyEGIgjuWAxHMosDzUTeHW',NULL,'0621790281',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(37,'Lou Schulist','reggie86@yahoo.com','$2y$12$Tg.Vpxc9NCtDm6VK9QG6bOYuY3.p4.pxENNWDMoyRQ.bkPQ1bRDnO',NULL,'0595752368',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(38,'Shaniya Cremin','odessa.herman@gmail.com','$2y$12$lEBruTQrpdgomwQAHjT.humEHdUvzre.xa/5f9DXeuY4ROBqFqlQi',NULL,'0792198776',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(39,'Dr. Wilmer Weber Sr.','qcartwright@hotmail.com','$2y$12$sTzT9Triz0VIZ5D5Ur40EOu/dygQbWSKfCDM0mxZNkQSymL1zKhOO',NULL,'0110588286',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(40,'Dr. Audrey Kirlin IV','felipa50@hotmail.com','$2y$12$E/hkchIf5gjfsEXmkdn5VOfppfaIkZqxB0J8kl1BdZt4AFhuKVnIy',NULL,'0514370665',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(41,'Ciara Lindgren','mayra.mohr@gmail.com','$2y$12$AIHRc4Fpc6knrPMyrKnw.OHWOE/TQfrRmP0cmK0eFySyxsHtIbSr2',NULL,'0998962648',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(42,'Jeanie Kassulke','mallie.wilderman@hotmail.com','$2y$12$9HLF6nNMeVqjtVkhGUVzJOGXwKF8.qHFss7k7YYFKwLxAWcCADGDK',NULL,'0352533530',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:58','2025-06-10 10:41:58'),(43,'Ezekiel Hayes','susanna70@miller.com','$2y$12$9CM.8MlrRJ2q069SsJkw9.9orGiG9Z/akpuDq97FKda5l.Yc8sTPy',NULL,'0765894038',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(44,'Amalia Luettgen','arnoldo79@gmail.com','$2y$12$7gRDsPFaoiEIw0HeEao96eCYLbfZE0uopgYw.iNTULnuniRbootim',NULL,'0366126863',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(45,'Janie Hauck II','jillian.bernier@willms.org','$2y$12$Us9HlAAWRRw3yv5kWF.WIOT6Sy7ddHCWoxj0LtJhUqJ95nyzkNayK',NULL,'0074641699',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(46,'Prof. Jess Lubowitz IV','earnest.bayer@rutherford.com','$2y$12$HQU0nd0bYqSj4EkiPV7na.fCdPI2a47j/YLmjHoqJco2lKcb4Cig2',NULL,'0035229031',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(47,'Loren Koss Sr.','oconnell.reyes@gislason.biz','$2y$12$X5.uB7asS8OIA8uZ2CgSxu3253zBcuiFqr/kNGtuGHxW8tX493ZkG',NULL,'0857458375',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(48,'Prof. Joelle Lehner II','blarkin@gmail.com','$2y$12$Lftgc7MfQBlEQgP7nwvzI.653zxh2NWkAClWHsvQ8SiJOkH7Lh3WO',NULL,'0875795276',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(49,'Sadye Jacobson DDS','dianna79@gmail.com','$2y$12$f4Epp76X2tL0SacOye9PD.xjxBIG3N3NwkygUwTFFrS953pndZL/C',NULL,'0440442391',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:41:59','2025-06-10 10:41:59'),(50,'Tabitha Bechtelar','wcartwright@koepp.com','$2y$12$f8QWwUaCr3kmL5ICAYwYKeo6UNLG/6WZk/X3fTBSrhjWqAcM5zsdC',NULL,'0473522032',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(51,'Miss Whitney Steuber','dayton.crooks@ferry.biz','$2y$12$HsBpAZjl.Uz1LJDMt10GK.UtsZC0ZGpPQ3DZBXq5Wl9SaOLVMBiM.',NULL,'0963300465',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(52,'Dr. Koby Reichert Jr.','thea.schiller@gmail.com','$2y$12$Gu2nZTnNRxOW3KmY78AXd.wzGJQdoCLASF/eK8rGRk1et3u0DaKqS',NULL,'0779925166',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(53,'Bethany Fay','sammie08@heidenreich.net','$2y$12$JELKhkWIO.r4Bwnf9POvtejtJ8ye5PIG1GPxJXfaB0RWMnAgXtFui',NULL,'0217280170',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(54,'Dr. Modesto Reichert','madisyn52@hotmail.com','$2y$12$csqEBuZFUc/eqTZ34PB8L.Ydw8dAhYrhaMUOxzCln5kItsz9GEY5a',NULL,'0939853079',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(55,'Abigale Ferry','hweber@gmail.com','$2y$12$3f.AhNRU37r92PcFR23FhOEdLhNUb0OlRsP27Gi.l2RDAE2dNKGSu',NULL,'0085099368',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:00','2025-06-10 10:42:00'),(56,'Sasha Wunsch','dillon60@huels.com','$2y$12$RTt0T3SWViZAepsTNWSkJuCOhxPboiPqnY...vNd21C8vWaF4uz4q',NULL,'0202615478',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(57,'Mr. Nikolas Yundt DVM','eda76@gmail.com','$2y$12$RzpHdoc1R9/jQwV.RT.lyeJ0G0SLhVxrPUPYepFgVzAxwo581LBW6',NULL,'0066513157',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(58,'Magali Miller','narciso.hahn@witting.org','$2y$12$g1j5MglPD9gPnxlSvmpMJ.kn3MENPUUmhlkS.3WSw.uUZXyTYSeXC',NULL,'0130984602',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(59,'Lorine Ortiz','guadalupe03@monahan.com','$2y$12$xR4/LiCfDZTRR3RhokWLb.WsNyYalmVUYOhBLvue3iutHfTs.p94G',NULL,'0978579844',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(60,'Anika Rohan IV','antonina29@brown.net','$2y$12$Un/qg3gf5zHjSIuQFziJWOqgQenumVbn1mNsiHlozuJmeYesddO5G',NULL,'0983864856',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(61,'Dr. Germaine Schinner MD','scollins@langworth.info','$2y$12$CN9CSWKS9rLhqvjfUlqmz.edjvaa9Jsn12mgaeXHdF2V94VSzRiES',NULL,'0671963915',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(62,'Miss Alvina Bogisich','tyshawn.kozey@lubowitz.info','$2y$12$Sid50bvpEMKtu7xLhc/yj.494jumc030YqjSZ57acfQmdQrvVS3rC',NULL,'0230218061',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:01','2025-06-10 10:42:01'),(63,'Mr. Louisa Skiles','mcasper@cummerata.com','$2y$12$ca4kKqVckqfnaHifQjHU0OMcqzsHtU59QfcDkD0rqtrAHzEbnWgY.',NULL,'0210646785',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(64,'Prof. Cameron Johns III','eunice.abernathy@sanford.com','$2y$12$yZeb8M5uzu350SG8ClB1F.ijS3fey8Wh8pXtP5JosZt.laB1Hx.rW',NULL,'0378835769',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(65,'Mitchell Welch','anastasia.will@hotmail.com','$2y$12$t2EKOcX5GFawEHP0xnGFJObLDgNRm3Pzfvu7Tb8nmG6YfycUzWYbC',NULL,'0529783781',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(66,'Abelardo Kunde','rgreenholt@gmail.com','$2y$12$V3XPi3yNWEngbXfOzjd1Lu01XO7x4HHk8eBLNEgx3wGH7x7ZiTAFa',NULL,'0950203922',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(67,'Marlee Stoltenberg DDS','mara.schiller@yahoo.com','$2y$12$ZE3F9woRbjalgBwnUtE.FuoUeiJfeITUpJYIStwz8gcz3ODRDWYyC',NULL,'0398475157',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(68,'Ressie Quitzon','osinski.jorge@hotmail.com','$2y$12$utvKJD/y/IB/1gKYOO3LbeAG8lz2mBjF5g8Rr14Le6FJgtIibI84e',NULL,'0218644358',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(69,'Hazel Haag Sr.','sawayn.watson@hotmail.com','$2y$12$G53Is2uWSEA8coXvHR8Gz.w1Eqfnm082pgG/WEkJZDpC1lV9g4Q7W',NULL,'0341668013',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:42:02','2025-06-10 10:42:02');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:41:08','2025-06-10 10:41:08'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:41:08','2025-06-10 10:41:08'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:41:08','2025-06-10 10:41:08');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (3,49,'2LERGXGWFQW5',NULL),(4,58,'4JQLNZKGIENL',NULL),(1,37,'4VLFPCM3HYFZ',NULL),(1,38,'5XJLX6NB1UYY',NULL),(2,40,'7KZY4EPPMTJS',NULL),(3,48,'8S69YWAWWGPO',NULL),(1,32,'AD6JABC9XIYN',NULL),(4,62,'AKKXRDJWNTBX',NULL),(1,34,'BS71PMSSLDL2',NULL),(4,61,'BTYRTHYHTRBX',NULL),(5,65,'CKBRTQ2J9T1H',NULL),(3,50,'F280X2XIPOS5',NULL),(3,47,'FYDZL2JBYHVF',NULL),(5,69,'G9N8ZPYSAREY',NULL),(3,52,'GKBP9LM5BFU6',NULL),(5,67,'GSG7KVK2G5YC',NULL),(2,44,'HNWXTJIBFBAI',NULL),(2,43,'HVVVOKDSBHCH',NULL),(4,63,'HZ7WAZDYAPIL',NULL),(4,59,'J1O46A71U8HP',NULL),(5,68,'JKE8QSNCM1AQ',NULL),(2,41,'KEPOESXBGH2E',NULL),(1,33,'KHZEHKDLQSJX',NULL),(4,60,'KNCHPTXXMVLW',NULL),(1,35,'LIM6YWYQQQXS',NULL),(1,39,'OES9SEBESS7R',NULL),(4,57,'PHQWVKPUALZ0',NULL),(4,64,'POB39KLPHC7K',NULL),(3,45,'PW2TRWFFEP4W',NULL),(3,56,'QB39IQQXG2MR',NULL),(3,51,'RLX5L7FZ2IGA',NULL),(3,54,'RXASKODQ7RRD',NULL),(1,36,'SPXUDLRVMPGV',NULL),(2,42,'TZAR5N2E952W',NULL),(3,46,'UFNJTCI3UCL3',NULL),(3,55,'VCU9XH86PZIX',NULL),(3,53,'XOZILP8DATHI',NULL),(5,66,'ZLWKCNAAVYKY',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,17,'Dolorem laboriosam omnis id quidem minus. Officiis pariatur distinctio magni quo autem maiores.',NULL,0,NULL,NULL),(1,3,'A aut et necessitatibus non. Est culpa quos magni.',NULL,1,NULL,NULL),(1,24,'Tempore ut rerum reprehenderit aliquam et ut. Voluptatibus accusantium inventore ut voluptatem.',NULL,3,NULL,NULL),(2,24,'Accusamus vel blanditiis distinctio et voluptatibus. Corporis expedita voluptatum consequatur.',NULL,0,NULL,NULL),(2,9,'Odit aperiam ut consequatur ipsam recusandae et sed. Optio recusandae incidunt illum illo eos et.',NULL,1,NULL,NULL),(3,17,'Quasi in sunt harum. Non dicta esse minus unde amet ab consectetur non.',NULL,0,NULL,NULL),(3,18,'Et id eos iusto. Et dolor possimus nemo dolores.',NULL,1,NULL,NULL),(3,3,'Nihil vitae tempora atque cupiditate esse aut. Quasi aut nihil consectetur consectetur libero.',NULL,2,NULL,NULL),(4,3,'Id qui non nam cupiditate quibusdam. Cum beatae aut et ratione ducimus in libero.',NULL,0,NULL,NULL),(4,17,'Ratione maiores veniam libero aut. Dolores aut necessitatibus rem reprehenderit.',NULL,1,NULL,NULL),(4,9,'Dolores corporis et sequi optio velit. Aut et expedita ab. Sit rerum soluta totam aliquid quia.',NULL,2,NULL,NULL),(4,13,'Cum et veniam veritatis possimus. Sit recusandae quia unde rerum et. Ipsa quidem est omnis neque.',NULL,3,NULL,NULL),(5,28,'Nisi eius error et magni perferendis. Doloremque doloremque rerum omnis rerum rem.',NULL,0,NULL,NULL),(5,17,'Impedit magnam at quo sed. Facilis corporis et ut sit repudiandae.',NULL,1,NULL,NULL),(5,18,'Ullam et animi quia tenetur voluptas soluta nisi corporis. In minima soluta cupiditate.',NULL,2,NULL,NULL),(5,9,'Ullam illo accusamus atque itaque voluptatibus amet assumenda. Magnam unde laudantium veniam.',NULL,3,NULL,NULL),(6,24,'Qui ut dolor qui modi ut. Animi tenetur commodi excepturi sint numquam. Deleniti at at distinctio.',NULL,0,NULL,NULL),(6,19,'Aut sit ipsum rerum minus. Dolore laborum temporibus nam.',NULL,1,NULL,NULL),(6,28,'Repellat dolorem magni nihil ex qui nisi. Sapiente dolorem minima quo.',NULL,2,NULL,NULL),(6,6,'Fuga tenetur impedit atque. Dolorum enim molestiae ea eos commodi ut.',NULL,3,NULL,NULL),(7,9,'Ipsum natus aut voluptas. Sit voluptatem ut placeat cupiditate ratione et officiis temporibus.',NULL,0,NULL,NULL),(7,19,'Numquam qui esse corporis. Ut iusto sequi veniam est excepturi reprehenderit distinctio.',NULL,1,NULL,NULL),(7,13,'Optio maxime consectetur fuga itaque. Ut itaque officiis sed voluptatum reiciendis itaque magnam.',NULL,2,NULL,NULL),(7,14,'Vero nemo et id. Aut nihil et neque sed.',NULL,3,NULL,NULL),(8,13,'Ipsum adipisci veniam commodi sed et ut. Tempora tenetur voluptatem voluptatem quam qui eveniet.',NULL,0,NULL,NULL),(8,14,'Sit est rerum quo. Ab omnis doloribus sit dolor dolor. Unde quos repellat qui quibusdam provident.',NULL,1,NULL,NULL),(8,3,'Quas facilis in eum maxime ut. Saepe deserunt repellendus in in vero doloribus.',NULL,2,NULL,NULL),(8,24,'Debitis ratione ut quia aperiam. Sit sit qui et esse esse.',NULL,3,NULL,NULL),(9,13,'Nihil repellendus repellat illo aut. Consequuntur ut voluptatum rerum sit qui quis ipsa autem.',NULL,0,NULL,NULL),(9,3,'Et quam aut quia doloribus molestiae. Rem occaecati dolorum et et. Pariatur id aut minus et qui.',NULL,1,NULL,NULL),(9,6,'Et vel quae vitae atque eum deleniti. Sit possimus similique natus eius.',NULL,2,NULL,NULL),(9,17,'Non enim repellat et ex molestiae. Veniam eius qui libero eaque velit omnis beatae.',NULL,3,NULL,NULL),(10,18,'Animi eum velit fugit aut. Eum non est eligendi ut dolorem. Voluptas modi quasi est distinctio.',NULL,0,NULL,NULL),(10,14,'Non atque omnis quaerat aperiam. Impedit non hic et. Pariatur qui est suscipit quo.',NULL,1,NULL,NULL),(10,24,'Omnis eius quae enim et quia impedit. In atque atque laboriosam magnam.',NULL,2,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',22,'Natus sint repudiandae excepturi et labore.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','daf9bea8-f78c-3aec-b314-baaeb0bdf812','main/events/1.webp',99.99,'8674 Makayla Port\nJakubowskimouth, IL 29379-6871',4,4,4,'-29.51301','-52.612516',83,0,'2025-06-10 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(2,'Mobile World Congress',30,'Officiis id eius quo omnis.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','8e8ceedb-71a4-33e7-9575-bdd4aa1a8ff6','main/events/2.webp',31.68,'3904 Gerhold Ways Apt. 345\nEmanuelmouth, KS 79373',5,5,5,'63.629546','-156.699113',96,0,'2025-06-10 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(3,'Google I/O',22,'Reiciendis aspernatur nesciunt excepturi dolore ex non non.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','48883e91-ab8a-3022-a1ee-79e720a1ac33','main/events/3.webp',86.80,'10008 Conroy Forges\nEllenchester, CT 14786-3996',5,5,5,'-22.88351','87.615238',72,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(4,'Apple WWDC',10,'Distinctio quo ipsa repellat ea nam perspiciatis et ab.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','1a8d7cb1-23b6-3263-a7f9-ffa20038336d','main/events/4.webp',84.31,'630 Koch Turnpike\nTremblaymouth, DE 00446',3,NULL,NULL,'6.678367','70.228266',97,0,'2025-06-10 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(5,'AWS re:Invent',5,'Voluptatem illo dignissimos ducimus nulla dolores corrupti sint velit.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','4311ae79-6e0f-3da3-81dc-c0a2c588ef9d','main/events/5.webp',79.05,'1518 Lurline Crest Suite 493\nNorth Kaelafurt, VT 30462-0134',3,NULL,NULL,'-25.438505','155.837176',70,0,'2025-06-11 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(6,'Microsoft Build',27,'Omnis reiciendis ut nihil quaerat reiciendis aut ad ex.','Microsoft\'s developer event, introducing new development tools and platforms.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','91ba1b80-1849-3153-bff8-53e9ea11c83b','main/events/6.webp',27.56,'523 Graham Heights Suite 385\nSouth Alisonview, HI 56388',1,3,3,'-40.773882','-144.128873',92,0,'2025-06-11 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(7,'Facebook F8',31,'Vitae quod dolore temporibus impedit placeat porro eligendi.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','59301eac-4811-3370-bbd0-dbff0373e9c0','main/events/7.webp',18.68,'5391 Weissnat Port Suite 695\nBernierchester, SD 83511',6,NULL,NULL,'-51.439317','-103.651106',50,0,'2025-06-11 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(8,'GitHub Universe',22,'Fuga soluta perferendis corporis praesentium.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','cf8b37ab-9070-38bf-8675-f793db948e50','main/events/8.webp',52.53,'92934 Paolo Courts Suite 954\nShieldsmouth, ID 85877-2602',2,2,2,'-42.821422','3.497252',93,0,'2025-06-11 09:00:00','2025-06-25 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(9,'Game Developers Conference',26,'Nostrum ipsum adipisci expedita voluptas cupiditate.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','ba19d3ff-4c34-3524-9d54-9c532fb3cfab','main/events/9.webp',48.03,'2345 Glen Course Apt. 862\nPort Kobe, RI 45652-8821',2,2,2,'-3.22244','26.075958',56,0,'2025-06-12 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(10,'Web Summit',26,'Maxime vitae et sit voluptates.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','6d486d6f-f612-3d24-942e-0b3850ec4286','main/events/10.webp',78.85,'904 Fred Valleys Suite 315\nSmithamview, WI 27840-7582',4,4,4,'-32.066883','-101.153259',62,0,'2025-06-12 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:41:53','2025-06-10 10:41:53');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Mercedes Huel - annabell.hill@dare.info','annabell.hill@dare.info','0804756700',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Wilford Gutkowski - zweber@blanda.com','zweber@blanda.com','0165242605',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Bridie Frami - patience.waelchi@beahan.net','patience.waelchi@beahan.net','0393682352',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Grayson Satterfield - maggio.sheila@homenick.com','maggio.sheila@homenick.com','0267828492',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(5,1,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Devon Krajcik II - xdicki@heller.org','xdicki@heller.org','0105964078',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Amir Moore III - okon.ruben@gmail.com','okon.ruben@gmail.com','0073795046',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Mr. Janick Will - hwalker@adams.com','hwalker@adams.com','0324002662',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Prof. Alek Dooley - lmann@kuvalis.com','lmann@kuvalis.com','0184504740',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(9,2,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Kaya Volkman - bjohns@nitzsche.org','bjohns@nitzsche.org','0014363749',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Beryl Skiles - graham.edwina@yahoo.com','graham.edwina@yahoo.com','0929544487',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Jaylin McDermott - sdamore@heaney.com','sdamore@heaney.com','0303942250',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Grant Mante V - king.everett@hotmail.com','king.everett@hotmail.com','0597854415',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(13,3,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Mrs. Abbigail Ernser I - jodie.dickinson@hotmail.com','jodie.dickinson@hotmail.com','0232745130',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(14,3,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Dr. Celestine Hessel - brooke.bogisich@hotmail.com','brooke.bogisich@hotmail.com','0628328192',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(15,3,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Dr. Rosario Beahan III - hailey.wiza@vandervort.com','hailey.wiza@vandervort.com','0790789174',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Else Graham III - pfeffer.modesto@rau.com','pfeffer.modesto@rau.com','0371298157',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(17,4,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Hunter Brekke - crooks.samir@hotmail.com','crooks.samir@hotmail.com','0847148681',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(18,4,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Mrs. Elenora Lebsack I - sage.larkin@gmail.com','sage.larkin@gmail.com','0607292261',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(19,4,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Miss Dora Marks V - garrett.rodriguez@gmail.com','garrett.rodriguez@gmail.com','0486573442',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(20,4,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Asa Goyette - scot.konopelski@gmail.com','scot.konopelski@gmail.com','0950631643',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(21,5,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Nathanael O\'Keefe - macey.streich@tremblay.com','macey.streich@tremblay.com','0512387937',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(22,5,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Nelda Ruecker - qschoen@hotmail.com','qschoen@hotmail.com','0154737998',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(23,5,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Benton Graham - pouros.emilio@gmail.com','pouros.emilio@gmail.com','0132076526',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(24,6,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Aidan Leuschke MD - zhahn@orn.com','zhahn@orn.com','0929409815',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(25,6,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Bruce Hoeger - ward.denis@grady.com','ward.denis@grady.com','0879111566',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(26,6,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Raoul Bayer II - lilliana.murray@abshire.info','lilliana.murray@abshire.info','0024393029',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(27,7,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Lucio Corkery - koss.emily@pfannerstill.com','koss.emily@pfannerstill.com','0793244920',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(28,7,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Deshawn Ebert V - icarter@gmail.com','icarter@gmail.com','0746716471',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(29,8,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Willy Wiza MD - gziemann@hotmail.com','gziemann@hotmail.com','0017054653',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(30,8,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Dr. Keon Ortiz III - bechtelar.braeden@yahoo.com','bechtelar.braeden@yahoo.com','0112995407',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(31,8,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Tia Bartoletti - schaefer.andre@hotmail.com','schaefer.andre@hotmail.com','0621790281',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(32,8,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Lou Schulist - reggie86@yahoo.com','reggie86@yahoo.com','0595752368',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(33,8,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Shaniya Cremin - odessa.herman@gmail.com','odessa.herman@gmail.com','0792198776',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(34,8,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Dr. Wilmer Weber Sr. - qcartwright@hotmail.com','qcartwright@hotmail.com','0110588286',1,99.99,99.99,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(35,9,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Dr. Raymundo Schumm IV - xmiller@yahoo.com','xmiller@yahoo.com','0669916286',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(36,9,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Bethel Toy - manuela14@hotmail.com','manuela14@hotmail.com','0010083054',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(37,10,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Rodolfo Powlowski I - jwitting@hand.com','jwitting@hand.com','0613125451',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(38,10,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Bryana Luettgen - koepp.mya@hotmail.com','koepp.mya@hotmail.com','0250704822',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Garnet King Jr. - gus.jast@frami.org','gus.jast@frami.org','0099967349',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(40,10,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Prof. Duane Strosin DVM - gislason.brycen@yahoo.com','gislason.brycen@yahoo.com','0655090514',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(41,10,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Shemar Smitham - kautzer.alyson@terry.net','kautzer.alyson@terry.net','0244323385',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(42,10,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Felix Simonis - adonis16@gmail.com','adonis16@gmail.com','0227653862',1,99.99,99.99,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(43,11,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Mr. Will McKenzie - alysha46@nitzsche.org','alysha46@nitzsche.org','0102935959',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(44,11,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Prof. Karlee Barton DVM - melvina.schaefer@gmail.com','melvina.schaefer@gmail.com','0544724813',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(45,11,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Dr. Angela Runte - douglas.dorothea@gmail.com','douglas.dorothea@gmail.com','0569727199',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(46,11,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Kenton Christiansen I - pagac.vladimir@batz.com','pagac.vladimir@batz.com','0347147575',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(47,11,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Giovani Moore - evan04@howe.com','evan04@howe.com','0915392891',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(48,11,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Nicklaus Stokes - spfannerstill@aufderhar.info','spfannerstill@aufderhar.info','0183382607',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(49,12,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Prof. Ila Adams Sr. - bettye.thompson@gmail.com','bettye.thompson@gmail.com','0470553466',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(50,12,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Evie Emard - pheidenreich@lueilwitz.com','pheidenreich@lueilwitz.com','0161966040',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(51,12,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Monroe Nienow - ignatius81@hotmail.com','ignatius81@hotmail.com','0383072397',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(52,12,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Rebecca Stiedemann II - hallie.gerlach@gmail.com','hallie.gerlach@gmail.com','0576560858',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(53,13,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Dr. Audrey Kirlin IV - felipa50@hotmail.com','felipa50@hotmail.com','0514370665',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(54,13,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Ciara Lindgren - mayra.mohr@gmail.com','mayra.mohr@gmail.com','0998962648',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(55,13,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Jeanie Kassulke - mallie.wilderman@hotmail.com','mallie.wilderman@hotmail.com','0352533530',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(56,13,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Ezekiel Hayes - susanna70@miller.com','susanna70@miller.com','0765894038',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(57,13,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Amalia Luettgen - arnoldo79@gmail.com','arnoldo79@gmail.com','0366126863',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(58,14,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Darron Boyer DVM - therese56@cummings.com','therese56@cummings.com','0766788287',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(59,14,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Roel Windler - spinka.darlene@gmail.com','spinka.darlene@gmail.com','0655281998',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(60,14,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Jaylin Ward - adell98@kulas.com','adell98@kulas.com','0254406002',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(61,15,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Pietro Heathcote - ruth52@nader.com','ruth52@nader.com','0136887425',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(62,15,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Coralie Rogahn - aleen.oberbrunner@barton.com','aleen.oberbrunner@barton.com','0875168406',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(63,15,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Buck Balistreri - alvah65@ebert.org','alvah65@ebert.org','0348374880',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(64,15,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Prof. Branson Emmerich - sarah70@frami.net','sarah70@frami.net','0927944525',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(65,15,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Ms. Magdalen Leffler - dustin.kessler@murazik.com','dustin.kessler@murazik.com','0432636670',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(66,15,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Lois Collins - imani67@huel.com','imani67@huel.com','0676462508',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(67,16,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Mrs. Hosea Wehner - dicki.juston@gmail.com','dicki.juston@gmail.com','0725309275',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(68,16,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Dolly Schmitt - madge30@kuhn.com','madge30@kuhn.com','0884115257',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(69,16,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Chelsea Beatty - tina.raynor@hotmail.com','tina.raynor@hotmail.com','0934092471',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(70,16,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Demarcus Weimann - brody33@dare.org','brody33@dare.org','0683218413',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(71,17,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Kacie Prohaska Jr. - harmon.schoen@yahoo.com','harmon.schoen@yahoo.com','0954986247',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(72,17,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Miss Mina Lueilwitz - reynolds.micaela@bernier.com','reynolds.micaela@bernier.com','0662230249',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(73,17,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Mathilde O\'Kon - larue58@nolan.com','larue58@nolan.com','0542072185',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(74,17,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Yazmin Mills III - winifred.kihn@yahoo.com','winifred.kihn@yahoo.com','0385939522',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(75,18,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Jane Johns Sr. - xhegmann@gmail.com','xhegmann@gmail.com','0357313298',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(76,18,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Prof. Shaun Fadel - kirlin.kyler@hotmail.com','kirlin.kyler@hotmail.com','0944361556',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(77,18,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Maybelle Brekke - jaren04@hotmail.com','jaren04@hotmail.com','0046904319',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(78,18,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Mobile World Congress - Prof. Jerel Tillman Sr. - vstracke@hotmail.com','vstracke@hotmail.com','0541146967',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(79,18,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Mobile World Congress - Mr. Lew Klein - zackery09@monahan.com','zackery09@monahan.com','0267875981',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(80,18,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Mobile World Congress - Lavina Adams - lkuhn@predovic.com','lkuhn@predovic.com','0231848755',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(81,19,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Mobile World Congress - Bessie Schneider - waylon.reilly@lind.com','waylon.reilly@lind.com','0429982208',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(82,19,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Mobile World Congress - Virgie Ward - hyatt.chelsie@hotmail.com','hyatt.chelsie@hotmail.com','0568444402',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(83,19,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Mobile World Congress - Prof. Francesco Reichert V - littel.ariel@yahoo.com','littel.ariel@yahoo.com','0877787251',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(84,19,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Mobile World Congress - Drake Little - gabrielle96@greenholt.com','gabrielle96@greenholt.com','0208192722',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(85,19,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Mobile World Congress - Rosario Lindgren - albin07@funk.com','albin07@funk.com','0699355469',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(86,20,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Mobile World Congress - Buck Keeling - roberta.turcotte@kemmer.com','roberta.turcotte@kemmer.com','0858103231',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(87,20,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Mobile World Congress - Prof. Selina Dicki III - merl.yundt@becker.org','merl.yundt@becker.org','0413997001',1,31.68,31.68,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(88,21,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Dr. Shane O\'Kon PhD - malika.williamson@frami.net','malika.williamson@frami.net','0696936289',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(89,21,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Verda Boyer II - jerod.bergstrom@fahey.com','jerod.bergstrom@fahey.com','0649367480',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(90,21,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Xzavier Kub - dnolan@raynor.com','dnolan@raynor.com','0339038849',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(91,22,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Janie Hauck II - jillian.bernier@willms.org','jillian.bernier@willms.org','0074641699',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(92,22,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Prof. Jess Lubowitz IV - earnest.bayer@rutherford.com','earnest.bayer@rutherford.com','0035229031',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(93,22,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Loren Koss Sr. - oconnell.reyes@gislason.biz','oconnell.reyes@gislason.biz','0857458375',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(94,22,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Prof. Joelle Lehner II - blarkin@gmail.com','blarkin@gmail.com','0875795276',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(95,22,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Sadye Jacobson DDS - dianna79@gmail.com','dianna79@gmail.com','0440442391',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(96,23,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Dayana Adams - christine.brekke@yahoo.com','christine.brekke@yahoo.com','0094711753',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(97,23,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Marguerite Schneider - fhuel@schoen.info','fhuel@schoen.info','0382296566',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(98,23,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Anabelle Marquardt - dheaney@yahoo.com','dheaney@yahoo.com','0338525961',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(99,23,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Alden Nitzsche - liam88@braun.info','liam88@braun.info','0704884726',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(100,23,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Mr. Joe King DDS - duncan26@hotmail.com','duncan26@hotmail.com','0579739456',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(101,24,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Fletcher Stokes - marguerite.rutherford@cartwright.com','marguerite.rutherford@cartwright.com','0341531437',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(102,24,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Adrienne Dicki - abagail.turcotte@schroeder.com','abagail.turcotte@schroeder.com','0784961155',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(103,24,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Florine Boyle PhD - ukunze@hotmail.com','ukunze@hotmail.com','0669208080',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(104,24,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Mr. Lawson Abbott IV - amelie96@armstrong.com','amelie96@armstrong.com','0932028218',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(105,24,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Loma Kulas - morissette.jo@yahoo.com','morissette.jo@yahoo.com','0068195435',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(106,25,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Agustin Morissette - sally.barrows@nicolas.net','sally.barrows@nicolas.net','0994623262',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(107,25,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Miss Heloise Veum - elyse.hudson@schroeder.net','elyse.hudson@schroeder.net','0318835914',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(108,25,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Ila Stiedemann - oconnell.deontae@spinka.biz','oconnell.deontae@spinka.biz','0423464691',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(109,25,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Maximo Kiehn II - frolfson@koss.biz','frolfson@koss.biz','0062556771',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(110,26,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Tabitha Bechtelar - wcartwright@koepp.com','wcartwright@koepp.com','0473522032',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(111,26,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Miss Whitney Steuber - dayton.crooks@ferry.biz','dayton.crooks@ferry.biz','0963300465',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(112,26,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Dr. Koby Reichert Jr. - thea.schiller@gmail.com','thea.schiller@gmail.com','0779925166',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(113,26,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Bethany Fay - sammie08@heidenreich.net','sammie08@heidenreich.net','0217280170',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(114,26,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Dr. Modesto Reichert - madisyn52@hotmail.com','madisyn52@hotmail.com','0939853079',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(115,27,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Margie Jenkins - christa.halvorson@gmail.com','christa.halvorson@gmail.com','0391960424',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(116,27,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Lucas Bode - kamren73@hotmail.com','kamren73@hotmail.com','0323927416',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(117,27,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Rahsaan Mann - mann.angie@yahoo.com','mann.angie@yahoo.com','0933600104',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(118,27,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Prof. Kirsten Schimmel - stephania65@yahoo.com','stephania65@yahoo.com','0812506183',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(119,27,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Einar Ebert - aletha28@gmail.com','aletha28@gmail.com','0055558556',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(120,28,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Google I/O - Abigale Ferry - hweber@gmail.com','hweber@gmail.com','0085099368',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(121,28,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Google I/O - Sasha Wunsch - dillon60@huels.com','dillon60@huels.com','0202615478',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(122,29,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Google I/O - Geovanni Stark - bahringer.dangelo@hotmail.com','bahringer.dangelo@hotmail.com','0580148856',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(123,29,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Google I/O - Cyrus Conn IV - vance04@goodwin.com','vance04@goodwin.com','0739273491',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(124,29,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Google I/O - Wayne Mayert - orn.jeffery@kovacek.com','orn.jeffery@kovacek.com','0982188568',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(125,29,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Google I/O - Mose King - langosh.izaiah@bernier.net','langosh.izaiah@bernier.net','0805388594',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(126,29,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Google I/O - Carolina Farrell - michele76@carroll.com','michele76@carroll.com','0024128781',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(127,30,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Google I/O - Angelica Predovic MD - jeanie96@yahoo.com','jeanie96@yahoo.com','0331791700',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(128,30,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Google I/O - Mrs. Josefa Champlin - junius50@swaniawski.com','junius50@swaniawski.com','0273974510',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(129,30,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Google I/O - Name Stark - mrau@hotmail.com','mrau@hotmail.com','0750109827',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(130,30,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Google I/O - Maximillia Steuber - kfeest@hotmail.com','kfeest@hotmail.com','0954024517',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(131,30,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Google I/O - Ashtyn Keebler - kunze.samanta@gmail.com','kunze.samanta@gmail.com','0730851423',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(132,30,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Google I/O - Luciano Nikolaus I - nlittle@gmail.com','nlittle@gmail.com','0156530276',1,86.80,86.80,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(133,31,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Larissa Auer - laury.hermiston@gmail.com','laury.hermiston@gmail.com','0714143222',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(134,31,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Dr. Concepcion Steuber - mason.leannon@yahoo.com','mason.leannon@yahoo.com','0646347611',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(135,31,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Jacquelyn Spinka IV - jerde.lori@miller.net','jerde.lori@miller.net','0991054874',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(136,32,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Mr. Nikolas Yundt DVM - eda76@gmail.com','eda76@gmail.com','0066513157',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(137,32,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Magali Miller - narciso.hahn@witting.org','narciso.hahn@witting.org','0130984602',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(138,32,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Lorine Ortiz - guadalupe03@monahan.com','guadalupe03@monahan.com','0978579844',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(139,33,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Dr. Zaria Ferry MD - marquardt.hunter@yahoo.com','marquardt.hunter@yahoo.com','0839026743',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(140,33,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Ellen Thiel - cortney02@lindgren.com','cortney02@lindgren.com','0190979261',1,84.31,84.31,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(141,34,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Malvina Ankunding - zjacobson@johnston.com','zjacobson@johnston.com','0164378023',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(142,34,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Prof. Laurine Schaden II - brook69@gmail.com','brook69@gmail.com','0472843571',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(143,34,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Reyna Trantow V - ariel09@roob.org','ariel09@roob.org','0339711522',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(144,35,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Bettie Runolfsdottir I - cindy.altenwerth@sanford.com','cindy.altenwerth@sanford.com','0809112698',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(145,35,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Melany Jones - vergie.cassin@hoeger.com','vergie.cassin@hoeger.com','0438120085',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(146,35,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Ward Spencer - vfadel@pfannerstill.com','vfadel@pfannerstill.com','0111580115',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(147,35,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Desmond Monahan - mitchell.alexanne@carroll.com','mitchell.alexanne@carroll.com','0380898079',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(148,36,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Katheryn Franecki II - dickens.chauncey@hotmail.com','dickens.chauncey@hotmail.com','0035025876',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(149,36,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Dr. Vada Jakubowski - bayer.sophia@feeney.info','bayer.sophia@feeney.info','0626257710',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(150,36,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Albert Kuhn Jr. - prosacco.isabella@hotmail.com','prosacco.isabella@hotmail.com','0975407214',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(151,36,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Prof. Enola Runolfsdottir - obayer@lebsack.com','obayer@lebsack.com','0834777033',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(152,37,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Anika Rohan IV - antonina29@brown.net','antonina29@brown.net','0983864856',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(153,37,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Dr. Germaine Schinner MD - scollins@langworth.info','scollins@langworth.info','0671963915',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(154,37,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Miss Alvina Bogisich - tyshawn.kozey@lubowitz.info','tyshawn.kozey@lubowitz.info','0230218061',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(155,38,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Omer Tromp - roxane50@harber.com','roxane50@harber.com','0503552482',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(156,38,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Mrs. Estefania Collins MD - hegmann.aglae@hermann.com','hegmann.aglae@hermann.com','0539071099',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(157,38,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Alivia Bartell - pablo19@prosacco.info','pablo19@prosacco.info','0398464087',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(158,39,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Gertrude Bartoletti - javon.fritsch@yahoo.com','javon.fritsch@yahoo.com','0953737969',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(159,39,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Colton Wintheiser - ikoepp@hotmail.com','ikoepp@hotmail.com','0094493347',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(160,39,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Lucie Halvorson - mohr.avery@gmail.com','mohr.avery@gmail.com','0261008276',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(161,39,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Elfrieda Franecki - julius50@homenick.info','julius50@homenick.info','0689933366',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(162,39,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'Apple WWDC - Mr. Kip Johns - claud.smitham@hansen.com','claud.smitham@hansen.com','0903731400',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(163,40,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'Apple WWDC - Mr. Louisa Skiles - mcasper@cummerata.com','mcasper@cummerata.com','0210646785',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(164,40,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'Apple WWDC - Prof. Cameron Johns III - eunice.abernathy@sanford.com','eunice.abernathy@sanford.com','0378835769',1,84.31,84.31,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(165,41,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Dr. Mckenna Walker - cesar.kovacek@gmail.com','cesar.kovacek@gmail.com','0142309880',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(166,41,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Kaycee Conroy I - gdietrich@larkin.biz','gdietrich@larkin.biz','0751680441',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(167,41,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Quinn Hamill - magali.hodkiewicz@yahoo.com','magali.hodkiewicz@yahoo.com','0956185328',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(168,42,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Ms. Cynthia Zemlak II - bbartell@hotmail.com','bbartell@hotmail.com','0659879245',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(169,42,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Cayla Monahan - abbott.maryse@gmail.com','abbott.maryse@gmail.com','0966037660',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(170,42,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Chyna Fahey - kattie75@dietrich.info','kattie75@dietrich.info','0411464560',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Cora Blanda - zboyer@yahoo.com','zboyer@yahoo.com','0097652431',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(172,42,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Veda Lehner - rosenbaum.efren@stokes.net','rosenbaum.efren@stokes.net','0738677094',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(173,42,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Ezequiel Thompson - xmueller@yahoo.com','xmueller@yahoo.com','0122418046',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(174,43,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Garry Aufderhar - lelah.larkin@gmail.com','lelah.larkin@gmail.com','0862704452',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(175,43,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Anastasia Ullrich - llewellyn.kovacek@yahoo.com','llewellyn.kovacek@yahoo.com','0916109379',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(176,43,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Elias Grant DDS - pearl98@hotmail.com','pearl98@hotmail.com','0517185299',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(177,43,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Kyleigh Murray - megane43@bartoletti.com','megane43@bartoletti.com','0518278192',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(178,43,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Noemi Kuphal - mprohaska@dare.biz','mprohaska@dare.biz','0366956653',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(179,44,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Deondre Lockman II - nmcglynn@kertzmann.com','nmcglynn@kertzmann.com','0888934981',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(180,44,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Mallie Cremin PhD - mack.homenick@boehm.com','mack.homenick@boehm.com','0204169249',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(181,45,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Jerel Sipes - yoshiko.gibson@hotmail.com','yoshiko.gibson@hotmail.com','0368890429',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(182,45,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Roel Leannon IV - steuber.genevieve@gmail.com','steuber.genevieve@gmail.com','0759630162',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(183,45,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Jaylen Schoen - uriel98@yahoo.com','uriel98@yahoo.com','0186767776',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(184,45,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Jamil Jacobson V - ugreenfelder@hotmail.com','ugreenfelder@hotmail.com','0738613549',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(185,45,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Kenneth McLaughlin - craig37@block.org','craig37@block.org','0538753624',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(186,45,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Maverick Stanton - rgraham@gmail.com','rgraham@gmail.com','0562967652',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(187,46,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Renee Ruecker IV - brenna.gorczany@funk.com','brenna.gorczany@funk.com','0231189626',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(188,46,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Dion Heidenreich - tcruickshank@cassin.net','tcruickshank@cassin.net','0662411481',1,79.05,79.05,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(189,47,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Jasen White - rogahn.birdie@wyman.com','rogahn.birdie@wyman.com','0834377921',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(190,47,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Zula McKenzie - ondricka.missouri@gmail.com','ondricka.missouri@gmail.com','0559294761',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(191,47,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Terrance King - kutch.ryann@hilpert.com','kutch.ryann@hilpert.com','0722876105',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(192,47,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Mr. Boris Brekke MD - eduardo57@gorczany.biz','eduardo57@gorczany.biz','0074707668',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(193,47,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Mrs. Genevieve Hilpert I - kuhlman.austin@keeling.biz','kuhlman.austin@keeling.biz','0451210560',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(194,47,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Prof. Rick Boyle - cristina51@gmail.com','cristina51@gmail.com','0169375503',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(195,48,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Gerda Bednar IV - xwiegand@kessler.net','xwiegand@kessler.net','0024416909',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(196,48,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Mr. Sid Kuphal DVM - brando45@erdman.com','brando45@erdman.com','0595726533',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(197,48,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Halle Parker - lsanford@little.com','lsanford@little.com','0351363780',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(198,48,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Ms. Fay Schimmel - hackett.pansy@moore.com','hackett.pansy@moore.com','0502248144',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(199,48,'ArchiElite\\EventsBooking\\Models\\Ticket',199,'AWS re:Invent - Malachi Kohler - clemens.thiel@hotmail.com','clemens.thiel@hotmail.com','0404628293',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(200,48,'ArchiElite\\EventsBooking\\Models\\Ticket',200,'AWS re:Invent - Dr. Aniyah Rogahn Sr. - paxton41@kuhlman.com','paxton41@kuhlman.com','0700024365',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(201,49,'ArchiElite\\EventsBooking\\Models\\Ticket',201,'AWS re:Invent - Mitchell Welch - anastasia.will@hotmail.com','anastasia.will@hotmail.com','0529783781',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(202,49,'ArchiElite\\EventsBooking\\Models\\Ticket',202,'AWS re:Invent - Abelardo Kunde - rgreenholt@gmail.com','rgreenholt@gmail.com','0950203922',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(203,49,'ArchiElite\\EventsBooking\\Models\\Ticket',203,'AWS re:Invent - Marlee Stoltenberg DDS - mara.schiller@yahoo.com','mara.schiller@yahoo.com','0398475157',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(204,49,'ArchiElite\\EventsBooking\\Models\\Ticket',204,'AWS re:Invent - Ressie Quitzon - osinski.jorge@hotmail.com','osinski.jorge@hotmail.com','0218644358',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(205,49,'ArchiElite\\EventsBooking\\Models\\Ticket',205,'AWS re:Invent - Hazel Haag Sr. - sawayn.watson@hotmail.com','sawayn.watson@hotmail.com','0341668013',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(206,50,'ArchiElite\\EventsBooking\\Models\\Ticket',206,'AWS re:Invent - Oda Herman Jr. - bertram66@purdy.com','bertram66@purdy.com','0537464623',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(207,50,'ArchiElite\\EventsBooking\\Models\\Ticket',207,'AWS re:Invent - Ed Welch MD - nhalvorson@hotmail.com','nhalvorson@hotmail.com','0699347897',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(208,50,'ArchiElite\\EventsBooking\\Models\\Ticket',208,'AWS re:Invent - Prof. Annamae Stracke - raynor.geovanny@gmail.com','raynor.geovanny@gmail.com','0508253211',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(209,50,'ArchiElite\\EventsBooking\\Models\\Ticket',209,'AWS re:Invent - Dr. Axel Marks - tdamore@hotmail.com','tdamore@hotmail.com','0333200602',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(210,50,'ArchiElite\\EventsBooking\\Models\\Ticket',210,'AWS re:Invent - Chelsey Moore - ylegros@shields.biz','ylegros@shields.biz','0099017017',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(211,50,'ArchiElite\\EventsBooking\\Models\\Ticket',211,'AWS re:Invent - Prof. Dorthy Koepp - rdonnelly@gmail.com','rdonnelly@gmail.com','0179420914',1,79.05,79.05,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',99.99,'CES (Consumer Electronics Show)','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',399.96,399.96,0.00,0.00,NULL,1,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',99.99,'CES (Consumer Electronics Show)','Johathan Bauch','ankunding.romaine@legros.biz',NULL,'ArchiElite','main/general/logo-light.png',299.97,299.97,0.00,0.00,NULL,2,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',99.99,'CES (Consumer Electronics Show)','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',499.95,499.95,0.00,0.00,NULL,3,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',99.99,'CES (Consumer Electronics Show)','Prof. Meaghan Skiles Jr.','zkling@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',399.96,399.96,0.00,0.00,NULL,4,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',99.99,'CES (Consumer Electronics Show)','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',199.98,199.98,0.00,0.00,NULL,5,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',99.99,'CES (Consumer Electronics Show)','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',199.98,199.98,0.00,0.00,NULL,6,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',99.99,'CES (Consumer Electronics Show)','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',99.99,99.99,0.00,0.00,NULL,7,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',99.99,'CES (Consumer Electronics Show)','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',499.95,499.95,0.00,0.00,NULL,8,'completed','2025-06-10 10:41:53','2025-06-10 10:41:53','2025-06-10 10:41:53'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',99.99,'CES (Consumer Electronics Show)','Richie Lakin','jessyca.donnelly@veum.biz',NULL,'ArchiElite','main/general/logo-light.png',99.99,99.99,0.00,0.00,NULL,9,'completed','2025-06-10 10:41:54','2025-06-10 10:41:53','2025-06-10 10:41:54'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',99.99,'CES (Consumer Electronics Show)','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',499.95,499.95,0.00,0.00,NULL,10,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',31.68,'Mobile World Congress','Richie Lakin','jessyca.donnelly@veum.biz',NULL,'ArchiElite','main/general/logo-light.png',158.40,158.40,0.00,0.00,NULL,11,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',31.68,'Mobile World Congress','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',95.04,95.04,0.00,0.00,NULL,12,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',31.68,'Mobile World Congress','Prof. Meaghan Skiles Jr.','zkling@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',126.72,126.72,0.00,0.00,NULL,13,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',31.68,'Mobile World Congress','Arnaldo Klein','delilah33@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',63.36,63.36,0.00,0.00,NULL,14,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',31.68,'Mobile World Congress','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',158.40,158.40,0.00,0.00,NULL,15,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',31.68,'Mobile World Congress','Maximillian Stamm','fritsch.emily@jacobs.net',NULL,'ArchiElite','main/general/logo-light.png',95.04,95.04,0.00,0.00,NULL,16,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',31.68,'Mobile World Congress','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',95.04,95.04,0.00,0.00,NULL,17,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',31.68,'Mobile World Congress','Prof. Meaghan Skiles Jr.','zkling@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',158.40,158.40,0.00,0.00,NULL,18,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',31.68,'Mobile World Congress','Arnaldo Klein','delilah33@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',126.72,126.72,0.00,0.00,NULL,19,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',31.68,'Mobile World Congress','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',31.68,31.68,0.00,0.00,NULL,20,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:54'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',86.80,'Google I/O','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',173.60,173.60,0.00,0.00,NULL,21,'completed','2025-06-10 10:41:54','2025-06-10 10:41:54','2025-06-10 10:41:55'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',86.80,'Google I/O','Johathan Bauch','ankunding.romaine@legros.biz',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,22,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',86.80,'Google I/O','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,23,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',86.80,'Google I/O','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,24,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',86.80,'Google I/O','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',260.40,260.40,0.00,0.00,NULL,25,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',86.80,'Google I/O','Maximillian Stamm','fritsch.emily@jacobs.net',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,26,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',86.80,'Google I/O','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,27,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',86.80,'Google I/O','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',86.80,86.80,0.00,0.00,NULL,28,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',86.80,'Google I/O','Maximillian Stamm','fritsch.emily@jacobs.net',NULL,'ArchiElite','main/general/logo-light.png',347.20,347.20,0.00,0.00,NULL,29,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',86.80,'Google I/O','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',434.00,434.00,0.00,0.00,NULL,30,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',84.31,'Apple WWDC','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',168.62,168.62,0.00,0.00,NULL,31,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',84.31,'Apple WWDC','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',168.62,168.62,0.00,0.00,NULL,32,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',84.31,'Apple WWDC','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',84.31,84.31,0.00,0.00,NULL,33,'completed','2025-06-10 10:41:55','2025-06-10 10:41:55','2025-06-10 10:41:55'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',84.31,'Apple WWDC','Richie Lakin','jessyca.donnelly@veum.biz',NULL,'ArchiElite','main/general/logo-light.png',168.62,168.62,0.00,0.00,NULL,34,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',84.31,'Apple WWDC','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',252.93,252.93,0.00,0.00,NULL,35,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',84.31,'Apple WWDC','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',252.93,252.93,0.00,0.00,NULL,36,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',84.31,'Apple WWDC','Maximillian Stamm','fritsch.emily@jacobs.net',NULL,'ArchiElite','main/general/logo-light.png',168.62,168.62,0.00,0.00,NULL,37,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',84.31,'Apple WWDC','Dr. Modesto Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',168.62,168.62,0.00,0.00,NULL,38,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',84.31,'Apple WWDC','Maximillian Stamm','fritsch.emily@jacobs.net',NULL,'ArchiElite','main/general/logo-light.png',337.24,337.24,0.00,0.00,NULL,39,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',84.31,'Apple WWDC','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',84.31,84.31,0.00,0.00,NULL,40,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',79.05,'AWS re:Invent','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',158.10,158.10,0.00,0.00,NULL,41,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',79.05,'AWS re:Invent','Richie Lakin','jessyca.donnelly@veum.biz',NULL,'ArchiElite','main/general/logo-light.png',395.25,395.25,0.00,0.00,NULL,42,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',79.05,'AWS re:Invent','Leta Schultz','beau.conn@herman.net',NULL,'ArchiElite','main/general/logo-light.png',316.20,316.20,0.00,0.00,NULL,43,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',79.05,'AWS re:Invent','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',79.05,79.05,0.00,0.00,NULL,44,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',79.05,'AWS re:Invent','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',395.25,395.25,0.00,0.00,NULL,45,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',79.05,'AWS re:Invent','Genoveva Kuhlman','dante26@kreiger.org',NULL,'ArchiElite','main/general/logo-light.png',79.05,79.05,0.00,0.00,NULL,46,'completed','2025-06-10 10:41:56','2025-06-10 10:41:56','2025-06-10 10:41:56'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',79.05,'AWS re:Invent','Dr. Marty Hauck Jr.','mitchell.chelsie@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',395.25,395.25,0.00,0.00,NULL,47,'completed','2025-06-10 10:41:57','2025-06-10 10:41:56','2025-06-10 10:41:57'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',79.05,'AWS re:Invent','Isai VonRueden','paige.stracke@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',395.25,395.25,0.00,0.00,NULL,48,'completed','2025-06-10 10:41:57','2025-06-10 10:41:57','2025-06-10 10:41:57'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',79.05,'AWS re:Invent','Dora Gusikowski','glover.bartholome@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',316.20,316.20,0.00,0.00,NULL,49,'completed','2025-06-10 10:41:57','2025-06-10 10:41:57','2025-06-10 10:41:57'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',79.05,'AWS re:Invent','Dr. Marty Hauck Jr.','mitchell.chelsie@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',395.25,395.25,0.00,0.00,NULL,50,'completed','2025-06-10 10:41:57','2025-06-10 10:41:57','2025-06-10 10:41:57');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'EA5QV6UGGIV2','11c665b4-483b-489d-b86f-4b384438bb12',1,'CES (Consumer Electronics Show)',99.99,20,1,'Isai VonRueden','paige.stracke@yahoo.com','He got behind Alice as it can\'t possibly make me giddy.\' And then, turning to the porpoise, \"Keep.',NULL,'1',99.99,4,399.96,399.96,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(2,'PF4OES9ZPHB5','c52762a8-0540-4b35-aa89-2fac59dd30ba',1,'CES (Consumer Electronics Show)',99.99,21,1,'Johathan Bauch','ankunding.romaine@legros.biz','Alice. \'I wonder how many miles I\'ve fallen by this time?\' she said to herself; \'I should have.',NULL,'2',99.99,3,299.97,299.97,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(3,'ASMHJVBFACOH','6e95c746-2cef-4e7a-87d0-2120bbba3572',1,'CES (Consumer Electronics Show)',99.99,25,1,'Genoveva Kuhlman','dante26@kreiger.org','Alice; \'it\'s laid for a minute or two she walked off, leaving Alice alone with the next witness.',NULL,'3',99.99,5,499.95,499.95,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(4,'RD3CC0ZZUMJJ','7d4c18a3-8f0a-4a08-8c72-3c7230df1507',1,'CES (Consumer Electronics Show)',99.99,12,1,'Prof. Meaghan Skiles Jr.','zkling@hotmail.com','Classics master, though. He was an old conger-eel, that used to it!\' pleaded poor Alice began to.',NULL,'4',99.99,4,399.96,399.96,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(5,'RKCNALYYY3J7','75412930-cd7b-4e23-80df-2dac1602a876',1,'CES (Consumer Electronics Show)',99.99,25,1,'Genoveva Kuhlman','dante26@kreiger.org','They\'re dreadfully fond of pretending to be lost, as she tucked her arm affectionately into.',NULL,'5',99.99,2,199.98,199.98,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(6,'KPLW09FPWWKJ','21f9cc5a-1042-4e98-a9e7-3af0cfaa891a',1,'CES (Consumer Electronics Show)',99.99,8,1,'Leta Schultz','beau.conn@herman.net','Majesty,\' said the King; \'and don\'t look at it!\' This speech caused a remarkable sensation among.',NULL,'6',99.99,2,199.98,199.98,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(7,'DLEGVJE8WNXO','a7c1042c-dcec-414b-b216-eebe2dab9eb1',1,'CES (Consumer Electronics Show)',99.99,20,1,'Isai VonRueden','paige.stracke@yahoo.com','You see, she came rather late, and the two creatures, who had not gone much farther before she had.',NULL,'7',99.99,1,99.99,99.99,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(8,'RJFW4HZLSNV1','1c6599c3-ca0a-4d2b-8440-4ffd6eaae5ce',1,'CES (Consumer Electronics Show)',99.99,8,1,'Leta Schultz','beau.conn@herman.net','While she was dozing off, and she hurried out of its mouth and yawned once or twice she had read.',NULL,'8',99.99,5,499.95,499.95,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53'),(9,'YOMI5S6MG1SL','ba6fde0e-e05b-40e3-b083-c4d3dccbef3b',1,'CES (Consumer Electronics Show)',99.99,4,1,'Richie Lakin','jessyca.donnelly@veum.biz','Alice had learnt several things of this sort in her pocket) till she was quite pleased to have got.',NULL,'9',99.99,1,99.99,99.99,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:53','2025-06-10 10:41:54'),(10,'H4YBYKUIY6J0','8b9bd5e5-70c4-4d72-9794-88ea599202b7',1,'CES (Consumer Electronics Show)',99.99,8,1,'Leta Schultz','beau.conn@herman.net','However, she soon made out what it was: she was quite impossible to say \'I once tasted--\' but.',NULL,'10',99.99,5,499.95,499.95,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(11,'WWPECQTAMTNC','6392bd54-fd2c-424f-a1f5-3d6b5e8bc1d3',2,'Mobile World Congress',31.68,4,1,'Richie Lakin','jessyca.donnelly@veum.biz','Queen. \'Never!\' said the Queen, and Alice, were in custody and under sentence of execution. Then.',NULL,'11',31.68,5,158.40,158.40,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(12,'I6NSCNKKFAYW','56ec7538-0575-46c4-95d1-ca1c98b791e9',2,'Mobile World Congress',31.68,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','Pray, what is the same thing, you know.\' \'I DON\'T know,\' said the Queen, and Alice, were in.',NULL,'12',31.68,3,95.04,95.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(13,'DCBQCAGLHIMV','c487de70-e5d5-4a85-80f8-d318ce2fdcb6',2,'Mobile World Congress',31.68,12,1,'Prof. Meaghan Skiles Jr.','zkling@hotmail.com','SOME change in my life!\' She had not attended to this mouse? Everything is so out-of-the-way down.',NULL,'13',31.68,4,126.72,126.72,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(14,'HMIJZG6P3C3V','87273343-9e55-4086-90f8-354edb2a10f6',2,'Mobile World Congress',31.68,11,1,'Arnaldo Klein','delilah33@hotmail.com','Queen was silent. The King looked anxiously at the bottom of a well?\' The Dormouse slowly opened.',NULL,'14',31.68,2,63.36,63.36,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(15,'OJ4AT5JYXKKC','8816d71e-82b1-44fa-8be6-09acf6a84625',2,'Mobile World Congress',31.68,20,1,'Isai VonRueden','paige.stracke@yahoo.com','Alice!\' she answered herself. \'How can you learn lessons in here? Why, there\'s hardly enough of me.',NULL,'15',31.68,5,158.40,158.40,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(16,'AOGBU2TWYA9I','e164109e-56b8-47a9-9d5f-fe4a16b8826c',2,'Mobile World Congress',31.68,15,1,'Maximillian Stamm','fritsch.emily@jacobs.net','Alice. It looked good-natured, she thought: still it was all ridges and furrows; the balls were.',NULL,'16',31.68,3,95.04,95.04,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(17,'2CSYLR4LLAPX','80cb3056-040d-41e1-9ce5-cff3102a018c',2,'Mobile World Congress',31.68,8,1,'Leta Schultz','beau.conn@herman.net','Queen, pointing to the Classics master, though. He was an immense length of neck, which seemed to.',NULL,'17',31.68,3,95.04,95.04,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(18,'VNIZAWWHX7XQ','fac70097-2bcc-4062-aea7-773de0889db9',2,'Mobile World Congress',31.68,12,1,'Prof. Meaghan Skiles Jr.','zkling@hotmail.com','Mouse. \'--I proceed. \"Edwin and Morcar, the earls of Mercia and Northumbria--\"\' \'Ugh!\' said the.',NULL,'18',31.68,5,158.40,158.40,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(19,'1UKHG88GCU5K','5bfc8f27-a969-42a6-88a5-af6a5c71a449',2,'Mobile World Congress',31.68,11,1,'Arnaldo Klein','delilah33@hotmail.com','Cat. \'I\'d nearly forgotten to ask.\' \'It turned into a small passage, not much surprised at her own.',NULL,'19',31.68,4,126.72,126.72,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(20,'QOLLQZ0HBJZI','771af261-8434-4152-9316-463bb68b3d9e',2,'Mobile World Congress',31.68,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','Dormouse into the open air. \'IF I don\'t like them raw.\' \'Well, be off, and she crossed her hands.',NULL,'20',31.68,1,31.68,31.68,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(21,'YRBGGXCMJQHY','45051f36-faf6-4f71-bea4-ae12382164fe',3,'Google I/O',86.80,20,1,'Isai VonRueden','paige.stracke@yahoo.com','I was a real Turtle.\' These words were followed by a very interesting dance to watch,\' said Alice.',NULL,'21',86.80,2,173.60,173.60,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54'),(22,'YIJZ0JYXPXFM','da9be040-55f5-45b2-92fc-056738f9478f',3,'Google I/O',86.80,21,1,'Johathan Bauch','ankunding.romaine@legros.biz','Gryphon is, look at it!\' This speech caused a remarkable sensation among the leaves, which she.',NULL,'22',86.80,4,347.20,347.20,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(23,'6QGDTXG2I2T2','39ace8f2-5704-4f20-8501-d4e73193c10f',3,'Google I/O',86.80,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','And so she turned the corner, but the great wonder is, that there\'s any one of the gloves, and she.',NULL,'23',86.80,4,347.20,347.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(24,'J3EJRKOEWYKZ','60092a46-231a-44b4-871d-a6aa4c26bc1e',3,'Google I/O',86.80,1,1,'Dr. Modesto Lemke','customer@archielite.com','Caterpillar. \'Not QUITE right, I\'m afraid,\' said Alice, \'because I\'m not myself, you see.\' \'I.',NULL,'24',86.80,4,347.20,347.20,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(25,'VHA2MF30DT8V','58a80fc6-494b-4a77-a99f-42325be51d4b',3,'Google I/O',86.80,1,1,'Dr. Modesto Lemke','customer@archielite.com','I\'m not looking for eggs, I know is, it would not give all else for two reasons. First, because.',NULL,'25',86.80,3,260.40,260.40,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(26,'SEHXYT1KLMRV','d4a19046-fb53-4f04-949d-cac6ee62acf3',3,'Google I/O',86.80,15,1,'Maximillian Stamm','fritsch.emily@jacobs.net','Caterpillar took the regular course.\' \'What was that?\' inquired Alice. \'Reeling and Writhing, of.',NULL,'26',86.80,4,347.20,347.20,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(27,'WOACNZL6M0WP','1f06b06e-630d-4dd9-a33d-11bb43c6360b',3,'Google I/O',86.80,1,1,'Dr. Modesto Lemke','customer@archielite.com','Mock Turtle, \'they--you\'ve seen them, of course?\' \'Yes,\' said Alice, \'how am I to do?\' said Alice.',NULL,'27',86.80,4,347.20,347.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(28,'CG7R36PWIAXW','acc2a92a-1f65-4f2f-8739-f3c53da55145',3,'Google I/O',86.80,25,1,'Genoveva Kuhlman','dante26@kreiger.org','She took down a very decided tone: \'tell her something worth hearing. For some minutes it seemed.',NULL,'28',86.80,1,86.80,86.80,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(29,'ZV2CXQPWUWIG','86918f7a-54f4-4ed5-82b7-9f6eac8b3192',3,'Google I/O',86.80,15,1,'Maximillian Stamm','fritsch.emily@jacobs.net','For this must be shutting up like a Jack-in-the-box, and up the fan and gloves. \'How queer it.',NULL,'29',86.80,4,347.20,347.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(30,'DLCQ7VSWDQKD','035ea49a-b7a1-470f-9743-eea1cca3114c',3,'Google I/O',86.80,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','It was the White Rabbit, \'but it seems to grin, How neatly spread his claws, And welcome little.',NULL,'30',86.80,5,434.00,434.00,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(31,'T1TYPKHWECDS','8ce82ac2-460c-4623-a74f-e8c1d4f9afd3',4,'Apple WWDC',84.31,25,1,'Genoveva Kuhlman','dante26@kreiger.org','I didn\'t!\' interrupted Alice. \'You did,\' said the Dormouse: \'not in that soup!\' Alice said very.',NULL,'31',84.31,2,168.62,168.62,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(32,'BJUY4NMOKV9P','d20bec91-29bd-4dbd-a294-20eab0895130',4,'Apple WWDC',84.31,8,1,'Leta Schultz','beau.conn@herman.net','At this the whole court was a large ring, with the dream of Wonderland of long ago: and how she.',NULL,'32',84.31,2,168.62,168.62,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(33,'FBYHFLYPJSSJ','076eed7d-4dbb-49b9-ad9c-1ed6e702badd',4,'Apple WWDC',84.31,20,1,'Isai VonRueden','paige.stracke@yahoo.com','The only things in the middle. Alice kept her waiting!\' Alice felt dreadfully puzzled. The.',NULL,'33',84.31,1,84.31,84.31,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55'),(34,'8YVMDPP9KLYO','15840d61-686c-4c7f-9339-42e0a5177353',4,'Apple WWDC',84.31,4,1,'Richie Lakin','jessyca.donnelly@veum.biz','Next came an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' said Alice, surprised at her.',NULL,'34',84.31,2,168.62,168.62,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(35,'G6GXNN6DFAGA','a81d8878-8be5-4db5-8ee4-698f5f90e062',4,'Apple WWDC',84.31,1,1,'Dr. Modesto Lemke','customer@archielite.com','I wonder?\' Alice guessed in a great letter, nearly as large as the large birds complained that.',NULL,'35',84.31,3,252.93,252.93,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(36,'ZC4LLCB6A38S','a38e40bc-8216-48a3-b6f5-33dba3d4a96e',4,'Apple WWDC',84.31,1,1,'Dr. Modesto Lemke','customer@archielite.com','I get it home?\' when it saw mine coming!\' \'How do you know why it\'s called a whiting?\' \'I never.',NULL,'36',84.31,3,252.93,252.93,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(37,'AKYFO5A9AFPN','afb2d82e-6c12-45a6-8379-ae2256461876',4,'Apple WWDC',84.31,15,1,'Maximillian Stamm','fritsch.emily@jacobs.net','Alice said; but was dreadfully puzzled by the pope, was soon submitted to by all three dates on.',NULL,'37',84.31,2,168.62,168.62,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(38,'RNEBRVNK6CJ0','fd5bc001-e6c0-4c13-b18b-9fe7c36d435d',4,'Apple WWDC',84.31,1,1,'Dr. Modesto Lemke','customer@archielite.com','I could say if I fell off the subjects on his knee, and looking anxiously round to see it again.',NULL,'38',84.31,2,168.62,168.62,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(39,'JPE85U4GIDRS','2ed38f7a-5bd1-4796-b283-620d1ba599ed',4,'Apple WWDC',84.31,15,1,'Maximillian Stamm','fritsch.emily@jacobs.net','Alice quite hungry to look over their slates; \'but it sounds uncommon nonsense.\' Alice said.',NULL,'39',84.31,4,337.24,337.24,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(40,'CDQO8TQZJ2LD','d9283e53-a773-4f9e-bce3-1586cfbf23d6',4,'Apple WWDC',84.31,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','How I wonder what CAN have happened to me! When I used to do:-- \'How doth the little door was shut.',NULL,'40',84.31,1,84.31,84.31,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(41,'LLP7HHCYCF3X','58e45390-55fd-445f-a7be-02577e259ac6',5,'AWS re:Invent',79.05,25,1,'Genoveva Kuhlman','dante26@kreiger.org','ME\' were beautifully marked in currants. \'Well, I\'ll eat it,\' said the Caterpillar. Alice thought.',NULL,'41',79.05,2,158.10,158.10,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(42,'1QBKJVOAGVTD','c09ed326-c973-4ee9-a5b6-f68e4dcb8706',5,'AWS re:Invent',79.05,4,1,'Richie Lakin','jessyca.donnelly@veum.biz','Alice dodged behind a great deal to come down the chimney!\' \'Oh! So Bill\'s got the other--Bill!.',NULL,'42',79.05,5,395.25,395.25,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(43,'G2TYTBWFDELN','d524c574-f401-4d08-807d-463652d14735',5,'AWS re:Invent',79.05,8,1,'Leta Schultz','beau.conn@herman.net','Hatter: \'let\'s all move one place on.\' He moved on as he spoke. \'UNimportant, of course, Alice.',NULL,'43',79.05,4,316.20,316.20,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(44,'5WHLPWOH598E','e00edd8b-1adc-42f9-afea-b2cf68ab5e0c',5,'AWS re:Invent',79.05,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','Alice, thinking it was too small, but at last she stretched her arms folded, frowning like a frog.',NULL,'44',79.05,1,79.05,79.05,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(45,'PEMS09ZH8ZGY','fba17adf-ee97-4e3a-9b2d-8b64c915c88a',5,'AWS re:Invent',79.05,20,1,'Isai VonRueden','paige.stracke@yahoo.com','Hatter: \'as the things between whiles.\' \'Then you should say what you would have appeared to them.',NULL,'45',79.05,5,395.25,395.25,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(46,'ECHWR9RRA0TO','03aca97e-4e18-4db2-bd09-132788f8afd8',5,'AWS re:Invent',79.05,25,1,'Genoveva Kuhlman','dante26@kreiger.org','I know all the way YOU manage?\' Alice asked. \'We called him Tortoise because he was gone, and, by.',NULL,'46',79.05,1,79.05,79.05,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(47,'AIZGNIACAFO6','23789250-e28e-47f9-b467-e9c325054eb4',5,'AWS re:Invent',79.05,16,1,'Dr. Marty Hauck Jr.','mitchell.chelsie@yahoo.com','Alice hastily replied; \'at least--at least I mean what I see\"!\' \'You might just as well say,\'.',NULL,'47',79.05,5,395.25,395.25,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56'),(48,'JSVFOKMGBMZS','5f54159f-fda9-4b88-8639-98dd927be58f',5,'AWS re:Invent',79.05,20,1,'Isai VonRueden','paige.stracke@yahoo.com','I can find it.\' And she kept tossing the baby was howling so much contradicted in her hands, and.',NULL,'48',79.05,5,395.25,395.25,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(49,'3XQ2WTQ1UMRG','ff98f415-11a2-4916-91d2-ecef75b76932',5,'AWS re:Invent',79.05,7,1,'Dora Gusikowski','glover.bartholome@yahoo.com','When the procession came opposite to Alice, they all quarrel so dreadfully one can\'t hear oneself.',NULL,'49',79.05,4,316.20,316.20,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57'),(50,'G8HI5OVNSC78','0c818b21-c5bf-4530-80ce-ca4bd8e0f651',5,'AWS re:Invent',79.05,16,1,'Dr. Marty Hauck Jr.','mitchell.chelsie@yahoo.com','I don\'t care which happens!\' She ate a little snappishly. \'You\'re enough to look about her and to.',NULL,'50',79.05,5,395.25,395.25,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=212 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'UMKKJ121C6TM','Mercedes Huel','annabell.hill@dare.info','0804756700','Queen, \'and take this child away with me,\' thought Alice, \'or perhaps they won\'t walk the way to.',NULL,'reserved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(2,1,'X3JJHBKU9VGE','Wilford Gutkowski','zweber@blanda.com','0165242605','Alice. \'Why, SHE,\' said the King replied. Here the other players, and shouting \'Off with his.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(3,1,'8BVGBHZOJBM2','Bridie Frami','patience.waelchi@beahan.net','0393682352','ME\' beautifully printed on it but tea. \'I don\'t see any wine,\' she remarked. \'There isn\'t any,\'.',NULL,'purchased','2025-06-10 10:41:53','2025-06-10 10:41:53'),(4,1,'MKBM6G0QU6DI','Grayson Satterfield','maggio.sheila@homenick.com','0267828492','I think--\' (for, you see, Alice had learnt several things of this ointment--one shilling the box.',NULL,'purchased','2025-06-10 10:41:53','2025-06-10 10:41:53'),(5,1,'PDTNTUKTEEIU','Devon Krajcik II','xdicki@heller.org','0105964078','AND WASHING--extra.\"\' \'You couldn\'t have done that, you know,\' the Hatter replied. \'Of course.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(6,2,'P7L59AQ4HCAZ','Amir Moore III','okon.ruben@gmail.com','0073795046','VERY much out of the Queen\'s ears--\' the Rabbit just under the window, and one foot to the.',NULL,'transferred','2025-06-10 10:41:53','2025-06-10 10:41:53'),(7,2,'R6M5TQS8IVXQ','Mr. Janick Will','hwalker@adams.com','0324002662','There was a little girl she\'ll think me at all.\' \'In that case,\' said the Pigeon; \'but I haven\'t.',NULL,'checked_in','2025-06-10 10:41:53','2025-06-10 10:41:53'),(8,2,'VV7SRD0THYJS','Prof. Alek Dooley','lmann@kuvalis.com','0184504740','Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'Well, then,\' the Cat again, sitting on a.',NULL,'transferred','2025-06-10 10:41:53','2025-06-10 10:41:53'),(9,2,'UGIFOHTKMQJD','Kaya Volkman','bjohns@nitzsche.org','0014363749','You MUST have meant some mischief, or else you\'d have signed your name like an honest man.\' There.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(10,3,'FDFGATAPTLGK','Beryl Skiles','graham.edwina@yahoo.com','0929544487','I never heard of uglifying!\' it exclaimed. \'You know what they\'re like.\' \'I believe so,\' Alice.',NULL,'refunded','2025-06-10 10:41:53','2025-06-10 10:41:53'),(11,3,'OJR6GFXAAX4P','Jaylin McDermott','sdamore@heaney.com','0303942250','Alice, as she picked her way into that beautiful garden--how IS that to be sure! However.',NULL,'checked_in','2025-06-10 10:41:53','2025-06-10 10:41:53'),(12,3,'HEKMLCW3H1IQ','Grant Mante V','king.everett@hotmail.com','0597854415','The Cat only grinned when it saw mine coming!\' \'How do you know the song, perhaps?\' \'I\'ve heard.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(13,3,'OMSBHWLK3M5K','Mrs. Abbigail Ernser I','jodie.dickinson@hotmail.com','0232745130','Gryphon as if he would deny it too: but the Dormouse indignantly. However, he consented to go on.',NULL,'checked_in','2025-06-10 10:41:53','2025-06-10 10:41:53'),(14,3,'LHOOVMJLXUDI','Dr. Celestine Hessel','brooke.bogisich@hotmail.com','0628328192','CHAPTER XII. Alice\'s Evidence \'Here!\' cried Alice, jumping up in spite of all this time. \'I want a.',NULL,'reserved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(15,3,'DHSA9SQRUWKO','Dr. Rosario Beahan III','hailey.wiza@vandervort.com','0790789174','Gryphon. \'I\'ve forgotten the words.\' So they sat down and cried. \'Come, there\'s no harm in.',NULL,'reserved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(16,4,'BXN6EEVWHRDV','Else Graham III','pfeffer.modesto@rau.com','0371298157','He says it kills all the first witness,\' said the Gryphon, \'that they WOULD put their heads off?\'.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(17,4,'XTCYRM2RJCVK','Hunter Brekke','crooks.samir@hotmail.com','0847148681','Oh dear! I shall be a Caucus-race.\' \'What IS a Caucus-race?\' said Alice; \'I must be growing small.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(18,4,'DBNSXPFEVFBG','Mrs. Elenora Lebsack I','sage.larkin@gmail.com','0607292261','There was a sound of many footsteps, and Alice looked round, eager to see if he thought it had.',NULL,'refunded','2025-06-10 10:41:53','2025-06-10 10:41:53'),(19,4,'KGHU7J8FKSYW','Miss Dora Marks V','garrett.rodriguez@gmail.com','0486573442','Caterpillar. Here was another long passage, and the Queen had only one way up as the Dormouse.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(20,4,'G8SNI26KJVEF','Asa Goyette','scot.konopelski@gmail.com','0950631643','Alice. \'I\'ve so often read in the middle, nursing a baby; the cook was busily stirring the soup.',NULL,'refunded','2025-06-10 10:41:53','2025-06-10 10:41:53'),(21,5,'4YVUGOAM1U0Q','Nathanael O\'Keefe','macey.streich@tremblay.com','0512387937','Gryphon replied rather impatiently: \'any shrimp could have been changed for any of them. \'I\'m sure.',NULL,'reserved','2025-06-10 10:41:53','2025-06-10 10:41:53'),(22,5,'WJZPEECRJ3PQ','Nelda Ruecker','qschoen@hotmail.com','0154737998','Hatter. \'It isn\'t mine,\' said the Lory. Alice replied thoughtfully. \'They have their tails in.',NULL,'refunded','2025-06-10 10:41:53','2025-06-10 10:41:53'),(23,5,'RGNBWWX21HEK','Benton Graham','pouros.emilio@gmail.com','0132076526','Alice a little quicker. \'What a curious appearance in the air: it puzzled her too much, so she.',NULL,'transferred','2025-06-10 10:41:53','2025-06-10 10:41:53'),(24,6,'8DWALYIN8OAX','Aidan Leuschke MD','zhahn@orn.com','0929409815','Alice loudly. \'The idea of having the sentence first!\' \'Hold your tongue!\' added the March Hare.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(25,6,'7PXIL6QXO4WG','Bruce Hoeger','ward.denis@grady.com','0879111566','Caterpillar decidedly, and there she saw in my time, but never ONE with such sudden violence that.',NULL,'purchased','2025-06-10 10:41:53','2025-06-10 10:41:53'),(26,6,'NMZWLDXLOUBS','Raoul Bayer II','lilliana.murray@abshire.info','0024393029','WHAT things?\' said the young lady to see what was coming. It was the Rabbit hastily interrupted.',NULL,'checked_in','2025-06-10 10:41:53','2025-06-10 10:41:53'),(27,7,'AD6JABC9XIYN','Lucio Corkery','koss.emily@pfannerstill.com','0793244920','March--just before HE went mad, you know--\' \'What did they live at the window, she suddenly spread.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(28,7,'KHZEHKDLQSJX','Deshawn Ebert V','icarter@gmail.com','0746716471','Quick, now!\' And Alice was very hot, she kept on puzzling about it while the Mock Turtle said: \'no.',NULL,'pending','2025-06-10 10:41:53','2025-06-10 10:41:53'),(29,8,'BS71PMSSLDL2','Willy Wiza MD','gziemann@hotmail.com','0017054653','Seven looked up and down in a twinkling! Half-past one, time for dinner!\' (\'I only wish it was,\'.',NULL,'refunded','2025-06-10 10:41:53','2025-06-10 10:41:53'),(30,8,'LIM6YWYQQQXS','Dr. Keon Ortiz III','bechtelar.braeden@yahoo.com','0112995407','I think?\' he said to Alice, and looking at the great hall, with the grin, which remained some time.',NULL,'purchased','2025-06-10 10:41:53','2025-06-10 10:41:53'),(31,8,'SPXUDLRVMPGV','Tia Bartoletti','schaefer.andre@hotmail.com','0621790281','Exactly as we were. My notion was that it seemed quite dull and stupid for life to go on till you.',NULL,'transferred','2025-06-10 10:41:53','2025-06-10 10:41:53'),(32,8,'4VLFPCM3HYFZ','Lou Schulist','reggie86@yahoo.com','0595752368','Alice, \'because I\'m not Ada,\' she said, as politely as she remembered trying to find quite a new.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(33,8,'5XJLX6NB1UYY','Shaniya Cremin','odessa.herman@gmail.com','0792198776','Alice. \'Stand up and down in an undertone, \'important--unimportant--unimportant--important--\' as.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(34,8,'OES9SEBESS7R','Dr. Wilmer Weber Sr.','qcartwright@hotmail.com','0110588286','March.\' As she said aloud. \'I must be really offended. \'We won\'t talk about trouble!\' said the.',NULL,'cancelled','2025-06-10 10:41:53','2025-06-10 10:41:53'),(35,9,'QIHZNV7GHA5S','Dr. Raymundo Schumm IV','xmiller@yahoo.com','0669916286','I am, sir,\' said Alice; \'living at the Queen, turning purple. \'I won\'t!\' said Alice. \'Come, let\'s.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(36,9,'VWYHTPAMY1US','Bethel Toy','manuela14@hotmail.com','0010083054','I\'ll tell you my history, and you\'ll understand why it is all the party were placed along the.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(37,10,'JUPFETLRSBKG','Rodolfo Powlowski I','jwitting@hand.com','0613125451','How queer everything is queer to-day.\' Just then she had never left off staring at the mushroom.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(38,10,'JGRUJYGMRTXF','Bryana Luettgen','koepp.mya@hotmail.com','0250704822','March Hare said in an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' said the Cat. \'I don\'t.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(39,10,'FKRHHTNSQZDZ','Garnet King Jr.','gus.jast@frami.org','0099967349','The moment Alice appeared, she was always ready to make personal remarks,\' Alice said very humbly.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(40,10,'CIKB3J1PDLLA','Prof. Duane Strosin DVM','gislason.brycen@yahoo.com','0655090514','Duchess, \'chop off her knowledge, as there was a body to cut it off from: that he had never been.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(41,10,'0ZHSUVX8LZHQ','Shemar Smitham','kautzer.alyson@terry.net','0244323385','She gave me a good thing!\' she said to herself. \'I dare say you never even introduced to a farmer.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(42,10,'N7RAMGKF8AN6','Felix Simonis','adonis16@gmail.com','0227653862','Queen\'s hedgehog just now, only it ran away when it saw mine coming!\' \'How do you like the three.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(43,11,'JJJ8EZDL7QUR','Mr. Will McKenzie','alysha46@nitzsche.org','0102935959','The Antipathies, I think--\' (she was so ordered about in the sea!\' cried the Mouse, turning to the.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(44,11,'6V5VPLUGUWVM','Prof. Karlee Barton DVM','melvina.schaefer@gmail.com','0544724813','I ever was at in all their simple sorrows, and find a thing,\' said the Duchess, \'as pigs have to.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(45,11,'ULIEQAXQL7CZ','Dr. Angela Runte','douglas.dorothea@gmail.com','0569727199','Alice replied, so eagerly that the Gryphon remarked: \'because they lessen from day to day.\' This.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(46,11,'HGT9XRLSJBJF','Kenton Christiansen I','pagac.vladimir@batz.com','0347147575','And the moral of THAT is--\"Take care of the wood--(she considered him to be otherwise.\"\' \'I think.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(47,11,'XT9CJBTP74FM','Giovani Moore','evan04@howe.com','0915392891','CAN all that green stuff be?\' said Alice. \'What sort of idea that they had to run back into the.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(48,11,'FZUEZ5OSLKRQ','Nicklaus Stokes','spfannerstill@aufderhar.info','0183382607','Alice replied in a thick wood. \'The first thing I\'ve got to see you any more!\' And here Alice.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(49,12,'QXDU2UI5V6SL','Prof. Ila Adams Sr.','bettye.thompson@gmail.com','0470553466','Alice: he had never left off quarrelling with the grin, which remained some time with the Queen.',NULL,'refunded','2025-06-10 10:41:54','2025-06-10 10:41:54'),(50,12,'1H2YVA60YNFH','Evie Emard','pheidenreich@lueilwitz.com','0161966040','Alice could see her after the birds! Why, she\'ll eat a bat?\' when suddenly, thump! thump! down she.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(51,12,'HPDKA6XT4LLJ','Monroe Nienow','ignatius81@hotmail.com','0383072397','Alice loudly. \'The idea of having nothing to do: once or twice, half hoping that they had any.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(52,12,'Q40UTZBOBHGH','Rebecca Stiedemann II','hallie.gerlach@gmail.com','0576560858','Alice dear!\' said her sister; \'Why, what are YOUR shoes done with?\' said the King. \'Shan\'t,\' said.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(53,13,'7KZY4EPPMTJS','Dr. Audrey Kirlin IV','felipa50@hotmail.com','0514370665','I beat him when he sneezes; For he can EVEN finish, if he were trying to make out which were the.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(54,13,'KEPOESXBGH2E','Ciara Lindgren','mayra.mohr@gmail.com','0998962648','They all sat down and began to tremble. Alice looked round, eager to see that queer little toss of.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(55,13,'TZAR5N2E952W','Jeanie Kassulke','mallie.wilderman@hotmail.com','0352533530','By this time it vanished quite slowly, beginning with the Queen say only yesterday you deserved to.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(56,13,'HVVVOKDSBHCH','Ezekiel Hayes','susanna70@miller.com','0765894038','Alice replied, so eagerly that the poor little thing sobbed again (or grunted, it was a very.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(57,13,'HNWXTJIBFBAI','Amalia Luettgen','arnoldo79@gmail.com','0366126863','Mouse, who was gently brushing away some dead leaves that had slipped in like herself. \'Would it.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(58,14,'LGTAZEJ6VULJ','Darron Boyer DVM','therese56@cummings.com','0766788287','Alice. \'Nothing WHATEVER?\' persisted the King. \'Then it doesn\'t understand English,\' thought.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(59,14,'ROJ8TZFHQEHJ','Roel Windler','spinka.darlene@gmail.com','0655281998','I almost wish I could show you our cat Dinah: I think I may as well as the Rabbit, and had just.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(60,14,'OUD348XRIQDD','Jaylin Ward','adell98@kulas.com','0254406002','Mock Turtle drew a long hookah, and taking not the same, the next question is, Who in the night?.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(61,15,'T4PRKEIJIRCR','Pietro Heathcote','ruth52@nader.com','0136887425','Alice, in a day or two: wouldn\'t it be murder to leave the room, when her eye fell on a summer.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(62,15,'PIYHBDNQISPM','Coralie Rogahn','aleen.oberbrunner@barton.com','0875168406','ONE with such a rule at processions; \'and besides, what would happen next. \'It\'s--it\'s a very.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(63,15,'HQUKRR4MPMA7','Buck Balistreri','alvah65@ebert.org','0348374880','And then, turning to Alice: he had to pinch it to half-past one as long as you are; secondly.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(64,15,'J4CXKP53BLBN','Prof. Branson Emmerich','sarah70@frami.net','0927944525','I\'M a Duchess,\' she said to herself. \'Shy, they seem to be\"--or if you\'d like it very much,\' said.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(65,15,'SXYAXC6VXIPX','Ms. Magdalen Leffler','dustin.kessler@murazik.com','0432636670','Gryphon is, look at the bottom of the well, and noticed that one of its mouth, and its great eyes.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(66,15,'43Y3MT0ILP6D','Lois Collins','imani67@huel.com','0676462508','I know. Silence all round, if you drink much from a Caterpillar The Caterpillar was the Hatter.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(67,16,'LMBBD92SDKXG','Mrs. Hosea Wehner','dicki.juston@gmail.com','0725309275','Rabbit coming to look over their slates; \'but it sounds uncommon nonsense.\' Alice said with some.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(68,16,'MDL0QSNTJLGW','Dolly Schmitt','madge30@kuhn.com','0884115257','I shall never get to twenty at that rate! However, the Multiplication Table doesn\'t signify: let\'s.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(69,16,'JNBJHIQHCS7J','Chelsea Beatty','tina.raynor@hotmail.com','0934092471','Hatter trembled so, that he had come back with the Queen, and Alice thought over all the time they.',NULL,'refunded','2025-06-10 10:41:54','2025-06-10 10:41:54'),(70,16,'J7YUAVTM7XUI','Demarcus Weimann','brody33@dare.org','0683218413','I think--\' (for, you see, Miss, we\'re doing our best, afore she comes, to--\' At this the White.',NULL,'refunded','2025-06-10 10:41:54','2025-06-10 10:41:54'),(71,17,'K4MU76UKE5YK','Kacie Prohaska Jr.','harmon.schoen@yahoo.com','0954986247','Mouse\'s tail; \'but why do you know why it\'s called a whiting?\' \'I never could abide figures!\' And.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(72,17,'ZSXSLDF2YR2R','Miss Mina Lueilwitz','reynolds.micaela@bernier.com','0662230249','I\'m not Ada,\' she said, as politely as she had this fit) An obstacle that came between Him, and.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(73,17,'YYHSAIVUM8YM','Mathilde O\'Kon','larue58@nolan.com','0542072185','March Hare: she thought to herself. Imagine her surprise, when the tide rises and sharks are.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(74,17,'FDFYRYEHDVHT','Yazmin Mills III','winifred.kihn@yahoo.com','0385939522','Alice very meekly: \'I\'m growing.\' \'You\'ve no right to think,\' said Alice in a low, timid voice.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(75,18,'KRT0B2KJ0OAZ','Jane Johns Sr.','xhegmann@gmail.com','0357313298','King said to the general conclusion, that wherever you go to law: I will tell you just now what.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(76,18,'NZSNWTTINRRE','Prof. Shaun Fadel','kirlin.kyler@hotmail.com','0944361556','Alice, as she tucked it away under her arm, that it signifies much,\' she said this, she came upon.',NULL,'checked_in','2025-06-10 10:41:54','2025-06-10 10:41:54'),(77,18,'FHAHGQ1GN6UG','Maybelle Brekke','jaren04@hotmail.com','0046904319','When the sands are all pardoned.\' \'Come, THAT\'S a good opportunity for making her escape; so she.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(78,18,'GWL4SRLITLXH','Prof. Jerel Tillman Sr.','vstracke@hotmail.com','0541146967','Alice had begun to think to herself, \'to be going messages for a minute or two she stood looking.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(79,18,'1KNHTSHUPRDT','Mr. Lew Klein','zackery09@monahan.com','0267875981','Hatter. Alice felt a little timidly: \'but it\'s no use in crying like that!\' But she waited for a.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(80,18,'49UFEIMBGYDD','Lavina Adams','lkuhn@predovic.com','0231848755','ME, and told me you had been running half an hour or so there were three little sisters,\' the.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(81,19,'YAPIKXHVCQEY','Bessie Schneider','waylon.reilly@lind.com','0429982208','Caterpillar. Alice thought this must ever be A secret, kept from all the same, shedding gallons of.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(82,19,'HQ9CHPP7WWUV','Virgie Ward','hyatt.chelsie@hotmail.com','0568444402','Hatter was out of that dark hall, and wander about among those beds of bright flowers and the roof.',NULL,'purchased','2025-06-10 10:41:54','2025-06-10 10:41:54'),(83,19,'MTLZELHGN92B','Prof. Francesco Reichert V','littel.ariel@yahoo.com','0877787251','NEVER get any older than you, and don\'t speak a word till I\'ve finished.\' So they began solemnly.',NULL,'reserved','2025-06-10 10:41:54','2025-06-10 10:41:54'),(84,19,'7TGGKOHGFU5T','Drake Little','gabrielle96@greenholt.com','0208192722','I\'ll just see what would be very likely true.) Down, down, down. Would the fall NEVER come to the.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(85,19,'GVUQLKIMU56V','Rosario Lindgren','albin07@funk.com','0699355469','White Rabbit: it was perfectly round, she came in with a growl, And concluded the banquet--] \'What.',NULL,'refunded','2025-06-10 10:41:54','2025-06-10 10:41:54'),(86,20,'TOQW13C9NINO','Buck Keeling','roberta.turcotte@kemmer.com','0858103231','Alice began telling them her adventures from the trees under which she found herself safe in a.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(87,20,'TJDYBZF4RDS6','Prof. Selina Dicki III','merl.yundt@becker.org','0413997001','Cat, \'if you only walk long enough.\' Alice felt a violent blow underneath her chin: it had grown.',NULL,'transferred','2025-06-10 10:41:54','2025-06-10 10:41:54'),(88,21,'COT8DISBZGI6','Dr. Shane O\'Kon PhD','malika.williamson@frami.net','0696936289','What happened to me! When I used to know. Let me see: I\'ll give them a railway station.) However.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(89,21,'FWCGWJFSDIIY','Verda Boyer II','jerod.bergstrom@fahey.com','0649367480','English,\' thought Alice; \'I must be really offended. \'We won\'t talk about her any more questions.',NULL,'pending','2025-06-10 10:41:54','2025-06-10 10:41:54'),(90,21,'WNOSKCBM47IH','Xzavier Kub','dnolan@raynor.com','0339038849','The Queen had ordered. They very soon came upon a little recovered from the trees behind him.',NULL,'cancelled','2025-06-10 10:41:54','2025-06-10 10:41:54'),(91,22,'PW2TRWFFEP4W','Janie Hauck II','jillian.bernier@willms.org','0074641699','I eat\" is the capital of Paris, and Paris is the capital of Rome, and Rome--no, THAT\'S all wrong.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(92,22,'UFNJTCI3UCL3','Prof. Jess Lubowitz IV','earnest.bayer@rutherford.com','0035229031','The March Hare said--\' \'I didn\'t!\' the March Hare, who had meanwhile been examining the roses.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(93,22,'FYDZL2JBYHVF','Loren Koss Sr.','oconnell.reyes@gislason.biz','0857458375','Alice could bear: she got to go from here?\' \'That depends a good deal on where you want to get out.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(94,22,'8S69YWAWWGPO','Prof. Joelle Lehner II','blarkin@gmail.com','0875795276','Father William,\' the young Crab, a little quicker. \'What a curious croquet-ground in her hands.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(95,22,'2LERGXGWFQW5','Sadye Jacobson DDS','dianna79@gmail.com','0440442391','Alice hastily; \'but I\'m not myself, you see.\' \'I don\'t see how the game began. Alice gave a little.',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(96,23,'MVQP88UB6RSG','Dayana Adams','christine.brekke@yahoo.com','0094711753','YOU manage?\' Alice asked. The Hatter looked at it uneasily, shaking it every now and then; such.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(97,23,'YHHZO0ZSVZUY','Marguerite Schneider','fhuel@schoen.info','0382296566','King. Here one of the ground.\' So she went on, very much to-night, I should think very likely to.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(98,23,'YLCWI3KNGQDI','Anabelle Marquardt','dheaney@yahoo.com','0338525961','Alice, (she had grown to her that she hardly knew what she was peering about anxiously among the.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(99,23,'VBGMRMNZISP2','Alden Nitzsche','liam88@braun.info','0704884726','Cat said, waving its tail when I\'m angry. Therefore I\'m mad.\' \'I call it sad?\' And she tried to.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(100,23,'HIEF8PP1NZCN','Mr. Joe King DDS','duncan26@hotmail.com','0579739456','There was a dead silence instantly, and neither of the court, she said this, she came upon a.',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(101,24,'IGO5EPPWGGRZ','Fletcher Stokes','marguerite.rutherford@cartwright.com','0341531437','Alice noticed with some difficulty, as it went, \'One side will make you grow taller, and the.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(102,24,'U3ABSKZCITAK','Adrienne Dicki','abagail.turcotte@schroeder.com','0784961155','Alice. \'Did you say things are worse than ever,\' thought the poor animal\'s feelings. \'I quite.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(103,24,'TP3YE1WKSMBU','Florine Boyle PhD','ukunze@hotmail.com','0669208080','White Rabbit; \'in fact, there\'s nothing written on the trumpet, and then said, \'It WAS a curious.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(104,24,'TIPHBGO9AEKS','Mr. Lawson Abbott IV','amelie96@armstrong.com','0932028218','Dormouse sulkily remarked, \'If you can\'t take more.\' \'You mean you can\'t take LESS,\' said the.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(105,24,'EWCSKNUKXEUT','Loma Kulas','morissette.jo@yahoo.com','0068195435','Hatter began, in a pleased tone. \'Pray don\'t trouble yourself to say it out loud. \'Thinking.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(106,25,'IQEBXYRKDK6D','Agustin Morissette','sally.barrows@nicolas.net','0994623262','I shall have somebody to talk to.\' \'How are you getting on?\' said Alice, seriously, \'I\'ll have.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(107,25,'L2Q14N4DVIJ8','Miss Heloise Veum','elyse.hudson@schroeder.net','0318835914','I\'m grown up now,\' she said, \'than waste it in with a melancholy way, being quite unable to move.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(108,25,'VDIZCBGR3YBN','Ila Stiedemann','oconnell.deontae@spinka.biz','0423464691','Seven flung down his face, as long as I was going to do that,\' said the Hatter: \'let\'s all move.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(109,25,'APBJ5V26GSP1','Maximo Kiehn II','frolfson@koss.biz','0062556771','IS his business!\' said Five, in a great hurry, muttering to himself in an encouraging opening for.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(110,26,'F280X2XIPOS5','Tabitha Bechtelar','wcartwright@koepp.com','0473522032','Queen, the royal children; there were no arches left, and all sorts of things, and she, oh! she.',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(111,26,'RLX5L7FZ2IGA','Miss Whitney Steuber','dayton.crooks@ferry.biz','0963300465','By this time she found her head pressing against the roof off.\' After a minute or two, looking for.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(112,26,'GKBP9LM5BFU6','Dr. Koby Reichert Jr.','thea.schiller@gmail.com','0779925166','She was a sound of many footsteps, and Alice rather unwillingly took the regular course.\' \'What.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(113,26,'XOZILP8DATHI','Bethany Fay','sammie08@heidenreich.net','0217280170','Magpie began wrapping itself up very sulkily and crossed over to the Classics master, though. He.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(114,26,'RXASKODQ7RRD','Dr. Modesto Reichert','madisyn52@hotmail.com','0939853079','I will just explain to you to leave the room, when her eye fell upon a Gryphon, lying fast asleep.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(115,27,'5TNQPJKTDZ1F','Margie Jenkins','christa.halvorson@gmail.com','0391960424','Alice whispered, \'that it\'s done by everybody minding their own business!\' \'Ah, well! It means.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(116,27,'LQ8UGC7NY6XN','Lucas Bode','kamren73@hotmail.com','0323927416','Hardly knowing what she was terribly frightened all the while, till at last the Gryphon replied.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(117,27,'ZCKRHKQGRXWN','Rahsaan Mann','mann.angie@yahoo.com','0933600104','Alice felt dreadfully puzzled. The Hatter\'s remark seemed to think that proved it at last, with a.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(118,27,'ZNOCA55HOHJB','Prof. Kirsten Schimmel','stephania65@yahoo.com','0812506183','Alice. \'Reeling and Writhing, of course, Alice could hardly hear the words:-- \'I speak severely to.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(119,27,'TKM9OY88TIPE','Einar Ebert','aletha28@gmail.com','0055558556','Mouse had changed his mind, and was going a journey, I should understand that better,\' Alice said.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(120,28,'VCU9XH86PZIX','Abigale Ferry','hweber@gmail.com','0085099368','The Cat\'s head with great emphasis, looking hard at Alice for protection. \'You shan\'t be able! I.',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(121,28,'QB39IQQXG2MR','Sasha Wunsch','dillon60@huels.com','0202615478','Now I growl when I\'m pleased, and wag my tail when I\'m angry. Therefore I\'m mad.\' \'I call it.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(122,29,'XNFPVG2DNYDH','Geovanni Stark','bahringer.dangelo@hotmail.com','0580148856','When the sands are all pardoned.\' \'Come, THAT\'S a good character, But said I could not think of.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(123,29,'ICKSARKMT2BW','Cyrus Conn IV','vance04@goodwin.com','0739273491','ARE a simpleton.\' Alice did not answer, so Alice ventured to remark. \'Tut, tut, child!\' said the.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(124,29,'7OPVPUDI11LQ','Wayne Mayert','orn.jeffery@kovacek.com','0982188568','Five and Seven said nothing, but looked at it uneasily, shaking it every now and then; such as.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(125,29,'UGCMOJPEOX4A','Mose King','langosh.izaiah@bernier.net','0805388594','Queen said to herself \'This is Bill,\' she gave a little bottle on it, (\'which certainly was not an.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(126,29,'L1JKSVBUBOD5','Carolina Farrell','michele76@carroll.com','0024128781','Alice recognised the White Rabbit interrupted: \'UNimportant, your Majesty means, of course,\' said.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(127,30,'APMPZHANVYU0','Angelica Predovic MD','jeanie96@yahoo.com','0331791700','The Rabbit started violently, dropped the white kid gloves while she was now the right word).',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(128,30,'URPDHFNPP0TP','Mrs. Josefa Champlin','junius50@swaniawski.com','0273974510','For some minutes it seemed quite natural); but when the Rabbit was still in sight, hurrying down.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(129,30,'JOI8LXCF1ZO9','Name Stark','mrau@hotmail.com','0750109827','Alice said nothing: she had found her head to hide a smile: some of the leaves: \'I should like to.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(130,30,'A1GP6M88KDN7','Maximillia Steuber','kfeest@hotmail.com','0954024517','Which shall sing?\' \'Oh, YOU sing,\' said the Rabbit\'s voice; and the beak-- Pray how did you call.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(131,30,'6AHFTRD9TUOQ','Ashtyn Keebler','kunze.samanta@gmail.com','0730851423','And she opened it, and then she remembered that she was dozing off, and Alice heard it before,\'.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(132,30,'0KOLUQPDSVJX','Luciano Nikolaus I','nlittle@gmail.com','0156530276','March Hare, who had followed him into the jury-box, or they would call after her: the last words.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(133,31,'3XIK8HQSBB7Z','Larissa Auer','laury.hermiston@gmail.com','0714143222','Hatter. \'He won\'t stand beating. Now, if you please! \"William the Conqueror, whose cause was.',NULL,'checked_in','2025-06-10 10:41:55','2025-06-10 10:41:55'),(134,31,'GV2Z0VB38IFT','Dr. Concepcion Steuber','mason.leannon@yahoo.com','0646347611','She was a very curious sensation, which puzzled her too much, so she took up the other, saying, in.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(135,31,'LXBDRHXW64DY','Jacquelyn Spinka IV','jerde.lori@miller.net','0991054874','I\'d been the right word) \'--but I shall be late!\' (when she thought of herself, \'I wish I had not.',NULL,'cancelled','2025-06-10 10:41:55','2025-06-10 10:41:55'),(136,32,'PHQWVKPUALZ0','Mr. Nikolas Yundt DVM','eda76@gmail.com','0066513157','Seaography: then Drawling--the Drawling-master was an old Turtle--we used to read fairy-tales, I.',NULL,'refunded','2025-06-10 10:41:55','2025-06-10 10:41:55'),(137,32,'4JQLNZKGIENL','Magali Miller','narciso.hahn@witting.org','0130984602','White Rabbit put on one side, to look for her, and said, \'That\'s right, Five! Always lay the blame.',NULL,'purchased','2025-06-10 10:41:55','2025-06-10 10:41:55'),(138,32,'J1O46A71U8HP','Lorine Ortiz','guadalupe03@monahan.com','0978579844','Dormouse!\' And they pinched it on both sides of it; so, after hunting all about for it, while the.',NULL,'pending','2025-06-10 10:41:55','2025-06-10 10:41:55'),(139,33,'OHT5XPA46BYK','Dr. Zaria Ferry MD','marquardt.hunter@yahoo.com','0839026743','Alice said nothing; she had never seen such a thing. After a while, finding that nothing more.',NULL,'reserved','2025-06-10 10:41:55','2025-06-10 10:41:55'),(140,33,'XGRGEQHMWIGN','Ellen Thiel','cortney02@lindgren.com','0190979261','Next came an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' And then a voice she had never.',NULL,'transferred','2025-06-10 10:41:55','2025-06-10 10:41:55'),(141,34,'V7FQWBSQTVVI','Malvina Ankunding','zjacobson@johnston.com','0164378023','Gryphon hastily. \'Go on with the words a little, \'From the Queen. \'I haven\'t the slightest idea,\'.',NULL,'transferred','2025-06-10 10:41:56','2025-06-10 10:41:56'),(142,34,'QO3QO1RT5LCS','Prof. Laurine Schaden II','brook69@gmail.com','0472843571','Alice could hear the very middle of one! There ought to tell me the truth: did you manage to do.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(143,34,'HBRQ025RLZIL','Reyna Trantow V','ariel09@roob.org','0339711522','Her chin was pressed hard against it, that attempt proved a failure. Alice heard it before,\' said.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(144,35,'GMHEYYBJW30G','Bettie Runolfsdottir I','cindy.altenwerth@sanford.com','0809112698','Come here directly, and get ready for your walk!\" \"Coming in a low curtain she had someone to.',NULL,'transferred','2025-06-10 10:41:56','2025-06-10 10:41:56'),(145,35,'Y7MLA6BR1ANZ','Melany Jones','vergie.cassin@hoeger.com','0438120085','How puzzling all these strange Adventures of hers would, in the act of crawling away: besides all.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(146,35,'BK7H4QEGAIKH','Ward Spencer','vfadel@pfannerstill.com','0111580115','Hatter continued, \'in this way:-- \"Up above the world go round!\"\' \'Somebody said,\' Alice.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(147,35,'FULPKTXHADMW','Desmond Monahan','mitchell.alexanne@carroll.com','0380898079','Duchess, who seemed to Alice an excellent opportunity for making her escape; so she went to the.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(148,36,'D6FSZ0ZJFGOV','Katheryn Franecki II','dickens.chauncey@hotmail.com','0035025876','Queen in a very truthful child; \'but little girls of her own children. \'How should I know?\' said.',NULL,'transferred','2025-06-10 10:41:56','2025-06-10 10:41:56'),(149,36,'7AOKSUAM5RSO','Dr. Vada Jakubowski','bayer.sophia@feeney.info','0626257710','YOU are, first.\' \'Why?\' said the Dodo had paused as if he would deny it too: but the Dodo suddenly.',NULL,'transferred','2025-06-10 10:41:56','2025-06-10 10:41:56'),(150,36,'LAW3QLS9QN6B','Albert Kuhn Jr.','prosacco.isabella@hotmail.com','0975407214','I shall be punished for it flashed across her mind that she ought not to be a footman in livery.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(151,36,'WZYSUQNHVE3J','Prof. Enola Runolfsdottir','obayer@lebsack.com','0834777033','English); \'now I\'m opening out like the right distance--but then I wonder what you\'re doing!\'.',NULL,'reserved','2025-06-10 10:41:56','2025-06-10 10:41:56'),(152,37,'KNCHPTXXMVLW','Anika Rohan IV','antonina29@brown.net','0983864856','No room!\' they cried out when they passed too close, and waving their forepaws to mark the time.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(153,37,'BTYRTHYHTRBX','Dr. Germaine Schinner MD','scollins@langworth.info','0671963915','Mouse splashed his way through the doorway; \'and even if my head would go anywhere without a.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(154,37,'AKKXRDJWNTBX','Miss Alvina Bogisich','tyshawn.kozey@lubowitz.info','0230218061','He says it kills all the arches are gone from this morning,\' said Alice indignantly. \'Let me.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(155,38,'IKHGBBJCMXEW','Omer Tromp','roxane50@harber.com','0503552482','TO BE TRUE--\" that\'s the jury-box,\' thought Alice, \'they\'re sure to happen,\' she said to the Knave.',NULL,'transferred','2025-06-10 10:41:56','2025-06-10 10:41:56'),(156,38,'BUUDLWDTMXR9','Mrs. Estefania Collins MD','hegmann.aglae@hermann.com','0539071099','XI. Who Stole the Tarts? The King and the Queen in a moment. \'Let\'s go on with the glass table as.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(157,38,'NPDMUUEJULN6','Alivia Bartell','pablo19@prosacco.info','0398464087','I hadn\'t drunk quite so much!\' Alas! it was good manners for her to speak good English); \'now I\'m.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(158,39,'NOUIPSP0NB8D','Gertrude Bartoletti','javon.fritsch@yahoo.com','0953737969','Gryphon. \'We can do no more, whatever happens. What WILL become of me? They\'re dreadfully fond of.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(159,39,'AZQIWYJH1BRT','Colton Wintheiser','ikoepp@hotmail.com','0094493347','Ann! Mary Ann!\' said the Caterpillar. Alice folded her hands, wondering if anything would EVER.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(160,39,'KY37N5M1KEUX','Lucie Halvorson','mohr.avery@gmail.com','0261008276','I\'m sure _I_ shan\'t be able! I shall think nothing of tumbling down stairs! How brave they\'ll all.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(161,39,'CPE0HZOLGNPF','Elfrieda Franecki','julius50@homenick.info','0689933366','HAVE tasted eggs, certainly,\' said Alice, (she had kept a piece of rudeness was more and more.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(162,39,'CG64ECPCHBA2','Mr. Kip Johns','claud.smitham@hansen.com','0903731400','Then it got down off the top of his great wig.\' The judge, by the carrier,\' she thought; \'and how.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(163,40,'HZ7WAZDYAPIL','Mr. Louisa Skiles','mcasper@cummerata.com','0210646785','I\'ll get into the sea, some children digging in the middle. Alice kept her waiting!\' Alice felt so.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(164,40,'POB39KLPHC7K','Prof. Cameron Johns III','eunice.abernathy@sanford.com','0378835769','WOULD go with the edge of her head on her lap as if it had finished this short speech, they all.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(165,41,'TRNXITLLGSOS','Dr. Mckenna Walker','cesar.kovacek@gmail.com','0142309880','Hardly knowing what she did, she picked her way into that lovely garden. I think it was,\' the.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(166,41,'UW6WPTGKHSC3','Kaycee Conroy I','gdietrich@larkin.biz','0751680441','March Hare interrupted, yawning. \'I\'m getting tired of being upset, and their slates and pencils.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(167,41,'WH5TDA4XXUYW','Quinn Hamill','magali.hodkiewicz@yahoo.com','0956185328','IS the fun?\' said Alice. \'That\'s the first day,\' said the March Hare,) \'--it was at in all their.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(168,42,'TUXHUXXFMKY8','Ms. Cynthia Zemlak II','bbartell@hotmail.com','0659879245','I should think you could draw treacle out of sight, he said in a solemn tone, \'For the Duchess.',NULL,'reserved','2025-06-10 10:41:56','2025-06-10 10:41:56'),(169,42,'8K7RDU0ZCENX','Cayla Monahan','abbott.maryse@gmail.com','0966037660','Alice, \'they\'re sure to happen,\' she said to the puppy; whereupon the puppy began a series of.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(170,42,'BXUQID5TVNTY','Chyna Fahey','kattie75@dietrich.info','0411464560','Rabbit\'s--\'Pat! Pat! Where are you?\' And then a voice she had never been in a helpless sort of.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(171,42,'ANHSWTAWZFVH','Cora Blanda','zboyer@yahoo.com','0097652431','I\'m afraid, sir\' said Alice, feeling very curious to see you any more!\' And here poor Alice began.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(172,42,'WIBX02RWKRDT','Veda Lehner','rosenbaum.efren@stokes.net','0738677094','Gryphon said, in a mournful tone, \'he won\'t do a thing before, and behind it was the first.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(173,42,'Z4VS4EFDV558','Ezequiel Thompson','xmueller@yahoo.com','0122418046','Bill! the master says you\'re to go down--Here, Bill! the master says you\'re to go through next.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(174,43,'SNZHI5LPH3BO','Garry Aufderhar','lelah.larkin@gmail.com','0862704452','I\'ll get into her face, and was going to dive in among the distant green leaves. As there seemed.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(175,43,'KIAVWQ0TTKUK','Anastasia Ullrich','llewellyn.kovacek@yahoo.com','0916109379','I will just explain to you to sit down without being seen, when she noticed that they had been.',NULL,'pending','2025-06-10 10:41:56','2025-06-10 10:41:56'),(176,43,'3DLKYGQJWUMH','Elias Grant DDS','pearl98@hotmail.com','0517185299','I only wish they COULD! I\'m sure _I_ shan\'t be able! I shall ever see such a capital one for.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(177,43,'UME1B7TNYLQJ','Kyleigh Murray','megane43@bartoletti.com','0518278192','I should have liked teaching it tricks very much, if--if I\'d only been the whiting,\' said Alice.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(178,43,'NDWBPFEREPOB','Noemi Kuphal','mprohaska@dare.biz','0366956653','Alice, \'and why it is all the things I used to say.\' \'So he did, so he with his nose Trims his.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(179,44,'LFWQZB6NYKHN','Deondre Lockman II','nmcglynn@kertzmann.com','0888934981','March Hare and his buttons, and turns out his toes.\' [later editions continued as follows When the.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(180,44,'ET2EAE0EK21Q','Mallie Cremin PhD','mack.homenick@boehm.com','0204169249','KNOW IT TO BE TRUE--\" that\'s the queerest thing about it.\' \'She\'s in prison,\' the Queen had never.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(181,45,'TGTLNZEUA2MN','Jerel Sipes','yoshiko.gibson@hotmail.com','0368890429','Christmas.\' And she squeezed herself up and picking the daisies, when suddenly a footman in livery.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(182,45,'DCGZK92IQZE2','Roel Leannon IV','steuber.genevieve@gmail.com','0759630162','I THINK I can creep under the sea--\' (\'I haven\'t,\' said Alice)--\'and perhaps you were never even.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(183,45,'LSRMGRGOM3FV','Jaylen Schoen','uriel98@yahoo.com','0186767776','Mouse did not like to drop the jar for fear of killing somebody, so managed to put it into his.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(184,45,'Z1B0M1M9XSPX','Jamil Jacobson V','ugreenfelder@hotmail.com','0738613549','Rabbit in a minute or two sobs choked his voice. \'Same as if it had made. \'He took me for asking!.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(185,45,'JOV07RPZI4DX','Kenneth McLaughlin','craig37@block.org','0538753624','She did it at all. \'But perhaps he can\'t help it,\' she said aloud. \'I must go back by railway,\'.',NULL,'purchased','2025-06-10 10:41:56','2025-06-10 10:41:56'),(186,45,'YFXD4Z3NZSKI','Maverick Stanton','rgraham@gmail.com','0562967652','But, now that I\'m doubtful about the crumbs,\' said the Caterpillar. \'Not QUITE right, I\'m afraid,\'.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(187,46,'WLWRG0092P0M','Renee Ruecker IV','brenna.gorczany@funk.com','0231189626','Alice whispered to the Mock Turtle. \'Hold your tongue, Ma!\' said the King; and the pool of tears.',NULL,'reserved','2025-06-10 10:41:56','2025-06-10 10:41:56'),(188,46,'ZUTVLINZGJUR','Dion Heidenreich','tcruickshank@cassin.net','0662411481','There was a child,\' said the Caterpillar. \'Well, I\'ve tried hedges,\' the Pigeon in a louder tone.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(189,47,'MWW7RSDAEQXD','Jasen White','rogahn.birdie@wyman.com','0834377921','Her first idea was that it might tell her something worth hearing. For some minutes the whole she.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(190,47,'TPYTZNDP4ARA','Zula McKenzie','ondricka.missouri@gmail.com','0559294761','King, \'that saves a world of trouble, you know, as we were. My notion was that it was an old.',NULL,'checked_in','2025-06-10 10:41:56','2025-06-10 10:41:56'),(191,47,'JMXIVTLTDS0G','Terrance King','kutch.ryann@hilpert.com','0722876105','Never heard of \"Uglification,\"\' Alice ventured to remark. \'Tut, tut, child!\' said the King. (The.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(192,47,'YEFVXYUYL6N9','Mr. Boris Brekke MD','eduardo57@gorczany.biz','0074707668','Next came an angry voice--the Rabbit\'s--\'Pat! Pat! Where are you?\' And then a voice of the.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(193,47,'630S9QCP0MMW','Mrs. Genevieve Hilpert I','kuhlman.austin@keeling.biz','0451210560','Lobster Quadrille The Mock Turtle sighed deeply, and began, in a more subdued tone, and added \'It.',NULL,'cancelled','2025-06-10 10:41:56','2025-06-10 10:41:56'),(194,47,'IJMECOS5HEHO','Prof. Rick Boyle','cristina51@gmail.com','0169375503','Alice in a more subdued tone, and added with a teacup in one hand and a Dodo, a Lory and an.',NULL,'refunded','2025-06-10 10:41:56','2025-06-10 10:41:56'),(195,48,'1D5MTJ2BPEGX','Gerda Bednar IV','xwiegand@kessler.net','0024416909','Duck. \'Found IT,\' the Mouse was speaking, and this Alice would not join the dance? \"You can really.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(196,48,'DZ1XRKM1EBXQ','Mr. Sid Kuphal DVM','brando45@erdman.com','0595726533','March Hare. Alice was not a regular rule: you invented it just at first, but, after watching it a.',NULL,'pending','2025-06-10 10:41:57','2025-06-10 10:41:57'),(197,48,'5OALWJFOXGQJ','Halle Parker','lsanford@little.com','0351363780','As they walked off together, Alice heard it say to this: so she bore it as a last resource, she.',NULL,'cancelled','2025-06-10 10:41:57','2025-06-10 10:41:57'),(198,48,'MMDTWXDDQ69R','Ms. Fay Schimmel','hackett.pansy@moore.com','0502248144','Queen?\' said the Duchess, \'and that\'s the jury, who instantly made a snatch in the pool, \'and she.',NULL,'refunded','2025-06-10 10:41:57','2025-06-10 10:41:57'),(199,48,'UTEFSLQJM0AX','Malachi Kohler','clemens.thiel@hotmail.com','0404628293','Majesty!\' the Duchess was VERY ugly; and secondly, because they\'re making such a very curious.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(200,48,'CQUXHBPZ8M5W','Dr. Aniyah Rogahn Sr.','paxton41@kuhlman.com','0700024365','March Hare. \'It was the cat.) \'I hope they\'ll remember her saucer of milk at tea-time. Dinah my.',NULL,'pending','2025-06-10 10:41:57','2025-06-10 10:41:57'),(201,49,'CKBRTQ2J9T1H','Mitchell Welch','anastasia.will@hotmail.com','0529783781','At this moment the King, the Queen, who had meanwhile been examining the roses. \'Off with her.',NULL,'cancelled','2025-06-10 10:41:57','2025-06-10 10:41:57'),(202,49,'ZLWKCNAAVYKY','Abelardo Kunde','rgreenholt@gmail.com','0950203922','However, \'jury-men\' would have done that, you know,\' said Alice, \'because I\'m not particular as to.',NULL,'refunded','2025-06-10 10:41:57','2025-06-10 10:41:57'),(203,49,'GSG7KVK2G5YC','Marlee Stoltenberg DDS','mara.schiller@yahoo.com','0398475157','Alice said to the Mock Turtle said with a sigh. \'I only took the thimble, saying \'We beg your.',NULL,'refunded','2025-06-10 10:41:57','2025-06-10 10:41:57'),(204,49,'JKE8QSNCM1AQ','Ressie Quitzon','osinski.jorge@hotmail.com','0218644358','Cheshire Cat,\' said Alice: \'allow me to him: She gave me a good many little girls of her head was.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(205,49,'G9N8ZPYSAREY','Hazel Haag Sr.','sawayn.watson@hotmail.com','0341668013','Alice. \'What sort of chance of this, so she turned away. \'Come back!\' the Caterpillar sternly.',NULL,'reserved','2025-06-10 10:41:57','2025-06-10 10:41:57'),(206,50,'EOUMU7RNYGYU','Oda Herman Jr.','bertram66@purdy.com','0537464623','Alice, a little nervous about it just missed her. Alice caught the flamingo and brought it back.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(207,50,'FA96BPPLOZXB','Ed Welch MD','nhalvorson@hotmail.com','0699347897','At last the Mock Turtle, who looked at poor Alice, \'when one wasn\'t always growing larger and.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(208,50,'KFFYDSXMBGFA','Prof. Annamae Stracke','raynor.geovanny@gmail.com','0508253211','And the muscular strength, which it gave to my right size: the next moment a shower of little.',NULL,'refunded','2025-06-10 10:41:57','2025-06-10 10:41:57'),(209,50,'Q7XMQ1UTQ2U9','Dr. Axel Marks','tdamore@hotmail.com','0333200602','Now, if you like!\' the Duchess asked, with another hedgehog, which seemed to her that she might as.',NULL,'pending','2025-06-10 10:41:57','2025-06-10 10:41:57'),(210,50,'L2DKGELRAIDJ','Chelsey Moore','ylegros@shields.biz','0099017017','Then the Queen said to the Cheshire Cat sitting on a little scream, half of fright and half.',NULL,'transferred','2025-06-10 10:41:57','2025-06-10 10:41:57'),(211,50,'KTKQBEJSYYOX','Prof. Dorthy Koepp','rdonnelly@gmail.com','0179420914','Bill,\' thought Alice,) \'Well, I hardly know--No more, thank ye; I\'m better now--but I\'m a hatter.\'.',NULL,'checked_in','2025-06-10 10:41:57','2025-06-10 10:41:57');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:41:37','2025-06-10 10:41:37','Harum veritatis aut quod quia quam dolor eum. Minima qui et atque aut.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:41:37','2025-06-10 10:41:37','Quis non veniam excepturi labore sed. Beatae sequi voluptate commodi omnis alias.'),(3,'Event Experience',0,'published','2025-06-10 10:41:37','2025-06-10 10:41:37','Modi harum id tenetur est. Esse aut qui autem nostrum eum consectetur aspernatur.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:41:37','2025-06-10 10:41:37','Maiores eius error non dolorem. Fugit voluptas atque modi harum fugiat est.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Rerum eius vel doloribus cumque.','Aut consequatur dolor voluptatem et quibusdam eum est vel tempore illum est quisquam nisi cum nemo fugit dolore quia voluptatibus voluptatem nesciunt exercitationem non ullam modi id necessitatibus.',2,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(2,'Et ipsum similique et id modi.','Nostrum consequatur ut et dolorum nihil aut odio et ipsum rerum cum mollitia cum ut dolor exercitationem porro cupiditate dicta aperiam sit repudiandae eius suscipit inventore nostrum maxime qui tempora error provident maxime dicta rem sequi quia.',2,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(3,'Dicta aut numquam ut.','Nulla inventore ut rerum aut eos illum labore et modi aut commodi expedita quisquam eos possimus sunt cupiditate enim eos perferendis exercitationem ullam et omnis non velit in molestias vitae molestiae molestias quae.',3,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(4,'Asperiores in odio consectetur quia.','Placeat sunt aut nobis consequatur necessitatibus quod vitae dignissimos iusto rerum vitae qui quo aut qui aut laudantium eum modi molestias repudiandae sapiente nemo qui et et et sit iure nam.',1,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(5,'Eos occaecati incidunt cum corporis eius sunt.','Excepturi et facilis recusandae et commodi et rerum cupiditate atque minus qui hic molestiae molestias ipsam dolorem quis aut quia quia laudantium maxime blanditiis dignissimos consectetur sapiente dolorem ullam nisi sed incidunt blanditiis quis labore natus.',2,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(6,'Deleniti et laudantium incidunt.','Inventore reprehenderit dolorem fuga expedita maxime aut non porro quas id ut atque dolor nisi recusandae temporibus asperiores quam dignissimos atque aut.',4,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(7,'Ratione aut consequuntur magni eveniet.','Reiciendis omnis provident aut aliquam nam voluptatem voluptas adipisci facilis voluptatem cumque atque vel corrupti assumenda quia harum et voluptate libero laborum.',4,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(8,'Sed odio accusamus aperiam ad sed.','Ipsum asperiores incidunt maiores est nihil repellendus omnis voluptas eveniet iusto velit est incidunt saepe ratione rerum qui non ipsam unde aliquid quia reprehenderit vero sit eius sit tempora odit est et voluptatem et omnis magni voluptatum.',2,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(9,'Nemo ipsum vitae cupiditate.','A sit eos non ut accusamus quo minima at assumenda commodi sed earum et sit nihil quia et eligendi ad impedit et.',2,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(10,'Sequi laudantium necessitatibus autem qui modi recusandae.','Et aut tempora et eius maiores voluptas nesciunt minima ipsa voluptatibus expedita nisi cupiditate saepe deserunt maiores dignissimos ut ipsum aut incidunt aut velit incidunt occaecati hic sed doloremque.',1,'published','2025-06-10 10:41:37','2025-06-10 10:41:37'),(11,'Fugiat illum omnis impedit dolor.','Id sint sunt cum ea alias laborum non et pariatur nihil officia soluta rem magni accusamus non sed aut perferendis saepe sequi saepe pariatur magni eaque quod aut neque ipsum odio quia recusandae et numquam provident est accusamus earum sed.',1,'published','2025-06-10 10:41:37','2025-06-10 10:41:37');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Et fugit officia minima nihil. Quia ut velit sequi non repudiandae. Aut veniam ut nostrum. Et veniam maiores optio et.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(2,'Ocean Views','Nemo dolorem vero velit eligendi amet odio vero. Officiis error est quibusdam dolores. Aliquam tempore voluptate soluta.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(3,'Adventure Time','Quia nostrum omnis illum aliquid qui est. Sint beatae non et et impedit. Iusto quia incidunt unde temporibus.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(4,'City Lights','Sed necessitatibus doloremque non ut cumque dolorem molestiae. Dicta eos sunt ad ut hic ipsa officiis. Veritatis vero consequatur quaerat fuga.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(5,'Dreamscape','Rerum ut officia architecto in tempora autem. Et ut nemo sed sunt necessitatibus nulla error velit.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(6,'Enchanted Forest','Commodi laborum eos facere officia accusamus. Provident nemo tempora explicabo qui. Totam deleniti hic repudiandae aut exercitationem recusandae.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(7,'Golden Hour','Et suscipit quibusdam explicabo vel. Qui dolor nulla non accusantium sit fugiat. Hic qui quia dolore est fugiat quos eum.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(8,'Serenity','Blanditiis aut qui iusto omnis voluptas ea pariatur. Voluptatum assumenda quas maiores illum. Enim nesciunt enim nam est facere error.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(9,'Eternal Beauty','Illum corrupti quia dolorem aut sunt. Ipsam voluptatem vero cupiditate eveniet repellendus.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(10,'Moonlight Magic','Voluptas porro aut quod quibusdam et. Consequatur distinctio consectetur maiores voluptas laborum ab. In commodi et quia consectetur ut optio et aut.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(11,'Starry Night','Consectetur sunt ea sit eligendi autem quibusdam minima consequatur. Nihil voluptatibus non non nam. Ipsam magnam quam harum iste ex a.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:41:14','2025-06-10 10:41:14'),(12,'Hidden Gems','Similique expedita omnis minus ut quis. Earum non et totam dolorem rem et. Velit incidunt assumenda aliquid nisi non autem.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:41:15','2025-06-10 10:41:15'),(13,'Tranquil Waters','Sequi culpa vitae similique. Qui est autem consequatur illum expedita vitae. Illo sed fugiat maxime est.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:41:15','2025-06-10 10:41:15'),(14,'Urban Escape','Sit cum ut voluptas qui. Nemo eum aut odio laborum laboriosam. Dolor a nam aut quis.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:41:15','2025-06-10 10:41:15'),(15,'Twilight Zone','Omnis qui aut mollitia commodi est quaerat. Atque fuga et consectetur quis esse et dolorum. Aut at qui ratione magni.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:41:15','2025-06-10 10:41:15');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:14','2025-06-10 10:41:14'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:15','2025-06-10 10:41:15'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:15','2025-06-10 10:41:15'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:15','2025-06-10 10:41:15'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:15','2025-06-10 10:41:15'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Dicta deserunt alias delectus. Ut ea facere et harum saepe animi error. Qui fuga rerum reprehenderit nesciunt aspernatur veniam et.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Quos neque quibusdam ut velit. Enim voluptatem rerum quasi autem harum rerum sint. Quod nihil et aut eligendi repellendus.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Ratione laboriosam distinctio sunt nam et tempora sapiente. Vero culpa hic eos repellendus non.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Minima dolor unde laboriosam molestiae. Aspernatur aperiam corrupti quisquam vel quia. Velit sunt atque illum quae.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Doloremque sint ut alias eos laudantium. Sint rerum qui recusandae reprehenderit nemo illum. Odit necessitatibus id ducimus corporis voluptas in ex.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Expedita non rerum expedita voluptatem. Laborum autem animi mollitia esse delectus. Qui placeat rerum est ut quo.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Minima et corrupti iste enim non omnis ea sit. Aut nobis consequatur a eum.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Esse nisi libero modi iure voluptatibus laborum non dolores. Omnis sit deserunt tempora. Occaecati nisi qui molestiae minus.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Omnis voluptatum et aut commodi in et saepe. Quasi et et aut reprehenderit cupiditate. Ut consequatur corporis ut veritatis aut eum.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Consequatur nisi doloribus perspiciatis sed commodi debitis sit. Voluptates ut magni nobis aperiam ducimus in placeat.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Autem rerum dolorem suscipit at ut et. Dolorem cumque possimus laudantium ut rem. Dolor voluptatem ut debitis molestiae quasi ad ut autem.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"A ullam delectus qui sint ut minima delectus. Molestiae dolores expedita ab pariatur earum ullam quo. Incidunt qui voluptatem alias sequi.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Voluptatibus sed explicabo inventore sint possimus dolorum. Aut quis aliquam ut doloremque optio neque omnis. Dignissimos ipsam quia sed.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Quidem molestiae odit beatae voluptatem. Et sequi hic officia illo. Et sit aliquid impedit rerum aut labore. Adipisci recusandae at quis.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Velit sunt ut ea eos et et. A fuga non dolores perspiciatis. Consectetur quia aliquam facere aliquid non. Quidem inventore aut nisi similique rerum.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Eos sit aspernatur velit exercitationem. Eos minima eum excepturi dolores. Laudantium mollitia deserunt ex quaerat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Alias accusantium excepturi aut. Minima sed est exercitationem aspernatur nihil quis. Et autem est eius alias et accusamus.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sunt laborum eum adipisci dolores. Voluptatem mollitia ea ratione id voluptatem. Eius possimus ea fugit quisquam maxime dignissimos in.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Corrupti consequuntur repellendus aut voluptates atque qui. Nostrum veniam natus illum.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Rerum veniam ipsa pariatur ratione. Voluptatem nihil ut ratione nulla. Et dolore tenetur doloribus sit ad itaque quia.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:41:15','2025-06-10 10:41:15');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','367d5dc349f76b3bb8a1f3ce101e67fa',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','0527442aed8276dd7bc3e1a2dc8413a2',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','ea5b021f3fdf97748614cc93ed8243b4',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=169 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (12,0,'contact-img','contact-img',4,'image/png',4828,'homepage04/general/contact-img.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(13,0,'contact-img2','contact-img2',4,'image/png',5087,'homepage04/general/contact-img2.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(14,0,'event-img1','event-img1',4,'image/png',10506,'homepage04/general/event-img1.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(15,0,'hero-img4','hero-img4',4,'image/png',8872,'homepage04/general/hero-img4.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(16,0,'image-1','image-1',4,'image/png',14690,'homepage04/general/image-1.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(17,0,'image-2','image-2',4,'image/png',4665,'homepage04/general/image-2.png','[]','2025-06-10 10:41:06','2025-06-10 10:41:06',NULL,'public'),(18,0,'image-3','image-3',4,'image/png',30044,'homepage04/general/image-3.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(19,0,'logo','logo',4,'image/png',1811,'homepage04/general/logo.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(20,0,'logo2','logo2',4,'image/png',238,'homepage04/general/logo2.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(21,0,'check','check',5,'image/png',15429,'homepage04/icons/check.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(22,0,'location','location',5,'image/png',22189,'homepage04/icons/location.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(23,0,'mail','mail',5,'image/png',37117,'homepage04/icons/mail.png','[]','2025-06-10 10:41:07','2025-06-10 10:41:07',NULL,'public'),(24,0,'countdown-bg','countdown-bg',6,'image/png',3047,'homepage04/backgrounds/countdown-bg.png','[]','2025-06-10 10:41:08','2025-06-10 10:41:08',NULL,'public'),(45,0,'1','1',8,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:41:15','2025-06-10 10:41:15',NULL,'public'),(46,0,'2','2',8,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:41:15','2025-06-10 10:41:15',NULL,'public'),(47,0,'3','3',8,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:41:15','2025-06-10 10:41:15',NULL,'public'),(48,0,'4','4',8,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:41:15','2025-06-10 10:41:15',NULL,'public'),(49,0,'brand-img1','brand-img1',9,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(50,0,'brand-img2','brand-img2',9,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(51,0,'brand-img3','brand-img3',9,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(52,0,'brand-img4','brand-img4',9,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(53,0,'brand-img5','brand-img5',9,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(54,0,'brand-img6','brand-img6',9,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(55,0,'brand-img7','brand-img7',9,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:41:16','2025-06-10 10:41:16',NULL,'public'),(56,0,'brand-img8','brand-img8',9,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:41:17','2025-06-10 10:41:17',NULL,'public'),(57,0,'1','1',10,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:41:17','2025-06-10 10:41:17',NULL,'public'),(58,0,'2','2',10,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:41:17','2025-06-10 10:41:17',NULL,'public'),(59,0,'header-bg4','header-bg4',10,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:41:17','2025-06-10 10:41:17',NULL,'public'),(60,0,'hero-banner-bg','hero-banner-bg',10,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:41:18','2025-06-10 10:41:18',NULL,'public'),(61,0,'image-1','image-1',10,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:41:19','2025-06-10 10:41:19',NULL,'public'),(62,0,'newsletter-bg','newsletter-bg',10,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:41:20','2025-06-10 10:41:20',NULL,'public'),(63,0,'pricing-name','pricing-name',10,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:41:20','2025-06-10 10:41:20',NULL,'public'),(64,0,'speakers-bg','speakers-bg',10,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:41:20','2025-06-10 10:41:20',NULL,'public'),(65,0,'balloons','balloons',11,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(66,0,'calendar','calendar',11,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(67,0,'clock','clock',11,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(68,0,'coding','coding',11,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(69,0,'idea','idea',11,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(70,0,'instagram-icon','instagram-icon',11,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(71,0,'location-icon','location-icon',11,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:41:21','2025-06-10 10:41:21',NULL,'public'),(72,0,'location','location',11,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(73,0,'mail-icon','mail-icon',11,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(74,0,'menu','menu',11,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(75,0,'microphone','microphone',11,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(76,0,'phone-icon','phone-icon',11,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(77,0,'search','search',11,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:41:22','2025-06-10 10:41:22',NULL,'public'),(78,0,'speaker','speaker',11,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(79,0,'ticket','ticket',11,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(80,0,'user','user',11,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(81,0,'view','view',11,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(82,0,'workshop','workshop',11,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(83,0,'1','1',7,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:41:23','2025-06-10 10:41:23',NULL,'public'),(84,0,'10','10',7,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:41:24','2025-06-10 10:41:24',NULL,'public'),(85,0,'11','11',7,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:41:24','2025-06-10 10:41:24',NULL,'public'),(86,0,'12','12',7,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:41:24','2025-06-10 10:41:24',NULL,'public'),(87,0,'13','13',7,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:41:25','2025-06-10 10:41:25',NULL,'public'),(88,0,'14','14',7,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:41:25','2025-06-10 10:41:25',NULL,'public'),(89,0,'15','15',7,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:41:25','2025-06-10 10:41:25',NULL,'public'),(90,0,'16','16',7,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:41:26','2025-06-10 10:41:26',NULL,'public'),(91,0,'17','17',7,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:41:26','2025-06-10 10:41:26',NULL,'public'),(92,0,'18','18',7,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:41:26','2025-06-10 10:41:26',NULL,'public'),(93,0,'19','19',7,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:41:27','2025-06-10 10:41:27',NULL,'public'),(94,0,'2','2',7,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:41:27','2025-06-10 10:41:27',NULL,'public'),(95,0,'20','20',7,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:41:27','2025-06-10 10:41:27',NULL,'public'),(96,0,'3','3',7,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:41:27','2025-06-10 10:41:27',NULL,'public'),(97,0,'4','4',7,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:41:28','2025-06-10 10:41:28',NULL,'public'),(98,0,'5','5',7,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:41:28','2025-06-10 10:41:28',NULL,'public'),(99,0,'6','6',7,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:41:28','2025-06-10 10:41:28',NULL,'public'),(100,0,'7','7',7,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:41:29','2025-06-10 10:41:29',NULL,'public'),(101,0,'8','8',7,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:41:29','2025-06-10 10:41:29',NULL,'public'),(102,0,'9','9',7,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:41:29','2025-06-10 10:41:29',NULL,'public'),(103,0,'1','1',12,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:41:30','2025-06-10 10:41:30',NULL,'public'),(104,0,'10','10',12,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:41:30','2025-06-10 10:41:30',NULL,'public'),(105,0,'11','11',12,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:41:30','2025-06-10 10:41:30',NULL,'public'),(106,0,'12','12',12,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:41:31','2025-06-10 10:41:31',NULL,'public'),(107,0,'13','13',12,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:41:31','2025-06-10 10:41:31',NULL,'public'),(108,0,'14','14',12,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:41:31','2025-06-10 10:41:31',NULL,'public'),(109,0,'15','15',12,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:41:32','2025-06-10 10:41:32',NULL,'public'),(110,0,'16','16',12,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:41:32','2025-06-10 10:41:32',NULL,'public'),(111,0,'17','17',12,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:41:32','2025-06-10 10:41:32',NULL,'public'),(112,0,'18','18',12,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:41:33','2025-06-10 10:41:33',NULL,'public'),(113,0,'19','19',12,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:41:33','2025-06-10 10:41:33',NULL,'public'),(114,0,'2','2',12,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:41:33','2025-06-10 10:41:33',NULL,'public'),(115,0,'20','20',12,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:41:34','2025-06-10 10:41:34',NULL,'public'),(116,0,'3','3',12,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:41:34','2025-06-10 10:41:34',NULL,'public'),(117,0,'4','4',12,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:41:34','2025-06-10 10:41:34',NULL,'public'),(118,0,'5','5',12,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:41:35','2025-06-10 10:41:35',NULL,'public'),(119,0,'6','6',12,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:41:35','2025-06-10 10:41:35',NULL,'public'),(120,0,'7','7',12,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:41:35','2025-06-10 10:41:35',NULL,'public'),(121,0,'8','8',12,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:41:35','2025-06-10 10:41:35',NULL,'public'),(122,0,'9','9',12,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:41:36','2025-06-10 10:41:36',NULL,'public'),(123,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(124,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(125,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(126,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(127,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(128,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:41:37','2025-06-10 10:41:37',NULL,'public'),(129,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(130,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(131,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(132,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(133,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(134,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:41:38','2025-06-10 10:41:38',NULL,'public'),(135,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(136,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(137,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(138,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(139,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(140,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:41:39','2025-06-10 10:41:39',NULL,'public'),(141,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:41:40','2025-06-10 10:41:40',NULL,'public'),(142,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:41:40','2025-06-10 10:41:40',NULL,'public'),(143,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:41:40','2025-06-10 10:41:40',NULL,'public'),(144,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:41:40','2025-06-10 10:41:40',NULL,'public'),(145,0,'0','0',14,'image/webp',33268,'main/events/0-1749552106.webp','[]','2025-06-10 10:41:46','2025-06-10 10:41:46',NULL,'public'),(146,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:41:46','2025-06-10 10:41:46',NULL,'public'),(147,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:41:47','2025-06-10 10:41:47',NULL,'public'),(148,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:41:47','2025-06-10 10:41:47',NULL,'public'),(149,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:41:47','2025-06-10 10:41:47',NULL,'public'),(150,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:41:48','2025-06-10 10:41:48',NULL,'public'),(151,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:41:48','2025-06-10 10:41:48',NULL,'public'),(152,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:41:48','2025-06-10 10:41:48',NULL,'public'),(153,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:41:49','2025-06-10 10:41:49',NULL,'public'),(154,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:41:49','2025-06-10 10:41:49',NULL,'public'),(155,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:41:49','2025-06-10 10:41:49',NULL,'public'),(156,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:41:50','2025-06-10 10:41:50',NULL,'public'),(157,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:41:50','2025-06-10 10:41:50',NULL,'public'),(158,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:41:50','2025-06-10 10:41:50',NULL,'public'),(159,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:41:50','2025-06-10 10:41:50',NULL,'public'),(160,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:41:51','2025-06-10 10:41:51',NULL,'public'),(161,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:41:51','2025-06-10 10:41:51',NULL,'public'),(162,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:41:51','2025-06-10 10:41:51',NULL,'public'),(163,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:41:52','2025-06-10 10:41:52',NULL,'public'),(164,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:41:52','2025-06-10 10:41:52',NULL,'public'),(165,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:41:52','2025-06-10 10:41:52',NULL,'public'),(166,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:42:03','2025-06-10 10:42:03',NULL,'public'),(167,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:42:03','2025-06-10 10:42:03',NULL,'public'),(168,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:42:03','2025-06-10 10:42:03',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:41:04','2025-06-10 10:41:04',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:41:04','2025-06-10 10:41:04',NULL),(3,0,'homepage04',NULL,'homepage04',0,'2025-06-10 10:41:06','2025-06-10 10:41:06',NULL),(4,0,'general',NULL,'general',3,'2025-06-10 10:41:06','2025-06-10 10:41:06',NULL),(5,0,'icons',NULL,'icons',3,'2025-06-10 10:41:07','2025-06-10 10:41:07',NULL),(6,0,'backgrounds',NULL,'backgrounds',3,'2025-06-10 10:41:08','2025-06-10 10:41:08',NULL),(7,0,'news',NULL,'news',1,'2025-06-10 10:41:08','2025-06-10 10:41:08',NULL),(8,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:41:15','2025-06-10 10:41:15',NULL),(9,0,'brands',NULL,'brands',1,'2025-06-10 10:41:16','2025-06-10 10:41:16',NULL),(10,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:41:17','2025-06-10 10:41:17',NULL),(11,0,'icons',NULL,'icons',1,'2025-06-10 10:41:21','2025-06-10 10:41:21',NULL),(12,0,'blogs',NULL,'blogs',1,'2025-06-10 10:41:30','2025-06-10 10:41:30',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:41:38','2025-06-10 10:41:38',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:41:46','2025-06-10 10:41:46',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:42:03','2025-06-10 10:42:03',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:42:02','2025-06-10 10:42:02');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:42:02','2025-06-10 10:42:02'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:42:03','2025-06-10 10:42:03');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:42:02','2025-06-10 10:42:02');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:41:16','2025-06-10 10:41:16'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:41:16','2025-06-10 10:41:16'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:41:16','2025-06-10 10:41:16'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:41:16','2025-06-10 10:41:16'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:41:30','2025-06-10 10:41:30'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:41:30','2025-06-10 10:41:30'),(7,'title','[\"UX\\/UI Designer\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:40','2025-06-10 10:41:40'),(8,'description','[\"Alice went on, without attending to her, And mentioned me to him: She gave me a good deal to come once a week: HE taught us Drawling, Stretching, and Fainting in Coils.\' \'What was THAT like?\' said.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:40','2025-06-10 10:41:40'),(9,'address','[\"61152 Gottlieb Forge\\nRicardoland, AL 77380-7978\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:40','2025-06-10 10:41:40'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:40','2025-06-10 10:41:40'),(11,'title','[\"Fullstack Developer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(12,'description','[\"The long grass rustled at her feet in a hoarse growl, \'the world would go through,\' thought poor Alice, who was passing at the Queen, \'and he shall tell you how the game began. Alice gave a little.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(13,'address','[\"13043 Camden Green\\nBrielleberg, ID 39080\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(15,'title','[\"Project Manager\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(16,'description','[\"I should think it would all wash off in the distance, sitting sad and lonely on a little glass table. \'Now, I\'ll manage better this time,\' she said, by way of expecting nothing but a pack of cards.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(17,'address','[\"3137 Batz Glen Suite 754\\nKieranfurt, KY 34202\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(19,'title','[\"System Administrator\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(20,'description','[\"Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never thought about it,\' added the Dormouse, who was reading the list of singers. \'You may not have lived much under the window.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(21,'address','[\"2273 Wolff Square\\nJocelynport, CO 48728-3516\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(23,'title','[\"UX\\/UI Designer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(24,'description','[\"So she began shrinking directly. As soon as there was the first witness,\' said the one who had got burnt, and eaten up by two guinea-pigs, who were lying on the bank--the birds with draggled.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(25,'address','[\"464 Grant Valley Suite 787\\nWest Stanfordton, WY 83126\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(27,'title','[\"Quality Assurance\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(28,'description','[\"Hatter. \'Nor I,\' said the King triumphantly, pointing to the Caterpillar, just as the rest were quite dry again, the Dodo replied very solemnly. Alice was so small as this before, never! And I.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(29,'address','[\"5116 Kutch Ville\\nWest Shanel, WA 35092-0980\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:41','2025-06-10 10:41:41'),(31,'title','[\"System Administrator\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(32,'description','[\"Down, down, down. There was nothing on it but tea. \'I don\'t see how he did it,) he did it,) he did with the birds and animals that had slipped in like herself. \'Would it be of any good reason, and.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(33,'address','[\"195 Stanton Crossroad Suite 705\\nPurdyport, ME 55221\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(35,'title','[\"Backend Developer\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(36,'description','[\"King said to herself, \'I don\'t know what \\\"it\\\" means.\' \'I know what to uglify is, you ARE a simpleton.\' Alice did not wish to offend the Dormouse again, so violently, that she ought not to make.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(37,'address','[\"845 Maritza Cliffs\\nLake Rylanmouth, NJ 73518-4004\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(39,'title','[\"Quality Assurance\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(40,'description','[\"Soup! Soup of the game, the Queen said severely \'Who is it twelve? I--\' \'Oh, don\'t bother ME,\' said the Gryphon. \'They can\'t have anything to say, she simply bowed, and took the hookah out of his.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(41,'address','[\"72673 Odessa Greens\\nBeattystad, AR 13657-8198\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(43,'title','[\"Product Manager\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(44,'description','[\"This seemed to have changed since her swim in the middle of her voice. Nobody moved. \'Who cares for you?\' said Alice, very earnestly. \'I\'ve had nothing else to do, and perhaps as this is May it.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(45,'address','[\"9525 Linwood Brooks\\nJaredmouth, OK 60296-1843\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(47,'title','[\"System Administrator\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(48,'description','[\"I needn\'t be so stingy about it, you may stand down,\' continued the Gryphon. \'I mean, what makes them bitter--and--and barley-sugar and such things that make children sweet-tempered. I only knew how.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(49,'address','[\"4964 Friesen Mission Apt. 430\\nMadisenton, MN 55349-6060\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(51,'title','[\"Product Manager\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(52,'description','[\"She went in search of her own children. \'How should I know?\' said Alice, rather alarmed at the sides of it; and while she ran, as well she might, what a wonderful dream it had finished this short.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(53,'address','[\"664 Renner Fall Apt. 406\\nPort Davetown, AZ 89015\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:42','2025-06-10 10:41:42'),(55,'title','[\"System Administrator\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(56,'description','[\"At last the Dodo had paused as if nothing had happened. \'How am I to get us dry would be the best thing to eat or drink anything; so I\'ll just see what was the fan and the Hatter with a shiver. \'I.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(57,'address','[\"7897 Gleason Stream Apt. 012\\nAmelietown, OK 14339-0936\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(59,'title','[\"Backend Developer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(60,'description','[\"EVER happen in a very curious to know what they\'re like.\' \'I believe so,\' Alice replied eagerly, for she could not help bursting out laughing: and when Alice had no idea what Latitude or Longitude.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(61,'address','[\"9593 Kuhn Island\\nNorth Karianneberg, NE 32902-7927\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(63,'title','[\"Fullstack Developer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(64,'description','[\"Duchess, \'as pigs have to go on for some way, and then quietly marched off after the rest of it in less than a pig, my dear,\' said Alice, feeling very glad to find quite a chorus of \'There goes.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(65,'address','[\"48039 Fadel Canyon\\nBruenshire, NJ 18394-7336\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(67,'title','[\"Frontend Developer\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(68,'description','[\"Alice, surprised at this, she looked down into its mouth and yawned once or twice she had forgotten the Duchess was VERY ugly; and secondly, because she was small enough to get dry very soon.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(69,'address','[\"8334 Lessie Flats Apt. 470\\nBradtkestad, AR 48603\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(71,'title','[\"Quality Assurance\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(72,'description','[\"Cat. \'I\'d nearly forgotten that I\'ve got to the conclusion that it would be very likely true.) Down, down, down. Would the fall NEVER come to the other: the only one way up as the doubled-up.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(73,'address','[\"676 Meagan Village\\nAlfredobury, AR 30273\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:43','2025-06-10 10:41:43'),(75,'title','[\"UX\\/UI Designer\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(76,'description','[\"Even the Duchess said in an agony of terror. \'Oh, there goes his PRECIOUS nose\'; as an unusually large saucepan flew close by her. There was a queer-shaped little creature, and held it out into the.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(77,'address','[\"146 Glenna Hill\\nNew Pamela, AL 93914-0845\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(79,'title','[\"Quality Assurance\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(80,'description','[\"Hatter. \'Nor I,\' said the Hatter. Alice felt a little three-legged table, all made a memorandum of the lefthand bit of the words have got into the loveliest garden you ever see you any more!\' And.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(81,'address','[\"966 Lon Crescent Suite 037\\nRahsaanshire, OH 42042\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(83,'title','[\"System Administrator\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(84,'description','[\"Even the Duchess was sitting on a three-legged stool in the direction in which you usually see Shakespeare, in the face. \'I\'ll put a white one in by mistake; and if the Mock Turtle went on so long.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(85,'address','[\"109 Homenick Row Suite 902\\nEast Genovevaland, KS 55547-9264\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(87,'title','[\"Product Manager\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(88,'description','[\"MINE,\' said the Dormouse; \'--well in.\' This answer so confused poor Alice, who always took a great hurry. \'You did!\' said the Hatter; \'so I can\'t show it you myself,\' the Mock Turtle Soup is made.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(89,'address','[\"726 Frami Lodge\\nSwaniawskiberg, SC 49226\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(91,'title','[\"Product Manager\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(92,'description','[\"Dormouse; \'VERY ill.\' Alice tried to get an opportunity of adding, \'You\'re looking for eggs, as it happens; and if the Queen said--\' \'Get to your places!\' shouted the Queen. \'You make me smaller, I.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(93,'address','[\"921 Josiah Isle\\nSouth Shaneview, MN 25693\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(95,'title','[\"Product Manager\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(96,'description','[\"Alice said; but was dreadfully puzzled by the time he was in livery: otherwise, judging by his garden.\\\"\' Alice did not see anything that looked like the name: however, it only grinned when it saw.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(97,'address','[\"271 Allen Pine\\nOctaviatown, MS 37810\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:44','2025-06-10 10:41:44'),(99,'title','[\"Quality Assurance\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(100,'description','[\"Alice thought to herself, and once again the tiny hands were clasped upon her arm, and timidly said \'Consider, my dear: she is such a long hookah, and taking not the same, shedding gallons of tears.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(101,'address','[\"92866 Antonia Trace\\nLake Stanford, GA 06212\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(103,'title','[\"Product Manager\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(104,'description','[\"Alice. \'Come on, then!\' roared the Queen, tossing her head to hide a smile: some of the evening, beautiful Soup! \'Beautiful Soup! Who cares for fish, Game, or any other dish? Who would not join the.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(105,'address','[\"195 Darwin Rue\\nNorth Kobyland, AR 62659\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(107,'title','[\"Product Manager\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(108,'description','[\"However, everything is to-day! And yesterday things went on muttering over the fire, and at last she spread out her hand, and a fan! Quick, now!\' And Alice was beginning to write with one eye; \'I.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(109,'address','[\"58301 Gina Junctions\\nReillyberg, CT 33859-6906\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(111,'title','[\"UX\\/UI Designer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(112,'description','[\"The Queen smiled and passed on. \'Who ARE you doing out here? Run home this moment, I tell you!\' said Alice. \'Then you should say \\\"With what porpoise?\\\"\' \'Don\'t you mean by that?\' said the Duchess, it.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(113,'address','[\"792 Zachariah Plaza Suite 883\\nEast Brayan, OR 88050-0997\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(115,'title','[\"Product Manager\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(116,'description','[\"For some minutes it puffed away without speaking, but at the mushroom (she had grown up,\' she said to herself, in a tone of the Lizard\'s slate-pencil, and the little golden key in the flurry of the.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(117,'address','[\"646 Stanford Spur Suite 020\\nKennithland, CA 61906-3602\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(119,'title','[\"DevOps Engineer\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(120,'description','[\"Down, down, down. There was a queer-shaped little creature, and held it out into the loveliest garden you ever saw. How she longed to change the subject. \'Ten hours the first question, you know.\'.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(121,'address','[\"38163 Chanelle Ranch Suite 193\\nPort Else, AL 19148\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:45','2025-06-10 10:41:45'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(123,'title','[\"Frontend Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(124,'description','[\"There\'s no pleasing them!\' Alice was not easy to take the place of the shepherd boy--and the sneeze of the others looked round also, and all must have been that,\' said the Hatter. Alice felt so.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(125,'address','[\"48095 Medhurst Expressway Apt. 531\\nHattietown, AK 77697-8936\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(127,'title','[\"Project Manager\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(128,'description','[\"CHAPTER VIII. The Queen\'s Croquet-Ground A large rose-tree stood near the house opened, and a sad tale!\' said the King, the Queen, who was passing at the Queen, but she gained courage as she could.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(129,'address','[\"26431 Meghan Locks\\nDorisborough, NV 26434-6371\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:41:46','2025-06-10 10:41:46'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(134,'event_id','[10]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(138,'event_id','[9]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04'),(142,'event_id','[9]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:42:04','2025-06-10 10:42:04');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner subtitle=&quot;Lead Purpose, Innovate with Passion&quot; title=&quot;Elevate 2025 &lt;br&gt; Leading with &lt;br&gt; the Purpose&quot; description=&quot;Welcome to Innovate 2024: Shaping the Future of Business, where industry leaders, innovators.&quot; button_primary_label=&quot;Reserve my Seat&quot; button_primary_url=&quot;/events&quot; subtitle_image=&quot;homepage04/general/logo2.png&quot; image=&quot;homepage04/general/hero-img4.png&quot; style=&quot;3&quot;][/hero-banner][countdown start_date=&quot;2026-01-09&quot; background_image=&quot;homepage04/backgrounds/countdown-bg.png&quot; style=&quot;2&quot; title=&quot;Yearly Business Conferences &ldquo;2025&rdquo;&quot;][/countdown][about-us-information style=&quot;5&quot; title=&quot;Innovating for Tomorrow Insights for Business&quot; subtitle=&quot;about our business conferences&quot; description=&quot;Perfectly captures the essence of what this blog aims to deliver. In a rapidly evolving business landscape, leaders must stay.&quot; quantity=&quot;3&quot; title_1=&quot;Director of the Developing Communities&quot; title_2=&quot;Deputy Attorney General Media Project&quot; title_3=&quot;Law School and Civil Rights Attorney&quot; icon_image_1=&quot;homepage04/icons/check.png&quot; icon_image_2=&quot;homepage04/icons/check.png&quot; icon_image_3=&quot;homepage04/icons/check.png&quot; image=&quot;homepage04/general/image-1.png&quot; image_1=&quot;homepage04/general/image-2.png&quot; image_2=&quot;homepage04/general/image-3.png&quot; button_label=&quot;Reserve my Seat&quot; button_url=&quot;/events&quot;][/about-us-information][events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;4&quot; number_each_days=&quot;5&quot; style=&quot;3&quot; image=&quot;homepage04/general/event-img1.png&quot;][/events-schedule][events title=&quot;Recent Memories 2025&quot; subtitle=&quot;last year memory&quot; limit=&quot;5&quot; style=&quot;4&quot;][/events][testimonials title=&quot;Feedback from Innovate 2024&quot; subtitle=&quot;testimonial&quot; testimonial_ids=&quot;1,2&quot; style=&quot;2&quot;][/testimonials][speakers title=&quot;Business Breakthrough Team&quot; subtitle=&quot;our 10+ event speakers&quot; limit=&quot;8&quot; style=&quot;4&quot;][/speakers][contact-information title=&quot;Connect with Our Team&quot; subtitle=&quot;How to reach&quot; style=&quot;3&quot; description=&quot;We&rsquo;re here to help! you have any questions about Innovate 2024, need assistance with registration, or want to learn more about.&quot; address=&quot;Viet Nam&quot; image=&quot;homepage04/general/contact-img.png&quot; image_2=&quot;homepage04/general/contact-img2.png&quot; quantity=&quot;2&quot; title_1=&quot;Our Email&quot; description_1=&quot;mailto:eventify@gmail.com&quot; icon_image_1=&quot;homepage04/icons/mail.png&quot; title_2=&quot;Our Phone Number&quot; description_2=&quot;0123456789&quot; icon_image_2=&quot;homepage04/icons/location.png&quot;][/contact-information][blog-posts title=&quot;Balancing Profit &amp; Purpose&quot; subtitle=&quot;News &amp; updates&quot; category_ids=&quot;3,5&quot; type=&quot;latest&quot; limit=&quot;3&quot; style=&quot;2&quot;][/blog-posts]',1,NULL,'homepage',NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:41:30','2025-06-10 10:41:30');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'7T7EZZTNOGTL','bank_transfer',NULL,399.96,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(2,'1',0,'YO3SPT7X5XJU','bank_transfer',NULL,299.97,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(3,'1',0,'OUO24ILX9OMV','bank_transfer',NULL,499.95,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(4,'1',0,'BKHUDBFQY4EK','bank_transfer',NULL,399.96,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(5,'1',0,'RTYAOIVZX9IE','bank_transfer',NULL,199.98,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(6,'1',0,'4SUFYUBZLXVN','bank_transfer',NULL,199.98,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(7,'1',0,'PJLD1NQ50AFC','bank_transfer',NULL,99.99,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(8,'1',0,'UUACS9K7GHQQ','bank_transfer',NULL,499.95,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:53','2025-06-10 10:41:53',NULL,NULL),(9,'1',0,'PAFZGBEHPC9F','bank_transfer',NULL,99.99,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(10,'1',0,'YGTZPAVJXXWY','bank_transfer',NULL,499.95,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(11,'1',0,'ROLLAOB1NYCA','bank_transfer',NULL,158.40,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(12,'1',0,'ZPJL1GT9W0IH','bank_transfer',NULL,95.04,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(13,'1',0,'LWBRX13UBV2N','bank_transfer',NULL,126.72,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(14,'1',0,'FAUCQBH4ZBRM','bank_transfer',NULL,63.36,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(15,'1',0,'JIDGJ5WRJYU5','bank_transfer',NULL,158.40,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(16,'1',0,'ULPD33HWD3ZA','bank_transfer',NULL,95.04,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(17,'1',0,'RRC8KFWVXMIL','bank_transfer',NULL,95.04,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(18,'1',0,'CAZEP75XS1BS','bank_transfer',NULL,158.40,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(19,'1',0,'7P0AFBJLM88P','bank_transfer',NULL,126.72,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(20,'1',0,'UCFOYCL2J9TU','bank_transfer',NULL,31.68,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(21,'1',0,'6KDVEJHR7CYG','bank_transfer',NULL,173.60,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:54','2025-06-10 10:41:54',NULL,NULL),(22,'1',0,'FIXSW7H8GOR1','bank_transfer',NULL,347.20,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(23,'1',0,'73AHVPIFZFS4','bank_transfer',NULL,347.20,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(24,'1',0,'RIOBXT30BXZG','bank_transfer',NULL,347.20,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(25,'1',0,'XF6NBJ8MX5WK','bank_transfer',NULL,260.40,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(26,'1',0,'VQGLLOANCKCJ','bank_transfer',NULL,347.20,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(27,'1',0,'YEFJLJ1Q0PUJ','bank_transfer',NULL,347.20,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(28,'1',0,'XAZB4HQ2MDGO','bank_transfer',NULL,86.80,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(29,'1',0,'ABXJFAMVGUR8','bank_transfer',NULL,347.20,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(30,'1',0,'OYOUTP94SCSD','bank_transfer',NULL,434.00,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(31,'1',0,'G53II7IAA1TR','bank_transfer',NULL,168.62,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(32,'1',0,'6VUU1EZRXU1E','bank_transfer',NULL,168.62,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(33,'1',0,'R4XZFUS7W0QE','bank_transfer',NULL,84.31,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:55','2025-06-10 10:41:55',NULL,NULL),(34,'1',0,'UOKPA1QETNAT','bank_transfer',NULL,168.62,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(35,'1',0,'FFYIKQXIL1JT','bank_transfer',NULL,252.93,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(36,'1',0,'RLOOMPID4MMF','bank_transfer',NULL,252.93,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(37,'1',0,'CSC0GOENBSWM','bank_transfer',NULL,168.62,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(38,'1',0,'JI7B1SNUKCCQ','bank_transfer',NULL,168.62,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(39,'1',0,'PA7HJS4PAII6','bank_transfer',NULL,337.24,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(40,'1',0,'07UOMAVO7LNG','bank_transfer',NULL,84.31,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(41,'1',0,'OVDSZJIA7VTE','bank_transfer',NULL,158.10,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(42,'1',0,'AZIYLIGFITJB','bank_transfer',NULL,395.25,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(43,'1',0,'KKMXFBHMV02L','bank_transfer',NULL,316.20,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(44,'1',0,'JAVLZ9FESWD8','bank_transfer',NULL,79.05,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(45,'1',0,'ZLZT9H8C1OW6','bank_transfer',NULL,395.25,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(46,'1',0,'YPCD7DHPMTGK','bank_transfer',NULL,79.05,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(47,'1',0,'WTO8IE9MIZ5X','bank_transfer',NULL,395.25,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:56','2025-06-10 10:41:56',NULL,NULL),(48,'1',0,'V3BWR2VHU3DP','bank_transfer',NULL,395.25,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57',NULL,NULL),(49,'1',0,'KBVZ9KOND73Q','bank_transfer',NULL,316.20,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57',NULL,NULL),(50,'1',0,'CRDK4YZHGPAD','bank_transfer',NULL,395.25,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:41:57','2025-06-10 10:41:57',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (4,1),(1,1),(5,2),(6,3),(2,3),(5,4),(6,4),(1,5),(4,5),(1,6),(4,6),(1,7),(6,7),(4,8),(3,8),(2,9),(6,9),(6,10),(2,10),(3,11),(1,11),(4,12),(1,12),(2,13),(5,13),(3,14),(4,14),(5,15),(1,15),(5,16),(6,16),(5,17),(6,17),(3,18),(4,18),(6,19),(2,19),(4,20),(2,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (2,1),(6,1),(5,1),(4,2),(2,2),(5,2),(4,3),(7,3),(6,3),(5,4),(3,4),(2,4),(1,5),(7,5),(4,5),(7,6),(4,6),(1,7),(5,7),(2,7),(5,8),(3,8),(5,9),(6,9),(7,9),(5,10),(6,10),(3,11),(5,11),(6,11),(6,12),(7,12),(4,13),(1,13),(2,14),(7,14),(1,14),(7,15),(2,15),(3,15),(4,16),(3,16),(7,16),(1,17),(6,17),(3,17),(2,18),(4,18),(5,19),(7,19),(3,20),(7,20),(2,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1673,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',554,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',1549,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',609,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',2439,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',1860,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',948,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1888,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',673,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',798,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',2177,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',293,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',2498,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1252,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',848,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',2265,NULL,'2025-06-10 10:41:36','2025-06-10 10:41:36'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',1590,NULL,'2025-06-10 10:41:37','2025-06-10 10:41:37'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',1728,NULL,'2025-06-10 10:41:37','2025-06-10 10:41:37'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',393,NULL,'2025-06-10 10:41:37','2025-06-10 10:41:37'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/10.jpg\" image_2=\"main/blogs/2.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',2368,NULL,'2025-06-10 10:41:37','2025-06-10 10:41:37');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:41:15','2025-06-10 10:41:15');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=89 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:42:04'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:42:04'),(6,'language_hide_default','1',NULL,'2025-06-10 10:42:04'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:42:04'),(8,'language_display','all',NULL,'2025-06-10 10:42:04'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:42:04'),(10,'media_random_hash','6a429dd578e45328b646504a275a5203',NULL,'2025-06-10 10:42:04'),(11,'theme','eventify-homepage04',NULL,'2025-06-10 10:42:04'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:42:04'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:42:04'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:42:04'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:42:04'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:42:04'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:42:04'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:42:04'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:42:04'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:42:04'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:42:04'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:42:04'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:42:04'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:42:04'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:42:04'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:42:04'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:42:04'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:42:04'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:42:04'),(30,'theme-eventify-homepage04-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:42:04'),(31,'theme-eventify-homepage04-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:42:04'),(32,'theme-eventify-homepage04-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:42:04'),(33,'theme-eventify-homepage04-favicon','main/general/favicon.png',NULL,'2025-06-10 10:42:04'),(34,'theme-eventify-homepage04-logo','homepage04/general/logo.png',NULL,'2025-06-10 10:42:04'),(35,'theme-eventify-homepage04-homepage_id','1',NULL,'2025-06-10 10:42:04'),(36,'theme-eventify-homepage04-blog_page_id','4',NULL,'2025-06-10 10:42:04'),(37,'theme-eventify-homepage04-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:42:04'),(38,'theme-eventify-homepage04-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:42:04'),(39,'theme-eventify-homepage04-blog_post_items_per_row','3',NULL,'2025-06-10 10:42:04'),(40,'theme-eventify-homepage04-number_of_related_posts','3',NULL,'2025-06-10 10:42:04'),(41,'theme-eventify-homepage04-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:42:04'),(42,'theme-eventify-homepage04-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:42:04'),(43,'theme-eventify-homepage04-events_page_id','5',NULL,'2025-06-10 10:42:04'),(44,'theme-eventify-homepage04-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:42:04'),(45,'theme-eventify-homepage04-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:42:04'),(46,'theme-eventify-homepage04-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:42:04'),(47,'theme-eventify-homepage04-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:42:04'),(48,'theme-eventify-homepage04-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:42:04'),(49,'theme-eventify-homepage04-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:42:04'),(50,'theme-eventify-homepage04-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:42:04'),(51,'theme-eventify-homepage04-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:42:04'),(52,'theme-eventify-homepage04-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:42:04'),(53,'theme-eventify-homepage04-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:42:04'),(54,'theme-eventify-homepage04-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:42:04'),(55,'theme-eventify-homepage04-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:42:04'),(56,'theme-eventify-homepage04-logo_height','45px',NULL,'2025-06-10 10:42:04'),(57,'theme-eventify-homepage04-is_header_transparent','1',NULL,'2025-06-10 10:42:04'),(58,'theme-eventify-homepage04-display_header_top','1',NULL,'2025-06-10 10:42:04'),(59,'theme-eventify-homepage04-header_top_text_color','#000000',NULL,'2025-06-10 10:42:04'),(60,'theme-eventify-homepage04-header_top_background_color','#ffffff',NULL,'2025-06-10 10:42:04'),(61,'theme-eventify-homepage04-header_background_color','#F8F7F3',NULL,'2025-06-10 10:42:04'),(62,'theme-eventify-homepage04-header_text_color','#002466',NULL,'2025-06-10 10:42:04'),(63,'theme-eventify-homepage04-footer_background_color','#F8F7F3',NULL,'2025-06-10 10:42:04'),(64,'theme-eventify-homepage04-footer_text_color','#363D4A',NULL,'2025-06-10 10:42:04'),(65,'theme-eventify-homepage04-footer_heading_color','#002466',NULL,'2025-06-10 10:42:04'),(66,'theme-eventify-homepage04-tp_primary_font','Figtree',NULL,'2025-06-10 10:42:04'),(67,'theme-eventify-homepage04-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:42:04'),(68,'theme-eventify-homepage04-primary_color','#2e4dfd',NULL,'2025-06-10 10:42:04'),(69,'theme-eventify-homepage04-secondary_color','#002466',NULL,'2025-06-10 10:42:04'),(70,'theme-eventify-homepage04-newsletter_popup_enable','1',NULL,'2025-06-10 10:42:04'),(71,'theme-eventify-homepage04-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:42:04'),(72,'theme-eventify-homepage04-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:42:04'),(73,'theme-eventify-homepage04-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:42:04'),(74,'theme-eventify-homepage04-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:42:04'),(75,'theme-eventify-homepage04-primary_font','Space Grotesk',NULL,'2025-06-10 10:42:04'),(76,'theme-eventify-homepage04-event_location_image','homepage04/icons/location.png',NULL,'2025-06-10 10:42:04'),(77,'theme-eventify-homepage04-breadcrumb_background_color','#2e4dfd',NULL,'2025-06-10 10:42:04'),(78,'theme-eventify-homepage04-gradient_color_from','#FF5000',NULL,'2025-06-10 10:42:04'),(79,'theme-eventify-homepage04-gradient_color_to','#FF00B8',NULL,'2025-06-10 10:42:04'),(80,'announcement_max_width','1210',NULL,'2025-06-10 10:42:04'),(81,'announcement_text_color','#000000',NULL,'2025-06-10 10:42:04'),(82,'announcement_background_color','transparent',NULL,'2025-06-10 10:42:04'),(83,'announcement_text_alignment','start',NULL,'2025-06-10 10:42:04'),(84,'announcement_dismissible','0',NULL,'2025-06-10 10:42:04'),(85,'announcement_font_size','14',NULL,'2025-06-10 10:42:04'),(86,'announcement_font_size_unit','px',NULL,'2025-06-10 10:42:04'),(87,'announcement_placement','theme',NULL,'2025-06-10 10:42:04'),(88,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:42:04','2025-06-10 10:42:04'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:42:04','2025-06-10 10:42:04'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:42:04','2025-06-10 10:42:04');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:42:04','2025-06-10 10:42:04');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=137 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:14','2025-06-10 10:41:14'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:15','2025-06-10 10:41:15'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:15','2025-06-10 10:41:15'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:15','2025-06-10 10:41:15'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:15','2025-06-10 10:41:15'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:41:15','2025-06-10 10:41:15'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:41:30','2025-06-10 10:41:30'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:41:36','2025-06-10 10:41:36'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:36','2025-06-10 10:41:36'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:37','2025-06-10 10:41:37'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:37','2025-06-10 10:41:37'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:37','2025-06-10 10:41:37'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:37','2025-06-10 10:41:37'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:41:37','2025-06-10 10:41:37'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:41','2025-06-10 10:41:41'),(59,'jalon-nader',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:41','2025-06-10 10:41:41'),(60,'miss-lilla-jacobi-iii',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:41','2025-06-10 10:41:41'),(61,'delpha-bruen',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:41','2025-06-10 10:41:41'),(62,'unique-heathcote',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:42','2025-06-10 10:41:42'),(63,'lukas-barrows-iii',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:42','2025-06-10 10:41:42'),(64,'jerome-koss',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:43','2025-06-10 10:41:43'),(65,'dr-toy-fritsch',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:43','2025-06-10 10:41:43'),(66,'dovie-runolfsson',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:43','2025-06-10 10:41:43'),(67,'orland-gorczany',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:44','2025-06-10 10:41:44'),(68,'mr-bart-wolf',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:44','2025-06-10 10:41:44'),(69,'mrs-samantha-leuschke',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:44','2025-06-10 10:41:44'),(70,'rosemary-lowe',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:44','2025-06-10 10:41:44'),(71,'lennie-leannon',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:45','2025-06-10 10:41:45'),(72,'mrs-lelia-tromp-jr',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:45','2025-06-10 10:41:45'),(73,'dawson-bogan',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:45','2025-06-10 10:41:45'),(74,'dr-alfred-kassulke',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:45','2025-06-10 10:41:45'),(75,'joana-watsica',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:45','2025-06-10 10:41:45'),(76,'neva-zieme',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:46','2025-06-10 10:41:46'),(77,'shaylee-mcdermott',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:41:46','2025-06-10 10:41:46'),(78,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(79,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(80,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(81,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(82,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(83,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(84,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(85,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(86,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(87,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:41:53','2025-06-10 10:41:53'),(88,'dr-modesto-lemke',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(89,'richie-lakin',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(90,'dora-gusikowski',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(91,'leta-schultz',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(92,'arnaldo-klein',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(93,'prof-meaghan-skiles-jr',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(94,'maximillian-stamm',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(95,'dr-marty-hauck-jr',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(96,'isai-vonrueden',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(97,'johathan-bauch',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(98,'genoveva-kuhlman',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(99,'lucio-corkery',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(100,'deshawn-ebert-v',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(101,'willy-wiza-md',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(102,'dr-keon-ortiz-iii',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(103,'tia-bartoletti',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(104,'lou-schulist',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(105,'shaniya-cremin',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(106,'dr-wilmer-weber-sr',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(107,'dr-audrey-kirlin-iv',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(108,'ciara-lindgren',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(109,'jeanie-kassulke',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(110,'ezekiel-hayes',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(111,'amalia-luettgen',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(112,'janie-hauck-ii',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(113,'prof-jess-lubowitz-iv',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(114,'loren-koss-sr',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(115,'prof-joelle-lehner-ii',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(116,'sadye-jacobson-dds',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(117,'tabitha-bechtelar',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(118,'miss-whitney-steuber',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(119,'dr-koby-reichert-jr',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(120,'bethany-fay',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(121,'dr-modesto-reichert',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(122,'abigale-ferry',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(123,'sasha-wunsch',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(124,'mr-nikolas-yundt-dvm',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(125,'magali-miller',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(126,'lorine-ortiz',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(127,'anika-rohan-iv',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(128,'dr-germaine-schinner-md',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(129,'miss-alvina-bogisich',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(130,'mr-louisa-skiles',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(131,'prof-cameron-johns-iii',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(132,'mitchell-welch',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(133,'abelardo-kunde',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(134,'marlee-stoltenberg-dds',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(135,'ressie-quitzon',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04'),(136,'hazel-haag-sr',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:42:04','2025-06-10 10:42:04');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:41:46','2025-06-10 10:41:46');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:41:36','2025-06-10 10:41:36');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:41:16','2025-06-10 10:41:16'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:41:16','2025-06-10 10:41:16'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:41:16','2025-06-10 10:41:16'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:41:16','2025-06-10 10:41:16');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'terry.lenore@conn.com',NULL,'$2y$12$6dJ030Ti6rF9.OZGuLTXG.q3RZN30.KY94JFOmTNZ3RBZY.YYnZHe',NULL,'2025-06-10 10:41:15','2025-06-10 10:41:15','Cortez','Blick','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage04',1,'[]','2025-06-10 10:41:30','2025-06-10 10:41:30'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage04',2,'[]','2025-06-10 10:41:30','2025-06-10 10:41:30'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage04',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage04',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage04',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage04',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(7,'EventListWidget','event_list_sidebar','eventify-homepage04',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(8,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage04',1,'{\"background_color\":\"#2E4DFD\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(9,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage04',1,'[]','2025-06-10 10:41:30','2025-06-10 10:41:30'),(10,'BlogSearchWidget','blog_sidebar','eventify-homepage04',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(11,'BlogCategoriesWidget','blog_sidebar','eventify-homepage04',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(12,'BlogTagsWidget','blog_sidebar','eventify-homepage04',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(13,'UpcomingEventWidget','pre_footer_sidebar','eventify-homepage04',1,'{\"background_color\":\"#FFBA00\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(14,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage04',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:41:30','2025-06-10 10:41:30'),(15,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage04',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:41:30','2025-06-10 10:41:30');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:42:05
