-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'6SQzm1rg8JrAcMwSLCMOjOcnQ8CGzDJq',1,'2025-06-10 10:44:22','2025-06-10 10:44:22','2025-06-10 10:44:22');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:45:13',NULL,1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:45:13',NULL,1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:45:13',NULL,1,'2025-06-10 10:45:13','2025-06-10 10:45:13');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Iure voluptas nobis totam velit dolores amet saepe. Occaecati dolore soluta nostrum magni eum tempore.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(2,'Leadership &amp; Strategy',0,'Sed velit ex in blanditiis quis aperiam non. Iusto nihil non velit magnam velit sed rerum.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(3,'Networking &amp; Collaboration',0,'Necessitatibus rerum dicta architecto et nisi minima aut. Laboriosam voluptas officia error. Qui vel atque eaque magni consequatur. Est magni exercitationem non aut soluta.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(4,'Entrepreneurship Startups',0,'Aut et et iure quis quos nobis. Quia soluta autem deleniti cumque. Quis praesentium excepturi adipisci a aliquam. Cum quae repudiandae dolor. Dolorem vero sit quos qui non.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(5,'Marketing &amp; Branding',0,'Ipsum ut quod et debitis quae. Nihil maiores hic quisquam. Distinctio facilis numquam eos recusandae ea minus. Velit deserunt delectus sapiente facilis molestiae consequatur.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(6,'Event Highlights &amp; Recaps',0,'Beatae ullam dignissimos et numquam velit itaque. Excepturi aspernatur ea tempora est. Quis ut placeat magnam architecto cum quasi et ratione.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:44:45','2025-06-10 10:44:45');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Desmond Homenick','talia.lueilwitz@example.org','+1.828.220.7660','42803 Armstrong Port\nLenorefurt, CT 88919','Ab et voluptatem sed ut quod qui.','Qui officiis ut est dolore distinctio sed nihil. Sequi fugiat id inventore quibusdam delectus sapiente aliquam. Modi quia nihil occaecati commodi ab. Eligendi ut deserunt quod. Doloremque rerum voluptatem commodi minus modi. Laborum nobis iste unde est repellendus. Cum sapiente facere qui enim velit sunt. Voluptas nihil quia tempora voluptas vel et. Consequuntur qui saepe id vel velit nihil. Praesentium voluptate delectus vitae a. Quasi necessitatibus veritatis ipsam.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(2,'Terrence Predovic II','baumbach.enoch@example.com','+14842237893','45143 Rocio Fort\nNorth Ernieborough, NV 47709-1005','Velit rerum omnis at quaerat.','Nostrum deleniti voluptate nobis iste. Dignissimos eum nesciunt voluptatum ut rerum fuga. Dolores ut a cum ab. Corporis error et exercitationem recusandae dolorem. Non quia non eum sit magni illo sit. Aliquam eos sit omnis pariatur dolorem iure error. Ut et quos est officia architecto magni dolorum. Ut ad ut reprehenderit amet ratione. Mollitia dolores tenetur aliquam hic laborum eius molestiae.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(3,'Mrs. Jazlyn Flatley V','douglas59@example.org','+1-903-369-0716','926 Domenick Road Apt. 855\nNew Chesterbury, MI 98653','Est nisi et quidem soluta qui.','Voluptas recusandae aut provident. Enim fuga itaque et minima sed. Est provident dolores doloribus voluptatem cumque. Quia suscipit voluptas atque ipsam illo nihil. Sed placeat culpa et laudantium ab aspernatur voluptatem. Neque sint amet aut culpa cum culpa iusto. Ut eveniet neque dolorum sapiente beatae et nam. Non molestiae corporis est quo similique incidunt fugit sed. Sint amet numquam omnis sequi officia delectus deserunt.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(4,'Kaela Fritsch','waldo.mosciski@example.org','281-755-9907','68980 Verla Centers Apt. 297\nSantachester, IL 89698','Rerum labore totam eveniet hic laboriosam et.','Laudantium aut aliquid nesciunt odit debitis. Fugiat autem qui sit possimus nihil. Exercitationem veritatis ut ea est numquam cumque ratione. At dolorum autem iusto accusamus et voluptatum. Aperiam quibusdam ea non qui qui voluptas maiores nisi. Molestiae ullam quam et ipsum eos. Mollitia maxime aut fuga repudiandae nihil.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(5,'Ms. Roslyn Balistreri','silas50@example.org','+1 (646) 267-2763','15406 Andy View\nNathanielburgh, MO 92211-3065','Ullam quia rerum eaque rem.','Velit minus praesentium unde quo repellat. Amet aut sit est. Minus et numquam aut aut autem. Tenetur quo unde molestias dolores nihil et. Nisi libero laborum velit reprehenderit. Tempore eos unde voluptas harum consequatur earum. Fugiat optio amet atque dolores neque. Ut tenetur voluptatum et ipsam excepturi dolores. Harum possimus nulla id est nostrum eius omnis. Porro odit dicta aut libero et eius. Et facilis soluta enim impedit.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(6,'Sebastian Pacocha','alysson.bartell@example.net','(916) 489-8726','8212 Tyson Way\nKuhicville, NH 12470','Inventore in nulla id cum.','Vel nam et labore doloribus ea doloribus doloribus. Praesentium soluta adipisci eligendi sunt eveniet consequatur alias. Quis tempore tempora ipsum incidunt. Nulla quo quis quis eum quia. Ut doloribus vero amet assumenda. Qui consequatur sit est incidunt nemo et. Similique consequuntur repellat porro cupiditate deserunt reiciendis soluta aut. Consequuntur libero et quo.',NULL,'unread','2025-06-10 10:44:23','2025-06-10 10:44:23'),(7,'Prof. Charlie Kub','sadye77@example.com','+16674434296','50243 Vivien Camp\nPort Ednashire, NY 67017','Qui ut animi ut praesentium.','Numquam ut eum veritatis asperiores sunt rerum. Alias atque eligendi et commodi nobis eos aut. Voluptatibus fuga et velit. Id ut consequuntur debitis blanditiis officia. Aut quasi tenetur rem qui ab reprehenderit voluptas. Illo odio ab amet voluptatem. Dolores ab necessitatibus est quis quia consectetur. Quia nulla ipsa molestiae dignissimos praesentium omnis soluta. Quod libero eligendi aspernatur et sed excepturi aut. Quas et itaque quaerat est deleniti a.',NULL,'unread','2025-06-10 10:44:23','2025-06-10 10:44:23'),(8,'Mrs. Marianne Cassin','hsanford@example.com','1-737-632-0198','10301 Leon Viaduct Suite 423\nNew Desiree, ND 73347-1005','Ea nisi ipsam quas quia maiores iusto.','Expedita ad nisi nesciunt ea eos. Sed fugiat aperiam et id laudantium ut dolore. Consequatur repudiandae ullam magni porro. Consequuntur aut est animi labore aut quod. Laboriosam necessitatibus neque deserunt aspernatur. Dolore ea voluptatem pariatur voluptatem aut adipisci temporibus commodi. At deleniti corrupti ut quos. Neque ducimus corporis quia in est cupiditate reprehenderit. Assumenda ad aut iusto tempora voluptatibus ut eum. Illo vero vitae fuga dolores et.',NULL,'unread','2025-06-10 10:44:23','2025-06-10 10:44:23'),(9,'Jasper Pagac III','ilangosh@example.net','+1-979-781-9560','433 Maurice Stravenue Suite 555\nReillyborough, MI 47754-3479','Sit voluptates quae nam.','Laboriosam debitis doloremque numquam. Dolor qui eos magnam voluptatum quae quis sit laborum. Dignissimos et voluptatem ex laudantium voluptas et quas. Blanditiis tempora eligendi quae illo. Sequi corrupti tenetur est autem perferendis expedita. Quia voluptas quasi ea sapiente soluta quia nostrum fugit. Praesentium qui officiis nobis doloribus unde ut.',NULL,'read','2025-06-10 10:44:23','2025-06-10 10:44:23'),(10,'Mr. Ross Thompson II','fgerlach@example.org','1-629-366-6534','658 Moriah Island Suite 169\nEltonborough, RI 67838-5412','Sit ut nihil praesentium facilis.','Aut exercitationem rerum minus in voluptates nihil cumque. Ratione qui cum iste suscipit voluptatem modi nihil incidunt. Dolorem commodi omnis esse aut natus et. Ex molestias sunt veritatis neque eius sapiente excepturi. Cupiditate et quidem quisquam repellendus nihil molestiae expedita. Quisquam nesciunt nihil odit veniam reiciendis.',NULL,'unread','2025-06-10 10:44:23','2025-06-10 10:44:23');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:44:56',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:44:56',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:44:56',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:44:56',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:44:56',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:44:56',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Dr. Stephania Becker','customer@archielite.com','$2y$12$U4/EvY7JWMsk37mJvq5eluoOV37hCMT2pxWfUExyNE4gc/lhr8EX6',NULL,'0400053723','2018-10-14','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:51','2025-06-10 10:44:51'),(2,'Michael Smith','connelly.brook@simonis.com','$2y$12$oonZOSpmoZFoBih2e49vuOdhs85s/HXnT.e8CcttwtBbQq5RWQz8e','homepage07/speakers/2.png','0870352251','2022-12-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:51','2025-06-10 10:44:51'),(3,'Dakota Rice','rowe.baylee@yahoo.com','$2y$12$E7pim8cXA1EA9H48vEpqguQ0sQ2BQqordII/0DXzpTaLegK3b8W4K',NULL,'0998972981','2019-01-18','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:51','2025-06-10 10:44:51'),(4,'Jayde Haag','nelson.swift@prohaska.com','$2y$12$I7uXWWgKq6TZT6CC2wVtBOuCMorSxDNP3rkj9TkT8Vx7chAM6QFYS','homepage07/speakers/7.png','0859187931','2003-09-25','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:51','2025-06-10 10:44:51'),(5,'Gerardo Hoeger','sklein@gmail.com','$2y$12$lSDRLmMaIhUVLEps7oLEveA3JVy9JXDa.Fndw7BE7c99aTk.IDuGC','homepage07/speakers/3.png','0581886624','2022-09-11','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:51','2025-06-10 10:44:52'),(6,'Dax Purdy','turcotte.keshawn@hotmail.com','$2y$12$GF3Hd6s2VjC0hV6WVptwROKMmKAHG7d0LJ4j8i1OV03eoTCZ8FoiO','homepage07/speakers/1.png','0743339023','2001-04-02','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:52','2025-06-10 10:44:52'),(7,'Tod Auer','lgreenholt@block.info','$2y$12$Tijk1xU7wqPMGJQoyCxL/Oc9YAL//X/u86qAXgx2X1XYvJG1RzKzS','homepage07/speakers/6.png','0274795716','1997-04-23','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:52','2025-06-10 10:44:52'),(8,'Bernard Kuhn','cgrant@dare.com','$2y$12$LYaUW3dsjc8giU9YmMHWI.lrA77S.h/FE/3VDcFPnm7V0rGx2O6c2',NULL,'0833337850','2007-05-24','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:52','2025-06-10 10:44:52'),(9,'Loy Koepp','della.orn@stracke.net','$2y$12$xp2gz7hK0qexFaA0nDqq6eWL4qmhds6WCWZFk4SSCu6N9KvckLSam','homepage07/speakers/3.png','0636021763','2004-12-24','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:52','2025-06-10 10:44:52'),(10,'Miss Yazmin Gaylord IV','hudson.johns@weissnat.com','$2y$12$UwJkavDlVvUimC/1wbSqKOs9kiwmkDJn9D/3PjR8no8e8bI4Qh5DW','homepage07/speakers/3.png','0495491139','2006-02-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:52','2025-06-10 10:44:52'),(11,'Mr. Kim White IV','stanton.hillary@yahoo.com','$2y$12$ZRw0WHyiVaU4KMFhbT/ejucGJHUnVdVHdJSHDBTrldQPV4.EJqqJi','homepage07/speakers/6.png','0115849353','2000-11-30','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(12,'Dolores Schaefer','brooklyn.kihn@block.net','$2y$12$MUvRxyuhE0FZCoFxLO6NPu2U3mpzFagHXR6YgRzUFGTqO6/6if..a','homepage07/speakers/5.png','0374000579','2020-02-24','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(13,'Howard Predovic','ehagenes@gmail.com','$2y$12$WuiwtIuyQs5.c/kZoPN35./vNgMfN5KXXLxSI.166Ma3AmiTnmZe2','homepage07/speakers/6.png','0601181545','2014-06-11','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(14,'Marilyne Kilback','hhayes@bradtke.com','$2y$12$NhCtVx6ioZkLoP3EpQ8Rqe0KzbCFcIZgs2pfkHTQS8srRQ8rRs2eO','homepage07/speakers/5.png','0695606367','2008-10-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(15,'Pearline Roob','norwood53@howe.com','$2y$12$l/cRZ34HUH36Zlb5lWuxTupuWbBDsEm6Rejv84GT6pybAO8oFIFx2','homepage07/speakers/8.png','0908262692','2005-06-06','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(16,'Parker Hills','friesen.hayden@koss.com','$2y$12$8bHaVc1PYtbbIRjnCcn5Pea.cfhMVQLPY5s1mwGY2xWOQoZG2moTS','homepage07/speakers/5.png','0059087265','2020-10-03','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:53','2025-06-10 10:44:53'),(17,'Laverne Hoeger','adrienne11@bauch.biz','$2y$12$GWRbmTQ2ybuAsppnPu0i6uONhZT5aISskIieLcbCCdjQMH5iXzplG','homepage07/speakers/4.png','0486525998','2025-02-28','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:54','2025-06-10 10:44:54'),(18,'Vallie Hirthe','wendy53@hotmail.com','$2y$12$sjCJqSO9bQB1823KkLUUPeGbxppUIegiGhRUmMUrSXtnk21rJy47O','homepage07/speakers/1.png','0034168129','2000-02-27','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:54','2025-06-10 10:44:54'),(19,'Max Hansen','mcassin@pouros.com','$2y$12$hSrhgcpAun9.B9CmusiLuOGT9nknj853P6vcRqvulSTiLDhqsbzlS',NULL,'0611621708','2016-10-28','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:54','2025-06-10 10:44:54'),(20,'Dale Robel','fcummerata@huels.biz','$2y$12$1ev65nULfC.j30UNkET1num.bNLG0HxU8w5OB7gFh/uez74LyMsWG','homepage07/speakers/1.png','0300368337','1996-07-28','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:54','2025-06-10 10:44:54'),(21,'Olin Senger','rosenbaum.elody@mcclure.biz','$2y$12$Mb1TE0rZ5b5JHQDSSIseNeHoBpVfzESr8DQZ9t8CbXH7bdzvfi0sS','homepage07/speakers/5.png','0709435804','2016-12-27','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:54','2025-06-10 10:44:54'),(22,'Cassidy Emmerich','vwelch@yahoo.com','$2y$12$MiTlk3Ih5YPnyEMQSgoaTuU0U5PXPn9SvSioCMEMCSqE67KMZHe0m','homepage07/speakers/4.png','0398747332','2022-01-02','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(23,'Dr. Hellen VonRueden','ypadberg@gmail.com','$2y$12$7i8jzMT5b7FHKidbXAHG8OHLbplfcYj1F.B4StFgfh5ck9q/g9qLS','homepage07/speakers/1.png','0531388214','2012-03-21','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(24,'Dr. Garry Ankunding','beulah.haley@kilback.com','$2y$12$Kd7fzVPHlKyXQzouWgVgTOJXpAIoBBFvPhAEh2Um6PkwTyBN7Uf0G',NULL,'0547165373','2006-05-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(25,'Zora White PhD','leonardo69@davis.org','$2y$12$3N6.NVsLK0TKXLN5XIzXG.VrIqHo4dsQIAsixRQjkZ0GX4WHZEqBO','homepage07/speakers/1.png','0633848389','2019-05-29','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(26,'Keegan Toy','trutherford@yahoo.com','$2y$12$a2wjBm/KfZgpOcSiFFqSiOR4ra4uPrWdNLJkvkUjUK8fPtYFlQrJe',NULL,'0792435004','2015-02-15','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(27,'Mr. Milo Dickinson','zjenkins@yahoo.com','$2y$12$QVMz1/HmXAZLmMpkUUKKVe8mdjMSnLOt0CXoV1R3AopCkLD3r9ILG','homepage07/speakers/3.png','0336210295','2010-11-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:55','2025-06-10 10:44:55'),(28,'Rosella Kuhn','frances44@schroeder.net','$2y$12$w9Nq8XgaQQS89OFxBUQih.uOqASzFZ0MyMDmZCbr/yjw96w1DymOW',NULL,'0421950879','2024-11-22','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:44:56','2025-06-10 10:44:56'),(29,'Antonietta Rau II','zieme.ethan@hotmail.com','$2y$12$3LNYgn7SmdMRfZFvasoneeTZki6NumLvKmbkMJ8yaFIh9mWieRkSe','homepage07/speakers/4.png','0369495059','2008-10-22','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:56','2025-06-10 10:44:56'),(30,'Reginald Mitchell IV','bruen.estefania@littel.com','$2y$12$b04haBpe8YPop1vBMrkPPOVdjsIA/S/1.uosI8KL5UCVlrZ9yZZNy','homepage07/speakers/5.png','0796089167','2015-11-21','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:44:56','2025-06-10 10:44:56'),(31,'Johnny Cummerata Sr.','auer.nyasia@murphy.net','$2y$12$dvMu2PWoKGNNJZwroXg7HOAywx1Kfy6.P40owFgXH51zrc6SJrJ1y','homepage07/speakers/3.png','0834630217','1996-02-09','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:44:56','2025-06-10 10:44:56'),(32,'Bradley Lindgren','anissa.kunze@yahoo.com','$2y$12$.CEILIfCuqwQSihIgJpHm.WfYR4h0OyutFFrIP2N.ktQjDo5ncytq',NULL,'0079907475',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(33,'Zachary Bartell','marcelle85@russel.com','$2y$12$zEKg0x./cCdZfsdX7Udd.ew9V4WXnBQyTanCBJikma35PSXBju9UW',NULL,'0866153018',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(34,'Cali Emmerich','gsanford@wintheiser.com','$2y$12$cTEvkez.Yr00WjYJLEpVyOyOFE5gkQfu5gT1WnEKNF7SfKQLT8NKy',NULL,'0985765819',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(35,'Alfredo Okuneva V','reanna.yundt@conn.com','$2y$12$QPyQ.M3GvQfhhSbkT/OUy.vlJ2nmjRdT7WELrLjzRtiHFYXeHsNdy',NULL,'0979932764',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(36,'Frankie Auer IV','bria.eichmann@lehner.info','$2y$12$tRMqLH3x7S3au6wivbXXm.LsMzU9wX8QPZRTwUASXzU.D4yG9R/z2',NULL,'0137043285',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(37,'Gladyce Kshlerin','dhermann@mante.com','$2y$12$X9IDUJQ9SVK7/7RtM4uFSOuOxTZ9Wqz0p6Zy1N8p2813eH8QpBbZW',NULL,'0657302099',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(38,'Oliver Gleichner','tharris@gmail.com','$2y$12$59jnRCe7h2fadOEBKD1SoelvFbtMH1oWPErZPeAwIKq//5270I4YK',NULL,'0786076207',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(39,'Carlo Lesch','lyric66@nitzsche.com','$2y$12$i7pip3jI4WZpFFD2uf52NeIcRgT9UJsPcK4Sg0LC8hzxWc4ETX.p2',NULL,'0886938727',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(40,'Prof. Trey Nienow III','lavern40@spencer.com','$2y$12$HwtYyEvxFAOytb.wFfMqiO6rsivCdh.t7NaxInZDmOsWxxUI71qIC',NULL,'0965972141',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(41,'Dr. Dominic Schuster Sr.','oherman@gmail.com','$2y$12$xUjaCOznfHI2jZEqjmYHjeVgE.Hei7xdgrYWWGzs50n42KmiQDw9m',NULL,'0028029462',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:08','2025-06-10 10:45:08'),(42,'Verdie Friesen DVM','lhoppe@gmail.com','$2y$12$TT5siMlNTmeB0Awj4q7vu.zT3/mJjDR1XG/PkClbuVfIoWcWkjxKW',NULL,'0590944043',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(43,'Mr. Jovanny Okuneva','lexie29@gmail.com','$2y$12$6E.yqkBTZR9a11v0iwCAjuU3KDZoovLycZf4RZ17ZEYg4uiWV9jxK',NULL,'0221271065',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(44,'Prof. Braeden Mante Jr.','veum.javonte@rosenbaum.net','$2y$12$bMNnpI8iX.cG2TNOZOM5oOYMppN9yZiceASVQhUJSj.Kkj9HYqqCu',NULL,'0964147377',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(45,'Mr. Bruce Stroman Jr.','dleannon@hotmail.com','$2y$12$i.HalbH1O4gg0nruk5GgSeKrKpJTJjGz0uUhH/Nasx4kWgX0.gs72',NULL,'0109845686',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(46,'Grant Rolfson','tnolan@yahoo.com','$2y$12$YmGORg0zGBUPLxu1zktpf.iJpvW1fbIhgIcskqXiTSJmkwzVZPWOS',NULL,'0013508547',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(47,'Ms. Haven Stark II','spfeffer@yahoo.com','$2y$12$4aHehBEnpTBSJEWD9wiEfuj.ggIIWrAay0Vvq78wBhVZlLmOUlo9G',NULL,'0560716619',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:09','2025-06-10 10:45:09'),(48,'Vance Beatty','elody.nicolas@gmail.com','$2y$12$0egf.Qo.e9ACQKJZjzMXPumoXGf4bBu9rls/gqw8pzlhIQdL2J70S',NULL,'0883794484',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(49,'Prof. Walton Beier DDS','casper.ida@king.info','$2y$12$dB3PcCiiMVqRFINqQmWi7uxQ1sM7K3vKonfEH7USLB7w/pvWCEWoy',NULL,'0707399418',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(50,'Mr. Johan Haley I','torp.elouise@hotmail.com','$2y$12$j7L55t40OvpBhJK.LDWi6ugMp7g3Gh2iGUQ8hMq6t01d49WbyOtIi',NULL,'0758552082',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(51,'Marcus Wisoky','scrooks@gleichner.com','$2y$12$ZYNo3cNoT7cY3oU98V27D.pAENAtgMDpJDhzFG/3hZAquE8TC9YFa',NULL,'0488690349',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(52,'Vernice Kris','oren61@grimes.net','$2y$12$HiXuhJT9IGHHJVZlMgu9uuzd0SgO3/7udUB3UeBJPgm2zCWHlMpmW',NULL,'0332740560',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(53,'Lucile Boyer','cmedhurst@murphy.biz','$2y$12$X1iRXBikb2O1U0YaI4P9AuSI1.vR1phBj8tgMyvSjpoSfBa/bXTt.',NULL,'0429383090',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(54,'Nikko Lynch','dereck.armstrong@hotmail.com','$2y$12$Ggz8hXsTS9nCefdriPLGt.sdmRTc4bbD0sSRxB/XlKxxICleJuD5q',NULL,'0648079428',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:10','2025-06-10 10:45:10'),(55,'Vivianne Jones','belle23@hotmail.com','$2y$12$PpGkz7qxcrv7JVM9Z7fE.OgQwAskH6iZJJub5x51lt1bosOLHqbIi',NULL,'0020214995',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(56,'Mercedes Gaylord','bogan.corbin@torphy.com','$2y$12$wL/9Lxktbm9LjHkczjvkHOgDVBTONNuSjkSTXogDYHzDe9igZHWeW',NULL,'0480027369',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(57,'Josefina Kuhic','evandervort@yahoo.com','$2y$12$.TQhNj5fzI8/j97CS3kUeuJU1QLBqu1cSQucZoqcOCnqUKVwppos.',NULL,'0304925498',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(58,'Margot Simonis','tcollins@dach.biz','$2y$12$T8snFIN8Kj.C03ldH/29aOmeFOtAWgItYHp3tgIKBiZa0rHM0HWYm',NULL,'0800926907',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(59,'Rodrick Kiehn','shad.nikolaus@gmail.com','$2y$12$NOXZ09MeIlSR1Ogkg/RkXOpaC/Bp0ato2CQVMUzJ/rRlVlo8CbFbu',NULL,'0210036297',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(60,'Shawn Kassulke','whickle@gmail.com','$2y$12$TMpdFo2zDbpSoyZTSZIzEubI4/qEJkYEzO3X6JWJefCOTkpC.unj2',NULL,'0880761287',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(61,'Rollin Kuphal','armstrong.callie@hotmail.com','$2y$12$sRr1lEbRz8xjR72vG0qUEu0LvPkkcxTg4JprGU3ppoTv9oRNavRsu',NULL,'0915941677',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:11','2025-06-10 10:45:11'),(62,'Jenifer Gutmann','ova75@connelly.com','$2y$12$/GST9SvJmznI0mewJkvesesSReVVlhnvy116kpTd5PJGiRg/o2Ht2',NULL,'0835082613',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(63,'Prof. Madison Langosh','ohammes@lakin.net','$2y$12$C.WjuY.NC/KAVn7lphAawO1aoiBb5smdiCkrnZagyus6gQ58pGlTe',NULL,'0829268965',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(64,'Lelia Shanahan','orlando64@hotmail.com','$2y$12$wKAw/x3cdv.aEg02N5bLEuiTC21hSxg6Sxc/wgV1a4o4NrsliKA4u',NULL,'0299926158',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(65,'Winifred Runte','kelli39@tromp.com','$2y$12$6vEOeIvNhtEp0h8PJjeGZuiU5UzYeCb43wIM8xQ8Tlv2h3i2.gZe6',NULL,'0298687780',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(66,'Prof. Enrique Fadel','ncarroll@yahoo.com','$2y$12$laOU8JzYqQOAlh6nnpP.sumiNnt6yUf/nfg9UgB9hoc4F1dMWsGee',NULL,'0851608454',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(67,'Dortha Nikolaus','kamron99@kassulke.biz','$2y$12$omLprPgw3DMqbmXJDvs62e1mEruIbZ76F.5cHr0hh9qi3i0Ec.rfW',NULL,'0664951352',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(68,'Monique Feil','glen61@yahoo.com','$2y$12$15ZbukWk7.mcuscyDqRZM.KI7wX7NQEVymcWESjksscGerWbD8h6.',NULL,'0212708000',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:12','2025-06-10 10:45:12'),(69,'Prof. Jasen Herzog II','bethel.hilpert@feil.org','$2y$12$I5cnu5Fka7nrXgYb82Ya/ORwD40.MRSQNCrUd5ahUXm7FqOMXguyS',NULL,'0619824489',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(70,'Gladyce Runolfsdottir','pjenkins@gmail.com','$2y$12$2bOpIDn/KlYk8ZdQDqA7FeJ0f3V2Rk6K8dySw5vbqDDrqIxpbHALe',NULL,'0171186718',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(71,'Mrs. Sierra Bailey','ifranecki@gmail.com','$2y$12$xBss24Qa7nNcuq2TqIl7LOBNMAfKuaJ4rez.6ATEmNAE2IKmN2VSO',NULL,'0146124112',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(72,'Jairo Davis','merle86@gmail.com','$2y$12$1wNX2jMwSXp7PTU9u1gdd.CkL9tVhqvGMqY12eoJLKHTYs2V./Pla',NULL,'0362923261',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:45:13','2025-06-10 10:45:13');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:44:16','2025-06-10 10:44:16'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:44:16','2025-06-10 10:44:16'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:44:16','2025-06-10 10:44:16');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (4,57,'3KD0UWN8FLVB',NULL),(4,62,'3NBLUEBTJWUU',NULL),(3,50,'5CFQL4MI2SUR',NULL),(5,68,'BJKWZGAOA7IU',NULL),(4,59,'BURBIL7J4IIK',NULL),(3,47,'BXGA0EMTJA7D',NULL),(1,35,'CQZEVRCOPZY6',NULL),(1,33,'CYOHOS0DVFEY',NULL),(2,41,'DBDE2W1FHPXN',NULL),(1,34,'DNSUIYDXBWV7',NULL),(2,38,'DWIEHGMPDEDF',NULL),(2,36,'GWFGP0VJA3IU',NULL),(2,46,'HCFNXNIQHPUK',NULL),(3,48,'IXLZ8EBNYRUI',NULL),(4,60,'K18ZWDPVP1Z5',NULL),(5,66,'K3OGCYPDMHRE',NULL),(2,40,'KCNF9SBLHCJB',NULL),(4,55,'KOEATHHS7MAO',NULL),(5,71,'LPG43QYO6V9N',NULL),(4,51,'MJGGCXABXWYJ',NULL),(2,42,'MPB90GRPCG8W',NULL),(5,70,'NBLCQWK2EJYW',NULL),(2,44,'PEERKXP8ZV18',NULL),(4,58,'PKCJKWVMMR2W',NULL),(5,65,'QLQFWQPNIHCV',NULL),(4,53,'QU358Q6WRNYE',NULL),(4,61,'RHTI4B4EVY6N',NULL),(5,69,'RU35BNW3NJWF',NULL),(4,56,'S3ZQAUTRPQ5Z',NULL),(4,63,'SMXRPNH3WZEG',NULL),(5,64,'T9Y48HQ4MT5R',NULL),(2,37,'TBDSRVYFNC0Y',NULL),(2,45,'TFMOXM7YNVNS',NULL),(1,32,'TQKJLSNAOQMA',NULL),(5,72,'UMIKGGKSBDJF',NULL),(3,49,'UYZWVI5ITTCE',NULL),(4,52,'VKOWBLM9GIQ7',NULL),(5,67,'W6EM21SUGJSM',NULL),(2,43,'XTT2OELCDSNH',NULL),(2,39,'ZDWT2ZLG7M3R',NULL),(4,54,'ZRHR1SR1R7LV',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,11,'Culpa dolor provident velit est aut nemo odio. Quis velit aut quasi.',NULL,0,NULL,NULL),(1,20,'Rerum exercitationem aperiam laborum est. Et et quia ut eos. Velit quos nesciunt reiciendis.',NULL,1,NULL,NULL),(1,14,'Quisquam laborum ratione facere ratione. Aut sunt magni corporis perspiciatis sed. Velit id ea et.',NULL,3,NULL,NULL),(2,29,'Aliquam sit et minima corrupti. Voluptatibus fugit soluta est et.',NULL,0,NULL,NULL),(2,14,'Et et dignissimos inventore qui ut. Unde doloremque non ipsum ea repellendus.',NULL,1,NULL,NULL),(3,31,'Ut adipisci quae aut cupiditate quam doloremque. Id aliquam qui temporibus hic.',NULL,0,NULL,NULL),(3,11,'Et id corporis aut minus. Repudiandae nam id veritatis adipisci error aliquam.',NULL,1,NULL,NULL),(3,18,'Autem ex accusantium labore dolorum doloremque. Perferendis eos alias sit non ipsa consequatur.',NULL,2,NULL,NULL),(3,29,'Dolorum eos ex eum. Iure est fugit distinctio nostrum alias. Et quaerat eaque accusamus officiis.',NULL,3,NULL,NULL),(4,14,'Sed rerum error consequatur minus eos id sapiente. Deserunt repudiandae dolorem vitae odio.',NULL,0,NULL,NULL),(4,25,'Et aliquam vero minima repudiandae. Inventore minus delectus quae ea cumque ipsam.',NULL,1,NULL,NULL),(4,20,'Fugiat velit ipsum quidem culpa vel. Aliquam unde iusto doloribus eligendi et.',NULL,2,NULL,NULL),(4,18,'Expedita optio magnam cumque. Et totam optio id rerum. Sunt quis dolorum tempora.',NULL,3,NULL,NULL),(5,20,'Totam ut molestias fuga. Deserunt odio voluptates et accusamus consequatur mollitia nesciunt eaque.',NULL,0,NULL,NULL),(5,18,'Facilis velit est sapiente aliquid. Perspiciatis et eius error excepturi.',NULL,1,NULL,NULL),(5,10,'Accusantium voluptate quasi et vitae non culpa. Quis nihil consequatur deleniti.',NULL,3,NULL,NULL),(6,25,'Unde corrupti dolorem possimus tempora. Labore quia et pariatur repellat esse rerum.',NULL,0,NULL,NULL),(6,6,'Vero dolores in soluta et. Consequatur nesciunt quis dolorum deserunt qui consequatur.',NULL,2,NULL,NULL),(6,10,'Ab cumque harum non architecto. Aut illo quis dolores omnis.',NULL,3,NULL,NULL),(7,10,'Quis esse amet eius aspernatur at. Odio dolore in ut porro.',NULL,0,NULL,NULL),(7,31,'Id aut rerum quae veritatis aut. Iste optio ullam consequatur modi hic.',NULL,1,NULL,NULL),(7,12,'Odit et sed veritatis similique laboriosam. Eius reprehenderit ut vero unde et iure.',NULL,2,NULL,NULL),(7,11,'A earum molestiae et qui. Sunt earum consectetur illum eaque omnis.',NULL,3,NULL,NULL),(8,6,'Non corrupti error consectetur quo possimus officiis. Autem consequatur inventore nisi rerum.',NULL,0,NULL,NULL),(8,31,'Quia ea laborum quis voluptas sed. Id dolor necessitatibus enim in et delectus delectus.',NULL,1,NULL,NULL),(8,12,'Rerum eum dignissimos assumenda ducimus est. Similique quia et enim reprehenderit sed.',NULL,2,NULL,NULL),(8,27,'In asperiores veritatis fugiat. Qui dolore ipsa earum quam.',NULL,3,NULL,NULL),(9,6,'Ut et est ut. Nostrum alias saepe officiis laborum neque est. Ducimus id dolorem quo nostrum.',NULL,0,NULL,NULL),(9,25,'Est hic ut consequatur. Voluptatem dolore repellendus velit molestiae.',NULL,1,NULL,NULL),(9,10,'Aut ex dolores et aut. Ea est eius et illum et. Qui optio reprehenderit dolore ut quia distinctio.',NULL,2,NULL,NULL),(9,16,'At totam libero est molestiae eum. Quia nostrum hic facere.',NULL,3,NULL,NULL),(10,4,'Qui voluptatibus quis voluptas est et quis quia quaerat. Unde iure at ab eos quisquam ab.',NULL,0,NULL,NULL),(10,10,'Minima ut fuga ea magnam eum molestiae et. Autem quod asperiores delectus ut.',NULL,1,NULL,NULL),(10,12,'Molestiae omnis necessitatibus et error. Odit eum laboriosam fugiat.',NULL,2,NULL,NULL),(10,11,'Minus molestiae possimus consequuntur. Eligendi ea nihil expedita tempora ut. Sit eum sit hic.',NULL,3,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',9,'Dolores doloremque voluptate commodi veniam voluptatem aut.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','3da91be8-16c9-317a-8d8c-886375186fd2','main/events/1.webp',69.45,'94873 Anabel Lodge\nChristophermouth, NM 86560-3196',6,NULL,NULL,'81.489341','19.918788',94,0,'2025-06-10 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(2,'Mobile World Congress',7,'In ut omnis commodi distinctio ab.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','15fc98f5-eef0-3075-a508-15dba547ff36','main/events/2.webp',46.90,'3773 Stroman Manors\nPort Adityaview, RI 74399',6,NULL,NULL,'71.987582','-118.522875',88,0,'2025-06-10 09:00:00','2025-06-24 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(3,'Google I/O',13,'Voluptatum enim dolore iste ut.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','32edd586-113b-38aa-b23d-ebbb246f07f4','main/events/3.webp',87.24,'517 Lorna Burg\nJorgeside, KS 26974',5,5,5,'32.870118','-158.595088',58,0,'2025-06-10 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(4,'Apple WWDC',21,'Ab est dolor qui eligendi enim saepe est.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','ed2fa0b3-b924-3d66-baca-548080555f80','main/events/4.webp',16.16,'24984 Jacinto Drive\nDellbury, IL 79493-5741',3,NULL,NULL,'-46.370555','-56.570023',84,0,'2025-06-10 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(5,'AWS re:Invent',30,'Maiores laborum in qui possimus.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','208dfbf6-203f-35ed-b4a3-67117ff95a83','main/events/5.webp',54.40,'4690 Garrett Rue Apt. 250\nNew Tadbury, TN 46274',2,2,2,'-8.57781','-85.142561',72,0,'2025-06-11 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(6,'Microsoft Build',17,'Ab dolores asperiores aut et nihil id.','Microsoft\'s developer event, introducing new development tools and platforms.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','239b0048-d9ed-3f9d-a631-0384bb0edb45','main/events/6.webp',90.20,'6214 Hoeger Well\nNew Glennie, VA 02254',3,NULL,NULL,'-36.769004','129.692002',82,0,'2025-06-11 09:00:00','2025-06-29 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(7,'Facebook F8',5,'Ut mollitia rerum itaque quia.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','3e869047-47f0-3bf9-af64-67e6d6e90d56','main/events/7.webp',32.99,'18038 Jo Dam Suite 139\nWest Betty, GA 74911-0181',1,6,6,'78.812843','-106.570645',67,0,'2025-06-11 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(8,'GitHub Universe',21,'Ea corporis qui ullam temporibus.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','678d5a7d-002d-37a9-aa47-b4aaa7500045','main/events/8.webp',85.47,'5930 Peggie Rue\nPort Shaynaborough, IL 60238-4018',6,NULL,NULL,'36.137902','-131.670673',58,0,'2025-06-11 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(9,'Game Developers Conference',13,'Blanditiis eum nihil sit et.','The largest conference in the gaming industry, focusing on game development and gaming technology.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','612d9eff-4ba7-37b4-a3bb-60695a9fb40a','main/events/9.webp',47.04,'4122 General Ferry Suite 046\nNorth Kacishire, MA 42666-7691',1,3,3,'-78.31442','-49.372293',82,0,'2025-06-12 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(10,'Web Summit',30,'Odit ipsa qui illum voluptatem quo est possimus.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','be2b78dc-dbb8-36a5-b237-cef4ff6563cf','main/events/10.webp',52.07,'69623 Wolff Junction Suite 798\nEddville, KS 47807-1915',2,2,2,'-82.92786','-178.172884',70,0,'2025-06-12 09:00:00','2025-06-21 18:00:00',NULL,NULL,'approved','2025-06-10 10:45:03','2025-06-10 10:45:03');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Bradley Lindgren - anissa.kunze@yahoo.com','anissa.kunze@yahoo.com','0079907475',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Zachary Bartell - marcelle85@russel.com','marcelle85@russel.com','0866153018',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(3,1,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Cali Emmerich - gsanford@wintheiser.com','gsanford@wintheiser.com','0985765819',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(4,1,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Alfredo Okuneva V - reanna.yundt@conn.com','reanna.yundt@conn.com','0979932764',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(5,2,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Sibyl Green - mariano.barton@hotmail.com','mariano.barton@hotmail.com','0118542777',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Ashton Weissnat - yasmine58@aufderhar.com','yasmine58@aufderhar.com','0768598729',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Karolann Kiehn I - janie.mann@yahoo.com','janie.mann@yahoo.com','0010213829',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(8,2,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Gerhard Kautzer - lily88@gmail.com','lily88@gmail.com','0665713153',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(9,2,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Jameson Waters DDS - quinton.runte@herzog.biz','quinton.runte@herzog.biz','0890258359',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Hugh Jacobs - dangelo10@gmail.com','dangelo10@gmail.com','0480097414',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Miss Asha Labadie V - tfadel@pouros.info','tfadel@pouros.info','0339077566',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Mr. Alek Hermiston PhD - mmaggio@yahoo.com','mmaggio@yahoo.com','0735999260',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(13,4,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Delphine Schmeler - uebert@hotmail.com','uebert@hotmail.com','0338521231',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Kacie Corwin - swift.doris@hagenes.com','swift.doris@hagenes.com','0050729904',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Cornelius Krajcik V - mcclure.beau@botsford.com','mcclure.beau@botsford.com','0014608133',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Dominic Weber - gutkowski.cornell@gmail.com','gutkowski.cornell@gmail.com','0646404296',1,69.45,69.45,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Mr. Curt Durgan Sr. - trent.terry@beahan.net','trent.terry@beahan.net','0978544235',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Nathanial Lakin - wledner@gmail.com','wledner@gmail.com','0223305512',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(19,6,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Judson Yost - riley82@yahoo.com','riley82@yahoo.com','0759408744',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Destany Hand - javon.fahey@gmail.com','javon.fahey@gmail.com','0929191701',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Mrs. Carmela Yundt - uanderson@dickens.net','uanderson@dickens.net','0829460123',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Dr. Hannah Prohaska - wgoodwin@hotmail.com','wgoodwin@hotmail.com','0432918722',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(23,7,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Prof. Kade Mante III - mcasper@hotmail.com','mcasper@hotmail.com','0999830137',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(24,7,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Corbin Heidenreich - myrtice82@schamberger.com','myrtice82@schamberger.com','0480645253',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(25,7,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Devon Bailey - junius36@hotmail.com','junius36@hotmail.com','0807784087',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(26,8,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Jeromy Durgan - herman.barrett@braun.com','herman.barrett@braun.com','0400572477',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(27,8,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Ervin Rolfson - wiza.kathryne@hotmail.com','wiza.kathryne@hotmail.com','0215147300',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(28,8,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Lera Schumm - zboncak.alec@rempel.com','zboncak.alec@rempel.com','0341167893',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(29,9,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Shanna Langosh - mjohnston@schultz.com','mjohnston@schultz.com','0949405814',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(30,9,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Wellington Sauer - ibayer@zulauf.com','ibayer@zulauf.com','0316210185',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(31,10,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Roberta VonRueden - brock31@schaefer.org','brock31@schaefer.org','0039091499',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(32,10,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Dr. Gay Will MD - tod.johnston@hotmail.com','tod.johnston@hotmail.com','0219201912',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(33,10,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Tyrel Zieme IV - santos81@terry.com','santos81@terry.com','0051029660',1,69.45,69.45,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(34,11,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'Mobile World Congress - Arjun Hodkiewicz - sherman@hotmail.com','sherman@hotmail.com','0262497406',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(35,11,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'Mobile World Congress - Flavie Schumm IV - howell.fern@yahoo.com','howell.fern@yahoo.com','0985312904',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(36,11,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'Mobile World Congress - Clifford O\'Connell - ndickinson@hotmail.com','ndickinson@hotmail.com','0464177456',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(37,12,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'Mobile World Congress - Frankie Auer IV - bria.eichmann@lehner.info','bria.eichmann@lehner.info','0137043285',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(38,12,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'Mobile World Congress - Gladyce Kshlerin - dhermann@mante.com','dhermann@mante.com','0657302099',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(39,12,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'Mobile World Congress - Oliver Gleichner - tharris@gmail.com','tharris@gmail.com','0786076207',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(40,12,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'Mobile World Congress - Carlo Lesch - lyric66@nitzsche.com','lyric66@nitzsche.com','0886938727',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(41,12,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'Mobile World Congress - Prof. Trey Nienow III - lavern40@spencer.com','lavern40@spencer.com','0965972141',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(42,12,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'Mobile World Congress - Dr. Dominic Schuster Sr. - oherman@gmail.com','oherman@gmail.com','0028029462',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(43,13,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Damien Braun - qmann@yahoo.com','qmann@yahoo.com','0732548720',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(44,13,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Shemar Tillman - frances33@conn.com','frances33@conn.com','0945645273',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(45,13,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Beulah Crona - canderson@daugherty.com','canderson@daugherty.com','0467866990',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(46,14,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Dora Walter - felton83@lehner.biz','felton83@lehner.biz','0946630182',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(47,14,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Mr. Pete Medhurst - lafayette.balistreri@osinski.com','lafayette.balistreri@osinski.com','0585139088',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(48,14,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Dr. Marlen Paucek IV - xhand@schuster.com','xhand@schuster.com','0103353228',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(49,14,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Piper Heidenreich - etha.flatley@hotmail.com','etha.flatley@hotmail.com','0437551566',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(50,14,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Jorge Wiegand - mathew.hermiston@yahoo.com','mathew.hermiston@yahoo.com','0138512358',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(51,14,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Keenan Pfeffer - jett.kulas@hotmail.com','jett.kulas@hotmail.com','0924551391',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(52,15,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Mrs. Jaqueline Ziemann MD - jazlyn53@yahoo.com','jazlyn53@yahoo.com','0982825897',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(53,15,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Archibald Aufderhar - genesis.paucek@gmail.com','genesis.paucek@gmail.com','0215663826',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(54,15,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Natasha Reynolds PhD - alena25@gmail.com','alena25@gmail.com','0545001565',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(55,15,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Kamron Halvorson - victor51@gmail.com','victor51@gmail.com','0886182225',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(56,16,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Verdie Friesen DVM - lhoppe@gmail.com','lhoppe@gmail.com','0590944043',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(57,16,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Mr. Jovanny Okuneva - lexie29@gmail.com','lexie29@gmail.com','0221271065',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(58,16,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Prof. Braeden Mante Jr. - veum.javonte@rosenbaum.net','veum.javonte@rosenbaum.net','0964147377',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(59,16,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Mr. Bruce Stroman Jr. - dleannon@hotmail.com','dleannon@hotmail.com','0109845686',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(60,16,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Grant Rolfson - tnolan@yahoo.com','tnolan@yahoo.com','0013508547',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(61,17,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Dr. Matt Bartell DVM - christopher.stroman@langosh.com','christopher.stroman@langosh.com','0929841270',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(62,17,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Dr. Hilma Bergnaum MD - hkozey@pollich.com','hkozey@pollich.com','0751135270',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(63,18,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Sydnee Ritchie - rogers.cummerata@gaylord.com','rogers.cummerata@gaylord.com','0025527961',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(64,18,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Ashlee Miller - dale.wintheiser@cole.info','dale.wintheiser@cole.info','0949767635',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(65,18,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Wilmer Abshire - xwisoky@hotmail.com','xwisoky@hotmail.com','0168356261',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(66,18,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Ms. Ada Brakus MD - nathan23@yahoo.com','nathan23@yahoo.com','0450525346',1,46.90,46.90,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(67,19,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Berta Beer - cooper.bernier@hotmail.com','cooper.bernier@hotmail.com','0918165027',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(68,19,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Maegan Collier - wayne10@gmail.com','wayne10@gmail.com','0450882776',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(69,19,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Marion Adams - mccullough.millie@hagenes.info','mccullough.millie@hagenes.info','0989025779',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(70,19,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Ms. Bryana Klocko III - verna11@dach.info','verna11@dach.info','0186005440',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(71,19,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Rita Ebert - forest.zemlak@gmail.com','forest.zemlak@gmail.com','0834634608',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(72,20,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Mrs. Trinity Cole III - ivy36@hilpert.com','ivy36@hilpert.com','0061532127',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(73,20,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Silas Klein - rosa.gorczany@bode.info','rosa.gorczany@bode.info','0544010270',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(74,20,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Prof. Shana Gleason - vallie.zemlak@hotmail.com','vallie.zemlak@hotmail.com','0097998373',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(75,20,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Joanie Bergstrom - adam.jerde@gmail.com','adam.jerde@gmail.com','0052308104',1,46.90,46.90,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(76,21,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Google I/O - Mathias Gleason - bbatz@spinka.info','bbatz@spinka.info','0793962897',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(77,21,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Google I/O - Katlyn Kunde I - cummerata.kyler@gmail.com','cummerata.kyler@gmail.com','0956751838',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(78,21,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Google I/O - Lew Rath - jacinthe.walter@schaden.net','jacinthe.walter@schaden.net','0880159810',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(79,21,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Google I/O - Adell McKenzie DDS - blick.mellie@mayer.org','blick.mellie@mayer.org','0766549406',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(80,21,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Google I/O - Astrid Rosenbaum - sgoyette@yahoo.com','sgoyette@yahoo.com','0528859956',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(81,21,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Google I/O - Mr. Emmet Watsica - bertram.balistreri@purdy.com','bertram.balistreri@purdy.com','0304742169',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(82,22,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Google I/O - Charlotte Quigley - jailyn.bode@hotmail.com','jailyn.bode@hotmail.com','0698967082',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(83,22,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Google I/O - Sim Herzog - khegmann@hotmail.com','khegmann@hotmail.com','0971017891',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(84,22,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Google I/O - Thora Jacobi - mweissnat@yahoo.com','mweissnat@yahoo.com','0506768581',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(85,22,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Ms. Queenie Crona - mborer@hotmail.com','mborer@hotmail.com','0070251826',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(86,22,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Dr. Brad Jacobson MD - jevon.mertz@yahoo.com','jevon.mertz@yahoo.com','0054204034',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(87,22,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Junior Hane MD - urban07@gmail.com','urban07@gmail.com','0620458521',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(88,23,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Jacinthe Huels II - marisa04@senger.info','marisa04@senger.info','0356939571',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(89,23,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Quinn Ruecker - jordane32@gusikowski.com','jordane32@gusikowski.com','0224015407',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(90,23,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Dorthy Roob - vwitting@harvey.com','vwitting@harvey.com','0366352940',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(91,23,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Jamison Nitzsche - dorothy.maggio@rau.org','dorothy.maggio@rau.org','0289825035',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(92,23,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Prof. Faye Feest Sr. - jackeline10@halvorson.com','jackeline10@halvorson.com','0547973090',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(93,23,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Prof. Weldon Ritchie V - gparker@thiel.com','gparker@thiel.com','0202336410',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(94,24,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Ms. Haven Stark II - spfeffer@yahoo.com','spfeffer@yahoo.com','0560716619',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(95,24,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Vance Beatty - elody.nicolas@gmail.com','elody.nicolas@gmail.com','0883794484',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(96,25,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Hermina Hermann - ceffertz@yahoo.com','ceffertz@yahoo.com','0832043582',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(97,25,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Dr. Darius Rodriguez I - freda.donnelly@yahoo.com','freda.donnelly@yahoo.com','0883224550',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(98,25,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Birdie West II - ghuel@gmail.com','ghuel@gmail.com','0717059092',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(99,25,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Prof. Reyes Labadie MD - selena62@gmail.com','selena62@gmail.com','0175300451',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(100,25,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Carolyn Schiller - dickinson.bernadine@hotmail.com','dickinson.bernadine@hotmail.com','0444627310',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(101,26,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Effie Cummerata - windler.elian@gmail.com','windler.elian@gmail.com','0489567427',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(102,26,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Lafayette Treutel - vance.eichmann@hotmail.com','vance.eichmann@hotmail.com','0723367774',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(103,27,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Prof. Walton Beier DDS - casper.ida@king.info','casper.ida@king.info','0707399418',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(104,27,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Mr. Johan Haley I - torp.elouise@hotmail.com','torp.elouise@hotmail.com','0758552082',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(105,28,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Fredy Emmerich - deon52@bauch.com','deon52@bauch.com','0785197944',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(106,28,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Mackenzie Kuvalis PhD - douglas64@nikolaus.com','douglas64@nikolaus.com','0720232365',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(107,28,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Dr. Mohamed Mraz - orville.donnelly@ryan.info','orville.donnelly@ryan.info','0443745280',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(108,29,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Dr. Elvera Ledner - maude.goodwin@schaden.org','maude.goodwin@schaden.org','0524830185',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(109,29,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Jerel Boyle - elizabeth51@ledner.com','elizabeth51@ledner.com','0703451748',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(110,30,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Colt Lesch - hosea.johnson@gmail.com','hosea.johnson@gmail.com','0245522273',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(111,30,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Miss Pansy Ankunding - gcarter@gmail.com','gcarter@gmail.com','0986867777',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(112,30,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Paula Sipes - vrolfson@lehner.com','vrolfson@lehner.com','0740048398',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(113,30,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Cody Harber - cassandra90@hotmail.com','cassandra90@hotmail.com','0022578167',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(114,30,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Katelynn Conroy - edward03@hotmail.com','edward03@hotmail.com','0564065022',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(115,30,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Clifford Fay - roslyn.armstrong@reichert.org','roslyn.armstrong@reichert.org','0437225508',1,87.24,87.24,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(116,31,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Apple WWDC - Janessa Koss DVM - imani29@yahoo.com','imani29@yahoo.com','0015051251',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(117,31,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Apple WWDC - Schuyler Nienow - ally51@mclaughlin.com','ally51@mclaughlin.com','0452843970',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(118,31,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Apple WWDC - Prof. Isabel Huel IV - lthiel@yahoo.com','lthiel@yahoo.com','0011280490',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(119,31,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Apple WWDC - Yazmin Mayer - aurelie86@yahoo.com','aurelie86@yahoo.com','0351631526',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(120,31,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Apple WWDC - Kavon Lueilwitz - addie21@nicolas.com','addie21@nicolas.com','0849774965',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(121,31,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Apple WWDC - Ms. Wendy Hoeger - carmelo43@lubowitz.info','carmelo43@lubowitz.info','0282326814',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(122,32,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Apple WWDC - Marcus Wisoky - scrooks@gleichner.com','scrooks@gleichner.com','0488690349',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(123,32,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Apple WWDC - Vernice Kris - oren61@grimes.net','oren61@grimes.net','0332740560',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(124,32,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Apple WWDC - Lucile Boyer - cmedhurst@murphy.biz','cmedhurst@murphy.biz','0429383090',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(125,32,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Nikko Lynch - dereck.armstrong@hotmail.com','dereck.armstrong@hotmail.com','0648079428',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(126,32,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Vivianne Jones - belle23@hotmail.com','belle23@hotmail.com','0020214995',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(127,32,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Mercedes Gaylord - bogan.corbin@torphy.com','bogan.corbin@torphy.com','0480027369',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(128,33,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Bettye Witting - wisoky.pearl@gmail.com','wisoky.pearl@gmail.com','0845479686',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(129,33,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Loma Ferry - antonette03@doyle.biz','antonette03@doyle.biz','0538118955',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(130,33,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Douglas Rogahn - dayana.turcotte@yahoo.com','dayana.turcotte@yahoo.com','0906649216',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(131,34,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Josefina Kuhic - evandervort@yahoo.com','evandervort@yahoo.com','0304925498',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(132,34,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Margot Simonis - tcollins@dach.biz','tcollins@dach.biz','0800926907',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(133,34,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Rodrick Kiehn - shad.nikolaus@gmail.com','shad.nikolaus@gmail.com','0210036297',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(134,34,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Shawn Kassulke - whickle@gmail.com','whickle@gmail.com','0880761287',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(135,35,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Dejuan Yundt - jabari.gislason@sawayn.net','jabari.gislason@sawayn.net','0887241846',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(136,35,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Ms. Alanis Konopelski - curt72@schaden.org','curt72@schaden.org','0366083548',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(137,35,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Prof. Madelynn Bosco III - swift.jules@yahoo.com','swift.jules@yahoo.com','0272936636',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(138,36,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Rollin Kuphal - armstrong.callie@hotmail.com','armstrong.callie@hotmail.com','0915941677',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(139,36,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Jenifer Gutmann - ova75@connelly.com','ova75@connelly.com','0835082613',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(140,36,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Prof. Madison Langosh - ohammes@lakin.net','ohammes@lakin.net','0829268965',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(141,37,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Prof. Alayna Paucek - breanne04@hotmail.com','breanne04@hotmail.com','0461498419',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(142,37,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Bethany Miller - bbartell@gmail.com','bbartell@gmail.com','0048278917',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(143,37,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Jovan Tremblay - nelson94@gmail.com','nelson94@gmail.com','0942175005',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(144,38,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Lempi McLaughlin - bill64@gleason.com','bill64@gleason.com','0447079339',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(145,38,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Haylie Bahringer - issac.renner@yahoo.com','issac.renner@yahoo.com','0117039660',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(146,38,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Dr. Ephraim Klein - russell.cummings@yahoo.com','russell.cummings@yahoo.com','0548215070',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(147,38,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Adrian Reilly - mann.demarcus@yahoo.com','mann.demarcus@yahoo.com','0259004902',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(148,38,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Ila McCullough II - dedric25@bradtke.com','dedric25@bradtke.com','0377739568',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(149,39,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Brionna Jerde - ethel87@kunze.com','ethel87@kunze.com','0954644256',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(150,39,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Colton Smitham - melba98@gmail.com','melba98@gmail.com','0167383367',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(151,39,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Danial Douglas - lind.brandy@gmail.com','lind.brandy@gmail.com','0911958789',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(152,39,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Amiya Blanda - candace.prohaska@yahoo.com','candace.prohaska@yahoo.com','0336088937',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(153,40,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Golda Stokes II - felicia74@hotmail.com','felicia74@hotmail.com','0606316763',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(154,40,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Lamont Dach - kward@jenkins.com','kward@jenkins.com','0665383855',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(155,40,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Kristin Huel - hilbert49@smith.com','hilbert49@smith.com','0151437313',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(156,40,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Enid Pfeffer - hwillms@metz.com','hwillms@metz.com','0161753321',1,16.16,16.16,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(157,41,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'AWS re:Invent - Rosalyn Oberbrunner - ptorp@gmail.com','ptorp@gmail.com','0437109626',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(158,41,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'AWS re:Invent - Tito Ziemann - merritt42@rau.info','merritt42@rau.info','0111160072',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(159,42,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'AWS re:Invent - Christiana Lemke - trycia.russel@leffler.com','trycia.russel@leffler.com','0316886258',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(160,42,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'AWS re:Invent - Jena Adams - darrel.casper@hotmail.com','darrel.casper@hotmail.com','0900327885',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(161,42,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'AWS re:Invent - Miss Idella Murray DVM - waldo65@gmail.com','waldo65@gmail.com','0581575156',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(162,42,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Kelton Kshlerin IV - xbarton@yahoo.com','xbarton@yahoo.com','0919584393',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(163,42,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Fay Boyle - greenholt.gage@hotmail.com','greenholt.gage@hotmail.com','0348028011',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(164,43,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Kayla Cronin - hreilly@hotmail.com','hreilly@hotmail.com','0619091756',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(165,43,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Kelsie Crist IV - wjerde@hotmail.com','wjerde@hotmail.com','0077628718',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(166,43,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Gerda Stiedemann - ethyl05@roberts.net','ethyl05@roberts.net','0112641647',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(167,43,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Meggie Gibson I - geovanni24@jacobi.com','geovanni24@jacobi.com','0918697436',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(168,43,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Dr. Dusty Schneider V - ovolkman@bradtke.org','ovolkman@bradtke.org','0662306283',1,54.40,54.40,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(169,44,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Joanny Pollich - fbradtke@prohaska.com','fbradtke@prohaska.com','0193903439',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(170,44,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Dr. Ruthe Carroll - jmills@hotmail.com','jmills@hotmail.com','0452301563',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(171,44,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Phyllis Mann - dominique65@hotmail.com','dominique65@hotmail.com','0960845515',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(172,44,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Florine Little - tjones@hotmail.com','tjones@hotmail.com','0211531751',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(173,44,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Ed Marquardt - may.spencer@gmail.com','may.spencer@gmail.com','0919098019',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(174,44,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Ms. Karen Waters - isabelle34@gmail.com','isabelle34@gmail.com','0246777381',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(175,45,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Deangelo Beahan III - ignacio.kertzmann@hotmail.com','ignacio.kertzmann@hotmail.com','0776148203',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(176,45,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Prof. Kimberly Torphy - stiedemann.dianna@hotmail.com','stiedemann.dianna@hotmail.com','0317510572',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(177,45,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Shad Heidenreich - pacocha.rhianna@gmail.com','pacocha.rhianna@gmail.com','0466810688',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(178,45,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Mr. Toni Cummings II - kayla.auer@ferry.com','kayla.auer@ferry.com','0006284245',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(179,45,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Jena Abernathy - khalid.parisian@runte.net','khalid.parisian@runte.net','0141954662',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(180,45,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Jeanne Feest DDS - mdare@bednar.info','mdare@bednar.info','0082267958',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(181,46,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Prof. Marcus Farrell - spinka.lupe@mertz.com','spinka.lupe@mertz.com','0175480151',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(182,46,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Geovanny Douglas - maryse32@lang.com','maryse32@lang.com','0637089405',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(183,46,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Bobby Towne - hstracke@moore.com','hstracke@moore.com','0622250061',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(184,47,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Jamarcus Larkin - adenesik@gmail.com','adenesik@gmail.com','0117643018',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(185,47,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Vilma Torphy - karson.langworth@pagac.biz','karson.langworth@pagac.biz','0458998686',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(186,47,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Leslie Hessel MD - lbosco@yahoo.com','lbosco@yahoo.com','0957164637',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(187,48,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Lelia Shanahan - orlando64@hotmail.com','orlando64@hotmail.com','0299926158',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(188,48,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Winifred Runte - kelli39@tromp.com','kelli39@tromp.com','0298687780',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(189,48,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Prof. Enrique Fadel - ncarroll@yahoo.com','ncarroll@yahoo.com','0851608454',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(190,48,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Dortha Nikolaus - kamron99@kassulke.biz','kamron99@kassulke.biz','0664951352',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(191,48,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Monique Feil - glen61@yahoo.com','glen61@yahoo.com','0212708000',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(192,48,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Prof. Jasen Herzog II - bethel.hilpert@feil.org','bethel.hilpert@feil.org','0619824489',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(193,49,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Gladyce Runolfsdottir - pjenkins@gmail.com','pjenkins@gmail.com','0171186718',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(194,49,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Mrs. Sierra Bailey - ifranecki@gmail.com','ifranecki@gmail.com','0146124112',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(195,49,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Jairo Davis - merle86@gmail.com','merle86@gmail.com','0362923261',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(196,50,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Abigayle Yost III - cjohns@hotmail.com','cjohns@hotmail.com','0888912154',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(197,50,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Gordon Smith - kovacek.horacio@carroll.com','kovacek.horacio@carroll.com','0281230852',1,54.40,54.40,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',69.45,'CES (Consumer Electronics Show)','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',208.35,208.35,0.00,0.00,NULL,1,'completed','2025-06-10 10:45:03','2025-06-10 10:45:03','2025-06-10 10:45:03'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',69.45,'CES (Consumer Electronics Show)','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',277.80,277.80,0.00,0.00,NULL,2,'completed','2025-06-10 10:45:03','2025-06-10 10:45:03','2025-06-10 10:45:03'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',69.45,'CES (Consumer Electronics Show)','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',138.90,138.90,0.00,0.00,NULL,3,'completed','2025-06-10 10:45:03','2025-06-10 10:45:03','2025-06-10 10:45:03'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',69.45,'CES (Consumer Electronics Show)','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',208.35,208.35,0.00,0.00,NULL,4,'completed','2025-06-10 10:45:03','2025-06-10 10:45:03','2025-06-10 10:45:03'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',69.45,'CES (Consumer Electronics Show)','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',69.45,69.45,0.00,0.00,NULL,5,'completed','2025-06-10 10:45:03','2025-06-10 10:45:03','2025-06-10 10:45:03'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',69.45,'CES (Consumer Electronics Show)','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',208.35,208.35,0.00,0.00,NULL,6,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',69.45,'CES (Consumer Electronics Show)','Bernard Kuhn','cgrant@dare.com',NULL,'ArchiElite','main/general/logo-light.png',138.90,138.90,0.00,0.00,NULL,7,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',69.45,'CES (Consumer Electronics Show)','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',138.90,138.90,0.00,0.00,NULL,8,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',69.45,'CES (Consumer Electronics Show)','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',69.45,69.45,0.00,0.00,NULL,9,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',69.45,'CES (Consumer Electronics Show)','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',138.90,138.90,0.00,0.00,NULL,10,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',46.90,'Mobile World Congress','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',93.80,93.80,0.00,0.00,NULL,11,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',46.90,'Mobile World Congress','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',234.50,234.50,0.00,0.00,NULL,12,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',46.90,'Mobile World Congress','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',93.80,93.80,0.00,0.00,NULL,13,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',46.90,'Mobile World Congress','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',234.50,234.50,0.00,0.00,NULL,14,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',46.90,'Mobile World Congress','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',140.70,140.70,0.00,0.00,NULL,15,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',46.90,'Mobile World Congress','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',187.60,187.60,0.00,0.00,NULL,16,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',46.90,'Mobile World Congress','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',46.90,46.90,0.00,0.00,NULL,17,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',46.90,'Mobile World Congress','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',140.70,140.70,0.00,0.00,NULL,18,'completed','2025-06-10 10:45:04','2025-06-10 10:45:04','2025-06-10 10:45:04'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',46.90,'Mobile World Congress','Bernard Kuhn','cgrant@dare.com',NULL,'ArchiElite','main/general/logo-light.png',187.60,187.60,0.00,0.00,NULL,19,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',46.90,'Mobile World Congress','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',140.70,140.70,0.00,0.00,NULL,20,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',87.24,'Google I/O','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',436.20,436.20,0.00,0.00,NULL,21,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',87.24,'Google I/O','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',436.20,436.20,0.00,0.00,NULL,22,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',87.24,'Google I/O','Max Hansen','mcassin@pouros.com',NULL,'ArchiElite','main/general/logo-light.png',436.20,436.20,0.00,0.00,NULL,23,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',87.24,'Google I/O','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',87.24,87.24,0.00,0.00,NULL,24,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',87.24,'Google I/O','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',348.96,348.96,0.00,0.00,NULL,25,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',87.24,'Google I/O','Max Hansen','mcassin@pouros.com',NULL,'ArchiElite','main/general/logo-light.png',87.24,87.24,0.00,0.00,NULL,26,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',87.24,'Google I/O','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',87.24,87.24,0.00,0.00,NULL,27,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',87.24,'Google I/O','Bernard Kuhn','cgrant@dare.com',NULL,'ArchiElite','main/general/logo-light.png',174.48,174.48,0.00,0.00,NULL,28,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',87.24,'Google I/O','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',87.24,87.24,0.00,0.00,NULL,29,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',87.24,'Google I/O','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',436.20,436.20,0.00,0.00,NULL,30,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:05'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',16.16,'Apple WWDC','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',80.80,80.80,0.00,0.00,NULL,31,'completed','2025-06-10 10:45:05','2025-06-10 10:45:05','2025-06-10 10:45:06'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',16.16,'Apple WWDC','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',80.80,80.80,0.00,0.00,NULL,32,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',16.16,'Apple WWDC','Max Hansen','mcassin@pouros.com',NULL,'ArchiElite','main/general/logo-light.png',32.32,32.32,0.00,0.00,NULL,33,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',16.16,'Apple WWDC','Max Hansen','mcassin@pouros.com',NULL,'ArchiElite','main/general/logo-light.png',48.48,48.48,0.00,0.00,NULL,34,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',16.16,'Apple WWDC','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',32.32,32.32,0.00,0.00,NULL,35,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',16.16,'Apple WWDC','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',32.32,32.32,0.00,0.00,NULL,36,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',16.16,'Apple WWDC','Dr. Stephania Becker','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',32.32,32.32,0.00,0.00,NULL,37,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',16.16,'Apple WWDC','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',64.64,64.64,0.00,0.00,NULL,38,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',16.16,'Apple WWDC','Max Hansen','mcassin@pouros.com',NULL,'ArchiElite','main/general/logo-light.png',48.48,48.48,0.00,0.00,NULL,39,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',16.16,'Apple WWDC','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',48.48,48.48,0.00,0.00,NULL,40,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',54.40,'AWS re:Invent','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',54.40,54.40,0.00,0.00,NULL,41,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',54.40,'AWS re:Invent','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',217.60,217.60,0.00,0.00,NULL,42,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',54.40,'AWS re:Invent','Dr. Garry Ankunding','beulah.haley@kilback.com',NULL,'ArchiElite','main/general/logo-light.png',217.60,217.60,0.00,0.00,NULL,43,'completed','2025-06-10 10:45:06','2025-06-10 10:45:06','2025-06-10 10:45:06'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',54.40,'AWS re:Invent','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',272.00,272.00,0.00,0.00,NULL,44,'completed','2025-06-10 10:45:07','2025-06-10 10:45:06','2025-06-10 10:45:07'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',54.40,'AWS re:Invent','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',272.00,272.00,0.00,0.00,NULL,45,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',54.40,'AWS re:Invent','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',108.80,108.80,0.00,0.00,NULL,46,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',54.40,'AWS re:Invent','Rosella Kuhn','frances44@schroeder.net',NULL,'ArchiElite','main/general/logo-light.png',108.80,108.80,0.00,0.00,NULL,47,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',54.40,'AWS re:Invent','Dakota Rice','rowe.baylee@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',272.00,272.00,0.00,0.00,NULL,48,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',54.40,'AWS re:Invent','Keegan Toy','trutherford@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',108.80,108.80,0.00,0.00,NULL,49,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',54.40,'AWS re:Invent','Bernard Kuhn','cgrant@dare.com',NULL,'ArchiElite','main/general/logo-light.png',54.40,54.40,0.00,0.00,NULL,50,'completed','2025-06-10 10:45:07','2025-06-10 10:45:07','2025-06-10 10:45:07');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'4WHGQ85F4XOA','74e1b933-74ab-4a51-8b12-99fcde6ca177',1,'CES (Consumer Electronics Show)',69.45,1,1,'Dr. Stephania Becker','customer@archielite.com','I did: there\'s no meaning in it,\' but none of them bowed low. \'Would you like the look of the.',NULL,'1',69.45,3,208.35,208.35,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(2,'XXMS3FRQKOBJ','35e29d03-3d75-477a-9d32-2d0fbf1e03b4',1,'CES (Consumer Electronics Show)',69.45,26,1,'Keegan Toy','trutherford@yahoo.com','Mock Turtle went on, \'you throw the--\' \'The lobsters!\' shouted the Queen was to get through was.',NULL,'2',69.45,4,277.80,277.80,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(3,'3YZWKJKXSJOL','4d3b1316-7500-45d7-92a7-0ca7d499b197',1,'CES (Consumer Electronics Show)',69.45,26,1,'Keegan Toy','trutherford@yahoo.com','Rabbit noticed Alice, as she went on, taking first one side and then said, \'It WAS a narrow.',NULL,'3',69.45,2,138.90,138.90,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(4,'8IORAM9XKMRG','9990dde1-4fe6-47fb-8574-3cf290ab8238',1,'CES (Consumer Electronics Show)',69.45,3,1,'Dakota Rice','rowe.baylee@yahoo.com','The table was a treacle-well.\' \'There\'s no such thing!\' Alice was just saying to herself \'It\'s the.',NULL,'4',69.45,3,208.35,208.35,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(5,'0XGVFMBF0FHK','00279172-4ca4-4d83-92f8-fe4a905c5761',1,'CES (Consumer Electronics Show)',69.45,26,1,'Keegan Toy','trutherford@yahoo.com','WAS a curious croquet-ground in her pocket, and was just going to do with you. Mind now!\' The poor.',NULL,'5',69.45,1,69.45,69.45,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03'),(6,'WEULY2YAYXEC','b4b1f194-902d-4ea3-b5d9-c7c4fad04834',1,'CES (Consumer Electronics Show)',69.45,28,1,'Rosella Kuhn','frances44@schroeder.net','THAT. Then again--\"BEFORE SHE HAD THIS FIT--\" you never had fits, my dear, and that in about half.',NULL,'6',69.45,3,208.35,208.35,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(7,'EH9H312UZWDP','016f4b05-0d2b-460e-8b57-09ca50f2fe1c',1,'CES (Consumer Electronics Show)',69.45,8,1,'Bernard Kuhn','cgrant@dare.com','There was no \'One, two, three, and away,\' but they all quarrel so dreadfully one can\'t hear.',NULL,'7',69.45,2,138.90,138.90,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(8,'IORCVCCGTX1Y','b59d24c3-b747-4ddb-855b-be90744faa19',1,'CES (Consumer Electronics Show)',69.45,26,1,'Keegan Toy','trutherford@yahoo.com','They all sat down with wonder at the top of its mouth, and addressed her in such a pleasant.',NULL,'8',69.45,2,138.90,138.90,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(9,'CHPG0GQTFD0M','78568f09-be50-4591-bdf6-c81289e739d0',1,'CES (Consumer Electronics Show)',69.45,3,1,'Dakota Rice','rowe.baylee@yahoo.com','ARE you doing out here? Run home this moment, I tell you, you coward!\' and at last she spread out.',NULL,'9',69.45,1,69.45,69.45,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(10,'E9KMTD0QBYJJ','cef93722-6208-4e84-a6a9-2bc1429d7da9',1,'CES (Consumer Electronics Show)',69.45,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','Half-past one, time for dinner!\' (\'I only wish people knew that: then they both cried. \'Wake up.',NULL,'10',69.45,2,138.90,138.90,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(11,'YIYPLBI8KYH9','72331e9e-da70-4452-8987-513c1f51036f',2,'Mobile World Congress',46.90,1,1,'Dr. Stephania Becker','customer@archielite.com','And she began fancying the sort of lullaby to it in less than a pig, and she felt a violent shake.',NULL,'11',46.90,2,93.80,93.80,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(12,'B6XD0WUHULXV','91751222-cb93-4d15-8634-a823fe71bfbd',2,'Mobile World Congress',46.90,1,1,'Dr. Stephania Becker','customer@archielite.com','Gryphon. \'It\'s all his fancy, that: they never executes nobody, you know. So you see, as they were.',NULL,'12',46.90,5,234.50,234.50,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(13,'CUS2LSMEJGO4','ff99b823-3d5d-4a02-9625-70ae3eda6ef9',2,'Mobile World Congress',46.90,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','Dormouse, not choosing to notice this question, but hurriedly went on, \'What HAVE you been doing.',NULL,'13',46.90,2,93.80,93.80,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(14,'IYWTYEO3DRMR','0ecaa6a2-a64b-4404-8b76-55cfce876804',2,'Mobile World Congress',46.90,28,1,'Rosella Kuhn','frances44@schroeder.net','YOUR shoes done with?\' said the voice. \'Fetch me my gloves this moment!\' Then came a rumbling of.',NULL,'14',46.90,5,234.50,234.50,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(15,'8X6LOOUKSW5I','e60949d4-6280-409a-a77b-ffddfa7f9ae0',2,'Mobile World Congress',46.90,3,1,'Dakota Rice','rowe.baylee@yahoo.com','YOURS: I don\'t like the three gardeners instantly jumped up, and there stood the Queen said--\'.',NULL,'15',46.90,3,140.70,140.70,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(16,'NTB0F77ENNQW','02e2a976-4774-454f-a566-eb8fd11f3a78',2,'Mobile World Congress',46.90,3,1,'Dakota Rice','rowe.baylee@yahoo.com','I BEG your pardon!\' cried Alice again, for really I\'m quite tired and out of its mouth and yawned.',NULL,'16',46.90,4,187.60,187.60,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(17,'NNWYUDB23GFE','20d8ba13-0953-4cd7-92a0-8500f1f62150',2,'Mobile World Congress',46.90,28,1,'Rosella Kuhn','frances44@schroeder.net','The great question certainly was, what? Alice looked at the cook, to see what was the BEST.',NULL,'17',46.90,1,46.90,46.90,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(18,'GI1TBTCPRJ4F','0783eb63-5026-47a4-b52d-47c3af8df6d6',2,'Mobile World Congress',46.90,3,1,'Dakota Rice','rowe.baylee@yahoo.com','Soup of the table, but it all came different!\' the Mock Turtle. \'Seals, turtles, salmon, and so.',NULL,'18',46.90,3,140.70,140.70,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04'),(19,'28WIKBGYTQEF','6f62d230-37b4-423d-b59f-f5c3039b318e',2,'Mobile World Congress',46.90,8,1,'Bernard Kuhn','cgrant@dare.com','I\'m NOT a serpent!\' said Alice indignantly, and she looked back once or twice, half hoping that.',NULL,'19',46.90,4,187.60,187.60,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(20,'HGOS7FBVRYQ4','618cc2e8-88f0-4377-9b8e-785e5630b998',2,'Mobile World Congress',46.90,3,1,'Dakota Rice','rowe.baylee@yahoo.com','I like being that person, I\'ll come up: if not, I\'ll stay down here! It\'ll be no sort of use in.',NULL,'20',46.90,3,140.70,140.70,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(21,'NRUALW25A6X9','6edefb46-9ebb-4906-8960-3057f0e9da6a',3,'Google I/O',87.24,1,1,'Dr. Stephania Becker','customer@archielite.com','Queen\'s absence, and were resting in the beautiful garden, among the people that walk with their.',NULL,'21',87.24,5,436.20,436.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(22,'DEYE0DHPTJFC','dffeaba9-6681-4fc6-9b69-c98bd6b2df3c',3,'Google I/O',87.24,28,1,'Rosella Kuhn','frances44@schroeder.net','ARE OLD, FATHER WILLIAM,\"\' said the King said, for about the twentieth time that day. \'No, no!\'.',NULL,'22',87.24,5,436.20,436.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(23,'BEARGJFSVYYX','4b5fab31-ad27-4e22-b16d-2a882471d6b7',3,'Google I/O',87.24,19,1,'Max Hansen','mcassin@pouros.com','I suppose?\' \'Yes,\' said Alice, rather alarmed at the door--I do wish I could show you our cat.',NULL,'23',87.24,5,436.20,436.20,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(24,'UXFIRYK9DG3D','c428145e-a3e4-4b56-bd16-8f96a81174a3',3,'Google I/O',87.24,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','I can do no more, whatever happens. What WILL become of me?\' Luckily for Alice, the little thing.',NULL,'24',87.24,1,87.24,87.24,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(25,'NYYZ1ONMAYVU','9be973c0-7f44-48c3-883e-cd024388d4e1',3,'Google I/O',87.24,28,1,'Rosella Kuhn','frances44@schroeder.net','Hush!\' said the King. \'Nearly two miles high,\' added the Gryphon, \'she wants for to know what to.',NULL,'25',87.24,4,348.96,348.96,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(26,'JWEUQ0YH08ZR','fbbb2b16-87e3-4be0-9ab4-7d9b434c857f',3,'Google I/O',87.24,19,1,'Max Hansen','mcassin@pouros.com','Alice soon came to the other, and growing sometimes taller and sometimes she scolded herself so.',NULL,'26',87.24,1,87.24,87.24,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(27,'3FNNA1NICUK9','6808f5a0-1132-4471-af5a-8b6c37bac1fc',3,'Google I/O',87.24,26,1,'Keegan Toy','trutherford@yahoo.com','Lory. Alice replied in an agony of terror. \'Oh, there goes his PRECIOUS nose\'; as an unusually.',NULL,'27',87.24,1,87.24,87.24,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(28,'ZWM5UIJCD1QU','82bd53fc-8ded-4678-a325-5e944e03d05c',3,'Google I/O',87.24,8,1,'Bernard Kuhn','cgrant@dare.com','And so she waited. The Gryphon lifted up both its paws in surprise. \'What! Never heard of.',NULL,'28',87.24,2,174.48,174.48,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(29,'SN80PB320ZIT','e7b49627-1830-4ea0-b92d-a661a524e339',3,'Google I/O',87.24,1,1,'Dr. Stephania Becker','customer@archielite.com','Christmas.\' And she opened it, and on it (as she had to sing this:-- \'Beautiful Soup, so rich and.',NULL,'29',87.24,1,87.24,87.24,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(30,'PYOPC8CLKENA','5677ea1f-3357-42d3-b790-819ce4d7a1d5',3,'Google I/O',87.24,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','Alice considered a little, and then said, \'It was the first to break the silence. \'What day of the.',NULL,'30',87.24,5,436.20,436.20,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(31,'2ZGPDSOADHZ6','d16ab797-ff51-4be4-8374-70104e77dcc7',4,'Apple WWDC',16.16,28,1,'Rosella Kuhn','frances44@schroeder.net','I shan\'t! YOU do it!--That I won\'t, then!--Bill\'s to go through next walking about at the door--I.',NULL,'31',16.16,5,80.80,80.80,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05'),(32,'BNUYR44KHMCT','10dd7e1a-d2dc-4f1f-9648-19e2f0bf5a83',4,'Apple WWDC',16.16,28,1,'Rosella Kuhn','frances44@schroeder.net','And have grown most uncommonly fat; Yet you balanced an eel on the bank--the birds with draggled.',NULL,'32',16.16,5,80.80,80.80,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(33,'UPRLAI6TQF2M','56181c63-4119-46b4-b948-9e8da854bc87',4,'Apple WWDC',16.16,19,1,'Max Hansen','mcassin@pouros.com','Duchess\'s knee, while plates and dishes crashed around it--once more the shriek of the right-hand.',NULL,'33',16.16,2,32.32,32.32,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(34,'9QMPKYEDLGZF','bdcfd7c7-d026-4add-9b3b-769c48d6ec55',4,'Apple WWDC',16.16,19,1,'Max Hansen','mcassin@pouros.com','Crab, a little house in it a bit, if you were never even introduced to a farmer, you know, as we.',NULL,'34',16.16,3,48.48,48.48,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(35,'4QRCJEDR7CCG','ec799b05-2881-4a2e-ae4b-fdec1842bdfd',4,'Apple WWDC',16.16,28,1,'Rosella Kuhn','frances44@schroeder.net','Rabbit\'s little white kid gloves, and was gone across to the little passage: and THEN--she found.',NULL,'35',16.16,2,32.32,32.32,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(36,'SAJ9KVQMHCOI','ea5ab8a9-1be6-4323-988a-473b23a37ad8',4,'Apple WWDC',16.16,28,1,'Rosella Kuhn','frances44@schroeder.net','O Mouse!\' (Alice thought this a very good height indeed!\' said the King, \'or I\'ll have you.',NULL,'36',16.16,2,32.32,32.32,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(37,'6X8CAX1ENT0U','0c0f1387-792d-4bbd-8769-67d26694c6d6',4,'Apple WWDC',16.16,1,1,'Dr. Stephania Becker','customer@archielite.com','Hatter said, turning to Alice, and she ran across the garden, and marked, with one of the March.',NULL,'37',16.16,2,32.32,32.32,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(38,'8OV8CTUP2L43','544ffe47-23a0-479c-a4e2-2fe6506ea1f7',4,'Apple WWDC',16.16,3,1,'Dakota Rice','rowe.baylee@yahoo.com','Alice. \'You did,\' said the Eaglet. \'I don\'t quite understand you,\' she said, as politely as she.',NULL,'38',16.16,4,64.64,64.64,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(39,'ZFQADDHVJDCZ','d7163794-5d69-43b6-98fa-2efefe620393',4,'Apple WWDC',16.16,19,1,'Max Hansen','mcassin@pouros.com','Presently she began nursing her child again, singing a sort of present!\' thought Alice. One of the.',NULL,'39',16.16,3,48.48,48.48,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(40,'KCPISGEH1N23','1f919e50-8913-463c-9b28-8edc1e7c2b4d',4,'Apple WWDC',16.16,3,1,'Dakota Rice','rowe.baylee@yahoo.com','King. The next thing was waving its tail when it\'s pleased. Now I growl when I\'m pleased, and wag.',NULL,'40',16.16,3,48.48,48.48,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(41,'O2QNBERR4K7B','2ff16f00-a134-450b-b110-2d9a9991cb98',5,'AWS re:Invent',54.40,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','Hatter. Alice felt a very poor speaker,\' said the Mock Turtle. \'And how many miles I\'ve fallen by.',NULL,'41',54.40,1,54.40,54.40,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(42,'RNADFLQTG5XX','894e5403-e514-4be9-8a15-071b513dad97',5,'AWS re:Invent',54.40,3,1,'Dakota Rice','rowe.baylee@yahoo.com','Mouse was swimming away from him, and said to herself, \'to be going messages for a few minutes.',NULL,'42',54.40,4,217.60,217.60,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(43,'69RUXK3MAOQG','0698c10a-5bc3-44b4-a940-b8f3a55ae847',5,'AWS re:Invent',54.40,24,1,'Dr. Garry Ankunding','beulah.haley@kilback.com','These words were followed by a row of lamps hanging from the Gryphon, half to Alice. \'Nothing,\'.',NULL,'43',54.40,4,217.60,217.60,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(44,'XLL9KL2TZUCD','cd848feb-bae4-4a14-bc29-ec5d114293f8',5,'AWS re:Invent',54.40,28,1,'Rosella Kuhn','frances44@schroeder.net','Alice could speak again. In a minute or two, looking for them, but they were gardeners, or.',NULL,'44',54.40,5,272.00,272.00,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06'),(45,'0MLZPTT4SA9K','0b3cb8a6-e632-49df-9f2d-8e450ec04674',5,'AWS re:Invent',54.40,28,1,'Rosella Kuhn','frances44@schroeder.net','King, going up to them to sell,\' the Hatter with a bound into the teapot. \'At any rate a book of.',NULL,'45',54.40,5,272.00,272.00,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(46,'MZWGWLOHN4YJ','4e1ef776-49ab-464d-a704-1c47c82bb0ab',5,'AWS re:Invent',54.40,26,1,'Keegan Toy','trutherford@yahoo.com','I never heard of \"Uglification,\"\' Alice ventured to say. \'What is it?\' Alice panted as she came in.',NULL,'46',54.40,2,108.80,108.80,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(47,'KZZMDBBTLOWU','00b3d476-4027-4556-aa8f-e0b96865aea8',5,'AWS re:Invent',54.40,28,1,'Rosella Kuhn','frances44@schroeder.net','And the moral of that is--\"Birds of a tree in front of them, and just as well be at school at.',NULL,'47',54.40,2,108.80,108.80,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(48,'NGWS0T1QOTED','d2aef6d9-12b4-4626-bb76-e2201fb5e033',5,'AWS re:Invent',54.40,3,1,'Dakota Rice','rowe.baylee@yahoo.com','Some of the March Hare had just upset the week before. \'Oh, I know!\' exclaimed Alice, who was.',NULL,'48',54.40,5,272.00,272.00,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(49,'HKKS3CGYVWZ5','11f7bd92-d28c-4442-b1ca-3db03fbbeac3',5,'AWS re:Invent',54.40,26,1,'Keegan Toy','trutherford@yahoo.com','While the Owl had the dish as its share of the jury asked. \'That I can\'t be civil, you\'d better.',NULL,'49',54.40,2,108.80,108.80,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07'),(50,'S2BO60R7YW50','3d0944b9-673b-43c3-a777-8ef5cf8c008b',5,'AWS re:Invent',54.40,8,1,'Bernard Kuhn','cgrant@dare.com','Alice. \'I mean what I should have liked teaching it tricks very much, if--if I\'d only been the.',NULL,'50',54.40,1,54.40,54.40,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'TQKJLSNAOQMA','Bradley Lindgren','anissa.kunze@yahoo.com','0079907475','Alice called out to the Knave of Hearts, who only bowed and smiled in reply. \'Idiot!\' said the.',NULL,'pending','2025-06-10 10:45:03','2025-06-10 10:45:03'),(2,1,'CYOHOS0DVFEY','Zachary Bartell','marcelle85@russel.com','0866153018','Always lay the blame on others!\' \'YOU\'D better not talk!\' said Five. \'I heard every word you.',NULL,'checked_in','2025-06-10 10:45:03','2025-06-10 10:45:03'),(3,1,'DNSUIYDXBWV7','Cali Emmerich','gsanford@wintheiser.com','0985765819','Alice, that she had quite forgotten the Duchess sang the second time round, she found she had to.',NULL,'cancelled','2025-06-10 10:45:03','2025-06-10 10:45:03'),(4,1,'CQZEVRCOPZY6','Alfredo Okuneva V','reanna.yundt@conn.com','0979932764','Queen merely remarking as it went. So she sat down in a day is very confusing.\' \'It isn\'t,\' said.',NULL,'pending','2025-06-10 10:45:03','2025-06-10 10:45:03'),(5,2,'8JG00LM8QTYE','Sibyl Green','mariano.barton@hotmail.com','0118542777','I must have a prize herself, you know,\' said the Gryphon: and Alice looked at Alice, as the.',NULL,'refunded','2025-06-10 10:45:03','2025-06-10 10:45:03'),(6,2,'5SBAGC2SAU5F','Ashton Weissnat','yasmine58@aufderhar.com','0768598729','Her first idea was that she was now only ten inches high, and she heard something like this.',NULL,'cancelled','2025-06-10 10:45:03','2025-06-10 10:45:03'),(7,2,'MYMHBUPGTYZU','Karolann Kiehn I','janie.mann@yahoo.com','0010213829','DOTH THE LITTLE BUSY BEE,\" but it did not come the same words as before, \'and things are \"much of.',NULL,'transferred','2025-06-10 10:45:03','2025-06-10 10:45:03'),(8,2,'BKHTCZJZY3ZM','Gerhard Kautzer','lily88@gmail.com','0665713153','And the Gryphon replied very politely, \'if I had to stop and untwist it. After a minute or two, it.',NULL,'pending','2025-06-10 10:45:03','2025-06-10 10:45:03'),(9,2,'ARIMVLLQK3KG','Jameson Waters DDS','quinton.runte@herzog.biz','0890258359','For some minutes it puffed away without speaking, but at any rate he might answer questions.--How.',NULL,'purchased','2025-06-10 10:45:03','2025-06-10 10:45:03'),(10,3,'6HPGDHDUHXWB','Hugh Jacobs','dangelo10@gmail.com','0480097414','Mouse, in a very poor speaker,\' said the Mock Turtle went on. \'Would you like the three gardeners.',NULL,'checked_in','2025-06-10 10:45:03','2025-06-10 10:45:03'),(11,3,'XWKJ8YFSMMWQ','Miss Asha Labadie V','tfadel@pouros.info','0339077566','I shall remember it in her lessons in the sea, some children digging in the distance, sitting sad.',NULL,'reserved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(12,3,'ASHCP8MLY3G9','Mr. Alek Hermiston PhD','mmaggio@yahoo.com','0735999260','King said to the law, And argued each case with MINE,\' said the one who had been to a lobster--\'.',NULL,'refunded','2025-06-10 10:45:03','2025-06-10 10:45:03'),(13,4,'VPSYU875CUWB','Delphine Schmeler','uebert@hotmail.com','0338521231','Hatter were having tea at it: a Dormouse was sitting next to no toys to play croquet.\' The.',NULL,'reserved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(14,4,'VPL67XVYEZYP','Kacie Corwin','swift.doris@hagenes.com','0050729904','Rabbit angrily. \'Here! Come and help me out of sight: then it watched the Queen had only one way.',NULL,'checked_in','2025-06-10 10:45:03','2025-06-10 10:45:03'),(15,4,'MBBJXXEHCXMK','Cornelius Krajcik V','mcclure.beau@botsford.com','0014608133','Off with his head!\' or \'Off with her face brightened up again.) \'Please your Majesty,\' he began.',NULL,'cancelled','2025-06-10 10:45:03','2025-06-10 10:45:03'),(16,4,'YKUPHRCLNJH3','Dominic Weber','gutkowski.cornell@gmail.com','0646404296','Dormouse fell asleep instantly, and Alice heard it before,\' said the Knave, \'I didn\'t mean it!\'.',NULL,'checked_in','2025-06-10 10:45:03','2025-06-10 10:45:03'),(17,5,'FW0NYH09TLEO','Mr. Curt Durgan Sr.','trent.terry@beahan.net','0978544235','I have dropped them, I wonder?\' Alice guessed who it was, even before she had put the hookah into.',NULL,'reserved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(18,5,'XUCXTY8A61NJ','Nathanial Lakin','wledner@gmail.com','0223305512','I will prosecute YOU.--Come, I\'ll take no denial; We must have a trial: For really this morning.',NULL,'reserved','2025-06-10 10:45:03','2025-06-10 10:45:03'),(19,6,'YOOFWB8BT2MD','Judson Yost','riley82@yahoo.com','0759408744','Gryphon. \'--you advance twice--\' \'Each with a sigh: \'he taught Laughing and Grief, they used to.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(20,6,'EBHCTKNEISXX','Destany Hand','javon.fahey@gmail.com','0929191701','I suppose?\' said Alice. \'What IS a long hookah, and taking not the same, shedding gallons of.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(21,6,'BLVIARJDTZ02','Mrs. Carmela Yundt','uanderson@dickens.net','0829460123','She was close behind it was over at last, and they sat down, and nobody spoke for some way, and.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(22,6,'A9ZGRXLWXVMM','Dr. Hannah Prohaska','wgoodwin@hotmail.com','0432918722','Dormouse,\' thought Alice; \'but when you come to an end! \'I wonder what they said. The.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(23,7,'RH3XVKRF0DBP','Prof. Kade Mante III','mcasper@hotmail.com','0999830137','However, she soon made out the proper way of expecting nothing but a pack of cards!\' At this.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(24,7,'DKRIHBI5FNIG','Corbin Heidenreich','myrtice82@schamberger.com','0480645253','The King and the other guinea-pig cheered, and was looking down at them, and was going to be, from.',NULL,'reserved','2025-06-10 10:45:04','2025-06-10 10:45:04'),(25,7,'L8HIN0XTUNJY','Devon Bailey','junius36@hotmail.com','0807784087','Alice went on, \'I must be what he did not sneeze, were the cook, and a fan! Quick, now!\' And Alice.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(26,8,'OESOAEIGVOV2','Jeromy Durgan','herman.barrett@braun.com','0400572477','She was a sound of many footsteps, and Alice was not going to begin with.\' \'A barrowful of WHAT?\'.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(27,8,'ARL0ISQMD0KL','Ervin Rolfson','wiza.kathryne@hotmail.com','0215147300','It\'s by far the most important piece of rudeness was more than nine feet high, and her eyes filled.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(28,8,'SFMDH2D4M2QH','Lera Schumm','zboncak.alec@rempel.com','0341167893','The Dormouse again took a great deal too flustered to tell me who YOU are, first.\' \'Why?\' said the.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(29,9,'Y4V0ZFNDIKGB','Shanna Langosh','mjohnston@schultz.com','0949405814','Alice. \'And ever since that,\' the Hatter and the other guinea-pig cheered, and was in March.\' As.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(30,9,'EL5FZXQMR9RT','Wellington Sauer','ibayer@zulauf.com','0316210185','That WILL be a person of authority among them, called out, \'First witness!\' The first question of.',NULL,'reserved','2025-06-10 10:45:04','2025-06-10 10:45:04'),(31,10,'TYGGXATLWSVS','Roberta VonRueden','brock31@schaefer.org','0039091499','Queen. \'Can you play croquet with the dream of Wonderland of long ago: and how she would keep.',NULL,'reserved','2025-06-10 10:45:04','2025-06-10 10:45:04'),(32,10,'QD61FGJSV1EU','Dr. Gay Will MD','tod.johnston@hotmail.com','0219201912','And concluded the banquet--] \'What IS the use of this elegant thimble\'; and, when it had some kind.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(33,10,'HQ9F0KB64UTH','Tyrel Zieme IV','santos81@terry.com','0051029660','RED rose-tree, and we won\'t talk about wasting IT. It\'s HIM.\' \'I don\'t quite understand you,\' she.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(34,11,'RJUA2GEDZ2AU','Arjun Hodkiewicz','sherman@hotmail.com','0262497406','Alice said with some severity; \'it\'s very easy to take MORE than nothing.\' \'Nobody asked YOUR.',NULL,'checked_in','2025-06-10 10:45:04','2025-06-10 10:45:04'),(35,11,'EMYC6LRW2ZJM','Flavie Schumm IV','howell.fern@yahoo.com','0985312904','Footman, and began to say whether the blows hurt it or not. \'Oh, PLEASE mind what you\'re at!\" You.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(36,11,'OZKYSC32NOLB','Clifford O\'Connell','ndickinson@hotmail.com','0464177456','I\'d hardly finished the first to break the silence. \'What day of the house, \"Let us both go to on.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(37,12,'GWFGP0VJA3IU','Frankie Auer IV','bria.eichmann@lehner.info','0137043285','I could shut up like a steam-engine when she was ever to get rather sleepy, and went back for a.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(38,12,'TBDSRVYFNC0Y','Gladyce Kshlerin','dhermann@mante.com','0657302099','I hadn\'t to bring but one; Bill\'s got the other--Bill! fetch it back!\' \'And who is to find that.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(39,12,'DWIEHGMPDEDF','Oliver Gleichner','tharris@gmail.com','0786076207','I could shut up like a serpent. She had already heard her sentence three of the table, but there.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(40,12,'ZDWT2ZLG7M3R','Carlo Lesch','lyric66@nitzsche.com','0886938727','Mock Turtle recovered his voice, and, with tears again as she had forgotten the words.\' So they.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(41,12,'KCNF9SBLHCJB','Prof. Trey Nienow III','lavern40@spencer.com','0965972141','Cat,\' said Alice: \'allow me to introduce it.\' \'I don\'t know much,\' said the Caterpillar took the.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(42,12,'DBDE2W1FHPXN','Dr. Dominic Schuster Sr.','oherman@gmail.com','0028029462','Alice dodged behind a great interest in questions of eating and drinking. \'They lived on treacle,\'.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(43,13,'N6FQVNSFCOOK','Damien Braun','qmann@yahoo.com','0732548720','Queen. \'I never heard before, \'Sure then I\'m here! Digging for apples, indeed!\' said the Duchess.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(44,13,'DIGSUNPSCNMZ','Shemar Tillman','frances33@conn.com','0945645273','But the insolence of his Normans--\" How are you getting on?\' said the Dodo, \'the best way you have.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(45,13,'IKGVZ7Q4GOTP','Beulah Crona','canderson@daugherty.com','0467866990','Now you know.\' It was, no doubt: only Alice did not appear, and after a minute or two, she made.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(46,14,'OZME7VHJSYHG','Dora Walter','felton83@lehner.biz','0946630182','However, this bottle does. I do it again and again.\' \'You are all dry, he is gay as a cushion.',NULL,'checked_in','2025-06-10 10:45:04','2025-06-10 10:45:04'),(47,14,'L2UBROBUXAKT','Mr. Pete Medhurst','lafayette.balistreri@osinski.com','0585139088','Queen, and Alice, were in custody and under sentence of execution. Then the Queen never left off.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(48,14,'J1S8QQ6DOEYB','Dr. Marlen Paucek IV','xhand@schuster.com','0103353228','THEN--she found herself in a low, trembling voice. \'There\'s more evidence to come before that!\'.',NULL,'reserved','2025-06-10 10:45:04','2025-06-10 10:45:04'),(49,14,'QXA5ECOQVQYZ','Piper Heidenreich','etha.flatley@hotmail.com','0437551566','Then it got down off the subjects on his slate with one finger, as he could go. Alice took up the.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(50,14,'ZQQROACKPCJF','Jorge Wiegand','mathew.hermiston@yahoo.com','0138512358','King and Queen of Hearts, and I could shut up like a mouse, That he met in the morning, just time.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(51,14,'HT7QGGWJ3S2U','Keenan Pfeffer','jett.kulas@hotmail.com','0924551391','For this must be off, then!\' said the Mock Turtle, capering wildly about. \'Change lobsters again!\'.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(52,15,'YOV6RJD3ZOWZ','Mrs. Jaqueline Ziemann MD','jazlyn53@yahoo.com','0982825897','Dinah, and saying \"Come up again, dear!\" I shall only look up and beg for its dinner, and all her.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(53,15,'NSOWH8WUBVOB','Archibald Aufderhar','genesis.paucek@gmail.com','0215663826','Soup, so rich and green, Waiting in a piteous tone. And she opened it, and found herself falling.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(54,15,'ODLQQXWU1EVL','Natasha Reynolds PhD','alena25@gmail.com','0545001565','Knave \'Turn them over!\' The Knave of Hearts, and I never was so ordered about by mice and rabbits.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(55,15,'EQAUTSYHBUIE','Kamron Halvorson','victor51@gmail.com','0886182225','Duchess, who seemed too much frightened that she was beginning to end,\' said the Gryphon. \'We can.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(56,16,'MPB90GRPCG8W','Verdie Friesen DVM','lhoppe@gmail.com','0590944043','Dormouse sulkily remarked, \'If you please, sir--\' The Rabbit Sends in a low, timid voice, \'If you.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(57,16,'XTT2OELCDSNH','Mr. Jovanny Okuneva','lexie29@gmail.com','0221271065','Duchess; \'and most things twinkled after that--only the March Hare. Alice sighed wearily. \'I think.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(58,16,'PEERKXP8ZV18','Prof. Braeden Mante Jr.','veum.javonte@rosenbaum.net','0964147377','King said, with a whiting. Now you know.\' \'Who is it twelve? I--\' \'Oh, don\'t bother ME,\' said.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(59,16,'TFMOXM7YNVNS','Mr. Bruce Stroman Jr.','dleannon@hotmail.com','0109845686','She said the March Hare. Alice sighed wearily. \'I think you might like to show you! A little.',NULL,'pending','2025-06-10 10:45:04','2025-06-10 10:45:04'),(60,16,'HCFNXNIQHPUK','Grant Rolfson','tnolan@yahoo.com','0013508547','However, the Multiplication Table doesn\'t signify: let\'s try the experiment?\' \'HE might bite,\'.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(61,17,'VKJDH725P50T','Dr. Matt Bartell DVM','christopher.stroman@langosh.com','0929841270','Alice waited till the eyes appeared, and then another confusion of voices--\'Hold up his.',NULL,'transferred','2025-06-10 10:45:04','2025-06-10 10:45:04'),(62,17,'O3AF7HKEDWE3','Dr. Hilma Bergnaum MD','hkozey@pollich.com','0751135270','Gryphon repeated impatiently: \'it begins \"I passed by his face only, she would manage it. \'They.',NULL,'cancelled','2025-06-10 10:45:04','2025-06-10 10:45:04'),(63,18,'BLWGA5TP8I0U','Sydnee Ritchie','rogers.cummerata@gaylord.com','0025527961','First, she tried to curtsey as she went on in a very interesting dance to watch,\' said Alice.',NULL,'refunded','2025-06-10 10:45:04','2025-06-10 10:45:04'),(64,18,'QXVBMZVDHM1O','Ashlee Miller','dale.wintheiser@cole.info','0949767635','March Hare said--\' \'I didn\'t!\' the March Hare. Visit either you like: they\'re both mad.\' \'But I.',NULL,'checked_in','2025-06-10 10:45:04','2025-06-10 10:45:04'),(65,18,'DX1MKHBJPKC2','Wilmer Abshire','xwisoky@hotmail.com','0168356261','Caterpillar sternly. \'Explain yourself!\' \'I can\'t go no lower,\' said the Duchess: you\'d better.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(66,18,'HTQ6HRUUPCPP','Ms. Ada Brakus MD','nathan23@yahoo.com','0450525346','Alice said nothing: she had hoped) a fan and gloves--that is, if I might venture to say a word.',NULL,'purchased','2025-06-10 10:45:04','2025-06-10 10:45:04'),(67,19,'RVUWO7CG141V','Berta Beer','cooper.bernier@hotmail.com','0918165027','Be off, or I\'ll have you executed on the shingle--will you come to an end! \'I wonder what they\'ll.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(68,19,'YKCA7EQF9V4T','Maegan Collier','wayne10@gmail.com','0450882776','Why, I wouldn\'t say anything about it, and found quite a new idea to Alice, very loudly and.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(69,19,'ZSSAPDXI6YHS','Marion Adams','mccullough.millie@hagenes.info','0989025779','YOUR temper!\' \'Hold your tongue!\' said the March Hare. \'Yes, please do!\' but the Gryphon added.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(70,19,'OOONBM0DGQSH','Ms. Bryana Klocko III','verna11@dach.info','0186005440','March Hare went on. \'Or would you tell me,\' said Alice, looking down with her arms round it as you.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(71,19,'8BMM1VWNIOL9','Rita Ebert','forest.zemlak@gmail.com','0834634608','That he met in the court!\' and the three gardeners, but she had got its head to keep herself from.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(72,20,'CWZGRT3XCIPM','Mrs. Trinity Cole III','ivy36@hilpert.com','0061532127','LITTLE larger, sir, if you please! \"William the Conqueror, whose cause was favoured by the little.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(73,20,'KQHJCZ8CM6IB','Silas Klein','rosa.gorczany@bode.info','0544010270','Cheshire Cat,\' said Alice: \'besides, that\'s not a VERY turn-up nose, much more like a mouse, That.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(74,20,'LTRXXFV0TMQN','Prof. Shana Gleason','vallie.zemlak@hotmail.com','0097998373','She was a dead silence. Alice noticed with some severity; \'it\'s very rude.\' The Hatter was the.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(75,20,'HYTXQSLOP4N1','Joanie Bergstrom','adam.jerde@gmail.com','0052308104','Alice heard the Queen\'s absence, and were resting in the distance would take the roof of the.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(76,21,'R1ZSGGQXBAFV','Mathias Gleason','bbatz@spinka.info','0793962897','Queen, in a wondering tone. \'Why, what a Mock Turtle said: \'I\'m too stiff. And the Gryphon.',NULL,'cancelled','2025-06-10 10:45:05','2025-06-10 10:45:05'),(77,21,'0A5T6JJ6FDOQ','Katlyn Kunde I','cummerata.kyler@gmail.com','0956751838','How the Owl and the Queen said severely \'Who is this?\' She said the Gryphon, \'you first form into.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(78,21,'IQWQTXUH0FK2','Lew Rath','jacinthe.walter@schaden.net','0880159810','She generally gave herself very good height indeed!\' said the Hatter. \'It isn\'t mine,\' said the.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(79,21,'ZAMPJ8PXENJW','Adell McKenzie DDS','blick.mellie@mayer.org','0766549406','Those whom she sentenced were taken into custody by the end of the other ladder?--Why, I hadn\'t.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(80,21,'4KJK3MYOKEBV','Astrid Rosenbaum','sgoyette@yahoo.com','0528859956','King, the Queen, who were all talking together: she made some tarts, All on a bough of a tree.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(81,21,'WDBQE0LQDR6W','Mr. Emmet Watsica','bertram.balistreri@purdy.com','0304742169','Queen, who were giving it something out of sight, he said to herself. \'Of the mushroom,\' said the.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(82,22,'EG96IT5Z40L9','Charlotte Quigley','jailyn.bode@hotmail.com','0698967082','Alice ventured to ask. \'Suppose we change the subject,\' the March Hare went on. \'We had the dish.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(83,22,'3YXIQOW98UFB','Sim Herzog','khegmann@hotmail.com','0971017891','Cat. \'Do you take me for his housemaid,\' she said to Alice, flinging the baby with some curiosity.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(84,22,'L07OYWI15VVV','Thora Jacobi','mweissnat@yahoo.com','0506768581','I must sugar my hair.\" As a duck with its arms folded, quietly smoking a long time with one elbow.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(85,22,'URKRR9OVALMF','Ms. Queenie Crona','mborer@hotmail.com','0070251826','Let this be a great deal to ME,\' said the King, the Queen, who had been all the rest, Between.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(86,22,'ZHCOOXZAJTFH','Dr. Brad Jacobson MD','jevon.mertz@yahoo.com','0054204034','IS that to be two people! Why, there\'s hardly room to grow here,\' said the Lory, with a pair of.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(87,22,'3WSW63YKGZ9Z','Junior Hane MD','urban07@gmail.com','0620458521','Alice \'without pictures or conversations in it, and burning with curiosity, she ran out of sight.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(88,23,'7OLWJYPSQAYD','Jacinthe Huels II','marisa04@senger.info','0356939571','I think?\' \'I had NOT!\' cried the Gryphon, and the two creatures, who had meanwhile been examining.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(89,23,'0LTIZGLWO0PM','Quinn Ruecker','jordane32@gusikowski.com','0224015407','Alice, (she had grown in the chimney close above her: then, saying to herself, and nibbled a.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(90,23,'XOCOXQ8LDCPP','Dorthy Roob','vwitting@harvey.com','0366352940','I\'m quite tired and out of the sort,\' said the voice. \'Fetch me my gloves this moment!\' Then came.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(91,23,'ZSO0NTKTFFZN','Jamison Nitzsche','dorothy.maggio@rau.org','0289825035','Alice aloud, addressing nobody in particular. \'She\'d soon fetch it here, lad!--Here, put \'em up at.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(92,23,'WMRMCXDCYBD2','Prof. Faye Feest Sr.','jackeline10@halvorson.com','0547973090','Mock Turtle. \'Very much indeed,\' said Alice. The King turned pale, and shut his eyes.--\'Tell her.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(93,23,'KFIFNSYPRZ8I','Prof. Weldon Ritchie V','gparker@thiel.com','0202336410','I then? Tell me that first, and then added them up, and there they are!\' said the Caterpillar.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(94,24,'BXGA0EMTJA7D','Ms. Haven Stark II','spfeffer@yahoo.com','0560716619','White Rabbit, trotting slowly back again, and went back to the Duchess: you\'d better ask HER about.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(95,24,'IXLZ8EBNYRUI','Vance Beatty','elody.nicolas@gmail.com','0883794484','I will prosecute YOU.--Come, I\'ll take no denial; We must have a prize herself, you know,\' the.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(96,25,'PJ9Z9ZCZFSUS','Hermina Hermann','ceffertz@yahoo.com','0832043582','I don\'t remember where.\' \'Well, it must be really offended. \'We won\'t talk about her and to wonder.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(97,25,'J6EY6U7EYSEN','Dr. Darius Rodriguez I','freda.donnelly@yahoo.com','0883224550','Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all the party were placed along.',NULL,'cancelled','2025-06-10 10:45:05','2025-06-10 10:45:05'),(98,25,'2VI63XL6VUYQ','Birdie West II','ghuel@gmail.com','0717059092','Alice soon came to ME, and told me you had been (Before she had not long to doubt, for the fan and.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(99,25,'E6VGNNATSDY5','Prof. Reyes Labadie MD','selena62@gmail.com','0175300451','In the very middle of the shepherd boy--and the sneeze of the evening, beautiful Soup! \'Beautiful.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(100,25,'UJP5DOPCDOHD','Carolyn Schiller','dickinson.bernadine@hotmail.com','0444627310','Cat. \'I don\'t quite understand you,\' she said, without even looking round. \'I\'ll fetch the.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(101,26,'QSB1LAPAJF7O','Effie Cummerata','windler.elian@gmail.com','0489567427','I shall have to beat time when I grow up, I\'ll write one--but I\'m grown up now,\' she said, by way.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(102,26,'X4OHXQBDQQRC','Lafayette Treutel','vance.eichmann@hotmail.com','0723367774','I begin, please your Majesty?\' he asked. \'Begin at the top of the miserable Mock Turtle. \'No, no!.',NULL,'cancelled','2025-06-10 10:45:05','2025-06-10 10:45:05'),(103,27,'UYZWVI5ITTCE','Prof. Walton Beier DDS','casper.ida@king.info','0707399418','She gave me a good deal worse off than before, as the rest of it at all; and I\'m sure _I_ shan\'t.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(104,27,'5CFQL4MI2SUR','Mr. Johan Haley I','torp.elouise@hotmail.com','0758552082','Let me see: four times seven is--oh dear! I shall remember it in less than no time she\'d have.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(105,28,'JP8WOABHJNMF','Fredy Emmerich','deon52@bauch.com','0785197944','Alice, a good way off, and found that it might happen any minute, \'and then,\' thought she, \'what.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(106,28,'FMZ01EVCBSCJ','Mackenzie Kuvalis PhD','douglas64@nikolaus.com','0720232365','Alice timidly. \'Would you like the look of things at all, at all!\' \'Do as I do,\' said the Gryphon.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(107,28,'AYMBKGQCWITX','Dr. Mohamed Mraz','orville.donnelly@ryan.info','0443745280','Cat; and this he handed over to the table for it, you know--\' (pointing with his head!\"\' \'How.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(108,29,'5HDYZQSOZ6YW','Dr. Elvera Ledner','maude.goodwin@schaden.org','0524830185','King. \'When did you call it sad?\' And she kept fanning herself all the time they were getting so.',NULL,'transferred','2025-06-10 10:45:05','2025-06-10 10:45:05'),(109,29,'E0VJDCUMMKXN','Jerel Boyle','elizabeth51@ledner.com','0703451748','Gryphon went on again:-- \'I didn\'t write it, and yet it was an immense length of neck, which.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(110,30,'SAO3S1JOMQ9Z','Colt Lesch','hosea.johnson@gmail.com','0245522273','He says it kills all the party sat silent and looked at the thought that it was certainly too much.',NULL,'pending','2025-06-10 10:45:05','2025-06-10 10:45:05'),(111,30,'UT2T8TCZMPCH','Miss Pansy Ankunding','gcarter@gmail.com','0986867777','CHAPTER VI. Pig and Pepper For a minute or two, it was only sobbing,\' she thought, \'and hand round.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(112,30,'JNUTXMZSUEJ7','Paula Sipes','vrolfson@lehner.com','0740048398','Alice to find that the Queen in a very pretty dance,\' said Alice to herself. (Alice had no very.',NULL,'cancelled','2025-06-10 10:45:05','2025-06-10 10:45:05'),(113,30,'JXJBIG4I3HBL','Cody Harber','cassandra90@hotmail.com','0022578167','Rabbit\'s--\'Pat! Pat! Where are you?\' said Alice, swallowing down her anger as well as the.',NULL,'cancelled','2025-06-10 10:45:05','2025-06-10 10:45:05'),(114,30,'FN3Y63NN0CFE','Katelynn Conroy','edward03@hotmail.com','0564065022','There was nothing on it were white, but there were a Duck and a large mushroom growing near her.',NULL,'refunded','2025-06-10 10:45:05','2025-06-10 10:45:05'),(115,30,'BYGZWQCRRLKW','Clifford Fay','roslyn.armstrong@reichert.org','0437225508','The Queen\'s Croquet-Ground A large rose-tree stood near the centre of the song. \'What trial is.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(116,31,'ZHAP4EWFZGGR','Janessa Koss DVM','imani29@yahoo.com','0015051251','Alice, who always took a great interest in questions of eating and drinking. \'They lived on.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(117,31,'X1SJBFMRFHMD','Schuyler Nienow','ally51@mclaughlin.com','0452843970','White Rabbit was still in sight, and no room at all a pity. I said \"What for?\"\' \'She boxed the.',NULL,'reserved','2025-06-10 10:45:05','2025-06-10 10:45:05'),(118,31,'SWYNKBYKVRFD','Prof. Isabel Huel IV','lthiel@yahoo.com','0011280490','RED rose-tree, and we won\'t talk about trouble!\' said the voice. \'Fetch me my gloves this moment!\'.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(119,31,'IYCMCL0HMVDV','Yazmin Mayer','aurelie86@yahoo.com','0351631526','Knave \'Turn them over!\' The Knave shook his head contemptuously. \'I dare say you\'re wondering why.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(120,31,'DMTXDJZKLLFV','Kavon Lueilwitz','addie21@nicolas.com','0849774965','I know!\' exclaimed Alice, who felt very curious thing, and she thought it would,\' said the King.',NULL,'checked_in','2025-06-10 10:45:05','2025-06-10 10:45:05'),(121,31,'QLZSWYL1F1CY','Ms. Wendy Hoeger','carmelo43@lubowitz.info','0282326814','Soup,\" will you, won\'t you, won\'t you, won\'t you, will you join the dance. Will you, won\'t you.',NULL,'purchased','2025-06-10 10:45:05','2025-06-10 10:45:05'),(122,32,'MJGGCXABXWYJ','Marcus Wisoky','scrooks@gleichner.com','0488690349','I had to do that,\' said the Hatter. \'Stolen!\' the King triumphantly, pointing to the end: then.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(123,32,'VKOWBLM9GIQ7','Vernice Kris','oren61@grimes.net','0332740560','I ever heard!\' \'Yes, I think that proved it at all; and I\'m I, and--oh dear, how puzzling it all.',NULL,'purchased','2025-06-10 10:45:06','2025-06-10 10:45:06'),(124,32,'QU358Q6WRNYE','Lucile Boyer','cmedhurst@murphy.biz','0429383090','THE VOICE OF THE SLUGGARD,\"\' said the Duchess: you\'d better ask HER about it.\' (The jury all.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(125,32,'ZRHR1SR1R7LV','Nikko Lynch','dereck.armstrong@hotmail.com','0648079428','I\'M a Duchess,\' she said this, she noticed a curious dream!\' said Alice, who had spoken first.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(126,32,'KOEATHHS7MAO','Vivianne Jones','belle23@hotmail.com','0020214995','Arithmetic--Ambition, Distraction, Uglification, and Derision.\' \'I never heard it before,\' said.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(127,32,'S3ZQAUTRPQ5Z','Mercedes Gaylord','bogan.corbin@torphy.com','0480027369','Why, there\'s hardly enough of it appeared. \'I don\'t see,\' said the Hatter. \'It isn\'t directed at.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(128,33,'ARRMIEADET4N','Bettye Witting','wisoky.pearl@gmail.com','0845479686','He looked at Two. Two began in a deep, hollow tone: \'sit down, both of you, and listen to her. \'I.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(129,33,'9E6OQID1CTIW','Loma Ferry','antonette03@doyle.biz','0538118955','Dormouse, after thinking a minute or two, it was quite pale (with passion, Alice thought), and it.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(130,33,'MXISLBOKBU9U','Douglas Rogahn','dayana.turcotte@yahoo.com','0906649216','However, this bottle does. I do it again and again.\' \'You are old,\' said the last time she had.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(131,34,'3KD0UWN8FLVB','Josefina Kuhic','evandervort@yahoo.com','0304925498','Alice began, in a voice of the words have got in your pocket?\' he went on saying to herself.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(132,34,'PKCJKWVMMR2W','Margot Simonis','tcollins@dach.biz','0800926907','When she got up and say \"How doth the little--\"\' and she dropped it hastily, just in time to begin.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(133,34,'BURBIL7J4IIK','Rodrick Kiehn','shad.nikolaus@gmail.com','0210036297','Mock Turtle, capering wildly about. \'Change lobsters again!\' yelled the Gryphon never learnt it.\'.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(134,34,'K18ZWDPVP1Z5','Shawn Kassulke','whickle@gmail.com','0880761287','And mentioned me to him: She gave me a good many voices all talking together: she made her next.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(135,35,'ONRYH6MOVPU0','Dejuan Yundt','jabari.gislason@sawayn.net','0887241846','I am, sir,\' said Alice; \'all I know is, something comes at me like a frog; and both the hedgehogs.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(136,35,'T7ID7DZJDRKH','Ms. Alanis Konopelski','curt72@schaden.org','0366083548','DOES THE BOOTS AND SHOES.\' the Gryphon in an encouraging opening for a minute or two she stood.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(137,35,'IZWZT9JPUWJY','Prof. Madelynn Bosco III','swift.jules@yahoo.com','0272936636','Alice, \'to pretend to be patted on the twelfth?\' Alice went timidly up to the three were all.',NULL,'purchased','2025-06-10 10:45:06','2025-06-10 10:45:06'),(138,36,'RHTI4B4EVY6N','Rollin Kuphal','armstrong.callie@hotmail.com','0915941677','A large rose-tree stood near the entrance of the bottle was a queer-shaped little creature, and.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(139,36,'3NBLUEBTJWUU','Jenifer Gutmann','ova75@connelly.com','0835082613','Mouse. \'Of course,\' the Mock Turtle sighed deeply, and drew the back of one flapper across his.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(140,36,'SMXRPNH3WZEG','Prof. Madison Langosh','ohammes@lakin.net','0829268965','THAT is--\"Take care of the house opened, and a Canary called out in a tone of delight, and rushed.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(141,37,'KGB8LUSH3XBG','Prof. Alayna Paucek','breanne04@hotmail.com','0461498419','Dormouse is asleep again,\' said the Duchess: \'flamingoes and mustard both bite. And the muscular.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(142,37,'SC4SOG9L8SGO','Bethany Miller','bbartell@gmail.com','0048278917','Alice, looking down with one elbow against the door, she found herself lying on the same size for.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(143,37,'FJBSFDRWTCKB','Jovan Tremblay','nelson94@gmail.com','0942175005','Alice very politely; but she could get away without speaking, but at any rate, the Dormouse into.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(144,38,'6GXM6XDLDRWY','Lempi McLaughlin','bill64@gleason.com','0447079339','Rabbit noticed Alice, as she could, and soon found herself in a great letter, nearly as large as.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(145,38,'E8HXUNOPFIQU','Haylie Bahringer','issac.renner@yahoo.com','0117039660','Rabbit angrily. \'Here! Come and help me out of sight; and an Eaglet, and several other curious.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(146,38,'XULQSNVPIYBR','Dr. Ephraim Klein','russell.cummings@yahoo.com','0548215070','YOU are, first.\' \'Why?\' said the King; and the baby--the fire-irons came first; then followed a.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(147,38,'DBR8BCEVFUIR','Adrian Reilly','mann.demarcus@yahoo.com','0259004902','Alice in a wondering tone. \'Why, what a Mock Turtle had just upset the milk-jug into his cup of.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(148,38,'XW6P9XS7QYRQ','Ila McCullough II','dedric25@bradtke.com','0377739568','HER about it.\' (The jury all looked so good, that it would not stoop? Soup of the earth. At last.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(149,39,'P26AR6GCFLVL','Brionna Jerde','ethel87@kunze.com','0954644256','March Hare. \'Yes, please do!\' pleaded Alice. \'And ever since that,\' the Hatter went on, \'you throw.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(150,39,'PIGMBXX6VU53','Colton Smitham','melba98@gmail.com','0167383367','Just then she remembered having seen in her life; it was empty: she did not at all this time. \'I.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(151,39,'03L10RKWWDB1','Danial Douglas','lind.brandy@gmail.com','0911958789','Duchess! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are ferrets! Where CAN.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(152,39,'PG7Z0ZMPWHQ7','Amiya Blanda','candace.prohaska@yahoo.com','0336088937','I got up in her face, with such sudden violence that Alice had begun to repeat it, when a cry of.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(153,40,'JUHMDEW4ITIU','Golda Stokes II','felicia74@hotmail.com','0606316763','Mock Turtle, who looked at them with one foot. \'Get up!\' said the Queen, the royal children; there.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(154,40,'ZIKB2OABSW93','Lamont Dach','kward@jenkins.com','0665383855','Majesty,\' said Two, in a sorrowful tone, \'I\'m afraid I can\'t show it you myself,\' the Mock Turtle.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(155,40,'WFBDONESC4BG','Kristin Huel','hilbert49@smith.com','0151437313','Edgar Atheling to meet William and offer him the crown. William\'s conduct at first she would.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(156,40,'93ZMKTN9VLEY','Enid Pfeffer','hwillms@metz.com','0161753321','Time as well look and see that queer little toss of her sharp little chin into Alice\'s head. \'Is.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(157,41,'KQ1KTFVHBTJV','Rosalyn Oberbrunner','ptorp@gmail.com','0437109626','Duchess! The Duchess! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(158,41,'KDLDWXU8FTIC','Tito Ziemann','merritt42@rau.info','0111160072','An enormous puppy was looking at Alice the moment she quite forgot you didn\'t sign it,\' said the.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(159,42,'HHB1ELZ1SNCT','Christiana Lemke','trycia.russel@leffler.com','0316886258','While the Owl had the dish as its share of the party sat silent for a minute or two, she made out.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(160,42,'MITIVMRLQ6KO','Jena Adams','darrel.casper@hotmail.com','0900327885','The first witness was the first question, you know.\' \'I DON\'T know,\' said Alice, a good many.',NULL,'purchased','2025-06-10 10:45:06','2025-06-10 10:45:06'),(161,42,'BTF6JCG8XRLB','Miss Idella Murray DVM','waldo65@gmail.com','0581575156','Hatter were having tea at it: a Dormouse was sitting between them, fast asleep, and the Mock.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(162,42,'OGUXJ3JLJBFJ','Kelton Kshlerin IV','xbarton@yahoo.com','0919584393','Alice. \'I\'m glad they don\'t give birthday presents like that!\' But she waited patiently. \'Once,\'.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(163,42,'OCEQYK5OTX4J','Fay Boyle','greenholt.gage@hotmail.com','0348028011','Cat; and this was the first to speak. \'What size do you know that you\'re mad?\' \'To begin with,\'.',NULL,'checked_in','2025-06-10 10:45:06','2025-06-10 10:45:06'),(164,43,'LDJJE0QPVZRM','Kayla Cronin','hreilly@hotmail.com','0619091756','YOU with us!\"\' \'They were learning to draw,\' the Dormouse again, so she set the little door, so.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(165,43,'AOF4IEZMUANO','Kelsie Crist IV','wjerde@hotmail.com','0077628718','Alice heard it before,\' said Alice,) and round the court was in such a simple question,\' added the.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(166,43,'HTE15HH38QOK','Gerda Stiedemann','ethyl05@roberts.net','0112641647','I say,\' the Mock Turtle, \'Drive on, old fellow! Don\'t be all day to day.\' This was quite out of.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(167,43,'HWHKC9V5R2CC','Meggie Gibson I','geovanni24@jacobi.com','0918697436','King, \'that saves a world of trouble, you know, upon the other ladder?--Why, I hadn\'t drunk quite.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(168,43,'JI9YLVWCJQTP','Dr. Dusty Schneider V','ovolkman@bradtke.org','0662306283','There was nothing else to do, and in his throat,\' said the Duchess: \'what a clear way you.',NULL,'reserved','2025-06-10 10:45:06','2025-06-10 10:45:06'),(169,44,'6OBTHGUCOQ7E','Joanny Pollich','fbradtke@prohaska.com','0193903439','Alice thought this must be kind to them,\' thought Alice, as she was walking by the hedge!\' then.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(170,44,'WXJXAR3UQ3RR','Dr. Ruthe Carroll','jmills@hotmail.com','0452301563','Mock Turtle in the sea. The master was an immense length of neck, which seemed to be a footman.',NULL,'transferred','2025-06-10 10:45:06','2025-06-10 10:45:06'),(171,44,'J6YFSTMGTG1S','Phyllis Mann','dominique65@hotmail.com','0960845515','Magpie began wrapping itself up and said, without even looking round. \'I\'ll fetch the executioner.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(172,44,'WEXCJB99CFDD','Florine Little','tjones@hotmail.com','0211531751','English,\' thought Alice; \'only, as it\'s asleep, I suppose it doesn\'t matter a bit,\' said the Mock.',NULL,'refunded','2025-06-10 10:45:06','2025-06-10 10:45:06'),(173,44,'3CDADFS7OEIQ','Ed Marquardt','may.spencer@gmail.com','0919098019','March Hare. \'Then it ought to be Number One,\' said Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\'.',NULL,'pending','2025-06-10 10:45:06','2025-06-10 10:45:06'),(174,44,'CMO3BXJVVRHY','Ms. Karen Waters','isabelle34@gmail.com','0246777381','Time!\' \'Perhaps not,\' Alice replied in an undertone to the three gardeners who were all shaped.',NULL,'cancelled','2025-06-10 10:45:06','2025-06-10 10:45:06'),(175,45,'YSC6AX2BJ8BV','Deangelo Beahan III','ignacio.kertzmann@hotmail.com','0776148203','Even the Duchess said to herself, rather sharply; \'I advise you to set them free, Exactly as we.',NULL,'reserved','2025-06-10 10:45:07','2025-06-10 10:45:07'),(176,45,'ZCEXXR4ZJSAS','Prof. Kimberly Torphy','stiedemann.dianna@hotmail.com','0317510572','Alice)--\'and perhaps you were down here with me! There are no mice in the book,\' said the Queen.',NULL,'purchased','2025-06-10 10:45:07','2025-06-10 10:45:07'),(177,45,'DYTGP1ZM3EOV','Shad Heidenreich','pacocha.rhianna@gmail.com','0466810688','I THINK,\' said Alice. \'You must be,\' said the Queen, \'and take this young lady to see how he can.',NULL,'transferred','2025-06-10 10:45:07','2025-06-10 10:45:07'),(178,45,'ZFVY7TGTIURF','Mr. Toni Cummings II','kayla.auer@ferry.com','0006284245','King added in a trembling voice to its feet, ran round the thistle again; then the Rabbit\'s voice.',NULL,'checked_in','2025-06-10 10:45:07','2025-06-10 10:45:07'),(179,45,'JM2R72179CIO','Jena Abernathy','khalid.parisian@runte.net','0141954662','Said his father; \'don\'t give yourself airs! Do you think you can have no sort of people live about.',NULL,'pending','2025-06-10 10:45:07','2025-06-10 10:45:07'),(180,45,'VACUOH16VNUE','Jeanne Feest DDS','mdare@bednar.info','0082267958','For he can thoroughly enjoy The pepper when he sneezes: He only does it matter to me whether.',NULL,'cancelled','2025-06-10 10:45:07','2025-06-10 10:45:07'),(181,46,'5ZNYHG3AANMN','Prof. Marcus Farrell','spinka.lupe@mertz.com','0175480151','I give you fair warning,\' shouted the Queen. \'Sentence first--verdict afterwards.\' \'Stuff and.',NULL,'purchased','2025-06-10 10:45:07','2025-06-10 10:45:07'),(182,46,'SNWPWBRQAKWL','Geovanny Douglas','maryse32@lang.com','0637089405','How brave they\'ll all think me at all.\' \'In that case,\' said the King; \'and don\'t be.',NULL,'transferred','2025-06-10 10:45:07','2025-06-10 10:45:07'),(183,46,'TZOVMV0PFSOU','Bobby Towne','hstracke@moore.com','0622250061','Cat, \'a dog\'s not mad. You grant that?\' \'I suppose they are the jurors.\' She said the King; \'and.',NULL,'transferred','2025-06-10 10:45:07','2025-06-10 10:45:07'),(184,47,'NCA5WSTCLMUY','Jamarcus Larkin','adenesik@gmail.com','0117643018','COULD! I\'m sure she\'s the best way you can;--but I must have been that,\' said Alice. \'Then it.',NULL,'reserved','2025-06-10 10:45:07','2025-06-10 10:45:07'),(185,47,'PFOHPD7RVNVA','Vilma Torphy','karson.langworth@pagac.biz','0458998686','At last the Caterpillar took the watch and looked at her for a few minutes it seemed quite dull.',NULL,'reserved','2025-06-10 10:45:07','2025-06-10 10:45:07'),(186,47,'M82MCOSUV9U3','Leslie Hessel MD','lbosco@yahoo.com','0957164637','But her sister was reading, but it did not like the Queen?\' said the Duchess, \'and that\'s the.',NULL,'cancelled','2025-06-10 10:45:07','2025-06-10 10:45:07'),(187,48,'T9Y48HQ4MT5R','Lelia Shanahan','orlando64@hotmail.com','0299926158','I say,\' the Mock Turtle repeated thoughtfully. \'I should have liked teaching it tricks very much.',NULL,'cancelled','2025-06-10 10:45:07','2025-06-10 10:45:07'),(188,48,'QLQFWQPNIHCV','Winifred Runte','kelli39@tromp.com','0298687780','March Hare took the cauldron of soup off the top of it. She went in search of her skirt, upsetting.',NULL,'checked_in','2025-06-10 10:45:07','2025-06-10 10:45:07'),(189,48,'K3OGCYPDMHRE','Prof. Enrique Fadel','ncarroll@yahoo.com','0851608454','King. (The jury all brightened up at the end of half an hour or so there were no tears. \'If you\'re.',NULL,'reserved','2025-06-10 10:45:07','2025-06-10 10:45:07'),(190,48,'W6EM21SUGJSM','Dortha Nikolaus','kamron99@kassulke.biz','0664951352','I\'m not used to it!\' pleaded poor Alice. \'But you\'re so easily offended, you know!\' The Mouse.',NULL,'cancelled','2025-06-10 10:45:07','2025-06-10 10:45:07'),(191,48,'BJKWZGAOA7IU','Monique Feil','glen61@yahoo.com','0212708000','I ever heard!\' \'Yes, I think I should be raving mad after all! I almost wish I hadn\'t begun my.',NULL,'pending','2025-06-10 10:45:07','2025-06-10 10:45:07'),(192,48,'RU35BNW3NJWF','Prof. Jasen Herzog II','bethel.hilpert@feil.org','0619824489','Alice. \'Well, then,\' the Cat remarked. \'Don\'t be impertinent,\' said the Caterpillar. \'Well, I.',NULL,'transferred','2025-06-10 10:45:07','2025-06-10 10:45:07'),(193,49,'NBLCQWK2EJYW','Gladyce Runolfsdottir','pjenkins@gmail.com','0171186718','Alice soon came upon a low trembling voice, \'Let us get to the jury. \'Not yet, not yet!\' the.',NULL,'reserved','2025-06-10 10:45:07','2025-06-10 10:45:07'),(194,49,'LPG43QYO6V9N','Mrs. Sierra Bailey','ifranecki@gmail.com','0146124112','Elsie, Lacie, and Tillie; and they walked off together, Alice heard it say to this: so she sat.',NULL,'checked_in','2025-06-10 10:45:07','2025-06-10 10:45:07'),(195,49,'UMIKGGKSBDJF','Jairo Davis','merle86@gmail.com','0362923261','Alice, in a very poor speaker,\' said the Dodo, \'the best way to explain the paper. \'If there\'s no.',NULL,'pending','2025-06-10 10:45:07','2025-06-10 10:45:07'),(196,50,'LS1VVAHKKIDP','Abigayle Yost III','cjohns@hotmail.com','0888912154','I was thinking I should think you\'ll feel it a bit, if you don\'t like them raw.\' \'Well, be off.',NULL,'transferred','2025-06-10 10:45:07','2025-06-10 10:45:07'),(197,50,'8MFPRFGO1CDU','Gordon Smith','kovacek.horacio@carroll.com','0281230852','I never understood what it meant till now.\' \'If that\'s all I can do no more, whatever happens.',NULL,'cancelled','2025-06-10 10:45:07','2025-06-10 10:45:07');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:44:46','2025-06-10 10:44:46','Eligendi ratione nesciunt a quidem voluptatem unde. Laborum omnis hic itaque est quia.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:44:46','2025-06-10 10:44:46','Exercitationem totam totam necessitatibus et vitae. Iusto magnam est quas a.'),(3,'Event Experience',0,'published','2025-06-10 10:44:46','2025-06-10 10:44:46','Fuga numquam qui quisquam et aliquid error. Aut ex qui quo ad sint tempore.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:44:46','2025-06-10 10:44:46','Sint qui alias perferendis. Et quam et culpa commodi.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Facilis ea aperiam aut nihil.','Quod iusto ab cumque voluptatem molestiae est minima in facilis dolorum quaerat exercitationem temporibus quidem non optio rerum delectus similique perferendis aut nam dolore accusantium a qui illo eos dolore eligendi alias est nobis accusantium atque expedita et.',4,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(2,'Eos et explicabo qui animi rerum.','Non qui veniam magnam aut ipsum labore velit beatae ut dolores similique earum repellat quo aut atque sequi quasi est laudantium vel sint porro explicabo libero nobis non laborum molestias corrupti qui necessitatibus dolore quia harum dolorem sed rerum.',1,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(3,'Eligendi autem explicabo amet optio voluptatum ut.','Aut recusandae non quia porro eius molestiae nobis mollitia laborum doloribus corporis quas quam aliquid perspiciatis quidem quisquam eum.',2,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(4,'Et consequatur minima adipisci quibusdam.','Eos illum culpa et sequi aliquid similique quibusdam inventore natus qui ipsam nostrum praesentium autem nihil exercitationem nobis soluta eius non dolor consequatur corporis dolores eius esse illo dicta odio et exercitationem est minima culpa.',4,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(5,'Nulla quod dolorem voluptatem quam.','Tempora et consequuntur quis dolorum sunt repellendus est in ratione et facilis ullam quasi debitis perferendis laboriosam ipsa nihil beatae a vel fuga ducimus ipsum et iste dicta dolor cum aut sit officia eos suscipit omnis sed.',1,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(6,'Et impedit cumque ut aut autem.','Ducimus nihil enim autem possimus sint ex eos et sit quidem enim quos dolorem recusandae quis in perferendis soluta animi labore autem quo est fuga soluta reiciendis ea minima similique.',3,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(7,'Praesentium autem et ducimus impedit quis unde.','Consectetur nemo rerum voluptates vitae voluptas veritatis enim excepturi dolorem sequi tempora natus fugiat sint laudantium voluptas id architecto voluptas et saepe.',2,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(8,'Qui voluptatem deserunt enim.','Omnis voluptas sed aut aut praesentium vitae quia aut eaque voluptatem rerum quisquam consequatur et eveniet dolorem saepe laudantium sed consequatur tenetur eveniet cupiditate amet nam eveniet asperiores dolor recusandae beatae dicta provident.',3,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(9,'Enim et repellat nihil atque vero.','Libero saepe laborum enim quaerat nostrum harum excepturi voluptatum repellat reiciendis reprehenderit rerum est ut autem in et alias iure maiores sequi numquam vel est iste necessitatibus est corrupti sit et veniam quam aut optio.',4,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(10,'Qui tenetur voluptas libero.','Nam eligendi pariatur voluptatem ut dicta repellat natus nemo modi iure nam sunt sunt ea itaque non nihil voluptatum est veritatis veniam excepturi optio enim ea praesentium repudiandae soluta beatae assumenda perferendis.',4,'published','2025-06-10 10:44:46','2025-06-10 10:44:46'),(11,'Id harum laborum magnam esse.','Molestiae voluptatem autem voluptatem cupiditate soluta saepe optio laudantium ut enim et distinctio aut et expedita quam sed iusto consequuntur dolor consequatur qui laudantium repellendus possimus aliquid in.',4,'published','2025-06-10 10:44:46','2025-06-10 10:44:46');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Similique aperiam officia vel provident fuga voluptatem. Fuga qui ipsum numquam eligendi inventore eveniet. Ad ab velit dolorem numquam.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(2,'Ocean Views','Voluptatem temporibus quaerat dolor. Cupiditate aut et dolor voluptas. Sint occaecati accusantium dolorem necessitatibus cumque ipsam.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(3,'Adventure Time','Omnis nihil ad perspiciatis id at fugit similique. Officiis labore a est iusto. Enim error ipsa beatae dolore inventore consequatur.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(4,'City Lights','Nulla tenetur eos est dolorem voluptas quas perferendis. Adipisci rerum suscipit sint dolor qui ut id. Provident quis adipisci quaerat aut facilis.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(5,'Dreamscape','Eius sequi et et blanditiis. Enim aperiam sunt laudantium suscipit rerum voluptatibus pariatur praesentium.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(6,'Enchanted Forest','Doloremque vero voluptas et quia beatae sequi. Qui aut quod mollitia. Aut magnam doloribus omnis facere quos sapiente aut.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(7,'Golden Hour','Ratione blanditiis voluptas ratione rerum. Ut voluptatem non cum atque. Veritatis aut nemo est assumenda molestias. Minima asperiores ut tempora et.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(8,'Serenity','Voluptatem sapiente et ipsum commodi. Dolorem sed sit ullam cumque aut commodi. Aut quia facere aliquam ut reiciendis.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(9,'Eternal Beauty','Veritatis iusto voluptates itaque sit blanditiis odio quia magnam. Sapiente qui et ea voluptatum eligendi.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(10,'Moonlight Magic','Nihil error magni pariatur non. Quasi est quia deserunt quidem nisi sequi hic. Consectetur necessitatibus dolores inventore amet incidunt.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(11,'Starry Night','Quis labore repudiandae dolorem. At quisquam voluptatibus fuga eum. Ratione iusto voluptatem facilis ad iste. Et id numquam provident.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(12,'Hidden Gems','Nulla doloribus autem ut aliquid accusantium rerum modi. In atque eum voluptas unde doloremque unde. Earum modi dolor itaque et quod.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(13,'Tranquil Waters','Aliquam et corporis dolorem porro aliquid veniam. Aut in aliquam non.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(14,'Urban Escape','Sequi autem soluta quia temporibus totam numquam quasi corporis. Repellendus ipsum qui soluta rerum autem. Facere temporibus qui minima nulla.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22'),(15,'Twilight Zone','Unde pariatur nesciunt consequuntur fugiat totam aut dolor et. Magnam autem ducimus voluptas. Ad rerum cumque quibusdam deleniti fugiat.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:44:22','2025-06-10 10:44:22');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Et doloremque ut autem est veniam. Aliquam suscipit reiciendis eligendi. Cum quisquam et amet odit.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Cupiditate commodi rem nulla eveniet. Fuga doloribus sed accusamus fugiat fugit sunt. Voluptas ex eos ducimus blanditiis est fugiat non.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"A consectetur ad voluptatem provident. Consequatur officia voluptas dolorum culpa nulla. Distinctio quae incidunt iure totam maiores.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Quasi eum excepturi occaecati fuga ea quia. Labore expedita impedit aperiam nobis. Similique harum unde eos tempora exercitationem.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Tempora eum consectetur voluptas et et ducimus. Debitis quis et corrupti. Dolor maiores architecto voluptatibus non quaerat delectus.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Eos earum non quo. Distinctio ipsa accusamus aut. Et modi sed voluptatem sunt nobis voluptate.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Eos cupiditate molestiae ea quidem. Amet voluptatum aut dolor. Et nihil rerum vitae dolores repellendus sint.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Aut sit reprehenderit quos nulla ut totam ut. Ad in quod aspernatur odio. Ipsam distinctio facere veniam aut adipisci tempora.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Ut quo totam eum est ipsam. Nisi est at accusamus et aliquam natus quis. A quis officiis quos qui in suscipit placeat.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Sed porro modi illum sint. Nobis reiciendis atque autem ipsa consequatur voluptatum.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Provident voluptas rerum qui omnis doloribus similique molestiae. Ut dicta ipsam rem laudantium animi odit. Et qui vitae aut rem tempore facilis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Ad dicta labore quas molestias ipsam. Eius et id modi fuga. Similique fugiat est qui occaecati et dolores occaecati velit.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Et aliquam aliquam maxime doloremque eaque iure dolorem. Adipisci et nobis qui numquam ipsum.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Rerum quo sint officia nisi doloribus animi voluptates modi. Doloremque possimus earum natus.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Accusamus aliquam laborum voluptas quia eum. Qui earum et autem ut reiciendis exercitationem voluptate.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Expedita quasi enim et. Molestiae omnis earum laborum dolorum. Numquam nihil deserunt et minus voluptas fugiat.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"At excepturi occaecati earum veniam consequatur aut. Illum molestiae ad hic ut reiciendis. Ex saepe pariatur sed eveniet quo omnis.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Adipisci tenetur maiores assumenda at. Dolor incidunt consequatur porro molestias neque nulla sed.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Ut quis quo quisquam quaerat. Aliquid est et dolor mollitia. Commodi saepe consequatur eius aut vitae. Hic enim vitae molestiae et quos natus dolore.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Vel et soluta aut rerum et et est. In qui debitis voluptatum harum aut et voluptatem.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:44:22','2025-06-10 10:44:22');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','7560dd08d2deb0cb11969417d91cf62b',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','0792422829fed4d2794b2c306935d172',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','cb792b00dfb1a93655b03035a32f45c4',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=175 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(36,0,'about-us-information-img-1','about-us-information-img-1',6,'image/webp',9054,'homepage07/general/about-us-information-img-1.webp','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(37,0,'about-us-information-img-2','about-us-information-img-2',6,'image/webp',6845,'homepage07/general/about-us-information-img-2.webp','[]','2025-06-10 10:44:23','2025-06-10 10:44:23',NULL,'public'),(38,0,'about-us-information-shape-img','about-us-information-shape-img',6,'image/webp',2273,'homepage07/general/about-us-information-shape-img.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(39,0,'hero-banner-img-1','hero-banner-img-1',6,'image/webp',6977,'homepage07/general/hero-banner-img-1.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(40,0,'hero-banner-img-2','hero-banner-img-2',6,'image/webp',3916,'homepage07/general/hero-banner-img-2.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(41,0,'location-1','location-1',6,'image/webp',5553,'homepage07/general/location-1.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(42,0,'location-2','location-2',6,'image/webp',5553,'homepage07/general/location-2.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(43,0,'location-3','location-3',6,'image/webp',5553,'homepage07/general/location-3.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(44,0,'location-4','location-4',6,'image/webp',5553,'homepage07/general/location-4.webp','[]','2025-06-10 10:44:24','2025-06-10 10:44:24',NULL,'public'),(45,0,'logo','logo',6,'image/png',812,'homepage07/general/logo.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(46,0,'hero-banner-bg','hero-banner-bg',7,'image/webp',20260,'homepage07/backgrounds/hero-banner-bg.webp','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(47,0,'brand-img1','brand-img1',8,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(48,0,'brand-img2','brand-img2',8,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(49,0,'brand-img3','brand-img3',8,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(50,0,'brand-img4','brand-img4',8,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(51,0,'brand-img5','brand-img5',8,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:44:25','2025-06-10 10:44:25',NULL,'public'),(52,0,'brand-img6','brand-img6',8,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(53,0,'brand-img7','brand-img7',8,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(54,0,'brand-img8','brand-img8',8,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(55,0,'1','1',9,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(56,0,'2','2',9,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(57,0,'header-bg4','header-bg4',9,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:44:26','2025-06-10 10:44:26',NULL,'public'),(58,0,'hero-banner-bg','hero-banner-bg',9,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:44:27','2025-06-10 10:44:27',NULL,'public'),(59,0,'image-1','image-1',9,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:44:28','2025-06-10 10:44:28',NULL,'public'),(60,0,'newsletter-bg','newsletter-bg',9,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:44:29','2025-06-10 10:44:29',NULL,'public'),(61,0,'pricing-name','pricing-name',9,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:44:29','2025-06-10 10:44:29',NULL,'public'),(62,0,'speakers-bg','speakers-bg',9,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(63,0,'balloons','balloons',10,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(64,0,'calendar','calendar',10,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(65,0,'clock','clock',10,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(66,0,'coding','coding',10,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(67,0,'idea','idea',10,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:44:30','2025-06-10 10:44:30',NULL,'public'),(68,0,'instagram-icon','instagram-icon',10,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(69,0,'location-icon','location-icon',10,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(70,0,'location','location',10,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(71,0,'mail-icon','mail-icon',10,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(72,0,'menu','menu',10,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(73,0,'microphone','microphone',10,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(74,0,'phone-icon','phone-icon',10,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:44:31','2025-06-10 10:44:31',NULL,'public'),(75,0,'search','search',10,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(76,0,'speaker','speaker',10,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(77,0,'ticket','ticket',10,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(78,0,'user','user',10,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(79,0,'view','view',10,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(80,0,'workshop','workshop',10,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:44:32','2025-06-10 10:44:32',NULL,'public'),(81,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:44:33','2025-06-10 10:44:33',NULL,'public'),(82,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:44:33','2025-06-10 10:44:33',NULL,'public'),(83,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:44:33','2025-06-10 10:44:33',NULL,'public'),(84,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:44:34','2025-06-10 10:44:34',NULL,'public'),(85,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:44:34','2025-06-10 10:44:34',NULL,'public'),(86,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:44:34','2025-06-10 10:44:34',NULL,'public'),(87,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:44:34','2025-06-10 10:44:34',NULL,'public'),(88,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:44:35','2025-06-10 10:44:35',NULL,'public'),(89,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:44:35','2025-06-10 10:44:35',NULL,'public'),(90,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:44:35','2025-06-10 10:44:35',NULL,'public'),(91,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:44:36','2025-06-10 10:44:36',NULL,'public'),(92,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:44:36','2025-06-10 10:44:36',NULL,'public'),(93,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:44:36','2025-06-10 10:44:36',NULL,'public'),(94,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:44:37','2025-06-10 10:44:37',NULL,'public'),(95,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:44:37','2025-06-10 10:44:37',NULL,'public'),(96,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:44:37','2025-06-10 10:44:37',NULL,'public'),(97,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:44:38','2025-06-10 10:44:38',NULL,'public'),(98,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:44:38','2025-06-10 10:44:38',NULL,'public'),(99,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:44:38','2025-06-10 10:44:38',NULL,'public'),(100,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:44:38','2025-06-10 10:44:38',NULL,'public'),(101,0,'1','1',11,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:44:39','2025-06-10 10:44:39',NULL,'public'),(102,0,'10','10',11,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:44:39','2025-06-10 10:44:39',NULL,'public'),(103,0,'11','11',11,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:44:40','2025-06-10 10:44:40',NULL,'public'),(104,0,'12','12',11,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:44:40','2025-06-10 10:44:40',NULL,'public'),(105,0,'13','13',11,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:44:40','2025-06-10 10:44:40',NULL,'public'),(106,0,'14','14',11,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:44:41','2025-06-10 10:44:41',NULL,'public'),(107,0,'15','15',11,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:44:41','2025-06-10 10:44:41',NULL,'public'),(108,0,'16','16',11,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:44:41','2025-06-10 10:44:41',NULL,'public'),(109,0,'17','17',11,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:44:41','2025-06-10 10:44:41',NULL,'public'),(110,0,'18','18',11,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:44:42','2025-06-10 10:44:42',NULL,'public'),(111,0,'19','19',11,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:44:42','2025-06-10 10:44:42',NULL,'public'),(112,0,'2','2',11,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:44:42','2025-06-10 10:44:42',NULL,'public'),(113,0,'20','20',11,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:44:43','2025-06-10 10:44:43',NULL,'public'),(114,0,'3','3',11,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:44:43','2025-06-10 10:44:43',NULL,'public'),(115,0,'4','4',11,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:44:43','2025-06-10 10:44:43',NULL,'public'),(116,0,'5','5',11,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:44:44','2025-06-10 10:44:44',NULL,'public'),(117,0,'6','6',11,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:44:44','2025-06-10 10:44:44',NULL,'public'),(118,0,'7','7',11,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:44:44','2025-06-10 10:44:44',NULL,'public'),(119,0,'8','8',11,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:44:45','2025-06-10 10:44:45',NULL,'public'),(120,0,'9','9',11,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:44:45','2025-06-10 10:44:45',NULL,'public'),(121,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:44:46','2025-06-10 10:44:46',NULL,'public'),(122,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:44:46','2025-06-10 10:44:46',NULL,'public'),(123,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:44:46','2025-06-10 10:44:46',NULL,'public'),(124,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:44:46','2025-06-10 10:44:46',NULL,'public'),(125,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:44:46','2025-06-10 10:44:46',NULL,'public'),(126,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(127,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(128,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(129,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(130,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(131,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:44:47','2025-06-10 10:44:47',NULL,'public'),(132,0,'1','1',12,'image/png',6515,'homepage07/speakers/1.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(133,0,'2','2',12,'image/png',6515,'homepage07/speakers/2.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(134,0,'3','3',12,'image/png',6515,'homepage07/speakers/3.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(135,0,'4','4',12,'image/png',6515,'homepage07/speakers/4.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(136,0,'5','5',12,'image/png',6001,'homepage07/speakers/5.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(137,0,'6','6',12,'image/png',6001,'homepage07/speakers/6.png','[]','2025-06-10 10:44:48','2025-06-10 10:44:48',NULL,'public'),(138,0,'7','7',12,'image/png',6001,'homepage07/speakers/7.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(139,0,'8','8',12,'image/png',6001,'homepage07/speakers/8.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(140,0,'1','1',13,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(141,0,'10','10',13,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(142,0,'11','11',13,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(143,0,'2','2',13,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(144,0,'3','3',13,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:44:49','2025-06-10 10:44:49',NULL,'public'),(145,0,'4','4',13,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(146,0,'5','5',13,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(147,0,'6','6',13,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(148,0,'7','7',13,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(149,0,'8','8',13,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(150,0,'9','9',13,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:44:50','2025-06-10 10:44:50',NULL,'public'),(151,0,'0','0',14,'image/webp',33268,'main/events/0-1749552296.webp','[]','2025-06-10 10:44:56','2025-06-10 10:44:56',NULL,'public'),(152,0,'1','1',14,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:44:57','2025-06-10 10:44:57',NULL,'public'),(153,0,'10','10',14,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:44:57','2025-06-10 10:44:57',NULL,'public'),(154,0,'11','11',14,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:44:57','2025-06-10 10:44:57',NULL,'public'),(155,0,'12','12',14,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:44:58','2025-06-10 10:44:58',NULL,'public'),(156,0,'13','13',14,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:44:58','2025-06-10 10:44:58',NULL,'public'),(157,0,'14','14',14,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:44:58','2025-06-10 10:44:58',NULL,'public'),(158,0,'15','15',14,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:44:59','2025-06-10 10:44:59',NULL,'public'),(159,0,'16','16',14,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:44:59','2025-06-10 10:44:59',NULL,'public'),(160,0,'17','17',14,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:44:59','2025-06-10 10:44:59',NULL,'public'),(161,0,'18','18',14,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:45:00','2025-06-10 10:45:00',NULL,'public'),(162,0,'19','19',14,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:45:00','2025-06-10 10:45:00',NULL,'public'),(163,0,'2','2',14,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:45:00','2025-06-10 10:45:00',NULL,'public'),(164,0,'20','20',14,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:45:00','2025-06-10 10:45:00',NULL,'public'),(165,0,'3','3',14,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:45:01','2025-06-10 10:45:01',NULL,'public'),(166,0,'4','4',14,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:45:01','2025-06-10 10:45:01',NULL,'public'),(167,0,'5','5',14,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:45:01','2025-06-10 10:45:01',NULL,'public'),(168,0,'6','6',14,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:45:02','2025-06-10 10:45:02',NULL,'public'),(169,0,'7','7',14,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:45:02','2025-06-10 10:45:02',NULL,'public'),(170,0,'8','8',14,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:45:02','2025-06-10 10:45:02',NULL,'public'),(171,0,'9','9',14,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,'public'),(172,0,'1','1',15,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:45:14','2025-06-10 10:45:14',NULL,'public'),(173,0,'2','2',15,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:45:14','2025-06-10 10:45:14',NULL,'public'),(174,0,'3','3',15,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:45:14','2025-06-10 10:45:14',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:44:14','2025-06-10 10:44:14',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:44:14','2025-06-10 10:44:14',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:44:16','2025-06-10 10:44:16',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:44:23','2025-06-10 10:44:23',NULL),(5,0,'homepage07',NULL,'homepage07',0,'2025-06-10 10:44:23','2025-06-10 10:44:23',NULL),(6,0,'general',NULL,'general',5,'2025-06-10 10:44:23','2025-06-10 10:44:23',NULL),(7,0,'backgrounds',NULL,'backgrounds',5,'2025-06-10 10:44:25','2025-06-10 10:44:25',NULL),(8,0,'brands',NULL,'brands',1,'2025-06-10 10:44:25','2025-06-10 10:44:25',NULL),(9,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:44:26','2025-06-10 10:44:26',NULL),(10,0,'icons',NULL,'icons',1,'2025-06-10 10:44:30','2025-06-10 10:44:30',NULL),(11,0,'blogs',NULL,'blogs',1,'2025-06-10 10:44:39','2025-06-10 10:44:39',NULL),(12,0,'speakers',NULL,'speakers',5,'2025-06-10 10:44:48','2025-06-10 10:44:48',NULL),(13,0,'speakers',NULL,'speakers',1,'2025-06-10 10:44:49','2025-06-10 10:44:49',NULL),(14,0,'events',NULL,'events',1,'2025-06-10 10:44:56','2025-06-10 10:44:56',NULL),(15,0,'sliders',NULL,'sliders',1,'2025-06-10 10:45:13','2025-06-10 10:45:13',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:45:13','2025-06-10 10:45:13');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:45:13','2025-06-10 10:45:13');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:45:13','2025-06-10 10:45:13');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:44:23','2025-06-10 10:44:23'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:44:23','2025-06-10 10:44:23'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:44:23','2025-06-10 10:44:23'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:44:23','2025-06-10 10:44:23'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:44:39','2025-06-10 10:44:39'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:44:39','2025-06-10 10:44:39'),(7,'title','[\"Frontend Developer\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(8,'description','[\"Rabbit angrily. \'Here! Come and help me out of its right ear and left off sneezing by this time). \'Don\'t grunt,\' said Alice; \'I daresay it\'s a French mouse, come over with diamonds, and walked two.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(9,'address','[\"63220 Liam Vista Apt. 068\\nTrevorville, VT 61260-2979\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(11,'title','[\"Frontend Developer\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(12,'description','[\"The King looked anxiously round, to make herself useful, and looking anxiously about as curious as it could go, and making faces at him as he spoke, \'we were trying--\' \'I see!\' said the March Hare.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(13,'address','[\"18660 Jean Inlet Apt. 271\\nTayafort, SC 44415-9775\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(15,'title','[\"DevOps Engineer\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(16,'description','[\"Don\'t be all day to such stuff? Be off, or I\'ll kick you down stairs!\' \'That is not said right,\' said the cook. The King looked anxiously over his shoulder with some severity; \'it\'s very.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(17,'address','[\"272 Katlyn Court\\nSouth Audie, SC 19442\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(19,'title','[\"UX\\/UI Designer\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(20,'description','[\"I\'ll kick you down stairs!\' \'That is not said right,\' said the Dormouse: \'not in that poky little house, on the same thing,\' said the King, with an anxious look at them--\'I wish they\'d get the trial.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(21,'address','[\"975 Volkman Village Apt. 800\\nSouth Gaylord, IN 40187-3923\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:51','2025-06-10 10:44:51'),(23,'title','[\"UX\\/UI Designer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(24,'description','[\"The Dormouse slowly opened his eyes. He looked anxiously round, to make out which were the two creatures got so close to her usual height. It was the Rabbit say, \'A barrowful will do, to begin.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(25,'address','[\"734 Ziemann Port Suite 960\\nNew Cordellberg, NV 50945\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(27,'title','[\"System Administrator\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(28,'description','[\"Alice, as the jury consider their verdict,\' the King hastily said, and went on: \'But why did they live on?\' said the Hatter. \'I deny it!\' said the Hatter, and, just as well as she remembered the.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(29,'address','[\"6050 Kathryn Field Apt. 974\\nWest Nanniefort, LA 27590\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(31,'title','[\"DevOps Engineer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(32,'description','[\"Duchess; \'I never thought about it,\' said Alice to herself. \'Of the mushroom,\' said the Cat, \'or you wouldn\'t squeeze so.\' said the Hatter, and here the conversation dropped, and the arm that was.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(33,'address','[\"2896 Toy Point Apt. 993\\nPort Rahsaanside, IL 56200-2599\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(35,'title','[\"Project Manager\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(36,'description','[\"This did not look at it!\' This speech caused a remarkable sensation among the trees, a little now and then quietly marched off after the rest of it in large letters. It was the only difficulty was.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(37,'address','[\"5472 Alvah Mountain Apt. 433\\nNorth Ashaland, HI 26762\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(39,'title','[\"DevOps Engineer\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(40,'description','[\"Dormouse indignantly. However, he consented to go from here?\' \'That depends a good way off, and found quite a long silence after this, and she very soon finished off the top with its tongue hanging.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(41,'address','[\"874 Ryan Lane\\nLake Ashtonberg, WA 69517\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(43,'title','[\"Frontend Developer\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(44,'description','[\"THEIR eyes bright and eager with many a strange tale, perhaps even with the end of trials, \\\"There was some attempts at applause, which was a little door about fifteen inches high: she tried hard to.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(45,'address','[\"57524 Martina Squares\\nNew Marietta, NC 49544\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:52','2025-06-10 10:44:52'),(47,'title','[\"System Administrator\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(48,'description','[\"Alice looked at Alice. \'It goes on, you know,\' said Alice to herself. \'Shy, they seem to encourage the witness at all: he kept shifting from one foot to the little magic bottle had now had its full.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(49,'address','[\"196 Kuhlman Fords\\nWisokychester, OH 40058\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(51,'title','[\"Project Manager\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(52,'description','[\"Mock Turtle, who looked at it again: but he now hastily began again, using the ink, that was said, and went on again:-- \'I didn\'t know that you\'re mad?\' \'To begin with,\' the Mock Turtle, who looked.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(53,'address','[\"460 Kertzmann Land\\nSouth Dulce, NC 03798-1818\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(55,'title','[\"System Administrator\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(56,'description','[\"Rabbit just under the window, and one foot up the chimney, has he?\' said Alice angrily. \'It wasn\'t very civil of you to sit down without being invited,\' said the youth, \'as I mentioned before, And.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(57,'address','[\"16987 Bergnaum Throughway Suite 906\\nPresleyborough, OR 64669\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(59,'title','[\"DevOps Engineer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(60,'description','[\"Oh, my dear paws! Oh my dear paws! Oh my fur and whiskers! She\'ll get me executed, as sure as ferrets are ferrets! Where CAN I have none, Why, I do so like that curious song about the twentieth time.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(61,'address','[\"83537 Louvenia Streets Apt. 709\\nEdytheside, MD 37197-9242\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(63,'title','[\"System Administrator\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(64,'description','[\"And then, turning to Alice again. \'No, I give you fair warning,\' shouted the Queen. \'Their heads are gone, if it had been. But her sister was reading, but it did not quite like the Mock Turtle had.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(65,'address','[\"7046 Durgan Hill\\nLarsonmouth, ME 36574\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(67,'title','[\"UX\\/UI Designer\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:53','2025-06-10 10:44:53'),(68,'description','[\"Gryphon, with a round face, and was going on within--a constant howling and sneezing, and every now and then, and holding it to be ashamed of yourself,\' said Alice, quite forgetting her promise.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(69,'address','[\"519 Gavin Isle Apt. 061\\nNew Joshuaburgh, IL 11683\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(71,'title','[\"UX\\/UI Designer\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(72,'description','[\"Alice, \'Have you seen the Mock Turtle. \'Certainly not!\' said Alice aloud, addressing nobody in particular. \'She\'d soon fetch it back!\' \'And who is to France-- Then turn not pale, beloved snail, but.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(73,'address','[\"1800 Glover Underpass Suite 143\\nMicaelachester, NY 96944-8237\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(75,'title','[\"System Administrator\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(76,'description','[\"I\'ve offended it again!\' For the Mouse to tell him. \'A nice muddle their slates\'ll be in before the trial\'s begun.\' \'They\'re putting down their names,\' the Gryphon repeated impatiently: \'it begins.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(77,'address','[\"76486 Kyleigh Tunnel\\nGrayceton, TN 18559-2229\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(79,'title','[\"DevOps Engineer\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(80,'description','[\"Rabbit just under the door; so either way I\'ll get into her eyes--and still as she had this fit) An obstacle that came between Him, and ourselves, and it. Don\'t let him know she liked them best, For.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(81,'address','[\"9215 Bartoletti Square Suite 007\\nWuckertburgh, CT 77862-9675\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(83,'title','[\"System Administrator\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(84,'description','[\"Time, and round the thistle again; then the other, trying every door, she walked sadly down the chimney, has he?\' said Alice to herself. \'Shy, they seem to be\\\"--or if you\'d like it put more.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(85,'address','[\"5141 Jacobi Junction\\nFriesentown, OH 39949-5506\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(87,'title','[\"System Administrator\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(88,'description','[\"No, no! You\'re a serpent; and there\'s no use in crying like that!\' said Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the Gryphon went on again:-- \'You may not have lived.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(89,'address','[\"29497 Gleason Stravenue\\nLake Edythland, MN 17214-9627\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:54','2025-06-10 10:44:54'),(91,'title','[\"Quality Assurance\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(92,'description','[\"I know I do!\' said Alice indignantly, and she hastily dried her eyes anxiously fixed on it, (\'which certainly was not going to dive in among the branches, and every now and then treading on my tail.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(93,'address','[\"831 Edd Forest\\nImanifort, MA 00487-6470\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(95,'title','[\"Quality Assurance\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(96,'description','[\"Hatter instead!\' CHAPTER VII. A Mad Tea-Party There was nothing on it were white, but there was Mystery,\' the Mock Turtle recovered his voice, and, with tears running down his brush, and had come.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(97,'address','[\"730 Anahi Knoll\\nWest Zolachester, IA 48700\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(99,'title','[\"Product Manager\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(100,'description','[\"Mind now!\' The poor little thing grunted in reply (it had left off sneezing by this very sudden change, but she stopped hastily, for the hedgehogs; and in another moment that it might not escape.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(101,'address','[\"720 Madeline Glen\\nHarberton, WI 61714-0823\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(103,'title','[\"Project Manager\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(104,'description','[\"GAVE HER ONE, THEY GAVE HIM TWO--\\\" why, that must be really offended. \'We won\'t talk about her repeating \'YOU ARE OLD, FATHER WILLIAM,\' to the Duchess: \'flamingoes and mustard both bite. And the.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(105,'address','[\"8382 Billie Street Suite 810\\nWest Louvenia, VA 98411-5741\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(107,'title','[\"UX\\/UI Designer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(108,'description','[\"Latitude or Longitude I\'ve got back to the King, going up to her chin upon Alice\'s shoulder, and it was the only difficulty was, that if you only kept on good terms with him, he\'d do almost anything.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(109,'address','[\"5022 Daniel View Suite 539\\nWest Reinholdborough, IN 53858\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(111,'title','[\"DevOps Engineer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(112,'description','[\"Tarts? The King looked anxiously over his shoulder as she came upon a Gryphon, lying fast asleep in the chimney close above her: then, saying to herself \'This is Bill,\' she gave one sharp kick, and.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(113,'address','[\"246 Olson Ferry\\nSchowalterside, CO 76909\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:55','2025-06-10 10:44:55'),(115,'title','[\"Product Manager\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(116,'description','[\"That your eye was as much as serpents do, you know.\' \'I DON\'T know,\' said Alice, quite forgetting that she was trying to put his mouth close to her head, and she could not answer without a cat! It\'s.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(117,'address','[\"826 Senger Streets Suite 609\\nBraunton, NE 85165\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(119,'title','[\"Quality Assurance\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(120,'description','[\"Alice to herself. \'Of the mushroom,\' said the youth, \'as I mentioned before, And have grown most uncommonly fat; Yet you balanced an eel on the bank, with her arms round it as you say things are.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(121,'address','[\"65478 Grimes Road Apt. 437\\nErnserberg, AR 06386-4892\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(123,'title','[\"DevOps Engineer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(124,'description','[\"Gryphon: \'I went to the shore, and then quietly marched off after the rest of the sort!\' said Alice. \'What IS the use of a tree a few yards off. The Cat only grinned a little before she got up very.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(125,'address','[\"25497 Bethany Oval Apt. 443\\nEast Fred, HI 35664-9316\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(127,'title','[\"UX\\/UI Designer\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(128,'description','[\"King. \'Then it wasn\'t very civil of you to learn?\' \'Well, there was no more of the evening, beautiful Soup! \'Beautiful Soup! Who cares for fish, Game, or any other dish? Who would not open any of.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(129,'address','[\"52283 Welch Inlet\\nSpinkaview, WI 62366\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:44:56','2025-06-10 10:44:56'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(134,'event_id','[6]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(138,'event_id','[6]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14'),(142,'event_id','[8]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:45:14','2025-06-10 10:45:14');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner style=&quot;6&quot; title=&quot; Digital World &lt;br&gt; Conference&quot; description=&quot;From cutting-edge technology and digital transformation to leadership strategies and sustainable growth, Innovate 2024 provide.&quot; circle_text=&quot;Build Success Brand .&quot; image=&quot;homepage07/general/hero-banner-img-1.webp&quot; image_1=&quot;homepage07/general/hero-banner-img-2.webp&quot; button_primary_label=&quot;Reserve My Seat &quot; button_primary_url=&quot;/&quot; background_image=&quot;homepage07/backgrounds/hero-banner-bg.webp&quot;][/hero-banner]\n[about-us-information style=&quot;7&quot; title=&quot;Transforming the of Global &lt;br&gt; Economic Landscape&quot; circle_text=&quot;Build Success Brand .&quot; description=&quot;Our mission at Economy Event to drive meaningful dialogue, foster collaboration, spark innovative solutions for sustainable economic.&quot; button_label=&quot;Become an Attendee &quot; button_url=&quot;/&quot; quantity=&quot;2&quot; title_1=&quot;ECollaborating for Economic Impact&quot; description_1=&quot;This event brings together economists business leaders policymakers, and innovators from around the globe.&quot; url_1=&quot;/&quot; icon_1=&quot;ti ti-microphone-2&quot; title_2=&quot;Where Ideas Shape the Economy&quot; description_2=&quot;With a focus on topics such as global trade, financial technology, sustainable development, and policy.&quot; url_2=&quot;/&quot; icon_2=&quot;ti ti-bubble-text&quot; image=&quot;homepage07/general/about-us-information-img-1.webp&quot; image_1=&quot;homepage07/general/about-us-information-img-2.webp&quot; shape_image=&quot;homepage07/general/about-us-information-shape-img.webp&quot;][/about-us-information]\n[locations title=&quot;Explore Our 4 Venues&quot; quantity=&quot;4&quot; name_1=&quot;Marine City Michigan&quot; subtitle_1=&quot;Venue 01&quot; address_1=&quot;New York, USA&quot; image_1=&quot;homepage07/general/location-1.webp&quot; button_label_1=&quot;Virtual Tour &quot; button_url_1=&quot;/contact-us&quot; name_2=&quot;Kansas City Omaha&quot; subtitle_2=&quot;Venue 02&quot; address_2=&quot;New York, USA&quot; image_2=&quot;homepage07/general/location-2.webp&quot; button_label_2=&quot;Virtual Tour &quot; button_url_2=&quot;/contact-us&quot; name_3=&quot;New Hampshire City&quot; subtitle_3=&quot;Venue 03&quot; address_3=&quot;New York, USA&quot; image_3=&quot;homepage07/general/location-3.webp&quot; button_label_3=&quot;Virtual Tour &quot; button_url_3=&quot;/contact-us&quot; name_4=&quot;Marine City Michigan&quot; subtitle_4=&quot;Venue 04&quot; address_4=&quot;New York, USA&quot; image_4=&quot;homepage07/general/location-4.webp&quot; button_label_4=&quot;Virtual Tour &quot; button_url_4=&quot;/contact-us&quot; text_color=&quot;rgb(0, 0, 0)&quot; background_color=&quot;rgb(255, 243, 246)&quot;][/locations]\n[speakers style=&quot;7&quot; title=&quot;Our Esteemed Speakers&quot; limit=&quot;8&quot;][/speakers]\n[events-schedule style=&quot;4&quot; title=&quot;Our Events Schedule Plan&quot; number_days=&quot;5&quot; number_each_days=&quot;4&quot; text_color=&quot;rgb(255, 255, 255)&quot; background_color=&quot;rgb(0, 0, 0)&quot;][/events-schedule]\n[testimonials style=&quot;4&quot; title=&quot;In Their Words Feedback &lt;br&gt; That Drives Change&quot; testimonial_ids=&quot;1,2,3,4&quot;][/testimonials]\n[brands style=&quot;2&quot; subtitle=&quot;PARTNERS&quot; title=&quot;Our Valued Sponsors &amp; Partners&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot; text_color=&quot;#000000&quot; background_color=&quot;#FFF3F6&quot;][/brands]\n[blog-posts style=&quot;3&quot; category_ids=&quot;1,2,3,4&quot; limit=&quot;3&quot; title=&quot;Leadership in Strategies &lt;br&gt; For Economic Growth&quot; type=&quot;latest&quot;][/blog-posts]',1,NULL,'homepage',NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:44:39','2025-06-10 10:44:39');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'RVYMQWM4UQUY','bank_transfer',NULL,208.35,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,NULL),(2,'1',0,'JO3LDNF5MLBJ','bank_transfer',NULL,277.80,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,NULL),(3,'1',0,'VVZXGJZAEPRR','bank_transfer',NULL,138.90,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,NULL),(4,'1',0,'JLC3LE8TMVHT','bank_transfer',NULL,208.35,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,NULL),(5,'1',0,'8QTCGZPETUJ0','bank_transfer',NULL,69.45,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:03','2025-06-10 10:45:03',NULL,NULL),(6,'1',0,'0OIF3MZX3IGJ','bank_transfer',NULL,208.35,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(7,'1',0,'NIAM0UFHZ3IA','bank_transfer',NULL,138.90,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(8,'1',0,'QBEJB9YSGOVP','bank_transfer',NULL,138.90,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(9,'1',0,'NNBO0M4IAEM4','bank_transfer',NULL,69.45,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(10,'1',0,'BOMC8VKZHVFM','bank_transfer',NULL,138.90,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(11,'1',0,'2ROOJH5AVNMJ','bank_transfer',NULL,93.80,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(12,'1',0,'SWAFUQXU2XAP','bank_transfer',NULL,234.50,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(13,'1',0,'IIPDDHTNZOQ8','bank_transfer',NULL,93.80,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(14,'1',0,'TDNZ25BPFVPK','bank_transfer',NULL,234.50,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(15,'1',0,'NPW8NJJFGG8M','bank_transfer',NULL,140.70,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(16,'1',0,'49RJW9QZ9NSE','bank_transfer',NULL,187.60,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(17,'1',0,'QMTYM9IZGYGJ','bank_transfer',NULL,46.90,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(18,'1',0,'UXR0VZTQO986','bank_transfer',NULL,140.70,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:04','2025-06-10 10:45:04',NULL,NULL),(19,'1',0,'HXZZZ9MPSFHI','bank_transfer',NULL,187.60,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(20,'1',0,'5ZTLWDKOKCSP','bank_transfer',NULL,140.70,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(21,'1',0,'FH61INLDSJSX','bank_transfer',NULL,436.20,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(22,'1',0,'6LISUYLYNBHY','bank_transfer',NULL,436.20,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(23,'1',0,'E9O97SSE5GRM','bank_transfer',NULL,436.20,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(24,'1',0,'GY0SDAV0F8AR','bank_transfer',NULL,87.24,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(25,'1',0,'NVHDPYSIAWGM','bank_transfer',NULL,348.96,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(26,'1',0,'PRBBSYLMMFBG','bank_transfer',NULL,87.24,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(27,'1',0,'BG2DD5W6IVNQ','bank_transfer',NULL,87.24,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(28,'1',0,'XMA8M8SDKFLC','bank_transfer',NULL,174.48,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(29,'1',0,'3MD5HEI63IAM','bank_transfer',NULL,87.24,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(30,'1',0,'UJESNWRC0ZNW','bank_transfer',NULL,436.20,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(31,'1',0,'KBBGPWLXJ9Z2','bank_transfer',NULL,80.80,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:05','2025-06-10 10:45:05',NULL,NULL),(32,'1',0,'TQD4ZNXWJGST','bank_transfer',NULL,80.80,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(33,'1',0,'BULIXIFCJQM6','bank_transfer',NULL,32.32,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(34,'1',0,'GRMUNEPZIXJ6','bank_transfer',NULL,48.48,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(35,'1',0,'BDZ6RLM73YWF','bank_transfer',NULL,32.32,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(36,'1',0,'I7VWCB8W4TXE','bank_transfer',NULL,32.32,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(37,'1',0,'CO1MVOPDQUGT','bank_transfer',NULL,32.32,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(38,'1',0,'LM8LZGRF0DGH','bank_transfer',NULL,64.64,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(39,'1',0,'Z88OXMAJNH41','bank_transfer',NULL,48.48,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(40,'1',0,'8IZJNXD4B0ZV','bank_transfer',NULL,48.48,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(41,'1',0,'1OXWHJ4WNWWW','bank_transfer',NULL,54.40,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(42,'1',0,'LI2L1FFASQUH','bank_transfer',NULL,217.60,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(43,'1',0,'HARNTXCJJLSD','bank_transfer',NULL,217.60,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(44,'1',0,'PQFYOY1FON9X','bank_transfer',NULL,272.00,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:06','2025-06-10 10:45:06',NULL,NULL),(45,'1',0,'QCJTNL66BEQ7','bank_transfer',NULL,272.00,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL),(46,'1',0,'HDPMR2FNLUPR','bank_transfer',NULL,108.80,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL),(47,'1',0,'QRGWBUHWITBT','bank_transfer',NULL,108.80,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL),(48,'1',0,'7SBKPVC8VLOX','bank_transfer',NULL,272.00,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL),(49,'1',0,'PONTN99RJL0G','bank_transfer',NULL,108.80,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL),(50,'1',0,'D7EBXMGVEZ29','bank_transfer',NULL,54.40,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:45:07','2025-06-10 10:45:07',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (6,1),(4,1),(5,2),(5,3),(1,3),(1,4),(5,4),(2,5),(1,5),(1,6),(5,6),(1,7),(6,7),(2,8),(6,8),(4,9),(5,9),(5,10),(3,10),(3,11),(6,11),(2,12),(3,12),(5,13),(1,14),(3,14),(1,15),(5,15),(2,16),(2,17),(5,17),(1,18),(4,18),(3,19),(1,19),(6,20),(5,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (6,1),(2,1),(3,2),(6,2),(3,3),(6,3),(1,3),(7,4),(2,4),(4,5),(7,5),(3,6),(1,6),(6,6),(3,7),(2,7),(7,8),(6,8),(1,9),(6,9),(7,9),(7,10),(4,10),(3,11),(6,11),(7,11),(7,12),(4,12),(5,12),(2,13),(6,13),(5,14),(4,14),(1,14),(1,15),(4,15),(2,15),(7,16),(3,16),(1,16),(2,17),(4,17),(6,17),(1,18),(2,18),(5,18),(2,19),(5,19),(7,19),(6,20),(2,20),(3,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',2136,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',913,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',437,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',516,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',1855,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',2464,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',616,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1686,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',1660,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',323,NULL,'2025-06-10 10:44:45','2025-06-10 10:44:45'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1606,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',432,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',1736,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',2269,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',2108,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',843,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',1023,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',1125,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',621,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',2214,NULL,'2025-06-10 10:44:46','2025-06-10 10:44:46');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:44:22','2025-06-10 10:44:22');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=85 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:45:14'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:45:14'),(6,'language_hide_default','1',NULL,'2025-06-10 10:45:14'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:45:14'),(8,'language_display','all',NULL,'2025-06-10 10:45:14'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:45:14'),(10,'media_random_hash','5a9c8137aa8b4500556f5352b7e9d91b',NULL,'2025-06-10 10:45:14'),(11,'theme','eventify-homepage07',NULL,'2025-06-10 10:45:14'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:45:14'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:45:14'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:45:14'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:45:14'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:45:14'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:45:14'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:45:14'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:45:14'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:45:14'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:45:14'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:45:14'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:45:14'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:45:14'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:45:14'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:45:14'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:45:14'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:45:14'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:45:14'),(30,'theme-eventify-homepage07-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:45:14'),(31,'theme-eventify-homepage07-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:45:14'),(32,'theme-eventify-homepage07-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:45:14'),(33,'theme-eventify-homepage07-favicon','main/general/favicon.png',NULL,'2025-06-10 10:45:14'),(34,'theme-eventify-homepage07-logo','homepage07/general/logo.png',NULL,'2025-06-10 10:45:14'),(35,'theme-eventify-homepage07-homepage_id','1',NULL,'2025-06-10 10:45:14'),(36,'theme-eventify-homepage07-blog_page_id','4',NULL,'2025-06-10 10:45:14'),(37,'theme-eventify-homepage07-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:45:14'),(38,'theme-eventify-homepage07-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:45:14'),(39,'theme-eventify-homepage07-blog_post_items_per_row','3',NULL,'2025-06-10 10:45:14'),(40,'theme-eventify-homepage07-number_of_related_posts','3',NULL,'2025-06-10 10:45:14'),(41,'theme-eventify-homepage07-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:45:14'),(42,'theme-eventify-homepage07-breadcrumb_text_color','#000000',NULL,'2025-06-10 10:45:14'),(43,'theme-eventify-homepage07-events_page_id','5',NULL,'2025-06-10 10:45:14'),(44,'theme-eventify-homepage07-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:45:14'),(45,'theme-eventify-homepage07-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:45:14'),(46,'theme-eventify-homepage07-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:45:14'),(47,'theme-eventify-homepage07-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:45:14'),(48,'theme-eventify-homepage07-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:45:14'),(49,'theme-eventify-homepage07-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:45:14'),(50,'theme-eventify-homepage07-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:45:14'),(51,'theme-eventify-homepage07-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:45:14'),(52,'theme-eventify-homepage07-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:45:14'),(53,'theme-eventify-homepage07-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:45:14'),(54,'theme-eventify-homepage07-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:45:14'),(55,'theme-eventify-homepage07-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:45:14'),(56,'theme-eventify-homepage07-logo_height','45px',NULL,'2025-06-10 10:45:14'),(57,'theme-eventify-homepage07-is_header_transparent','1',NULL,'2025-06-10 10:45:14'),(58,'theme-eventify-homepage07-display_header_top','1',NULL,'2025-06-10 10:45:14'),(59,'theme-eventify-homepage07-header_top_text_color','#ffffff',NULL,'2025-06-10 10:45:14'),(60,'theme-eventify-homepage07-header_top_background_color','#FC226A',NULL,'2025-06-10 10:45:14'),(61,'theme-eventify-homepage07-header_background_color','#ffffff',NULL,'2025-06-10 10:45:14'),(62,'theme-eventify-homepage07-header_text_color','#000000',NULL,'2025-06-10 10:45:14'),(63,'theme-eventify-homepage07-footer_background_color','#FFF3F6',NULL,'2025-06-10 10:45:14'),(64,'theme-eventify-homepage07-footer_text_color','#544E51',NULL,'2025-06-10 10:45:14'),(65,'theme-eventify-homepage07-footer_heading_color','#1A1719',NULL,'2025-06-10 10:45:14'),(66,'theme-eventify-homepage07-tp_primary_font','Figtree',NULL,'2025-06-10 10:45:14'),(67,'theme-eventify-homepage07-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:45:14'),(68,'theme-eventify-homepage07-primary_color','#FC226A',NULL,'2025-06-10 10:45:14'),(69,'theme-eventify-homepage07-secondary_color','#1A1719',NULL,'2025-06-10 10:45:14'),(70,'theme-eventify-homepage07-newsletter_popup_enable','1',NULL,'2025-06-10 10:45:14'),(71,'theme-eventify-homepage07-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:45:14'),(72,'theme-eventify-homepage07-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:45:14'),(73,'theme-eventify-homepage07-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:45:14'),(74,'theme-eventify-homepage07-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:45:14'),(75,'theme-eventify-homepage07-breadcrumb_background_color','#FFF3F6',NULL,'2025-06-10 10:45:14'),(76,'announcement_max_width','1210',NULL,'2025-06-10 10:45:14'),(77,'announcement_text_color','#000000',NULL,'2025-06-10 10:45:14'),(78,'announcement_background_color','transparent',NULL,'2025-06-10 10:45:14'),(79,'announcement_text_alignment','start',NULL,'2025-06-10 10:45:14'),(80,'announcement_dismissible','0',NULL,'2025-06-10 10:45:14'),(81,'announcement_font_size','14',NULL,'2025-06-10 10:45:14'),(82,'announcement_font_size_unit','px',NULL,'2025-06-10 10:45:14'),(83,'announcement_placement','theme',NULL,'2025-06-10 10:45:14'),(84,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:45:14','2025-06-10 10:45:14'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:45:14','2025-06-10 10:45:14'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:45:14','2025-06-10 10:45:14');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:45:14','2025-06-10 10:45:14');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=140 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:44:22','2025-06-10 10:44:22'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:44:39','2025-06-10 10:44:39'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:44:45','2025-06-10 10:44:45'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:45','2025-06-10 10:44:45'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:44:46','2025-06-10 10:44:46'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:51','2025-06-10 10:44:51'),(59,'jayde-haag',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:51','2025-06-10 10:44:51'),(60,'gerardo-hoeger',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:52','2025-06-10 10:44:52'),(61,'dax-purdy',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:52','2025-06-10 10:44:52'),(62,'tod-auer',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:52','2025-06-10 10:44:52'),(63,'loy-koepp',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:52','2025-06-10 10:44:52'),(64,'miss-yazmin-gaylord-iv',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:52','2025-06-10 10:44:52'),(65,'mr-kim-white-iv',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(66,'dolores-schaefer',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(67,'howard-predovic',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(68,'marilyne-kilback',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(69,'pearline-roob',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(70,'parker-hills',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:53','2025-06-10 10:44:53'),(71,'laverne-hoeger',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:54','2025-06-10 10:44:54'),(72,'vallie-hirthe',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:54','2025-06-10 10:44:54'),(73,'dale-robel',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:54','2025-06-10 10:44:54'),(74,'olin-senger',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:54','2025-06-10 10:44:54'),(75,'cassidy-emmerich',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:55','2025-06-10 10:44:55'),(76,'dr-hellen-vonrueden',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:55','2025-06-10 10:44:55'),(77,'zora-white-phd',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:55','2025-06-10 10:44:55'),(78,'mr-milo-dickinson',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:55','2025-06-10 10:44:55'),(79,'antonietta-rau-ii',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:56','2025-06-10 10:44:56'),(80,'reginald-mitchell-iv',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:56','2025-06-10 10:44:56'),(81,'johnny-cummerata-sr',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:44:56','2025-06-10 10:44:56'),(82,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(83,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(84,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(85,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(86,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(87,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(88,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(89,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(90,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(91,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:45:03','2025-06-10 10:45:03'),(92,'dr-stephania-becker',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(93,'dakota-rice',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(94,'bernard-kuhn',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(95,'max-hansen',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(96,'dr-garry-ankunding',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(97,'keegan-toy',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(98,'rosella-kuhn',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:14','2025-06-10 10:45:14'),(99,'bradley-lindgren',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(100,'zachary-bartell',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(101,'cali-emmerich',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(102,'alfredo-okuneva-v',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(103,'frankie-auer-iv',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(104,'gladyce-kshlerin',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(105,'oliver-gleichner',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(106,'carlo-lesch',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(107,'prof-trey-nienow-iii',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(108,'dr-dominic-schuster-sr',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(109,'verdie-friesen-dvm',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(110,'mr-jovanny-okuneva',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(111,'prof-braeden-mante-jr',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(112,'mr-bruce-stroman-jr',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(113,'grant-rolfson',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(114,'ms-haven-stark-ii',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(115,'vance-beatty',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(116,'prof-walton-beier-dds',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(117,'mr-johan-haley-i',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(118,'marcus-wisoky',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(119,'vernice-kris',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(120,'lucile-boyer',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(121,'nikko-lynch',54,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(122,'vivianne-jones',55,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(123,'mercedes-gaylord',56,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(124,'josefina-kuhic',57,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(125,'margot-simonis',58,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(126,'rodrick-kiehn',59,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(127,'shawn-kassulke',60,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(128,'rollin-kuphal',61,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(129,'jenifer-gutmann',62,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(130,'prof-madison-langosh',63,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(131,'lelia-shanahan',64,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(132,'winifred-runte',65,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(133,'prof-enrique-fadel',66,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(134,'dortha-nikolaus',67,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(135,'monique-feil',68,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(136,'prof-jasen-herzog-ii',69,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(137,'gladyce-runolfsdottir',70,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(138,'mrs-sierra-bailey',71,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15'),(139,'jairo-davis',72,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:45:15','2025-06-10 10:45:15');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:44:56','2025-06-10 10:44:56');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:44:45','2025-06-10 10:44:45');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:44:23','2025-06-10 10:44:23'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:44:23','2025-06-10 10:44:23'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:44:23','2025-06-10 10:44:23'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:44:23','2025-06-10 10:44:23');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'mbailey@howell.com',NULL,'$2y$12$m.SG3Ro2hlMVVtB51erZlOdz5YZl8ixPT8VQ1FitgwDG5xVqhW2Lu',NULL,'2025-06-10 10:44:22','2025-06-10 10:44:22','Wendell','Goldner','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify-homepage07',1,'[]','2025-06-10 10:44:39','2025-06-10 10:44:39'),(2,'SocialLinksWidget','header_sidebar','eventify-homepage07',2,'[]','2025-06-10 10:44:39','2025-06-10 10:44:39'),(3,'SiteInformationWidget','footer_sidebar','eventify-homepage07',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage07',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify-homepage07',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(6,'GalleriesWidget','footer_sidebar','eventify-homepage07',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(7,'EventListWidget','event_list_sidebar','eventify-homepage07',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify-homepage07',1,'[]','2025-06-10 10:44:39','2025-06-10 10:44:39'),(9,'BlogSearchWidget','blog_sidebar','eventify-homepage07',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(10,'BlogCategoriesWidget','blog_sidebar','eventify-homepage07',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(11,'BlogTagsWidget','blog_sidebar','eventify-homepage07',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(12,'ActionBlockWidget','pre_footer_sidebar','eventify-homepage07',1,'{\"title\":\"Are you want to join our events?\",\"description\":\"It is a long established fact that a reader will be distracted by the readable content of a page when looking at its layout.\",\"button_label\":\"Register Now\",\"button_url\":\"\\/register\",\"background_image\":\"homepage07\\/backgrounds\\/hero-banner-bg.webp\"}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify-homepage07',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:44:39','2025-06-10 10:44:39'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify-homepage07',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:44:39','2025-06-10 10:44:39');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:45:15
