-- MySQL dump 10.13  Distrib 8.0.42, for Linux (x86_64)
--
-- Host: 127.0.0.1    Database: archi_eventify
-- ------------------------------------------------------
-- Server version	8.4.5

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `activations`
--

DROP TABLE IF EXISTS `activations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `code` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `completed` tinyint(1) NOT NULL DEFAULT '0',
  `completed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activations_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `activations`
--

LOCK TABLES `activations` WRITE;
/*!40000 ALTER TABLE `activations` DISABLE KEYS */;
INSERT INTO `activations` VALUES (1,1,'Ls9hXmMzKdie2oj1zj8akGn7U1OdZfFE',1,'2025-06-10 10:37:53','2025-06-10 10:37:53','2025-06-10 10:37:53');
/*!40000 ALTER TABLE `activations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `admin_notifications`
--

DROP TABLE IF EXISTS `admin_notifications`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `admin_notifications` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `action_label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `permission` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `admin_notifications`
--

LOCK TABLES `admin_notifications` WRITE;
/*!40000 ALTER TABLE `admin_notifications` DISABLE KEYS */;
/*!40000 ALTER TABLE `admin_notifications` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads`
--

DROP TABLE IF EXISTS `ads`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expired_at` datetime DEFAULT NULL,
  `location` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `clicked` bigint NOT NULL DEFAULT '0',
  `order` int DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `open_in_new_tab` tinyint(1) NOT NULL DEFAULT '1',
  `tablet_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `mobile_image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `ads_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `google_adsense_slot_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `ads_key_unique` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads`
--

LOCK TABLES `ads` WRITE;
/*!40000 ALTER TABLE `ads` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `ads_translations`
--

DROP TABLE IF EXISTS `ads_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `ads_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `ads_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`ads_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `ads_translations`
--

LOCK TABLES `ads_translations` WRITE;
/*!40000 ALTER TABLE `ads_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `ads_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements`
--

DROP TABLE IF EXISTS `announcements`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `has_action` tinyint(1) NOT NULL DEFAULT '0',
  `action_label` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_url` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `action_open_new_tab` tinyint(1) NOT NULL DEFAULT '0',
  `dismissible` tinyint(1) NOT NULL DEFAULT '0',
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `is_active` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements`
--

LOCK TABLES `announcements` WRITE;
/*!40000 ALTER TABLE `announcements` DISABLE KEYS */;
INSERT INTO `announcements` VALUES (1,'Announcement 1','\"Hamilton\" Returns - Book Now Before Tickets Sell Out!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:38:46',NULL,1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(2,'Announcement 2','Experience Magic: Cirque du Soleil Exclusive Pre-Sale',1,'Buy Ticket','/events',0,0,'2025-06-10 10:38:46',NULL,1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(3,'Announcement 3','Coachella 2024: Early Bird Access Opens Tomorrow!',1,'Buy Ticket','/events',0,0,'2025-06-10 10:38:46',NULL,1,'2025-06-10 10:38:46','2025-06-10 10:38:46');
/*!40000 ALTER TABLE `announcements` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `announcements_translations`
--

DROP TABLE IF EXISTS `announcements_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `announcements_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `announcements_id` bigint unsigned NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`announcements_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `announcements_translations`
--

LOCK TABLES `announcements_translations` WRITE;
/*!40000 ALTER TABLE `announcements_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `announcements_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `audit_histories`
--

DROP TABLE IF EXISTS `audit_histories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `audit_histories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `module` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `action` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `actor_id` bigint unsigned NOT NULL,
  `actor_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'Botble\\ACL\\Models\\User',
  `reference_id` bigint unsigned NOT NULL,
  `reference_name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `audit_histories_user_id_index` (`user_id`),
  KEY `audit_histories_module_index` (`module`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `audit_histories`
--

LOCK TABLES `audit_histories` WRITE;
/*!40000 ALTER TABLE `audit_histories` DISABLE KEYS */;
/*!40000 ALTER TABLE `audit_histories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache`
--

DROP TABLE IF EXISTS `cache`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache`
--

LOCK TABLES `cache` WRITE;
/*!40000 ALTER TABLE `cache` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cache_locks`
--

DROP TABLE IF EXISTS `cache_locks`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cache_locks` (
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `owner` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `expiration` int NOT NULL,
  PRIMARY KEY (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cache_locks`
--

LOCK TABLES `cache_locks` WRITE;
/*!40000 ALTER TABLE `cache_locks` DISABLE KEYS */;
/*!40000 ALTER TABLE `cache_locks` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories`
--

DROP TABLE IF EXISTS `categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'Botble\\ACL\\Models\\User',
  `icon` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_featured` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_parent_id_index` (`parent_id`),
  KEY `categories_status_index` (`status`),
  KEY `categories_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
INSERT INTO `categories` VALUES (1,'Business Innovation',0,'Est est non nemo debitis laborum inventore eius. Quam est tenetur quas consequatur facere. Minus facere officia sapiente aliquid nobis. Impedit nemo cumque aut nulla et. A numquam nemo maxime qui.','published',1,'Botble\\ACL\\Models\\User',NULL,0,0,0,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(2,'Leadership &amp; Strategy',0,'Dolor aut sed dignissimos laudantium dolores. Sequi tenetur odit molestiae dolorum corporis et. Facilis non quam fugiat officiis. Nihil velit dolores minus quas. Minima quasi nihil et ad animi sunt.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(3,'Networking &amp; Collaboration',0,'Deserunt voluptatibus qui nihil eos qui deleniti nisi. Libero eum ut ipsam aut ipsa. Tempore unde nemo id praesentium sequi eum velit. Eum non labore sit.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(4,'Entrepreneurship Startups',0,'Itaque doloremque deleniti voluptatem facere similique. Est aliquid eaque repellat iste rerum ut. Illum consequatur iusto ad sunt dolor rerum laudantium.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(5,'Marketing &amp; Branding',0,'Corporis voluptate non mollitia dicta aut. Non libero sapiente assumenda labore. Rerum accusamus sint quae dolores iste.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(6,'Event Highlights &amp; Recaps',0,'Quos et sit omnis deserunt saepe ut. Atque cupiditate et dolor accusantium et ex. Impedit magnam totam dolorum qui magnam ea quidem.','published',1,'Botble\\ACL\\Models\\User',NULL,0,1,0,'2025-06-10 10:38:19','2025-06-10 10:38:19');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `categories_translations`
--

DROP TABLE IF EXISTS `categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `categories_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories_translations`
--

LOCK TABLES `categories_translations` WRITE;
/*!40000 ALTER TABLE `categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities`
--

DROP TABLE IF EXISTS `cities`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `record_id` varchar(40) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `cities_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities`
--

LOCK TABLES `cities` WRITE;
/*!40000 ALTER TABLE `cities` DISABLE KEYS */;
INSERT INTO `cities` VALUES (1,'Paris','paris',1,1,NULL,0,'locations/location1.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(2,'London','london',2,2,NULL,0,'locations/location2.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(3,'New York','new-york',3,3,NULL,0,'locations/location3.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(4,'New York','new-york-1',4,4,NULL,0,'locations/location4.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(5,'Copenhagen','copenhagen',5,5,NULL,0,'locations/location5.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(6,'Berlin','berlin',6,6,NULL,0,'locations/location6.png',0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31');
/*!40000 ALTER TABLE `cities` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `cities_translations`
--

DROP TABLE IF EXISTS `cities_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `cities_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `cities_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`cities_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cities_translations`
--

LOCK TABLES `cities_translations` WRITE;
/*!40000 ALTER TABLE `cities_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `cities_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options`
--

DROP TABLE IF EXISTS `contact_custom_field_options`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `custom_field_id` bigint unsigned NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` int NOT NULL DEFAULT '999',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options`
--

LOCK TABLES `contact_custom_field_options` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_field_options_translations`
--

DROP TABLE IF EXISTS `contact_custom_field_options_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_field_options_translations` (
  `contact_custom_field_options_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `label` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_field_options_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_field_options_translations`
--

LOCK TABLES `contact_custom_field_options_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_field_options_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields`
--

DROP TABLE IF EXISTS `contact_custom_fields`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` int NOT NULL DEFAULT '999',
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields`
--

LOCK TABLES `contact_custom_fields` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_custom_fields_translations`
--

DROP TABLE IF EXISTS `contact_custom_fields_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_custom_fields_translations` (
  `contact_custom_fields_id` bigint unsigned NOT NULL,
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `placeholder` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`contact_custom_fields_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_custom_fields_translations`
--

LOCK TABLES `contact_custom_fields_translations` WRITE;
/*!40000 ALTER TABLE `contact_custom_fields_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_custom_fields_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contact_replies`
--

DROP TABLE IF EXISTS `contact_replies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contact_replies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `message` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `contact_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contact_replies`
--

LOCK TABLES `contact_replies` WRITE;
/*!40000 ALTER TABLE `contact_replies` DISABLE KEYS */;
/*!40000 ALTER TABLE `contact_replies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `contacts`
--

DROP TABLE IF EXISTS `contacts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `contacts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subject` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_fields` text COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'unread',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contacts`
--

LOCK TABLES `contacts` WRITE;
/*!40000 ALTER TABLE `contacts` DISABLE KEYS */;
INSERT INTO `contacts` VALUES (1,'Robbie Skiles','thora.tillman@example.net','1-551-200-0461','87855 Towne Fort Apt. 699\nSonnymouth, WI 03648-1484','Nemo iusto ea qui aut aut.','A quia est aliquid eaque labore animi perferendis. Nihil dolor exercitationem voluptas dignissimos non voluptas. Pariatur nulla et est voluptatum. Voluptatem est dolores sed aperiam officia nesciunt a. Eos est ut doloribus non. Excepturi corrupti expedita consequatur illum. Necessitatibus facilis doloribus nulla ipsam quas deserunt deserunt. Cum quia esse quod. Quas in quia eius. Quos sapiente ut magnam voluptas.',NULL,'unread','2025-06-10 10:37:54','2025-06-10 10:37:54'),(2,'Cassandra Cole IV','okilback@example.com','720.853.0650','38442 Alexandro Crest Apt. 355\nWest Euna, GA 66592-4129','Veniam voluptate odit tempore harum.','Et libero veritatis et officiis facilis itaque non. Non eligendi explicabo voluptatem quisquam perferendis enim. Hic et et unde. Et et dolor quaerat est repellat itaque. Fuga consequatur ab et consequatur error quae. Non voluptates laborum vel et voluptates repudiandae qui amet. Dignissimos nihil aliquid perspiciatis eum est.',NULL,'unread','2025-06-10 10:37:54','2025-06-10 10:37:54'),(3,'Prof. Zackary Hansen','maryam14@example.net','+15413845543','888 Bernier Garden Suite 958\nPort Sarah, DE 58018-2717','Quidem aspernatur ut ut tempore porro.','Corrupti nostrum consequuntur et laudantium pariatur modi. Ex omnis vitae dolorem. Sed at iusto voluptate ipsa. Et repellendus ex aperiam ipsa. Quam adipisci ut aut nulla laborum. Officiis provident officia recusandae earum aut magnam. Rerum beatae doloribus dolorem voluptas aperiam natus. Molestiae quia consectetur aut laudantium.',NULL,'unread','2025-06-10 10:37:54','2025-06-10 10:37:54'),(4,'Jermain Hirthe','wilhelm.skiles@example.com','408-686-0117','793 Zaria Junctions\nNew Arturomouth, CT 77477-8709','Quia quibusdam ea ea qui corporis corrupti sit.','Corrupti ut officia recusandae non rerum qui. Rerum deleniti sit recusandae dolorem sapiente est. Reprehenderit officiis voluptatum totam. Tempora pariatur porro enim. Qui quasi aut aut voluptatum cupiditate. Enim deserunt in facilis qui magni modi voluptatem. Quod dolorum tempore quos eveniet et ut explicabo. Voluptatem rerum quos quis perferendis.',NULL,'read','2025-06-10 10:37:54','2025-06-10 10:37:54'),(5,'Elfrieda King','cdibbert@example.org','1-737-463-9400','957 Darrion Falls\nEast Isaiville, WI 04982-0133','Iure deserunt tempore laudantium sed id sed eius.','Earum neque modi dolorem culpa et autem maxime ut. Iure explicabo sit labore omnis repellendus sed autem. Consequuntur veritatis minus adipisci consequatur ipsa molestiae expedita. Omnis libero est amet molestiae unde possimus. Harum sint sint id accusamus reprehenderit dolorem. Cupiditate itaque perspiciatis rerum rerum vero dolores. Hic voluptatibus quas est nihil. Consequatur minima doloribus ut nisi sed.',NULL,'read','2025-06-10 10:37:54','2025-06-10 10:37:54'),(6,'Immanuel Jacobs Sr.','block.sanford@example.org','937.228.9017','94848 Powlowski Hill Apt. 167\nGulgowskiberg, NV 51261-0620','Ea nemo et ut sit. Quia autem aut nam quos a.','Vel delectus provident culpa quaerat aut autem. Et amet eveniet voluptatibus dolor corrupti aperiam consequuntur. Rem sapiente quisquam est. Veritatis et enim nemo excepturi magni. Voluptas nihil qui et nam sapiente. Velit voluptatum aliquid et qui. Temporibus est enim aut a provident. Minima ut quia dolor minus eveniet.',NULL,'unread','2025-06-10 10:37:54','2025-06-10 10:37:54'),(7,'Lisandro Ferry','joanne.huels@example.com','1-640-909-8025','545 Goyette Oval\nSouth Wilhelmstad, WY 74026-8164','Iure maxime modi voluptas voluptas quaerat quam.','Molestias officia suscipit sapiente praesentium. Quis est esse ut id non in veritatis. Atque velit qui cupiditate aut a laudantium magnam quia. Aut veritatis sit consequatur ut minus. Reiciendis alias fugit deserunt minima sit ea. Eos molestiae placeat natus at fuga impedit. Sapiente id voluptatem enim quidem sunt atque rerum debitis. Aliquam rerum beatae odit facilis qui necessitatibus. Qui expedita ipsum modi necessitatibus ullam. Voluptas asperiores quisquam minima et id qui sit dolores.',NULL,'read','2025-06-10 10:37:54','2025-06-10 10:37:54'),(8,'Magnolia Little','oberbrunner.ken@example.org','+16782960720','1007 Bode Lodge\nMcLaughlinchester, IL 77900','Est tempore officia illo dolore facere nam.','Omnis voluptates nihil molestiae voluptatem quas. Et veritatis sit eveniet debitis quia. Eius corporis est et. Est non nulla consequatur quis sit voluptatum et. Repellat ad rerum eaque qui ducimus doloribus amet. Natus assumenda qui rerum sit dolorem doloremque ullam omnis. Nisi sapiente necessitatibus odio et. Necessitatibus sunt quod culpa sed.',NULL,'read','2025-06-10 10:37:54','2025-06-10 10:37:54'),(9,'Isai Huels','eprice@example.com','1-475-832-9027','9893 Lori Cove Apt. 109\nGutkowskiport, SC 09511','Aut et modi vel ducimus.','Consequatur consequatur ut nam eum nostrum dignissimos dignissimos. Ad aut dolorum dicta voluptas qui. Quasi odit non totam cum non. Qui ab eos suscipit quia qui. Dolor est rerum repellendus sapiente ea et non. Modi dolor non vel est recusandae neque sed. Qui beatae nobis facilis ea est et vel. Ipsa hic illo sequi delectus tenetur illo. Qui itaque et est. Sed voluptatem ullam eligendi. Enim itaque aspernatur labore voluptatem aut ea. Modi accusamus minus aliquam dolorum quia voluptas.',NULL,'unread','2025-06-10 10:37:54','2025-06-10 10:37:54'),(10,'Ms. Sharon Schimmel','spencer.milford@example.com','575-699-1060','14717 Roslyn Trail Apt. 775\nDeshaunfort, RI 29876-5382','Sed reprehenderit aut et deserunt qui.','Alias praesentium voluptatem ipsa ipsam excepturi est. Sit eum et libero vel. Et eum quae error sapiente ipsa autem qui blanditiis. Aperiam dolorem commodi voluptatem adipisci. Nesciunt provident necessitatibus et officia facilis laboriosam. Eos quo sed eius quis amet et. Repellendus debitis aut amet sed velit ea maxime. Et et reprehenderit ipsam provident. Consequatur deserunt consequatur dolores animi dolores tempora aut.',NULL,'read','2025-06-10 10:37:54','2025-06-10 10:37:54');
/*!40000 ALTER TABLE `contacts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries`
--

DROP TABLE IF EXISTS `countries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `code` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
INSERT INTO `countries` VALUES (1,'France','French',0,0,'published','2025-06-10 10:38:31',NULL,'FRA'),(2,'England','English',0,0,'published','2025-06-10 10:38:31',NULL,'UK'),(3,'USA','Americans',0,0,'published','2025-06-10 10:38:31',NULL,'US'),(4,'Holland','Dutch',0,0,'published','2025-06-10 10:38:31',NULL,'HL'),(5,'Denmark','Danish',0,0,'published','2025-06-10 10:38:31',NULL,'DN'),(6,'Germany','Danish',0,0,'published','2025-06-10 10:38:31',NULL,'DN');
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `countries_translations`
--

DROP TABLE IF EXISTS `countries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `countries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `countries_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `nationality` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`countries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries_translations`
--

LOCK TABLES `countries_translations` WRITE;
/*!40000 ALTER TABLE `countries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `countries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widget_settings`
--

DROP TABLE IF EXISTS `dashboard_widget_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widget_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `settings` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `widget_id` bigint unsigned NOT NULL,
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `status` tinyint unsigned NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dashboard_widget_settings_user_id_index` (`user_id`),
  KEY `dashboard_widget_settings_widget_id_index` (`widget_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widget_settings`
--

LOCK TABLES `dashboard_widget_settings` WRITE;
/*!40000 ALTER TABLE `dashboard_widget_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widget_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `dashboard_widgets`
--

DROP TABLE IF EXISTS `dashboard_widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `dashboard_widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dashboard_widgets`
--

LOCK TABLES `dashboard_widgets` WRITE;
/*!40000 ALTER TABLE `dashboard_widgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `dashboard_widgets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_account_password_resets`
--

DROP TABLE IF EXISTS `eb_account_password_resets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_account_password_resets` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  KEY `eb_account_password_resets_email_index` (`email`),
  KEY `eb_account_password_resets_token_index` (`token`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_account_password_resets`
--

LOCK TABLES `eb_account_password_resets` WRITE;
/*!40000 ALTER TABLE `eb_account_password_resets` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_account_password_resets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_accounts`
--

DROP TABLE IF EXISTS `eb_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `password` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `avatar` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `dob` date DEFAULT NULL,
  `type` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'attendee',
  `status` varchar(30) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'activated',
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `confirmed_at` datetime DEFAULT NULL,
  `email_verify_token` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_accounts_email_unique` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_accounts`
--

LOCK TABLES `eb_accounts` WRITE;
/*!40000 ALTER TABLE `eb_accounts` DISABLE KEYS */;
INSERT INTO `eb_accounts` VALUES (1,'Joyce Lemke','customer@archielite.com','$2y$12$9tFc/MQBaTWjIDHYn5yHV.GjaMu2m.ampp8yGvYS.lRwA6xqBY5qO',NULL,'0130674562','2011-03-14','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:25','2025-06-10 10:38:25'),(2,'Michael Smith','kerluke.andreane@sauer.com','$2y$12$3./uOhGjwT6wypM2/Prvne2iKw723syISci4q8qx6AgbQ/VWVwOUG','main/speakers/8.png','0005233777','2018-11-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:25','2025-06-10 10:38:25'),(3,'Desmond Tillman','christa75@hotmail.com','$2y$12$/X5Ui2AqvEBCc4w4JbWWTuFmVgJOMojLmIHYXSnH.OZzb/7yfqXcK',NULL,'0227348020','1997-02-17','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:25','2025-06-10 10:38:25'),(4,'Wilfrid Bruen','casimer.bechtelar@pfannerstill.com','$2y$12$ik8kO7qbKTlw0bBpmEUKwOcMIz9M9YdNR47RBY0va2Hj4pRVhiGJa','main/speakers/6.png','0117072566','2000-10-15','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:25','2025-06-10 10:38:25'),(5,'Prof. Ben Schiller II','sschroeder@gmail.com','$2y$12$FJkS4bkH7BhYtonDCh.bIO/HBVeB4GjEZCGSIV5WwLRUawcWE1Ay6','main/speakers/1.png','0237998598','1999-10-03','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:25','2025-06-10 10:38:25'),(6,'Dr. Lorine Christiansen','alanna.vandervort@willms.info','$2y$12$fOyFDBGZbLOKfnDXP3y9VOsfyVKVpD5ypNsott9DzeKCBoYRdYpBO','main/speakers/2.png','0675434947','2014-05-02','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:26','2025-06-10 10:38:26'),(7,'Sherman Konopelski','terrill.kreiger@white.net','$2y$12$QPfYS1EKSrjX7qFSf72HXO4xC7Q3nSHejzIolS3dGa6SizkCs2h6q','main/speakers/8.png','0310420001','2006-03-12','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:26','2025-06-10 10:38:26'),(8,'Mrs. Abagail Smitham','hane.malika@yahoo.com','$2y$12$KiJX4VNcarotfGV2cusljeOwzPg4IMiozqP0XdDvSTbVGmsH0LMjK','main/speakers/9.png','0245998636','2003-07-07','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:26','2025-06-10 10:38:26'),(9,'Stan Cummerata I','daniel.sheila@king.com','$2y$12$/nxdy1d5UL0qrgQlsHchzuPNpj41D4sGlZpERdqRAIAkQoY3luZym','main/speakers/8.png','0489229156','2022-05-20','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:26','2025-06-10 10:38:26'),(10,'Trystan Bechtelar','lenore.schmidt@wilkinson.com','$2y$12$fSj049iSqb2G3nBR1KqqhO.6QlrtBuFkbPSUqIkE8tCEb/NNsRRmW',NULL,'0751434379','2007-11-09','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:26','2025-06-10 10:38:26'),(11,'Prof. Orin Tremblay','esperanza59@adams.com','$2y$12$eGfZFceTCs8DM9sfSG0rHOkk8od/OdXdCubbWttcVtFiMj6QadPOa','main/speakers/1.png','0019125889','1996-08-03','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:27','2025-06-10 10:38:27'),(12,'May Heaney','wilbert.lemke@predovic.com','$2y$12$oLRPAYC7yfOZ.3nLsAZrReODGwkxlVZzbi0qECS2EaSjNGfz0o/Oq','main/speakers/9.png','0225045646','1997-06-26','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:27','2025-06-10 10:38:27'),(13,'Gerhard Mosciski','isadore.cruickshank@stoltenberg.com','$2y$12$EA8vbUWl2csM7THhQ.Ya0u0yM4n7As4rwQmUUUwsfA2coEfr9qgH6','main/speakers/10.png','0337001234','2003-09-04','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:27','2025-06-10 10:38:27'),(14,'Juana Purdy','bosco.abby@schaden.com','$2y$12$pq4TrZ7Hvl9posGJGTkoG.6V9jzqW7b38.xovHCaFL3eX8HUL/zp.','main/speakers/9.png','0819653004','2001-12-13','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:27','2025-06-10 10:38:27'),(15,'Edison Raynor','josiah.goyette@emard.com','$2y$12$ZeW4zq/UrJm3BUBFVo69neu7QzIeVUxgry7A3LUpSQoKPe.BdXVMS','main/speakers/3.png','0098787748','2024-11-09','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(16,'Dr. Kennedi Kemmer','tamara97@conroy.com','$2y$12$7V52EPEcNmHc8CC.uFz8a.BYZLjcr/zWlSg06wt/HkH09v7b0YNGS','main/speakers/2.png','0647436338','2001-11-16','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(17,'Kayley Watsica','dasia81@welch.com','$2y$12$65Cu5xaiU54J68dPuH0IhufjBDq1yWrfmlgJ8v.rURmBLBnNh8xIW',NULL,'0543085965','1997-11-17','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(18,'Trudie Cassin','ricky.powlowski@yahoo.com','$2y$12$/agXDsFlQIcBdlERxELeGOoHo.mMlXSOomasNyNGtW4B323nVNdzW','main/speakers/1.png','0424955736','2009-07-27','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(19,'Dalton Okuneva','jkilback@rutherford.org','$2y$12$hUwO3WXgXt0poCzV9jpqfeZlY7rskALwsqgdnWNz435QTJgnI9xra',NULL,'0333984919','2001-06-14','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(20,'Reinhold Harber','everardo33@klocko.com','$2y$12$Amb8lAVrUc96EzeLp.DJBeJa0mFxfEizqVWnrxVbFymNQyAQFeiXG','main/speakers/4.png','0870478063','2020-12-07','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:28','2025-06-10 10:38:28'),(21,'Ashleigh Will','yhudson@dibbert.net','$2y$12$xOOJdPrwkYnWi3UX.DYfaOWXvgta9dDHk36sQg0/oenjffR.wsuyW','main/speakers/2.png','0605037407','2015-02-28','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:29','2025-06-10 10:38:29'),(22,'Juliet Steuber II','xconnelly@yahoo.com','$2y$12$gdU8uaB9eFJDyoDd3IOoY.mSFrB4waV0UrcYydqY24P3mg4n11ulS',NULL,'0107246886','2022-12-13','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:29','2025-06-10 10:38:29'),(23,'Asia Metz','gene.waelchi@stiedemann.com','$2y$12$EfM0tQHEoWpVba9l/VAoqe9voeWpOkOiaRO9sRH9FtMMgOTCq5gdi','main/speakers/4.png','0316504628','2014-11-29','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:29','2025-06-10 10:38:29'),(24,'Prof. Yasmine Trantow','tara76@haley.com','$2y$12$0xtKCVw.XIAV37TahCCRZOoQqDr6iSq0tK0aD6b4vTxo0a8goEooG','main/speakers/8.png','0688272369','1997-02-16','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:29','2025-06-10 10:38:29'),(25,'Howard Runte Jr.','wiza.oral@little.com','$2y$12$/.qYYYUy/iQxiSDo.ogp1eB02sTXqxUp0dnc1KnzC0S3WxQtQh.4e','main/speakers/7.png','0599627309','2014-05-31','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:29','2025-06-10 10:38:29'),(26,'Randall Koch II','marvin.jaqueline@gaylord.com','$2y$12$AzlrJF0egjyZ3sOz/D2UYOlWWXi2tON7Okkfnf31zWw6Sj7LJRsIy',NULL,'0845008060','1999-10-01','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:30','2025-06-10 10:38:30'),(27,'Melyna Simonis','kuhlman.joelle@gleichner.com','$2y$12$fxG9JSwlA2JF9q9lyOiGCepIuyuo.4cxI5Qeiy7bsmB8oijypZhD2',NULL,'0610985164','2016-04-16','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:30','2025-06-10 10:38:30'),(28,'Lera Olson','plowe@wiegand.com','$2y$12$QOioOh/Bp38kuURVlRRjQ.uIgjWaniGx5.qqy/JsC7ZeznBVZtwfO','main/speakers/9.png','0896924929','2007-10-18','organizer','activated',NULL,NULL,NULL,'2025-06-10 10:38:30','2025-06-10 10:38:30'),(29,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','$2y$12$5esyGnXIL1yB7ZFksOxvO.TaitZepCVQZbA.PEkRmvA8g5Frdq5pe',NULL,'0754798071','2002-06-29','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:30','2025-06-10 10:38:30'),(30,'Alexzander Zemlak','shaun.wolf@yahoo.com','$2y$12$o34uJuCOh9hLrFjFBmQ99e88JRHGzwplBoCTundcpx3nwMFoTzZjK',NULL,'0823276304','2002-04-18','attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:30','2025-06-10 10:38:30'),(31,'Kenyon Stokes','lonie39@mills.info','$2y$12$qBESZgwvzxrLVW9h0/jVdOdqASkZ.WAaFgdd8/kGcBhnFSSepm9.G','main/speakers/2.png','0632593418','2017-02-02','speaker','activated',NULL,NULL,NULL,'2025-06-10 10:38:31','2025-06-10 10:38:31'),(32,'Ford Gusikowski','ewisozk@yahoo.com','$2y$12$.Y0tn3l5.AZ4YCzKcvER6OcfdcGVGqKWNHu58V/Ssa4T.xZA/mDVW',NULL,'0312803984',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(33,'Salvatore Swift DVM','vullrich@hotmail.com','$2y$12$SJeWD8qsYGpUb.BnG8kz1OE00266cJXjshBe4HXYnf/d8N3eaVUG.',NULL,'0193828282',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(34,'Lenora Heaney MD','wilber22@gmail.com','$2y$12$dAF9LUTI1KTcsMKk.T7bZ.2kLHSMEv/wGg49ajrEOWaRf27k3rtLS',NULL,'0412229300',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(35,'Destini Lindgren','irwin83@gmail.com','$2y$12$2hJh.jGV7g3cwFmzutydyuR6QNI7AXqCvxa6dLmyC8a5Jx2swmdL.',NULL,'0252171374',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(36,'Winnifred Boehm','schaefer.emmet@dicki.com','$2y$12$8WyfuGKukwQh3e6uMjO0VOo7g2ahfIcAf6SGd2gfN76yyj1wyO/pq',NULL,'0976046696',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(37,'Wendell Goodwin DVM','ahalvorson@kemmer.com','$2y$12$prcPL2BSX.fva3bByLbsCOVEzwDD/Kb/9PfNwm/dVKAxHG8zs9DNi',NULL,'0646685753',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(38,'Sylvan Rodriguez','hillary.king@roberts.com','$2y$12$5gWtmphKUSFeJJC8zeuk3.9BlTQp71NLoV0OuWrjC/Z139BDZz8TC',NULL,'0355074997',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(39,'Mr. Riley Gerhold','karelle55@wisoky.com','$2y$12$xMJj7ybtlDAW8Bp.renRrez4ri1zBjsS9xPgBCFkE1XC0pyOGfCC6',NULL,'0648631181',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(40,'Mr. Eladio Bradtke','eusebio15@luettgen.org','$2y$12$SA3Jnz3ICqPw7lu3uEoMOeyXO4e5eeR9gN1BXKDg.J0J36kt2boP.',NULL,'0658626776',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(41,'Layne Hermiston','eondricka@yahoo.com','$2y$12$09SzGw3tI38BdsSh/zDOk.AGO1a3dZKcpbG0tEDLfVcIH56F9b876',NULL,'0394933086',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(42,'Miss Matilda Kuhic II','thompson.esther@wintheiser.info','$2y$12$crtJzFw5V4sN91W1n/Tgduv7qKGSqepJlPxVcS2JaEtHwRUCmCf0C',NULL,'0332208497',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(43,'Otho Hauck','ymarks@lakin.com','$2y$12$09bItwAgarj3UiR9Rxnmf.mz8LUXi0KzvgpjtCniGaArJfXM8uBi.',NULL,'0794154587',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(44,'Prof. Coleman Harvey Sr.','fritz.kertzmann@nienow.com','$2y$12$4l7zskHRaycd536U9cuazOXggljPb8HDJy002SyYDj/23jwgEcBpO',NULL,'0346179802',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:44','2025-06-10 10:38:44'),(45,'Ms. Aylin Nitzsche','xhahn@gutkowski.com','$2y$12$L1p1kQR0JiOOwZI3XAZFmORZWU1ppTGlpj1Gjx5Wzc8sFXIdpzRUG',NULL,'0590141237',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(46,'Dr. Nash Kunde','kautzer.louisa@gmail.com','$2y$12$e10YvwEMo89fQbayjTLTqOkR1t4Kx/dZI3CVADQg3Ogt4deQrHBK2',NULL,'0302595133',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(47,'Isabella Lockman','shanon16@yahoo.com','$2y$12$yT.uuyejgrcnb6JnV.rH8upREkY1kg3NJlVwfO5f/o/DZJ.17M1AC',NULL,'0646714573',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(48,'Flo Brekke','sonya.mosciski@stehr.com','$2y$12$Nus0qPvHxC1KiYaIYgzxjucxQRBuunWZJUF3QP1OAn5AejAuh2xFK',NULL,'0203552996',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(49,'Estel Flatley','rita.mcclure@thompson.com','$2y$12$qUkyzcYx7z3aXvsts9H4iO289xKNB0vVmOvZNUf5od8DkaLHDWbde',NULL,'0844469241',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(50,'Mrs. Alison Monahan','oral79@gmail.com','$2y$12$yqBbPdBrrdSJbTxFl980Mud4DvjxQ5LNVkqXGP80OMvnx/QMcsSMa',NULL,'0383077671',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:45','2025-06-10 10:38:45'),(51,'Randy Gulgowski','vgaylord@yahoo.com','$2y$12$rMHpnAMou8GI3bs5fhtSKefn0WZA9pH2KgKp1xwmEIKYlSNeWWkyi',NULL,'0833934178',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(52,'Luigi Kris','jaeden52@lesch.com','$2y$12$ya2x43qt0P7sIXHJtd0EK.CUaEJWgohXBe1h3kxVqvCWVWz4y0KXG',NULL,'0083127185',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(53,'Jarvis West','eldora.koss@yahoo.com','$2y$12$7hO8TGI6rIiSwsovCAVFr.LwUitSUFpYPo1vYmYNoW4KQkgnWXco6',NULL,'0853484716',NULL,'attendee','activated',NULL,NULL,NULL,'2025-06-10 10:38:46','2025-06-10 10:38:46');
/*!40000 ALTER TABLE `eb_accounts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_coupons`
--

DROP TABLE IF EXISTS `eb_coupons`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_coupons` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` decimal(8,2) NOT NULL,
  `quantity` int DEFAULT NULL,
  `total_used` int unsigned NOT NULL DEFAULT '0',
  `expires_date` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_coupons_code_unique` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_coupons`
--

LOCK TABLES `eb_coupons` WRITE;
/*!40000 ALTER TABLE `eb_coupons` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_coupons` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_currencies`
--

DROP TABLE IF EXISTS `eb_currencies`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_currencies` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL,
  `symbol` varchar(10) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_prefix_symbol` tinyint unsigned NOT NULL DEFAULT '0',
  `decimals` tinyint unsigned NOT NULL DEFAULT '0',
  `order` int unsigned NOT NULL DEFAULT '0',
  `is_default` tinyint NOT NULL DEFAULT '0',
  `exchange_rate` double NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_currencies`
--

LOCK TABLES `eb_currencies` WRITE;
/*!40000 ALTER TABLE `eb_currencies` DISABLE KEYS */;
INSERT INTO `eb_currencies` VALUES (1,'USD','$',1,2,0,1,1,'2025-06-10 10:37:44','2025-06-10 10:37:44'),(2,'EUR','€',0,2,1,0,0.91,'2025-06-10 10:37:44','2025-06-10 10:37:44'),(3,'VND','₫',0,0,2,0,23717.5,'2025-06-10 10:37:44','2025-06-10 10:37:44');
/*!40000 ALTER TABLE `eb_currencies` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_attendee`
--

DROP TABLE IF EXISTS `eb_event_attendee`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_attendee` (
  `event_id` bigint unsigned NOT NULL,
  `attendee_id` bigint unsigned NOT NULL,
  `hash` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_in_at` datetime DEFAULT NULL,
  UNIQUE KEY `eb_event_attendee_hash_unique` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_attendee`
--

LOCK TABLES `eb_event_attendee` WRITE;
/*!40000 ALTER TABLE `eb_event_attendee` DISABLE KEYS */;
INSERT INTO `eb_event_attendee` VALUES (3,39,'0TEAYVZQRLOH',NULL),(3,43,'1VILQJWBKJUC',NULL),(3,47,'5XCVCCEIDMR3',NULL),(3,52,'6BKIMUO0FC5Z',NULL),(3,42,'8NOYPQCGZ0FQ',NULL),(3,45,'9KAJKKHOWEYI',NULL),(2,37,'D6JHTDZZLKGT',NULL),(2,38,'E3VBKWQCFRK8',NULL),(1,33,'GIYVEFC1A8EL',NULL),(3,48,'GNXA2DDFLSQL',NULL),(1,32,'MQHZABJXFDNG',NULL),(1,34,'NRIFIZ88QEEH',NULL),(1,35,'OGSMNTEL8JK8',NULL),(3,44,'PRULON9KL08F',NULL),(3,50,'RD6FE3X4YS4V',NULL),(3,40,'T4QZDDV9CQY2',NULL),(1,36,'T9N9GF3L0TWW',NULL),(3,49,'VWMKGVLF1FQL',NULL),(3,53,'X9GVM6DS1JKJ',NULL),(3,51,'XLM0VYXLZW72',NULL),(3,46,'XYWIMFDHZCXQ',NULL),(3,41,'YM81ISQNCYPW',NULL);
/*!40000 ALTER TABLE `eb_event_attendee` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_event_speaker`
--

DROP TABLE IF EXISTS `eb_event_speaker`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_event_speaker` (
  `event_id` bigint unsigned NOT NULL,
  `speaker_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `subtitle` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `priority` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime DEFAULT NULL,
  `ended_at` datetime DEFAULT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_event_speaker`
--

LOCK TABLES `eb_event_speaker` WRITE;
/*!40000 ALTER TABLE `eb_event_speaker` DISABLE KEYS */;
INSERT INTO `eb_event_speaker` VALUES (1,25,'Cumque laboriosam rerum velit suscipit unde. Et consequuntur unde quia minus totam.',NULL,0,NULL,NULL),(1,14,'Eveniet quasi nemo aspernatur non. Reprehenderit laboriosam praesentium non vero.',NULL,1,NULL,NULL),(1,20,'Accusantium ex fugit quibusdam. Quaerat quis accusantium ut quia. Officia qui illum quam.',NULL,2,NULL,NULL),(1,8,'Rerum ipsam placeat eaque rerum magni. Est a voluptas et voluptatem et est.',NULL,3,NULL,NULL),(2,20,'Voluptatibus id esse non. Quidem velit ullam quas recusandae qui. Delectus adipisci illo ea quia.',NULL,0,NULL,NULL),(2,5,'Possimus ut ab at odio. Consequuntur nulla sed sed voluptas. Neque quis iusto possimus eius.',NULL,1,NULL,NULL),(2,25,'In praesentium magni delectus qui nemo non. Doloremque qui dolorem eaque qui praesentium.',NULL,2,NULL,NULL),(2,31,'Eum et aut omnis quia quisquam vel. Et aliquam sit hic. Rerum aut laudantium quod nesciunt sint.',NULL,3,NULL,NULL),(3,25,'Et qui ipsa dolor est. Consequuntur voluptas sit fuga neque provident maxime delectus itaque.',NULL,0,NULL,NULL),(3,20,'Numquam dolor quis blanditiis eaque ratione. Harum at nemo sint. Et voluptas labore ab.',NULL,1,NULL,NULL),(3,16,'Aut aut amet fugiat illum. Quis omnis amet quia enim dolores.',NULL,2,NULL,NULL),(4,14,'Iusto veritatis quam et vel vel. Voluptate aut architecto illo error.',NULL,0,NULL,NULL),(4,6,'Quod esse aut aut. Debitis molestiae error quos omnis odio iste.',NULL,2,NULL,NULL),(4,9,'Molestiae est odit perspiciatis hic possimus. Tempora omnis est omnis velit earum.',NULL,3,NULL,NULL),(5,20,'Deserunt distinctio aspernatur est magnam nihil aut non. Nostrum iusto non accusamus.',NULL,0,NULL,NULL),(5,31,'In velit sit molestias aspernatur sint. Quas consequatur ea rerum beatae velit similique et.',NULL,1,NULL,NULL),(5,12,'Asperiores eligendi sit vitae et culpa. Aut qui quis eius qui excepturi omnis rerum alias.',NULL,2,NULL,NULL),(5,14,'Amet voluptate minus ut ut consequatur labore. Esse ut sit et doloremque quod eligendi et.',NULL,3,NULL,NULL),(6,8,'Quisquam et commodi sed incidunt. Eos maiores autem non qui possimus.',NULL,0,NULL,NULL),(6,21,'Sed ab sed veritatis voluptates beatae dicta id. Et quibusdam qui ipsam facere dolor enim.',NULL,2,NULL,NULL),(6,14,'A est velit consectetur omnis enim et. Quae dolore laborum vel. Sint rem delectus ut.',NULL,3,NULL,NULL),(7,21,'Et et cupiditate quas aliquid dicta. Excepturi mollitia beatae neque velit est est sit.',NULL,0,NULL,NULL),(7,12,'Officiis esse ipsa error iure iste qui quae. Animi perspiciatis molestiae ad consequuntur et.',NULL,1,NULL,NULL),(7,20,'Voluptatem est temporibus incidunt sed ea saepe distinctio. Eos ab est veniam placeat.',NULL,2,NULL,NULL),(7,31,'Quod quae illum quod cumque blanditiis cupiditate aperiam. Nesciunt omnis in et.',NULL,3,NULL,NULL),(8,15,'Ipsa iste qui libero voluptates cupiditate. Ea ratione et amet. Voluptate dolorum fugit et minima.',NULL,0,NULL,NULL),(8,12,'Neque corrupti excepturi labore nam eaque ut consequatur. Est voluptatem sunt dolores autem.',NULL,1,NULL,NULL),(8,9,'Aut enim voluptas nihil debitis. Quidem quo aliquid assumenda atque est eius. Odit ut aut ut sit.',NULL,2,NULL,NULL),(8,13,'Quas earum et et iure sit. Doloremque illo facere sunt autem incidunt atque rerum.',NULL,3,NULL,NULL),(9,6,'Et recusandae dolorum placeat cum. Sint id sit porro deserunt.',NULL,0,NULL,NULL),(9,21,'Voluptate molestiae autem odit id labore ut qui. Eum voluptas corrupti itaque modi hic et.',NULL,1,NULL,NULL),(9,25,'Et officia doloribus est in. Voluptatibus natus occaecati ea sed tempora facere nihil placeat.',NULL,2,NULL,NULL),(9,13,'Eum porro qui maxime eos esse sed. Ullam velit libero nulla.',NULL,3,NULL,NULL),(10,20,'Ea in perferendis est. Pariatur dolor soluta quod deserunt quidem. Quia quis libero ut.',NULL,0,NULL,NULL),(10,15,'Laboriosam in soluta et magni porro. Et cupiditate eveniet et tempore.',NULL,1,NULL,NULL),(10,25,'Iusto voluptatum illum culpa. Blanditiis omnis sed eveniet labore veniam deleniti quibusdam.',NULL,2,NULL,NULL);
/*!40000 ALTER TABLE `eb_event_speaker` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events`
--

DROP TABLE IF EXISTS `eb_events`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_id` bigint unsigned NOT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_featured` tinyint(1) NOT NULL DEFAULT '0',
  `content` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `unique_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) DEFAULT NULL,
  `address` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `state_id` bigint unsigned DEFAULT NULL,
  `city_id` bigint unsigned DEFAULT NULL,
  `latitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `longitude` varchar(25) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `seats` int unsigned NOT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `started_at` datetime NOT NULL,
  `ended_at` datetime DEFAULT NULL,
  `booking_closed_at` datetime DEFAULT NULL,
  `tax_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_events_unique_id_unique` (`unique_id`)
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events`
--

LOCK TABLES `eb_events` WRITE;
/*!40000 ALTER TABLE `eb_events` DISABLE KEYS */;
INSERT INTO `eb_events` VALUES (1,'CES (Consumer Electronics Show)',18,'Molestiae in cumque cumque iusto voluptatem ducimus ut hic.','The world\'s largest consumer electronics exhibition, showcasing the latest products and technologies in consumer electronics.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','faa7e667-6e5c-37d5-af30-9e32a3665483','main/events/1.webp',4.45,'55697 Stiedemann Curve Apt. 104\nEast Faustino, NY 93622-8279',2,2,2,'-12.295548','80.726664',75,0,'2025-06-10 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(2,'Mobile World Congress',7,'Praesentium numquam atque quia accusantium ipsa recusandae et.','The world\'s leading mobile technology event, displaying the latest trends and innovations in mobile technology and telecommunications.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','9f611f85-7076-32ce-b2aa-d7ea7678e6e8','main/events/2.webp',95.36,'26989 Beahan Place\nLake Justinaview, CA 68578',1,1,1,'-88.588794','-123.028032',57,0,'2025-06-10 09:00:00','2025-06-28 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(3,'Google I/O',18,'Aliquam quia et iusto in vitae aliquam delectus minima.','Google\'s annual developer conference, announcing new products, services, and technologies from Google.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5e3aabd2-a095-338d-8827-5a44d8e06d77','main/events/3.webp',22.42,'4008 Mayert Walks Suite 727\nNew Josefinaborough, OR 45719',1,6,6,'61.707085','105.133636',81,0,'2025-06-10 09:00:00','2025-06-22 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(4,'Apple WWDC',4,'Nihil eius quo quaerat qui in voluptatem.','Apple\'s Worldwide Developers Conference, introducing software updates and occasionally new hardware.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','3f44063a-7733-335b-a05a-bbf4abc5d469','main/events/4.webp',24.31,'997 Haylee Path Apt. 970\nHillberg, ID 26620-1736',6,NULL,NULL,'-38.5068','11.942098',67,0,'2025-06-10 09:00:00','2025-06-27 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(5,'AWS re:Invent',18,'Illum veniam ut aperiam.','Amazon Web Services\' annual conference, focusing on cloud computing and new AWS services.',1,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','3ce10d9f-85b1-3199-a40d-f7073e247bb2','main/events/5.webp',74.57,'933 June Ports\nKuhicton, MT 05804-1756',6,NULL,NULL,'33.188168','128.853601',61,0,'2025-06-11 09:00:00','2025-06-20 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(6,'Microsoft Build',24,'Dolorem ex et totam praesentium et quia.','Microsoft\'s developer event, introducing new development tools and platforms.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','5c67573e-dca4-3495-9ee7-4d506e5143f3','main/events/6.webp',53.04,'90163 Ludwig Fork Suite 514\nNorth Cornelius, GA 11664',2,2,2,'8.149864','7.342064',66,0,'2025-06-11 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(7,'Facebook F8',24,'Et vel eius modi.','Meta\'s (Facebook) developer conference, focusing on the future of social media and virtual reality technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','dbc6f7eb-9ab5-3cfc-97c5-035dc5136083','main/events/7.webp',51.50,'642 Becker Divide Apt. 828\nRhiannonbury, KY 26995-8429',1,3,3,'-68.111223','-33.964512',95,0,'2025-06-11 09:00:00','2025-06-23 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(8,'GitHub Universe',23,'Debitis consequuntur officia velit iste modi.','GitHub\'s annual event, discussing the future of software development and open-source collaboration.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','18d4e6aa-20c7-3faf-ae8f-fc0ee837bf76','main/events/8.webp',0.91,'865 Cielo Crest Apt. 248\nDickinsonfort, ND 78009-5036',6,NULL,NULL,'76.013088','52.23969',78,0,'2025-06-11 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(9,'Game Developers Conference',23,'Praesentium enim consequatur qui at dolorem omnis occaecati.','The largest conference in the gaming industry, focusing on game development and gaming technology.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','2b1cb229-8fbb-3f37-8b9b-08458256a9b9','main/events/9.webp',48.07,'2802 Jayde Place\nSamirbury, WV 96112-5469',5,5,5,'39.447275','-20.770933',75,0,'2025-06-12 09:00:00','2025-06-26 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(10,'Web Summit',11,'Enim sed aliquam quis iusto sit ipsum neque sed.','One of the world\'s largest technology conferences, focusing on technology trends and startups.',0,'<p>In today\'s digital landscape, exceptional user experience (UX) is the key to creating products and services that truly resonate with people. At Eventify, dive deep into the world of UX with expert-led sessions that explore and cutting-edge techniques, research-driven insights, and innovative tools.</p>\n','0fddaf5e-f445-37b4-aa46-ba57e49cdb0c','main/events/10.webp',7.71,'1476 Gutmann Extensions\nMireilletown, WI 04412',4,4,4,'82.204592','121.108333',73,0,'2025-06-12 09:00:00','2025-06-30 18:00:00',NULL,NULL,'approved','2025-06-10 10:38:38','2025-06-10 10:38:38');
/*!40000 ALTER TABLE `eb_events` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_events_translations`
--

DROP TABLE IF EXISTS `eb_events_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_events_translations` (
  `lang_code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `eb_events_id` bigint unsigned NOT NULL,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `short_description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`eb_events_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_events_translations`
--

LOCK TABLES `eb_events_translations` WRITE;
/*!40000 ALTER TABLE `eb_events_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_events_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoice_items`
--

DROP TABLE IF EXISTS `eb_invoice_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoice_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `invoice_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `qty` int unsigned NOT NULL,
  `sub_total` decimal(15,2) DEFAULT NULL,
  `amount` decimal(15,2) DEFAULT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `eb_invoice_items_reference_type_reference_id_index` (`reference_type`,`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoice_items`
--

LOCK TABLES `eb_invoice_items` WRITE;
/*!40000 ALTER TABLE `eb_invoice_items` DISABLE KEYS */;
INSERT INTO `eb_invoice_items` VALUES (1,1,'ArchiElite\\EventsBooking\\Models\\Ticket',1,'CES (Consumer Electronics Show) - Ford Gusikowski - ewisozk@yahoo.com','ewisozk@yahoo.com','0312803984',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(2,1,'ArchiElite\\EventsBooking\\Models\\Ticket',2,'CES (Consumer Electronics Show) - Salvatore Swift DVM - vullrich@hotmail.com','vullrich@hotmail.com','0193828282',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(3,2,'ArchiElite\\EventsBooking\\Models\\Ticket',3,'CES (Consumer Electronics Show) - Rebeca Rempel - junior76@hotmail.com','junior76@hotmail.com','0285937313',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(4,2,'ArchiElite\\EventsBooking\\Models\\Ticket',4,'CES (Consumer Electronics Show) - Mrs. Gwen Rau - eusebio79@ondricka.com','eusebio79@ondricka.com','0187693844',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(5,2,'ArchiElite\\EventsBooking\\Models\\Ticket',5,'CES (Consumer Electronics Show) - Erik Kuphal I - prohaska.lessie@miller.com','prohaska.lessie@miller.com','0609913053',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(6,2,'ArchiElite\\EventsBooking\\Models\\Ticket',6,'CES (Consumer Electronics Show) - Jackson Weber - wilber91@yahoo.com','wilber91@yahoo.com','0271337617',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(7,2,'ArchiElite\\EventsBooking\\Models\\Ticket',7,'CES (Consumer Electronics Show) - Bernie Wilderman - althea.ruecker@collins.org','althea.ruecker@collins.org','0217326164',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(8,3,'ArchiElite\\EventsBooking\\Models\\Ticket',8,'CES (Consumer Electronics Show) - Dr. Juvenal Tremblay - graham.marcia@douglas.info','graham.marcia@douglas.info','0039634705',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(9,3,'ArchiElite\\EventsBooking\\Models\\Ticket',9,'CES (Consumer Electronics Show) - Dr. Rahul Murazik Sr. - qcummerata@gmail.com','qcummerata@gmail.com','0703590067',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(10,3,'ArchiElite\\EventsBooking\\Models\\Ticket',10,'CES (Consumer Electronics Show) - Dr. Tara Greenholt I - breanne76@schamberger.net','breanne76@schamberger.net','0174192361',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(11,3,'ArchiElite\\EventsBooking\\Models\\Ticket',11,'CES (Consumer Electronics Show) - Dustin Dietrich - derick.schmidt@gmail.com','derick.schmidt@gmail.com','0104833291',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(12,3,'ArchiElite\\EventsBooking\\Models\\Ticket',12,'CES (Consumer Electronics Show) - Dave Willms - donny.weber@gmail.com','donny.weber@gmail.com','0856369230',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(13,3,'ArchiElite\\EventsBooking\\Models\\Ticket',13,'CES (Consumer Electronics Show) - Maye Pacocha - shields.eleanore@ratke.com','shields.eleanore@ratke.com','0795085594',1,4.45,4.45,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(14,4,'ArchiElite\\EventsBooking\\Models\\Ticket',14,'CES (Consumer Electronics Show) - Lenora Heaney MD - wilber22@gmail.com','wilber22@gmail.com','0412229300',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(15,4,'ArchiElite\\EventsBooking\\Models\\Ticket',15,'CES (Consumer Electronics Show) - Destini Lindgren - irwin83@gmail.com','irwin83@gmail.com','0252171374',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(16,4,'ArchiElite\\EventsBooking\\Models\\Ticket',16,'CES (Consumer Electronics Show) - Winnifred Boehm - schaefer.emmet@dicki.com','schaefer.emmet@dicki.com','0976046696',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(17,5,'ArchiElite\\EventsBooking\\Models\\Ticket',17,'CES (Consumer Electronics Show) - Cathy Pagac - julien.russel@gmail.com','julien.russel@gmail.com','0357623247',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(18,5,'ArchiElite\\EventsBooking\\Models\\Ticket',18,'CES (Consumer Electronics Show) - Roberta Kshlerin - dominic.volkman@jacobs.info','dominic.volkman@jacobs.info','0422302566',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(19,5,'ArchiElite\\EventsBooking\\Models\\Ticket',19,'CES (Consumer Electronics Show) - Ms. Queenie Dooley IV - connelly.tara@stokes.com','connelly.tara@stokes.com','0969494180',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(20,6,'ArchiElite\\EventsBooking\\Models\\Ticket',20,'CES (Consumer Electronics Show) - Sylvan Welch - shirley.hane@quitzon.com','shirley.hane@quitzon.com','0327895139',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(21,6,'ArchiElite\\EventsBooking\\Models\\Ticket',21,'CES (Consumer Electronics Show) - Mr. Brant Moore DDS - jerrell.barton@barrows.com','jerrell.barton@barrows.com','0499309669',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(22,6,'ArchiElite\\EventsBooking\\Models\\Ticket',22,'CES (Consumer Electronics Show) - Giovanni Fahey - sydni62@kutch.com','sydni62@kutch.com','0342631081',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(23,6,'ArchiElite\\EventsBooking\\Models\\Ticket',23,'CES (Consumer Electronics Show) - Nichole Rippin DDS - ybraun@hotmail.com','ybraun@hotmail.com','0895023429',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(24,6,'ArchiElite\\EventsBooking\\Models\\Ticket',24,'CES (Consumer Electronics Show) - Juanita Schumm - eino32@hahn.com','eino32@hahn.com','0092617082',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(25,6,'ArchiElite\\EventsBooking\\Models\\Ticket',25,'CES (Consumer Electronics Show) - Prof. Lucie Trantow - darrion82@yahoo.com','darrion82@yahoo.com','0382962331',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(26,7,'ArchiElite\\EventsBooking\\Models\\Ticket',26,'CES (Consumer Electronics Show) - Prof. Ruthe Schumm - candice88@jerde.org','candice88@jerde.org','0093128954',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(27,7,'ArchiElite\\EventsBooking\\Models\\Ticket',27,'CES (Consumer Electronics Show) - Miss Kayli Weimann - htillman@yahoo.com','htillman@yahoo.com','0348714509',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(28,7,'ArchiElite\\EventsBooking\\Models\\Ticket',28,'CES (Consumer Electronics Show) - Isidro Lehner - dasia84@hotmail.com','dasia84@hotmail.com','0195110157',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(29,8,'ArchiElite\\EventsBooking\\Models\\Ticket',29,'CES (Consumer Electronics Show) - Claudie Ferry - doyle.fabian@yahoo.com','doyle.fabian@yahoo.com','0447272213',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(30,8,'ArchiElite\\EventsBooking\\Models\\Ticket',30,'CES (Consumer Electronics Show) - Mr. Ulises Botsford PhD - lucius56@hotmail.com','lucius56@hotmail.com','0169426948',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(31,8,'ArchiElite\\EventsBooking\\Models\\Ticket',31,'CES (Consumer Electronics Show) - Karolann Gerhold - jamar.koelpin@hotmail.com','jamar.koelpin@hotmail.com','0126088810',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(32,8,'ArchiElite\\EventsBooking\\Models\\Ticket',32,'CES (Consumer Electronics Show) - Erich Schmeler - william.funk@larkin.org','william.funk@larkin.org','0712694598',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(33,8,'ArchiElite\\EventsBooking\\Models\\Ticket',33,'CES (Consumer Electronics Show) - Mr. Abdul Effertz I - xschimmel@blanda.org','xschimmel@blanda.org','0658731852',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(34,8,'ArchiElite\\EventsBooking\\Models\\Ticket',34,'CES (Consumer Electronics Show) - Carleton Hintz - tia.cummings@hotmail.com','tia.cummings@hotmail.com','0877835250',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(35,9,'ArchiElite\\EventsBooking\\Models\\Ticket',35,'CES (Consumer Electronics Show) - Jordon Gutmann - nabbott@yahoo.com','nabbott@yahoo.com','0192872222',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(36,9,'ArchiElite\\EventsBooking\\Models\\Ticket',36,'CES (Consumer Electronics Show) - Chasity Tromp - jayden38@wuckert.com','jayden38@wuckert.com','0192667002',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(37,9,'ArchiElite\\EventsBooking\\Models\\Ticket',37,'CES (Consumer Electronics Show) - Dana Grady - derrick.lind@hotmail.com','derrick.lind@hotmail.com','0763069984',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(38,9,'ArchiElite\\EventsBooking\\Models\\Ticket',38,'CES (Consumer Electronics Show) - Mylene Predovic - deangelo.renner@gmail.com','deangelo.renner@gmail.com','0168051515',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(39,10,'ArchiElite\\EventsBooking\\Models\\Ticket',39,'CES (Consumer Electronics Show) - Mr. Leif Bradtke - grimes.reese@hotmail.com','grimes.reese@hotmail.com','0200096223',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(40,10,'ArchiElite\\EventsBooking\\Models\\Ticket',40,'CES (Consumer Electronics Show) - Dr. Tania Grady Sr. - rmckenzie@ondricka.com','rmckenzie@ondricka.com','0793199160',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(41,10,'ArchiElite\\EventsBooking\\Models\\Ticket',41,'CES (Consumer Electronics Show) - Lera Nienow - antone20@greenholt.com','antone20@greenholt.com','0624147885',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(42,10,'ArchiElite\\EventsBooking\\Models\\Ticket',42,'CES (Consumer Electronics Show) - Rosemarie Ortiz - wwalter@gmail.com','wwalter@gmail.com','0744441968',1,4.45,4.45,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(43,11,'ArchiElite\\EventsBooking\\Models\\Ticket',43,'Mobile World Congress - Jimmy Bogisich I - cassidy.kozey@yahoo.com','cassidy.kozey@yahoo.com','0924984113',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(44,11,'ArchiElite\\EventsBooking\\Models\\Ticket',44,'Mobile World Congress - Mrs. Elmira Littel I - jeremy.grimes@labadie.com','jeremy.grimes@labadie.com','0935833931',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(45,11,'ArchiElite\\EventsBooking\\Models\\Ticket',45,'Mobile World Congress - Mr. Weston Kunde I - lynch.candelario@hotmail.com','lynch.candelario@hotmail.com','0117624893',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(46,11,'ArchiElite\\EventsBooking\\Models\\Ticket',46,'Mobile World Congress - Carolyn Dare I - maggio.janessa@gmail.com','maggio.janessa@gmail.com','0780906804',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(47,11,'ArchiElite\\EventsBooking\\Models\\Ticket',47,'Mobile World Congress - Miss Layla Aufderhar - wilkinson.cedrick@weber.com','wilkinson.cedrick@weber.com','0555597186',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(48,12,'ArchiElite\\EventsBooking\\Models\\Ticket',48,'Mobile World Congress - Valentin O\'Reilly MD - rebert@yahoo.com','rebert@yahoo.com','0859983270',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(49,12,'ArchiElite\\EventsBooking\\Models\\Ticket',49,'Mobile World Congress - Elton Kassulke - kutch.darius@gmail.com','kutch.darius@gmail.com','0314843483',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(50,12,'ArchiElite\\EventsBooking\\Models\\Ticket',50,'Mobile World Congress - Prof. Rylan Koss Sr. - maiya.schumm@hotmail.com','maiya.schumm@hotmail.com','0244732703',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(51,12,'ArchiElite\\EventsBooking\\Models\\Ticket',51,'Mobile World Congress - Mrs. Delia Yost - jrowe@ward.net','jrowe@ward.net','0002747827',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(52,12,'ArchiElite\\EventsBooking\\Models\\Ticket',52,'Mobile World Congress - Leopold Aufderhar Sr. - okon.valentina@yahoo.com','okon.valentina@yahoo.com','0547118401',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(53,13,'ArchiElite\\EventsBooking\\Models\\Ticket',53,'Mobile World Congress - Mr. Dale Trantow IV - lparisian@herzog.com','lparisian@herzog.com','0540950612',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(54,13,'ArchiElite\\EventsBooking\\Models\\Ticket',54,'Mobile World Congress - Zula Hickle - maudie13@wisozk.com','maudie13@wisozk.com','0130853530',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(55,13,'ArchiElite\\EventsBooking\\Models\\Ticket',55,'Mobile World Congress - Prof. Adriel Bartoletti - donald.weissnat@yahoo.com','donald.weissnat@yahoo.com','0392796208',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(56,13,'ArchiElite\\EventsBooking\\Models\\Ticket',56,'Mobile World Congress - Cleta Price - luisa38@jaskolski.com','luisa38@jaskolski.com','0878095745',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(57,14,'ArchiElite\\EventsBooking\\Models\\Ticket',57,'Mobile World Congress - Ms. Isabell Becker III - dubuque.wilfrid@gmail.com','dubuque.wilfrid@gmail.com','0564381892',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(58,14,'ArchiElite\\EventsBooking\\Models\\Ticket',58,'Mobile World Congress - Georgianna O\'Connell - jevon.lind@vandervort.com','jevon.lind@vandervort.com','0372889843',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(59,14,'ArchiElite\\EventsBooking\\Models\\Ticket',59,'Mobile World Congress - Burnice Huels - ellie48@greenholt.com','ellie48@greenholt.com','0343865085',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(60,14,'ArchiElite\\EventsBooking\\Models\\Ticket',60,'Mobile World Congress - Dr. Howell Medhurst IV - lvonrueden@yahoo.com','lvonrueden@yahoo.com','0835838346',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(61,14,'ArchiElite\\EventsBooking\\Models\\Ticket',61,'Mobile World Congress - Roselyn Emmerich - jeramy52@gmail.com','jeramy52@gmail.com','0834909257',1,95.36,95.36,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(62,15,'ArchiElite\\EventsBooking\\Models\\Ticket',62,'Mobile World Congress - Rubie Blanda III - wiegand.jo@bartoletti.info','wiegand.jo@bartoletti.info','0212507190',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(63,15,'ArchiElite\\EventsBooking\\Models\\Ticket',63,'Mobile World Congress - Hilario Miller - amayer@roberts.com','amayer@roberts.com','0341957663',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(64,15,'ArchiElite\\EventsBooking\\Models\\Ticket',64,'Mobile World Congress - Kristian Lehner II - olowe@hotmail.com','olowe@hotmail.com','0080450231',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(65,15,'ArchiElite\\EventsBooking\\Models\\Ticket',65,'Mobile World Congress - Prince McCullough - houston.kuhn@gmail.com','houston.kuhn@gmail.com','0030642153',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(66,15,'ArchiElite\\EventsBooking\\Models\\Ticket',66,'Mobile World Congress - Lloyd Deckow - camylle60@cremin.net','camylle60@cremin.net','0079953419',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(67,16,'ArchiElite\\EventsBooking\\Models\\Ticket',67,'Mobile World Congress - Brenden Sawayn - olson.keyshawn@runte.com','olson.keyshawn@runte.com','0255837784',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(68,16,'ArchiElite\\EventsBooking\\Models\\Ticket',68,'Mobile World Congress - Hosea Koss - halvorson.veda@eichmann.com','halvorson.veda@eichmann.com','0207120066',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(69,16,'ArchiElite\\EventsBooking\\Models\\Ticket',69,'Mobile World Congress - Dewitt Smitham - kstrosin@yahoo.com','kstrosin@yahoo.com','0115073398',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(70,16,'ArchiElite\\EventsBooking\\Models\\Ticket',70,'Mobile World Congress - Nathan Rutherford - michelle.donnelly@rowe.com','michelle.donnelly@rowe.com','0805431849',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(71,16,'ArchiElite\\EventsBooking\\Models\\Ticket',71,'Mobile World Congress - Mrs. Caitlyn Donnelly - kaley40@gmail.com','kaley40@gmail.com','0932260310',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(72,17,'ArchiElite\\EventsBooking\\Models\\Ticket',72,'Mobile World Congress - Prof. Ryleigh Moore III - lourdes59@leannon.info','lourdes59@leannon.info','0458416250',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(73,17,'ArchiElite\\EventsBooking\\Models\\Ticket',73,'Mobile World Congress - Abdiel Halvorson V - solon79@hotmail.com','solon79@hotmail.com','0900531499',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(74,17,'ArchiElite\\EventsBooking\\Models\\Ticket',74,'Mobile World Congress - Tressie Schaden I - mariane72@langosh.com','mariane72@langosh.com','0819456984',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(75,17,'ArchiElite\\EventsBooking\\Models\\Ticket',75,'Mobile World Congress - Ibrahim Kling III - noemy.spinka@yahoo.com','noemy.spinka@yahoo.com','0398351217',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(76,17,'ArchiElite\\EventsBooking\\Models\\Ticket',76,'Mobile World Congress - Izabella Kutch - fadel.otis@hotmail.com','fadel.otis@hotmail.com','0288076241',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(77,18,'ArchiElite\\EventsBooking\\Models\\Ticket',77,'Mobile World Congress - Wendell Goodwin DVM - ahalvorson@kemmer.com','ahalvorson@kemmer.com','0646685753',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(78,18,'ArchiElite\\EventsBooking\\Models\\Ticket',78,'Mobile World Congress - Sylvan Rodriguez - hillary.king@roberts.com','hillary.king@roberts.com','0355074997',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(79,19,'ArchiElite\\EventsBooking\\Models\\Ticket',79,'Mobile World Congress - Drew VonRueden - katherine.haley@hodkiewicz.net','katherine.haley@hodkiewicz.net','0478224724',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(80,19,'ArchiElite\\EventsBooking\\Models\\Ticket',80,'Mobile World Congress - Paris Hackett - igoldner@boyer.com','igoldner@boyer.com','0253280949',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(81,20,'ArchiElite\\EventsBooking\\Models\\Ticket',81,'Mobile World Congress - Geovanny Williamson - hilbert23@gmail.com','hilbert23@gmail.com','0228905674',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(82,20,'ArchiElite\\EventsBooking\\Models\\Ticket',82,'Mobile World Congress - Chester Dicki PhD - edythe32@gmail.com','edythe32@gmail.com','0837524421',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(83,20,'ArchiElite\\EventsBooking\\Models\\Ticket',83,'Mobile World Congress - Prof. Reinhold Nikolaus MD - tgrimes@gmail.com','tgrimes@gmail.com','0358765246',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(84,20,'ArchiElite\\EventsBooking\\Models\\Ticket',84,'Mobile World Congress - Tyree Lebsack - ubeahan@kirlin.com','ubeahan@kirlin.com','0528378017',1,95.36,95.36,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(85,21,'ArchiElite\\EventsBooking\\Models\\Ticket',85,'Google I/O - Eloy Zemlak - kmueller@kihn.com','kmueller@kihn.com','0783349807',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(86,21,'ArchiElite\\EventsBooking\\Models\\Ticket',86,'Google I/O - Dr. Bernice Donnelly DVM - dwilderman@gmail.com','dwilderman@gmail.com','0264168453',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(87,21,'ArchiElite\\EventsBooking\\Models\\Ticket',87,'Google I/O - Mable Bogisich Jr. - krempel@stamm.com','krempel@stamm.com','0221442501',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(88,21,'ArchiElite\\EventsBooking\\Models\\Ticket',88,'Google I/O - Eloisa O\'Connell - clakin@hotmail.com','clakin@hotmail.com','0513963047',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(89,21,'ArchiElite\\EventsBooking\\Models\\Ticket',89,'Google I/O - Claude Murazik - hritchie@gmail.com','hritchie@gmail.com','0200504113',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(90,22,'ArchiElite\\EventsBooking\\Models\\Ticket',90,'Google I/O - Dr. Kameron Ward - lbaumbach@gmail.com','lbaumbach@gmail.com','0279486201',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(91,22,'ArchiElite\\EventsBooking\\Models\\Ticket',91,'Google I/O - Aurelio Medhurst - zula12@dibbert.com','zula12@dibbert.com','0763923038',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(92,22,'ArchiElite\\EventsBooking\\Models\\Ticket',92,'Google I/O - Johnathon Fisher - stokes.jordyn@wilderman.org','stokes.jordyn@wilderman.org','0439112644',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(93,22,'ArchiElite\\EventsBooking\\Models\\Ticket',93,'Google I/O - Pablo Schroeder - ggleason@hotmail.com','ggleason@hotmail.com','0241400185',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(94,22,'ArchiElite\\EventsBooking\\Models\\Ticket',94,'Google I/O - Marina Altenwerth - gordon.erdman@yahoo.com','gordon.erdman@yahoo.com','0936880469',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(95,23,'ArchiElite\\EventsBooking\\Models\\Ticket',95,'Google I/O - Ashtyn Larson - alan.olson@yahoo.com','alan.olson@yahoo.com','0443941432',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(96,23,'ArchiElite\\EventsBooking\\Models\\Ticket',96,'Google I/O - Dr. Art Leuschke MD - konopelski.luciano@paucek.com','konopelski.luciano@paucek.com','0396887717',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(97,23,'ArchiElite\\EventsBooking\\Models\\Ticket',97,'Google I/O - Mr. William Bahringer - littel.dagmar@hotmail.com','littel.dagmar@hotmail.com','0188415759',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(98,23,'ArchiElite\\EventsBooking\\Models\\Ticket',98,'Google I/O - Nicklaus Hirthe - rreilly@yahoo.com','rreilly@yahoo.com','0278676325',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(99,24,'ArchiElite\\EventsBooking\\Models\\Ticket',99,'Google I/O - Imelda Pagac - lelia.ondricka@nitzsche.com','lelia.ondricka@nitzsche.com','0000376678',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(100,24,'ArchiElite\\EventsBooking\\Models\\Ticket',100,'Google I/O - Rossie Conroy - zion.gleichner@gmail.com','zion.gleichner@gmail.com','0887530988',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(101,24,'ArchiElite\\EventsBooking\\Models\\Ticket',101,'Google I/O - Alysson Murphy MD - raquel.collins@oconnell.biz','raquel.collins@oconnell.biz','0963273459',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(102,24,'ArchiElite\\EventsBooking\\Models\\Ticket',102,'Google I/O - Jada Bailey - haag.magali@oconner.com','haag.magali@oconner.com','0266747968',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(103,24,'ArchiElite\\EventsBooking\\Models\\Ticket',103,'Google I/O - Dr. Ralph Wolff - casper.lowe@gmail.com','casper.lowe@gmail.com','0051672105',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(104,25,'ArchiElite\\EventsBooking\\Models\\Ticket',104,'Google I/O - Mr. Riley Gerhold - karelle55@wisoky.com','karelle55@wisoky.com','0648631181',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(105,25,'ArchiElite\\EventsBooking\\Models\\Ticket',105,'Google I/O - Mr. Eladio Bradtke - eusebio15@luettgen.org','eusebio15@luettgen.org','0658626776',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(106,25,'ArchiElite\\EventsBooking\\Models\\Ticket',106,'Google I/O - Layne Hermiston - eondricka@yahoo.com','eondricka@yahoo.com','0394933086',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(107,25,'ArchiElite\\EventsBooking\\Models\\Ticket',107,'Google I/O - Miss Matilda Kuhic II - thompson.esther@wintheiser.info','thompson.esther@wintheiser.info','0332208497',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(108,26,'ArchiElite\\EventsBooking\\Models\\Ticket',108,'Google I/O - Dr. Enoch Larson - amorissette@wolf.info','amorissette@wolf.info','0546178413',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(109,26,'ArchiElite\\EventsBooking\\Models\\Ticket',109,'Google I/O - Luigi Rodriguez - juliana.stehr@gmail.com','juliana.stehr@gmail.com','0258492661',1,22.42,22.42,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(110,27,'ArchiElite\\EventsBooking\\Models\\Ticket',110,'Google I/O - Otho Hauck - ymarks@lakin.com','ymarks@lakin.com','0794154587',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(111,27,'ArchiElite\\EventsBooking\\Models\\Ticket',111,'Google I/O - Prof. Coleman Harvey Sr. - fritz.kertzmann@nienow.com','fritz.kertzmann@nienow.com','0346179802',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(112,28,'ArchiElite\\EventsBooking\\Models\\Ticket',112,'Google I/O - Ms. Aylin Nitzsche - xhahn@gutkowski.com','xhahn@gutkowski.com','0590141237',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(113,28,'ArchiElite\\EventsBooking\\Models\\Ticket',113,'Google I/O - Dr. Nash Kunde - kautzer.louisa@gmail.com','kautzer.louisa@gmail.com','0302595133',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(114,28,'ArchiElite\\EventsBooking\\Models\\Ticket',114,'Google I/O - Isabella Lockman - shanon16@yahoo.com','shanon16@yahoo.com','0646714573',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(115,29,'ArchiElite\\EventsBooking\\Models\\Ticket',115,'Google I/O - Berta Marquardt PhD - vaughn14@gmail.com','vaughn14@gmail.com','0270017965',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(116,29,'ArchiElite\\EventsBooking\\Models\\Ticket',116,'Google I/O - Miss Jacquelyn Heller - kuhic.adell@pfannerstill.info','kuhic.adell@pfannerstill.info','0871790177',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(117,29,'ArchiElite\\EventsBooking\\Models\\Ticket',117,'Google I/O - Catalina Lang PhD - btillman@oconner.org','btillman@oconner.org','0254361795',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(118,29,'ArchiElite\\EventsBooking\\Models\\Ticket',118,'Google I/O - Prof. Sunny Kerluke II - mmills@rodriguez.info','mmills@rodriguez.info','0495347674',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(119,30,'ArchiElite\\EventsBooking\\Models\\Ticket',119,'Google I/O - Flo Brekke - sonya.mosciski@stehr.com','sonya.mosciski@stehr.com','0203552996',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(120,30,'ArchiElite\\EventsBooking\\Models\\Ticket',120,'Google I/O - Estel Flatley - rita.mcclure@thompson.com','rita.mcclure@thompson.com','0844469241',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(121,30,'ArchiElite\\EventsBooking\\Models\\Ticket',121,'Google I/O - Mrs. Alison Monahan - oral79@gmail.com','oral79@gmail.com','0383077671',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(122,30,'ArchiElite\\EventsBooking\\Models\\Ticket',122,'Google I/O - Randy Gulgowski - vgaylord@yahoo.com','vgaylord@yahoo.com','0833934178',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(123,30,'ArchiElite\\EventsBooking\\Models\\Ticket',123,'Google I/O - Luigi Kris - jaeden52@lesch.com','jaeden52@lesch.com','0083127185',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(124,30,'ArchiElite\\EventsBooking\\Models\\Ticket',124,'Google I/O - Jarvis West - eldora.koss@yahoo.com','eldora.koss@yahoo.com','0853484716',1,22.42,22.42,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(125,31,'ArchiElite\\EventsBooking\\Models\\Ticket',125,'Apple WWDC - Candida Kautzer - heaven.okon@reinger.com','heaven.okon@reinger.com','0388240495',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(126,31,'ArchiElite\\EventsBooking\\Models\\Ticket',126,'Apple WWDC - Mrs. Blanca Hoppe - zboncak.crawford@hotmail.com','zboncak.crawford@hotmail.com','0534084305',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(127,32,'ArchiElite\\EventsBooking\\Models\\Ticket',127,'Apple WWDC - Lindsay Thompson - kparker@hotmail.com','kparker@hotmail.com','0320934303',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(128,32,'ArchiElite\\EventsBooking\\Models\\Ticket',128,'Apple WWDC - Mrs. Lysanne Bosco - emely78@hotmail.com','emely78@hotmail.com','0386056812',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(129,32,'ArchiElite\\EventsBooking\\Models\\Ticket',129,'Apple WWDC - Retta Lind - michaela71@spencer.info','michaela71@spencer.info','0184259430',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(130,32,'ArchiElite\\EventsBooking\\Models\\Ticket',130,'Apple WWDC - Ms. Eleanore Johnston - minnie.denesik@collins.com','minnie.denesik@collins.com','0907667964',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(131,32,'ArchiElite\\EventsBooking\\Models\\Ticket',131,'Apple WWDC - Silas West - ahowe@crist.info','ahowe@crist.info','0982732272',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(132,33,'ArchiElite\\EventsBooking\\Models\\Ticket',132,'Apple WWDC - Dr. Noemie Kunde II - twila.krajcik@yahoo.com','twila.krajcik@yahoo.com','0535251851',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(133,33,'ArchiElite\\EventsBooking\\Models\\Ticket',133,'Apple WWDC - Miss Dortha Gulgowski - vtoy@schamberger.net','vtoy@schamberger.net','0198353073',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(134,33,'ArchiElite\\EventsBooking\\Models\\Ticket',134,'Apple WWDC - Jamarcus Armstrong - erling.tillman@gmail.com','erling.tillman@gmail.com','0520747406',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(135,33,'ArchiElite\\EventsBooking\\Models\\Ticket',135,'Apple WWDC - Miss Lyda Gleason DVM - rose.leffler@gmail.com','rose.leffler@gmail.com','0498868321',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(136,34,'ArchiElite\\EventsBooking\\Models\\Ticket',136,'Apple WWDC - Rick Block - tara50@yahoo.com','tara50@yahoo.com','0476531875',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(137,34,'ArchiElite\\EventsBooking\\Models\\Ticket',137,'Apple WWDC - Hardy Torp - goyette.adelle@mitchell.com','goyette.adelle@mitchell.com','0506347752',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(138,34,'ArchiElite\\EventsBooking\\Models\\Ticket',138,'Apple WWDC - Collin Ullrich - estamm@schoen.com','estamm@schoen.com','0885015026',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(139,34,'ArchiElite\\EventsBooking\\Models\\Ticket',139,'Apple WWDC - Payton Hagenes Sr. - mbernier@yahoo.com','mbernier@yahoo.com','0112110400',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(140,35,'ArchiElite\\EventsBooking\\Models\\Ticket',140,'Apple WWDC - Bailey Schulist - meghan18@runte.com','meghan18@runte.com','0373499316',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(141,35,'ArchiElite\\EventsBooking\\Models\\Ticket',141,'Apple WWDC - Oda Wuckert - clabadie@hotmail.com','clabadie@hotmail.com','0021986742',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(142,35,'ArchiElite\\EventsBooking\\Models\\Ticket',142,'Apple WWDC - Virginie Wilderman - bhoppe@dibbert.com','bhoppe@dibbert.com','0304611651',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(143,35,'ArchiElite\\EventsBooking\\Models\\Ticket',143,'Apple WWDC - Miss Queen Deckow - trevor53@feeney.biz','trevor53@feeney.biz','0343327412',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(144,36,'ArchiElite\\EventsBooking\\Models\\Ticket',144,'Apple WWDC - Hilma Bartell - kuhn.devan@fadel.net','kuhn.devan@fadel.net','0313195129',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(145,36,'ArchiElite\\EventsBooking\\Models\\Ticket',145,'Apple WWDC - Rosemary Rosenbaum - fkreiger@hotmail.com','fkreiger@hotmail.com','0485834574',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(146,36,'ArchiElite\\EventsBooking\\Models\\Ticket',146,'Apple WWDC - Merl Flatley - mbruen@mohr.com','mbruen@mohr.com','0259773485',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(147,36,'ArchiElite\\EventsBooking\\Models\\Ticket',147,'Apple WWDC - Nathanial Smith Sr. - wheathcote@bechtelar.com','wheathcote@bechtelar.com','0986029057',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(148,37,'ArchiElite\\EventsBooking\\Models\\Ticket',148,'Apple WWDC - Evalyn Goyette - lina.dubuque@yahoo.com','lina.dubuque@yahoo.com','0957490494',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(149,37,'ArchiElite\\EventsBooking\\Models\\Ticket',149,'Apple WWDC - Nelson Conn - june.huels@yahoo.com','june.huels@yahoo.com','0940393529',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(150,37,'ArchiElite\\EventsBooking\\Models\\Ticket',150,'Apple WWDC - Shaun Kris - alexandrine35@yahoo.com','alexandrine35@yahoo.com','0375097261',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(151,37,'ArchiElite\\EventsBooking\\Models\\Ticket',151,'Apple WWDC - Neva Swift - chasity53@gmail.com','chasity53@gmail.com','0286692841',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(152,38,'ArchiElite\\EventsBooking\\Models\\Ticket',152,'Apple WWDC - Lisette Fritsch - ayden38@daugherty.com','ayden38@daugherty.com','0246941665',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(153,38,'ArchiElite\\EventsBooking\\Models\\Ticket',153,'Apple WWDC - Lavinia Kutch - joaquin41@yahoo.com','joaquin41@yahoo.com','0953876132',1,24.31,24.31,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(154,39,'ArchiElite\\EventsBooking\\Models\\Ticket',154,'Apple WWDC - Prof. Timothy Sauer - nicolas.jairo@hotmail.com','nicolas.jairo@hotmail.com','0997105430',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(155,39,'ArchiElite\\EventsBooking\\Models\\Ticket',155,'Apple WWDC - Jaquelin Watsica - walsh.taryn@feeney.com','walsh.taryn@feeney.com','0486086096',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(156,39,'ArchiElite\\EventsBooking\\Models\\Ticket',156,'Apple WWDC - Noelia Stokes - ucassin@yahoo.com','ucassin@yahoo.com','0766038604',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(157,39,'ArchiElite\\EventsBooking\\Models\\Ticket',157,'Apple WWDC - Al West - wcartwright@gmail.com','wcartwright@gmail.com','0014494112',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(158,39,'ArchiElite\\EventsBooking\\Models\\Ticket',158,'Apple WWDC - Prof. Leland Kovacek PhD - chandler.kilback@mraz.com','chandler.kilback@mraz.com','0449498518',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(159,40,'ArchiElite\\EventsBooking\\Models\\Ticket',159,'Apple WWDC - Loyce Sporer - schaefer.raymundo@gmail.com','schaefer.raymundo@gmail.com','0377414601',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(160,40,'ArchiElite\\EventsBooking\\Models\\Ticket',160,'Apple WWDC - Quentin Franecki - zdach@yahoo.com','zdach@yahoo.com','0526803195',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(161,40,'ArchiElite\\EventsBooking\\Models\\Ticket',161,'Apple WWDC - Troy Parker Jr. - deckow.troy@gmail.com','deckow.troy@gmail.com','0963755965',1,24.31,24.31,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(162,41,'ArchiElite\\EventsBooking\\Models\\Ticket',162,'AWS re:Invent - Murl Heaney - wdurgan@douglas.com','wdurgan@douglas.com','0928544933',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(163,41,'ArchiElite\\EventsBooking\\Models\\Ticket',163,'AWS re:Invent - Anabel Kiehn - kamryn.carter@yahoo.com','kamryn.carter@yahoo.com','0787364819',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(164,41,'ArchiElite\\EventsBooking\\Models\\Ticket',164,'AWS re:Invent - Mrs. Treva Marvin - litzy.borer@murphy.com','litzy.borer@murphy.com','0535346709',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(165,41,'ArchiElite\\EventsBooking\\Models\\Ticket',165,'AWS re:Invent - Julie Graham - heathcote.carmelo@windler.com','heathcote.carmelo@windler.com','0195892952',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(166,41,'ArchiElite\\EventsBooking\\Models\\Ticket',166,'AWS re:Invent - Suzanne Marvin - crempel@yahoo.com','crempel@yahoo.com','0767287214',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(167,42,'ArchiElite\\EventsBooking\\Models\\Ticket',167,'AWS re:Invent - Prof. Mohammad Gerhold - rodriguez.katrina@gmail.com','rodriguez.katrina@gmail.com','0476313875',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(168,42,'ArchiElite\\EventsBooking\\Models\\Ticket',168,'AWS re:Invent - Chauncey Reilly - kattie.crona@kuhic.com','kattie.crona@kuhic.com','0617357000',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(169,42,'ArchiElite\\EventsBooking\\Models\\Ticket',169,'AWS re:Invent - Sheila Rippin - ekemmer@ritchie.com','ekemmer@ritchie.com','0350446879',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(170,42,'ArchiElite\\EventsBooking\\Models\\Ticket',170,'AWS re:Invent - Celestine Howe - okon.mitchel@gmail.com','okon.mitchel@gmail.com','0782262406',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(171,42,'ArchiElite\\EventsBooking\\Models\\Ticket',171,'AWS re:Invent - Dr. Golden Greenholt II - tratke@ondricka.com','tratke@ondricka.com','0622392773',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(172,43,'ArchiElite\\EventsBooking\\Models\\Ticket',172,'AWS re:Invent - Mrs. Everette Littel - robbie88@yahoo.com','robbie88@yahoo.com','0244683532',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(173,43,'ArchiElite\\EventsBooking\\Models\\Ticket',173,'AWS re:Invent - Dave Cummerata - samir24@hotmail.com','samir24@hotmail.com','0281790035',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(174,43,'ArchiElite\\EventsBooking\\Models\\Ticket',174,'AWS re:Invent - Obie Macejkovic - jaskolski.jada@hotmail.com','jaskolski.jada@hotmail.com','0714597999',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(175,43,'ArchiElite\\EventsBooking\\Models\\Ticket',175,'AWS re:Invent - Golda Kilback - schinner.justus@larkin.com','schinner.justus@larkin.com','0105381552',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(176,44,'ArchiElite\\EventsBooking\\Models\\Ticket',176,'AWS re:Invent - Willy Wisozk - wava99@hotmail.com','wava99@hotmail.com','0400720938',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(177,44,'ArchiElite\\EventsBooking\\Models\\Ticket',177,'AWS re:Invent - Zechariah Cruickshank - reichel.manuela@zemlak.com','reichel.manuela@zemlak.com','0392191940',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(178,44,'ArchiElite\\EventsBooking\\Models\\Ticket',178,'AWS re:Invent - Renee Dickens - dannie75@yahoo.com','dannie75@yahoo.com','0634502951',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(179,44,'ArchiElite\\EventsBooking\\Models\\Ticket',179,'AWS re:Invent - Tyler Sporer V - bianka.wyman@kirlin.com','bianka.wyman@kirlin.com','0927571069',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(180,45,'ArchiElite\\EventsBooking\\Models\\Ticket',180,'AWS re:Invent - Kallie Lakin - ronny15@borer.biz','ronny15@borer.biz','0760879632',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(181,45,'ArchiElite\\EventsBooking\\Models\\Ticket',181,'AWS re:Invent - Prof. Jennifer Kreiger Jr. - wisoky.ari@kiehn.com','wisoky.ari@kiehn.com','0579728584',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(182,46,'ArchiElite\\EventsBooking\\Models\\Ticket',182,'AWS re:Invent - Judah Pacocha - mosciski.dustin@thompson.com','mosciski.dustin@thompson.com','0567879986',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(183,46,'ArchiElite\\EventsBooking\\Models\\Ticket',183,'AWS re:Invent - Fleta Fahey - janae.roob@yahoo.com','janae.roob@yahoo.com','0094179138',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(184,46,'ArchiElite\\EventsBooking\\Models\\Ticket',184,'AWS re:Invent - Bernadine Kohler - tomas.spinka@treutel.info','tomas.spinka@treutel.info','0676331708',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(185,47,'ArchiElite\\EventsBooking\\Models\\Ticket',185,'AWS re:Invent - Letitia Hayes PhD - wgreen@yahoo.com','wgreen@yahoo.com','0302445036',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(186,47,'ArchiElite\\EventsBooking\\Models\\Ticket',186,'AWS re:Invent - Betsy Bailey II - schaefer.kadin@yahoo.com','schaefer.kadin@yahoo.com','0803107498',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(187,47,'ArchiElite\\EventsBooking\\Models\\Ticket',187,'AWS re:Invent - Aida Eichmann - wuckert.katelynn@goyette.net','wuckert.katelynn@goyette.net','0751717241',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(188,47,'ArchiElite\\EventsBooking\\Models\\Ticket',188,'AWS re:Invent - Cary Kshlerin - tcronin@labadie.com','tcronin@labadie.com','0848892829',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(189,48,'ArchiElite\\EventsBooking\\Models\\Ticket',189,'AWS re:Invent - Jadyn Schowalter - jacobs.arnold@hotmail.com','jacobs.arnold@hotmail.com','0343993359',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(190,48,'ArchiElite\\EventsBooking\\Models\\Ticket',190,'AWS re:Invent - Mitchell Aufderhar - oauer@hotmail.com','oauer@hotmail.com','0891931198',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(191,48,'ArchiElite\\EventsBooking\\Models\\Ticket',191,'AWS re:Invent - Judy Roberts - astrid.green@schroeder.com','astrid.green@schroeder.com','0021984169',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(192,48,'ArchiElite\\EventsBooking\\Models\\Ticket',192,'AWS re:Invent - Mrs. Rachael Crooks II - erdman.clark@anderson.com','erdman.clark@anderson.com','0117323526',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(193,48,'ArchiElite\\EventsBooking\\Models\\Ticket',193,'AWS re:Invent - Prof. Ed Hauck DVM - fiona93@yahoo.com','fiona93@yahoo.com','0342788859',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(194,49,'ArchiElite\\EventsBooking\\Models\\Ticket',194,'AWS re:Invent - Werner Kuhlman - runolfsson.tracy@beer.info','runolfsson.tracy@beer.info','0950701391',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(195,49,'ArchiElite\\EventsBooking\\Models\\Ticket',195,'AWS re:Invent - Greg Schultz - jflatley@schumm.info','jflatley@schumm.info','0440189722',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(196,49,'ArchiElite\\EventsBooking\\Models\\Ticket',196,'AWS re:Invent - Mr. Ariel Nikolaus - ada33@gottlieb.org','ada33@gottlieb.org','0096095608',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(197,49,'ArchiElite\\EventsBooking\\Models\\Ticket',197,'AWS re:Invent - Mr. Felton Hills - efrain29@eichmann.com','efrain29@eichmann.com','0648435964',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(198,49,'ArchiElite\\EventsBooking\\Models\\Ticket',198,'AWS re:Invent - Katherine Hill - willms.raven@yahoo.com','willms.raven@yahoo.com','0534797624',1,74.57,74.57,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(199,50,'ArchiElite\\EventsBooking\\Models\\Ticket',199,'AWS re:Invent - Marley Roberts - moen.katrine@yahoo.com','moen.katrine@yahoo.com','0515063015',1,74.57,74.57,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(200,50,'ArchiElite\\EventsBooking\\Models\\Ticket',200,'AWS re:Invent - Savanna Abbott - dooley.abdullah@gmail.com','dooley.abdullah@gmail.com','0868771663',1,74.57,74.57,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43'),(201,50,'ArchiElite\\EventsBooking\\Models\\Ticket',201,'AWS re:Invent - Vergie King - salma.powlowski@gmail.com','salma.powlowski@gmail.com','0760985622',1,74.57,74.57,NULL,'2025-06-10 10:38:43','2025-06-10 10:38:43');
/*!40000 ALTER TABLE `eb_invoice_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_invoices`
--

DROP TABLE IF EXISTS `eb_invoices`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_invoices` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company_logo` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `sub_total` decimal(15,2) NOT NULL,
  `amount` decimal(15,2) NOT NULL,
  `tax_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `discount_amount` decimal(15,2) NOT NULL DEFAULT '0.00',
  `description` text COLLATE utf8mb4_unicode_ci,
  `payment_id` bigint unsigned DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `paid_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_invoices_code_unique` (`code`),
  KEY `eb_invoices_reference_type_reference_id_index` (`reference_type`,`reference_id`),
  KEY `eb_invoices_payment_id_index` (`payment_id`),
  KEY `eb_invoices_status_index` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_invoices`
--

LOCK TABLES `eb_invoices` WRITE;
/*!40000 ALTER TABLE `eb_invoices` DISABLE KEYS */;
INSERT INTO `eb_invoices` VALUES (1,'ArchiElite\\EventsBooking\\Models\\Order',1,'INV-1',4.45,'CES (Consumer Electronics Show)','Alexzander Zemlak','shaun.wolf@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',4.45,4.45,0.00,0.00,NULL,1,'completed','2025-06-10 10:38:38','2025-06-10 10:38:38','2025-06-10 10:38:38'),(2,'ArchiElite\\EventsBooking\\Models\\Order',2,'INV-2',4.45,'CES (Consumer Electronics Show)','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',17.80,17.80,0.00,0.00,NULL,2,'completed','2025-06-10 10:38:38','2025-06-10 10:38:38','2025-06-10 10:38:38'),(3,'ArchiElite\\EventsBooking\\Models\\Order',3,'INV-3',4.45,'CES (Consumer Electronics Show)','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',22.25,22.25,0.00,0.00,NULL,3,'completed','2025-06-10 10:38:38','2025-06-10 10:38:38','2025-06-10 10:38:38'),(4,'ArchiElite\\EventsBooking\\Models\\Order',4,'INV-4',4.45,'CES (Consumer Electronics Show)','Alexzander Zemlak','shaun.wolf@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',8.90,8.90,0.00,0.00,NULL,4,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(5,'ArchiElite\\EventsBooking\\Models\\Order',5,'INV-5',4.45,'CES (Consumer Electronics Show)','Prof. Lee Emmerich I','gutmann.levi@swaniawski.com',NULL,'ArchiElite','main/general/logo-light.png',8.90,8.90,0.00,0.00,NULL,5,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(6,'ArchiElite\\EventsBooking\\Models\\Order',6,'INV-6',4.45,'CES (Consumer Electronics Show)','Prof. Lee Emmerich I','gutmann.levi@swaniawski.com',NULL,'ArchiElite','main/general/logo-light.png',22.25,22.25,0.00,0.00,NULL,6,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(7,'ArchiElite\\EventsBooking\\Models\\Order',7,'INV-7',4.45,'CES (Consumer Electronics Show)','Prof. Lee Emmerich I','gutmann.levi@swaniawski.com',NULL,'ArchiElite','main/general/logo-light.png',8.90,8.90,0.00,0.00,NULL,7,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(8,'ArchiElite\\EventsBooking\\Models\\Order',8,'INV-8',4.45,'CES (Consumer Electronics Show)','Dalton Okuneva','jkilback@rutherford.org',NULL,'ArchiElite','main/general/logo-light.png',22.25,22.25,0.00,0.00,NULL,8,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(9,'ArchiElite\\EventsBooking\\Models\\Order',9,'INV-9',4.45,'CES (Consumer Electronics Show)','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',13.35,13.35,0.00,0.00,NULL,9,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(10,'ArchiElite\\EventsBooking\\Models\\Order',10,'INV-10',4.45,'CES (Consumer Electronics Show)','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',13.35,13.35,0.00,0.00,NULL,10,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(11,'ArchiElite\\EventsBooking\\Models\\Order',11,'INV-11',95.36,'Mobile World Congress','Dalton Okuneva','jkilback@rutherford.org',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,11,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(12,'ArchiElite\\EventsBooking\\Models\\Order',12,'INV-12',95.36,'Mobile World Congress','Trystan Bechtelar','lenore.schmidt@wilkinson.com',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,12,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(13,'ArchiElite\\EventsBooking\\Models\\Order',13,'INV-13',95.36,'Mobile World Congress','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',286.08,286.08,0.00,0.00,NULL,13,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(14,'ArchiElite\\EventsBooking\\Models\\Order',14,'INV-14',95.36,'Mobile World Congress','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,14,'completed','2025-06-10 10:38:39','2025-06-10 10:38:39','2025-06-10 10:38:39'),(15,'ArchiElite\\EventsBooking\\Models\\Order',15,'INV-15',95.36,'Mobile World Congress','Dalton Okuneva','jkilback@rutherford.org',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,15,'completed','2025-06-10 10:38:40','2025-06-10 10:38:39','2025-06-10 10:38:40'),(16,'ArchiElite\\EventsBooking\\Models\\Order',16,'INV-16',95.36,'Mobile World Congress','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,16,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(17,'ArchiElite\\EventsBooking\\Models\\Order',17,'INV-17',95.36,'Mobile World Congress','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',381.44,381.44,0.00,0.00,NULL,17,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(18,'ArchiElite\\EventsBooking\\Models\\Order',18,'INV-18',95.36,'Mobile World Congress','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',95.36,95.36,0.00,0.00,NULL,18,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(19,'ArchiElite\\EventsBooking\\Models\\Order',19,'INV-19',95.36,'Mobile World Congress','Kayley Watsica','dasia81@welch.com',NULL,'ArchiElite','main/general/logo-light.png',95.36,95.36,0.00,0.00,NULL,19,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(20,'ArchiElite\\EventsBooking\\Models\\Order',20,'INV-20',95.36,'Mobile World Congress','Juliet Steuber II','xconnelly@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',286.08,286.08,0.00,0.00,NULL,20,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(21,'ArchiElite\\EventsBooking\\Models\\Order',21,'INV-21',22.42,'Google I/O','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',89.68,89.68,0.00,0.00,NULL,21,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(22,'ArchiElite\\EventsBooking\\Models\\Order',22,'INV-22',22.42,'Google I/O','Juliet Steuber II','xconnelly@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',89.68,89.68,0.00,0.00,NULL,22,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(23,'ArchiElite\\EventsBooking\\Models\\Order',23,'INV-23',22.42,'Google I/O','Alexzander Zemlak','shaun.wolf@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',67.26,67.26,0.00,0.00,NULL,23,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(24,'ArchiElite\\EventsBooking\\Models\\Order',24,'INV-24',22.42,'Google I/O','Dalton Okuneva','jkilback@rutherford.org',NULL,'ArchiElite','main/general/logo-light.png',89.68,89.68,0.00,0.00,NULL,24,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(25,'ArchiElite\\EventsBooking\\Models\\Order',25,'INV-25',22.42,'Google I/O','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',67.26,67.26,0.00,0.00,NULL,25,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(26,'ArchiElite\\EventsBooking\\Models\\Order',26,'INV-26',22.42,'Google I/O','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',22.42,22.42,0.00,0.00,NULL,26,'completed','2025-06-10 10:38:40','2025-06-10 10:38:40','2025-06-10 10:38:40'),(27,'ArchiElite\\EventsBooking\\Models\\Order',27,'INV-27',22.42,'Google I/O','Juliet Steuber II','xconnelly@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',22.42,22.42,0.00,0.00,NULL,27,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(28,'ArchiElite\\EventsBooking\\Models\\Order',28,'INV-28',22.42,'Google I/O','Trystan Bechtelar','lenore.schmidt@wilkinson.com',NULL,'ArchiElite','main/general/logo-light.png',44.84,44.84,0.00,0.00,NULL,28,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(29,'ArchiElite\\EventsBooking\\Models\\Order',29,'INV-29',22.42,'Google I/O','Alexzander Zemlak','shaun.wolf@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',67.26,67.26,0.00,0.00,NULL,29,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(30,'ArchiElite\\EventsBooking\\Models\\Order',30,'INV-30',22.42,'Google I/O','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',112.10,112.10,0.00,0.00,NULL,30,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(31,'ArchiElite\\EventsBooking\\Models\\Order',31,'INV-31',24.31,'Apple WWDC','Trystan Bechtelar','lenore.schmidt@wilkinson.com',NULL,'ArchiElite','main/general/logo-light.png',24.31,24.31,0.00,0.00,NULL,31,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(32,'ArchiElite\\EventsBooking\\Models\\Order',32,'INV-32',24.31,'Apple WWDC','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',97.24,97.24,0.00,0.00,NULL,32,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(33,'ArchiElite\\EventsBooking\\Models\\Order',33,'INV-33',24.31,'Apple WWDC','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',72.93,72.93,0.00,0.00,NULL,33,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(34,'ArchiElite\\EventsBooking\\Models\\Order',34,'INV-34',24.31,'Apple WWDC','Prof. Lee Emmerich I','gutmann.levi@swaniawski.com',NULL,'ArchiElite','main/general/logo-light.png',72.93,72.93,0.00,0.00,NULL,34,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(35,'ArchiElite\\EventsBooking\\Models\\Order',35,'INV-35',24.31,'Apple WWDC','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',72.93,72.93,0.00,0.00,NULL,35,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(36,'ArchiElite\\EventsBooking\\Models\\Order',36,'INV-36',24.31,'Apple WWDC','Prof. Lee Emmerich I','gutmann.levi@swaniawski.com',NULL,'ArchiElite','main/general/logo-light.png',72.93,72.93,0.00,0.00,NULL,36,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(37,'ArchiElite\\EventsBooking\\Models\\Order',37,'INV-37',24.31,'Apple WWDC','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',72.93,72.93,0.00,0.00,NULL,37,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(38,'ArchiElite\\EventsBooking\\Models\\Order',38,'INV-38',24.31,'Apple WWDC','Alexzander Zemlak','shaun.wolf@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',24.31,24.31,0.00,0.00,NULL,38,'completed','2025-06-10 10:38:41','2025-06-10 10:38:41','2025-06-10 10:38:41'),(39,'ArchiElite\\EventsBooking\\Models\\Order',39,'INV-39',24.31,'Apple WWDC','Melyna Simonis','kuhlman.joelle@gleichner.com',NULL,'ArchiElite','main/general/logo-light.png',97.24,97.24,0.00,0.00,NULL,39,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(40,'ArchiElite\\EventsBooking\\Models\\Order',40,'INV-40',24.31,'Apple WWDC','Kayley Watsica','dasia81@welch.com',NULL,'ArchiElite','main/general/logo-light.png',48.62,48.62,0.00,0.00,NULL,40,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(41,'ArchiElite\\EventsBooking\\Models\\Order',41,'INV-41',74.57,'AWS re:Invent','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',298.28,298.28,0.00,0.00,NULL,41,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(42,'ArchiElite\\EventsBooking\\Models\\Order',42,'INV-42',74.57,'AWS re:Invent','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',298.28,298.28,0.00,0.00,NULL,42,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(43,'ArchiElite\\EventsBooking\\Models\\Order',43,'INV-43',74.57,'AWS re:Invent','Kayley Watsica','dasia81@welch.com',NULL,'ArchiElite','main/general/logo-light.png',223.71,223.71,0.00,0.00,NULL,43,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(44,'ArchiElite\\EventsBooking\\Models\\Order',44,'INV-44',74.57,'AWS re:Invent','Juliet Steuber II','xconnelly@yahoo.com',NULL,'ArchiElite','main/general/logo-light.png',223.71,223.71,0.00,0.00,NULL,44,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(45,'ArchiElite\\EventsBooking\\Models\\Order',45,'INV-45',74.57,'AWS re:Invent','Trystan Bechtelar','lenore.schmidt@wilkinson.com',NULL,'ArchiElite','main/general/logo-light.png',74.57,74.57,0.00,0.00,NULL,45,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(46,'ArchiElite\\EventsBooking\\Models\\Order',46,'INV-46',74.57,'AWS re:Invent','Joyce Lemke','customer@archielite.com',NULL,'ArchiElite','main/general/logo-light.png',149.14,149.14,0.00,0.00,NULL,46,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(47,'ArchiElite\\EventsBooking\\Models\\Order',47,'INV-47',74.57,'AWS re:Invent','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',223.71,223.71,0.00,0.00,NULL,47,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(48,'ArchiElite\\EventsBooking\\Models\\Order',48,'INV-48',74.57,'AWS re:Invent','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',298.28,298.28,0.00,0.00,NULL,48,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(49,'ArchiElite\\EventsBooking\\Models\\Order',49,'INV-49',74.57,'AWS re:Invent','Randall Koch II','marvin.jaqueline@gaylord.com',NULL,'ArchiElite','main/general/logo-light.png',298.28,298.28,0.00,0.00,NULL,49,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42'),(50,'ArchiElite\\EventsBooking\\Models\\Order',50,'INV-50',74.57,'AWS re:Invent','Desmond Tillman','christa75@hotmail.com',NULL,'ArchiElite','main/general/logo-light.png',149.14,149.14,0.00,0.00,NULL,50,'completed','2025-06-10 10:38:42','2025-06-10 10:38:42','2025-06-10 10:38:42');
/*!40000 ALTER TABLE `eb_invoices` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_orders`
--

DROP TABLE IF EXISTS `eb_orders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_orders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_id` bigint unsigned NOT NULL,
  `event_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event_ticket_price` decimal(8,2) DEFAULT NULL,
  `account_id` bigint unsigned DEFAULT NULL,
  `currency_id` bigint unsigned NOT NULL,
  `account_name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `private_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `price` decimal(8,2) NOT NULL,
  `quantity` int unsigned NOT NULL,
  `subtotal` decimal(8,2) NOT NULL,
  `total` decimal(8,2) NOT NULL,
  `tax_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_amount` decimal(8,2) NOT NULL DEFAULT '0.00',
  `coupon_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'pending',
  `completed_at` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_orders_code_unique` (`code`),
  UNIQUE KEY `eb_orders_token_unique` (`token`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_orders`
--

LOCK TABLES `eb_orders` WRITE;
/*!40000 ALTER TABLE `eb_orders` DISABLE KEYS */;
INSERT INTO `eb_orders` VALUES (1,'MEZTEEQYNPIP','a6f29e98-cec8-4ec0-9ea0-9e4e5c4e24a0',1,'CES (Consumer Electronics Show)',4.45,30,1,'Alexzander Zemlak','shaun.wolf@yahoo.com','Alice more boldly: \'you know you\'re growing too.\' \'Yes, but I shall only look up in a hurry: a.',NULL,'1',4.45,1,4.45,4.45,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(2,'QQOVL7WAAXE2','aa345160-6c40-4572-963e-c2d972031889',1,'CES (Consumer Electronics Show)',4.45,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','So Bill\'s got the other--Bill! fetch it here, lad!--Here, put \'em up at the sides of the doors of.',NULL,'2',4.45,4,17.80,17.80,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(3,'5RGBQWFAUYCV','2e91e45d-d4e6-4327-ba6b-175eb11be1fd',1,'CES (Consumer Electronics Show)',4.45,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','Alice, seriously, \'I\'ll have nothing more to do this, so she went on to the porpoise, \"Keep back.',NULL,'3',4.45,5,22.25,22.25,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38'),(4,'5U6KY8JNH2CI','3e56a8dd-1317-411c-8f5d-bed3a519b23c',1,'CES (Consumer Electronics Show)',4.45,30,1,'Alexzander Zemlak','shaun.wolf@yahoo.com','Exactly as we were. My notion was that she had found her way into a large ring, with the Mouse had.',NULL,'4',4.45,2,8.90,8.90,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(5,'ULU8GJEKHDDX','8796c34f-8162-4771-969c-de6a41cd8acb',1,'CES (Consumer Electronics Show)',4.45,29,1,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','And yet you incessantly stand on your head-- Do you think, at your age, it is to France-- Then.',NULL,'5',4.45,2,8.90,8.90,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(6,'67KEYXEWDRZX','2a1038bd-1cd1-4272-b3c4-5d4e8ce4dea5',1,'CES (Consumer Electronics Show)',4.45,29,1,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','At last the Dodo managed it.) First it marked out a box of comfits, (luckily the salt water had.',NULL,'6',4.45,5,22.25,22.25,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(7,'IYCO1NXVFIMC','b6a4483a-569f-4c99-bd18-1983f00dd5b6',1,'CES (Consumer Electronics Show)',4.45,29,1,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','I shan\'t grow any more--As it is, I can\'t tell you my adventures--beginning from this morning,\'.',NULL,'7',4.45,2,8.90,8.90,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(8,'8LHRPFHNQR9P','2e02b875-3222-4b90-a7cd-f89a68f10ff8',1,'CES (Consumer Electronics Show)',4.45,19,1,'Dalton Okuneva','jkilback@rutherford.org','I\'ve nothing to do: once or twice, half hoping that they would call after her: the last time she.',NULL,'8',4.45,5,22.25,22.25,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(9,'XVZA9SSONB7M','86067c4d-fe9b-4211-89b0-c9d2dea77070',1,'CES (Consumer Electronics Show)',4.45,1,1,'Joyce Lemke','customer@archielite.com','CHAPTER VIII. The Queen\'s argument was, that if something wasn\'t done about it while the Mock.',NULL,'9',4.45,3,13.35,13.35,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(10,'YMPLG5D3P0JO','8c53ab81-bc64-41b8-82c7-505d2d02fa5e',1,'CES (Consumer Electronics Show)',4.45,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','King. The White Rabbit with pink eyes ran close by it, and then hurried on, Alice started to her.',NULL,'10',4.45,3,13.35,13.35,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(11,'ODXVGYIXZMCY','9e1fccb1-e611-4e61-982b-607755604390',2,'Mobile World Congress',95.36,19,1,'Dalton Okuneva','jkilback@rutherford.org','I can kick a little!\' She drew her foot as far down the chimney as she spoke, but no result seemed.',NULL,'11',95.36,4,381.44,381.44,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(12,'FB3FHUDU4JHA','5d5d0190-63b5-4cd0-b6d5-b4434fb9cdc5',2,'Mobile World Congress',95.36,10,1,'Trystan Bechtelar','lenore.schmidt@wilkinson.com','So she went round the thistle again; then the puppy jumped into the open air. \'IF I don\'t.',NULL,'12',95.36,4,381.44,381.44,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(13,'I7YNHESONPVN','e0dcd03d-4556-4766-9233-f43ecc771fe9',2,'Mobile World Congress',95.36,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','Caterpillar decidedly, and the Queen furiously, throwing an inkstand at the other, and growing.',NULL,'13',95.36,3,286.08,286.08,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(14,'4K4TZ16TKCAO','80057593-8e86-47fd-b894-be2c1b84e332',2,'Mobile World Congress',95.36,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','Knave, \'I didn\'t write it, and on it except a little scream of laughter. \'Oh, hush!\' the Rabbit.',NULL,'14',95.36,4,381.44,381.44,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39'),(15,'QYMCAZETRTBW','b1e0ef50-28ff-4b5c-b1e3-f5e9939145a8',2,'Mobile World Congress',95.36,19,1,'Dalton Okuneva','jkilback@rutherford.org','I shall have to fly; and the pattern on their slates, and she could even make out who was reading.',NULL,'15',95.36,4,381.44,381.44,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:39','2025-06-10 10:38:40'),(16,'U44LMSRSUWRB','e2780f7d-0a17-4d6e-a7a3-ecab94db69a9',2,'Mobile World Congress',95.36,1,1,'Joyce Lemke','customer@archielite.com','COULD! I\'m sure I don\'t know,\' he went on, turning to Alice, flinging the baby violently up and to.',NULL,'16',95.36,4,381.44,381.44,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(17,'BMJS9YSDI4PD','1b804723-3489-4926-b58f-aa498017ffdf',2,'Mobile World Congress',95.36,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','King, who had spoken first. \'That\'s none of YOUR business, Two!\' said Seven. \'Yes, it IS his.',NULL,'17',95.36,4,381.44,381.44,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(18,'FXV6FUUKX5JY','5e7ba9ae-97a5-4ea5-b9af-a9e27df694f5',2,'Mobile World Congress',95.36,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','Mock Turtle, \'but if they do, why then they\'re a kind of authority over Alice. \'Stand up and to.',NULL,'18',95.36,1,95.36,95.36,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(19,'ZHKGYWBMWN9E','86c39b55-9d67-4601-82dd-2e79f66ca161',2,'Mobile World Congress',95.36,17,1,'Kayley Watsica','dasia81@welch.com','Alice remarked. \'Right, as usual,\' said the Lory hastily. \'I don\'t think they play at all this.',NULL,'19',95.36,1,95.36,95.36,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(20,'LPCDDNHTR2UY','4cba3229-e780-4731-9ea8-1bb85318b8e4',2,'Mobile World Congress',95.36,22,1,'Juliet Steuber II','xconnelly@yahoo.com','So Alice got up this morning, but I THINK I can say.\' This was such a hurry that she had hoped) a.',NULL,'20',95.36,3,286.08,286.08,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(21,'JFVHDMNUHUTD','4139c44c-f27e-4c37-aed8-e2dbd431950f',3,'Google I/O',22.42,1,1,'Joyce Lemke','customer@archielite.com','Dodo, pointing to the door, and the Hatter went on, \'you see, a dog growls when it\'s pleased. Now.',NULL,'21',22.42,4,89.68,89.68,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(22,'CRS320JGGXMO','c24e60a0-ff0b-4f0b-9c19-b4f151161515',3,'Google I/O',22.42,22,1,'Juliet Steuber II','xconnelly@yahoo.com','Gryphon, \'that they WOULD go with the name of the e--e--evening, Beautiful, beautiful Soup! Soup.',NULL,'22',22.42,4,89.68,89.68,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(23,'BVYSABIQMLJY','56f2f492-27d9-4f59-bf44-234c192735ae',3,'Google I/O',22.42,30,1,'Alexzander Zemlak','shaun.wolf@yahoo.com','I hadn\'t cried so much!\' Alas! it was too late to wish that! She went in search of her hedgehog.',NULL,'23',22.42,3,67.26,67.26,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(24,'CM3XLSTDGHEM','1ba31dd8-00d6-45b7-b655-d52384970a0b',3,'Google I/O',22.42,19,1,'Dalton Okuneva','jkilback@rutherford.org','This time Alice waited till the eyes appeared, and then keep tight hold of anything, but she heard.',NULL,'24',22.42,4,89.68,89.68,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(25,'JMBVWLYCDOYB','0ec04b58-bbe6-4975-9b30-1cbd88db9355',3,'Google I/O',22.42,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','Alice, and she went on, \'What\'s your name, child?\' \'My name is Alice, so please your Majesty?\' he.',NULL,'25',22.42,3,67.26,67.26,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(26,'R26YB3GRXNZM','b5b30163-790c-43de-862b-acbe5ceae18e',3,'Google I/O',22.42,1,1,'Joyce Lemke','customer@archielite.com','Hatter, and here the conversation a little. \'\'Tis so,\' said the Mock Turtle would be worth the.',NULL,'26',22.42,1,22.42,22.42,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40'),(27,'6GBRZGX9PQNX','548df9af-a646-4e4d-99bf-81eaf7323c7e',3,'Google I/O',22.42,22,1,'Juliet Steuber II','xconnelly@yahoo.com','HAVE tasted eggs, certainly,\' said Alice, \'it\'s very interesting. I never was so much frightened.',NULL,'27',22.42,1,22.42,22.42,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(28,'G77WHLHWNJFU','ef5f2472-5482-46b6-afca-14af2fa9dee1',3,'Google I/O',22.42,10,1,'Trystan Bechtelar','lenore.schmidt@wilkinson.com','Mystery,\' the Mock Turtle: \'nine the next, and so on; then, when you\'ve cleared all the things I.',NULL,'28',22.42,2,44.84,44.84,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(29,'8BOP4TM38BHP','8636d236-8cbd-468e-8696-029e0f997344',3,'Google I/O',22.42,30,1,'Alexzander Zemlak','shaun.wolf@yahoo.com','Rabbit\'s voice along--\'Catch him, you by the Hatter, \'I cut some more bread-and-butter--\' \'But.',NULL,'29',22.42,3,67.26,67.26,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(30,'SEKLWGWQUSRW','42ee014e-98b0-4010-99e2-332ccf940cc5',3,'Google I/O',22.42,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','HIM.\' \'I don\'t see,\' said the Footman, \'and that for the garden!\' and she swam nearer to watch.',NULL,'30',22.42,5,112.10,112.10,0.00,0.00,NULL,'completed',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(31,'FJMKJQ54V48Z','1be3fbcf-671d-4e42-b5f7-ce812382d9e8',4,'Apple WWDC',24.31,10,1,'Trystan Bechtelar','lenore.schmidt@wilkinson.com','I\'ll have you got in your pocket?\' he went on, \'you see, a dog growls when it\'s pleased. Now I.',NULL,'31',24.31,1,24.31,24.31,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(32,'DR8MSADDXATS','e5a6bae4-9a4a-4298-b0a5-f56b7d3ae02c',4,'Apple WWDC',24.31,3,1,'Desmond Tillman','christa75@hotmail.com','Dodo in an offended tone, and added with a cart-horse, and expecting every moment to be no use.',NULL,'32',24.31,4,97.24,97.24,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(33,'BLNDCDLKGL7L','f5a5cea1-d6e3-4055-9a9c-cbff2dff1823',4,'Apple WWDC',24.31,3,1,'Desmond Tillman','christa75@hotmail.com','The Pool of Tears \'Curiouser and curiouser!\' cried Alice hastily, afraid that she began fancying.',NULL,'33',24.31,3,72.93,72.93,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(34,'KGXL3XKJCQQJ','1453c170-012b-4028-b02c-0cf735a12ba4',4,'Apple WWDC',24.31,29,1,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','So she went on, \'What\'s your name, child?\' \'My name is Alice, so please your Majesty?\' he asked.',NULL,'34',24.31,3,72.93,72.93,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(35,'DFJCNY1BKGLZ','46e0be69-5127-41ef-8679-07f0bcd6775e',4,'Apple WWDC',24.31,3,1,'Desmond Tillman','christa75@hotmail.com','Adventures, till she was walking hand in her hands, and she walked down the middle, nursing a.',NULL,'35',24.31,3,72.93,72.93,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(36,'ECFNE121DMTK','6060fca5-a8c9-41db-a0dc-08424ea4fe9a',4,'Apple WWDC',24.31,29,1,'Prof. Lee Emmerich I','gutmann.levi@swaniawski.com','Queen never left off when they passed too close, and waving their forepaws to mark the time, while.',NULL,'36',24.31,3,72.93,72.93,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(37,'RC3PXNKVYEMN','6267d4cf-a962-465c-970f-4093bfef5b60',4,'Apple WWDC',24.31,3,1,'Desmond Tillman','christa75@hotmail.com','Alice doubtfully: \'it means--to--make--anything--prettier.\' \'Well, then,\' the Cat again, sitting.',NULL,'37',24.31,3,72.93,72.93,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(38,'JFO4L8SGTJ5W','f602a606-792f-4589-a761-da4e6a9287cb',4,'Apple WWDC',24.31,30,1,'Alexzander Zemlak','shaun.wolf@yahoo.com','Alice, a little startled when she was now, and she walked up towards it rather timidly, as she.',NULL,'38',24.31,1,24.31,24.31,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41'),(39,'LANRBNOCHUBI','f41f49fd-cfb6-4261-b1f6-9df4c26fd3b9',4,'Apple WWDC',24.31,27,1,'Melyna Simonis','kuhlman.joelle@gleichner.com','Mock Turtle drew a long hookah, and taking not the same, the next witness. It quite makes my.',NULL,'39',24.31,4,97.24,97.24,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(40,'J37S1AHEVHVY','6d8979f0-6c35-410b-9c51-e9fcc01eb19f',4,'Apple WWDC',24.31,17,1,'Kayley Watsica','dasia81@welch.com','Bill had left off writing on his spectacles and looked at the Duchess by this time?\' she said to.',NULL,'40',24.31,2,48.62,48.62,0.00,0.00,NULL,'refunded',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(41,'HWX5GVZ9ESG5','b2a41444-0bb5-4f2f-af5e-51a5054f5f6a',5,'AWS re:Invent',74.57,3,1,'Desmond Tillman','christa75@hotmail.com','Dormouse. \'Don\'t talk nonsense,\' said Alice to find that she had never done such a fall as this, I.',NULL,'41',74.57,4,298.28,298.28,0.00,0.00,NULL,'pending',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(42,'N2DPMCHMTFHT','cf851240-98ae-4e32-bd20-38fd4087f421',5,'AWS re:Invent',74.57,1,1,'Joyce Lemke','customer@archielite.com','Alice could think of any use, now,\' thought Alice, \'and why it is to find any. And yet I wish you.',NULL,'42',74.57,4,298.28,298.28,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(43,'KFTCJRLZWTHB','f87536e4-e1ec-4d9c-8820-e59e82d8297c',5,'AWS re:Invent',74.57,17,1,'Kayley Watsica','dasia81@welch.com','This did not like to see a little sharp bark just over her head was so much already, that it might.',NULL,'43',74.57,3,223.71,223.71,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(44,'1CTBG74RCJM0','ffa7aa8c-0fb5-4386-96e5-8f2dda495735',5,'AWS re:Invent',74.57,22,1,'Juliet Steuber II','xconnelly@yahoo.com','Alice, as she could, \'If you do. I\'ll set Dinah at you!\' There was a dead silence. \'It\'s a friend.',NULL,'44',74.57,3,223.71,223.71,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(45,'SPHPXAYBBRCK','e8b1a5db-d1b9-4977-9556-56c59c961273',5,'AWS re:Invent',74.57,10,1,'Trystan Bechtelar','lenore.schmidt@wilkinson.com','With gently smiling jaws!\' \'I\'m sure those are not attending!\' said the Dodo, \'the best way you.',NULL,'45',74.57,1,74.57,74.57,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(46,'Q37KSPPL7LCQ','0bcc69eb-34eb-4e2e-9c17-dcdd1811aa5a',5,'AWS re:Invent',74.57,1,1,'Joyce Lemke','customer@archielite.com','Bill\'s place for a minute or two sobs choked his voice. \'Same as if it had made. \'He took me for a.',NULL,'46',74.57,2,149.14,149.14,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(47,'FS5JGKGLMKUF','ec0ce357-c77e-4923-a036-4e34d0c84be1',5,'AWS re:Invent',74.57,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','The Dormouse slowly opened his eyes were nearly out of the game, feeling very glad to find that.',NULL,'47',74.57,3,223.71,223.71,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(48,'STFVFVJV8IFH','d94a5d39-849e-4953-b8af-0d2b617f8133',5,'AWS re:Invent',74.57,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','Hardly knowing what she did, she picked her way out. \'I shall be a great crowd assembled about.',NULL,'48',74.57,4,298.28,298.28,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(49,'V6KRVV4IGRUO','1b486e5a-e94c-4e71-b78c-b5e43f7c491d',5,'AWS re:Invent',74.57,26,1,'Randall Koch II','marvin.jaqueline@gaylord.com','Mock Turtle with a sigh: \'he taught Laughing and Grief, they used to know. Let me see: I\'ll give.',NULL,'49',74.57,4,298.28,298.28,0.00,0.00,NULL,'cancelled',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42'),(50,'GWK7CJWBE406','f5b89a35-9145-4464-820b-2f828b88d394',5,'AWS re:Invent',74.57,3,1,'Desmond Tillman','christa75@hotmail.com','Alice. \'Come on, then!\' roared the Queen, \'and take this child away with me,\' thought Alice.',NULL,'50',74.57,2,149.14,149.14,0.00,0.00,NULL,'processing',NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42');
/*!40000 ALTER TABLE `eb_orders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_taxes`
--

DROP TABLE IF EXISTS `eb_taxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_taxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `percentage` float DEFAULT NULL,
  `priority` int DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_taxes`
--

LOCK TABLES `eb_taxes` WRITE;
/*!40000 ALTER TABLE `eb_taxes` DISABLE KEYS */;
/*!40000 ALTER TABLE `eb_taxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `eb_tickets`
--

DROP TABLE IF EXISTS `eb_tickets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `eb_tickets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint unsigned DEFAULT NULL,
  `code` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `phone` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `checked_in_at` date DEFAULT NULL,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'purchased',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `eb_tickets_code_unique` (`code`)
) ENGINE=InnoDB AUTO_INCREMENT=202 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `eb_tickets`
--

LOCK TABLES `eb_tickets` WRITE;
/*!40000 ALTER TABLE `eb_tickets` DISABLE KEYS */;
INSERT INTO `eb_tickets` VALUES (1,1,'MQHZABJXFDNG','Ford Gusikowski','ewisozk@yahoo.com','0312803984','Alice put down the little glass table. \'Now, I\'ll manage better this time,\' she said these words.',NULL,'purchased','2025-06-10 10:38:38','2025-06-10 10:38:38'),(2,1,'GIYVEFC1A8EL','Salvatore Swift DVM','vullrich@hotmail.com','0193828282','I do,\' said the Gryphon: \'I went to the Dormouse, after thinking a minute or two. \'They couldn\'t.',NULL,'purchased','2025-06-10 10:38:38','2025-06-10 10:38:38'),(3,2,'CDRO9WESRN0X','Rebeca Rempel','junior76@hotmail.com','0285937313','YOU?\' said the White Rabbit returning, splendidly dressed, with a sigh: \'it\'s always tea-time, and.',NULL,'purchased','2025-06-10 10:38:38','2025-06-10 10:38:38'),(4,2,'B8U7DVFJJYZB','Mrs. Gwen Rau','eusebio79@ondricka.com','0187693844','Duchess; \'and most things twinkled after that--only the March Hare moved into the roof of the.',NULL,'refunded','2025-06-10 10:38:38','2025-06-10 10:38:38'),(5,2,'LIEQM74GLYWZ','Erik Kuphal I','prohaska.lessie@miller.com','0609913053','Dormouse followed him: the March Hare and the White Rabbit interrupted: \'UNimportant, your Majesty.',NULL,'reserved','2025-06-10 10:38:38','2025-06-10 10:38:38'),(6,2,'KY3OL6ELJM5S','Jackson Weber','wilber91@yahoo.com','0271337617','Duck. \'Found IT,\' the Mouse replied rather impatiently: \'any shrimp could have told you butter.',NULL,'checked_in','2025-06-10 10:38:38','2025-06-10 10:38:38'),(7,2,'ADVMZK6A7ZIF','Bernie Wilderman','althea.ruecker@collins.org','0217326164','Beautiful, beauti--FUL SOUP!\' \'Chorus again!\' cried the Mouse, who seemed too much frightened to.',NULL,'cancelled','2025-06-10 10:38:38','2025-06-10 10:38:38'),(8,3,'IW237ZDAUKRC','Dr. Juvenal Tremblay','graham.marcia@douglas.info','0039634705','But they HAVE their tails in their mouths--and they\'re all over with fright. \'Oh, I BEG your.',NULL,'purchased','2025-06-10 10:38:38','2025-06-10 10:38:38'),(9,3,'8VBKIPAU5V3D','Dr. Rahul Murazik Sr.','qcummerata@gmail.com','0703590067','Off--\' \'Nonsense!\' said Alice, (she had grown to her very much confused, \'I don\'t see any wine,\'.',NULL,'transferred','2025-06-10 10:38:38','2025-06-10 10:38:38'),(10,3,'4PIAIJCEWX7P','Dr. Tara Greenholt I','breanne76@schamberger.net','0174192361','Alice, \'because I\'m not Ada,\' she said, by way of nursing it, (which was to find herself still in.',NULL,'purchased','2025-06-10 10:38:38','2025-06-10 10:38:38'),(11,3,'CIRZGAEX7XYV','Dustin Dietrich','derick.schmidt@gmail.com','0104833291','CAN have happened to you? Tell us all about for a baby: altogether Alice did not like the three.',NULL,'cancelled','2025-06-10 10:38:38','2025-06-10 10:38:38'),(12,3,'0UTPL6Q0PQFQ','Dave Willms','donny.weber@gmail.com','0856369230','Alice as she stood looking at it gloomily: then he dipped it into one of them.\' In another moment.',NULL,'cancelled','2025-06-10 10:38:38','2025-06-10 10:38:38'),(13,3,'PPBIMQXQ3V1H','Maye Pacocha','shields.eleanore@ratke.com','0795085594','So she was exactly three inches high). \'But I\'m not the same, the next verse.\' \'But about his.',NULL,'cancelled','2025-06-10 10:38:38','2025-06-10 10:38:38'),(14,4,'NRIFIZ88QEEH','Lenora Heaney MD','wilber22@gmail.com','0412229300','Gryphon. \'I mean, what makes them sour--and camomile that makes people hot-tempered,\' she went on.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(15,4,'OGSMNTEL8JK8','Destini Lindgren','irwin83@gmail.com','0252171374','Alice, (she had kept a piece of bread-and-butter in the wood, \'is to grow to my right size for.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(16,4,'T9N9GF3L0TWW','Winnifred Boehm','schaefer.emmet@dicki.com','0976046696','I\'ve got back to finish his story. CHAPTER IV. The Rabbit Sends in a low, hurried tone. He looked.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(17,5,'4RYRR9PQ63O1','Cathy Pagac','julien.russel@gmail.com','0357623247','I\'m a hatter.\' Here the Dormouse said--\' the Hatter and the fan, and skurried away into the book.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(18,5,'QVY4J3XI2R6T','Roberta Kshlerin','dominic.volkman@jacobs.info','0422302566','There was nothing on it (as she had not long to doubt, for the fan and the other end of the same.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(19,5,'B85DAV9OB5ZN','Ms. Queenie Dooley IV','connelly.tara@stokes.com','0969494180','Time!\' \'Perhaps not,\' Alice replied eagerly, for she felt that it ought to tell its age, there was.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(20,6,'BW28VXNS6GIY','Sylvan Welch','shirley.hane@quitzon.com','0327895139','I shall have to ask his neighbour to tell me your history, she do.\' \'I\'ll tell it her,\' said the.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(21,6,'KJT94RXNHSWI','Mr. Brant Moore DDS','jerrell.barton@barrows.com','0499309669','RED rose-tree, and we won\'t talk about trouble!\' said the Dodo, pointing to the table to measure.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(22,6,'PC2UDWUKUTFW','Giovanni Fahey','sydni62@kutch.com','0342631081','Lobster Quadrille is!\' \'No, indeed,\' said Alice. \'Of course they were\', said the Gryphon, and the.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(23,6,'CAEJW1AM5VT5','Nichole Rippin DDS','ybraun@hotmail.com','0895023429','Alice thought she had a VERY good opportunity for croqueting one of the wood--(she considered him.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(24,6,'PKBNOABMO3TU','Juanita Schumm','eino32@hahn.com','0092617082','Cat went on, \'and most things twinkled after that--only the March Hare. \'It was much pleasanter at.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(25,6,'HC9JD2YUTEMN','Prof. Lucie Trantow','darrion82@yahoo.com','0382962331','YOU, and no one listening, this time, and was going to say,\' said the Duchess, who seemed ready to.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(26,7,'3FGCUGSTD2K2','Prof. Ruthe Schumm','candice88@jerde.org','0093128954','FIT you,\' said the Hatter: \'but you could only hear whispers now and then added them up, and.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(27,7,'JVF4QUALSZ2D','Miss Kayli Weimann','htillman@yahoo.com','0348714509','For some minutes the whole pack of cards!\' At this the White Rabbit with pink eyes ran close by.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(28,7,'FGJ8LSZ39YG2','Isidro Lehner','dasia84@hotmail.com','0195110157','Alice could speak again. The rabbit-hole went straight on like a sky-rocket!\' \'So you did, old.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(29,8,'PSPQFMSHH4ZV','Claudie Ferry','doyle.fabian@yahoo.com','0447272213','Alice hastily, afraid that she had quite forgotten the little golden key in the other. \'I beg your.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(30,8,'2AVHGDCJQQLG','Mr. Ulises Botsford PhD','lucius56@hotmail.com','0169426948','Mock Turtle: \'why, if a fish came to ME, and told me he was going off into a butterfly, I should.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(31,8,'JCLFHYGRZY85','Karolann Gerhold','jamar.koelpin@hotmail.com','0126088810','White Rabbit, \'and that\'s the queerest thing about it.\' \'She\'s in prison,\' the Queen say only.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(32,8,'PWPCTAMQHQQP','Erich Schmeler','william.funk@larkin.org','0712694598','I\'ve tried banks, and I\'ve tried banks, and I\'ve tried banks, and I\'ve tried banks, and I\'ve tried.',NULL,'purchased','2025-06-10 10:38:39','2025-06-10 10:38:39'),(33,8,'GX1N4UCBKFHY','Mr. Abdul Effertz I','xschimmel@blanda.org','0658731852','However, this bottle does. I do it again and again.\' \'You are old,\' said the King. (The jury all.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(34,8,'NB7XQUJOJ7OZ','Carleton Hintz','tia.cummings@hotmail.com','0877835250','I eat one of them even when they saw the White Rabbit blew three blasts on the trumpet, and called.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(35,9,'NJZJV1HLUPEJ','Jordon Gutmann','nabbott@yahoo.com','0192872222','Her chin was pressed hard against it, that attempt proved a failure. Alice heard the Queen of.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(36,9,'EARIGXG2GV1K','Chasity Tromp','jayden38@wuckert.com','0192667002','I beg your pardon!\' cried Alice hastily, afraid that she had expected: before she gave her one.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(37,9,'OOYM1UOFIKKH','Dana Grady','derrick.lind@hotmail.com','0763069984','But they HAVE their tails fast in their mouths; and the soldiers did. After these came the guests.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(38,9,'86GWZTPAJCUU','Mylene Predovic','deangelo.renner@gmail.com','0168051515','Alice could think of nothing else to say it out again, so that by the end of every line: \'Speak.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(39,10,'8EPI7ULUEQ5I','Mr. Leif Bradtke','grimes.reese@hotmail.com','0200096223','Alice got up this morning? I almost wish I\'d gone to see you again, you dear old thing!\' said the.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(40,10,'RIQASQSR0DSG','Dr. Tania Grady Sr.','rmckenzie@ondricka.com','0793199160','The Mouse did not venture to say \"HOW DOTH THE LITTLE BUSY BEE,\" but it was the same thing as \"I.',NULL,'purchased','2025-06-10 10:38:39','2025-06-10 10:38:39'),(41,10,'UDU4KTRLMKSW','Lera Nienow','antone20@greenholt.com','0624147885','However, I\'ve got to the Mock Turtle, \'but if you\'ve seen them so often, of course had to kneel.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(42,10,'PYBN1S2ZY59Z','Rosemarie Ortiz','wwalter@gmail.com','0744441968','Alice. \'I\'ve tried every way, and then the puppy jumped into the court, she said to herself \'It\'s.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(43,11,'0ACW24IKG2WF','Jimmy Bogisich I','cassidy.kozey@yahoo.com','0924984113','Dormouse shall!\' they both cried. \'Wake up, Dormouse!\' And they pinched it on both sides of it.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(44,11,'8OLX8VXIVLZ7','Mrs. Elmira Littel I','jeremy.grimes@labadie.com','0935833931','Alice for some time in silence: at last came a little nervous about it while the rest of the room.',NULL,'purchased','2025-06-10 10:38:39','2025-06-10 10:38:39'),(45,11,'RC7BKAC4XHZF','Mr. Weston Kunde I','lynch.candelario@hotmail.com','0117624893','Pat, what\'s that in the same year for such dainties would not give all else for two Pennyworth.',NULL,'transferred','2025-06-10 10:38:39','2025-06-10 10:38:39'),(46,11,'LAMHWMSB78FW','Carolyn Dare I','maggio.janessa@gmail.com','0780906804','Alice thought over all she could guess, she was as much as she could remember about ravens and.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(47,11,'VKEU2LZVTDQ7','Miss Layla Aufderhar','wilkinson.cedrick@weber.com','0555597186','Alice to herself, as usual. \'Come, there\'s half my plan done now! How puzzling all these strange.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(48,12,'RDU1YJ8YNK2F','Valentin O\'Reilly MD','rebert@yahoo.com','0859983270','Puss,\' she began, rather timidly, as she could, and soon found herself lying on the top of her.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(49,12,'DCQJSF5XIR9C','Elton Kassulke','kutch.darius@gmail.com','0314843483','I suppose it were nine o\'clock in the air: it puzzled her very earnestly, \'Now, Dinah, tell me who.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(50,12,'59AZJSAX4OIQ','Prof. Rylan Koss Sr.','maiya.schumm@hotmail.com','0244732703','Alice remarked. \'Oh, you foolish Alice!\' she answered herself. \'How can you learn lessons in here?.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(51,12,'AP8ADQ6SVS2N','Mrs. Delia Yost','jrowe@ward.net','0002747827','Hatter. He came in sight of the earth. At last the Dodo could not remember ever having seen in her.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(52,12,'MQ9WFBZHUTWC','Leopold Aufderhar Sr.','okon.valentina@yahoo.com','0547118401','Caterpillar. \'I\'m afraid I\'ve offended it again!\' For the Mouse to tell me the truth: did you.',NULL,'purchased','2025-06-10 10:38:39','2025-06-10 10:38:39'),(53,13,'3CFANHOADN49','Mr. Dale Trantow IV','lparisian@herzog.com','0540950612','Alice did not dare to disobey, though she knew that it was a different person then.\' \'Explain all.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(54,13,'HSWGRZNWFODH','Zula Hickle','maudie13@wisozk.com','0130853530','THE VOICE OF THE SLUGGARD,\"\' said the Gryphon, and, taking Alice by the officers of the other side.',NULL,'cancelled','2025-06-10 10:38:39','2025-06-10 10:38:39'),(55,13,'UZOFD40ST2SH','Prof. Adriel Bartoletti','donald.weissnat@yahoo.com','0392796208','King hastily said, and went on: \'--that begins with an M?\' said Alice. \'Well, then,\' the Gryphon.',NULL,'reserved','2025-06-10 10:38:39','2025-06-10 10:38:39'),(56,13,'DBDDIVR8BUAA','Cleta Price','luisa38@jaskolski.com','0878095745','Alice sharply, for she felt certain it must make me grow larger, I can go back by railway,\' she.',NULL,'purchased','2025-06-10 10:38:39','2025-06-10 10:38:39'),(57,14,'MRKEO3ODFW84','Ms. Isabell Becker III','dubuque.wilfrid@gmail.com','0564381892','BEST butter,\' the March Hare and his buttons, and turns out his toes.\' [later editions continued.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(58,14,'UEPQOT6UTMSG','Georgianna O\'Connell','jevon.lind@vandervort.com','0372889843','I suppose you\'ll be asleep again before it\'s done.\' \'Once upon a neat little house, and have next.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(59,14,'ZGQRHPWIPGC0','Burnice Huels','ellie48@greenholt.com','0343865085','And she\'s such a thing. After a time there were three gardeners who were lying on the glass table.',NULL,'checked_in','2025-06-10 10:38:39','2025-06-10 10:38:39'),(60,14,'7XPLIRRMV5F4','Dr. Howell Medhurst IV','lvonrueden@yahoo.com','0835838346','OUT OF ITS WAISTCOAT-POCKET, and looked at the Queen, who were giving it a minute or two, she made.',NULL,'refunded','2025-06-10 10:38:39','2025-06-10 10:38:39'),(61,14,'CWLVM6XX69BR','Roselyn Emmerich','jeramy52@gmail.com','0834909257','For some minutes it seemed quite natural to Alice as he spoke. \'A cat may look at me like a snout.',NULL,'pending','2025-06-10 10:38:39','2025-06-10 10:38:39'),(62,15,'QJRQYGWVWK8R','Rubie Blanda III','wiegand.jo@bartoletti.info','0212507190','VERY remarkable in that; nor did Alice think it so yet,\' said the voice. \'Fetch me my gloves this.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(63,15,'QZAH1ZOJHOOG','Hilario Miller','amayer@roberts.com','0341957663','I almost wish I hadn\'t drunk quite so much!\' Alas! it was sneezing and howling alternately without.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(64,15,'SOYGFWBZGZTJ','Kristian Lehner II','olowe@hotmail.com','0080450231','You know the way I want to be?\' it asked. \'Oh, I\'m not the smallest notice of her ever getting out.',NULL,'refunded','2025-06-10 10:38:40','2025-06-10 10:38:40'),(65,15,'YWYA9ICO7FRW','Prince McCullough','houston.kuhn@gmail.com','0030642153','I\'m Mabel, I\'ll stay down here till I\'m somebody else\"--but, oh dear!\' cried Alice, with a little.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(66,15,'NXXLZWOT8HQA','Lloyd Deckow','camylle60@cremin.net','0079953419','Presently the Rabbit hastily interrupted. \'There\'s a great crash, as if a dish or kettle had been.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(67,16,'DDJOQJREAZMM','Brenden Sawayn','olson.keyshawn@runte.com','0255837784','I think?\' \'I had NOT!\' cried the Mouse, turning to the jury, and the turtles all advance! They are.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(68,16,'TTDFJUSVVHZO','Hosea Koss','halvorson.veda@eichmann.com','0207120066','Never heard of uglifying!\' it exclaimed. \'You know what \"it\" means.\' \'I know SOMETHING interesting.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(69,16,'UWADNGZISOFE','Dewitt Smitham','kstrosin@yahoo.com','0115073398','And yet I don\'t want to get in?\' she repeated, aloud. \'I shall sit here,\' he said, turning to.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(70,16,'IGCKJXTY1LVU','Nathan Rutherford','michelle.donnelly@rowe.com','0805431849','Ann! Mary Ann!\' said the Mock Turtle. \'Certainly not!\' said Alice to herself, and nibbled a little.',NULL,'refunded','2025-06-10 10:38:40','2025-06-10 10:38:40'),(71,16,'5OEYOXWSPNW6','Mrs. Caitlyn Donnelly','kaley40@gmail.com','0932260310','Alice. \'Of course it is,\' said the Caterpillar. \'Well, I never heard of one,\' said Alice. \'Of.',NULL,'purchased','2025-06-10 10:38:40','2025-06-10 10:38:40'),(72,17,'OYQAJDW5QBPL','Prof. Ryleigh Moore III','lourdes59@leannon.info','0458416250','ME, and told me he was speaking, so that her flamingo was gone in a very small cake, on which the.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(73,17,'OTJMCB4TNKGS','Abdiel Halvorson V','solon79@hotmail.com','0900531499','Him, and ourselves, and it. Don\'t let me help to undo it!\' \'I shall sit here,\' he said, turning to.',NULL,'purchased','2025-06-10 10:38:40','2025-06-10 10:38:40'),(74,17,'JQ2IVNMFL5HT','Tressie Schaden I','mariane72@langosh.com','0819456984','WHAT? The other guests had taken his watch out of THIS!\' (Sounds of more energetic remedies--\'.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(75,17,'B63NFTI6XF57','Ibrahim Kling III','noemy.spinka@yahoo.com','0398351217','No, no! You\'re a serpent; and there\'s no harm in trying.\' So she began fancying the sort of.',NULL,'transferred','2025-06-10 10:38:40','2025-06-10 10:38:40'),(76,17,'O0UEVAJWDBYE','Izabella Kutch','fadel.otis@hotmail.com','0288076241','Just at this moment the door of which was a dead silence. Alice noticed with some difficulty, as.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(77,18,'D6JHTDZZLKGT','Wendell Goodwin DVM','ahalvorson@kemmer.com','0646685753','I\'m sure _I_ shan\'t be able! I shall never get to the garden door. Poor Alice! It was all.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(78,18,'E3VBKWQCFRK8','Sylvan Rodriguez','hillary.king@roberts.com','0355074997','I know all the creatures order one about, and called out, \'Sit down, all of you, and must know.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(79,19,'NNL4LNP5NYIV','Drew VonRueden','katherine.haley@hodkiewicz.net','0478224724','March Hare. \'Then it wasn\'t trouble enough hatching the eggs,\' said the Duchess: \'what a clear way.',NULL,'refunded','2025-06-10 10:38:40','2025-06-10 10:38:40'),(80,19,'NW6RYZ8UN5OI','Paris Hackett','igoldner@boyer.com','0253280949','I\'ve tried to open them again, and put back into the jury-box, or they would die. \'The trial.',NULL,'refunded','2025-06-10 10:38:40','2025-06-10 10:38:40'),(81,20,'TRRA46AMFQ6W','Geovanny Williamson','hilbert23@gmail.com','0228905674','Alice and all that,\' said Alice. \'I mean what I say,\' the Mock Turtle said: \'advance twice, set to.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(82,20,'ZR20MNDIP20M','Chester Dicki PhD','edythe32@gmail.com','0837524421','THIS size: why, I should like it very nice, (it had, in fact, I didn\'t know how to begin.\' He.',NULL,'purchased','2025-06-10 10:38:40','2025-06-10 10:38:40'),(83,20,'XVVLA71AKMF0','Prof. Reinhold Nikolaus MD','tgrimes@gmail.com','0358765246','Lizard) could not join the dance? Will you, won\'t you, will you, won\'t you, will you join the.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(84,20,'YEZ3VPLBX45S','Tyree Lebsack','ubeahan@kirlin.com','0528378017','Sir, With no jury or judge, would be four thousand miles down, I think--\' (for, you see, so many.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(85,21,'YYSK4CV3FTZV','Eloy Zemlak','kmueller@kihn.com','0783349807','And so it was over at last: \'and I do it again and again.\' \'You are old,\' said the Queen, in a.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(86,21,'67GFQKUHVA3N','Dr. Bernice Donnelly DVM','dwilderman@gmail.com','0264168453','However, she did it so yet,\' said the King. \'Nearly two miles high,\' added the Gryphon, and the.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(87,21,'DH9OE45ZTWPW','Mable Bogisich Jr.','krempel@stamm.com','0221442501','Alice the moment she appeared; but she added, to herself, in a whisper.) \'That would be a LITTLE.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(88,21,'HLQZV4KMMDYL','Eloisa O\'Connell','clakin@hotmail.com','0513963047','King. \'I can\'t explain it,\' said Alice, a little sharp bark just over her head impatiently; and.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(89,21,'1N2DSXI40OT8','Claude Murazik','hritchie@gmail.com','0200504113','So they sat down, and was delighted to find that the reason so many lessons to learn! No, I\'ve.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(90,22,'MPHL2ZMAUO6P','Dr. Kameron Ward','lbaumbach@gmail.com','0279486201','Some of the country is, you ARE a simpleton.\' Alice did not quite like the tone of great relief.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(91,22,'FZ15GETYXNMR','Aurelio Medhurst','zula12@dibbert.com','0763923038','QUITE as much right,\' said the Dormouse; \'--well in.\' This answer so confused poor Alice, who felt.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(92,22,'5B4IYVQJUMOQ','Johnathon Fisher','stokes.jordyn@wilderman.org','0439112644','Alice, she went slowly after it: \'I never was so long that they would call after her: the last few.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(93,22,'473NJAHLAFSG','Pablo Schroeder','ggleason@hotmail.com','0241400185','I suppose Dinah\'ll be sending me on messages next!\' And she began nursing her child again, singing.',NULL,'refunded','2025-06-10 10:38:40','2025-06-10 10:38:40'),(94,22,'UYD5SRWMVVAB','Marina Altenwerth','gordon.erdman@yahoo.com','0936880469','ONE.\' \'One, indeed!\' said the Caterpillar. \'Well, perhaps you haven\'t found it made no mark; but.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(95,23,'T4KT5XFUI8S1','Ashtyn Larson','alan.olson@yahoo.com','0443941432','Gryphon said to herself, \'in my going out altogether, like a writing-desk?\' \'Come, we shall have.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(96,23,'O3O3I1KAZ1WN','Dr. Art Leuschke MD','konopelski.luciano@paucek.com','0396887717','Cat, as soon as look at the Queen, and Alice looked round, eager to see what the next witness.\'.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(97,23,'9BRIFUUHVFWB','Mr. William Bahringer','littel.dagmar@hotmail.com','0188415759','Dormouse, after thinking a minute or two, it was good manners for her to carry it further. So she.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(98,23,'B0GYCYRRMJQV','Nicklaus Hirthe','rreilly@yahoo.com','0278676325','Dormouse,\' the Queen of Hearts, carrying the King\'s crown on a little irritated at the place of.',NULL,'transferred','2025-06-10 10:38:40','2025-06-10 10:38:40'),(99,24,'MO7SZUTUUJOX','Imelda Pagac','lelia.ondricka@nitzsche.com','0000376678','Hatter. \'I told you butter wouldn\'t suit the works!\' he added in a mournful tone, \'he won\'t do a.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(100,24,'15ONLYC1WYDF','Rossie Conroy','zion.gleichner@gmail.com','0887530988','White Rabbit, who was beginning very angrily, but the Hatter went on, \'What\'s your name, child?\'.',NULL,'pending','2025-06-10 10:38:40','2025-06-10 10:38:40'),(101,24,'TROQ0DVDNVK4','Alysson Murphy MD','raquel.collins@oconnell.biz','0963273459','Rabbit\'s little white kid gloves, and was going to turn round on its axis--\' \'Talking of axes,\'.',NULL,'transferred','2025-06-10 10:38:40','2025-06-10 10:38:40'),(102,24,'URN7UZD1JERD','Jada Bailey','haag.magali@oconner.com','0266747968','Alice looked very uncomfortable. The first thing she heard a voice sometimes choked with sobs, to.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(103,24,'CCBND5JRX92V','Dr. Ralph Wolff','casper.lowe@gmail.com','0051672105','There was a little different. But if I\'m Mabel, I\'ll stay down here! It\'ll be no use in crying.',NULL,'checked_in','2025-06-10 10:38:40','2025-06-10 10:38:40'),(104,25,'0TEAYVZQRLOH','Mr. Riley Gerhold','karelle55@wisoky.com','0648631181','I\'ll try if I would talk on such a curious appearance in the prisoner\'s handwriting?\' asked.',NULL,'transferred','2025-06-10 10:38:40','2025-06-10 10:38:40'),(105,25,'T4QZDDV9CQY2','Mr. Eladio Bradtke','eusebio15@luettgen.org','0658626776','Gryphon went on growing, and growing, and growing, and growing, and she trembled till she was now.',NULL,'transferred','2025-06-10 10:38:40','2025-06-10 10:38:40'),(106,25,'YM81ISQNCYPW','Layne Hermiston','eondricka@yahoo.com','0394933086','Was kindly permitted to pocket the spoon: While the Owl had the dish as its share of the trees.',NULL,'cancelled','2025-06-10 10:38:40','2025-06-10 10:38:40'),(107,25,'8NOYPQCGZ0FQ','Miss Matilda Kuhic II','thompson.esther@wintheiser.info','0332208497','I believe.\' \'Boots and shoes under the table: she opened the door began sneezing all at once. The.',NULL,'reserved','2025-06-10 10:38:40','2025-06-10 10:38:40'),(108,26,'KDBCIGK5GHKS','Dr. Enoch Larson','amorissette@wolf.info','0546178413','Caterpillar. Here was another long passage, and the March Hare said to herself. At this the White.',NULL,'purchased','2025-06-10 10:38:40','2025-06-10 10:38:40'),(109,26,'TDEUJTN75NQY','Luigi Rodriguez','juliana.stehr@gmail.com','0258492661','A bright idea came into Alice\'s head. \'Is that the reason of that?\' \'In my youth,\' said the.',NULL,'purchased','2025-06-10 10:38:40','2025-06-10 10:38:40'),(110,27,'1VILQJWBKJUC','Otho Hauck','ymarks@lakin.com','0794154587','Oh dear! I\'d nearly forgotten to ask.\' \'It turned into a cucumber-frame, or something of the.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(111,27,'PRULON9KL08F','Prof. Coleman Harvey Sr.','fritz.kertzmann@nienow.com','0346179802','CAN I have done that, you know,\' the Hatter replied. \'Of course you don\'t!\' the Hatter instead!\'.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(112,28,'9KAJKKHOWEYI','Ms. Aylin Nitzsche','xhahn@gutkowski.com','0590141237','SAID was, \'Why is a long way. So she went back to the conclusion that it would feel with all speed.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(113,28,'XYWIMFDHZCXQ','Dr. Nash Kunde','kautzer.louisa@gmail.com','0302595133','His voice has a timid and tremulous sound.] \'That\'s different from what I should like to try the.',NULL,'refunded','2025-06-10 10:38:41','2025-06-10 10:38:41'),(114,28,'5XCVCCEIDMR3','Isabella Lockman','shanon16@yahoo.com','0646714573','I\'ll be jury,\" Said cunning old Fury: \"I\'ll try the first verse,\' said the Gryphon: and it put.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(115,29,'MHMRYIODMZP9','Berta Marquardt PhD','vaughn14@gmail.com','0270017965','Alice, \'or perhaps they won\'t walk the way I ought to be otherwise than what it was the Duchess\'s.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(116,29,'HQVPTULVV7HG','Miss Jacquelyn Heller','kuhic.adell@pfannerstill.info','0871790177','Alice thought to herself, for this time the Mouse was bristling all over, and both footmen, Alice.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(117,29,'M3OZH5WSBKZT','Catalina Lang PhD','btillman@oconner.org','0254361795','CHAPTER V. Advice from a bottle marked \'poison,\' so Alice went on planning to herself what such an.',NULL,'reserved','2025-06-10 10:38:41','2025-06-10 10:38:41'),(118,29,'GTPI1HRYYDLZ','Prof. Sunny Kerluke II','mmills@rodriguez.info','0495347674','Fainting in Coils.\' \'What was THAT like?\' said Alice. \'Call it what you like,\' said the King. \'I.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(119,30,'GNXA2DDFLSQL','Flo Brekke','sonya.mosciski@stehr.com','0203552996','CHAPTER X. The Lobster Quadrille The Mock Turtle said with a knife, it usually bleeds; and she.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(120,30,'VWMKGVLF1FQL','Estel Flatley','rita.mcclure@thompson.com','0844469241','She went in search of her or of anything else. CHAPTER V. Advice from a bottle marked \'poison,\' it.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(121,30,'RD6FE3X4YS4V','Mrs. Alison Monahan','oral79@gmail.com','0383077671','I shall fall right THROUGH the earth! How funny it\'ll seem, sending presents to one\'s own feet!.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(122,30,'XLM0VYXLZW72','Randy Gulgowski','vgaylord@yahoo.com','0833934178','Gryphon, \'you first form into a butterfly, I should like it very nice, (it had, in fact, a sort of.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(123,30,'6BKIMUO0FC5Z','Luigi Kris','jaeden52@lesch.com','0083127185','Let me think: was I the same year for such a subject! Our family always HATED cats: nasty, low.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(124,30,'X9GVM6DS1JKJ','Jarvis West','eldora.koss@yahoo.com','0853484716','I look like one, but the three gardeners who were lying round the hall, but they were gardeners.',NULL,'reserved','2025-06-10 10:38:41','2025-06-10 10:38:41'),(125,31,'JNLG16NCVAIU','Candida Kautzer','heaven.okon@reinger.com','0388240495','At last the Dodo solemnly presented the thimble, looking as solemn as she could, \'If you can\'t.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(126,31,'UNUPEKJQEHQJ','Mrs. Blanca Hoppe','zboncak.crawford@hotmail.com','0534084305','Said the mouse to the law, And argued each case with MINE,\' said the Duchess: \'what a clear way.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(127,32,'VOUCWTU6BFUY','Lindsay Thompson','kparker@hotmail.com','0320934303','Mary Ann!\' said the Caterpillar. \'I\'m afraid I\'ve offended it again!\' For the Mouse had changed.',NULL,'pending','2025-06-10 10:38:41','2025-06-10 10:38:41'),(128,32,'SYPXWZELGIAQ','Mrs. Lysanne Bosco','emely78@hotmail.com','0386056812','I can\'t get out again. The rabbit-hole went straight on like a star-fish,\' thought Alice. \'I\'ve.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(129,32,'LCZUIQGNOM18','Retta Lind','michaela71@spencer.info','0184259430','King added in a melancholy tone. \'Nobody seems to grin, How neatly spread his claws, And welcome.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(130,32,'KRUFMQF8BIFL','Ms. Eleanore Johnston','minnie.denesik@collins.com','0907667964','So you see, Alice had not noticed before, and behind them a railway station.) However, she soon.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(131,32,'GSQMKNP28DVQ','Silas West','ahowe@crist.info','0982732272','Gryphon. \'They can\'t have anything to say, she simply bowed, and took the cauldron of soup off the.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(132,33,'30SDNKCIDNK4','Dr. Noemie Kunde II','twila.krajcik@yahoo.com','0535251851','All the time he had never done such a curious feeling!\' said Alice; \'I might as well wait, as she.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(133,33,'JTT4APKKQY8Q','Miss Dortha Gulgowski','vtoy@schamberger.net','0198353073','The Frog-Footman repeated, in the book,\' said the Duchess; \'and most things twinkled after.',NULL,'reserved','2025-06-10 10:38:41','2025-06-10 10:38:41'),(134,33,'HTBYPLGCAEVE','Jamarcus Armstrong','erling.tillman@gmail.com','0520747406','King triumphantly, pointing to the other, looking uneasily at the cook, and a Canary called out.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(135,33,'RP2FIE2NQJBU','Miss Lyda Gleason DVM','rose.leffler@gmail.com','0498868321','So Alice got up this morning? I almost wish I\'d gone to see the earth takes twenty-four hours to.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(136,34,'X4XVSTIY48OR','Rick Block','tara50@yahoo.com','0476531875','But, now that I\'m perfectly sure I have none, Why, I haven\'t had a VERY unpleasant state of mind.',NULL,'refunded','2025-06-10 10:38:41','2025-06-10 10:38:41'),(137,34,'HTADG9U7NUZ8','Hardy Torp','goyette.adelle@mitchell.com','0506347752','The jury all looked so good, that it was talking in his throat,\' said the King had said that day.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(138,34,'XFQR47OXCHTN','Collin Ullrich','estamm@schoen.com','0885015026','Caterpillar. Alice folded her hands, and she tried to get through the wood. \'It\'s the first.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(139,34,'2WLOCNEZBRZD','Payton Hagenes Sr.','mbernier@yahoo.com','0112110400','Two. Two began in a great thistle, to keep herself from being run over; and the shrill voice of.',NULL,'refunded','2025-06-10 10:38:41','2025-06-10 10:38:41'),(140,35,'8GGGCHABDL6N','Bailey Schulist','meghan18@runte.com','0373499316','Wonderland, though she knew that it signifies much,\' she said to the general conclusion, that.',NULL,'refunded','2025-06-10 10:38:41','2025-06-10 10:38:41'),(141,35,'YZDBHI5C6SPW','Oda Wuckert','clabadie@hotmail.com','0021986742','The Rabbit started violently, dropped the white kid gloves, and she felt sure she would gather.',NULL,'reserved','2025-06-10 10:38:41','2025-06-10 10:38:41'),(142,35,'PFEXLSHRDTQF','Virginie Wilderman','bhoppe@dibbert.com','0304611651','While the Panther were sharing a pie--\' [later editions continued as follows When the pie was all.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(143,35,'GMCGPPQHFIQG','Miss Queen Deckow','trevor53@feeney.biz','0343327412','I chose,\' the Duchess sang the second time round, she came up to the conclusion that it was empty.',NULL,'reserved','2025-06-10 10:38:41','2025-06-10 10:38:41'),(144,36,'KPEUPUI47REQ','Hilma Bartell','kuhn.devan@fadel.net','0313195129','Tortoise, if he thought it over here,\' said the Caterpillar. \'I\'m afraid I am, sir,\' said Alice.',NULL,'pending','2025-06-10 10:38:41','2025-06-10 10:38:41'),(145,36,'O4ZGNBTMNQ7E','Rosemary Rosenbaum','fkreiger@hotmail.com','0485834574','Queen in front of them, with her head on her spectacles, and began smoking again. This time there.',NULL,'refunded','2025-06-10 10:38:41','2025-06-10 10:38:41'),(146,36,'ZZV0JWGMSSNI','Merl Flatley','mbruen@mohr.com','0259773485','Alice, \'because I\'m not myself, you see.\' \'I don\'t quite understand you,\' she said, as politely as.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(147,36,'M7GCFBQV6HJN','Nathanial Smith Sr.','wheathcote@bechtelar.com','0986029057','I should think it would be so stingy about it, you know.\' It was, no doubt: only Alice did not.',NULL,'pending','2025-06-10 10:38:41','2025-06-10 10:38:41'),(148,37,'BDVVD4XYACYW','Evalyn Goyette','lina.dubuque@yahoo.com','0957490494','And the muscular strength, which it gave to my right size: the next witness!\' said the Queen.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(149,37,'EZQPS7AW6NIN','Nelson Conn','june.huels@yahoo.com','0940393529','King; and as it was neither more nor less than no time to be beheaded!\' \'What for?\' said the.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(150,37,'92FZYCZZIGVF','Shaun Kris','alexandrine35@yahoo.com','0375097261','IT. It\'s HIM.\' \'I don\'t like them!\' When the procession came opposite to Alice, and she was.',NULL,'checked_in','2025-06-10 10:38:41','2025-06-10 10:38:41'),(151,37,'DROSPRJ99JLJ','Neva Swift','chasity53@gmail.com','0286692841','Gryphon, the squeaking of the jurymen. \'It isn\'t directed at all,\' said the Gryphon, with a.',NULL,'cancelled','2025-06-10 10:38:41','2025-06-10 10:38:41'),(152,38,'WF0VOYLANX7W','Lisette Fritsch','ayden38@daugherty.com','0246941665','Queen! The Queen!\' and the poor little thing was to find that she had sat down at them, and then.',NULL,'purchased','2025-06-10 10:38:41','2025-06-10 10:38:41'),(153,38,'FJ9V3AVTNJ6K','Lavinia Kutch','joaquin41@yahoo.com','0953876132','Pool of Tears \'Curiouser and curiouser!\' cried Alice in a low, timid voice, \'If you knew Time as.',NULL,'transferred','2025-06-10 10:38:41','2025-06-10 10:38:41'),(154,39,'XSGEFHG2J2TR','Prof. Timothy Sauer','nicolas.jairo@hotmail.com','0997105430','BEST butter, you know.\' \'And what an ignorant little girl she\'ll think me at home! Why, I haven\'t.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(155,39,'C98VZ7AK4JCU','Jaquelin Watsica','walsh.taryn@feeney.com','0486086096','Hatter: and in his note-book, cackled out \'Silence!\' and read out from his book, \'Rule Forty-two.',NULL,'transferred','2025-06-10 10:38:42','2025-06-10 10:38:42'),(156,39,'HMLNIYNQD5G0','Noelia Stokes','ucassin@yahoo.com','0766038604','Hatter added as an unusually large saucepan flew close by her. There was a good opportunity for.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(157,39,'S1MLLUEHGGIP','Al West','wcartwright@gmail.com','0014494112','However, she got to the conclusion that it was getting very sleepy; \'and they all moved off, and.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(158,39,'RJPTLGLLWBND','Prof. Leland Kovacek PhD','chandler.kilback@mraz.com','0449498518','Alice remained looking thoughtfully at the thought that it was neither more nor less than no time.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(159,40,'GI5C0PT5GPNF','Loyce Sporer','schaefer.raymundo@gmail.com','0377414601','CHAPTER XII. Alice\'s Evidence \'Here!\' cried Alice, quite forgetting in the distance. \'And yet what.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(160,40,'NSBWHTUEAZBG','Quentin Franecki','zdach@yahoo.com','0526803195','I was going to shrink any further: she felt very glad that it would be offended again. \'Mine is a.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(161,40,'411DS5NYDHO0','Troy Parker Jr.','deckow.troy@gmail.com','0963755965','And welcome little fishes in With gently smiling jaws!\' \'I\'m sure those are not attending!\' said.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(162,41,'0SNX7XLGSGFD','Murl Heaney','wdurgan@douglas.com','0928544933','Mouse with an M?\' said Alice. \'Why, you don\'t explain it is to find her in the prisoner\'s.',NULL,'reserved','2025-06-10 10:38:42','2025-06-10 10:38:42'),(163,41,'PG7TGT743IQL','Anabel Kiehn','kamryn.carter@yahoo.com','0787364819','Mouse, do you like the largest telescope that ever was! Good-bye, feet!\' (for when she had not.',NULL,'reserved','2025-06-10 10:38:42','2025-06-10 10:38:42'),(164,41,'MGJCUF35CKGR','Mrs. Treva Marvin','litzy.borer@murphy.com','0535346709','The Duchess took no notice of her or of anything else. CHAPTER V. Advice from a bottle marked.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(165,41,'N2KAMBG4FDDG','Julie Graham','heathcote.carmelo@windler.com','0195892952','Dormouse\'s place, and Alice joined the procession, wondering very much at first, perhaps,\' said.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(166,41,'BLJYRTOAEKS1','Suzanne Marvin','crempel@yahoo.com','0767287214','The Knave of Hearts, he stole those tarts, And took them quite away!\' \'Consider your verdict,\' the.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(167,42,'S9JBDKI4YHYZ','Prof. Mohammad Gerhold','rodriguez.katrina@gmail.com','0476313875','VERY long claws and a crash of broken glass. \'What a curious appearance in the morning, just time.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(168,42,'WHFTM1Y0YYRQ','Chauncey Reilly','kattie.crona@kuhic.com','0617357000','March Hare meekly replied. \'Yes, but I think that proved it at all; however, she again heard a.',NULL,'transferred','2025-06-10 10:38:42','2025-06-10 10:38:42'),(169,42,'G2L0QNUQECVL','Sheila Rippin','ekemmer@ritchie.com','0350446879','I should think!\' (Dinah was the King; and the words \'EAT ME\' were beautifully marked in currants.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(170,42,'1TXBBVWBQ6SM','Celestine Howe','okon.mitchel@gmail.com','0782262406','I am so VERY wide, but she could for sneezing. There was a dead silence. Alice noticed with some.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(171,42,'BQPU82LOLPXN','Dr. Golden Greenholt II','tratke@ondricka.com','0622392773','Alice could only see her. She is such a wretched height to be.\' \'It is a very curious to know what.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(172,43,'LOPHMYSM1HRL','Mrs. Everette Littel','robbie88@yahoo.com','0244683532','Queen shouted at the Hatter, it woke up again as quickly as she ran. \'How surprised he\'ll be when.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(173,43,'VA48XWOQIEKJ','Dave Cummerata','samir24@hotmail.com','0281790035','Alice, \'when one wasn\'t always growing larger and smaller, and being so many out-of-the-way things.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(174,43,'MIHXPGKYQAAM','Obie Macejkovic','jaskolski.jada@hotmail.com','0714597999','Duchess was VERY ugly; and secondly, because she was considering in her hand, and made believe to.',NULL,'transferred','2025-06-10 10:38:42','2025-06-10 10:38:42'),(175,43,'BANTYOFYBEBW','Golda Kilback','schinner.justus@larkin.com','0105381552','Very soon the Rabbit asked. \'No, I give it up,\' Alice replied: \'what\'s the answer?\' \'I haven\'t the.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(176,44,'O47BJDE23HQX','Willy Wisozk','wava99@hotmail.com','0400720938','I know?\' said Alice, as she picked up a little of the trees had a VERY turn-up nose, much more.',NULL,'transferred','2025-06-10 10:38:42','2025-06-10 10:38:42'),(177,44,'0L1NRBEODYCC','Zechariah Cruickshank','reichel.manuela@zemlak.com','0392191940','King was the cat.) \'I hope they\'ll remember her saucer of milk at tea-time. Dinah my dear! Let.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(178,44,'GUFMXTF2QTHF','Renee Dickens','dannie75@yahoo.com','0634502951','I know?\' said Alice, who was reading the list of singers. \'You may go,\' said the Mock Turtle, \'but.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(179,44,'IYV8KYYBQC5Y','Tyler Sporer V','bianka.wyman@kirlin.com','0927571069','Alice was so much at this, she looked back once or twice, and shook itself. Then it got down off.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(180,45,'MDQYSJHUIM2V','Kallie Lakin','ronny15@borer.biz','0760879632','I wonder?\' And here poor Alice in a hoarse growl, \'the world would go anywhere without a cat! It\'s.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(181,45,'RLKWNPRB0IEF','Prof. Jennifer Kreiger Jr.','wisoky.ari@kiehn.com','0579728584','I wonder if I\'ve kept her waiting!\' Alice felt so desperate that she was small enough to try the.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(182,46,'JAEOC9OFHC7S','Judah Pacocha','mosciski.dustin@thompson.com','0567879986','I\'ve kept her waiting!\' Alice felt a little startled by seeing the Cheshire Cat sitting on the end.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(183,46,'CZ3V5RIVAR4M','Fleta Fahey','janae.roob@yahoo.com','0094179138','I know I do!\' said Alice more boldly: \'you know you\'re growing too.\' \'Yes, but I THINK I can creep.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(184,46,'NOBTWPGPYMLD','Bernadine Kohler','tomas.spinka@treutel.info','0676331708','Dormouse, and repeated her question. \'Why did they live on?\' said Alice, \'and if it please your.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(185,47,'MB485X1UDP7G','Letitia Hayes PhD','wgreen@yahoo.com','0302445036','Let me think: was I the same as the hall was very glad to find her in such a noise inside, no one.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(186,47,'HQDNXCZPYHCL','Betsy Bailey II','schaefer.kadin@yahoo.com','0803107498','Alice said to herself how she would catch a bat, and that\'s all the creatures order one about, and.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(187,47,'0IKS8XGK45JK','Aida Eichmann','wuckert.katelynn@goyette.net','0751717241','Majesty,\' said the Hatter. \'You MUST remember,\' remarked the King, \'and don\'t be particular--Here.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(188,47,'T9871LTCFEB7','Cary Kshlerin','tcronin@labadie.com','0848892829','Alice, \'as all the first position in dancing.\' Alice said; \'there\'s a large kitchen, which was.',NULL,'transferred','2025-06-10 10:38:42','2025-06-10 10:38:42'),(189,48,'XSEMFFBPONGN','Jadyn Schowalter','jacobs.arnold@hotmail.com','0343993359','I to get in at the window.\' \'THAT you won\'t\' thought Alice, \'they\'re sure to make personal.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(190,48,'1LQRDWEKYPBN','Mitchell Aufderhar','oauer@hotmail.com','0891931198','King: \'leave out that part.\' \'Well, at any rate: go and get ready to sink into the loveliest.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42'),(191,48,'KYME3BI111F5','Judy Roberts','astrid.green@schroeder.com','0021984169','Hatter: and in another moment it was addressed to the Dormouse, not choosing to notice this last.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(192,48,'7HHFKAGM3HK7','Mrs. Rachael Crooks II','erdman.clark@anderson.com','0117323526','She gave me a pair of gloves and the other arm curled round her at the March Hare: she thought it.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(193,48,'TP091ICGZKRQ','Prof. Ed Hauck DVM','fiona93@yahoo.com','0342788859','Alice for some time without hearing anything more: at last she spread out her hand in her life.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(194,49,'TP50WI9JHNOX','Werner Kuhlman','runolfsson.tracy@beer.info','0950701391','RED rose-tree, and we put a white one in by mistake; and if it began ordering people about like.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(195,49,'DB2PKOMDR2AO','Greg Schultz','jflatley@schumm.info','0440189722','THEIR eyes bright and eager with many a strange tale, perhaps even with the name \'W. RABBIT\'.',NULL,'reserved','2025-06-10 10:38:42','2025-06-10 10:38:42'),(196,49,'MQTOEWSVICTO','Mr. Ariel Nikolaus','ada33@gottlieb.org','0096095608','It was the White Rabbit. She was looking about for them, and was just saying to herself what such.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(197,49,'KZHLKK2DQRCC','Mr. Felton Hills','efrain29@eichmann.com','0648435964','As soon as she could guess, she was out of the trial.\' \'Stupid things!\' Alice began in a large.',NULL,'cancelled','2025-06-10 10:38:42','2025-06-10 10:38:42'),(198,49,'7K3P7TUTEKWA','Katherine Hill','willms.raven@yahoo.com','0534797624','White Rabbit, jumping up and picking the daisies, when suddenly a footman in livery, with a deep.',NULL,'refunded','2025-06-10 10:38:42','2025-06-10 10:38:42'),(199,50,'MQ45TT4XGYL6','Marley Roberts','moen.katrine@yahoo.com','0515063015','As she said to herself as she added, to herself, \'I wish the creatures argue. It\'s enough to try.',NULL,'checked_in','2025-06-10 10:38:42','2025-06-10 10:38:42'),(200,50,'PNY2DHDKBXKL','Savanna Abbott','dooley.abdullah@gmail.com','0868771663','Her first idea was that you have of putting things!\' \'It\'s a pun!\' the King said, for about the.',NULL,'pending','2025-06-10 10:38:42','2025-06-10 10:38:42'),(201,50,'XGDCYUNTAZVW','Vergie King','salma.powlowski@gmail.com','0760985622','Queen! The Queen!\' and the second thing is to give the prizes?\' quite a chorus of voices asked.',NULL,'purchased','2025-06-10 10:38:42','2025-06-10 10:38:42');
/*!40000 ALTER TABLE `eb_tickets` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `failed_jobs`
--

DROP TABLE IF EXISTS `failed_jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `failed_jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `connection` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `queue` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `exception` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `failed_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `failed_jobs_uuid_unique` (`uuid`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `failed_jobs`
--

LOCK TABLES `failed_jobs` WRITE;
/*!40000 ALTER TABLE `failed_jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `failed_jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories`
--

DROP TABLE IF EXISTS `faq_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories`
--

LOCK TABLES `faq_categories` WRITE;
/*!40000 ALTER TABLE `faq_categories` DISABLE KEYS */;
INSERT INTO `faq_categories` VALUES (1,'Event information',0,'published','2025-06-10 10:38:20','2025-06-10 10:38:20','Aspernatur accusamus qui asperiores consequatur harum. Accusantium et veniam magni saepe.'),(2,'Registration &amp; Tickets',0,'published','2025-06-10 10:38:20','2025-06-10 10:38:20','Aut dolores debitis cumque quae. Dolor illo rerum itaque voluptas. Magnam autem eaque consequatur.'),(3,'Event Experience',0,'published','2025-06-10 10:38:20','2025-06-10 10:38:20','Assumenda voluptatem ratione aut. Unde eaque maxime saepe dolores.'),(4,'Speaker &amp; Sessions',0,'published','2025-06-10 10:38:20','2025-06-10 10:38:20','Corrupti et et ea architecto. Laborum ut unde tempora.');
/*!40000 ALTER TABLE `faq_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faq_categories_translations`
--

DROP TABLE IF EXISTS `faq_categories_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faq_categories_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faq_categories_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`faq_categories_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faq_categories_translations`
--

LOCK TABLES `faq_categories_translations` WRITE;
/*!40000 ALTER TABLE `faq_categories_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faq_categories_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs`
--

DROP TABLE IF EXISTS `faqs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `question` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `answer` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `category_id` bigint unsigned NOT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs`
--

LOCK TABLES `faqs` WRITE;
/*!40000 ALTER TABLE `faqs` DISABLE KEYS */;
INSERT INTO `faqs` VALUES (1,'Repudiandae unde omnis ad.','Vel porro non quod officia quis soluta officia eum rerum laborum ut ut suscipit vitae odio ut dolorem ipsa sunt modi modi repellat atque ut rerum commodi voluptates totam culpa possimus sit itaque dolor.',3,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(2,'Nisi omnis est neque autem aliquid cum.','Unde cumque quia sint repellat ipsum iusto deleniti ullam est et deserunt sunt aliquam nulla quis est architecto sunt magni vel quas alias repudiandae voluptatem et maiores vel odio.',3,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(3,'Doloribus aut perferendis quasi in enim omnis.','Sint nostrum necessitatibus explicabo qui aliquid velit aspernatur enim fuga labore libero numquam eius consequatur ut minus fuga corrupti saepe aut voluptates minus optio in et velit dolores illum ullam eligendi aut.',2,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(4,'Deleniti autem aperiam fuga quia.','Modi tempore ab aut dolores quibusdam id quo quidem et itaque qui ea modi est soluta nihil vero nulla aut possimus.',2,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(5,'Optio atque tenetur dolore molestias qui.','Quos ab rerum qui maiores neque consequatur ut sunt odio quia voluptates doloribus rem sint neque soluta harum reprehenderit quia consequuntur ratione qui sed qui blanditiis porro et illum ut omnis aspernatur inventore non illo asperiores esse eum rerum et aliquam sed.',2,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(6,'Voluptate voluptas minus id.','Consequatur architecto aut qui nobis aut impedit qui aut in optio nam autem nobis dicta ut qui laudantium ducimus vitae rem ad sequi voluptate illo ut laboriosam autem alias nisi dolorem est veritatis qui omnis facilis nisi id.',4,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(7,'Labore rem quae aut incidunt.','Eaque rem quod ut quaerat doloribus a qui et laboriosam doloribus molestiae velit ea enim ipsum quis rerum ea sit sed molestiae neque soluta reprehenderit quibusdam omnis iusto suscipit culpa voluptatem.',1,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(8,'Dolorem velit qui quisquam magni enim rem.','Nihil molestiae incidunt et ut non eos nesciunt et voluptatibus voluptatem laboriosam ipsa aut tempora quidem aut est ipsum et et sint et sequi ullam voluptatum dolorem placeat in commodi ut eum qui eos distinctio suscipit harum quisquam illo.',2,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(9,'Quam id quos dignissimos.','Porro enim qui ut dignissimos rerum sed expedita modi corporis et ipsum ab quis qui ipsum aliquid perferendis aut provident corrupti unde neque et eligendi et tenetur ea incidunt.',4,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(10,'Voluptatem voluptatem earum esse.','Et rem earum et deleniti ipsam fugiat qui quod qui ullam ex aperiam consequatur nesciunt fugiat aliquid est dolorem eveniet labore optio dolores consequuntur et est iure quia minus quia voluptate iusto rerum minima culpa error velit eveniet culpa numquam quas nostrum.',4,'published','2025-06-10 10:38:20','2025-06-10 10:38:20'),(11,'Nam officia asperiores sed.','Odit facere enim sapiente in illum mollitia minima quis aliquam ut vitae eum laboriosam sit nam dolor rerum dolore sit est quis inventore.',2,'published','2025-06-10 10:38:20','2025-06-10 10:38:20');
/*!40000 ALTER TABLE `faqs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `faqs_translations`
--

DROP TABLE IF EXISTS `faqs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `faqs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `faqs_id` bigint unsigned NOT NULL,
  `question` text COLLATE utf8mb4_unicode_ci,
  `answer` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`faqs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `faqs_translations`
--

LOCK TABLES `faqs_translations` WRITE;
/*!40000 ALTER TABLE `faqs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `faqs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries`
--

DROP TABLE IF EXISTS `galleries`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `order` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `galleries_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries`
--

LOCK TABLES `galleries` WRITE;
/*!40000 ALTER TABLE `galleries` DISABLE KEYS */;
INSERT INTO `galleries` VALUES (1,'Sunset','Expedita odit voluptates aut expedita vitae et. Unde sequi in odio voluptatem eius deleniti officia. Ad nobis id in quaerat impedit.',1,0,'main/news/6.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(2,'Ocean Views','Quibusdam omnis aliquid quia quia dolore. Unde eos eveniet consequatur culpa accusamus unde quo.',1,0,'main/news/7.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(3,'Adventure Time','Atque dolor sed qui. Expedita voluptas sit necessitatibus dolor ex repudiandae.',1,0,'main/news/8.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(4,'City Lights','Maxime reiciendis qui corporis itaque ex. Et enim cupiditate occaecati est. Vel dolore at animi sit.',1,0,'main/news/9.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(5,'Dreamscape','Quis laboriosam quam accusantium et. Mollitia asperiores vel sint. Adipisci vitae sit iste autem sit similique.',1,0,'main/news/10.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(6,'Enchanted Forest','Iste quaerat id quo et reiciendis. Amet fugiat sit incidunt consequatur. Et qui tempore quibusdam. Dignissimos aut mollitia nihil delectus et.',1,0,'main/news/11.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(7,'Golden Hour','Voluptas distinctio iste porro aut explicabo. Voluptas in occaecati quis perferendis sapiente excepturi beatae. Adipisci sunt et mollitia et.',0,0,'main/news/12.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(8,'Serenity','Ut saepe tempore omnis quo distinctio excepturi. Quos non nisi odio eos dolorem quae. Reiciendis eum aspernatur animi aliquid laborum et.',0,0,'main/news/13.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(9,'Eternal Beauty','Quia deserunt et dignissimos ut id. Quo minima sint qui laborum eaque. Vel omnis quod ipsa ipsam minus et non. Totam saepe optio quibusdam alias.',0,0,'main/news/14.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(10,'Moonlight Magic','Laboriosam cum assumenda aliquid nam quo. Recusandae cupiditate laudantium itaque illum tempora quam. Nemo et sapiente est exercitationem.',0,0,'main/news/15.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(11,'Starry Night','Sequi in velit laboriosam voluptate. Suscipit deserunt sint enim quae nihil blanditiis aut. Qui doloribus architecto iusto.',0,0,'main/news/16.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(12,'Hidden Gems','Error laborum et omnis harum. Illo facere aut odio harum assumenda. Error non veritatis ut nesciunt quis veniam rem.',0,0,'main/news/17.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(13,'Tranquil Waters','Laborum at reiciendis voluptatem. Sunt sed libero quaerat est.',0,0,'main/news/18.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(14,'Urban Escape','Minus pariatur aliquam nihil est. Officia nam velit ut inventore rerum deserunt. Consequatur sapiente quia sed quo. Reiciendis illo rem ut id.',0,0,'main/news/19.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53'),(15,'Twilight Zone','Tempora et consequatur officiis ut iure. Alias velit sequi amet illo totam. Tempora in totam amet ut cumque. Consectetur aut sit rerum et.',0,0,'main/news/20.jpg',NULL,'published','2025-06-10 10:37:53','2025-06-10 10:37:53');
/*!40000 ALTER TABLE `galleries` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `galleries_translations`
--

DROP TABLE IF EXISTS `galleries_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `galleries_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `galleries_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`galleries_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `galleries_translations`
--

LOCK TABLES `galleries_translations` WRITE;
/*!40000 ALTER TABLE `galleries_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `galleries_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta`
--

DROP TABLE IF EXISTS `gallery_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `images` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `gallery_meta_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta`
--

LOCK TABLES `gallery_meta` WRITE;
/*!40000 ALTER TABLE `gallery_meta` DISABLE KEYS */;
INSERT INTO `gallery_meta` VALUES (1,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',1,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(2,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',2,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(3,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',3,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(4,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',4,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(5,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',5,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(6,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',6,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(7,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',7,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(8,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',8,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(9,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',9,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(10,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',10,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(11,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',11,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(12,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',12,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(13,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',13,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(14,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',14,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53'),(15,'[{\"img\":\"main\\/news\\/1.jpg\",\"description\":\"Consequatur et alias voluptatum. Ipsum ipsam at voluptatem quia culpa. Et distinctio quasi sapiente culpa ducimus molestiae voluptas.\"},{\"img\":\"main\\/news\\/2.jpg\",\"description\":\"Deserunt ex aut dolores recusandae. Nostrum ut minima deleniti maxime tenetur. Dicta ipsam sed et dolor atque est. Ut tenetur sed odit fuga in.\"},{\"img\":\"main\\/news\\/3.jpg\",\"description\":\"Qui incidunt error adipisci distinctio quia placeat. Rem et excepturi quisquam et. Occaecati modi temporibus sit quo. Consequatur et quo sed.\"},{\"img\":\"main\\/news\\/4.jpg\",\"description\":\"Assumenda quidem ut excepturi quos et animi. Quia laudantium similique minus ut eligendi vero. Quia consequatur eaque aut ut.\"},{\"img\":\"main\\/news\\/5.jpg\",\"description\":\"Non aut ea et iure voluptas. Esse aliquam sunt doloremque tempora est. Eos modi labore ut.\"},{\"img\":\"main\\/news\\/6.jpg\",\"description\":\"Deleniti corrupti iste molestiae saepe. Repudiandae placeat placeat ab molestias minus.\"},{\"img\":\"main\\/news\\/7.jpg\",\"description\":\"Ducimus voluptates iste qui id minus sit. Ut voluptate nulla est fugiat nihil atque ex. Est illo odio adipisci.\"},{\"img\":\"main\\/news\\/8.jpg\",\"description\":\"Possimus magnam debitis voluptatem et accusamus non. Eum vel tenetur sapiente quo vel commodi. Eos beatae ipsam porro quas eum impedit perferendis.\"},{\"img\":\"main\\/news\\/9.jpg\",\"description\":\"Aperiam perspiciatis dignissimos saepe nostrum aut soluta magnam. Minus ut mollitia nihil vel.\"},{\"img\":\"main\\/news\\/10.jpg\",\"description\":\"Itaque sint consequatur ullam est ut. Sequi natus molestiae eaque enim et doloribus ipsam.\"},{\"img\":\"main\\/news\\/11.jpg\",\"description\":\"Voluptas exercitationem in saepe. Et sint maiores assumenda quibusdam modi sint ullam est. Possimus qui doloribus voluptatem repudiandae quis.\"},{\"img\":\"main\\/news\\/12.jpg\",\"description\":\"Dolores voluptates ullam numquam necessitatibus consequatur. Cumque rerum sunt impedit autem.\"},{\"img\":\"main\\/news\\/13.jpg\",\"description\":\"Praesentium minus similique et. Atque ullam et quos non incidunt.\"},{\"img\":\"main\\/news\\/14.jpg\",\"description\":\"Ducimus sit aperiam ullam voluptatum. Vitae exercitationem aut necessitatibus. Repellat aliquid pariatur rerum in vel qui.\"},{\"img\":\"main\\/news\\/15.jpg\",\"description\":\"Ipsa voluptas ratione officia natus officia dignissimos. Ea adipisci dolores qui tempora provident. Eum quas aut fugiat et sunt qui unde.\"},{\"img\":\"main\\/news\\/16.jpg\",\"description\":\"Esse qui error assumenda et. Ab ullam aut id quibusdam et.\"},{\"img\":\"main\\/news\\/17.jpg\",\"description\":\"Harum consequuntur aspernatur aut. Occaecati suscipit nemo a. Molestiae voluptatem aut culpa et aut rerum sit.\"},{\"img\":\"main\\/news\\/18.jpg\",\"description\":\"Sit accusamus sunt labore voluptatem hic qui. Quos omnis omnis ullam officiis quia quo in. Voluptatum aut ut dolorum est.\"},{\"img\":\"main\\/news\\/19.jpg\",\"description\":\"Aperiam assumenda omnis id saepe tenetur. Est nam recusandae fuga ut nobis. Eum omnis consequatur dolores vel. Dolorem quasi non eius aut.\"},{\"img\":\"main\\/news\\/20.jpg\",\"description\":\"Ratione ut recusandae repellendus maiores et earum recusandae. Quisquam aut corporis aut autem eos quaerat qui.\"}]',15,'Botble\\Gallery\\Models\\Gallery','2025-06-10 10:37:53','2025-06-10 10:37:53');
/*!40000 ALTER TABLE `gallery_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `gallery_meta_translations`
--

DROP TABLE IF EXISTS `gallery_meta_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `gallery_meta_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gallery_meta_id` bigint unsigned NOT NULL,
  `images` text COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`gallery_meta_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `gallery_meta_translations`
--

LOCK TABLES `gallery_meta_translations` WRITE;
/*!40000 ALTER TABLE `gallery_meta_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `gallery_meta_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `jobs`
--

DROP TABLE IF EXISTS `jobs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `jobs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `queue` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `attempts` tinyint unsigned NOT NULL,
  `reserved_at` int unsigned DEFAULT NULL,
  `available_at` int unsigned NOT NULL,
  `created_at` int unsigned NOT NULL,
  PRIMARY KEY (`id`),
  KEY `jobs_queue_index` (`queue`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `jobs`
--

LOCK TABLES `jobs` WRITE;
/*!40000 ALTER TABLE `jobs` DISABLE KEYS */;
/*!40000 ALTER TABLE `jobs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `language_meta`
--

DROP TABLE IF EXISTS `language_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `language_meta` (
  `lang_meta_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_meta_code` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_meta_origin` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`lang_meta_id`),
  KEY `language_meta_reference_id_index` (`reference_id`),
  KEY `meta_code_index` (`lang_meta_code`),
  KEY `meta_origin_index` (`lang_meta_origin`),
  KEY `meta_reference_type_index` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `language_meta`
--

LOCK TABLES `language_meta` WRITE;
/*!40000 ALTER TABLE `language_meta` DISABLE KEYS */;
INSERT INTO `language_meta` VALUES (1,'en_US','1c1c9c6021eaba26ff55ef161a587b9b',1,'Botble\\Menu\\Models\\MenuLocation'),(2,'en_US','6352fae10b166b491e27891a23cd2c53',1,'Botble\\Menu\\Models\\Menu'),(3,'en_US','489c294eddd71525a784960a8e6a1731',1,'Botble\\SimpleSlider\\Models\\SimpleSlider');
/*!40000 ALTER TABLE `language_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `languages`
--

DROP TABLE IF EXISTS `languages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `languages` (
  `lang_id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `lang_name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_locale` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `lang_flag` varchar(20) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `lang_is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `lang_order` int NOT NULL DEFAULT '0',
  `lang_is_rtl` tinyint unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`lang_id`),
  KEY `lang_locale_index` (`lang_locale`),
  KEY `lang_code_index` (`lang_code`),
  KEY `lang_is_default_index` (`lang_is_default`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `languages`
--

LOCK TABLES `languages` WRITE;
/*!40000 ALTER TABLE `languages` DISABLE KEYS */;
INSERT INTO `languages` VALUES (1,'English','en','en_US','us',1,0,0);
/*!40000 ALTER TABLE `languages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_files`
--

DROP TABLE IF EXISTS `media_files`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_files` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alt` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `folder_id` bigint unsigned NOT NULL DEFAULT '0',
  `mime_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `size` int NOT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `options` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `visibility` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'public',
  PRIMARY KEY (`id`),
  KEY `media_files_user_id_index` (`user_id`),
  KEY `media_files_index` (`folder_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=156 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_files`
--

LOCK TABLES `media_files` WRITE;
/*!40000 ALTER TABLE `media_files` DISABLE KEYS */;
INSERT INTO `media_files` VALUES (32,0,'1','1',4,'image/png',1070,'main/testimonials/1.png','[]','2025-06-10 10:37:54','2025-06-10 10:37:54',NULL,'public'),(33,0,'2','2',4,'image/png',1070,'main/testimonials/2.png','[]','2025-06-10 10:37:54','2025-06-10 10:37:54',NULL,'public'),(34,0,'3','3',4,'image/png',1070,'main/testimonials/3.png','[]','2025-06-10 10:37:54','2025-06-10 10:37:54',NULL,'public'),(35,0,'4','4',4,'image/png',1070,'main/testimonials/4.png','[]','2025-06-10 10:37:54','2025-06-10 10:37:54',NULL,'public'),(36,0,'brand-img1','brand-img1',5,'image/png',922,'main/brands/brand-img1.png','[]','2025-06-10 10:37:55','2025-06-10 10:37:55',NULL,'public'),(37,0,'brand-img2','brand-img2',5,'image/png',922,'main/brands/brand-img2.png','[]','2025-06-10 10:37:55','2025-06-10 10:37:55',NULL,'public'),(38,0,'brand-img3','brand-img3',5,'image/png',922,'main/brands/brand-img3.png','[]','2025-06-10 10:37:55','2025-06-10 10:37:55',NULL,'public'),(39,0,'brand-img4','brand-img4',5,'image/png',922,'main/brands/brand-img4.png','[]','2025-06-10 10:37:56','2025-06-10 10:37:56',NULL,'public'),(40,0,'brand-img5','brand-img5',5,'image/png',922,'main/brands/brand-img5.png','[]','2025-06-10 10:37:56','2025-06-10 10:37:56',NULL,'public'),(41,0,'brand-img6','brand-img6',5,'image/png',922,'main/brands/brand-img6.png','[]','2025-06-10 10:37:56','2025-06-10 10:37:56',NULL,'public'),(42,0,'brand-img7','brand-img7',5,'image/png',922,'main/brands/brand-img7.png','[]','2025-06-10 10:37:57','2025-06-10 10:37:57',NULL,'public'),(43,0,'brand-img8','brand-img8',5,'image/png',922,'main/brands/brand-img8.png','[]','2025-06-10 10:37:57','2025-06-10 10:37:57',NULL,'public'),(44,0,'1','1',6,'image/png',2977,'main/backgrounds/1.png','[]','2025-06-10 10:37:57','2025-06-10 10:37:57',NULL,'public'),(45,0,'2','2',6,'image/png',116016,'main/backgrounds/2.png','[]','2025-06-10 10:37:58','2025-06-10 10:37:58',NULL,'public'),(46,0,'header-bg4','header-bg4',6,'image/png',879258,'main/backgrounds/header-bg4.png','[]','2025-06-10 10:37:58','2025-06-10 10:37:58',NULL,'public'),(47,0,'hero-banner-bg','hero-banner-bg',6,'image/png',483385,'main/backgrounds/hero-banner-bg.png','[]','2025-06-10 10:37:59','2025-06-10 10:37:59',NULL,'public'),(48,0,'image-1','image-1',6,'image/jpeg',2353175,'main/backgrounds/image-1.jpg','[]','2025-06-10 10:37:59','2025-06-10 10:37:59',NULL,'public'),(49,0,'newsletter-bg','newsletter-bg',6,'image/jpeg',132982,'main/backgrounds/newsletter-bg.jpg','[]','2025-06-10 10:38:01','2025-06-10 10:38:01',NULL,'public'),(50,0,'pricing-name','pricing-name',6,'image/png',116016,'main/backgrounds/pricing-name.png','[]','2025-06-10 10:38:01','2025-06-10 10:38:01',NULL,'public'),(51,0,'speakers-bg','speakers-bg',6,'image/png',135272,'main/backgrounds/speakers-bg.png','[]','2025-06-10 10:38:01','2025-06-10 10:38:01',NULL,'public'),(52,0,'balloons','balloons',7,'image/png',25074,'main/icons/balloons.png','[]','2025-06-10 10:38:02','2025-06-10 10:38:02',NULL,'public'),(53,0,'calendar','calendar',7,'image/png',15903,'main/icons/calendar.png','[]','2025-06-10 10:38:02','2025-06-10 10:38:02',NULL,'public'),(54,0,'clock','clock',7,'image/png',31087,'main/icons/clock.png','[]','2025-06-10 10:38:02','2025-06-10 10:38:02',NULL,'public'),(55,0,'coding','coding',7,'image/png',19675,'main/icons/coding.png','[]','2025-06-10 10:38:02','2025-06-10 10:38:02',NULL,'public'),(56,0,'idea','idea',7,'image/png',18793,'main/icons/idea.png','[]','2025-06-10 10:38:02','2025-06-10 10:38:02',NULL,'public'),(57,0,'instagram-icon','instagram-icon',7,'image/png',606,'main/icons/instagram-icon.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(58,0,'location-icon','location-icon',7,'image/png',835,'main/icons/location-icon.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(59,0,'location','location',7,'image/png',22189,'main/icons/location.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(60,0,'mail-icon','mail-icon',7,'image/png',647,'main/icons/mail-icon.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(61,0,'menu','menu',7,'image/png',11155,'main/icons/menu.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(62,0,'microphone','microphone',7,'image/png',22211,'main/icons/microphone.png','[]','2025-06-10 10:38:03','2025-06-10 10:38:03',NULL,'public'),(63,0,'phone-icon','phone-icon',7,'image/png',982,'main/icons/phone-icon.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(64,0,'search','search',7,'image/png',23517,'main/icons/search.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(65,0,'speaker','speaker',7,'image/png',16059,'main/icons/speaker.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(66,0,'ticket','ticket',7,'image/png',18246,'main/icons/ticket.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(67,0,'user','user',7,'image/png',16365,'main/icons/user.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(68,0,'view','view',7,'image/png',18213,'main/icons/view.png','[]','2025-06-10 10:38:04','2025-06-10 10:38:04',NULL,'public'),(69,0,'workshop','workshop',7,'image/png',25532,'main/icons/workshop.png','[]','2025-06-10 10:38:05','2025-06-10 10:38:05',NULL,'public'),(70,0,'1','1',3,'image/jpeg',33268,'main/news/1.jpg','[]','2025-06-10 10:38:05','2025-06-10 10:38:05',NULL,'public'),(71,0,'10','10',3,'image/jpeg',33268,'main/news/10.jpg','[]','2025-06-10 10:38:05','2025-06-10 10:38:05',NULL,'public'),(72,0,'11','11',3,'image/jpeg',33268,'main/news/11.jpg','[]','2025-06-10 10:38:06','2025-06-10 10:38:06',NULL,'public'),(73,0,'12','12',3,'image/jpeg',33268,'main/news/12.jpg','[]','2025-06-10 10:38:06','2025-06-10 10:38:06',NULL,'public'),(74,0,'13','13',3,'image/jpeg',33268,'main/news/13.jpg','[]','2025-06-10 10:38:06','2025-06-10 10:38:06',NULL,'public'),(75,0,'14','14',3,'image/jpeg',33268,'main/news/14.jpg','[]','2025-06-10 10:38:07','2025-06-10 10:38:07',NULL,'public'),(76,0,'15','15',3,'image/jpeg',33268,'main/news/15.jpg','[]','2025-06-10 10:38:07','2025-06-10 10:38:07',NULL,'public'),(77,0,'16','16',3,'image/jpeg',33268,'main/news/16.jpg','[]','2025-06-10 10:38:07','2025-06-10 10:38:07',NULL,'public'),(78,0,'17','17',3,'image/jpeg',33268,'main/news/17.jpg','[]','2025-06-10 10:38:08','2025-06-10 10:38:08',NULL,'public'),(79,0,'18','18',3,'image/jpeg',33268,'main/news/18.jpg','[]','2025-06-10 10:38:08','2025-06-10 10:38:08',NULL,'public'),(80,0,'19','19',3,'image/jpeg',33268,'main/news/19.jpg','[]','2025-06-10 10:38:08','2025-06-10 10:38:08',NULL,'public'),(81,0,'2','2',3,'image/jpeg',33268,'main/news/2.jpg','[]','2025-06-10 10:38:09','2025-06-10 10:38:09',NULL,'public'),(82,0,'20','20',3,'image/jpeg',33268,'main/news/20.jpg','[]','2025-06-10 10:38:09','2025-06-10 10:38:09',NULL,'public'),(83,0,'3','3',3,'image/jpeg',33268,'main/news/3.jpg','[]','2025-06-10 10:38:09','2025-06-10 10:38:09',NULL,'public'),(84,0,'4','4',3,'image/jpeg',33268,'main/news/4.jpg','[]','2025-06-10 10:38:10','2025-06-10 10:38:10',NULL,'public'),(85,0,'5','5',3,'image/jpeg',33268,'main/news/5.jpg','[]','2025-06-10 10:38:10','2025-06-10 10:38:10',NULL,'public'),(86,0,'6','6',3,'image/jpeg',33268,'main/news/6.jpg','[]','2025-06-10 10:38:10','2025-06-10 10:38:10',NULL,'public'),(87,0,'7','7',3,'image/jpeg',33268,'main/news/7.jpg','[]','2025-06-10 10:38:11','2025-06-10 10:38:11',NULL,'public'),(88,0,'8','8',3,'image/jpeg',33268,'main/news/8.jpg','[]','2025-06-10 10:38:11','2025-06-10 10:38:11',NULL,'public'),(89,0,'9','9',3,'image/jpeg',33268,'main/news/9.jpg','[]','2025-06-10 10:38:11','2025-06-10 10:38:11',NULL,'public'),(90,0,'1','1',8,'image/jpeg',33268,'main/blogs/1.jpg','[]','2025-06-10 10:38:12','2025-06-10 10:38:12',NULL,'public'),(91,0,'10','10',8,'image/jpeg',33268,'main/blogs/10.jpg','[]','2025-06-10 10:38:12','2025-06-10 10:38:12',NULL,'public'),(92,0,'11','11',8,'image/jpeg',33268,'main/blogs/11.jpg','[]','2025-06-10 10:38:13','2025-06-10 10:38:13',NULL,'public'),(93,0,'12','12',8,'image/jpeg',33268,'main/blogs/12.jpg','[]','2025-06-10 10:38:13','2025-06-10 10:38:13',NULL,'public'),(94,0,'13','13',8,'image/jpeg',33268,'main/blogs/13.jpg','[]','2025-06-10 10:38:13','2025-06-10 10:38:13',NULL,'public'),(95,0,'14','14',8,'image/jpeg',33268,'main/blogs/14.jpg','[]','2025-06-10 10:38:14','2025-06-10 10:38:14',NULL,'public'),(96,0,'15','15',8,'image/jpeg',33268,'main/blogs/15.jpg','[]','2025-06-10 10:38:14','2025-06-10 10:38:14',NULL,'public'),(97,0,'16','16',8,'image/jpeg',33268,'main/blogs/16.jpg','[]','2025-06-10 10:38:14','2025-06-10 10:38:14',NULL,'public'),(98,0,'17','17',8,'image/jpeg',33268,'main/blogs/17.jpg','[]','2025-06-10 10:38:15','2025-06-10 10:38:15',NULL,'public'),(99,0,'18','18',8,'image/jpeg',33268,'main/blogs/18.jpg','[]','2025-06-10 10:38:15','2025-06-10 10:38:15',NULL,'public'),(100,0,'19','19',8,'image/jpeg',33268,'main/blogs/19.jpg','[]','2025-06-10 10:38:15','2025-06-10 10:38:15',NULL,'public'),(101,0,'2','2',8,'image/jpeg',33268,'main/blogs/2.jpg','[]','2025-06-10 10:38:16','2025-06-10 10:38:16',NULL,'public'),(102,0,'20','20',8,'image/jpeg',33268,'main/blogs/20.jpg','[]','2025-06-10 10:38:16','2025-06-10 10:38:16',NULL,'public'),(103,0,'3','3',8,'image/jpeg',33268,'main/blogs/3.jpg','[]','2025-06-10 10:38:16','2025-06-10 10:38:16',NULL,'public'),(104,0,'4','4',8,'image/jpeg',33268,'main/blogs/4.jpg','[]','2025-06-10 10:38:17','2025-06-10 10:38:17',NULL,'public'),(105,0,'5','5',8,'image/jpeg',33268,'main/blogs/5.jpg','[]','2025-06-10 10:38:17','2025-06-10 10:38:17',NULL,'public'),(106,0,'6','6',8,'image/jpeg',33268,'main/blogs/6.jpg','[]','2025-06-10 10:38:17','2025-06-10 10:38:17',NULL,'public'),(107,0,'7','7',8,'image/jpeg',33268,'main/blogs/7.jpg','[]','2025-06-10 10:38:18','2025-06-10 10:38:18',NULL,'public'),(108,0,'8','8',8,'image/jpeg',33268,'main/blogs/8.jpg','[]','2025-06-10 10:38:18','2025-06-10 10:38:18',NULL,'public'),(109,0,'9','9',8,'image/jpeg',33268,'main/blogs/9.jpg','[]','2025-06-10 10:38:19','2025-06-10 10:38:19',NULL,'public'),(110,0,'about-img1','about-img1',2,'image/png',7125,'main/general/about-img1.png','[]','2025-06-10 10:38:20','2025-06-10 10:38:20',NULL,'public'),(111,0,'about-img2','about-img2',2,'image/png',4665,'main/general/about-img2.png','[]','2025-06-10 10:38:20','2025-06-10 10:38:20',NULL,'public'),(112,0,'about-img3','about-img3',2,'image/png',4665,'main/general/about-img3.png','[]','2025-06-10 10:38:20','2025-06-10 10:38:20',NULL,'public'),(113,0,'contact-img-1','contact-img-1',2,'image/png',10689,'main/general/contact-img-1.png','[]','2025-06-10 10:38:21','2025-06-10 10:38:21',NULL,'public'),(114,0,'contact-img-2','contact-img-2',2,'image/png',13642,'main/general/contact-img-2.png','[]','2025-06-10 10:38:21','2025-06-10 10:38:21',NULL,'public'),(115,0,'favicon','favicon',2,'image/png',479,'main/general/favicon.png','[]','2025-06-10 10:38:21','2025-06-10 10:38:21',NULL,'public'),(116,0,'hero-banner-img','hero-banner-img',2,'image/png',30044,'main/general/hero-banner-img.png','[]','2025-06-10 10:38:21','2025-06-10 10:38:21',NULL,'public'),(117,0,'logo-light','logo-light',2,'image/png',812,'main/general/logo-light.png','[]','2025-06-10 10:38:21','2025-06-10 10:38:21',NULL,'public'),(118,0,'logo-yellow','logo-yellow',2,'image/png',598,'main/general/logo-yellow.png','[]','2025-06-10 10:38:22','2025-06-10 10:38:22',NULL,'public'),(119,0,'logo','logo',2,'image/png',1811,'main/general/logo.png','[]','2025-06-10 10:38:22','2025-06-10 10:38:22',NULL,'public'),(120,0,'testimonial-image','testimonial-image',2,'image/png',14690,'main/general/testimonial-image.png','[]','2025-06-10 10:38:22','2025-06-10 10:38:22',NULL,'public'),(121,0,'1','1',9,'image/png',31065,'main/speakers/1.png','[]','2025-06-10 10:38:22','2025-06-10 10:38:22',NULL,'public'),(122,0,'10','10',9,'image/png',46860,'main/speakers/10.png','[]','2025-06-10 10:38:22','2025-06-10 10:38:22',NULL,'public'),(123,0,'11','11',9,'image/png',52206,'main/speakers/11.png','[]','2025-06-10 10:38:23','2025-06-10 10:38:23',NULL,'public'),(124,0,'2','2',9,'image/png',36766,'main/speakers/2.png','[]','2025-06-10 10:38:23','2025-06-10 10:38:23',NULL,'public'),(125,0,'3','3',9,'image/png',30159,'main/speakers/3.png','[]','2025-06-10 10:38:23','2025-06-10 10:38:23',NULL,'public'),(126,0,'4','4',9,'image/png',10879,'main/speakers/4.png','[]','2025-06-10 10:38:23','2025-06-10 10:38:23',NULL,'public'),(127,0,'5','5',9,'image/png',38725,'main/speakers/5.png','[]','2025-06-10 10:38:23','2025-06-10 10:38:23',NULL,'public'),(128,0,'6','6',9,'image/png',41822,'main/speakers/6.png','[]','2025-06-10 10:38:24','2025-06-10 10:38:24',NULL,'public'),(129,0,'7','7',9,'image/png',36871,'main/speakers/7.png','[]','2025-06-10 10:38:24','2025-06-10 10:38:24',NULL,'public'),(130,0,'8','8',9,'image/png',44128,'main/speakers/8.png','[]','2025-06-10 10:38:24','2025-06-10 10:38:24',NULL,'public'),(131,0,'9','9',9,'image/png',42973,'main/speakers/9.png','[]','2025-06-10 10:38:24','2025-06-10 10:38:24',NULL,'public'),(132,0,'0','0',10,'image/webp',33268,'main/events/0-1749551911.webp','[]','2025-06-10 10:38:31','2025-06-10 10:38:31',NULL,'public'),(133,0,'1','1',10,'image/webp',33268,'main/events/1.webp','[]','2025-06-10 10:38:31','2025-06-10 10:38:31',NULL,'public'),(134,0,'10','10',10,'image/webp',33268,'main/events/10.webp','[]','2025-06-10 10:38:32','2025-06-10 10:38:32',NULL,'public'),(135,0,'11','11',10,'image/webp',33268,'main/events/11.webp','[]','2025-06-10 10:38:32','2025-06-10 10:38:32',NULL,'public'),(136,0,'12','12',10,'image/webp',33268,'main/events/12.webp','[]','2025-06-10 10:38:32','2025-06-10 10:38:32',NULL,'public'),(137,0,'13','13',10,'image/webp',33268,'main/events/13.webp','[]','2025-06-10 10:38:33','2025-06-10 10:38:33',NULL,'public'),(138,0,'14','14',10,'image/webp',33268,'main/events/14.webp','[]','2025-06-10 10:38:33','2025-06-10 10:38:33',NULL,'public'),(139,0,'15','15',10,'image/webp',33268,'main/events/15.webp','[]','2025-06-10 10:38:33','2025-06-10 10:38:33',NULL,'public'),(140,0,'16','16',10,'image/webp',33268,'main/events/16.webp','[]','2025-06-10 10:38:34','2025-06-10 10:38:34',NULL,'public'),(141,0,'17','17',10,'image/webp',33268,'main/events/17.webp','[]','2025-06-10 10:38:34','2025-06-10 10:38:34',NULL,'public'),(142,0,'18','18',10,'image/webp',33268,'main/events/18.webp','[]','2025-06-10 10:38:34','2025-06-10 10:38:34',NULL,'public'),(143,0,'19','19',10,'image/webp',33268,'main/events/19.webp','[]','2025-06-10 10:38:35','2025-06-10 10:38:35',NULL,'public'),(144,0,'2','2',10,'image/webp',33268,'main/events/2.webp','[]','2025-06-10 10:38:35','2025-06-10 10:38:35',NULL,'public'),(145,0,'20','20',10,'image/webp',33268,'main/events/20.webp','[]','2025-06-10 10:38:35','2025-06-10 10:38:35',NULL,'public'),(146,0,'3','3',10,'image/webp',33268,'main/events/3.webp','[]','2025-06-10 10:38:36','2025-06-10 10:38:36',NULL,'public'),(147,0,'4','4',10,'image/webp',33268,'main/events/4.webp','[]','2025-06-10 10:38:36','2025-06-10 10:38:36',NULL,'public'),(148,0,'5','5',10,'image/webp',33268,'main/events/5.webp','[]','2025-06-10 10:38:36','2025-06-10 10:38:36',NULL,'public'),(149,0,'6','6',10,'image/webp',33268,'main/events/6.webp','[]','2025-06-10 10:38:37','2025-06-10 10:38:37',NULL,'public'),(150,0,'7','7',10,'image/webp',33268,'main/events/7.webp','[]','2025-06-10 10:38:37','2025-06-10 10:38:37',NULL,'public'),(151,0,'8','8',10,'image/webp',33268,'main/events/8.webp','[]','2025-06-10 10:38:37','2025-06-10 10:38:37',NULL,'public'),(152,0,'9','9',10,'image/webp',33268,'main/events/9.webp','[]','2025-06-10 10:38:38','2025-06-10 10:38:38',NULL,'public'),(153,0,'1','1',11,'image/png',21331,'main/sliders/1.png','[]','2025-06-10 10:38:46','2025-06-10 10:38:46',NULL,'public'),(154,0,'2','2',11,'image/png',21331,'main/sliders/2.png','[]','2025-06-10 10:38:47','2025-06-10 10:38:47',NULL,'public'),(155,0,'3','3',11,'image/png',21331,'main/sliders/3.png','[]','2025-06-10 10:38:47','2025-06-10 10:38:47',NULL,'public');
/*!40000 ALTER TABLE `media_files` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_folders`
--

DROP TABLE IF EXISTS `media_folders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_folders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `color` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `media_folders_user_id_index` (`user_id`),
  KEY `media_folders_index` (`parent_id`,`user_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_folders`
--

LOCK TABLES `media_folders` WRITE;
/*!40000 ALTER TABLE `media_folders` DISABLE KEYS */;
INSERT INTO `media_folders` VALUES (1,0,'main',NULL,'main',0,'2025-06-10 10:37:42','2025-06-10 10:37:42',NULL),(2,0,'general',NULL,'general',1,'2025-06-10 10:37:42','2025-06-10 10:37:42',NULL),(3,0,'news',NULL,'news',1,'2025-06-10 10:37:44','2025-06-10 10:37:44',NULL),(4,0,'testimonials',NULL,'testimonials',1,'2025-06-10 10:37:54','2025-06-10 10:37:54',NULL),(5,0,'brands',NULL,'brands',1,'2025-06-10 10:37:55','2025-06-10 10:37:55',NULL),(6,0,'backgrounds',NULL,'backgrounds',1,'2025-06-10 10:37:57','2025-06-10 10:37:57',NULL),(7,0,'icons',NULL,'icons',1,'2025-06-10 10:38:02','2025-06-10 10:38:02',NULL),(8,0,'blogs',NULL,'blogs',1,'2025-06-10 10:38:12','2025-06-10 10:38:12',NULL),(9,0,'speakers',NULL,'speakers',1,'2025-06-10 10:38:22','2025-06-10 10:38:22',NULL),(10,0,'events',NULL,'events',1,'2025-06-10 10:38:31','2025-06-10 10:38:31',NULL),(11,0,'sliders',NULL,'sliders',1,'2025-06-10 10:38:46','2025-06-10 10:38:46',NULL);
/*!40000 ALTER TABLE `media_folders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `media_settings`
--

DROP TABLE IF EXISTS `media_settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `media_settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `media_id` bigint unsigned DEFAULT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `media_settings`
--

LOCK TABLES `media_settings` WRITE;
/*!40000 ALTER TABLE `media_settings` DISABLE KEYS */;
/*!40000 ALTER TABLE `media_settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_locations`
--

DROP TABLE IF EXISTS `menu_locations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_locations` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `location` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_locations_menu_id_created_at_index` (`menu_id`,`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_locations`
--

LOCK TABLES `menu_locations` WRITE;
/*!40000 ALTER TABLE `menu_locations` DISABLE KEYS */;
INSERT INTO `menu_locations` VALUES (1,1,'main-menu','2025-06-10 10:38:46','2025-06-10 10:38:46');
/*!40000 ALTER TABLE `menu_locations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menu_nodes`
--

DROP TABLE IF EXISTS `menu_nodes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menu_nodes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `menu_id` bigint unsigned NOT NULL,
  `parent_id` bigint unsigned NOT NULL DEFAULT '0',
  `reference_id` bigint unsigned DEFAULT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `url` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `icon_font` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `css_class` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `target` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '_self',
  `has_child` tinyint unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `menu_nodes_menu_id_index` (`menu_id`),
  KEY `menu_nodes_parent_id_index` (`parent_id`),
  KEY `reference_id` (`reference_id`),
  KEY `reference_type` (`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menu_nodes`
--

LOCK TABLES `menu_nodes` WRITE;
/*!40000 ALTER TABLE `menu_nodes` DISABLE KEYS */;
INSERT INTO `menu_nodes` VALUES (1,1,0,NULL,NULL,'/',NULL,0,'Home',NULL,'_self',1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(2,1,1,NULL,NULL,'https://eventify.archielite.com',NULL,0,'Home 1',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(3,1,1,NULL,NULL,'https://eventify-home-2.archielite.com',NULL,1,'Home 2',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(4,1,1,NULL,NULL,'https://eventify-home-3.archielite.com',NULL,2,'Home 3',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(5,1,1,NULL,NULL,'https://eventify-home-4.archielite.com',NULL,3,'Home 4',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(6,1,1,NULL,NULL,'https://eventify-home-5.archielite.com',NULL,4,'Home 5',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(7,1,1,NULL,NULL,'https://eventify-home-6.archielite.com',NULL,5,'Home 6',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(8,1,1,NULL,NULL,'https://eventify-home-7.archielite.com',NULL,6,'Home 7',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(9,1,1,NULL,NULL,'https://eventify-home-8.archielite.com',NULL,7,'Home 8',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(10,1,1,NULL,NULL,'https://eventify-home-9.archielite.com',NULL,8,'Home 9',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(11,1,1,NULL,NULL,'https://eventify-home-10.archielite.com',NULL,9,'Home 10',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(12,1,0,2,'Botble\\Page\\Models\\Page','/about-us',NULL,1,'About Us',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(13,1,0,NULL,NULL,'/',NULL,2,'Speakers',NULL,'_self',1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(14,1,13,3,'Botble\\Page\\Models\\Page','/speakers',NULL,0,'Speakers',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(15,1,13,NULL,NULL,'/speakers/michael-smith',NULL,1,'Speaker Detail',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(16,1,0,NULL,NULL,'/',NULL,3,'Schedule',NULL,'_self',1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(17,1,16,NULL,NULL,'/events',NULL,0,'Our Event',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(18,1,16,NULL,NULL,'/events',NULL,1,'Event Schedule',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(19,1,16,NULL,NULL,'/events/ces-consumer-electronics-show',NULL,2,'Event Detail',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(20,1,0,NULL,NULL,'/',NULL,4,'Blog',NULL,'_self',1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(21,1,20,4,'Botble\\Page\\Models\\Page','/blog',NULL,0,'Our Blog',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(22,1,20,NULL,NULL,'/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',NULL,1,'Blog Detail',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(23,1,0,NULL,NULL,'/',NULL,5,'Pages',NULL,'_self',1,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(24,1,23,NULL,NULL,'/blog',NULL,0,'Our Memories',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(25,1,23,6,'Botble\\Page\\Models\\Page','/pricing-plan',NULL,1,'Pricing Plan',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(26,1,23,8,'Botble\\Page\\Models\\Page','/faqs',NULL,2,'FAQs',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46'),(27,1,23,7,'Botble\\Page\\Models\\Page','/contact-us',NULL,3,'Contact Us',NULL,'_self',0,'2025-06-10 10:38:46','2025-06-10 10:38:46');
/*!40000 ALTER TABLE `menu_nodes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `menus`
--

DROP TABLE IF EXISTS `menus`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `menus` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `menus_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `menus`
--

LOCK TABLES `menus` WRITE;
/*!40000 ALTER TABLE `menus` DISABLE KEYS */;
INSERT INTO `menus` VALUES (1,'Main menu','main-menu','published','2025-06-10 10:38:46','2025-06-10 10:38:46');
/*!40000 ALTER TABLE `menus` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `meta_boxes`
--

DROP TABLE IF EXISTS `meta_boxes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `meta_boxes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `meta_key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `meta_value` text COLLATE utf8mb4_unicode_ci,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_boxes_reference_id_index` (`reference_id`)
) ENGINE=InnoDB AUTO_INCREMENT=143 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `meta_boxes`
--

LOCK TABLES `meta_boxes` WRITE;
/*!40000 ALTER TABLE `meta_boxes` DISABLE KEYS */;
INSERT INTO `meta_boxes` VALUES (1,'rating_star','[5]',1,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:37:54','2025-06-10 10:37:54'),(2,'rating_star','[5]',2,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:37:54','2025-06-10 10:37:54'),(3,'rating_star','[5]',3,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:37:55','2025-06-10 10:37:55'),(4,'rating_star','[5]',4,'Botble\\Testimonial\\Models\\Testimonial','2025-06-10 10:37:55','2025-06-10 10:37:55'),(5,'breadcrumb_background_image','[\"main\\/backgrounds\\/speakers-bg.png\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:38:12','2025-06-10 10:38:12'),(6,'breadcrumb_text_color','[\"#ffffff\"]',3,'Botble\\Page\\Models\\Page','2025-06-10 10:38:12','2025-06-10 10:38:12'),(7,'title','[\"Fullstack Developer\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(8,'description','[\"I don\'t want to see some meaning in it, \'and what is the use of this pool? I am so VERY nearly at the sudden change, but she got used to it in time,\' said the Cat; and this was not even room for.\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(9,'address','[\"54506 O\'Connell Ways\\nPort Margaretside, MI 85395\"]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(10,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',1,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(11,'title','[\"Product Manager\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(12,'description','[\"HIGH TO LEAVE THE COURT.\' Everybody looked at her, and said, \'So you think I can say.\' This was quite impossible to say it any longer than that,\' said the King: \'however, it may kiss my hand if it.\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(13,'address','[\"2810 Hammes Harbor\\nSchustertown, MA 07026\"]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(14,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',2,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(15,'title','[\"Quality Assurance\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(16,'description','[\"I ever was at the top of the wood--(she considered him to you, Though they were nowhere to be a very curious to see if she were looking over his shoulder as she spoke. Alice did not venture to go on.\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(17,'address','[\"974 Makayla Land\\nJarrettchester, KY 34397\"]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(18,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',3,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(19,'title','[\"System Administrator\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(20,'description','[\"Very soon the Rabbit noticed Alice, as she leant against a buttercup to rest her chin upon Alice\'s shoulder, and it was as steady as ever; Yet you turned a back-somersault in at the cook was busily.\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(21,'address','[\"50936 Dietrich Route\\nLindmouth, NJ 90248\"]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(22,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',4,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(23,'title','[\"Fullstack Developer\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(24,'description','[\"Mouse had changed his mind, and was going off into a pig, my dear,\' said Alice, in a low trembling voice, \'--and I hadn\'t quite finished my tea when I find a pleasure in all directions, \'just like a.\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(25,'address','[\"269 Omer Cliff Suite 550\\nDemarcoville, IL 16704-2218\"]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(26,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',5,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:25','2025-06-10 10:38:25'),(27,'title','[\"Project Manager\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(28,'description','[\"Either the well was very likely to eat her up in great fear lest she should chance to be sure, she had gone through that day. \'No, no!\' said the Footman. \'That\'s the most curious thing I ever.\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(29,'address','[\"2333 McClure Junctions\\nNew Larissaport, MT 15191-2216\"]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(30,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',6,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(31,'title','[\"Fullstack Developer\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(32,'description','[\"But her sister kissed her, and she said to herself, \'Which way? Which way?\', holding her hand in hand with Dinah, and saying to herself what such an extraordinary ways of living would be as well go.\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(33,'address','[\"80293 Reilly Ford\\nHandchester, NV 65942-6007\"]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(34,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',7,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(35,'title','[\"Quality Assurance\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(36,'description','[\"Queen, who were all turning into little cakes as they were all talking together: she made out what she was near enough to drive one crazy!\' The Footman seemed to be patted on the hearth and grinning.\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(37,'address','[\"6593 Brigitte River Suite 784\\nMitchelmouth, AK 82924\"]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(38,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',8,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(39,'title','[\"Backend Developer\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(40,'description','[\"There was a dead silence instantly, and neither of the gloves, and she felt sure it would be so stingy about it, and on both sides of it, and found quite a long time together.\' \'Which is just the.\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(41,'address','[\"763 Constantin Mission Apt. 434\\nRandallfort, NE 05138-2468\"]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(42,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',9,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(43,'title','[\"Quality Assurance\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(44,'description','[\"Just at this moment Five, who had followed him into the garden door. Poor Alice! It was so small as this is May it won\'t be raving mad after all! I almost think I should think!\' (Dinah was the BEST.\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(45,'address','[\"9452 Amya Loop\\nLake Elmo, ME 57673-3717\"]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(46,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',10,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:26','2025-06-10 10:38:26'),(47,'title','[\"DevOps Engineer\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(48,'description','[\"Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found this a good character, But said I could let you out, you know.\' \'I don\'t know what you were never even introduced to a.\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(49,'address','[\"6334 Halvorson Radial\\nNorth Zolaborough, TX 12232-9258\"]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(50,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',11,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(51,'title','[\"Project Manager\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(52,'description','[\"Duchess; \'and most of \'em do.\' \'I don\'t even know what to do with you. Mind now!\' The poor little feet, I wonder what they\'ll do well enough; don\'t be particular--Here, Bill! catch hold of it; so.\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(53,'address','[\"502 Adrianna Ridge Suite 980\\nWunschshire, IA 56670\"]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(54,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',12,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(55,'title','[\"Backend Developer\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(56,'description','[\"Pigeon in a moment to think about stopping herself before she found a little timidly, \'why you are very dull!\' \'You ought to be found: all she could not think of what sort it was) scratching and.\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(57,'address','[\"253 Jakubowski Mountains\\nDaughertyhaven, AR 54525-6135\"]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(58,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',13,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(59,'title','[\"DevOps Engineer\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(60,'description','[\"Queen said--\' \'Get to your places!\' shouted the Queen. \'Sentence first--verdict afterwards.\' \'Stuff and nonsense!\' said Alice very politely; but she could not answer without a porpoise.\' \'Wouldn\'t.\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(61,'address','[\"97154 Mosciski Parkways\\nLake Cieloland, ME 06288\"]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(62,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',14,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:27','2025-06-10 10:38:27'),(63,'title','[\"Backend Developer\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(64,'description','[\"Rabbit say to itself \'Then I\'ll go round and look up and leave the room, when her eye fell on a little glass table. \'Now, I\'ll manage better this time,\' she said, as politely as she could. \'The.\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(65,'address','[\"781 Walter Park Suite 880\\nNew Lauryburgh, VA 10084\"]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(66,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',15,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(67,'title','[\"Project Manager\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(68,'description','[\"Gryphon, and, taking Alice by the little crocodile Improve his shining tail, And pour the waters of the house if it thought that SOMEBODY ought to go near the house down!\' said the Caterpillar.\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(69,'address','[\"56711 Parisian Dam\\nMullertown, NM 94305-6767\"]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(70,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',16,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(71,'title','[\"Product Manager\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(72,'description','[\"The first thing I\'ve got back to them, and just as I get it home?\' when it grunted again, and put it more clearly,\' Alice replied very politely, \'if I had not gone much farther before she found.\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(73,'address','[\"3044 Abbey Inlet Apt. 243\\nSanfordshire, ID 86477\"]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(74,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',17,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(75,'title','[\"System Administrator\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(76,'description','[\"An obstacle that came between Him, and ourselves, and it. Don\'t let him know she liked them best, For this must be Mabel after all, and I don\'t like them!\' When the Mouse had changed his mind, and.\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(77,'address','[\"7753 Cary Groves\\nNew Rick, UT 72292-8775\"]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(78,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',18,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(79,'title','[\"Project Manager\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(80,'description','[\"CHAPTER III. A Caucus-Race and a Long Tale They were just beginning to grow to my jaw, Has lasted the rest were quite dry again, the Dodo replied very solemnly. Alice was not otherwise than what you.\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(81,'address','[\"4984 Gerhard Flats\\nPort Nathanialview, KS 52302-2352\"]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(82,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',19,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(83,'title','[\"Backend Developer\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:28','2025-06-10 10:38:28'),(84,'description','[\"PROVES his guilt,\' said the Duchess; \'and most things twinkled after that--only the March Hare will be much the same when I was thinking I should frighten them out with trying, the poor little juror.\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(85,'address','[\"42163 Gislason Neck Suite 891\\nLoramouth, WV 29345\"]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(86,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',20,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(87,'title','[\"DevOps Engineer\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(88,'description','[\"March Hare. \'It was the first figure!\' said the King said, with a smile. There was a different person then.\' \'Explain all that,\' said the King. On this the White Rabbit read:-- \'They told me you had.\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(89,'address','[\"1123 Parisian Walk Suite 876\\nNew Mohammed, GA 49330\"]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(90,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',21,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(91,'title','[\"UX\\/UI Designer\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(92,'description','[\"Alice. \'Of course not,\' Alice cautiously replied: \'but I know all the rest, Between yourself and me.\' \'That\'s the judge,\' she said to the waving of the other arm curled round her once more, while.\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(93,'address','[\"6161 Harvey Lake Apt. 427\\nSchusterborough, NH 26766-6115\"]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(94,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',22,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(95,'title','[\"UX\\/UI Designer\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(96,'description','[\"MYSELF, I\'m afraid, but you might catch a bat, and that\'s all I can kick a little!\' She drew her foot as far as they were IN the well,\' Alice said nothing; she had gone through that day. \'That.\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(97,'address','[\"7963 Lueilwitz Key\\nNorth Jaydonstad, NV 97086\"]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(98,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',23,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(99,'title','[\"System Administrator\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(100,'description','[\"The other guests had taken his watch out of breath, and said \'What else have you executed.\' The miserable Hatter dropped his teacup and bread-and-butter, and went back for a minute or two the.\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(101,'address','[\"646 Lindgren Forges\\nKatelynberg, ND 38593\"]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(102,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',24,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(103,'title','[\"Frontend Developer\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(104,'description','[\"Alice; \'I daresay it\'s a set of verses.\' \'Are they in the wood,\' continued the King. The White Rabbit read:-- \'They told me you had been looking at them with one finger pressed upon its forehead.\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(105,'address','[\"868 Mason Creek\\nFraneckitown, TN 71930\"]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(106,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',25,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:29','2025-06-10 10:38:29'),(107,'title','[\"Frontend Developer\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(108,'description','[\"Alice, as the rest of the house, \\\"Let us both go to law: I will tell you my adventures--beginning from this morning,\' said Alice thoughtfully: \'but then--I shouldn\'t be hungry for it, she found she.\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(109,'address','[\"20628 Brando Views Suite 881\\nNorth Bridgetteton, WV 66911-8516\"]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(110,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',26,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(111,'title','[\"UX\\/UI Designer\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(112,'description','[\"Mock Turtle interrupted, \'if you don\'t explain it is all the things I used to it!\' pleaded poor Alice began to cry again, for really I\'m quite tired of being all alone here!\' As she said this, she.\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(113,'address','[\"97277 Meagan Squares Suite 777\\nNorth Dejaside, OR 23907\"]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(114,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',27,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(115,'title','[\"DevOps Engineer\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(116,'description','[\"Alice. \'Why?\' \'IT DOES THE BOOTS AND SHOES.\' the Gryphon as if she had sat down with her face brightened up again.) \'Please your Majesty,\' he began, \'for bringing these in: but I can\'t remember,\'.\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(117,'address','[\"90651 Nolan River Apt. 360\\nWest Gennarohaven, NH 16278\"]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(118,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',28,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(119,'title','[\"System Administrator\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(120,'description','[\"Duchess was sitting on a little quicker. \'What a number of changes she had forgotten the Duchess to play croquet with the game,\' the Queen in front of them, with her head!\' Alice glanced rather.\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(121,'address','[\"83121 Amos Club Apt. 047\\nJuanitaside, ME 93113\"]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(122,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',29,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(123,'title','[\"Fullstack Developer\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(124,'description','[\"When I used to say \'I once tasted--\' but checked herself hastily, and said to herself, \'Now, what am I then? Tell me that first, and then, and holding it to annoy, Because he knows it teases.\'.\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(125,'address','[\"6616 Shanelle Junction\\nEvangelinehaven, LA 57080-9459\"]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(126,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',30,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:30','2025-06-10 10:38:30'),(127,'title','[\"Quality Assurance\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:31','2025-06-10 10:38:31'),(128,'description','[\"MINE,\' said the Caterpillar. Here was another puzzling question; and as it was YOUR table,\' said Alice; \'living at the corners: next the ten courtiers; these were all in bed!\' On various pretexts.\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:31','2025-06-10 10:38:31'),(129,'address','[\"5280 Wisoky Freeway Suite 845\\nDietrichville, GA 48456-7848\"]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:31','2025-06-10 10:38:31'),(130,'socials','[[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]]',31,'ArchiElite\\EventsBooking\\Models\\Account','2025-06-10 10:38:31','2025-06-10 10:38:31'),(131,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(132,'highlight_title','[\"Conferences\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(133,'button_label','[\"Reserve My Seat\"]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(134,'event_id','[10]',1,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(135,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(136,'highlight_title','[\"Conferences\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(137,'button_label','[\"Reserve My Seat\"]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(138,'event_id','[6]',2,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(139,'subtitle','[\"Lead Purpose, Innovate with Passion\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(140,'highlight_title','[\"Conferences\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(141,'button_label','[\"Reserve My Seat\"]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47'),(142,'event_id','[6]',3,'Botble\\SimpleSlider\\Models\\SimpleSliderItem','2025-06-10 10:38:47','2025-06-10 10:38:47');
/*!40000 ALTER TABLE `meta_boxes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `migrations`
--

DROP TABLE IF EXISTS `migrations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `migrations` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `migration` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `batch` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=104 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `migrations`
--

LOCK TABLES `migrations` WRITE;
/*!40000 ALTER TABLE `migrations` DISABLE KEYS */;
INSERT INTO `migrations` VALUES (1,'0001_01_01_000001_create_cache_table',1),(2,'2013_04_09_032329_create_base_tables',1),(3,'2013_04_09_062329_create_revisions_table',1),(4,'2014_10_12_000000_create_users_table',1),(5,'2014_10_12_100000_create_password_reset_tokens_table',1),(6,'2015_06_18_033822_create_blog_table',1),(7,'2015_06_29_025744_create_audit_history',1),(8,'2015_08_15_122343_create_notes_table',1),(9,'2016_06_10_230148_create_acl_tables',1),(10,'2016_06_14_230857_create_menus_table',1),(11,'2016_06_17_091537_create_contacts_table',1),(12,'2016_06_28_221418_create_pages_table',1),(13,'2016_10_03_032336_create_languages_table',1),(14,'2016_10_05_074239_create_setting_table',1),(15,'2016_10_07_193005_create_translations_table',1),(16,'2016_10_13_150201_create_galleries_table',1),(17,'2016_11_28_032840_create_dashboard_widget_tables',1),(18,'2016_12_16_084601_create_widgets_table',1),(19,'2017_05_09_070343_create_media_tables',1),(20,'2017_05_18_080441_create_payment_tables',1),(21,'2017_07_11_140018_create_simple_slider_table',1),(22,'2017_10_24_154832_create_newsletter_table',1),(23,'2017_11_03_070450_create_slug_table',1),(24,'2018_07_09_214610_create_testimonial_table',1),(25,'2018_07_09_221238_create_faq_table',1),(26,'2019_01_05_053554_create_jobs_table',1),(27,'2019_08_19_000000_create_failed_jobs_table',1),(28,'2019_11_18_061011_create_country_table',1),(29,'2019_12_14_000001_create_personal_access_tokens_table',1),(30,'2020_11_18_150916_ads_create_ads_table',1),(31,'2021_02_16_092633_remove_default_value_for_author_type',1),(32,'2021_03_27_144913_add_customer_type_into_table_payments',1),(33,'2021_05_24_034720_make_column_currency_nullable',1),(34,'2021_08_09_161302_add_metadata_column_to_payments_table',1),(35,'2021_10_19_020859_update_metadata_field',1),(36,'2021_10_25_021023_fix-priority-load-for-language-advanced',1),(37,'2021_12_02_035301_add_ads_translations_table',1),(38,'2021_12_03_030600_create_blog_translations',1),(39,'2021_12_03_075608_create_page_translations',1),(40,'2021_12_03_082134_create_faq_translations',1),(41,'2021_12_03_082953_create_gallery_translations',1),(42,'2021_12_03_083642_create_testimonials_translations',1),(43,'2021_12_03_084118_create_location_translations',1),(44,'2021_12_03_094518_migrate_old_location_data',1),(45,'2021_12_10_034440_switch_plugin_location_to_use_language_advanced',1),(46,'2022_01_16_085908_improve_plugin_location',1),(47,'2022_04_19_113923_add_index_to_table_posts',1),(48,'2022_04_20_100851_add_index_to_media_table',1),(49,'2022_04_20_101046_add_index_to_menu_table',1),(50,'2022_04_30_034048_create_gallery_meta_translations_table',1),(51,'2022_06_28_151901_activate_paypal_stripe_plugin',1),(52,'2022_07_07_153354_update_charge_id_in_table_payments',1),(53,'2022_07_10_034813_move_lang_folder_to_root',1),(54,'2022_08_04_051940_add_missing_column_expires_at',1),(55,'2022_08_04_052122_delete_location_backup_tables',1),(56,'2022_09_01_000001_create_admin_notifications_tables',1),(57,'2022_10_14_024629_drop_column_is_featured',1),(58,'2022_11_18_063357_add_missing_timestamp_in_table_settings',1),(59,'2022_12_02_093615_update_slug_index_columns',1),(60,'2023_01_30_024431_add_alt_to_media_table',1),(61,'2023_02_16_042611_drop_table_password_resets',1),(62,'2023_04_17_062645_add_open_in_new_tab',1),(63,'2023_04_23_005903_add_column_permissions_to_admin_notifications',1),(64,'2023_04_23_061847_increase_state_translations_abbreviation_column',1),(65,'2023_05_10_075124_drop_column_id_in_role_users_table',1),(66,'2023_07_06_011444_create_slug_translations_table',1),(67,'2023_07_26_041451_add_more_columns_to_location_table',1),(68,'2023_07_27_041451_add_more_columns_to_location_translation_table',1),(69,'2023_08_11_060908_create_announcements_table',1),(70,'2023_08_15_073307_drop_unique_in_states_cities_translations',1),(71,'2023_08_21_090810_make_page_content_nullable',1),(72,'2023_08_29_074620_make_column_author_id_nullable',1),(73,'2023_08_29_075308_make_column_user_id_nullable',1),(74,'2023_09_14_021936_update_index_for_slugs_table',1),(75,'2023_09_14_022423_add_index_for_language_table',1),(76,'2023_10_21_065016_make_state_id_in_table_cities_nullable',1),(77,'2023_11_07_023805_add_tablet_mobile_image',1),(78,'2023_11_10_080225_migrate_contact_blacklist_email_domains_to_core',1),(79,'2023_11_14_033417_change_request_column_in_table_audit_histories',1),(80,'2023_11_17_063408_add_description_column_to_faq_categories_table',1),(81,'2023_12_07_095130_add_color_column_to_media_folders_table',1),(82,'2023_12_12_105220_drop_translations_table',1),(83,'2023_12_17_162208_make_sure_column_color_in_media_folders_nullable',1),(84,'2024_03_20_080001_migrate_change_attribute_email_to_nullable_form_contacts_table',1),(85,'2024_03_25_000001_update_captcha_settings_for_contact',1),(86,'2024_03_25_000001_update_captcha_settings_for_newsletter',1),(87,'2024_04_01_043317_add_google_adsense_slot_id_to_ads_table',1),(88,'2024_04_04_110758_update_value_column_in_user_meta_table',1),(89,'2024_04_19_063914_create_custom_fields_table',1),(90,'2024_04_27_100730_improve_analytics_setting',1),(91,'2024_05_12_091229_add_column_visibility_to_table_media_files',1),(92,'2024_06_21_083515_events_booking_create_eb_events_table',1),(93,'2024_07_04_083133_create_payment_logs_table',1),(94,'2024_07_07_091316_fix_column_url_in_menu_nodes_table',1),(95,'2024_07_12_100000_change_random_hash_for_media',1),(96,'2024_07_30_091615_fix_order_column_in_categories_table',1),(97,'2024_09_30_024515_create_sessions_table',1),(98,'2025_01_06_033807_add_default_value_for_categories_author_type',1),(99,'2025_03_18_095019_update_invoices_table',1),(100,'2025_04_08_040931_create_social_logins_table',1),(101,'2025_04_12_000003_add_payment_fee_to_payments_table',1),(102,'2025_05_05_000001_add_user_type_to_audit_histories_table',1),(103,'2025_05_22_000001_add_payment_fee_type_to_settings_table',1);
/*!40000 ALTER TABLE `migrations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `newsletters`
--

DROP TABLE IF EXISTS `newsletters`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `newsletters` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `newsletters`
--

LOCK TABLES `newsletters` WRITE;
/*!40000 ALTER TABLE `newsletters` DISABLE KEYS */;
/*!40000 ALTER TABLE `newsletters` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `notes`
--

DROP TABLE IF EXISTS `notes`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `notes` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint unsigned NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` bigint unsigned NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `notes_user_id_index` (`user_id`),
  KEY `notes_reference_id_index` (`reference_id`),
  KEY `notes_created_by_index` (`created_by`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `notes`
--

LOCK TABLES `notes` WRITE;
/*!40000 ALTER TABLE `notes` DISABLE KEYS */;
/*!40000 ALTER TABLE `notes` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages`
--

DROP TABLE IF EXISTS `pages`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `template` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pages_user_id_index` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages`
--

LOCK TABLES `pages` WRITE;
/*!40000 ALTER TABLE `pages` DISABLE KEYS */;
INSERT INTO `pages` VALUES (1,'Homepage','[hero-banner title=&quot;Business Forward 2025 Strategies for a New Era&quot; subtitle=&quot;Lead Purpose, Innovate with Passion&quot; description=&quot;Welcome Innovate 2025 Shaping the Future of Business, where industry leaders, innovators, and visionaries come.&quot; image=&quot;main/general/hero-banner-img.png&quot; button_primary_label=&quot;Reserve My Seat&quot; button_secondary_url=&quot;/about-us&quot; button_secondary_label=&quot;About us&quot; button_primary_url=&quot;/events&quot; background_image=&quot;main/backgrounds/hero-banner-bg.png&quot;][/hero-banner][about-us-information style=&quot;3&quot; title=&quot;Innovate 2024 Shaping Of The Future Of Business&quot; subtitle=&quot;about our business conferences&quot; description=&quot;Reflects Our commitment To Driving Progress Embracing Innovation In An Ever-evolving Marketplace. Our Conference is Designed to be a hub for thought leadership, where business pioneers and emerging.&quot; floating_button_label=&quot;Buy Ticket&quot; floating_button_url=&quot;/events&quot; button_label=&quot;Become an Attendee&quot; button_url=&quot;/about-us&quot; quantity=&quot;2&quot; title_1=&quot;Exclusive Keynotes&quot; description_1=&quot;The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.&quot; icon_1=&quot;ti ti-microphone-2&quot; title_2=&quot;Off Side Trips&quot; description_2=&quot;By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.&quot; icon_2=&quot;ti ti-chart-bubble&quot; image=&quot;main/general/about-img1.png&quot; image_1=&quot;main/general/about-img2.png&quot; image_2=&quot;main/general/about-img3.png&quot;][/about-us-information][events-schedule title=&quot;Our Events Schedule Plan&quot; subtitle=&quot;Event Schedule&quot; number_days=&quot;5&quot;][/events-schedule][testimonials title=&quot;What Our Attendees Say&quot; subtitle=&quot;Testimonial&quot; testimonial_ids=&quot;1,2,3,4&quot; youtube_video_url=&quot;https://www.youtube.com/watch?v=ldusxyoq0Y8&quot; image=&quot;main/general/testimonial-image.png&quot; background_color=&quot;#FBF9F4&quot;][/testimonials][events title=&quot;Recent Memories 2024&quot; subtitle=&quot;Last year memory&quot; limit=&quot;5&quot; logo=&quot;main/general/logo-yellow.png&quot;][/events][brands style=&quot;2&quot; subtitle=&quot;general sponsors&quot; title=&quot;Our Official Sponsors&quot; quantity=&quot;8&quot; alt_1=&quot;Boltshift&quot; image_1=&quot;main/brands/brand-img1.png&quot; link_1=&quot;https://paulmbingu.com/boltshiftui&quot; alt_2=&quot;Lightbox&quot; image_2=&quot;main/brands/brand-img2.png&quot; link_2=&quot;https://lokeshdhakar.com/projects/lightbox2/&quot; alt_3=&quot;GlobalBank&quot; image_3=&quot;main/brands/brand-img3.png&quot; link_3=&quot;https://www.globalbank.com.pa/&quot; alt_4=&quot;FeatherDev&quot; image_4=&quot;main/brands/brand-img4.png&quot; link_4=&quot;https://featherdev.com/&quot; alt_5=&quot;Acme Corp&quot; image_5=&quot;main/brands/brand-img5.png&quot; link_5=&quot;https://www.acmecorp.com/&quot; alt_6=&quot;Polymath&quot; image_6=&quot;main/brands/brand-img6.png&quot; link_6=&quot;https://polymath.network/&quot; alt_7=&quot;Nietzche&quot; image_7=&quot;main/brands/brand-img7.png&quot; link_7=&quot;https://redsvn.net/&quot; alt_8=&quot;Epicurious&quot; image_8=&quot;main/brands/brand-img8.png&quot; link_8=&quot;https://www.epicurious.com&quot;][/brands][blog-posts limit=&quot;3&quot; category_ids=&quot;1,2,4&quot; title=&quot;Balancing Profit &amp; Purpose&quot; subtitle=&quot;News &amp; updates&quot; type=&quot;featured&quot; enable_lazy_loading=&quot;no&quot;][/blog-posts]',1,NULL,'homepage',NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(2,'About Us','[about-us-information subtitle=\"About our Business conferences\" title=\"Explore Future Of Design At Our Yearly Conference\" description=\"The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.\" button_label=\"Become an Attendee\" button_url=\"/contact-us\" quantity=\"3\" title_1=\"Our Journalist\" figure_1=\"250\" description_1=\"The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.\" icon_image_1=\"main/icons/microphone.png\" title_2=\"Our Speaker\" figure_2=\"15\" description_2=\"By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.\" icon_image_2=\"main/icons/balloons.png\" title_3=\"Attendees\" figure_3=\"7000\" floating_button_label=\"Buy Ticket\" floating_button_url=\"/pricing\" image=\"main/general/about-img1.png\" image_1=\"main/general/about-img2.png\" image_2=\"main/general/about-img3.png\"][/about-us-information][brands style=\"1\" title=\"Join 4,000+ companies already growing\" quantity=\"8\" alt_1=\"Boltshift\" image_1=\"main/brands/brand-img1.png\" link_1=\"https://paulmbingu.com/boltshiftui\" alt_2=\"Lightbox\" image_2=\"main/brands/brand-img2.png\" link_2=\"https://lokeshdhakar.com/projects/lightbox2/\" alt_3=\"GlobalBank\" image_3=\"main/brands/brand-img3.png\" link_3=\"https://www.globalbank.com.pa/\" alt_4=\"FeatherDev\" image_4=\"main/brands/brand-img4.png\" link_4=\"https://featherdev.com/\" alt_5=\"Acme Corp\" image_5=\"main/brands/brand-img5.png\" link_5=\"https://www.acmecorp.com/\" alt_6=\"Polymath\" image_6=\"main/brands/brand-img6.png\" link_6=\"https://polymath.network/\" alt_7=\"Nietzche\" image_7=\"main/brands/brand-img7.png\" link_7=\"https://redsvn.net/\" alt_8=\"Epicurious\" image_8=\"main/brands/brand-img8.png\" link_8=\"https://www.epicurious.com\"][/brands][featured-block subtitle=\"why choose us\" title=\"Why Attend Event?\" quantity=\"6\" title_1=\"Make Ideas Happen\" description_1=\"Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.\" url_1=\"/events\" icon_image_1=\"main/icons/idea.png\" title_2=\"Great Speakers\" description_2=\"Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.\" url_2=\"/events\" icon_image_2=\"main/icons/speaker.png\" title_3=\"One Day Ticket\" description_3=\"We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.\" url_3=\"/events\" icon_image_3=\"main/icons/ticket.png\" title_4=\"Develop Your Skills\" description_4=\"Eventify is your gateway to future of business. By bringing together best experts from various sectors.\" url_4=\"/events\" icon_image_4=\"main/icons/coding.png\" title_5=\"Entry Verification\" description_5=\"You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.\" url_5=\"/events\" icon_image_5=\"main/icons/search.png\" title_6=\"Workshops Offer\" description_6=\"Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.\" url_6=\"/events\" icon_image_6=\"main/icons/workshop.png\"][/featured-block]',1,NULL,NULL,NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(3,'Speakers','[speakers limit=\"8\"][/speakers]',1,NULL,'full-width',NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(4,'Blog','',1,NULL,'default',NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(5,'Events','',1,NULL,'default',NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(6,'Pricing Plan','[pricing title=\"Event Pass & Tickets\" subtitle=\"Ticket Pricing\" quantity=\"3\" name_1=\"Basic Packages\" price_1=\"$29\" unit_1=\"One Person\" features_1=\"+ Regular Seating \\n + Comfortable Sleeping \\n + Afternoon Snacks \\n + Afternoon Entrance \\n + Idea sharing\" button_url_1=\"/contact-us\" button_label_1=\"Buy A Ticket\" name_2=\"Standard Packages\" price_2=\"$49\" unit_2=\"One Person\" features_2=\"+ Venue rental \\n + Premium seating and tables \\n + Full event planning service \\n + Entertainment services \\n + Luxury transportation\" button_url_2=\"/contact-us\" button_label_2=\"Buy A Ticket\" name_3=\"Premium Packages\" price_3=\"$69\" unit_3=\"One Person\" features_3=\"+ Customized decor \\n + Top-tier catering \\n + Top-shelf beverage package \\n + Full event production \\n + Luxury accommodations\" button_url_3=\"/contact-us\" button_label_3=\"Buy A Ticket\" background_image_name=\"main/backgrounds/pricing-name.png\"][/pricing]',1,NULL,'full-width',NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(7,'Contact Us','[contact-form title=&quot;Get In Touch Now&quot; display_fields=&quot;phone,email,subject,address&quot; mandatory_fields=&quot;email&quot; image=&quot;main/general/contact-img-1.png&quot;][/contact-form][contact-information address=&quot;Ho Chi Minh City, Viet Nam&quot; title=&quot;Direction To The Venue&quot; subtitle=&quot;How to reach&quot; image=&quot;main/general/contact-img-2.png&quot; background_image=&quot;main/backgrounds/2.png&quot; icon_bg_image=&quot;main/backgrounds/1.png&quot; quantity=&quot;4&quot; title_1=&quot;Our Email&quot; description_1=&quot;eventify@gmail.com&quot; url_1=&quot;maito:eventify@gmail.com&quot; icon_image_1=&quot;main/icons/mail-icon.png&quot; title_2=&quot;our location&quot; description_2=&quot;Viet Nam&quot; url_2=&quot;/contact-us&quot; icon_image_2=&quot;main/icons/location-icon.png&quot; title_3=&quot;Call/Message&quot; description_3=&quot;+11234567890&quot; url_3=&quot;tel:+11234567890&quot; icon_image_3=&quot;main/icons/phone-icon.png&quot; title_4=&quot;Instagram&quot; description_4=&quot;@eventify&quot; url_4=&quot;/contact-us&quot; icon_image_4=&quot;main/icons/instagram-icon.png&quot;][/contact-information]',1,NULL,NULL,NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(8,'FAQs','[faq title=&quot;Frequently Asked Question&quot; quantity=&quot;4&quot; category_id_1=&quot;1&quot; category_id_2=&quot;2&quot; category_id_3=&quot;3&quot; category_id_4=&quot;4&quot;][/faq]',1,NULL,NULL,NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12'),(9,'Privacy Policy','<div class=\"container mt-50\">\n    <div class=\"content-detail font-md\">\n        <div class=\"ck-content\">\n            <h3>EU Privacy policy</h3>\n            <br>\n            <p>To use this website we are using Cookies and collecting some Data. To be compliant with the EU GDPR we give you to choose if you allow us to use certain Cookies and to collect some Data.</p>\n            <br>\n            <h4>Essential Data</h4>\n            <br>\n            <p>The Essential Data is needed to run the Site you are visiting technically. You can not deactivate them.</p>\n            <p>- Session Cookie: PHP uses a Cookie to identify user sessions. Without this Cookie the Website is not working.</p>\n            <p>- XSRF-Token Cookie: Laravel automatically generates a CSRF \"token\" for each active user session managed by the application. This token is used to verify that the authenticated user is the one actually making the requests to the application.</p>\n        </div>\n    </div>\n</div>\n',1,NULL,NULL,NULL,'published','2025-06-10 10:38:12','2025-06-10 10:38:12');
/*!40000 ALTER TABLE `pages` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `pages_translations`
--

DROP TABLE IF EXISTS `pages_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `pages_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pages_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`pages_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `pages_translations`
--

LOCK TABLES `pages_translations` WRITE;
/*!40000 ALTER TABLE `pages_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `pages_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `password_reset_tokens`
--

DROP TABLE IF EXISTS `password_reset_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `password_reset_tokens` (
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `password_reset_tokens`
--

LOCK TABLES `password_reset_tokens` WRITE;
/*!40000 ALTER TABLE `password_reset_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `password_reset_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payment_logs`
--

DROP TABLE IF EXISTS `payment_logs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payment_logs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `payment_method` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request` longtext COLLATE utf8mb4_unicode_ci,
  `response` longtext COLLATE utf8mb4_unicode_ci,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payment_logs`
--

LOCK TABLES `payment_logs` WRITE;
/*!40000 ALTER TABLE `payment_logs` DISABLE KEYS */;
/*!40000 ALTER TABLE `payment_logs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `payments`
--

DROP TABLE IF EXISTS `payments`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `payments` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `currency` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_id` bigint unsigned NOT NULL DEFAULT '0',
  `charge_id` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `payment_channel` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(15,2) unsigned NOT NULL,
  `payment_fee` decimal(15,2) DEFAULT '0.00',
  `order_id` bigint unsigned DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `payment_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT 'confirm',
  `customer_id` bigint unsigned DEFAULT NULL,
  `refunded_amount` decimal(15,2) unsigned DEFAULT NULL,
  `refund_note` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `customer_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `metadata` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=51 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `payments`
--

LOCK TABLES `payments` WRITE;
/*!40000 ALTER TABLE `payments` DISABLE KEYS */;
INSERT INTO `payments` VALUES (1,'1',0,'IAKYGSQEA3I9','bank_transfer',NULL,4.45,0.00,1,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38',NULL,NULL),(2,'1',0,'G3OMEVV7BTLH','bank_transfer',NULL,17.80,0.00,2,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38',NULL,NULL),(3,'1',0,'XQUI9ZOSMWIV','bank_transfer',NULL,22.25,0.00,3,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:38','2025-06-10 10:38:38',NULL,NULL),(4,'1',0,'4QDF6R5RLKHL','bank_transfer',NULL,8.90,0.00,4,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(5,'1',0,'6BKHWFSZCTWY','bank_transfer',NULL,8.90,0.00,5,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(6,'1',0,'UQOCOMQ16E8V','bank_transfer',NULL,22.25,0.00,6,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(7,'1',0,'RJOWINJNGRCW','bank_transfer',NULL,8.90,0.00,7,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(8,'1',0,'QF9XDD8B9EBB','bank_transfer',NULL,22.25,0.00,8,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(9,'1',0,'WW5W73WY2TOO','bank_transfer',NULL,13.35,0.00,9,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(10,'1',0,'BJU40H8TCXOF','bank_transfer',NULL,13.35,0.00,10,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(11,'1',0,'94IKTUMMPCHO','bank_transfer',NULL,381.44,0.00,11,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(12,'1',0,'XADO4GG3KMVJ','bank_transfer',NULL,381.44,0.00,12,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(13,'1',0,'DEYFHYCRDQHA','bank_transfer',NULL,286.08,0.00,13,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(14,'1',0,'8HWLOCLGYZ99','bank_transfer',NULL,381.44,0.00,14,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:39','2025-06-10 10:38:39',NULL,NULL),(15,'1',0,'3VJ1Z5WD8XUI','bank_transfer',NULL,381.44,0.00,15,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(16,'1',0,'RO5R0XXY4DLK','bank_transfer',NULL,381.44,0.00,16,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(17,'1',0,'O9DDF42NKWKE','bank_transfer',NULL,381.44,0.00,17,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(18,'1',0,'HPY4BCBYDPDN','bank_transfer',NULL,95.36,0.00,18,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(19,'1',0,'RQX2QJF5PIJY','bank_transfer',NULL,95.36,0.00,19,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(20,'1',0,'TFB9KU06G7EL','bank_transfer',NULL,286.08,0.00,20,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(21,'1',0,'KHM3FW4HWERH','bank_transfer',NULL,89.68,0.00,21,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(22,'1',0,'OXVGVC7HQ6HC','bank_transfer',NULL,89.68,0.00,22,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(23,'1',0,'YLWYHKJXQCOL','bank_transfer',NULL,67.26,0.00,23,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(24,'1',0,'NBSNVKHMVA82','bank_transfer',NULL,89.68,0.00,24,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(25,'1',0,'A7LAEH86IWQF','bank_transfer',NULL,67.26,0.00,25,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(26,'1',0,'PGH9JPRNR5DP','bank_transfer',NULL,22.42,0.00,26,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:40','2025-06-10 10:38:40',NULL,NULL),(27,'1',0,'EQDWR0HCZZ5V','bank_transfer',NULL,22.42,0.00,27,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(28,'1',0,'XVCC13Q49NSL','bank_transfer',NULL,44.84,0.00,28,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(29,'1',0,'XVLEKAXLZLIS','bank_transfer',NULL,67.26,0.00,29,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(30,'1',0,'TZ6V3GQWBRGL','bank_transfer',NULL,112.10,0.00,30,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(31,'1',0,'PPU88WUPKWTU','bank_transfer',NULL,24.31,0.00,31,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(32,'1',0,'1MNM05JKD3YF','bank_transfer',NULL,97.24,0.00,32,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(33,'1',0,'BJ4WKO25BXJN','bank_transfer',NULL,72.93,0.00,33,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(34,'1',0,'UL2CWUMAOHU4','bank_transfer',NULL,72.93,0.00,34,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(35,'1',0,'J8E7HFQGOO57','bank_transfer',NULL,72.93,0.00,35,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(36,'1',0,'EMSWKBEISTHA','bank_transfer',NULL,72.93,0.00,36,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(37,'1',0,'SAEZMXYB8KJN','bank_transfer',NULL,72.93,0.00,37,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(38,'1',0,'YMJ3OALIE2O8','bank_transfer',NULL,24.31,0.00,38,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:41','2025-06-10 10:38:41',NULL,NULL),(39,'1',0,'7O0FVEIRO5ZY','bank_transfer',NULL,97.24,0.00,39,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(40,'1',0,'F4IJHVHZFB9U','bank_transfer',NULL,48.62,0.00,40,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(41,'1',0,'JLZOVIML2KQI','bank_transfer',NULL,298.28,0.00,41,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(42,'1',0,'SFEAOUDXW4TD','bank_transfer',NULL,298.28,0.00,42,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(43,'1',0,'4XSQSEZADTSY','bank_transfer',NULL,223.71,0.00,43,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(44,'1',0,'MPCZR0YO62NO','bank_transfer',NULL,223.71,0.00,44,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(45,'1',0,'W19VCQPGA6Z8','bank_transfer',NULL,74.57,0.00,45,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(46,'1',0,'LTJV0SA4BYTA','bank_transfer',NULL,149.14,0.00,46,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(47,'1',0,'UOXQY5M1OCGN','bank_transfer',NULL,223.71,0.00,47,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(48,'1',0,'BF5RYRQITOJY','bank_transfer',NULL,298.28,0.00,48,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(49,'1',0,'XFLWUSDYZCSF','bank_transfer',NULL,298.28,0.00,49,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL),(50,'1',0,'CZY3Q0YNYWTC','bank_transfer',NULL,149.14,0.00,50,'completed','confirm',NULL,NULL,NULL,'2025-06-10 10:38:42','2025-06-10 10:38:42',NULL,NULL);
/*!40000 ALTER TABLE `payments` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `personal_access_tokens`
--

DROP TABLE IF EXISTS `personal_access_tokens`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `personal_access_tokens` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `tokenable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tokenable_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` varchar(64) COLLATE utf8mb4_unicode_ci NOT NULL,
  `abilities` text COLLATE utf8mb4_unicode_ci,
  `last_used_at` timestamp NULL DEFAULT NULL,
  `expires_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `personal_access_tokens_token_unique` (`token`),
  KEY `personal_access_tokens_tokenable_type_tokenable_id_index` (`tokenable_type`,`tokenable_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `personal_access_tokens`
--

LOCK TABLES `personal_access_tokens` WRITE;
/*!40000 ALTER TABLE `personal_access_tokens` DISABLE KEYS */;
/*!40000 ALTER TABLE `personal_access_tokens` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_categories`
--

DROP TABLE IF EXISTS `post_categories`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_categories` (
  `category_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_categories_category_id_index` (`category_id`),
  KEY `post_categories_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_categories`
--

LOCK TABLES `post_categories` WRITE;
/*!40000 ALTER TABLE `post_categories` DISABLE KEYS */;
INSERT INTO `post_categories` VALUES (2,1),(1,1),(5,2),(1,2),(2,3),(3,3),(6,4),(1,4),(3,5),(2,5),(2,6),(1,6),(5,7),(6,7),(1,8),(1,9),(6,9),(6,10),(1,10),(2,11),(5,11),(3,12),(6,13),(4,13),(6,14),(1,14),(2,15),(1,15),(4,16),(6,17),(4,17),(6,18),(2,19),(4,19),(1,20),(3,20);
/*!40000 ALTER TABLE `post_categories` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `post_tags`
--

DROP TABLE IF EXISTS `post_tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `post_tags` (
  `tag_id` bigint unsigned NOT NULL,
  `post_id` bigint unsigned NOT NULL,
  KEY `post_tags_tag_id_index` (`tag_id`),
  KEY `post_tags_post_id_index` (`post_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `post_tags`
--

LOCK TABLES `post_tags` WRITE;
/*!40000 ALTER TABLE `post_tags` DISABLE KEYS */;
INSERT INTO `post_tags` VALUES (6,1),(7,1),(7,2),(3,2),(1,3),(4,3),(6,3),(4,4),(3,4),(6,4),(7,5),(5,5),(2,6),(1,6),(6,6),(6,7),(4,7),(1,7),(5,8),(4,8),(6,9),(2,9),(7,9),(6,10),(5,10),(2,11),(3,11),(6,12),(1,12),(3,12),(2,13),(7,13),(7,14),(4,14),(3,15),(5,15),(4,15),(2,16),(6,16),(4,16),(2,17),(1,17),(5,17),(4,18),(2,18),(3,18),(2,19),(4,19),(7,19),(7,20),(5,20),(3,20);
/*!40000 ALTER TABLE `post_tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts`
--

DROP TABLE IF EXISTS `posts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `is_featured` tinyint unsigned NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `views` int unsigned NOT NULL DEFAULT '0',
  `format_type` varchar(30) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `posts_status_index` (`status`),
  KEY `posts_author_id_index` (`author_id`),
  KEY `posts_author_type_index` (`author_type`),
  KEY `posts_created_at_index` (`created_at`)
) ENGINE=InnoDB AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts`
--

LOCK TABLES `posts` WRITE;
/*!40000 ALTER TABLE `posts` DISABLE KEYS */;
INSERT INTO `posts` VALUES (1,'Breakthrough in Quantum Computing: Computing Power Reaches Milestone','Researchers achieve a significant milestone in quantum computing, unlocking unprecedented computing power that has the potential to revolutionize various industries.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/1.jpg',1058,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(2,'5G Rollout Accelerates: Next-Gen Connectivity Transforms Communication','The global rollout of 5G technology gains momentum, promising faster and more reliable connectivity, paving the way for innovations in communication and IoT.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/2.jpg',943,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(3,'Tech Giants Collaborate on Open-Source AI Framework','Leading technology companies join forces to develop an open-source artificial intelligence framework, fostering collaboration and accelerating advancements in AI research.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/3.jpg',1473,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(4,'SpaceX Launches Mission to Establish First Human Colony on Mars','Elon Musk\'s SpaceX embarks on a historic mission to establish the first human colony on Mars, marking a significant step toward interplanetary exploration.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/4.jpg',2315,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(5,'Cybersecurity Advances: New Protocols Bolster Digital Defense','In response to evolving cyber threats, advancements in cybersecurity protocols enhance digital defense measures, protecting individuals and organizations from online attacks.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/5.jpg',2015,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(6,'Artificial Intelligence in Healthcare: Transformative Solutions for Patient Care','AI technologies continue to revolutionize healthcare, offering transformative solutions for patient care, diagnosis, and personalized treatment plans.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',1,'main/blogs/6.jpg',2428,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(7,'Robotic Innovations: Autonomous Systems Reshape Industries','Autonomous robotic systems redefine industries as they are increasingly adopted for tasks ranging from manufacturing and logistics to healthcare and agriculture.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/7.jpg',299,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(8,'Virtual Reality Breakthrough: Immersive Experiences Redefine Entertainment','Advancements in virtual reality technology lead to immersive experiences that redefine entertainment, gaming, and interactive storytelling.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/8.jpg',1459,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(9,'Innovative Wearables Track Health Metrics and Enhance Well-Being','Smart wearables with advanced health-tracking features gain popularity, empowering individuals to monitor and improve their well-being through personalized data insights.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/9.jpg',136,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(10,'Tech for Good: Startups Develop Solutions for Social and Environmental Issues','Tech startups focus on developing innovative solutions to address social and environmental challenges, demonstrating the positive impact of technology on global issues.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/10.jpg',1077,NULL,'2025-06-10 10:38:19','2025-06-10 10:38:19'),(11,'AI-Powered Personal Assistants Evolve: Enhancing Productivity and Convenience','AI-powered personal assistants undergo significant advancements, becoming more intuitive and capable of enhancing productivity and convenience in users\' daily lives.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/11.jpg',1590,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(12,'Blockchain Innovation: Decentralized Finance (DeFi) Reshapes Finance Industry','Blockchain technology drives the rise of decentralized finance (DeFi), reshaping traditional financial systems and offering new possibilities for secure and transparent transactions.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/12.jpg',709,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(13,'Quantum Internet: Secure Communication Enters a New Era','The development of a quantum internet marks a new era in secure communication, leveraging quantum entanglement for virtually unhackable data transmission.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/13.jpg',2275,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(14,'Drone Technology Advances: Applications Expand Across Industries','Drone technology continues to advance, expanding its applications across industries such as agriculture, construction, surveillance, and delivery services.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/14.jpg',1628,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(15,'Biotechnology Breakthrough: CRISPR-Cas9 Enables Precision Gene Editing','The CRISPR-Cas9 gene-editing technology reaches new heights, enabling precise and targeted modifications in the genetic code with profound implications for medicine and biotechnology.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/15.jpg',2089,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(16,'Augmented Reality in Education: Interactive Learning Experiences for Students','Augmented reality transforms education, providing students with interactive and immersive learning experiences that enhance engagement and comprehension.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/16.jpg',932,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(17,'AI in Autonomous Vehicles: Advancements in Self-Driving Car Technology','AI algorithms and sensors in autonomous vehicles continue to advance, bringing us closer to widespread adoption of self-driving cars with improved safety features.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/17.jpg',1916,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(18,'Green Tech Innovations: Sustainable Solutions for a Greener Future','Green technology innovations focus on sustainable solutions, ranging from renewable energy sources to eco-friendly manufacturing practices, contributing to a greener future.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/18.jpg',781,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(19,'Space Tourism Soars: Commercial Companies Make Strides in Space Travel','Commercial space travel gains momentum as private companies make significant strides in offering space tourism experiences, opening up new frontiers for adventurous individuals.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/19.jpg',1726,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20'),(20,'Humanoid Robots in Everyday Life: AI Companions and Assistants','Humanoid robots equipped with advanced artificial intelligence become more integrated into everyday life, serving as companions and assistants in various settings.','<p>At Eventify 2024, you\'ll join an exclusive gathering of business leaders and innovators shaping the future their industries. This one-day conference offers dynamic sessions on leadership, technology, and strategy to help you stay ahead in today\'s competitive market. Whether you\'re looking to unlock new opportunities or build lasting eventify partnerships, Eventify is where you need to be.</p>\n<div class=\"space16\"></div>\n[content-images quantity=\"2\" image_1=\"main/blogs/8.jpg\" image_2=\"main/blogs/5.jpg\"][/content-images]\n<h3>Eventify: Your Gateway Strategic Growth</h3>\n<div class=\"space16\"></div>\n<p>Fuel an your business growth with actionable insights from world-class experts at Eventify 2024. This premier event brings together forward-thinking professionals to explore the latest trends, technologies, and strategies for success. From keynote speeches to interactive workshops, Eventify provides you with the tools you need.</p>\n<div class=\"space16\"></div>\n<p>\"Join us at Eventify 2024, where innovation meets opportunity. This conference is the ultimate destination for business leaders seeking to push the boundaries of an what\'s possible. With sessions on disruptive technologies, leadership trends, and market strategies, you\'ll walk away with the knowledge and connections to lead.</p>\n<div class=\"space48\"></div>\n[youtube-video]https://www.youtube.com/watch?v=ldusxyoq0Y8[/youtube-video]\n<div class=\"space32\"></div>\n<h3>Reimagine Business Possibilities Eventify</h3>\n<div class=\"space16\"></div>\n<p>\"Eventify 2024 is the ultimate destination for professionals eager to stay ahead in the evolving business landscape. This event brings together to innovators, meetup industry leaders, and experts to explore the future of business strategy technology.</p>\n<div class=\"space32\"></div>\n','published',1,'Botble\\ACL\\Models\\User',0,'main/blogs/20.jpg',165,NULL,'2025-06-10 10:38:20','2025-06-10 10:38:20');
/*!40000 ALTER TABLE `posts` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `posts_translations`
--

DROP TABLE IF EXISTS `posts_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `posts_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `posts_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` longtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`lang_code`,`posts_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `posts_translations`
--

LOCK TABLES `posts_translations` WRITE;
/*!40000 ALTER TABLE `posts_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `posts_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `revisions`
--

DROP TABLE IF EXISTS `revisions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `revisions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `revisionable_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `revisionable_id` bigint unsigned NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `old_value` text COLLATE utf8mb4_unicode_ci,
  `new_value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `revisions_revisionable_id_revisionable_type_index` (`revisionable_id`,`revisionable_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `revisions`
--

LOCK TABLES `revisions` WRITE;
/*!40000 ALTER TABLE `revisions` DISABLE KEYS */;
/*!40000 ALTER TABLE `revisions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `role_users`
--

DROP TABLE IF EXISTS `role_users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `role_users` (
  `user_id` bigint unsigned NOT NULL,
  `role_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`user_id`,`role_id`),
  KEY `role_users_user_id_index` (`user_id`),
  KEY `role_users_role_id_index` (`role_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `role_users`
--

LOCK TABLES `role_users` WRITE;
/*!40000 ALTER TABLE `role_users` DISABLE KEYS */;
/*!40000 ALTER TABLE `role_users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `roles`
--

DROP TABLE IF EXISTS `roles`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `roles` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `created_by` bigint unsigned NOT NULL,
  `updated_by` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `roles_slug_unique` (`slug`),
  KEY `roles_created_by_index` (`created_by`),
  KEY `roles_updated_by_index` (`updated_by`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `roles`
--

LOCK TABLES `roles` WRITE;
/*!40000 ALTER TABLE `roles` DISABLE KEYS */;
INSERT INTO `roles` VALUES (1,'admin','Admin','{\"users.index\":true,\"users.create\":true,\"users.edit\":true,\"users.destroy\":true,\"roles.index\":true,\"roles.create\":true,\"roles.edit\":true,\"roles.destroy\":true,\"core.system\":true,\"core.cms\":true,\"core.manage.license\":true,\"systems.cronjob\":true,\"core.tools\":true,\"tools.data-synchronize\":true,\"media.index\":true,\"files.index\":true,\"files.create\":true,\"files.edit\":true,\"files.trash\":true,\"files.destroy\":true,\"folders.index\":true,\"folders.create\":true,\"folders.edit\":true,\"folders.trash\":true,\"folders.destroy\":true,\"settings.index\":true,\"settings.common\":true,\"settings.options\":true,\"settings.email\":true,\"settings.media\":true,\"settings.admin-appearance\":true,\"settings.cache\":true,\"settings.datatables\":true,\"settings.email.rules\":true,\"settings.others\":true,\"menus.index\":true,\"menus.create\":true,\"menus.edit\":true,\"menus.destroy\":true,\"optimize.settings\":true,\"pages.index\":true,\"pages.create\":true,\"pages.edit\":true,\"pages.destroy\":true,\"plugins.index\":true,\"plugins.edit\":true,\"plugins.remove\":true,\"plugins.marketplace\":true,\"sitemap.settings\":true,\"core.appearance\":true,\"theme.index\":true,\"theme.activate\":true,\"theme.remove\":true,\"theme.options\":true,\"theme.custom-css\":true,\"theme.custom-js\":true,\"theme.custom-html\":true,\"theme.robots-txt\":true,\"settings.website-tracking\":true,\"widgets.index\":true,\"ads.index\":true,\"ads.create\":true,\"ads.edit\":true,\"ads.destroy\":true,\"ads.settings\":true,\"analytics.general\":true,\"analytics.page\":true,\"analytics.browser\":true,\"analytics.referrer\":true,\"analytics.settings\":true,\"announcements.index\":true,\"announcements.create\":true,\"announcements.edit\":true,\"announcements.destroy\":true,\"announcements.settings\":true,\"audit-log.index\":true,\"audit-log.destroy\":true,\"backups.index\":true,\"backups.create\":true,\"backups.restore\":true,\"backups.destroy\":true,\"plugins.blog\":true,\"posts.index\":true,\"posts.create\":true,\"posts.edit\":true,\"posts.destroy\":true,\"categories.index\":true,\"categories.create\":true,\"categories.edit\":true,\"categories.destroy\":true,\"tags.index\":true,\"tags.create\":true,\"tags.edit\":true,\"tags.destroy\":true,\"blog.settings\":true,\"posts.export\":true,\"posts.import\":true,\"captcha.settings\":true,\"contacts.index\":true,\"contacts.edit\":true,\"contacts.destroy\":true,\"contact.custom-fields\":true,\"contact.settings\":true,\"events-booking.index\":true,\"events-booking.events.index\":true,\"events-booking.events.create\":true,\"events-booking.events.edit\":true,\"events-booking.events.destroy\":true,\"events-booking.tickets.index\":true,\"events-booking.attendees.export\":true,\"events-booking.attendees.import\":true,\"events-booking.accounts.create\":true,\"events-booking.accounts.edit\":true,\"events-booking.accounts.destroy\":true,\"events-booking.accounts.export\":true,\"events-booking.accounts.import\":true,\"events-booking.booking.reports.index\":true,\"events-booking.taxes.index\":true,\"events-booking.taxes.create\":true,\"events-booking.taxes.edit\":true,\"events-booking.taxes.destroy\":true,\"events-booking.coupons.index\":true,\"events-booking.coupons.create\":true,\"events-booking.coupons.edit\":true,\"events-booking.coupons.destroy\":true,\"plugin.faq\":true,\"faq.index\":true,\"faq.create\":true,\"faq.edit\":true,\"faq.destroy\":true,\"faq_category.index\":true,\"faq_category.create\":true,\"faq_category.edit\":true,\"faq_category.destroy\":true,\"faqs.settings\":true,\"galleries.index\":true,\"galleries.create\":true,\"galleries.edit\":true,\"galleries.destroy\":true,\"languages.index\":true,\"languages.create\":true,\"languages.edit\":true,\"languages.destroy\":true,\"translations.import\":true,\"translations.export\":true,\"property-translations.import\":true,\"property-translations.export\":true,\"plugin.location\":true,\"country.index\":true,\"country.create\":true,\"country.edit\":true,\"country.destroy\":true,\"state.index\":true,\"state.create\":true,\"state.edit\":true,\"state.destroy\":true,\"city.index\":true,\"city.create\":true,\"city.edit\":true,\"city.destroy\":true,\"newsletter.index\":true,\"newsletter.destroy\":true,\"newsletter.settings\":true,\"payment.index\":true,\"payments.settings\":true,\"payment.destroy\":true,\"payments.logs\":true,\"payments.logs.show\":true,\"payments.logs.destroy\":true,\"simple-slider.index\":true,\"simple-slider.create\":true,\"simple-slider.edit\":true,\"simple-slider.destroy\":true,\"simple-slider-item.index\":true,\"simple-slider-item.create\":true,\"simple-slider-item.edit\":true,\"simple-slider-item.destroy\":true,\"simple-slider.settings\":true,\"social-login.settings\":true,\"testimonial.index\":true,\"testimonial.create\":true,\"testimonial.edit\":true,\"testimonial.destroy\":true,\"plugins.translation\":true,\"translations.locales\":true,\"translations.theme-translations\":true,\"translations.index\":true,\"theme-translations.export\":true,\"other-translations.export\":true,\"theme-translations.import\":true,\"other-translations.import\":true,\"api.settings\":true,\"api.sanctum-token.index\":true,\"api.sanctum-token.create\":true,\"api.sanctum-token.destroy\":true}','Admin users role',1,1,1,'2025-06-10 10:37:53','2025-06-10 10:37:53');
/*!40000 ALTER TABLE `roles` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `sessions`
--

DROP TABLE IF EXISTS `sessions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `sessions` (
  `id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned DEFAULT NULL,
  `ip_address` varchar(45) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `user_agent` text COLLATE utf8mb4_unicode_ci,
  `payload` longtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `last_activity` int NOT NULL,
  PRIMARY KEY (`id`),
  KEY `sessions_user_id_index` (`user_id`),
  KEY `sessions_last_activity_index` (`last_activity`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `sessions`
--

LOCK TABLES `sessions` WRITE;
/*!40000 ALTER TABLE `sessions` DISABLE KEYS */;
/*!40000 ALTER TABLE `sessions` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `settings`
--

DROP TABLE IF EXISTS `settings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `settings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `settings_key_unique` (`key`)
) ENGINE=InnoDB AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `settings`
--

LOCK TABLES `settings` WRITE;
/*!40000 ALTER TABLE `settings` DISABLE KEYS */;
INSERT INTO `settings` VALUES (2,'api_enabled','0',NULL,'2025-06-10 10:38:47'),(3,'activated_plugins','[\"language\",\"language-advanced\",\"ads\",\"analytics\",\"announcement\",\"audit-log\",\"backup\",\"blog\",\"captcha\",\"contact\",\"cookie-consent\",\"events-booking\",\"faq\",\"gallery\",\"location\",\"newsletter\",\"note\",\"payment\",\"paypal\",\"paystack\",\"razorpay\",\"rss-feed\",\"simple-slider\",\"social-login\",\"sslcommerz\",\"stripe\",\"testimonial\",\"translation\"]',NULL,'2025-06-10 10:38:47'),(6,'language_hide_default','1',NULL,'2025-06-10 10:38:47'),(7,'language_switcher_display','dropdown',NULL,'2025-06-10 10:38:47'),(8,'language_display','all',NULL,'2025-06-10 10:38:47'),(9,'language_hide_languages','[]',NULL,'2025-06-10 10:38:47'),(10,'media_random_hash','ce162bb52c548f07bbf658c8671c11c6',NULL,'2025-06-10 10:38:47'),(11,'theme','eventify',NULL,'2025-06-10 10:38:47'),(12,'show_admin_bar','1',NULL,'2025-06-10 10:38:47'),(13,'admin_favicon','main/general/favicon.png',NULL,'2025-06-10 10:38:47'),(14,'admin_logo','main/general/logo.png',NULL,'2025-06-10 10:38:47'),(15,'permalink-botble-blog-models-post','blog',NULL,'2025-06-10 10:38:47'),(16,'permalink-botble-blog-models-category','blog',NULL,'2025-06-10 10:38:47'),(17,'payment_cod_status','1',NULL,'2025-06-10 10:38:47'),(18,'payment_cod_description','Please pay money directly to the postman, if you choose cash on delivery method (COD).',NULL,'2025-06-10 10:38:47'),(19,'payment_bank_transfer_status','1',NULL,'2025-06-10 10:38:47'),(20,'payment_bank_transfer_description','Please send money to our bank account: ACB - 69270 213 19.',NULL,'2025-06-10 10:38:47'),(21,'payment_stripe_payment_type','stripe_checkout',NULL,'2025-06-10 10:38:47'),(22,'events_booking_company_name_for_invoicing','ArchiElite',NULL,'2025-06-10 10:38:47'),(23,'events_booking_company_address_for_invoicing','123 Street, New York, USA',NULL,'2025-06-10 10:38:47'),(24,'events_booking_company_country_for_invoicing','US',NULL,'2025-06-10 10:38:47'),(25,'events_booking_company_state_for_invoicing','NY',NULL,'2025-06-10 10:38:47'),(26,'events_booking_company_city_for_invoicing','New York',NULL,'2025-06-10 10:38:47'),(27,'events_booking_company_email_for_invoicing','company@example.com',NULL,'2025-06-10 10:38:47'),(28,'events_booking_company_phone_for_invoicing','123456789',NULL,'2025-06-10 10:38:47'),(29,'events_booking_company_logo_for_invoicing','main/general/logo-light.png',NULL,'2025-06-10 10:38:47'),(30,'theme-eventify-site_title','Eventify - Event And Conference Laravel Script',NULL,'2025-06-10 10:38:47'),(31,'theme-eventify-seo_description','Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',NULL,'2025-06-10 10:38:47'),(32,'theme-eventify-copyright','©%Y Archi Elite Team. All Rights Reserved.',NULL,'2025-06-10 10:38:47'),(33,'theme-eventify-favicon','main/general/favicon.png',NULL,'2025-06-10 10:38:47'),(34,'theme-eventify-logo','main/general/logo.png',NULL,'2025-06-10 10:38:47'),(35,'theme-eventify-homepage_id','1',NULL,'2025-06-10 10:38:47'),(36,'theme-eventify-blog_page_id','4',NULL,'2025-06-10 10:38:47'),(37,'theme-eventify-blog_post_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:38:47'),(38,'theme-eventify-blog_post_detail_meta_display','[\"author_name\",\"published_date\"]',NULL,'2025-06-10 10:38:47'),(39,'theme-eventify-blog_post_items_per_row','3',NULL,'2025-06-10 10:38:47'),(40,'theme-eventify-number_of_related_posts','3',NULL,'2025-06-10 10:38:47'),(41,'theme-eventify-breadcrumb_background_image','main/backgrounds/image-1.jpg',NULL,'2025-06-10 10:38:47'),(42,'theme-eventify-breadcrumb_text_color','#ffffff',NULL,'2025-06-10 10:38:47'),(43,'theme-eventify-events_page_id','5',NULL,'2025-06-10 10:38:47'),(44,'theme-eventify-event_list_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:38:47'),(45,'theme-eventify-event_detail_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:38:47'),(46,'theme-eventify-event_list_widget_meta_display','[\"date_time\", \"organizer_name\", \"organizer_title\", \"organizer_image\"]',NULL,'2025-06-10 10:38:47'),(47,'theme-eventify-event_list_title','Event History Kireon Pollardy',NULL,'2025-06-10 10:38:47'),(48,'theme-eventify-event_list_widget_date_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:38:47'),(49,'theme-eventify-calender_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:38:47'),(50,'theme-eventify-author_icon_image','main/icons/user.png',NULL,'2025-06-10 10:38:47'),(51,'theme-eventify-views_icon_image','main/icons/view.png',NULL,'2025-06-10 10:38:47'),(52,'theme-eventify-reading_time_icon_image','main/icons/clock.png',NULL,'2025-06-10 10:38:47'),(53,'theme-eventify-category_icon_image','main/icons/menu.png',NULL,'2025-06-10 10:38:47'),(54,'theme-eventify-published_icon_image','main/icons/calendar.png',NULL,'2025-06-10 10:38:47'),(55,'theme-eventify-social_links','[[{\"key\":\"name\",\"value\":\"Facebook\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-facebook\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.facebook.com\"}],[{\"key\":\"name\",\"value\":\"X (Twitter)\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-x\"},{\"key\":\"url\",\"value\":\"https:\\/\\/x.com\"}],[{\"key\":\"name\",\"value\":\"YouTube\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-youtube\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.youtube.com\"}],[{\"key\":\"name\",\"value\":\"Instagram\"},{\"key\":\"icon\",\"value\":\"ti ti-brand-linkedin\"},{\"key\":\"url\",\"value\":\"https:\\/\\/www.linkedin.com\"}]]',NULL,'2025-06-10 10:38:47'),(56,'theme-eventify-logo_height','45',NULL,'2025-06-10 10:38:47'),(57,'theme-eventify-is_header_transparent','1',NULL,'2025-06-10 10:38:47'),(58,'theme-eventify-display_header_top','1',NULL,'2025-06-10 10:38:47'),(59,'theme-eventify-header_top_text_color','#000000',NULL,'2025-06-10 10:38:47'),(60,'theme-eventify-header_top_background_color','#FFBA00',NULL,'2025-06-10 10:38:47'),(61,'theme-eventify-header_background_color','#1A1719',NULL,'2025-06-10 10:38:47'),(62,'theme-eventify-header_text_color','#ffffff',NULL,'2025-06-10 10:38:47'),(63,'theme-eventify-footer_background_color','#FBF9F4',NULL,'2025-06-10 10:38:47'),(64,'theme-eventify-footer_text_color','#544E51',NULL,'2025-06-10 10:38:47'),(65,'theme-eventify-footer_heading_color','#1A1719',NULL,'2025-06-10 10:38:47'),(66,'theme-eventify-tp_primary_font','Figtree',NULL,'2025-06-10 10:38:47'),(67,'theme-eventify-tp_heading_font','Space Grotesk',NULL,'2025-06-10 10:38:47'),(68,'theme-eventify-primary_color','#FFBA00',NULL,'2025-06-10 10:38:47'),(69,'theme-eventify-secondary_color','#1A1719',NULL,'2025-06-10 10:38:47'),(70,'theme-eventify-newsletter_popup_enable','1',NULL,'2025-06-10 10:38:47'),(71,'theme-eventify-newsletter_popup_image','main/backgrounds/newsletter-bg.jpg',NULL,'2025-06-10 10:38:47'),(72,'theme-eventify-newsletter_popup_title','HOT DEALS',NULL,'2025-06-10 10:38:47'),(73,'theme-eventify-newsletter_popup_description','Promo Booking Hub - Discover and Book Exclusive Event Deals!',NULL,'2025-06-10 10:38:47'),(74,'theme-eventify-term_and_privacy_policy_url','/privacy-policy',NULL,'2025-06-10 10:38:47'),(75,'announcement_max_width','1210',NULL,'2025-06-10 10:38:47'),(76,'announcement_text_color','#000000',NULL,'2025-06-10 10:38:47'),(77,'announcement_background_color','transparent',NULL,'2025-06-10 10:38:47'),(78,'announcement_text_alignment','start',NULL,'2025-06-10 10:38:47'),(79,'announcement_dismissible','0',NULL,'2025-06-10 10:38:47'),(80,'announcement_font_size','14',NULL,'2025-06-10 10:38:47'),(81,'announcement_font_size_unit','px',NULL,'2025-06-10 10:38:47'),(82,'announcement_placement','theme',NULL,'2025-06-10 10:38:47'),(83,'simple_slider_using_assets','0',NULL,NULL);
/*!40000 ALTER TABLE `settings` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_slider_items`
--

DROP TABLE IF EXISTS `simple_slider_items`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_slider_items` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `simple_slider_id` bigint unsigned NOT NULL,
  `title` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `link` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `order` int unsigned NOT NULL DEFAULT '0',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_slider_items`
--

LOCK TABLES `simple_slider_items` WRITE;
/*!40000 ALTER TABLE `simple_slider_items` DISABLE KEYS */;
INSERT INTO `simple_slider_items` VALUES (1,1,'Yearly Business','main/sliders/1.png','/',NULL,0,'2025-06-10 10:38:47','2025-06-10 10:38:47'),(2,1,'Yearly Business','main/sliders/2.png','/',NULL,1,'2025-06-10 10:38:47','2025-06-10 10:38:47'),(3,1,'Yearly Business','main/sliders/3.png','/',NULL,2,'2025-06-10 10:38:47','2025-06-10 10:38:47');
/*!40000 ALTER TABLE `simple_slider_items` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `simple_sliders`
--

DROP TABLE IF EXISTS `simple_sliders`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `simple_sliders` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `simple_sliders`
--

LOCK TABLES `simple_sliders` WRITE;
/*!40000 ALTER TABLE `simple_sliders` DISABLE KEYS */;
INSERT INTO `simple_sliders` VALUES (1,'Home slider','home-slider','The main slider on homepage','published','2025-06-10 10:38:47','2025-06-10 10:38:47');
/*!40000 ALTER TABLE `simple_sliders` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs`
--

DROP TABLE IF EXISTS `slugs`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `reference_id` bigint unsigned NOT NULL,
  `reference_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `slugs_reference_id_index` (`reference_id`),
  KEY `slugs_key_index` (`key`),
  KEY `slugs_prefix_index` (`prefix`),
  KEY `slugs_reference_index` (`reference_id`,`reference_type`)
) ENGINE=InnoDB AUTO_INCREMENT=121 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs`
--

LOCK TABLES `slugs` WRITE;
/*!40000 ALTER TABLE `slugs` DISABLE KEYS */;
INSERT INTO `slugs` VALUES (1,'sunset',1,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(2,'ocean-views',2,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(3,'adventure-time',3,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(4,'city-lights',4,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(5,'dreamscape',5,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(6,'enchanted-forest',6,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(7,'golden-hour',7,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(8,'serenity',8,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(9,'eternal-beauty',9,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(10,'moonlight-magic',10,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(11,'starry-night',11,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(12,'hidden-gems',12,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(13,'tranquil-waters',13,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(14,'urban-escape',14,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(15,'twilight-zone',15,'Botble\\Gallery\\Models\\Gallery','galleries','2025-06-10 10:37:53','2025-06-10 10:37:53'),(16,'homepage',1,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(17,'about-us',2,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(18,'speakers',3,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(19,'blog',4,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(20,'events',5,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(21,'pricing-plan',6,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(22,'contact-us',7,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(23,'faqs',8,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(24,'privacy-policy',9,'Botble\\Page\\Models\\Page','','2025-06-10 10:38:12','2025-06-10 10:38:12'),(25,'business-innovation',1,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(26,'leadership-strategy',2,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(27,'networking-collaboration',3,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(28,'entrepreneurship-startups',4,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(29,'marketing-branding',5,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(30,'event-highlights-recaps',6,'Botble\\Blog\\Models\\Category','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(31,'conferences',1,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(32,'meetup',2,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(33,'event',3,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(34,'eventify2024',4,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(35,'digitaltransformation',5,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(36,'businessleadership',6,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(37,'industrytrends',7,'Botble\\Blog\\Models\\Tag','tag','2025-06-10 10:38:19','2025-06-10 10:38:19'),(38,'breakthrough-in-quantum-computing-computing-power-reaches-milestone',1,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(39,'5g-rollout-accelerates-next-gen-connectivity-transforms-communication',2,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(40,'tech-giants-collaborate-on-open-source-ai-framework',3,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(41,'spacex-launches-mission-to-establish-first-human-colony-on-mars',4,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(42,'cybersecurity-advances-new-protocols-bolster-digital-defense',5,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(43,'artificial-intelligence-in-healthcare-transformative-solutions-for-patient-care',6,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(44,'robotic-innovations-autonomous-systems-reshape-industries',7,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(45,'virtual-reality-breakthrough-immersive-experiences-redefine-entertainment',8,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(46,'innovative-wearables-track-health-metrics-and-enhance-well-being',9,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:19','2025-06-10 10:38:19'),(47,'tech-for-good-startups-develop-solutions-for-social-and-environmental-issues',10,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(48,'ai-powered-personal-assistants-evolve-enhancing-productivity-and-convenience',11,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(49,'blockchain-innovation-decentralized-finance-defi-reshapes-finance-industry',12,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(50,'quantum-internet-secure-communication-enters-a-new-era',13,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(51,'drone-technology-advances-applications-expand-across-industries',14,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(52,'biotechnology-breakthrough-crispr-cas9-enables-precision-gene-editing',15,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(53,'augmented-reality-in-education-interactive-learning-experiences-for-students',16,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(54,'ai-in-autonomous-vehicles-advancements-in-self-driving-car-technology',17,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(55,'green-tech-innovations-sustainable-solutions-for-a-greener-future',18,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(56,'space-tourism-soars-commercial-companies-make-strides-in-space-travel',19,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(57,'humanoid-robots-in-everyday-life-ai-companions-and-assistants',20,'Botble\\Blog\\Models\\Post','blog','2025-06-10 10:38:20','2025-06-10 10:38:20'),(58,'michael-smith',2,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:25','2025-06-10 10:38:25'),(59,'wilfrid-bruen',4,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:25','2025-06-10 10:38:25'),(60,'prof-ben-schiller-ii',5,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:25','2025-06-10 10:38:25'),(61,'dr-lorine-christiansen',6,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:26','2025-06-10 10:38:26'),(62,'sherman-konopelski',7,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:26','2025-06-10 10:38:26'),(63,'mrs-abagail-smitham',8,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:26','2025-06-10 10:38:26'),(64,'stan-cummerata-i',9,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:26','2025-06-10 10:38:26'),(65,'prof-orin-tremblay',11,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:27','2025-06-10 10:38:27'),(66,'may-heaney',12,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:27','2025-06-10 10:38:27'),(67,'gerhard-mosciski',13,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:27','2025-06-10 10:38:27'),(68,'juana-purdy',14,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:27','2025-06-10 10:38:27'),(69,'edison-raynor',15,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:28','2025-06-10 10:38:28'),(70,'dr-kennedi-kemmer',16,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:28','2025-06-10 10:38:28'),(71,'trudie-cassin',18,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:28','2025-06-10 10:38:28'),(72,'reinhold-harber',20,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:28','2025-06-10 10:38:28'),(73,'ashleigh-will',21,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:29','2025-06-10 10:38:29'),(74,'asia-metz',23,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:29','2025-06-10 10:38:29'),(75,'prof-yasmine-trantow',24,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:29','2025-06-10 10:38:29'),(76,'howard-runte-jr',25,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:29','2025-06-10 10:38:29'),(77,'lera-olson',28,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:30','2025-06-10 10:38:30'),(78,'kenyon-stokes',31,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:31','2025-06-10 10:38:31'),(79,'ces-consumer-electronics-show',1,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(80,'mobile-world-congress',2,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(81,'google-io',3,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(82,'apple-wwdc',4,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(83,'aws-reinvent',5,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(84,'microsoft-build',6,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(85,'facebook-f8',7,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(86,'github-universe',8,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(87,'game-developers-conference',9,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(88,'web-summit',10,'ArchiElite\\EventsBooking\\Models\\Event','events','2025-06-10 10:38:38','2025-06-10 10:38:38'),(89,'joyce-lemke',1,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(90,'desmond-tillman',3,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(91,'trystan-bechtelar',10,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(92,'kayley-watsica',17,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(93,'dalton-okuneva',19,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(94,'juliet-steuber-ii',22,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(95,'randall-koch-ii',26,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(96,'melyna-simonis',27,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(97,'prof-lee-emmerich-i',29,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(98,'alexzander-zemlak',30,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(99,'ford-gusikowski',32,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(100,'salvatore-swift-dvm',33,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(101,'lenora-heaney-md',34,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(102,'destini-lindgren',35,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(103,'winnifred-boehm',36,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(104,'wendell-goodwin-dvm',37,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(105,'sylvan-rodriguez',38,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(106,'mr-riley-gerhold',39,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(107,'mr-eladio-bradtke',40,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(108,'layne-hermiston',41,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(109,'miss-matilda-kuhic-ii',42,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(110,'otho-hauck',43,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(111,'prof-coleman-harvey-sr',44,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(112,'ms-aylin-nitzsche',45,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(113,'dr-nash-kunde',46,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:47','2025-06-10 10:38:47'),(114,'isabella-lockman',47,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(115,'flo-brekke',48,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(116,'estel-flatley',49,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(117,'mrs-alison-monahan',50,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(118,'randy-gulgowski',51,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(119,'luigi-kris',52,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48'),(120,'jarvis-west',53,'ArchiElite\\EventsBooking\\Models\\Account','speakers','2025-06-10 10:38:48','2025-06-10 10:38:48');
/*!40000 ALTER TABLE `slugs` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `slugs_translations`
--

DROP TABLE IF EXISTS `slugs_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `slugs_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slugs_id` bigint unsigned NOT NULL,
  `key` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `prefix` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT '',
  PRIMARY KEY (`lang_code`,`slugs_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `slugs_translations`
--

LOCK TABLES `slugs_translations` WRITE;
/*!40000 ALTER TABLE `slugs_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `slugs_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `social_logins`
--

DROP TABLE IF EXISTS `social_logins`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `social_logins` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `user_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` bigint unsigned NOT NULL,
  `provider` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `provider_id` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `token` text COLLATE utf8mb4_unicode_ci,
  `refresh_token` text COLLATE utf8mb4_unicode_ci,
  `token_expires_at` timestamp NULL DEFAULT NULL,
  `provider_data` json DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `social_logins_provider_provider_id_unique` (`provider`,`provider_id`),
  KEY `social_logins_user_type_user_id_index` (`user_type`,`user_id`),
  KEY `social_logins_user_id_user_type_index` (`user_id`,`user_type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `social_logins`
--

LOCK TABLES `social_logins` WRITE;
/*!40000 ALTER TABLE `social_logins` DISABLE KEYS */;
/*!40000 ALTER TABLE `social_logins` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states`
--

DROP TABLE IF EXISTS `states`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country_id` bigint unsigned DEFAULT NULL,
  `order` tinyint NOT NULL DEFAULT '0',
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `is_default` tinyint unsigned NOT NULL DEFAULT '0',
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `states_slug_unique` (`slug`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states`
--

LOCK TABLES `states` WRITE;
/*!40000 ALTER TABLE `states` DISABLE KEYS */;
INSERT INTO `states` VALUES (1,'France','france','FR',1,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(2,'England','england','EN',2,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(3,'New York','new-york','NY',1,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(4,'Holland','holland','HL',4,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(5,'Denmark','denmark','DN',5,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31'),(6,'Germany','germany','GER',1,0,NULL,0,'published','2025-06-10 10:38:31','2025-06-10 10:38:31');
/*!40000 ALTER TABLE `states` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `states_translations`
--

DROP TABLE IF EXISTS `states_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `states_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `states_id` bigint unsigned NOT NULL,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `slug` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `abbreviation` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`states_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `states_translations`
--

LOCK TABLES `states_translations` WRITE;
/*!40000 ALTER TABLE `states_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `states_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags`
--

DROP TABLE IF EXISTS `tags`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `author_id` bigint unsigned DEFAULT NULL,
  `author_type` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags`
--

LOCK TABLES `tags` WRITE;
/*!40000 ALTER TABLE `tags` DISABLE KEYS */;
INSERT INTO `tags` VALUES (1,'Conferences',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(2,'Meetup',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(3,'Event',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(4,'Eventify2024',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(5,'DigitalTransformation',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(6,'BusinessLeadership',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19'),(7,'IndustryTrends',1,'Botble\\ACL\\Models\\User',NULL,'published','2025-06-10 10:38:19','2025-06-10 10:38:19');
/*!40000 ALTER TABLE `tags` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `tags_translations`
--

DROP TABLE IF EXISTS `tags_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `tags_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `tags_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`tags_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `tags_translations`
--

LOCK TABLES `tags_translations` WRITE;
/*!40000 ALTER TABLE `tags_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `tags_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials`
--

DROP TABLE IF EXISTS `testimonials`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `content` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `image` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `status` varchar(60) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'published',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials`
--

LOCK TABLES `testimonials` WRITE;
/*!40000 ALTER TABLE `testimonials` DISABLE KEYS */;
INSERT INTO `testimonials` VALUES (1,'Guy Hawkins','Exceptional service! Gerow’s attention to detail and reliability have been instrumental in our supply chain success.','main/testimonials/1.png','CEO, JAKS Shans','published','2025-06-10 10:37:54','2025-06-10 10:37:54'),(2,'Eleanor Pena','Gerow has consistently met and exceeded our logistics needs. Their dedication to excellence is truly commendable.','main/testimonials/2.png','SEO, ChenTech Solutions','published','2025-06-10 10:37:54','2025-06-10 10:37:54'),(3,'Cody Fisher','Their team is a valuable asset to our business operations. Gerow’s efficient service has saved us time and money.','main/testimonials/3.png','Developer, Moie Agency','published','2025-06-10 10:37:55','2025-06-10 10:37:55'),(4,'Albert Flores','Gerow’s attention to detail and professionalism have made them our preferred logistics partner. Highly recommended!','main/testimonials/4.png','CEO, Bank of America','published','2025-06-10 10:37:55','2025-06-10 10:37:55');
/*!40000 ALTER TABLE `testimonials` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `testimonials_translations`
--

DROP TABLE IF EXISTS `testimonials_translations`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `testimonials_translations` (
  `lang_code` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `testimonials_id` bigint unsigned NOT NULL,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `content` text COLLATE utf8mb4_unicode_ci,
  `company` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`lang_code`,`testimonials_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `testimonials_translations`
--

LOCK TABLES `testimonials_translations` WRITE;
/*!40000 ALTER TABLE `testimonials_translations` DISABLE KEYS */;
/*!40000 ALTER TABLE `testimonials_translations` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `user_meta`
--

DROP TABLE IF EXISTS `user_meta`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `user_meta` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `key` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `value` text COLLATE utf8mb4_unicode_ci,
  `user_id` bigint unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_meta_user_id_index` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `user_meta`
--

LOCK TABLES `user_meta` WRITE;
/*!40000 ALTER TABLE `user_meta` DISABLE KEYS */;
/*!40000 ALTER TABLE `user_meta` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `users`
--

DROP TABLE IF EXISTS `users`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `users` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `email` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `email_verified_at` timestamp NULL DEFAULT NULL,
  `password` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `remember_token` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `first_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `last_name` varchar(120) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `username` varchar(60) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `avatar_id` bigint unsigned DEFAULT NULL,
  `super_user` tinyint(1) NOT NULL DEFAULT '0',
  `manage_supers` tinyint(1) NOT NULL DEFAULT '0',
  `permissions` text COLLATE utf8mb4_unicode_ci,
  `last_login` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `users_email_unique` (`email`),
  UNIQUE KEY `users_username_unique` (`username`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `users`
--

LOCK TABLES `users` WRITE;
/*!40000 ALTER TABLE `users` DISABLE KEYS */;
INSERT INTO `users` VALUES (1,'lisette56@ritchie.org',NULL,'$2y$12$Wzh8ZU15YLgYsBKA8.ohJObqgsE0rKbJ1E5eGzZ47wXG4i6HvG9c2',NULL,'2025-06-10 10:37:53','2025-06-10 10:37:53','Alexandria','Jakubowski','admin',NULL,1,1,NULL,NULL);
/*!40000 ALTER TABLE `users` ENABLE KEYS */;
UNLOCK TABLES;

--
-- Table structure for table `widgets`
--

DROP TABLE IF EXISTS `widgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `widgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `widget_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sidebar_id` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `theme` varchar(120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `position` tinyint unsigned NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `widgets`
--

LOCK TABLES `widgets` WRITE;
/*!40000 ALTER TABLE `widgets` DISABLE KEYS */;
INSERT INTO `widgets` VALUES (1,'SearchActionButtonWidget','header_sidebar','eventify',1,'[]','2025-06-10 10:38:12','2025-06-10 10:38:12'),(2,'SocialLinksWidget','header_sidebar','eventify',2,'[]','2025-06-10 10:38:12','2025-06-10 10:38:12'),(3,'SiteInformationWidget','footer_sidebar','eventify',1,'{\"id\":\"SiteInformationWidget\",\"description\":\"We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas\",\"is_enabled_social_links\":true,\"logo\":\"main\\/general\\/logo-light.png\"}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(4,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify',2,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Quick Links\",\"items\":[[{\"key\":\"label\",\"value\":\"About Us\"},{\"key\":\"url\",\"value\":\"\\/about-us\"}],[{\"key\":\"label\",\"value\":\"Our Blog\"},{\"key\":\"url\",\"value\":\"\\/blog\"}],[{\"key\":\"label\",\"value\":\"Event Listing\"},{\"key\":\"url\",\"value\":\"\\/events\"}],[{\"key\":\"label\",\"value\":\"Pricing Plan\"},{\"key\":\"url\",\"value\":\"\\/pricing-plan\"}],[{\"key\":\"label\",\"value\":\"Contact Us\"},{\"key\":\"url\",\"value\":\"\\/contact-us\"}]]}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(5,'Botble\\Widget\\Widgets\\CoreSimpleMenu','footer_sidebar','eventify',3,'{\"id\":\"Botble\\\\Widget\\\\Widgets\\\\CoreSimpleMenu\",\"name\":\"Contact Us\",\"items\":[[{\"key\":\"label\",\"value\":\"+1 123 456 7890\"},{\"key\":\"url\",\"value\":\"tel:+1 123 456 7890\"},{\"key\":\"icon\",\"value\":\"ti ti-phone-call\"}],[{\"key\":\"label\",\"value\":\"Secret Location In The UK\"},{\"key\":\"url\",\"value\":\"\\/\"},{\"key\":\"icon\",\"value\":\"ti ti-map-pin\"}],[{\"key\":\"label\",\"value\":\"eventifyevent@gmail.com\"},{\"key\":\"url\",\"value\":\"mailto:eventifyevent@gmail.com\"},{\"key\":\"icon\",\"value\":\"ti ti-mail\"}],[{\"key\":\"label\",\"value\":\"eventify.archielite.com\"},{\"key\":\"url\",\"value\":\"https:\\/\\/eventify.archielite.com\"},{\"key\":\"icon\",\"value\":\"ti ti-world\"}]]}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(6,'GalleriesWidget','footer_sidebar','eventify',4,'{\"id\":\"GalleriesWidget\",\"title\":\"Our Recent Event Gallery\",\"limit\":6}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(7,'EventListWidget','event_list_sidebar','eventify',1,'{\"id\":\"EventListWidget\",\"title\":\"View More Event\",\"number_of_days\":3}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(8,'SiteCopyrightWidget','bottom_footer_sidebar','eventify',1,'[]','2025-06-10 10:38:12','2025-06-10 10:38:12'),(9,'BlogSearchWidget','blog_sidebar','eventify',1,'{\"id\":\"BlogSearchWidget\",\"title\":\"Search\",\"placeholder\":\"Search...\"}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(10,'BlogCategoriesWidget','blog_sidebar','eventify',2,'{\"id\":\"BlogCategoriesWidget\",\"title\":\"Blog Category\",\"category_ids\":[1,2,3,4]}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(11,'BlogTagsWidget','blog_sidebar','eventify',3,'{\"id\":\"BlogTagsWidget\",\"title\":\"Popular Hastag\",\"tag_ids\":[1,2,3,4,5,6,7]}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(12,'UpcomingEventWidget','pre_footer_sidebar','eventify',1,'{\"background_color\":\"#FFBA00\",\"button_label\":\"Buy Ticket\"}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(13,'ContactInformationWidget','off_canvas_sidebar','eventify',1,'{\"id\":\"ContactInformationWidget\",\"title\":\"Contact Info\",\"quantity\":3,\"title_1\":\"+3(924)4596512\",\"icon_1\":\"ti ti-phone-call\",\"url_1\":\"tel:39244596512\",\"title_2\":\"info@example.com\",\"icon_2\":\"ti ti-mail\",\"url_2\":\"mailto:info@example.com\",\"icon_3\":\"ti ti-map-pin\",\"title_3\":\"55 East Birchwood Ave.Brooklyn, NY 11234\"}','2025-06-10 10:38:12','2025-06-10 10:38:12'),(14,'SocialLinksWidget','off_canvas_sidebar','eventify',2,'{\"id\":\"SocialLinksWidget\",\"title\":\"Social Links\"}','2025-06-10 10:38:12','2025-06-10 10:38:12');
/*!40000 ALTER TABLE `widgets` ENABLE KEYS */;
UNLOCK TABLES;
/*!40103 SET TIME_ZONE=@OLD_TIME_ZONE */;

/*!40101 SET SQL_MODE=@OLD_SQL_MODE */;
/*!40014 SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS */;
/*!40014 SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40101 SET CHARACTER_SET_RESULTS=@OLD_CHARACTER_SET_RESULTS */;
/*!40101 SET COLLATION_CONNECTION=@OLD_COLLATION_CONNECTION */;
/*!40111 SET SQL_NOTES=@OLD_SQL_NOTES */;

-- Dump completed on 2025-06-10 17:38:49
