<?php

namespace Database\Seeders\Themes\Homepage02;

use ArchiElite\EventsBooking\Models\Account;
use Database\Seeders\Themes\Main\AccountSeeder as MainAccountSeeder;

class AccountSeeder extends MainAccountSeeder
{
    public function run(): void
    {
        $this->uploadFiles('speakers', 'homepage02');

        parent::run();
    }

    public function updateAvatar(Account $account): void
    {
        $account->update([
            'avatar' => $this->filePath('speakers/' . rand(1, 4) . '.png', 'homepage02'),
        ]);
    }
}
