<?php

namespace Database\Seeders\Themes\Homepage02;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;
use Database\Seeders\Themes\Main\PageSeeder as BasePageSeeder;

class PageSeeder extends BasePageSeeder
{
    public function run(): void
    {
        parent::run();

        $this->uploadFiles('general', 'homepage02');
        $this->uploadFiles('backgrounds', 'homepage02');

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('simple-slider', [
                    'key' => 'home-slider',
                    'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ]) .
                Shortcode::generateShortcode('about-us-information', [
                    'style' => '2',
                    'subtitle' => 'About our business conferences',
                    'title' => 'Growth Through WorldClass And Conferences',
                    'description' => 'At Business, we bring together brightest minds, leaders, and trailblazers from across industries to explore latest trends, technologies, and strategies shaping the future.',
                    'quantity' => 2,
                    'title_1' => 'Speakers',
                    'figure_1' => 40,
                    'icon_1' => 'ti ti-microphone-2',
                    'title_2' => 'Sponsors',
                    'figure_2' => 19,
                    'icon_2' => 'ti ti-briefcase',
                    'image' => $this->filePath('general/about-us-information-1.png', 'homepage02'),
                    'image_1' => $this->filePath('general/about-us-information-2.png', 'homepage02'),
                    'image_2' => $this->filePath('general/about-us-information-3.png', 'homepage02'),
                    'button_label' => 'Become an Attendee',
                    'button_url' => '/contact-us',
                    'background_color' => '#032530',
                    'text_color' => '#ffffff',
                ]) .
                Shortcode::generateShortcode('brands', [
                    'style' => '1',
                    'subtitle' => 'general sponsors',
                    'title' => 'Our Official Sponsors',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'text_color' => '#ffffff',
                    'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ]) .
                Shortcode::generateShortcode('speakers', [
                    'title' => 'Our Event Speakers',
                    'subtitle' => 'Our 10+ event speakers',
                    'limit' => 4,
                    'background_color' => '#032530',
                    'text_color' => '#ffffff',
                    'style' => '2',
                ]) .
                Shortcode::generateShortcode('events-schedule', [
                    'title' => 'Our Events Schedule Plan',
                    'subtitle' => 'Event Schedule',
                    'number_days' => 3,
                    'style' => '2',
                    'text_color' => '#ffffff',
                    'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ]) .
                Shortcode::generateShortcode('events', [
                    'style' => '2',
                    'title' => 'Recent Memories 2024',
                    'subtitle' => 'last year memory',
                    'limit' => '5',
                    'redirect_url' => '/events',
                    'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ]) .
                Shortcode::generateShortcode('pricing', [
                    'title' => 'Event Pass & Tickets',
                    'subtitle' => 'Ticket Pricing',
                    'quantity' => 3,
                    'name_1' => 'Basic Packages',
                    'price_1' => '$29',
                    'unit_1' => 'One Person',
                    'features_1' => '+ Regular Seating \n + Comfortable Sleeping \n + Afternoon Snacks \n + Afternoon Entrance \n + Idea sharing',
                    'button_url_1' => '/contact-us',
                    'button_label_1' => 'Buy A Ticket',
                    'name_2' => 'Standard Packages',
                    'price_2' => '$49',
                    'unit_2' => 'One Person',
                    'is_featured_2' => 'yes',
                    'features_2' => '+ Venue rental \n + Premium seating and tables \n + Full event planning service \n + Entertainment services \n + Luxury transportation',
                    'button_url_2' => '/contact-us',
                    'button_label_2' => 'Buy A Ticket',
                    'name_3' => 'Premium Packages',
                    'price_3' => '$69',
                    'unit_3' => 'One Person',
                    'features_3' => '+ Customized decor \n + Top-tier catering \n + Top-shelf beverage package \n + Full event production \n + Luxury accommodations',
                    'button_url_3' => '/contact-us',
                    'button_label_3' => 'Buy A Ticket',
                    'style' => '2',
                    'text_color' => '#ffffff',
                    'background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
                ]) .
                Shortcode::generateShortcode('contact-information', [
                    'style' => '2',
                    'address' => 'Ho Chi Minh City, Viet Nam',
                    'title' => 'Direction To The Venue',
                    'subtitle' => 'How to reach',
                    'quantity' => '4',
                    'title_1' => 'Our Email',
                    'description_1' => 'eventify@gmail.com',
                    'url_1' => 'maito:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail-icon.png', 'main'),
                    'title_2' => 'our location',
                    'description_2' => 'Viet Nam',
                    'url_2' => '/contact-us',
                    'icon_image_2' => $this->filePath('icons/location-icon.png', 'main'),
                    'title_3' => 'Call/Message',
                    'description_3' => '+11234567890',
                    'url_3' => 'tel:+11234567890',
                    'icon_image_3' => $this->filePath('icons/phone-icon.png', 'main'),
                    'title_4' => 'Instagram',
                    'description_4' => '@eventify',
                    'url_4' => '/contact-us',
                    'icon_image_4' => $this->filePath('icons/instagram-icon.png', 'main'),
                    'background_color' => '#032530',
                ])
            ),
        ]);
    }
}
