<?php

namespace Database\Seeders\Themes\Homepage02;

use Database\Seeders\Themes\Main\ThemeOptionSeeder as MainThemeOptionSeeder;

class ThemeOptionSeeder extends MainThemeOptionSeeder
{
    public function getData(): array
    {
        return [
            ...parent::getData(),
            'primary_color' => '#C0F037',
            'secondary_color' => '#032530',
            'logo' => $this->filePath('general/logo.png', 'homepage02'),
            'header_background_color' => '#ffffff',
            'header_text_color' => '#000000',
            'is_header_transparent' => true,
            'display_header_top' => true,
            'footer_background_color' => '#032530',
            'footer_background_image' => $this->filePath('backgrounds/footer-bg.png', 'homepage02'),
            'footer_text_color' => '#ffffff',
            'footer_heading_color' => '#ffffff',
            'breadcrumb_text_color' => '#ffffff',
            'breadcrumb_background_color' => '#032530',
            'breadcrumb_background_image' => $this->filePath('backgrounds/header-bg.png', 'homepage02'),
            'header_top_background_color' => '#FFFFFF',
        ];
    }
}
