<?php

namespace Database\Seeders\Themes\Homepage04;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;
use Database\Seeders\Themes\Main\PageSeeder as BasePageSeeder;

class PageSeeder extends BasePageSeeder
{
    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('hero-banner', [
                    'subtitle' => 'Lead Purpose, Innovate with Passion',
                    'title' => 'Elevate 2025 <br> Leading with <br> the Purpose',
                    'description' => 'Welcome to Innovate 2024: Shaping the Future of Business, where industry leaders, innovators.',
                    'button_primary_label' => 'Reserve my Seat',
                    'button_primary_url' => '/events',
                    'subtitle_image' => $this->filePath('general/logo2.png', 'homepage04'),
                    'image' => $this->filePath('general/hero-img4.png', 'homepage04'),
                    'style' => '3',
                ]) . Shortcode::generateShortcode('countdown', [
                    'start_date' => '2026-01-09',
                    'background_image' => $this->filePath('backgrounds/countdown-bg.png', 'homepage04'),
                    'style' => '2',
                    'title' => 'Yearly Business Conferences “2025”',
                ]) . Shortcode::generateShortcode('about-us-information', [
                    'style' => '5',
                    'title' => 'Innovating for Tomorrow Insights for Business',
                    'subtitle' => 'about our business conferences',
                    'description' => 'Perfectly captures the essence of what this blog aims to deliver. In a rapidly evolving business landscape, leaders must stay.',
                    'quantity' => '3',
                    'title_1' => 'Director of the Developing Communities',
                    'title_2' => 'Deputy Attorney General Media Project',
                    'title_3' => 'Law School and Civil Rights Attorney',
                    'icon_image_1' => $this->filePath('icons/check.png', 'homepage04'),
                    'icon_image_2' => $this->filePath('icons/check.png', 'homepage04'),
                    'icon_image_3' => $this->filePath('icons/check.png', 'homepage04'),
                    'image' => $this->filePath('general/image-1.png', 'homepage04'),
                    'image_1' => $this->filePath('general/image-2.png', 'homepage04'),
                    'image_2' => $this->filePath('general/image-3.png', 'homepage04'),
                    'button_label' => 'Reserve my Seat',
                    'button_url' => '/events',
                ]) . Shortcode::generateShortcode('events-schedule', [
                    'title' => 'Our Events Schedule Plan',
                    'subtitle' => 'Event Schedule',
                    'number_days' => 4,
                    'number_each_days' => 5,
                    'style' => '3',
                    'image' => $this->filePath('general/event-img1.png', 'homepage04'),
                ]) . Shortcode::generateShortcode('events', [
                    'title' => 'Recent Memories 2025',
                    'subtitle' => 'last year memory',
                    'limit' => 5,
                    'style' => '4',
                ]) . Shortcode::generateShortcode('testimonials', [
                    'title' => 'Feedback from Innovate 2024',
                    'subtitle' => 'testimonial',
                    'testimonial_ids' => '1,2',
                    'style' => '2',
                ])
                . Shortcode::generateShortcode('speakers', [
                    'title' => 'Business Breakthrough Team',
                    'subtitle' => 'our 10+ event speakers',
                    'limit' => 8,
                    'style' => '4',
                ]) . Shortcode::generateShortcode('contact-information', [
                    'title' => 'Connect with Our Team',
                    'subtitle' => 'How to reach',
                    'style' => '3',
                    'description' => 'We’re here to help! you have any questions about Innovate 2024, need assistance with registration, or want to learn more about.',
                    'address' => 'Viet Nam',
                    'image' => $this->filePath('general/contact-img.png', 'homepage04'),
                    'image_2' => $this->filePath('general/contact-img2.png', 'homepage04'),
                    'quantity' => '2',
                    'title_1' => 'Our Email',
                    'description_1' => 'mailto:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail.png', 'homepage04'),
                    'title_2' => 'Our Phone Number',
                    'description_2' => '0123456789',
                    'icon_image_2' => $this->filePath('icons/location.png', 'homepage04'),
                ]) . Shortcode::generateShortcode('blog-posts', [
                    'title' => 'Balancing Profit & Purpose',
                    'subtitle' => 'News & updates',
                    'category_ids' => '3,5',
                    'type' => 'latest',
                    'limit' => 3,
                    'style' => '2',
                ])
            ),
        ]);
    }
}
