<?php

namespace Database\Seeders\Themes\Homepage05;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;
use Database\Seeders\Themes\Main\PageSeeder as BasePageSeeder;

class PageSeeder extends BasePageSeeder
{
    public function run(): void
    {
        parent::run();

        $this->uploadFiles('icons', 'homepage05');
        $this->uploadFiles('general', 'homepage05');
        $this->uploadFiles('backgrounds', 'homepage05');

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => htmlentities(
                Shortcode::generateShortcode('hero-banner', [
                    'subtitle' => 'Location: 1800 Abbot Kinney Blvd',
                    'title' => 'AI Digital',
                    'highlight' => 'Summit',
                    'circle_text' => 'Build Success Brand .',
                    'subtitle_image' => $this->filePath('icons/location.png', 'homepage05'),
                    'image' => $this->filePath('general/hero-banner-img.webp', 'homepage05'),
                    'image_1' => $this->filePath('general/hero-banner-author.webp', 'homepage05'),
                    'style' => '4',
                ]) .
                Shortcode::generateShortcode('countdown', [
                    'start_date' => '2026-12-01',
                ]) .
                Shortcode::generateShortcode('events', [
                    'style' => '3',
                    'title' => 'Digital Event <span>List</span>',
                    'subtitle_image' => $this->filePath('general/sub-logo.png', 'homepage05'),
                    'subtitle' => 'Event Schedule',
                    'limit' => '4',
                ]) .
                Shortcode::generateShortcode('marquees', [
                    'quantity' => '4',
                    'name_1' => 'CONFERENCES',
                    'name_2' => 'DIGITAL',
                    'name_3' => 'EXPERIENCE',
                    'name_4' => 'EVENT',
                ]) .
                Shortcode::generateShortcode('speakers', [
                    'style' => '5',
                    'title' => 'Our Event <span>Speakers</span>',
                    'subtitle' => 'Our 15+ event speakers',
                    'subtitle_image' => $this->filePath('general/sub-logo.png', 'homepage05'),
                    'limit' => '4',
                ]) .
                Shortcode::generateShortcode('brands', [
                    'style' => '1',
                    'subtitle' => 'general sponsors',
                    'title' => 'Our Official Sponsors',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'text_color' => '#ffffff',
                ]) .
                Shortcode::generateShortcode('tabs-content', [
                    'title' => 'How You Can <span> Participate </span>',
                    'subtitle' => 'The Redefines Conferences',
                    'subtitle_image' => 'homepage05/general/sub-logo.png',
                    'quantity' => '3',
                    'title_1' => 'Registration Form Fill Up',
                    'description_1' => 'It all starts with understanding your unique needs, Our team takes the time to learn about your goal.',
                    'image_1' => $this->filePath('general/tabs-content-1.webp', 'homepage05'),
                    'image_1_1' => $this->filePath('general/tabs-content-2.webp', 'homepage05'),
                    'image_2_1' => $this->filePath('general/tabs-content-3.webp', 'homepage05'),
                    'image_3_1' => $this->filePath('general/tabs-content-4.webp', 'homepage05'),
                    'title_2' => 'Invitation Card Download',
                    'description_2' => 'It all starts with understanding your unique needs, Our team takes the time to learn about your goal.',
                    'image_2' => $this->filePath('general/tabs-content-1.webp', 'homepage05'),
                    'image_1_2' => $this->filePath('general/tabs-content-2.webp', 'homepage05'),
                    'image_2_2' => $this->filePath('general/tabs-content-3.webp', 'homepage05'),
                    'image_3_2' => $this->filePath('general/tabs-content-4.webp', 'homepage05'),
                    'title_3' => 'Join And Enjoy The Event',
                    'description_3' => 'It all starts with understanding your unique needs, Our team takes the time to learn about your goal.',
                    'image_3' => $this->filePath('general/tabs-content-1.webp', 'homepage05'),
                    'image_1_3' => $this->filePath('general/tabs-content-2.webp', 'homepage05'),
                    'image_2_3' => $this->filePath('general/tabs-content-3.webp', 'homepage05'),
                    'image_3_3' => $this->filePath('general/tabs-content-4.webp', 'homepage05'),
                ]) .
                Shortcode::generateShortcode('site-statistics', [
                    'quantity' => '4',
                    'title_1' => 'Days Of Event',
                    'data_1' => '3',
                    'unit_1' => 'D',
                    'title_2' => 'Registered Participant',
                    'data_2' => '20',
                    'unit_2' => 'K+',
                    'title_3' => 'Attendance Event',
                    'data_3' => '12',
                    'unit_3' => 'K+',
                    'title_4' => 'Our Event Venue',
                    'data_4' => '5',
                ]) .
                Shortcode::generateShortcode('events', [
                    'style' => '2',
                    'title' => 'Our Image <span> Gallery </span>',
                    'subtitle_image' => $this->filePath('general/sub-logo.png', 'homepage05'),
                    'subtitle' => 'Event image gallery',
                    'limit' => '5',
                ]) .
                Shortcode::generateShortcode('marquees', [
                    'quantity' => '4',
                    'name_1' => 'CONFERENCES',
                    'name_2' => 'DIGITAL',
                    'name_3' => 'EXPERIENCE',
                    'name_4' => 'EVENT',
                ]) .
                Shortcode::generateShortcode('contact-information', [
                    'address' => 'New York, USA',
                    'title' => 'Direction To The Venue',
                    'subtitle' => 'How to reach',
                    'image' => $this->filePath('general/contact-information-img.webp', 'homepage05'),
                    'background_image' => $this->filePath('backgrounds/contact-information-bg.png', 'homepage05'),
                    'quantity' => '4',
                    'title_1' => 'Our Email',
                    'description_1' => 'eventify@gmail.com',
                    'url_1' => 'maito:eventify@gmail.com',
                    'icon_image_1' => $this->filePath('icons/mail-icon.png', 'main'),
                    'title_2' => 'our location',
                    'description_2' => 'Viet Nam',
                    'url_2' => '/contact-us',
                    'icon_image_2' => $this->filePath('icons/location-icon.png', 'main'),
                    'title_3' => 'Call/Message',
                    'description_3' => '+11234567890',
                    'url_3' => 'tel:+11234567890',
                    'icon_image_3' => $this->filePath('icons/phone-icon.png', 'main'),
                    'title_4' => 'Instagram',
                    'description_4' => '@eventify',
                    'url_4' => '/contact-us',
                    'icon_image_4' => $this->filePath('icons/instagram-icon.png', 'main'),
                ]) .
                Shortcode::generateShortcode('countdown', [
                    'title' => 'Event <span>Countdown</span>',
                    'subtitle' => 'our event countdown',
                    'subtitle_image' => 'homepage05/general/sub-logo.png',
                    'start_date' => '2027-11-18T16:17',
                    'primary_button_label' => 'purchase ticket now',
                    'primary_button_url' => '/events',
                    'secondary_button_label' => 'Reserve Seat',
                    'secondary_button_url' => '/contact-us',
                ]),
            ),
        ]);

        $aboutUsPage = Page::query()->where('name', 'About Us')->firstOrFail();

        $faker = $this->fake();

        $aboutUsPage->update([
            'content' => Shortcode::generateShortcode(
                'about-us-information',
                [
                        'subtitle' => 'About our Business conferences',
                        'title' => 'Explore Future Of Design At Our Yearly Conference',
                        'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.',
                        'button_label' => 'Become an Attendee',
                        'button_url' => '/contact-us',
                        'quantity' => 3,
                        'title_1' => 'Our Journalist',
                        'figure_1' => '250',
                        'description_1' => 'The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.',
                        'icon_image_1' => $this->filePath('icons/microphone.png', 'main'),
                        'title_2' => 'Our Speaker',
                        'figure_2' => '15',
                        'description_2' => 'By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.',
                        'icon_image_2' => $this->filePath('icons/balloons.png', 'main'),
                        'title_3' => 'Attendees',
                        'figure_3' => '7000',
                        'floating_button_label' => 'Buy Ticket',
                        'floating_button_url' => '/pricing',
                        'image' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                        'image_1' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                        'image_2' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                    ]
            ) . Shortcode::generateShortcode(
                'brands',
                [
                    'title' => 'Join 4,000+ companies already growing',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'style' => 2,
                    'text_color' => '#000000',
                ]
            ) . Shortcode::generateShortcode(
                'featured-block',
                [
                    'subtitle' => 'why choose us',
                    'title' => 'Why Attend Event?',
                    'quantity' => 6,
                    'title_1' => 'Make Ideas Happen',
                    'description_1' => 'Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.',
                    'url_1' => '/events',
                    'icon_image_1' => $this->filePath('icons/idea.png', 'main'),
                    'title_2' => 'Great Speakers',
                    'description_2' => 'Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.',
                    'url_2' => '/events',
                    'icon_image_2' => $this->filePath('icons/speaker.png', 'main'),
                    'title_3' => 'One Day Ticket',
                    'description_3' => 'We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.',
                    'url_3' => '/events',
                    'icon_image_3' => $this->filePath('icons/ticket.png', 'main'),
                    'title_4' => 'Develop Your Skills',
                    'description_4' => 'Eventify is your gateway to future of business. By bringing together best experts from various sectors.',
                    'url_4' => '/events',
                    'icon_image_4' => $this->filePath('icons/coding.png', 'main'),
                    'title_5' => 'Entry Verification',
                    'description_5' => 'You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.',
                    'url_5' => '/events',
                    'icon_image_5' => $this->filePath('icons/search.png', 'main'),
                    'title_6' => 'Workshops Offer',
                    'description_6' => 'Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.',
                    'url_6' => '/events',
                    'icon_image_6' => $this->filePath('icons/workshop.png', 'main'),
                ]
            ),
        ]);
    }
}
