<?php

namespace Database\Seeders\Themes\Homepage05;

use Botble\Widget\Widgets\CoreSimpleMenu;
use Database\Seeders\Themes\Main\WidgetSeeder as MainWidgetSeeder;

class WidgetSeeder extends MainWidgetSeeder
{
    public function getDataHeaderTopSideBar(): array
    {
        return [
            [
                'widget_id' => 'ContactInformationWidget',
                'sidebar_id' => 'header_top_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'ContactInformationWidget',
                    'title' => 'Contact Info',
                    'quantity' => 2,
                    'title_1' => '+3(924)4596512',
                    'icon_1' => 'ti ti-phone-call',
                    'url_1' => 'tel:39244596512',
                    'title_2' => 'info@example.com',
                    'icon_2' => 'ti ti-mail',
                    'url_2' => 'mailto:info@example.com',
                ],
            ],
        ];
    }

    public function getHeaderSidebarData(): array
    {
        return [
            [
                'widget_id' => 'SearchActionButtonWidget',
                'sidebar_id' => 'header_sidebar',
                'position' => 1,
                'data' => [],
            ],
            [
                'widget_id' => 'ButtonWidget',
                'sidebar_id' => 'header_sidebar',
                'position' => 2,
                'data' => [
                    'url' => '/pricing-plan',
                    'label' => 'Buy Ticket',
                ],
            ],
        ];
    }

    public function getDataFooterSidebar(): array
    {
        return [
            [
                'widget_id' => 'SiteInformationWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'SiteInformationWidget',
                    'description' => 'We are committed to creating a platform where business leaders, innovators, and professionals can come together to exchange ideas',
                    'is_enabled_social_links' => true,
                    'logo' => $this->filePath('general/logo.png', 'main'),
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 2,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Quick Links',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => 'About Us',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/about-us',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Our Blog',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/blog',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Event Listing',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/events',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Pricing Plan',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/pricing-plan',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Contact Us',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/contact-us',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => CoreSimpleMenu::class,
                'sidebar_id' => 'footer_sidebar',
                'position' => 3,
                'data' => [
                    'id' => CoreSimpleMenu::class,
                    'name' => 'Contact Us',
                    'items' => [
                        [
                            [
                                'key' => 'label',
                                'value' => '+1 123 456 7890',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'tel:+1 123 456 7890',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-phone-call',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'Secret Location In The UK',
                            ],
                            [
                                'key' => 'url',
                                'value' => '/',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-map-pin',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'eventifyevent@gmail.com',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'mailto:eventifyevent@gmail.com',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-mail',
                            ],
                        ],
                        [
                            [
                                'key' => 'label',
                                'value' => 'eventify.archielite.com',
                            ],
                            [
                                'key' => 'url',
                                'value' => 'https://eventify.archielite.com',
                            ],
                            [
                                'key' => 'icon',
                                'value' => 'ti ti-world',
                            ],
                        ],
                    ],
                ],
            ],
            [
                'widget_id' => 'GalleriesWidget',
                'sidebar_id' => 'footer_sidebar',
                'position' => 4,
                'data' => [
                    'id' => 'GalleriesWidget',
                    'title' => 'Our Recent Event Gallery',
                    'limit' => 6,
                ],
            ],
            [
                'widget_id' => 'EventListWidget',
                'sidebar_id' => 'event_list_sidebar',
                'position' => 1,
                'data' => [
                    'id' => 'EventListWidget',
                    'title' => 'View More Event',
                    'number_of_days' => 3,
                ],
            ],
        ];
    }

    public function getDataPreFooterSidebar(): array
    {
        return [];
    }
}
