<?php

namespace Database\Seeders\Themes\Homepage06;

use Botble\Page\Models\Page;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    protected string $themeName = 'eventify-homepage06';

    public function run(): void
    {
        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'hero-banner',
                    'attributes' => [
                        'style' => '5',
                        'title' => 'Empowering <br> Tomorrow\'s <br> Marketers',
                        'subtitle' => 'Marketing Summit "2025"',
                        'sub_image' => $this->filePath('general/sub-logo.png', 'homepage06'),
                        'circle_text' => 'Build Success Brand .',
                        'image' => $this->filePath('general/hero-banner-5.webp', 'homepage06'),
                        'button_primary_label' => 'Buy Ticket Now',
                        'button_primary_url' => '/events',
                        'background_image' => $this->filePath('backgrounds/hero-banner-bg.webp', 'homepage06'),
                    ],
                ],
                [
                    'name' => 'about-us-information',
                    'attributes' => [
                        'style' => '6',
                        'title' => 'Why Attend the Marketing <br> Summit Event 2025',
                        'subtitle' => 'About Summit',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'description' => 'The Marketing Summit 2024 is more than just a conference—it\'s an opportunity to redefine your marketing approach. From seasoned professionals to emerging talents, this summit is designed for those who are passionate about staying ahead of the curve. <br> <br> With a focus on digital transformation, content strategies, and data-driven decision-making, attendees will walk away with actionable insigh',
                        'button_label' => 'About Event',
                        'button_url' => '/events',
                        'quantity' => '3',
                        'image' => $this->filePath('general/about-us-information-6-1.png', 'homepage06'),
                        'image_1' => $this->filePath('general/about-us-information-6-2.png', 'homepage06'),
                        'image_2' => $this->filePath('general/about-us-information-6-3.png', 'homepage06'),
                    ],
                ],
                [
                    'name' => 'events',
                    'attributes' => [
                        'style' => '5',
                        'title' => 'Event Location & How to Get There',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'subtitle' => 'Event Schedule',
                        'limit' => '3',
                    ],
                ],
                [
                    'name' => 'featured-block',
                    'attributes' => [
                        'style' => '2',
                        'title' => 'Where Marketers Go to Learn',
                        'subtitle' => 'What You Learn',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'quantity' => '3',
                        'title_1' => 'Connect with Visionaries',
                        'description_1' => ' Join industry leaders and like-minded peers, and expand your network with a dynamic community ready to support your career growth and aspirations.',
                        'url_1' => '/',
                        'icon_image_1' => $this->filePath('general/featured-block-1.png', 'homepage06'),
                        'title_2' => 'Master New Skills',
                        'description_2' => 'Every obstacle has a solution, and we bring together experts who\'ve been through it all. Get practical advice, tips, and guidance to challenges faster.',
                        'url_2' => '/',
                        'icon_image_2' => $this->filePath('general/featured-block-2.png', 'homepage06'),
                        'title_3' => 'Take Actionable Insight',
                        'description_3' => 'Immerse yourself in tailored sessions that address your biggest marketing hurdles. Leave with proven strategies and innovative ideas to elevate success.',
                        'url_3' => '/',
                        'icon_image_3' => $this->filePath('general/featured-block-3.png', 'homepage06'),
                    ],
                ],
                [
                    'name' => 'speakers',
                    'attributes' => [
                        'style' => '6',
                        'title' => 'Meet Our Event Speaker\'s',
                        'subtitle' => 'EVENT SPEAKERS ',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'limit' => '4',
                        'background_color' => '#F9FAFB',
                    ],
                ],
                [
                    'name' => 'pricing',
                    'attributes' => [
                        'style' => '3',
                        'title' => 'Register For Eventify 2025',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'subtitle' => 'PRICING',
                        'quantity' => '2',
                        'name_1' => 'Conference Pass',
                        'description_1' => 'Get full access to all man stage keynotes, mastermind sessions, and installation for the conference at Eventify.',
                        'price_1' => '$249',
                        'is_featured_1' => 'no',
                        'features_1' => '+ Main Stage Keynotes \n + Mastermind Sessions (Booking Required) \n + Unlimited Coffee at event Conference \n + Breakfast, Snaks, and Buffet Lunch \n + Post Event Cocktail Reception \n + Event Party On 14 January 2025 + Semrush Swag',
                        'button_label_1' => 'Buy Tickets Now ',
                        'button_url_1' => '/events',
                        'background_color_1' => '#1C58CC',
                        'name_2' => 'VIP Pass',
                        'description_2' => 'Get full access to all man stage keynotes, mastermind sessions, and installation for the conference at Eventify.',
                        'price_2' => '$449',
                        'is_featured_2' => 'no',
                        'features_2' => '+ Main Stage Keynotes \n + Mastermind Sessions (Booking Required) \n + Unlimited Coffee at event Conference \n + Breakfast, Snaks, and Buffet Lunch \n + Post Event Cocktail Reception \n + Event Party On 14 January 2025 \n + Semrush Swag \n + Exclusive Speaker & VIP Welcome Party on 15 January 2025 \n + Fast Track VIP Check In \n + 60 Min Site Clinic (On Site or within a Month) \n + Semrush Certification Workshop of Your Choice On January 2025',
                        'button_label_2' => 'Buy Tickets Now ',
                        'button_url_2' => '/events',
                        'background_color_2' => '#FF3A86',
                        'text_color' => '#000000',
                    ],
                ],
                [
                    'name' => 'testimonials',
                    'attributes' => [
                        'style' => '3',
                        'title' => 'Register For Eventify 2025',
                        'subtitle_image' => $this->filePath('general/sub-logo.png', 'homepage06'),
                        'subtitle' => 'Testimonials',
                        'testimonial_ids' => '1,2,3,4',
                        'background_color' => 'rgb(0, 0, 0)',
                    ],
                ],
                [
                    'name' => 'brands',
                    'attributes' => [
                        'style' => '2',
                        'subtitle' => 'PARTNERS',
                        'subtitle_image' => $this->filePath('general/sub-logo-black.png', 'homepage06'),
                        'title' => 'Our Valued Sponsors & Partners',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png'),
                        'link_8' => 'https://www.epicurious.com',
                        'text_color' => '#000000',
                        'background_color' => '#FFF3F6',
                    ],
                ],
            ]),
        ]);
    }
}
