<?php

namespace Database\Seeders\Themes\Homepage08;

use Botble\Page\Models\Page;
use Botble\Shortcode\Facades\Shortcode;

class PageSeeder extends \Database\Seeders\Themes\Main\PageSeeder
{
    public function run(): void
    {
        $this->uploadFiles('general', 'homepage08');
        $this->uploadFiles('backgrounds', 'homepage08');

        parent::run();

        $homepage = Page::query()->where('name', 'Homepage')->firstOrFail();

        $homepage->update([
            'content' => $this->generateShortcodeContent([
                [
                    'name' => 'hero-banner',
                    'attributes' => [
                        'style' => '7',
                        'title' => 'Digital crypto <br> Conferences 25',
                        'subtitle' => 'Join the the Future of crypto',
                        'subtitle_image' => $this->filePath('general/sub-logo.png', 'homepage08'),
                        'circle_text' => 'Build Success Brand .',
                        'button_primary_label' => 'Reserve premium Seat',
                        'button_primary_url' => '/events',
                        'background_image' => $this->filePath('backgrounds/hero-banner-bg.webp', 'homepage08'),
                    ],
                ],
                [
                    'name' => 'countdown',
                    'attributes' => [
                        'style' => '3',
                        'title' => 'Countdown: Hurry Up!',
                        'subtitle' => 'event day countdown',
                        'start_date' => '2026-06-06T11:12',
                        'background_image' => $this->filePath('backgrounds/countdown-bg.webp', 'homepage08'),
                    ],
                ],
                [
                    'name' => 'events-schedule',
                    'attributes' => [
                        'style' => '5',
                        'title' => 'Our Event Schedule',
                        'subtitle' => 'economy event schedule',
                        'number_days' => '2',
                        'number_each_days' => '4',
                        'text_color' => '#ffffff',
                        'background_image' => $this->filePath('backgrounds/countdown-bg.webp', 'homepage08'),
                    ],
                ],
                [
                    'name' => 'brands',
                    'attributes' => [
                        'style' => '1',
                        'title' => 'Join 4,000+ companies already growing',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                        'link_8' => 'https://www.epicurious.com',
                        'text_color' => '#ffffff',
                        'background_image' => $this->filePath('backgrounds/countdown-bg.webp', 'homepage08'),
                    ],
                ],
                [
                    'name' => 'contact-information',
                    'attributes' => [
                        'style' => 4,
                        'address' => 'Los Angeles, CA 90013',
                        'background_image' => $this->filePath('backgrounds/countdown-bg.webp', 'homepage08'),
                        'quantity' => '4',
                        'title_1' => 'Our Email',
                        'description_1' => 'eventify@gmail.com',
                        'url_1' => 'maito:eventify@gmail.com',
                        'icon_image_1' => $this->filePath('icons/mail-icon.png'),
                        'title_2' => 'our location',
                        'description_2' => 'Viet Nam',
                        'url_2' => '/contact-us',
                        'icon_image_2' => $this->filePath('icons/location-icon.png'),
                        'title_3' => 'Call/Message',
                        'description_3' => '+11234567890',
                        'url_3' => 'tel:+11234567890',
                        'icon_image_3' => $this->filePath('icons/phone-icon.png'),
                        'title_4' => 'Instagram',
                        'description_4' => '@eventify',
                        'url_4' => '/contact-us',
                        'icon_image_4' => $this->filePath('icons/instagram-icon.png'),
                    ],
                ],
                [
                    'name' => 'speakers',
                    'attributes' => [
                        'style' => '8',
                        'title' => 'Meet Our Speakers',
                        'subtitle' => '15+ Event Speakers',
                        'limit' => '8',
                        'text_color' => '#ffffff',
                        'background_image' => $this->filePath('backgrounds/countdown-bg.webp', 'homepage08'),
                    ],
                ],
            ]),
        ]);

        $aboutUsPage = Page::query()->where('name', 'About Us')->firstOrFail();

        $faker = $this->fake();

        $aboutUsPage->update([
            'content' => Shortcode::generateShortcode(
                'about-us-information',
                [
                        'subtitle' => 'About our Business conferences',
                        'title' => 'Explore Future Of Design At Our Yearly Conference',
                        'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.',
                        'button_label' => 'Become an Attendee',
                        'button_url' => '/contact-us',
                        'quantity' => 3,
                        'title_1' => 'Our Journalist',
                        'figure_1' => '250',
                        'description_1' => 'The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.',
                        'icon_image_1' => $this->filePath('icons/microphone.png', 'main'),
                        'title_2' => 'Our Speaker',
                        'figure_2' => '15',
                        'description_2' => 'By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.',
                        'icon_image_2' => $this->filePath('icons/balloons.png', 'main'),
                        'title_3' => 'Attendees',
                        'figure_3' => '7000',
                        'floating_button_label' => 'Buy Ticket',
                        'floating_button_url' => '/pricing',
                        'image' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                        'image_1' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                        'image_2' => $this->filePath('news/' . $faker->numberBetween(1, 20) . '.jpg', 'main'),
                    ]
            ) . Shortcode::generateShortcode(
                'brands',
                [
                    'title' => 'Join 4,000+ companies already growing',
                    'quantity' => 8,
                    'alt_1' => 'Boltshift',
                    'image_1' => $this->filePath('brands/brand-img1.png', 'main'),
                    'link_1' => 'https://paulmbingu.com/boltshiftui',
                    'alt_2' => 'Lightbox',
                    'image_2' => $this->filePath('brands/brand-img2.png', 'main'),
                    'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                    'alt_3' => 'GlobalBank',
                    'image_3' => $this->filePath('brands/brand-img3.png', 'main'),
                    'link_3' => 'https://www.globalbank.com.pa/',
                    'alt_4' => 'FeatherDev',
                    'image_4' => $this->filePath('brands/brand-img4.png', 'main'),
                    'link_4' => 'https://featherdev.com/',
                    'alt_5' => 'Acme Corp',
                    'image_5' => $this->filePath('brands/brand-img5.png', 'main'),
                    'link_5' => 'https://www.acmecorp.com/',
                    'alt_6' => 'Polymath',
                    'image_6' => $this->filePath('brands/brand-img6.png', 'main'),
                    'link_6' => 'https://polymath.network/',
                    'alt_7' => 'Nietzche',
                    'image_7' => $this->filePath('brands/brand-img7.png', 'main'),
                    'link_7' => 'https://redsvn.net/',
                    'alt_8' => 'Epicurious',
                    'image_8' => $this->filePath('brands/brand-img8.png', 'main'),
                    'link_8' => 'https://www.epicurious.com',
                    'style' => 2,
                    'text_color' => '#000000',
                ]
            ) . Shortcode::generateShortcode(
                'featured-block',
                [
                    'subtitle' => 'why choose us',
                    'title' => 'Why Attend Event?',
                    'quantity' => 6,
                    'title_1' => 'Make Ideas Happen',
                    'description_1' => 'Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.',
                    'url_1' => '/events',
                    'icon_image_1' => $this->filePath('icons/idea.png', 'main'),
                    'title_2' => 'Great Speakers',
                    'description_2' => 'Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.',
                    'url_2' => '/events',
                    'icon_image_2' => $this->filePath('icons/speaker.png', 'main'),
                    'title_3' => 'One Day Ticket',
                    'description_3' => 'We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.',
                    'url_3' => '/events',
                    'icon_image_3' => $this->filePath('icons/ticket.png', 'main'),
                    'title_4' => 'Develop Your Skills',
                    'description_4' => 'Eventify is your gateway to future of business. By bringing together best experts from various sectors.',
                    'url_4' => '/events',
                    'icon_image_4' => $this->filePath('icons/coding.png', 'main'),
                    'title_5' => 'Entry Verification',
                    'description_5' => 'You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.',
                    'url_5' => '/events',
                    'icon_image_5' => $this->filePath('icons/search.png', 'main'),
                    'title_6' => 'Workshops Offer',
                    'description_6' => 'Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.',
                    'url_6' => '/events',
                    'icon_image_6' => $this->filePath('icons/workshop.png', 'main'),
                ]
            ),
        ]);
    }
}
