<?php

namespace Database\Seeders\Themes\Main;

use ArchiElite\Announcement\Models\Announcement;
use Botble\Base\Supports\BaseSeeder;
use Botble\Setting\Facades\Setting;
use Carbon\Carbon;

class AnnouncementSeeder extends BaseSeeder
{
    public function run(): void
    {
        Announcement::query()->truncate();

        $announcements = [
            '"Hamilton" Returns - Book Now Before Tickets Sell Out!',
            'Experience Magic: Cirque du Soleil Exclusive Pre-Sale',
            'Coachella 2024: Early Bird Access Opens Tomorrow!',
        ];

        $now = Carbon::now();

        foreach ($announcements as $key => $value) {
            Announcement::query()->create([
                'name' => sprintf('Announcement %s', $key + 1),
                'content' => $value,
                'start_date' => $now,
                'dismissible' => false,
                'has_action' => true,
                'action_label' => 'Buy Ticket',
                'action_url' => '/events',
            ]);
        }

        $settings = $this->getSettings();

        Setting::delete(array_keys($settings));

        Setting::set($settings)->save();
    }

    public function getSettings(): array
    {
        return [
            'announcement_max_width' => '1210',
            'announcement_text_color' => '#000000',
            'announcement_background_color' => 'transparent',
            'announcement_text_alignment' => 'start',
            'announcement_dismissible' => '0',
            'announcement_font_size' => 14,
            'announcement_font_size_unit' => 'px',
            'announcement_placement' => 'theme',
        ];
    }
}
