<?php

namespace Database\Seeders\Themes\Main;

use ArchiElite\EventsBooking\Enums\AccountStatusEnum;
use ArchiElite\EventsBooking\Enums\AccountTypeEnum;
use ArchiElite\EventsBooking\Enums\EventStatusEnum;
use ArchiElite\EventsBooking\Models\Account;
use ArchiElite\EventsBooking\Models\Event;
use Botble\Base\Supports\BaseSeeder;
use Botble\Menu\Database\Traits\HasMenuSeeder;
use Botble\Page\Database\Traits\HasPageSeeder;
use Botble\Page\Models\Page;

class MenuSeeder extends BaseSeeder
{
    use HasMenuSeeder;
    use HasPageSeeder;

    public function run(): void
    {
        $data = [
            [
                'name' => 'Main menu',
                'slug' => 'main-menu',
                'location' => 'main-menu',
                'items' => [
                    [
                        'title' => 'Home',
                        'url' => '/',
                        'children' => [
                            [
                                'title' => 'Home 1',
                                'url' => 'https://eventify.archielite.com',
                            ],
                            ...collect(range(2, 10))->map(function ($index) {
                                return [
                                    'title' => 'Home ' . $index,
                                    'url' => sprintf('https://eventify-home-%s.archielite.com', $index),
                                ];
                            })->toArray(),
                        ],
                    ],
                    [
                        'title' => 'About Us',
                        'reference_type' => Page::class,
                        'reference_id' => $this->getPageId('About Us'),
                    ],
                    [
                        'title' => 'Speakers',
                        'url' => '/',
                        'children' => [
                            [
                                'title' => 'Speakers',
                                'reference_type' => Page::class,
                                'reference_id' => $this->getPageId('Speakers'),
                            ],
                            [
                                'title' => 'Speaker Detail',
                                'url' => Account::query()->where('type', AccountTypeEnum::SPEAKER)->where('status', AccountStatusEnum::ACTIVATED)->first()?->url,
                            ],
                        ],
                    ],
                    [
                        'title' => 'Schedule',
                        'url' => '/',
                        'children' => [
                            [
                                'title' => 'Our Event',
                                'url' => '/events',
                            ],
                            [
                                'title' => 'Event Schedule',
                                'url' => '/events',
                            ],
                            [
                                'title' => 'Event Detail',
                                'url' => Event::query()->where('status', EventStatusEnum::APPROVED)->first()?->url,
                            ],
                        ],
                    ],
                    [
                        'title' => 'Blog',
                        'url' => '/',
                        'children' => [
                            [
                                'title' => 'Our Blog',
                                'reference_type' => Page::class,
                                'reference_id' => $this->getPageId('Blog'),
                            ],
                            [
                                'title' => 'Blog Detail',
                                'url' => '/blog/humanoid-robots-in-everyday-life-ai-companions-and-assistants',
                            ],
                        ],
                    ],
                    [
                        'title' => 'Pages',
                        'url' => '/',
                        'children' => [
                            [
                                'title' => 'Our Memories',
                                'url' => '/blog',
                            ],
                            [
                                'title' => 'Pricing Plan',
                                'reference_type' => Page::class,
                                'reference_id' => $this->getPageId('Pricing Plan'),
                            ],
                            [
                                'title' => 'FAQs',
                                'reference_type' => Page::class,
                                'reference_id' => $this->getPageId('FAQs'),
                            ],
                            [
                                'title' => 'Contact Us',
                                'reference_type' => Page::class,
                                'reference_id' => $this->getPageId('Contact Us'),
                            ],
                        ],
                    ],
                ],
            ],
        ];

        $this->createMenus($data);
    }
}
