<?php

namespace Database\Seeders\Themes\Main;

use Botble\Page\Database\Traits\HasPageSeeder;
use Botble\Shortcode\Facades\Shortcode;
use Botble\Theme\Database\Seeders\ThemeSeeder;

class PageSeeder extends ThemeSeeder
{
    use HasPageSeeder;

    public function run(): void
    {
        $this->truncatePages();
        $this->uploadFiles('brands', 'main');
        $this->uploadFiles('backgrounds', 'main');
        $this->uploadFiles('icons', 'main');
        $this->uploadFiles('news', 'main');

        $pages = [
            [
                'name' => 'Homepage',
                'content' => htmlentities(
                    Shortcode::generateShortcode('hero-banner', [
                        'title' => 'Business Forward 2025 Strategies for a New Era',
                        'subtitle' => 'Lead Purpose, Innovate with Passion',
                        'description' => 'Welcome Innovate 2025 Shaping the Future of Business, where industry leaders, innovators, and visionaries come.',
                        'image' => $this->filePath('general/hero-banner-img.png'),
                        'button_primary_label' => 'Reserve My Seat',
                        'button_secondary_url' => '/about-us',
                        'button_secondary_label' => 'About us',
                        'button_primary_url' => '/events',
                        'background_image' => $this->filePath('backgrounds/hero-banner-bg.png'),
                    ]) .
                    Shortcode::generateShortcode(
                        'about-us-information',
                        [
                            'style' => '3',
                            'title' => 'Innovate 2024 Shaping Of The Future Of Business',
                            'subtitle' => 'about our business conferences',
                            'description' => 'Reflects Our commitment To Driving Progress Embracing Innovation In An Ever-evolving Marketplace. Our Conference is Designed to be a hub for thought leadership, where business pioneers and emerging.',
                            'floating_button_label' => 'Buy Ticket',
                            'floating_button_url' => '/events',
                            'button_label' => 'Become an Attendee',
                            'button_url' => '/about-us',
                            'quantity' => '2',
                            'title_1' => 'Exclusive Keynotes',
                            'description_1' => 'The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.',
                            'icon_1' => 'ti ti-microphone-2',
                            'title_2' => 'Off Side Trips',
                            'description_2' => 'By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.',
                            'icon_2' => 'ti ti-chart-bubble',
                            'image' => $this->filePath('general/about-img1.png', 'main'),
                            'image_1' => $this->filePath('general/about-img2.png', 'main'),
                            'image_2' => $this->filePath('general/about-img3.png', 'main'),
                        ]
                    ) .
                    Shortcode::generateShortcode('events-schedule', [
                        'title' => 'Our Events Schedule Plan',
                        'subtitle' => 'Event Schedule',
                        'number_days' => 5,
                    ]) .
                    Shortcode::generateShortcode('testimonials', [
                        'title' => 'What Our Attendees Say',
                        'subtitle' => 'Testimonial',
                        'testimonial_ids' => '1,2,3,4',
                        'youtube_video_url' => 'https://www.youtube.com/watch?v=ldusxyoq0Y8',
                        'image' => $this->filePath('general/testimonial-image.png', 'main'),
                        'background_color' => '#FBF9F4',
                    ]) .
                    Shortcode::generateShortcode('events', [
                        'title' => 'Recent Memories 2024',
                        'subtitle' => 'Last year memory',
                        'limit' => '5',
                        'logo' => $this->filePath('general/logo-yellow.png', 'main'),
                    ]) .
                    Shortcode::generateShortcode('brands', [
                        'style' => '2',
                        'subtitle' => 'general sponsors',
                        'title' => 'Our Official Sponsors',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png'),
                        'link_8' => 'https://www.epicurious.com',
                    ]) .
                    Shortcode::generateShortcode('blog-posts', [
                        'limit' => '3',
                        'category_ids' => '1,2,4',
                        'title' => 'Balancing Profit & Purpose',
                        'subtitle' => 'News & updates',
                        'type' => 'featured',
                        'enable_lazy_loading' => 'no',
                    ]),
                ),
                'template' => 'homepage',
            ],
            [
                'name' => 'About Us',
                'content' => Shortcode::generateShortcode(
                    'about-us-information',
                    [
                            'subtitle' => 'About our Business conferences',
                            'title' => 'Explore Future Of Design At Our Yearly Conference',
                            'description' => 'The Yearly Designer Conferences designed to challenge, Event inspire, and push the boundaries of what is possible in design. From emerging technologies to sustainable design practices.',
                            'button_label' => 'Become an Attendee',
                            'button_url' => '/contact-us',
                            'quantity' => 3,
                            'title_1' => 'Our Journalist',
                            'figure_1' => '250',
                            'description_1' => 'The title captures our mission to empower businesses to not only adapt but lead in this new era of digital.',
                            'icon_image_1' => $this->filePath('icons/microphone.png'),
                            'title_2' => 'Our Speaker',
                            'figure_2' => '15',
                            'description_2' => 'By shaping the future today, we aim to create a lasting impact that will resonate across industries and inspire.',
                            'icon_image_2' => $this->filePath('icons/balloons.png'),
                            'title_3' => 'Attendees',
                            'figure_3' => '7000',
                            'floating_button_label' => 'Buy Ticket',
                            'floating_button_url' => '/pricing',
                            'image' => $this->filePath('general/about-img1.png', 'main'),
                            'image_1' => $this->filePath('general/about-img2.png', 'main'),
                            'image_2' => $this->filePath('general/about-img3.png', 'main'),
                        ]
                ) . Shortcode::generateShortcode(
                    'brands',
                    [
                        'style' => '1',
                        'title' => 'Join 4,000+ companies already growing',
                        'quantity' => 8,
                        'alt_1' => 'Boltshift',
                        'image_1' => $this->filePath('brands/brand-img1.png'),
                        'link_1' => 'https://paulmbingu.com/boltshiftui',
                        'alt_2' => 'Lightbox',
                        'image_2' => $this->filePath('brands/brand-img2.png'),
                        'link_2' => 'https://lokeshdhakar.com/projects/lightbox2/',
                        'alt_3' => 'GlobalBank',
                        'image_3' => $this->filePath('brands/brand-img3.png'),
                        'link_3' => 'https://www.globalbank.com.pa/',
                        'alt_4' => 'FeatherDev',
                        'image_4' => $this->filePath('brands/brand-img4.png'),
                        'link_4' => 'https://featherdev.com/',
                        'alt_5' => 'Acme Corp',
                        'image_5' => $this->filePath('brands/brand-img5.png'),
                        'link_5' => 'https://www.acmecorp.com/',
                        'alt_6' => 'Polymath',
                        'image_6' => $this->filePath('brands/brand-img6.png'),
                        'link_6' => 'https://polymath.network/',
                        'alt_7' => 'Nietzche',
                        'image_7' => $this->filePath('brands/brand-img7.png'),
                        'link_7' => 'https://redsvn.net/',
                        'alt_8' => 'Epicurious',
                        'image_8' => $this->filePath('brands/brand-img8.png'),
                        'link_8' => 'https://www.epicurious.com',
                    ]
                ) . Shortcode::generateShortcode(
                    'featured-block',
                    [
                        'subtitle' => 'why choose us',
                        'title' => 'Why Attend Event?',
                        'quantity' => 6,
                        'title_1' => 'Make Ideas Happen',
                        'description_1' => 'Eventify 2024 brings together the brightest minds and industry leaders for best of transformative business.',
                        'url_1' => '/events',
                        'icon_image_1' => $this->filePath('icons/idea.png'),
                        'title_2' => 'Great Speakers',
                        'description_2' => 'Whether you\'re looking to elevate your business strategy, discover the latest industry trends, or connect.',
                        'url_2' => '/events',
                        'icon_image_2' => $this->filePath('icons/speaker.png'),
                        'title_3' => 'One Day Ticket',
                        'description_3' => 'We empower businesses to thrive in an ever-evolving marketplace. This conference more than just an event.',
                        'url_3' => '/events',
                        'icon_image_3' => $this->filePath('icons/ticket.png', 'main'),
                        'title_4' => 'Develop Your Skills',
                        'description_4' => 'Eventify is your gateway to future of business. By bringing together best experts from various sectors.',
                        'url_4' => '/events',
                        'icon_image_4' => $this->filePath('icons/coding.png'),
                        'title_5' => 'Entry Verification',
                        'description_5' => 'You\'ll walk away with a deeper best understanding of emerging trends and actionable strategies that can.',
                        'url_5' => '/events',
                        'icon_image_5' => $this->filePath('icons/search.png'),
                        'title_6' => 'Workshops Offer',
                        'description_6' => 'Designed for forward-thinking and professionals, this event delivers the tools, connections, and insights you.',
                        'url_6' => '/events',
                        'icon_image_6' => $this->filePath('icons/workshop.png', 'main'),
                    ]
                ),
            ],
            [
                'name' => 'Speakers',
                'content' => Shortcode::generateShortcode('speakers', [
                'limit' => 8,
                ]),
                'template' => 'full-width',
                'metadata' => [
                'breadcrumb_background_image' => $this->filePath('backgrounds/speakers-bg.png', 'main'),
                'breadcrumb_text_color' => '#ffffff',
                ],
            ],
            [
                'name' => 'Blog',
                'content' => '',
                'template' => 'default',
            ],
            [
                'name' => 'Events',
                'content' => '',
                'template' => 'default',
            ],
            [
                'name' => 'Pricing Plan',
                'content' => Shortcode::generateShortcode('pricing', [
                'title' => 'Event Pass & Tickets',
                'subtitle' => 'Ticket Pricing',
                'quantity' => 3,
                'name_1' => 'Basic Packages',
                'price_1' => '$29',
                'unit_1' => 'One Person',
                'features_1' => '+ Regular Seating \n + Comfortable Sleeping \n + Afternoon Snacks \n + Afternoon Entrance \n + Idea sharing',
                'button_url_1' => '/contact-us',
                'button_label_1' => 'Buy A Ticket',
                'name_2' => 'Standard Packages',
                'price_2' => '$49',
                'unit_2' => 'One Person',
                'features_2' => '+ Venue rental \n + Premium seating and tables \n + Full event planning service \n + Entertainment services \n + Luxury transportation',
                'button_url_2' => '/contact-us',
                'button_label_2' => 'Buy A Ticket',
                'name_3' => 'Premium Packages',
                'price_3' => '$69',
                'unit_3' => 'One Person',
                'features_3' => '+ Customized decor \n + Top-tier catering \n + Top-shelf beverage package \n + Full event production \n + Luxury accommodations',
                'button_url_3' => '/contact-us',
                'button_label_3' => 'Buy A Ticket',
                'background_image_name' => $this->filePath('backgrounds/pricing-name.png', 'main'),
                ]),
                'template' => 'full-width',
            ],
            [
                'name' => 'Contact Us',
                'content' => htmlentities(
                    Shortcode::generateShortcode('contact-form', [
                        'title' => 'Get In Touch Now',
                        'display_fields' => 'phone,email,subject,address',
                        'mandatory_fields' => 'email',
                        'image' => $this->filePath('general/contact-img-1.png', 'main'),
                    ]) .
                    Shortcode::generateShortcode('contact-information', [
                        'address' => 'Ho Chi Minh City, Viet Nam',
                        'title' => 'Direction To The Venue',
                        'subtitle' => 'How to reach',
                        'image' => $this->filePath('general/contact-img-2.png', 'main'),
                        'background_image' => $this->filePath('backgrounds/2.png'),
                        'icon_bg_image' => $this->filePath('backgrounds/1.png'),
                        'quantity' => '4',
                        'title_1' => 'Our Email',
                        'description_1' => 'eventify@gmail.com',
                        'url_1' => 'maito:eventify@gmail.com',
                        'icon_image_1' => $this->filePath('icons/mail-icon.png'),
                        'title_2' => 'our location',
                        'description_2' => 'Viet Nam',
                        'url_2' => '/contact-us',
                        'icon_image_2' => $this->filePath('icons/location-icon.png'),
                        'title_3' => 'Call/Message',
                        'description_3' => '+11234567890',
                        'url_3' => 'tel:+11234567890',
                        'icon_image_3' => $this->filePath('icons/phone-icon.png'),
                        'title_4' => 'Instagram',
                        'description_4' => '@eventify',
                        'url_4' => '/contact-us',
                        'icon_image_4' => $this->filePath('icons/instagram-icon.png'),
                    ])
                ),
            ],
            [
                'name' => 'FAQs',
                'content' => htmlentities(
                    Shortcode::generateShortcode('faq', [
                        'title' => 'Frequently Asked Question',
                        'quantity' => '4',
                        'category_id_1' => '1',
                        'category_id_2' => '2',
                        'category_id_3' => '3',
                        'category_id_4' => '4',
                    ])
                ),
            ],
            [
                'name' => 'Privacy Policy',
                'content' => file_get_contents(database_path('seeders/contents/privacy-policy.html')),
            ],
        ];

        $this->createPages($pages);
    }
}
