<?php

namespace Database\Seeders\Themes\Main;

use Botble\Page\Database\Traits\HasPageSeeder;
use Botble\Theme\Database\Seeders\ThemeSeeder;
use Botble\Theme\Database\Traits\HasThemeOptionSeeder;
use Botble\Theme\Supports\ThemeSupport;

class ThemeOptionSeeder extends ThemeSeeder
{
    use HasThemeOptionSeeder;
    use HasPageSeeder;

    public function run(): void
    {
        $this->uploadFiles('general', 'main');

        $this->createThemeOptions($this->getData());
    }

    public function getData(): array
    {
        return [
            'site_title' => 'Eventify - Event And Conference Laravel Script',
            'seo_description' => 'Professional Laravel event management system for conferences and workshops with built-in ticketing and scheduling features.',
            'copyright' => '©%Y Archi Elite Team. All Rights Reserved.',
            'favicon' => $this->filePath('general/favicon.png', 'main'),
            'logo' => $this->filePath('general/logo.png', 'main'),
            'homepage_id' => $this->getPageId('Homepage'),

            // Blog
            'blog_page_id' => $this->getPageId('Blog'),
            'blog_post_meta_display' => '["author_name","published_date"]',
            'blog_post_detail_meta_display' => '["author_name","published_date"]',
            'blog_post_items_per_row' => 3,
            'number_of_related_posts' => 3,

            // Breadcrumb
            'breadcrumb_background_image' => $this->filePath('backgrounds/image-1.jpg', 'main'),
            'breadcrumb_text_color' => '#ffffff',

            // Event booking
            'events_page_id' => $this->getPageId('Events'),
            'event_list_meta_display' => '["date_time", "organizer_name", "organizer_title", "organizer_image"]',
            'event_detail_meta_display' => '["date_time", "organizer_name", "organizer_title", "organizer_image"]',
            'event_list_widget_meta_display' => '["date_time", "organizer_name", "organizer_title", "organizer_image"]',
            'event_list_title' => 'Event History Kireon Pollardy',
            'event_list_widget_date_icon_image' => $this->filePath('icons/calendar.png', 'main'),

            'calender_icon_image' => $this->filePath('icons/calendar.png', 'main'),
            'author_icon_image' => $this->filePath('icons/user.png', 'main'),
            'views_icon_image' => $this->filePath('icons/view.png', 'main'),
            'reading_time_icon_image' => $this->filePath('icons/clock.png', 'main'),
            'category_icon_image' => $this->filePath('icons/menu.png', 'main'),
            'published_icon_image' => $this->filePath('icons/calendar.png', 'main'),
            'social_links' => ThemeSupport::getDefaultSocialLinksData(),
            'logo_height' => 45,
            'is_header_transparent' => true,
            'display_header_top' => true,
            'header_top_text_color' => '#000000',
            'header_top_background_color' => '#FFBA00',
            'header_background_color' => '#1A1719',
            'header_text_color' => '#ffffff',
            'footer_background_color' => '#FBF9F4',
            'footer_text_color' => '#544E51',
            'footer_heading_color' => '#1A1719',
            'tp_primary_font' => 'Figtree',
            'tp_heading_font' => 'Space Grotesk',
            'primary_color' => '#FFBA00',
            'secondary_color' => '#1A1719',
            'newsletter_popup_enable' => true,
            'newsletter_popup_image' => $this->filePath('backgrounds/newsletter-bg.jpg', 'main'),
            'newsletter_popup_title' => 'HOT DEALS',
            'newsletter_popup_description' => 'Promo Booking Hub - Discover and Book Exclusive Event Deals!',
            'term_and_privacy_policy_url' => '/privacy-policy',
        ];
    }
}
