<?php

return [
    'name' => 'Events Booking',
    'description' => 'Config email templates for Events Booking',
    'templates' => [
        'confirm-email' => [
            'title' => 'Confirm email',
            'description' => 'Send email to user when they register an account to verify their email',
            'subject' => 'Confirm Email Notification',
            'can_off' => false,
            'variables' => [
                'verify_link' => 'Verify email link',
                'account_name' => 'Account name',
            ],
        ],
        'password-reminder' => [
            'title' => 'Reset password',
            'description' => 'Send email to user when requesting reset password',
            'subject' => 'Reset Password',
            'can_off' => false,
            'variables' => [
                'reset_link' => 'Reset password link',
            ],
        ],
        'order_completed' => [
            'title' => 'plugins/events-booking::events-booking.order_confirm.order_confirmation_title',
            'description' => 'plugins/events-booking::events-booking.order_confirm.order_confirmation_description',
            'subject' => 'Order confirmed {{ order_id }}',
            'can_off' => true,
            'variables' => [
                'customer_name' => 'plugins/events-booking::events-booking.order_confirm.customer_name',
                'customer_phone' => 'plugins/events-booking::events-booking.order_confirm.customer_phone',
                'customer_email' => 'plugins/events-booking::events-booking.order_confirm.customer_email',
                'payment_method' => 'plugins/events-booking::events-booking.order_confirm.payment_method',
                'ticket_list' => 'plugins/events-booking::events-booking.order_confirm.ticket_list',
                'order_note' => 'plugins/events-booking::events-booking.order_confirm.order_note',
                'order_id' => 'plugins/events-booking::events-booking.order_confirm.order_id',
                'event_name' => 'plugins/events-booking::events-booking.order_confirm.event_name',
                'event_image' => 'plugins/events-booking::events-booking.order_confirm.event_image',
                'event_location' => 'plugins/events-booking::events-booking.order_confirm.event_location',
                'start_date' => 'plugins/events-booking::events-booking.order_confirm.event_date',
                'order_completed_title' => 'plugins/events-booking::events-booking.order_confirm.order_completed_title',
                'order_dear' => 'plugins/events-booking::events-booking.order_confirm.order_dear',
                'order_your_tickets' => 'plugins/events-booking::events-booking.order_confirm.order_your_tickets',
            ],
        ],
        'event_tickets_delivery' => [
            'title' => 'plugins/events-booking::events-booking.event_tickets_delivery.event_tickets_delivery_title',
            'description' => 'plugins/events-booking::events-booking.event_tickets_delivery.event_tickets_delivery_description',
            'subject' => 'Your tickets for event {{ event_name }}',
            'can_off' => true,
            'variables' => [
                'customer_name' => 'plugins/events-booking::events-booking.order_confirm.customer_name',
                'customer_phone' => 'plugins/events-booking::events-booking.order_confirm.customer_phone',
                'customer_email' => 'plugins/events-booking::events-booking.order_confirm.customer_email',
                'ticket_list' => 'plugins/events-booking::events-booking.order_confirm.ticket_list',
                'order_id' => 'plugins/events-booking::events-booking.order_confirm.order_id',
                'event_name' => 'plugins/events-booking::events-booking.order_confirm.event_name',
                'order_title' => 'plugins/events-booking::events-booking.order_confirm.order_title',
                'event_image' => 'plugins/events-booking::events-booking.order_confirm.event_image',
                'event_location' => 'plugins/events-booking::events-booking.order_confirm.event_location',
                'start_date' => 'plugins/events-booking::events-booking.order_confirm.event_date',
                'ticket_qrcode' => 'plugins/events-booking::events-booking.order_confirm.ticket_qrcode',
                'ticket_thanks' => 'plugins/events-booking::events-booking.event_tickets_delivery.ticket_thanks',
                'ticket_dear' => 'plugins/events-booking::events-booking.event_tickets_delivery.ticket_dear',
                'ticket_instruction' => 'plugins/events-booking::events-booking.event_tickets_delivery.ticket_instruction',
            ],
        ],
        'account_new_order' => [
            'title' => 'plugins/events-booking::events-booking.account_new_order.account_new_order_title',
            'description' => 'plugins/events-booking::events-booking.account_new_order.account_new_order_description',
            'subject' => 'New order(s) at {{ site_title }}',
            'can_off' => true,
            'enabled' => true,
            'variables' => [
                'customer_name' => 'plugins/events-booking::events-booking.order_confirm.customer_name',
                'customer_email' => 'plugins/events-booking::events-booking.order_confirm.customer_email',
                'customer_phone' => 'plugins/events-booking::events-booking.order_confirm.customer_phone',
                'payment_method' => 'plugins/events-booking::events-booking.order_confirm.payment_method',
                'order_note' => 'plugins/events-booking::events-booking.order_confirm.order_note',
                'order_id' => 'plugins/events-booking::events-booking.order_confirm.order_id',
                'event_name' => 'plugins/events-booking::events-booking.order_confirm.event_name',
                'event_location' => 'plugins/events-booking::events-booking.order_confirm.event_location',
                'start_date' => 'plugins/events-booking::events-booking.order_confirm.event_date',
            ],
        ],
        'order_confirm_payment' => [
            'title' => 'plugins/events-booking::events-booking.payment_confirmation.payment_confirmation_title',
            'description' => 'plugins/events-booking::events-booking.payment_confirmation.payment_confirmation_description',
            'subject' => 'Payment for order {{ order_id }} was confirmed',
            'can_off' => true,
            'variables' => [
                'customer_name' => 'plugins/events-booking::events-booking.order_confirm.customer_name',
                'customer_phone' => 'plugins/events-booking::events-booking.order_confirm.customer_phone',
                'customer_address' => 'plugins/events-booking::events-booking.order_confirm.customer_address',
                'shipping_method' => 'plugins/events-booking::events-booking.order_confirm.shipping_method',
                'payment_method' => 'plugins/events-booking::events-booking.order_confirm.payment_method',
                'product_list' => 'plugins/events-booking::events-booking.order_confirm.product_list',
                'order_note' => 'plugins/events-booking::events-booking.order_confirm.order_note',
                'order_id' => 'plugins/events-booking::events-booking.order_confirm.order_id',
                'event_name' => 'plugins/events-booking::events-booking.order_confirm.event_name',
                'event_location' => 'plugins/events-booking::events-booking.order_confirm.event_location',
                'start_date' => 'plugins/events-booking::events-booking.order_confirm.event_date',
            ],
        ],
    ],
];
