$(document).ready(function() {
    let ajaxRequest
    let hasAjaxSearchRequested = false

    $(document).on('keyup', '[data-bb-toggle="event-search"]', (event) => {
        event.preventDefault()
        const _self = $(event.currentTarget)
        const $formBody = _self.closest('.box-search-advance').find('.card')
        setTimeout(() => {
            ajaxRequest = $httpClient
                .make()
                .withLoading($formBody)
                .get(_self.data('bb-target'), { keyword: _self.val() })
                .then(({ data }) => {
                    if (data.error) {
                        Botble.showError(data.message)
                    } else {
                        $formBody.html(data.data).show()
                    }
                    hasAjaxSearchRequested = false
                })
                .catch((error) => {
                    if (data.statusText !== 'abort') {
                        Botble.handleError(error)
                    }
                })
        }, 500)
    })

    $(document).on('click', 'body', (e) => {
        const container = $('.box-search-advance')

        if (!container.is(e.target) && container.has(e.target).length === 0) {
            container.find('.card').hide()
        }
    })

    $(document).on('click', '[data-bb-toggle="event-choose-item"]', function(event) {
        event.preventDefault()
        const _self = $(event.currentTarget)
        const $formBody = _self.closest('.box-search-advance').find('.card')
        const $eventSelected = _self.closest('.box-search-advance-wrapper').find('.event-selected')

        const $input = $('input[data-bb-toggle="event-search"]')

        $input.val('')
        $input.hide()

        $httpClient
            .make()
            .get(_self.data('bb-url'))
            .then(({ data }) => {
                if (data.error) {
                    Botble.showError(data.message)
                } else {
                    removeAndSetQueryParams()
                    addQueryParam("event_id", data.data.event_id)

                    $('input[name="event_id"]').val(data.data.event_id)

                    $eventSelected.html(data.data.html).show()

                    $('[data-bb-toggle="export-counter"]').text(data.data.attendees_count)

                    $formBody.hide()
                }
                hasAjaxSearchRequested = false
            })
            .catch((error) => {
                if (data.statusText !== 'abort') {
                    Botble.handleError(error)
                }
            })
    })

    $(document).on('click', '[data-bb-toggle="event-remove-item"]', function(event) {
        const _self = $(event.currentTarget)
        const $eventSelected = _self.closest('.box-search-advance-wrapper').find('.event-selected')
        const $input = $('input[data-bb-toggle="event-search"]')

        $input.show()

        $('[data-bb-toggle="export-counter"]').text(0)
        $('input[name="event_id"]').val('')

        $eventSelected.hide()
        removeAndSetQueryParams()
    })
})

function addQueryParam(key, value) {
    let url = window.location.href;

    const hashIndex = url.indexOf('#');
    if (hashIndex !== -1) {
        url = url.substring(0, hashIndex);
    }

    const separator = url.indexOf('?') === -1 ? '?' : '&';
    const newUrl = url + separator + key + '=' + encodeURIComponent(value);
    window.history.pushState({}, document.title, newUrl);
}

function removeAndSetQueryParams(newParams) {
    let url = window.location.href.split('?')[0];
    const params = new URLSearchParams(newParams).toString();
    const newUrl = params ? `${url}?${params}` : url;
    window.history.pushState({}, document.title, newUrl);
    return newUrl;
}
