@extends(BaseHelper::getAdminMasterLayoutTemplate())

@push('header-action')
    <x-core::button
            tag="a"
            href="{{ route('events-booking.invoices.generate-invoice', ['invoice' => $invoice, 'type' => 'print']) }}"
            target="_blank"
            icon="ti ti-printer"
    >
        {{ trans('plugins/events-booking::invoice.print') }}
    </x-core::button>

    <x-core::button
            href="{{ route('events-booking.invoices.generate-invoice', ['invoice' => $invoice, 'type' => 'download']) }}"
            tag="a"
            target="_blank"
            icon="ti ti-download"
    >
        {{ trans('plugins/events-booking::invoice.download') }}
    </x-core::button>
@endpush

@section('content')
    <div class="row">
        <x-core::card>
            <x-core::card.body>
                <div class="row align-items-center">
                    <div class="col-md-6">
                        @if ($invoice->company_logo)
                            <img
                                    src="{{ RvMedia::getImageUrl($invoice->company_logo) }}"
                                    alt="{{ $invoice->company_name }}"
                                    style="max-height: 150px;"
                            >
                        @endif
                    </div>
                    <div class="col-md-6 text-end">
                        <h2 class="mb-0 uppercase">{{ trans('plugins/events-booking::invoice.heading') }}</h2>
                    </div>
                </div>
                <div class="row mt-5">
                    <div class="col-6">
                    </div>
                    <div class="col-6 text-end">
                        <ul class="list-unstyled">
                            @if ($customerName = $invoice->account_name)
                                <li>{{ $customerName }}</li>
                            @endif
                            @if ($customerEmail = $invoice->account_email)
                                <li>{{ $customerEmail }}</li>
                            @endif
                            @if ($customerPhone = $invoice->account_phone)
                                <li>{{ $customerPhone }}</li>
                            @endif
                        </ul>
                    </div>
                </div>
                <div class="invoice-info">
                    <div class="mb-3">
                        <div class="row">
                            <div class="hr"></div>
                            <x-core::datagrid class="mb-3">
                                <x-core::datagrid.item>
                                    <x-slot:title>
                                        {{ trans('plugins/events-booking::invoice.detail.code') }}
                                    </x-slot:title>
                                    {{ $invoice->code }}
                                </x-core::datagrid.item>
                                @if ($invoice->created_at)
                                    <x-core::datagrid.item>
                                        <x-slot:title>
                                            {{ trans('plugins/events-booking::invoice.detail.issue_at') }}
                                        </x-slot:title>
                                        {{ $invoice->created_at->translatedFormat('j F, Y') }}
                                    </x-core::datagrid.item>
                                @endif
                                @if (is_plugin_active('payment') && $invoice->payment->payment_channel->label())
                                    <x-core::datagrid.item>
                                        <x-slot:title>
                                            {{ trans('plugins/events-booking::invoice.payment_method') }}
                                        </x-slot:title>
                                        {{ $invoice->payment->payment_channel->label() }}
                                    </x-core::datagrid.item>
                                @endif
                            </x-core::datagrid>
                        </div>
                    </div>

                    <div class="table-responsive">
                        <x-core::table>
                            <x-core::table.header>
                                <x-core::table.header.cell>#</x-core::table.header.cell>
                                <x-core::table.header.cell>
                                    {{ __('Event') }}
                                </x-core::table.header.cell>
                                <x-core::table.header.cell>
                                    {{ __('Name') }}
                                </x-core::table.header.cell>
                                <x-core::table.header.cell>
                                    {{ __('Amount') }}
                                </x-core::table.header.cell>
                                <x-core::table.header.cell>
                                    {{ __('Quantity') }}
                                </x-core::table.header.cell>
                                <x-core::table.header.cell>
                                    {{ __('Total') }}
                                </x-core::table.header.cell>
                            </x-core::table.header>

                            <x-core::table.body>
                                @foreach ($invoice->items as $invoiceItem)
                                    @php
                                        $ticket = $invoiceItem->reference;
                                        $ticket->loadMissing('order');
                                    @endphp
                                    <x-core::table.body.row>
                                        <x-core::table.body.cell>
                                            {{ $loop->iteration }}
                                        </x-core::table.body.cell>
                                        <x-core::table.body.cell>
                                            {{ $invoice->event_name }}
                                        </x-core::table.body.cell>
                                        <x-core::table.body.cell>
                                            {{ $ticket->name }}
                                        </x-core::table.body.cell>
                                        <x-core::table.body.cell>
                                            {{ format_price($invoiceItem->amount) }}
                                        </x-core::table.body.cell>
                                        <x-core::table.body.cell>
                                            {{ $invoiceItem->qty }}
                                        </x-core::table.body.cell>
                                        <x-core::table.body.cell class="money">
                                            <strong>
                                                {{ format_price($invoiceItem->amount) }}
                                            </strong>
                                        </x-core::table.body.cell>
                                    </x-core::table.body.row>
                                @endforeach
                            </x-core::table.body>

                            <x-core::table.footer>
                                <x-core::table.body.row>
                                    <x-core::table.body.cell colspan="4"></x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ trans('plugins/events-booking::invoice.detail.quantity') }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell class="fw-bold">
                                        {{ number_format($invoice->items->sum('qty')) }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                                <x-core::table.body.row>
                                    <x-core::table.body.cell colspan="4"></x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ trans('plugins/events-booking::invoice.detail.sub_total') }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell class="fw-bold">
                                        {{ format_price($invoice->sub_total) }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                                <x-core::table.body.row>
                                    <x-core::table.body.cell colspan="4"></x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ trans('plugins/events-booking::invoice.detail.tax') }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell class="fw-bold">
                                        {{ format_price($invoice->tax_amount) }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                                <x-core::table.body.row>
                                    <x-core::table.body.cell colspan="4"></x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ trans('plugins/events-booking::invoice.detail.discount') }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell class="fw-bold">
                                        {{ format_price($invoice->discount_amount) }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                                <x-core::table.body.row>
                                    <x-core::table.body.cell colspan="4"></x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ trans('plugins/events-booking::invoice.total_amount') }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell class="fw-bold">
                                        <h3 class="mt-0 mb-0 text-danger">{{ format_price($invoice->amount) }}</h3>
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                            </x-core::table.footer>
                        </x-core::table>
                    </div>

                    <div class="mt-3">
                        @if ($invoice->reference && $invoice->reference->id)
                            <x-core::form.label>
                                <small>
                                    {{ trans('plugins/events-booking::invoice.detail.invoice_for') }}:
                                    <a href="{{ route('events-booking.orders.edit', $invoice->reference->id) }}" target="_blank">
                                        {{ $invoice->reference->code }}
                                        <x-core::icon name="ti ti-external-link" />
                                    </a>
                                </small>
                            </x-core::form.label>
                        @endif

                        <p class="font-sm">
                            @if ($invoice->company_name)
                                <strong>{{ trans('plugins/events-booking::invoice.detail.invoice_to') }}:</strong>
                                {{ $invoice->company_name }}<br>
                            @endif

                            {!! apply_filters('events-booking_admin_invoice_extra_info', null, $invoice->reference) !!}
                        </p>
                    </div>
                </div>
            </x-core::card.body>
        </x-core::card>
    </div>
@endsection
