@php
    $route ??= 'account.invoices.generate-invoice';
    $event = $order->event;
    $tickets = $order->tickets;
@endphp

<div class="container">
    <div class="container mt-5">
        <div class="card p-4 shadow-sm">
            <h2>{{ __('Your booking information') }}</h2>
            <div class="row mb-4">
                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Time') }}</strong></p>
                    <p>{{ $order->created_at }}</p>
                </div>
                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Full Name') }}</strong></p>
                    <p>{{ $order->account_name }}</p>
                </div>

                @if ($email = $order->account_email)
                    <div class="col-md-3">
                        <p class="mb-1"><strong>{{ __('Email') }}</strong></p>
                        <p>{{ $email }}</p>
                    </div>
                @endif

                @if ($event)
                    <div class="col-md-3">
                        <p class="mb-1"><strong>{{ __('Event') }}</strong></p>
                        <p>{{ $event->name }}</p>
                    </div>
                @endif

                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Start Date') }}</strong></p>
                    <p>{{ $event->started_at }}</p>
                </div>

                @if($endedAt = $event->ended_at)
                    <div class="col-md-3">
                        <p class="mb-1"><strong>{{ __('End Date') }}</strong></p>
                        <p>{{ $endedAt }}</p>
                    </div>
                @endif

                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Order Status') }}</strong></p>
                    <p>{!! $order->status->toHtml() !!}</p>
                </div>
            </div>

            @if($tickets)
                <div class="row mb-4">
                    <h4>{{ __('Tickets') }}</h4>
                    <x-core::table>
                        <x-core::table.header>
                            <x-core::table.header.cell>
                                {{ __('Code') }}
                            </x-core::table.header.cell>
                            <x-core::table.header.cell>
                                {{ __('Name') }}
                            </x-core::table.header.cell>
                            <x-core::table.header.cell>
                                {{ __('Email') }}
                            </x-core::table.header.cell>
                            <x-core::table.header.cell>
                                {{ __('Phone') }}
                            </x-core::table.header.cell>
                        </x-core::table.header>
                        <x-core::table.body>
                            @foreach($tickets as $ticket)
                                <x-core::table.body.row>
                                    <x-core::table.body.cell>
                                        {{ $ticket->code }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ $ticket->name }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ $ticket->email }}
                                    </x-core::table.body.cell>
                                    <x-core::table.body.cell>
                                        {{ $ticket->phone }}
                                    </x-core::table.body.cell>
                                </x-core::table.body.row>
                            @endforeach
                        </x-core::table.body>
                    </x-core::table>
                </div>
            @endif

            <div class="row">
                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Sub total') }}</strong></p>
                    <p>{{ format_price($order->subtotal) }}</p>
                </div>

                <div class="col-md-3">
                    <p class="mb-1"><strong>{{ __('Total') }}</strong></p>
                    <p>{{ format_price($order->total) }}</p>
                </div>

                @if (is_plugin_active('payment') && $order->payment->id)
                    @auth
                        <div class="col-md-3">
                            <p class="mb-1"><strong>{{ __('Payment ID') }}</strong></p>
                            <a href="{{ route('payment.show', $order->payment->id) }}" target="_blank">
                                {{ $order->payment->charge_id }}
                                <i class="fas fa-external-link-alt"></i>
                            </a>
                        </div>
                    @endauth

                    <div class="col-md-3">
                        <p class="mb-1"><strong>{{ __('Payment method') }}</strong></p>
                        <p>{{ $order->payment->payment_channel->label() }}</p>
                    </div>

                    <div class="col-md-3">
                        <p class="mb-1"><strong>{{ __('Payment status') }}</strong></p>
                        <p>{!! $order->payment->status->toHtml() !!}</p>
                    </div>


                    @if ($order->payment->payment_channel == \Botble\Payment\Enums\PaymentMethodEnum::BANK_TRANSFER
                        && $order->payment->status == \Botble\Payment\Enums\PaymentStatusEnum::PENDING
                    )
                        <div class="col-md-3">
                            <p class="mb-1"><strong>{{ __('Payment info') }}</strong></p>
                            <p>{!! BaseHelper::clean(get_payment_setting('description', $order->payment->payment_channel)) !!}</p>
                        </div>
                    @endif
                @endif
            </div>

            @if ((auth()->check() || $order->account_id) && ($invoiceId = $order->invoice->id) && $route)
                @php
                    $buttonClass = 'btn btn-primary';
                @endphp
                <div class="btn-list mt-5">
                    <x-core::button
                            tag="a"
                            :href="route($route, ['invoice' => $invoiceId, 'type' => 'print'])"
                            target="_blank"
                            icon="ti ti-printer"
                            :class="$buttonClass ?? ''"
                    >
                        {{ __('view Invoice') }}
                    </x-core::button>
                    <x-core::button
                            tag="a"
                            :href="route($route, ['invoice' => $invoiceId, 'type' => 'download'])"
                            target="_blank"
                            icon="ti ti-download"
                            :class="$buttonClass ?? ''"
                    >
                        {{ __('Download Invoice') }}
                    </x-core::button>
                </div>
            @endif
        </div>
    </div>
</div>