@if (is_plugin_active('payment'))
    <link rel="stylesheet" href="{{ asset('vendor/core/plugins/payment/css/payment.css') }}?v=1.0.3">
    @php
        Theme::asset()->container('header')->usePath()->add('jquery', 'libraries/jquery.min.js');
        Theme::asset()->container('header')->add('payment-js', 'vendor/core/plugins/payment/js/payment.js');
    @endphp

    {!! apply_filters(PAYMENT_FILTER_HEADER_ASSETS, null) !!}
@endif
@php
    Theme::set('pageTitle', __('Booking'));
    $account = auth('account')->user();
@endphp

<div class="container mt-5">
    <div class="row">
        <div class="col-md-8">
            <div class="card shadow-sm p-4">
                <h2>{{ __('Your Information') }}</h2>
                <form action="{{ route('public.booking.checkout') }}" class="payment-checkout-form" method="POST">
                    @csrf

                    <input type="hidden" name="token" value="{{ $token }}">
                    <input type="hidden" name="amount" value="{{ $total }}">
                    <input type="hidden" name="event_id" value="{{ $event->getKey() }}">
                    <input type="hidden" name="number_slots" value="{{ $numberSlots }}">
                    <input type="hidden" name="currency" value="{{ strtoupper(get_application_currency()->title) }}">
                    <input type="hidden" name="currency_id" value="{{ get_application_currency_id() }}">

                    <div class="row">
                        <div class="mb-3 col-lg-12">
                            <label for="name" class="form-label required">{{ __('Name') }} *</label>
                            <input type="text" name="name" value="{{ old('name', $account) }}" class="form-control" id="name" placeholder="{{ __('Enter name') }}">
                        </div>
                        <div class="mb-3 col-lg-6">
                            <label for="email" class="form-label">{{ __('Email') }} *</label>
                            <input type="email" value="{{ old('email', $account) }}" name="email" class="form-control" id="email" placeholder="{{ __('Enter email') }}">
                        </div>
                        <div class="mb-3 col-lg-6">
                            <label for="phone" class="form-label">{{ __('Phone') }}</label>
                            <input type="text" name="phone" value="{{ old('phone', $account) }}" class="form-control" id="phone" placeholder="{{ __('Enter phone') }}">
                        </div>
                        <div class="mb-3">
                            <label for="note" class="form-label">{{ __('Note') }}</label>
                            <textarea class="form-control" name="note" id="note" rows="3" placeholder="{{ __('Write Something...') }}"></textarea>
                        </div>

                        @if(! $account || ! $account->getKey())
                            <div class="create-account mb-3">
                                <div class="row mb-3">
                                    <div class="form-group mb-20 custom-checkbox d-block">
                                        <label for="register-account" class="w-100">
                                            <input type="checkbox" id="register-account" name="register_account" value="1" > {{ __('Register an account with above information?') }}
                                            <span></span>
                                        </label>
                                    </div>
                                </div>
                                <div class="row mb-3 d-none form-create-account-password">
                                    <div class="col-md-6">
                                        <div class="form-group mb-20">
                                            <label for="password">{{ __('Password') }}</label>
                                            <input type="password" name="password" id="password" class="form-control">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group mb-20">
                                            <label for="password_confirm">{{ __('Password confirm') }}</label>
                                            <input type="password" name="password_confirm" id="password_confirm" class="form-control">
                                        </div>
                                    </div>
                                </div>
                            </div>
                        @endif

                        @include('plugins/events-booking::themes.includes.tickets-form', ['quantity' => $numberSlots])

                        <div class="col-lg-12">
                            @if (is_plugin_active('payment') && ($defaultPaymentMethod = PaymentMethods::getDefaultMethod()) && get_payment_setting('status', $defaultPaymentMethod))
                                <div class="form-group mb-3">
                                    <label class="form-label" for="requests">{{ __('Payment method') }}</label>
                                    <ul class="list-group list_payment_method">
                                        {!! apply_filters(PAYMENT_FILTER_ADDITIONAL_PAYMENT_METHODS, null, [
                                            'amount' => $total,
                                            'currency' => strtoupper(get_application_currency()->title),
                                            'name' => $event->name,
                                            'selected' => PaymentMethods::getSelectedMethod(),
                                            'default' => $defaultPaymentMethod,
                                            'selecting' => PaymentMethods::getSelectingMethod(),
                                        ]) !!}

                                        {!! PaymentMethods::render() !!}
                                    </ul>
                                </div>
                            @endif

                            {!! apply_filters('form_extra_fields_render', null) !!}

                            <div class="form-group mb-3 custom-checkbox d-block">
                                <label for="terms_conditions" class="form-label w-100">
                                    <input type="checkbox" id="terms_conditions" name="terms_conditions" value="1" @if (old('terms_conditions') == 1) checked @endif> {{ __('Terms & conditions *') }}
                                    <span></span>
                                </label>
                            </div>
                            <div class="form-group mb-0">
                                <button type="submit" class="btn btn-primary payment-checkout-btn" data-processing-text="{{ __('Processing. Please wait...') }}" data-error-header="{{ __('Error') }}">{{ __('Checkout') }}</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <div class="col-md-4">
            <div class="card shadow-sm">
                {{ RvMedia::image($event->image, $event->name, attributes: ['class' => 'mw-100 card-img-top']) }}
                <div class="card-body">
                    <h5 class="card-title">{{ $event->name }}</h5>
                    <p class="card-text">
                        {{ __('Start date:') }} <strong> {{ $event->started_at->format('D, M d, Y') }} </strong><br>
                        @if ($endedAt = $event->ended_at)
                            {{ __('End date:') }} <strong> {{ $endedAt->format('D, M d, Y') }} </strong><br>
                        @endif
                        {{ __('Number of slots:') }} <strong> {{ $numberSlots }} </strong><br>
                        {{ __('Price:') }} <strong> {{ render_price($event->price * $numberSlots) }}</strong><br>
                        {{ __('Discount:') }} <strong>{{ format_price($couponAmount) }}</strong><br>
                    </p>
                    <h5 class="card-text"><strong>{{ __('Total:') }}</strong> {{ format_price($total) }}</h5>
                </div>
            </div>
        </div>
    </div>
</div>

<script src="{{ asset('vendor/core/plugins/events-booking/js/checkout.js') }}">

</script>

@if (is_plugin_active('payment'))
    {!! apply_filters(PAYMENT_FILTER_FOOTER_ASSETS, null) !!}

    @php
        Theme::asset()->container('footer')
        ->add('js-validation', 'vendor/core/core/js-validation/js/js-validation.js', ['jquery'])
        ->writeContent('checkout-validator', JsValidator::formRequest(ArchiElite\EventsBooking\Http\Requests\CheckoutRequest::class))
    @endphp
@endif